% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selections.R
\name{has_role}
\alias{has_role}
\alias{all_predictors}
\alias{all_outcomes}
\alias{has_type}
\alias{all_numeric}
\alias{all_nominal}
\alias{current_info}
\title{Role Selection}
\usage{
has_role(match = "predictor", roles = current_info()$roles)

all_predictors(roles = current_info()$roles)

all_outcomes(roles = current_info()$roles)

has_type(match = "numeric", types = current_info()$types)

all_numeric(types = current_info()$types)

all_nominal(types = current_info()$types)

current_info()
}
\arguments{
\item{match}{A single character string for the query. Exact matching is
used (i.e. regular expressions won't work).}

\item{roles}{A character string of roles for the current set of terms.}

\item{types}{A character string of roles for the current set of data types}
}
\value{
Selector functions return an integer vector while
  \code{current_info} returns an environment with vectors \code{vars},
  \code{roles}, and \code{types}.
}
\description{
\code{has_role}, \code{all_predictors}, and \code{all_outcomes} can be used
  to select variables in a formula that have certain roles. Similarly,
  \code{has_type}, \code{all_numeric}, and \code{all_nominal} are used to
  select columns based on their data type. See \code{\link{selections}} for
  more details. \code{current_info} is an internal function that is
  unlikely to help users while the others have limited utility outside of
  step function arguments.
}
\examples{
data(biomass)

rec <- recipe(biomass) \%>\%
  add_role(carbon, hydrogen, oxygen, nitrogen, sulfur,
           new_role = "predictor") \%>\%
  add_role(HHV, new_role = "outcome") \%>\%
  add_role(sample, new_role = "id variable") \%>\%
  add_role(dataset, new_role = "splitting indicator")
recipe_info <- summary(rec)
recipe_info

has_role("id variable", roles = recipe_info$role)
all_outcomes(roles = recipe_info$role)
}
\keyword{datagen}
