% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{read_lines}
\alias{read_lines}
\alias{read_lines_raw}
\alias{write_lines}
\title{Read/write lines to/from a file}
\usage{
read_lines(file, skip = 0, n_max = -1L, locale = default_locale(),
  na = character(), progress = show_progress())

read_lines_raw(file, skip = 0, n_max = -1L, progress = show_progress())

write_lines(x, path, na = "NA", append = FALSE)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \code{http://},
\code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path).}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Number of lines to read. If \code{n_max} is -1, all lines in
file will be read.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to use for missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}

\item{x}{A data frame to write to disk}

\item{path}{Path or connection to write to.}

\item{append}{If \code{FALSE}, will overwrite existing file. If \code{TRUE},
will append to existing file. In both cases, if file does not exist a new
file is created.}
}
\value{
\code{read_lines()}: A character vector with one element for each line.
\code{read_lines_raw()}: A list containing a raw vector for each line.

\code{write_lines()} returns \code{x}, invisibly.
}
\description{
\code{read_lines()} reads up to \code{n_max} lines from a file. New lines are
not included in the output. \code{read_lines_raw()} produces a list of raw
vectors, and is useful for handling data with unknown encoding.
\code{write_lines()} takes a character vector or list of raw vectors, appending a
new line after each entry.
}
\examples{
read_lines(file.path(R.home("doc"), "AUTHORS"), n_max = 10)
read_lines_raw(file.path(R.home("doc"), "AUTHORS"), n_max = 10)

tmp <- tempfile()

write_lines(rownames(mtcars), tmp)
read_lines(tmp)
read_file(tmp) # note trailing \\n

write_lines(airquality$Ozone, tmp, na = "-1")
read_lines(tmp)
}
