/*
 * Decompiled with CFR 0.152.
 */
package analysis.results;

import analysis.results.MinimalResult;
import data.Point;
import data.VarPairData;
import java.io.IOException;
import mine.core.MineParameters;

public class BriefResult
extends MinimalResult {
    protected float nonlinearity = Float.NaN;
    protected float MAS = Float.NaN;
    protected float MEV = Float.NaN;
    protected float MCN = Float.NaN;
    protected float pearson = Float.NaN;

    @Override
    public void construct(VarPairData xy, MineParameters p) {
        super.construct(xy, p);
        Point MICfoundat = new Point(1.0f, 1.0f);
        this.MIC = this.m.MIC(MICfoundat);
        this.MAS = this.m.MAS();
        this.MEV = this.m.maxValueWithTwoRowsOrColumns();
        this.MCN = (float)(Math.log(MICfoundat.x * MICfoundat.y) / Math.log(2.0));
        this.pearson = xy.pearsonCorrelation();
        this.nonlinearity = this.MIC - this.pearson * this.pearson;
        if (p.debug > 1) {
            try {
                p.debugOut.write("MIC (=" + this.getMIC() + ")\n");
                p.debugOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getHeader() {
        return String.valueOf(super.getHeader()) + ",MIC-p^2 (nonlinearity),MAS (non-monotonicity)" + ",MEV (functionality),MCN (complexity),Linear regression (p)";
    }

    @Override
    public String toString() {
        String result = "," + this.nonlinearity + "," + this.MAS + "," + this.MEV + "," + this.MCN + "," + this.pearson;
        result = result.replace(Float.toString(Float.NaN), "");
        result = result.replace(Integer.toString(Integer.MIN_VALUE), "");
        result = result.replace(Integer.toString(Integer.MAX_VALUE), "ERROR");
        return String.valueOf(super.toString()) + result;
    }

    public float getPearson() {
        return this.pearson;
    }

    public float getMAS() {
        return this.MAS;
    }

    public float getMEV() {
        return this.MEV;
    }

    public float getMCN() {
        return this.MCN;
    }
}

