% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.R
\name{with.mids}
\alias{with.mids}
\alias{with}
\title{Evaluate an expression in multiple imputed datasets}
\usage{
\method{with}{mids}(data, expr, ...)
}
\arguments{
\item{data}{An object of type \code{mids}, which stands for 'multiply imputed
data set', typically created by a call to function \code{mice()}.}

\item{expr}{An expression to evaluate for each imputed data set. Formula's
containing a dot (notation for "all other variables") do not work.}

\item{\dots}{Not used}
}
\value{
An object of S3 class \code{\link{mira}}
}
\description{
Performs a computation of each of imputed datasets in data.
}
\note{
Version 3.11.10 changed to tidy evaluation on a quosure. This change
should not affect any code that worked on previous versions.
It turned out that the latter statement was not true (#292).
Version 3.12.2 reverts to the old \code{with()} function.
}
\examples{
imp <- mice(nhanes2, m = 2, print = FALSE, seed = 14221)

# descriptive statistics
getfit(with(imp, table(hyp, age)))

# model fitting and testing
fit1 <- with(imp, lm(bmi ~ age + hyp + chl))
fit2 <- with(imp, glm(hyp ~ age + chl, family = binomial))
fit3 <- with(imp, anova(lm(bmi ~ age + chl)))
}
\references{
van Buuren S and Groothuis-Oudshoorn K (2011). \code{mice}:
Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
Statistical Software}, \bold{45}(3), 1-67.
\doi{10.18637/jss.v045.i03}
}
\seealso{
\code{\link{mids}}, \code{\link{mira}}, \code{\link{pool}},
\code{\link{D1}}, \code{\link{D3}}, \code{\link{pool.r.squared}}
}
\author{
Karin Oudshoorn, Stef van Buuren 2009, 2012, 2020
}
\keyword{multivariate}
