% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_Al2O3C_CrossTalk.R
\name{analyse_Al2O3C_CrossTalk}
\alias{analyse_Al2O3C_CrossTalk}
\title{Al2O3:C Reader Cross Talk Analysis}
\usage{
analyse_Al2O3C_CrossTalk(
  object,
  signal_integral = NULL,
  dose_points = c(0, 4),
  recordType = c("OSL (UVVIS)"),
  irradiation_time_correction = NULL,
  method_control = NULL,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} or \link{list} (\strong{required}):
measurement input}

\item{signal_integral}{\link{numeric} (\emph{optional}):
signal integral, used for the signal and the background.
If nothing is provided the full range is used}

\item{dose_points}{\link{numeric} (\emph{with default}):
vector with dose points, if dose points are repeated, only the general
pattern needs to be provided. Default values follow the suggestions
made by Kreutzer et al., 2018}

\item{recordType}{\link{character} (\emph{with default}): input curve selection, which is passed to
function \link{get_RLum}. To deactivate the automatic selection set the argument to \code{NULL}}

\item{irradiation_time_correction}{\link{numeric} or \linkS4class{RLum.Results} (\emph{optional}):
information on the used irradiation time correction obtained by another
experiment.}

\item{method_control}{\link{list} (\emph{optional}):
optional parameters to control the calculation.
See details for further explanations}

\item{plot}{\link{logical} (\emph{with default}):
enable/disable the plot output.}

\item{...}{further arguments that can be passed to the plot output}
}
\value{
Function returns results numerically and graphically:

-----------------------------------\cr
\verb{[ NUMERICAL OUTPUT ]}\cr
-----------------------------------\cr

\strong{\code{RLum.Results}}-object

\strong{slot:} \strong{\verb{@data}}

\tabular{lll}{
\strong{Element} \tab \strong{Type} \tab \strong{Description}\cr
\verb{$data} \tab \code{data.frame} \tab summed apparent dose table \cr
\verb{$data_full} \tab \code{data.frame} \tab full apparent dose table \cr
\verb{$fit} \tab \code{lm} \tab the linear model obtained from fitting \cr
\verb{$col.seq} \tab \code{numeric} \tab the used colour vector \cr
}

\strong{slot:} \strong{\verb{@info}}

The original function call

------------------------\cr
\verb{[ PLOT OUTPUT ]}\cr
------------------------\cr
\itemize{
\item An overview of the obtained apparent dose values
}
}
\description{
The function provides the analysis of cross-talk measurements on a
FI lexsyg SMART reader using Al2O3:C chips
}
\section{Function version}{
 0.1.3
}

\examples{

##load data
data(ExampleData.Al2O3C, envir = environment())

##run analysis
analyse_Al2O3C_CrossTalk(data_CrossTalk)

} 

\section{How to cite}{
Kreutzer, S., 2025. analyse_Al2O3C_CrossTalk(): Al2O3:C Reader Cross Talk Analysis. Function version 0.1.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.0.1. https://r-lum.github.io/Luminescence/
}

\references{
Kreutzer, S., Martin, L., Guérin, G., Tribolo, C., Selva, P., Mercier, N., 2018. Environmental Dose Rate
Determination Using a Passive Dosimeter: Techniques and Workflow for alpha-Al2O3:C Chips.
Geochronometria 45, 56-67. doi: 10.1515/geochr-2015-0086
}
\seealso{
\link{analyse_Al2O3C_ITC}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{datagen}
