% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-modelsearch2.R
\name{autplot-modelsearch2}
\alias{autplot-modelsearch2}
\alias{autoplot.modelsearch2}
\title{Display the Value of a Coefficient across the Steps.}
\usage{
\method{autoplot}{modelsearch2}(object, param, ci = TRUE,
  step = 0:nStep(object), conf.level = 0.95, plot = TRUE,
  add.0 = TRUE, ...)
}
\arguments{
\item{object}{a \code{modelsearch2} object.}

\item{param}{[character vector] the name of the coefficient(s) to be displayed.}

\item{ci}{[logical] should the confidence intervals of the coefficient(s) be displayed.}

\item{step}{[integer >0] the steps at which the coefficient value should be displayed.}

\item{conf.level}{[numeric, 0-1] confidence level of the interval.}

\item{plot}{[logical] should the graph be displayed?}

\item{add.0}{[logical] should an horizontal line representing no effect be displayed?}

\item{...}{[internal] only used by the generic method.}
}
\value{
A list containing \itemize{
\item \code{plot}: a ggplot object.
\item \code{data}: the data used to generate the ggplot object.
}
}
\description{
Display the value of a coefficient across the steps.
}
\examples{
\dontrun{
mSim <- lvm(Y~G+X1+X2+X3+X4+X5)
addvar(mSim) <- ~Z1+Z2

set.seed(10)
df.data <- lava::sim(mSim, 1e2)

mBase <- lvm(Y~G)
addvar(mBase) <- ~X1+X2+X3+X4+X5+Z1+Z2
e.lvm <- estimate(mBase, data = df.data)
res <- modelsearch2(e.lvm, method.p.adjust = "holm", alpha = 0.05)
autoplot(res, param = "Y~G")
autoplot(res, param = c("Y","Y~G"))
}
}
\concept{extractor}
\concept{modelsearch}
