% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflog.r
\docType{methods}
\name{reflog}
\alias{reflog}
\alias{reflog,git_repository,missing-method}
\alias{reflog,git_repository,character-method}
\title{List and view reflog information}
\usage{
reflog(repo, refname)

\S4method{reflog}{git_repository,missing}(repo)

\S4method{reflog}{git_repository,character}(repo, refname)
}
\arguments{
\item{repo}{S4 class git_repository \code{object}.}

\item{refname}{The name of the reference to list. 'HEAD' by
default.}
}
\value{
S3 class \code{git_reflog} with git_reflog_entry objects.
}
\description{
List and view reflog information
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Change file and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "Second commit message")

## Change file again and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad",
             "minim veniam, quis nostrud exercitation ullamco laboris nisi ut"),
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "Third commit message")

## View reflog
reflog(repo)
}
}
\keyword{methods}
