% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative-risk-regression.R
\name{relRisk}
\alias{relRisk}
\title{Fit a Relative Risk Model for Binary data with Log Link}
\usage{
relRisk(
  formula,
  id,
  waves = NULL,
  data = parent.frame(),
  subset = NULL,
  contrasts = NULL,
  na.action = na.omit,
  corstr = "indep",
  ncopy = 1000,
  control = geese.control(),
  b = NULL,
  alpha = NULL
)
}
\arguments{
\item{formula}{same as in \code{geese}}

\item{id}{same as in \code{geese}}

\item{waves}{same as in \code{geese}}

\item{data}{same as in \code{geese}}

\item{subset}{same as in \code{geese}}

\item{contrasts}{same as in \code{geese}}

\item{na.action}{same as in \code{geese}}

\item{corstr}{same as in \code{geese}}

\item{ncopy}{the number of copies of the original data in
constructing weight.}

\item{control}{same as in \code{geese}}

\item{b}{initial values for regression coefficients as in
\code{geese} but more difficult to obtain due to the log link.}

\item{alpha}{same as in \code{geese}}
}
\value{
An object of class \code{"geese"} representing the fit.
}
\description{
Fit a Relative Risk Model for Binary data with Log
Link using the COPY method.
}
\examples{

## this example was used in Yu and Yan (2010, techreport)
data(respiratory)
respiratory$treat <- relevel(respiratory$treat, ref = "P")
respiratory$sex <- relevel(respiratory$sex, ref = "M")
respiratory$center <- as.factor(respiratory$center)
## 1 will be the reference level

fit <- relRisk(outcome ~ treat + center + sex + age + baseline + visit,
               id = id, corstr = "ar1", data = respiratory, ncopy=10000)
summary(fit)
## fit <- relRisk(outcome ~ treat + center + sex + age + baseline + visit,
##               id = id, corstr = "ex", data = respiratory)
## summary(fit)
## fit <- relRisk(outcome ~ treat + center + sex + age + baseline + visit,
##                id = id, corstr = "indep", data = respiratory)
## summary(fit)

}
\references{
Lumley, T., Kornmal, R. and Ma, S. (2006). Relative
risk regression in medical research: models, contrasts,
estimators, and algorithms. UW Biostatistics Working Paper
Series 293, University of Washington.
}
\author{
Jun Yan \email{jyan.stat@gmail.com}
}
\keyword{models}
