% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgr.R
\name{state_at_end}
\alias{state_at_end}
\alias{close_state}
\title{Utilities for Managing CSI and OSC State  In Strings}
\usage{
state_at_end(
  x,
  warn = getOption("fansi.warn", TRUE),
  term.cap = getOption("fansi.term.cap", dflt_term_cap()),
  normalize = getOption("fansi.normalize", FALSE),
  carry = getOption("fansi.carry", FALSE)
)

close_state(
  x,
  warn = getOption("fansi.warn", TRUE),
  normalize = getOption("fansi.normalize", FALSE)
)
}
\arguments{
\item{x}{a character vector or object that can be coerced to such.}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \code{\link[=fansi]{?fansi}}).
At most one warning will be issued per element in each input vector.  Will
also warn about some badly encoded UTF-8 strings, but a lack of UTF-8
warnings is not a guarantee of correct encoding (use \code{\link{validUTF8}} for
that).}

\item{term.cap}{character a vector of the capabilities of the terminal, can
be any combination of "bright" (SGR codes 90-97, 100-107), "256" (SGR codes
starting with "38;5" or "48;5"), "truecolor" (SGR codes starting with
"38;2" or "48;2"), and "all". "all" behaves as it does for the \code{ctl}
parameter: "all" combined with any other value means all terminal
capabilities except that one.  \code{fansi} will warn if it encounters SGR codes
that exceed the terminal capabilities specified (see \code{\link{term_cap_test}}
for details).  In versions prior to 1.0, \code{fansi} would also skip exceeding
SGRs entirely instead of interpreting them.  You may add the string "old"
to any otherwise valid \code{term.cap} spec to restore the pre 1.0 behavior.
"old" will not interact with "all" the way other valid values for this
parameter do.}

\item{normalize}{TRUE or FALSE (default) whether SGR sequence should be
normalized out such that there is one distinct sequence for each SGR code.
normalized strings will occupy more space (e.g. "\033[31;42m" becomes
"\033[31m\033[42m"), but will work better with code that assumes each SGR
code will be in its own escape as \code{crayon} does.}

\item{carry}{TRUE, FALSE (default), or a scalar string, controls whether to
interpret the character vector as a "single document" (TRUE or string) or
as independent elements (FALSE).  In "single document" mode, active state
at the end of an input element is considered active at the beginning of the
next vector element, simulating what happens with a document with active
state at the end of a line.  If FALSE each vector element is interpreted as
if there were no active state when it begins.  If character, then the
active state at the end of the \code{carry} string is carried into the first
element of \code{x} (see "Replacement Functions" for differences there).  The
carried state is injected in the interstice between an imaginary zeroeth
character and the first character of a vector element.  See the "Position
Semantics" section of \code{\link{substr_ctl}} and the "State Interactions" section
of \code{\link[=fansi]{?fansi}} for details.  Except for \code{\link{strwrap_ctl}} where \code{NA} is
treated as the string \code{"NA"}, \code{carry} will cause \code{NA}s in inputs to
propagate through the remaining vector elements.}
}
\value{
character vector same length as \code{x}.
}
\description{
\code{state_at_end} reads through strings computing the accumulated SGR and
OSC hyperlinks, and outputs the active state at the end of them.
\code{close_state} produces the sequence that closes any SGR active and OSC
hyperlinks at the end of each input string.  If \code{normalize = FALSE}
(default), it will emit the reset code "ESC[0m" if any SGR is present.
It is more interesting for closing SGRs if \code{normalize = TRUE}.  Unlike
\code{state_at_end} and other functions \code{close_state} has no concept of \code{carry}:
it will only emit closing sequences for states explicitly active at the end
of a string.
}
\section{Control and Special Sequences}{


\emph{Control Sequences} are non-printing characters or sequences of characters.
\emph{Special Sequences} are a subset of the \emph{Control Sequences}, and include CSI
SGR sequences which can be used to change rendered appearance of text, and
OSC hyperlinks.  See \code{\link{fansi}} for details.
}

\section{Output Stability}{


Several factors could affect the exact output produced by \code{fansi}
functions across versions of \code{fansi}, \code{R}, and/or across systems.
\strong{In general it is best not to rely on exact \code{fansi} output, e.g. by
embedding it in tests}.

Width and grapheme calculations depend on locale, Unicode database
version, and grapheme processing logic (which is still in development), among
other things.  For the most part \code{fansi} (currently) uses the internals of
\code{base::nchar(type='width')}, but there are exceptions and this may change in
the future.

How a particular display format is encoded in \emph{Control Sequences} is
not guaranteed to be stable across \code{fansi} versions.  Additionally, which
\emph{Special Sequences} are re-encoded vs transcribed untouched may change.
In general we will strive to keep the rendered appearance stable.

To maximize the odds of getting stable output set \code{normalize_state} to
\code{TRUE} and \code{type} to \code{"chars"} in functions that allow it, and
set \code{term.cap} to a specific set of capabilities.
}

\examples{
x <- c("\033[44mhello", "\033[33mworld")
state_at_end(x)
state_at_end(x, carry=TRUE)
(close <- close_state(state_at_end(x, carry=TRUE), normalize=TRUE))
writeLines(paste0(x, close, " no style"))
}
\seealso{
\code{\link[=fansi]{?fansi}} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results,
\code{\link{unhandled_ctl}} for detecting bad control sequences.
}
