% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count-tally.R
\name{tally}
\alias{tally}
\alias{count}
\alias{add_tally}
\alias{add_count}
\title{Count/tally observations by group}
\usage{
tally(x, wt = NULL, sort = FALSE, name = "n")

count(x, ..., wt = NULL, sort = FALSE, name = "n",
  .drop = group_by_drop_default(x))

add_tally(x, wt, sort = FALSE, name = "n")

add_count(x, ..., wt = NULL, sort = FALSE, name = "n")
}
\arguments{
\item{x}{a \code{\link[=tbl]{tbl()}} to tally/count.}

\item{wt}{(Optional) If omitted (and no variable named \code{n} exists in the
data), will count the number of rows.
If specified, will perform a "weighted" tally by summing the
(non-missing) values of variable \code{wt}. A column named \code{n} (but not \code{nn} or
\code{nnn}) will be used as weighting variable by default in \code{tally()}, but not
in \code{count()}. This argument is automatically \link[rlang:quo]{quoted} and later
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. It supports \link[rlang:quasiquotation]{unquoting}. See
\code{vignette("programming")} for an introduction to these concepts.}

\item{sort}{if \code{TRUE} will sort output in descending order of \code{n}}

\item{name}{The output column name. If omitted, it will be \code{n}.}

\item{...}{Variables to group by.}

\item{.drop}{see \code{\link[=group_by]{group_by()}}}
}
\value{
A tbl, grouped the same way as \code{x}.
}
\description{
\code{tally()} is a convenient wrapper for summarise that will either call
\code{\link[=n]{n()}} or \code{\link{sum}(n)} depending on whether you're tallying
for the first time, or re-tallying. \code{count()} is similar but calls
\code{\link[=group_by]{group_by()}} before and \code{\link[=ungroup]{ungroup()}} after. If the data is already
grouped, \code{count()} adds an additional group that is removed afterwards.

\code{add_tally()} adds a column \code{n} to a table based on the number
of items within each existing group, while \code{add_count()} is a shortcut that
does the grouping as well. These functions are to \code{\link[=tally]{tally()}}
and \code{\link[=count]{count()}} as \code{\link[=mutate]{mutate()}} is to \code{\link[=summarise]{summarise()}}:
they add an additional column rather than collapsing each group.
}
\note{
The column name in the returned data is given by the \code{name} argument,
set to \code{"n"} by default.

If the data already has a column by that name, the output column
will be prefixed by an extra \code{"n"} as many times as necessary.
}
\examples{
# tally() is short-hand for summarise()
mtcars \%>\% tally()
mtcars \%>\% group_by(cyl) \%>\% tally()
# count() is a short-hand for group_by() + tally()
mtcars \%>\% count(cyl)
# Note that if the data is already grouped, count() adds
# an additional group that is removed afterwards
mtcars \%>\% group_by(gear) \%>\% count(carb)

# add_tally() is short-hand for mutate()
mtcars \%>\% add_tally()
# add_count() is a short-hand for group_by() + add_tally()
mtcars \%>\% add_count(cyl)

# count() and tally() are designed so that you can call
# them repeatedly, each time rolling up a level of detail
species <-
 starwars \%>\%
 count(species, homeworld, sort = TRUE)
species
species \%>\% count(species, sort = TRUE)

# Change the name of the newly created column:
species <-
 starwars \%>\%
 count(species, homeworld, sort = TRUE, name = "n_species_by_homeworld")
species
species \%>\%
 count(species, sort = TRUE, name = "n_species")

# add_count() is useful for groupwise filtering
# e.g.: show details for species that have a single member
starwars \%>\%
  add_count(species) \%>\%
  filter(n == 1)
}
