% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_outer.R
\name{fullmodel.ssq}
\alias{fullmodel.ssq}
\title{OLS Statistics for the Full Model Including All Potential Covariates}
\usage{
fullmodel.ssq(yX.data)
}
\arguments{
\item{yX.data}{a bma object (cf. \code{\link{bms}}) - alternatively a
\link{data.frame} or \link{matrix} whose first column is the dependent
variable}
}
\value{
Returns a list with some basic OLS statistics \item{R2}{The
R-squared of the full model} \item{ymy}{The sum of squares of residuals of
the full model} \item{ypy}{The explained sum of squares of the full model}
\item{yty}{The sum of squares of the (demeaned) dependent variable}
\item{Fstat}{The F-statistic of the full model}
}
\description{
A utility function for reference: Returns a list with R2 and sum of squares
for the OLS model encompassing all potential covariates that are included in
a bma object.
}
\note{
This function is just for quick comparison; for proper OLS estimation
consider \code{\link{lm}}
}
\examples{

data(datafls)
mm=bms(datafls)

fullmodel.ssq(mm)

#equivalent:
fullmodel.ssq(datafls)


}
\seealso{
\code{\link{bms}} for creating bma objects, \code{\link{lm}} for
OLS estimation

Check \url{http://bms.zeugner.eu} for additional help.
}
\keyword{utilities}
