% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix64.R
\name{matrix64}
\alias{matrix64}
\alias{colSums}
\alias{colSums.default}
\alias{colSums.integer64}
\alias{rowSums}
\alias{rowSums.default}
\alias{rowSums.integer64}
\alias{aperm.integer64}
\title{Working with integer64 arrays and matrices}
\usage{
colSums(x, na.rm = FALSE, dims = 1L)

\method{colSums}{default}(x, na.rm = FALSE, dims = 1L)

\method{colSums}{integer64}(x, na.rm = FALSE, dims = 1L)

rowSums(x, na.rm = FALSE, dims = 1L)

\method{rowSums}{default}(x, na.rm = FALSE, dims = 1L)

\method{rowSums}{integer64}(x, na.rm = FALSE, dims = 1L)

\method{aperm}{integer64}(a, perm, ...)
}
\arguments{
\item{x}{An array of integer64 numbers.}

\item{na.rm, dims}{Same interpretation as in \code{\link[=colSums]{colSums()}}.}

\item{a, perm}{Passed on to \code{\link[=aperm]{aperm()}}.}

\item{...}{Passed on to subsequent methods.}
}
\description{
These functions and methods facilitate working with integer64
objects stored in matrices. As ever, the primary motivation
for having tailor-made functions here is that R's methods
often receive input from bit64 and treat the vectors as doubles,
leading to unexpected and/or incorrect results.
}
\details{
As of now, the \code{colSums()} and \code{rowSums()} methods are implemented
as wrappers around equivalent \code{apply()} approaches, because
re-using the default routine (and then applying integer64 to the
result) does not work for objects with missing elements. Ideally
this would eventually get its own dedicated C routine mimicking
that of \code{colSums()} for integers; feature requests and PRs welcome.

\code{aperm()} is required for \code{apply()} to work, in general, otherwise
\code{FUN} gets applied to a class-stripped version of the input.
}
\examples{
A = as.integer64(1:6)
dim(A) = 3:2

colSums(A)
rowSums(A)
aperm(A, 2:1)
}
