% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spi.R
\name{spi}
\alias{spi}
\alias{spi.numeric}
\alias{spi.stanreg}
\alias{spi.brmsfit}
\title{Shortest Probability Interval (SPI)}
\usage{
spi(x, ...)

\method{spi}{numeric}(x, ci = 0.95, verbose = TRUE, ...)

\method{spi}{stanreg}(
  x,
  ci = 0.95,
  effects = c("fixed", "random", "all"),
  component = c("location", "all", "conditional", "smooth_terms", "sigma",
    "distributional", "auxiliary"),
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{spi}{brmsfit}(
  x,
  ci = 0.95,
  effects = c("fixed", "random", "all"),
  component = c("conditional", "zi", "zero_inflated", "all"),
  parameters = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{Vector representing a posterior distribution, or a data frame of such
vectors. Can also be a Bayesian model. \strong{bayestestR} supports a wide range
of models (see, for example, \code{methods("hdi")}) and not all of those are
documented in the 'Usage' section, because methods for other classes mostly
resemble the arguments of the \code{.numeric} or \code{.data.frame}methods.}

\item{...}{Currently not used.}

\item{ci}{Value or vector of probability of the (credible) interval - CI
(between 0 and 1) to be estimated. Default to \code{.95} (\verb{95\%}).}

\item{verbose}{Toggle off warnings.}

\item{effects}{Should results for fixed effects, random effects or both be
returned? Only applies to mixed models. May be abbreviated.}

\item{component}{Should results for all parameters, parameters for the
conditional model or the zero-inflated part of the model be returned? May
be abbreviated. Only applies to \pkg{brms}-models.}

\item{parameters}{Regular expression pattern that describes the parameters
that should be returned. Meta-parameters (like \code{lp__} or \code{prior_}) are
filtered by default, so only parameters that typically appear in the
\code{summary()} are returned. Use \code{parameters} to select specific parameters
for the output.}
}
\value{
A data frame with following columns:
\itemize{
\item \code{Parameter} The model parameter(s), if \code{x} is a model-object. If \code{x} is a vector, this column is missing.
\item \code{CI} The probability of the credible interval.
\item \code{CI_low}, \code{CI_high} The lower and upper credible interval limits for the parameters.
}
}
\description{
Compute the \strong{Shortest Probability Interval (SPI)} of posterior distributions.
The SPI is a more computationally stable HDI. The implementation is based on
the algorithm from the \strong{SPIn} package.
}
\details{
The SPI is an alternative method to the HDI (\code{\link[=hdi]{hdi()}}) to quantify
uncertainty of (posterior) distributions. The SPI is said to be more stable
than the HDI, because, the \emph{"HDI can be noisy (that is, have a high Monte Carlo error)"}
(Liu et al. 2015). Furthermore, the HDI is sensitive to additional assumptions,
in particular assumptions related to the different estimation methods, which
can make the HDI less accurate or reliable (see also discussion
\href{https://twitter.com/betanalpha/status/1479107186030624771}{here}).
}
\note{
The code to compute the SPI was adapted from the \strong{SPIn} package,
and slightly modified to be more robust for Stan models. Thus, credits go
to Ying Liu for the original SPI algorithm and R implementation.
}
\examples{
\dontshow{if (requireNamespace("quadprog", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(bayestestR)

posterior <- rnorm(1000)
spi(posterior)
spi(posterior, ci = c(0.80, 0.89, 0.95))

df <- data.frame(replicate(4, rnorm(100)))
spi(df)
spi(df, ci = c(0.80, 0.89, 0.95))
\dontrun{
library(rstanarm)
model <- stan_glm(mpg ~ wt + gear, data = mtcars, chains = 2, iter = 200, refresh = 0)
spi(model)
}
\dontshow{\}) # examplesIf}
}
\references{
Liu, Y., Gelman, A., & Zheng, T. (2015). Simulation-efficient shortest probability intervals. Statistics and Computing, 25(4), 809–819. https://doi.org/10.1007/s11222-015-9563-8
}
\seealso{
Other ci: 
\code{\link{bci}()},
\code{\link{ci}()},
\code{\link{cwi}()},
\code{\link{eti}()},
\code{\link{hdi}()},
\code{\link{si}()}
}
\concept{ci}
