% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPlatePosition.R
\name{plotPlatePosition}
\alias{plotPlatePosition}
\title{Plot cells in plate positions}
\usage{
plotPlatePosition(
  object,
  plate_position = NULL,
  colour_by = NULL,
  size_by = NULL,
  shape_by = NULL,
  by_exprs_values = "logcounts",
  add_legend = TRUE,
  theme_size = 24,
  point_alpha = 0.6,
  point_size = 24,
  other_fields = list(),
  swap_rownames = NULL
)
}
\arguments{
\item{object}{A SingleCellExperiment object.}

\item{plate_position}{A character vector specifying the plate position for each cell (e.g., A01, B12, and so on, where letter indicates row and number indicates column).
If \code{NULL}, the function will attempt to extract this from \code{object$plate_position}.
Alternatively, a list of two factors (\code{"row"} and \code{"column"}) can be supplied, specifying the row (capital letters) and column (integer) for each cell in \code{object}.}

\item{colour_by}{Specification of a column metadata field or a feature to colour by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{size_by}{Specification of a column metadata field or a feature to size by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{shape_by}{Specification of a column metadata field or a feature to shape by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{by_exprs_values}{A string or integer scalar specifying which assay to obtain expression values from, 
for use in point aesthetics - see the \code{exprs_values} argument in \code{?\link{retrieveCellInfo}}.}

\item{add_legend}{Logical scalar specifying whether a legend should be shown.}

\item{theme_size}{Numeric scalar, see \code{?"\link{scater-plot-args}"} for details.}

\item{point_alpha}{Numeric scalar specifying the transparency of the points, see \code{?"\link{scater-plot-args}"} for details.}

\item{point_size}{Numeric scalar specifying the size of the points, see \code{?"\link{scater-plot-args}"} for details.}

\item{other_fields}{Additional cell-based fields to include in the data.frame, see \code{?"\link{scater-plot-args}"} for details.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to 
identify features instead of \code{rownames(object)} when labelling plot 
elements.}
}
\value{
A ggplot object.
}
\description{
Plots cells in their position on a plate, coloured by metadata variables or feature expression values from a SingleCellExperiment object.
}
\details{
This function expects plate positions to be given in a charcter format where a letter indicates the row on the plate and a numeric value  indicates the column. 
Each cell has a plate position such as "A01", "B12", "K24" and so on. 
From these plate positions, the row is extracted as the letter, and the column as the numeric part. 
Alternatively, the row and column identities can be directly supplied by setting \code{plate_position} as a list of two factors.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)

## define plate positions
example_sce$plate_position <- paste0(
    rep(LETTERS[1:5], each = 8), 
    rep(formatC(1:8, width = 2, flag = "0"), 5)
)

## plot plate positions
plotPlatePosition(example_sce, colour_by = "Mutation_Status")

plotPlatePosition(example_sce, shape_by = "Treatment", 
    colour_by = "Gene_0004")

plotPlatePosition(example_sce, shape_by = "Treatment", size_by = "Gene_0001",
    colour_by = "Cell_Cycle")

}
\author{
Davis McCarthy, with modifications by Aaron Lun
}
