% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5create.R
\name{h5_createFile}
\alias{h5_createFile}
\alias{h5createFile}
\title{Create HDF5 file}
\usage{
h5createFile(file)
}
\arguments{
\item{file}{The filename of the HDF5 file.}
}
\value{
Returns (invisibly) \code{TRUE} is file was created successfully and \code{FALSE} otherwise.
}
\description{
R function to create an empty HDF5 file.
}
\details{
Creates an empty HDF5 file.
}
\examples{

h5createFile("ex_createFile.h5")

# create groups
h5createGroup("ex_createFile.h5","foo")
h5createGroup("ex_createFile.h5","foo/foobaa")

h5ls("ex_createFile.h5")

}
\seealso{
\code{\link[=h5createGroup]{h5createGroup()}}, \code{\link[=h5createDataset]{h5createDataset()}},
\code{\link[=h5read]{h5read()}}, \code{\link[=h5write]{h5write()}}, \link{rhdf5}
}
\author{
Bernd Fischer
}
