% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/503-readMolFromSDF.R
\name{readMolFromSDF}
\alias{readMolFromSDF}
\title{Read Molecules from SDF Files and Return Parsed Java Molecular Object}
\usage{
readMolFromSDF(sdffile)
}
\arguments{
\item{sdffile}{Character vector, containing SDF file location(s).}
}
\value{
A list, containing parsed Java molecular object.
}
\description{
Read Molecules from SDF Files and Return Parsed Java Molecular Object
}
\details{
This function reads molecules from SDF files and return
parsed Java molecular object needed by \code{extractDrug...} functions.
}
\examples{
sdf  = system.file('compseq/DB00859.sdf', package = 'Rcpi')
sdfs = c(system.file('compseq/DB00859.sdf', package = 'Rcpi'),
         system.file('compseq/DB00860.sdf', package = 'Rcpi'))
\donttest{
mol  = readMolFromSDF(sdf)
mols = readMolFromSDF(sdfs)}
}
\seealso{
See \code{\link{readMolFromSmi}} for reading molecules by SMILES
string and returning parsed Java molecular object.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{MOL}
\keyword{SDF}
\keyword{readMolFromSDF}
