## ----setup, include=FALSE-----------------------------------------------------
library(knitr)
opts_chunk$set(size="scriptsize")
mydata_dir <- file.path(tempdir(), "mydata")
if (!dir.exists(mydata_dir)) dir.create(mydata_dir)
options(width=80)
library(Matrix)
library(DelayedArray)
library(HDF5Array)
library(SummarizedExperiment)
library(airway)
library(lobstr)

## ----airway-------------------------------------------------------------------
library(airway)
data(airway)
m <- unname(assay(airway))
dim(m)
typeof(m)

## ----airway2------------------------------------------------------------------
head(m, n=4)
tail(m, n=4)
sum(m != 0) / length(m)

## ----obj_size-----------------------------------------------------------------
library(lobstr)  # for obj_size()
obj_size(m)

library(Matrix)
obj_size(as(m, "dgCMatrix"))

library(DelayedArray)
obj_size(as(m, "RleMatrix"))
obj_size(as(t(m), "RleMatrix"))

library(HDF5Array)
obj_size(as(m, "HDF5Matrix"))

## ----M------------------------------------------------------------------------
M <- as(m, "HDF5Matrix")
M

## ----M2-----------------------------------------------------------------------
M2 <- M[10:12, 1:5]
M2

## ----seed_of_M2---------------------------------------------------------------
seed(M2)

## -----------------------------------------------------------------------------
M3 <- t(M2)
M3

## -----------------------------------------------------------------------------
seed(M3)

## -----------------------------------------------------------------------------
M4 <- cbind(M3, M[1:5, 6:8])
M4

## ----eval=FALSE---------------------------------------------------------------
#  seed(M4)  # Error! (more than one seed)

## -----------------------------------------------------------------------------
M5 <- M == 0
M5

## -----------------------------------------------------------------------------
seed(M5)

## -----------------------------------------------------------------------------
M6 <- round(M[11:14, ] / M[1:4, ], digits=3)
M6

## ----eval=FALSE---------------------------------------------------------------
#  seed(M6)  # Error! (more than one seed)

## -----------------------------------------------------------------------------
M6a <- as(M6, "HDF5Array")
M6a

## -----------------------------------------------------------------------------
seed(M6a)

## -----------------------------------------------------------------------------
M6b <- as(M6, "RleArray")
M6b

## -----------------------------------------------------------------------------
seed(M6b)

## -----------------------------------------------------------------------------
hdf5_dumpfile <- file.path(mydata_dir, "M6c.h5")
setHDF5DumpFile(hdf5_dumpfile)
setHDF5DumpName("M6c")
M6c <- as(M6, "HDF5Array")

## -----------------------------------------------------------------------------
seed(M6c)
h5ls(hdf5_dumpfile)

## -----------------------------------------------------------------------------
showHDF5DumpLog()

## -----------------------------------------------------------------------------
DelayedArray:::set_verbose_block_processing(TRUE)
colSums(M)

## -----------------------------------------------------------------------------
getAutoBlockSize()
setAutoBlockSize(1e6)
colSums(M)

## ----cleanup, include=FALSE---------------------------------------------------
setHDF5DumpFile()
unlink(mydata_dir, recursive=TRUE, force=TRUE)

