/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.trove;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.trove.THash;
import com.squareup.haha.trove.TLongHashingStrategy;
import com.squareup.haha.trove.TLongObjectProcedure;
import com.squareup.haha.trove.TObjectHash;
import com.squareup.haha.trove.TObjectProcedure;

public final class TLongObjectHashMap<V>
extends THash
implements TLongHashingStrategy {
    private transient V[] _values;
    private transient long[] _set;
    protected final TLongHashingStrategy _hashingStrategy = this;

    @Override
    protected final int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        this._set = new long[capacity];
        return capacity;
    }

    @Override
    protected final int capacity() {
        return this._values.length;
    }

    public final V put(long key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = TLongObjectHashMap.unwrapNull(this._values[index]);
            isNewMapping = false;
        } else {
            wasFree = TLongObjectHashMap.isFree(this._values, index);
        }
        this._set[index] = key;
        V v = value;
        TObjectHash.NULL nULL = this._values[index] = v == null ? TObjectHash.NULL : v;
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected final void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        long[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new long[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(oldVals, i)) continue;
            long o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public final V get(long key) {
        int index = this.index(key);
        if (index < 0) {
            return null;
        }
        return TLongObjectHashMap.unwrapNull(this._values[index]);
    }

    private static <V> V unwrapNull(V value) {
        if (value == TObjectHash.NULL) {
            return null;
        }
        return value;
    }

    @Override
    public final void clear() {
        super.clear();
        long[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0L;
            values[i] = null;
        }
    }

    protected final int index(long val) {
        long[] set = this._set;
        Object[] values = this._values;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (!TLongObjectHashMap.isFree(values, index) && (TLongObjectHashMap.isRemoved(values, index) || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!TLongObjectHashMap.isFree(values, index) && (TLongObjectHashMap.isRemoved(values, index) || set[index] != val));
        }
        if (TLongObjectHashMap.isFree(values, index)) {
            return -1;
        }
        return index;
    }

    private int insertionIndex(long val) {
        int firstRemoved;
        Object[] values = this._values;
        long[] set = this._set;
        int length = this._set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (TLongObjectHashMap.isFree(values, index)) {
            return index;
        }
        if (TLongObjectHashMap.isFull(values, index) && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TLongObjectHashMap.isRemoved(values, index) ? index : -1;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if (firstRemoved != -1 || !TLongObjectHashMap.isRemoved(values, index)) continue;
            firstRemoved = index;
        } while (TLongObjectHashMap.isFull(values, index) && set[index] != val);
        if (TLongObjectHashMap.isRemoved(values, index)) {
            while (!TLongObjectHashMap.isFree(values, index) && (TLongObjectHashMap.isRemoved(values, index) || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
        }
        if (TLongObjectHashMap.isFull(values, index)) {
            return -index - 1;
        }
        if (firstRemoved == -1) {
            return index;
        }
        return firstRemoved;
    }

    private static boolean isFull(Object[] values, int index) {
        Object value = values[index];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values, int index) {
        return values[index] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values, int index) {
        return values[index] == null;
    }

    public final boolean equals(Object other) {
        if (!(other instanceof TLongObjectHashMap)) {
            return false;
        }
        TLongObjectHashMap that = (TLongObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public final int hashCode() {
        HashProcedure p = new HashProcedure(this);
        this.forEachEntry(p);
        HashProcedure hashProcedure = p;
        return hashProcedure.h;
    }

    @Override
    protected final void removeAt(int index) {
        this._values[index] = TObjectHash.REMOVED;
        super.removeAt(index);
    }

    public final Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] values = this._values;
        int i = this._values.length;
        int j = 0;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values, i)) continue;
            vals[j++] = TLongObjectHashMap.unwrapNull(values[i]);
        }
        return vals;
    }

    public final boolean forEachValue(TObjectProcedure<V> procedure) {
        Object[] values = this._values;
        int i = this._values.length;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values, i) || procedure.execute(TLongObjectHashMap.unwrapNull(values[i]))) continue;
            return false;
        }
        return true;
    }

    private boolean forEachEntry(TLongObjectProcedure<V> procedure) {
        long[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values, i) || procedure.execute(keys[i], TLongObjectHashMap.unwrapNull(values[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int computeHashCode(long val) {
        long l = val;
        return (int)(l ^ l >> 32);
    }

    static final class EqProcedure<V>
    implements TLongObjectProcedure<V> {
        private final TLongObjectHashMap<V> _otherMap;

        EqProcedure(TLongObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(long key, V value) {
            V v;
            V v2;
            int index = this._otherMap.index(key);
            return index >= 0 && ((v2 = value) == (v = this._otherMap.get(key)) || v2 != null && v2.equals(v));
        }
    }

    final class HashProcedure
    implements TLongObjectProcedure<V> {
        int h;
        private /* synthetic */ TLongObjectHashMap this$0;

        HashProcedure(TLongObjectHashMap tLongObjectHashMap) {
            this.this$0 = tLongObjectHashMap;
        }

        @Override
        public final boolean execute(long key, V value) {
            this.h += this.this$0._hashingStrategy.computeHashCode(key) ^ Ascii.hash(value);
            return true;
        }
    }
}

