/***************************************************************************
 *   Copyright (C) 2005 by Johan Maes   *
 *   on4qz@telenet.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/
#include "moderobot1.h"

modeRobot1::modeRobot1(esstvMode m,unsigned int len, bool tx):modeBase(m,len,tx)
{
}


modeRobot1::~modeRobot1()
{
}

void modeRobot1::setupParams(double clock)
{
  visibleLineLength=(lineLength(mode,clock)-fp-bp-blank-syncDuration)/3.;
}

modeBase::embState modeRobot1::rxSetupLine()
{
  start=lineTimeTableRX[lineCounter];
  switch(subLine)
		{
			case 0:
				calcPixelPositionTable(YLINEODD,FALSE);
				pixelArrayPtr=yArrayPtr;
				return MBPIXELS;
			case 1:
				debugState=stG1;
				marker=(unsigned int)round(start+blank+2*visibleLineLength);
				return MBRXWAIT;
			case 2:
				calcPixelPositionTable(REDLINE,FALSE);
				pixelArrayPtr=redArrayPtr;
				return MBPIXELS;
			case 3:
				debugState=stFP;
				marker=(unsigned int)round(start+blank+3*visibleLineLength+fp);
				return MBRXWAIT;
			case 4:
				debugState=stSync;
        syncPosition=(unsigned int)round(lineTimeTableRX[lineCounter+1]-bp);
				return MBSYNC;
			case 5:
				debugState=stBP;
        marker=(unsigned int)round(lineTimeTableRX[lineCounter]);
				lineCounter++;
				return MBRXWAIT;		
			case 6:
				calcPixelPositionTable(YLINEEVEN,FALSE);
				pixelArrayPtr=greenArrayPtr;
				return MBPIXELS;
			case 7:
				debugState=stG1;
        marker=(unsigned int)round(lineTimeTableRX[lineCounter]+blank+2*visibleLineLength);
				return MBRXWAIT;						
			case 8:
				calcPixelPositionTable(BLUELINE,FALSE);
				pixelArrayPtr=blueArrayPtr;
				return MBPIXELS;
			case 9:
				debugState=stFP;
				marker=(unsigned int)round(start+blank+3*visibleLineLength+fp);
				return MBRXWAIT;				
			case 10:
				debugState=stSync;
        syncPosition=(unsigned int)round(lineTimeTableRX[lineCounter+1]-bp);
				return MBSYNC;
			case 11:
				debugState=stBP;
        marker=(unsigned int)round(lineTimeTableRX[lineCounter+1]);
				return MBRXWAIT;		
			default:
				return MBENDOFLINE;
		}
}

void modeRobot1::showLine()
{
	yuvConversion(yArrayPtr);
	yuvConversion(greenArrayPtr);
}




void modeRobot1::calcPixelPositionTable(unsigned int colorLine,bool tx)
{
	unsigned int i;
	int ofx=0;
	if(tx) ofx=1;
  double start;
  if(tx) start=lineTimeTableTX[lineCounter];
  else start=lineTimeTableRX[lineCounter];
	debugState=colorLine;
	switch (colorLine)
		{
			case YLINEODD:
			case YLINEEVEN:
				start+=bp;
        for(i=0;i<activeSSTVParam->numberOfPixels;i++)
					{
            pixelPositionTable[i]=(unsigned int)round(start+(((float)(i+ofx)*visibleLineLength*2)/activeSSTVParam->numberOfPixels));
					}
			break;
			case REDLINE:
				start+=bp+blank+visibleLineLength*2;
        for(i=0;i<activeSSTVParam->numberOfPixels;i++)
					{
						pixelPositionTable[i]=
            (unsigned int)round(start+(((float)(i+ofx)*visibleLineLength)/activeSSTVParam->numberOfPixels));
					}
			break;
			case BLUELINE:
				start+=bp+blank+visibleLineLength*2;
        for(i=0;i<activeSSTVParam->numberOfPixels;i++)
					{
						pixelPositionTable[i]=
            (unsigned int)round(start+(((float)(i+ofx)*visibleLineLength)/activeSSTVParam->numberOfPixels));
					}
			break;
		}
}

/**
	\todo resync odd/even line via frequency detection
*/

modeBase::embState modeRobot1::txSetupLine()
{
  start=lineTimeTableTX[lineCounter];
  switch(subLine)
		{
			case 0:
				calcPixelPositionTable(YLINEODD,TRUE);
				pixelArrayPtr=yArrayPtr;
				return MBPIXELS;
			case 1:
				txFreq=1500.;
				txDur=(unsigned int)rint((2*blank)/3);
				return MBTXGAP;
			case 2:
				txFreq=1900.;
				txDur=(unsigned int)rint(blank/3);
				return MBTXGAP;
			case 3:
				calcPixelPositionTable(REDLINE,TRUE);
				pixelArrayPtr=redArrayPtr;
				return MBPIXELS;
			case 4:
				txFreq=1500;
				txDur=(unsigned int)rint(fp);
				return MBTXGAP;
			case 5:
				txFreq=1200;
				txDur=(unsigned int)rint(syncDuration);
				return MBTXGAP;
			case 6:
				txFreq=1500;
				txDur=(unsigned int)rint(bp);
				lineCounter++;
				return MBTXGAP;
			case 7:
				calcPixelPositionTable(YLINEEVEN,TRUE);
				pixelArrayPtr=greenArrayPtr;
				return MBPIXELS;
			case 8:
				txFreq=2300.;
				txDur=(unsigned int)rint((2*blank)/3);
				return MBTXGAP;
			case 9:
				txFreq=1900.;
				txDur=(unsigned int)rint(blank/3);
				return MBTXGAP;
			case 10:
				calcPixelPositionTable(BLUELINE,TRUE);
				pixelArrayPtr=blueArrayPtr;
				return MBPIXELS;
			case 11:
				txFreq=1500;
				txDur=(unsigned int)rint(fp);
				return MBTXGAP;
			case 12:
				txFreq=1200;
				txDur=(unsigned int)rint(syncDuration);
				return MBTXGAP;
			case 13:
				txFreq=1500;
				txDur=(unsigned int)rint(bp);
				return MBTXGAP;
			default:
				return MBENDOFLINE;
		}
}

void modeRobot1::getLine()
{
	getLineY(TRUE);
}

