/***************************************************************************
 *   Copyright (C) 2005 by Johan Maes   *
 *   on4qz@telenet.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/
#include "modepd.h"

modePD::modePD(esstvMode m,unsigned int len,bool tx): modeBase(m,len,tx)
{

}


modePD::~modePD()
{

}

void modePD::setupParams(double clock)
{
  visibleLineLength=(lineLength(mode,clock)-fp-bp-3*blank-syncDuration)/4;
}

modeBase::embState modePD::rxSetupLine()
{
  start=lineTimeTableRX[lineCounter];
  switch(subLine)
		{
			case 0:
				calcPixelPositionTable(YLINEODD,FALSE);
        addToLog(QString("yOdd %1").arg(pixelPositionTable[0]),DBMODES);
				pixelArrayPtr=yArrayPtr;
				return MBPIXELS;
      case 1:
        debugState=stG1;
        start=lineTimeTableRX[lineCounter];
        marker=(unsigned int)round(start+bp+blank+visibleLineLength);
        addToLog(QString("mrk1 %1").arg(marker),DBMODES);
        return MBRXWAIT;
      case 2:
				calcPixelPositionTable(REDLINE,FALSE);
				pixelArrayPtr=redArrayPtr;
        addToLog(QString("red %1").arg(pixelPositionTable[0]),DBMODES);
				return MBPIXELS;
      case 3:
        debugState=stG1;
        start=lineTimeTableRX[lineCounter];
        marker=(unsigned int)round(start+bp+2*blank+2*visibleLineLength);
        addToLog(QString("mrk2 %1").arg(marker),DBMODES);
        return MBRXWAIT;
      case 4:
				calcPixelPositionTable(BLUELINE,FALSE);
				pixelArrayPtr=blueArrayPtr;
        addToLog(QString("blue %1").arg(pixelPositionTable[0]),DBMODES);
				return MBPIXELS;
      case 5:
        debugState=stG1;
        start=lineTimeTableRX[lineCounter];
        marker=(unsigned int)round(start+bp+3*blank+3*visibleLineLength);
        addToLog(QString("mrk3 %1").arg(marker),DBMODES);
        return MBRXWAIT;
      case 6:
				calcPixelPositionTable(YLINEEVEN,FALSE);
				pixelArrayPtr=greenArrayPtr;
        addToLog(QString("yEven %1").arg(pixelPositionTable[0]),DBMODES);
				return MBPIXELS;				
      case 7:
				debugState=stSync;
        syncPosition=(unsigned int)round(lineTimeTableRX[lineCounter+1]);
				return MBSYNC;
			default:
				return MBENDOFLINE;
		}
}



void modePD::calcPixelPositionTable(unsigned int colorLine,bool tx)
{
	unsigned int i;
	int ofx=0;
	if(tx) ofx=1;
  double start;
  if(tx) start=lineTimeTableTX[lineCounter];
  else start=lineTimeTableRX[lineCounter];
	debugState=colorLine;
	switch (colorLine)
		{
			case YLINEODD:
				start+=bp;
        for(i=0;i<activeSSTVParam->numberOfPixels;i++)
					{
            pixelPositionTable[i]=(unsigned int)round(start+(((float)(i+ofx)*visibleLineLength)/activeSSTVParam->numberOfPixels));
					}
			break;
			case REDLINE:
				start+=(bp+blank+visibleLineLength);
        for(i=0;i<activeSSTVParam->numberOfPixels;i++)
					{
            pixelPositionTable[i]=(unsigned int)round(start+(((float)(i+ofx)*visibleLineLength)/activeSSTVParam->numberOfPixels));
					}
			break;
			case BLUELINE:
				start+=bp+2*blank+2*visibleLineLength;
        for(i=0;i<activeSSTVParam->numberOfPixels;i++)
					{
            pixelPositionTable[i]=(unsigned int)round(start+(((float)(i+ofx)*visibleLineLength)/activeSSTVParam->numberOfPixels));
					}
			break;
			case YLINEEVEN:
				start+=bp+(3*blank+3*visibleLineLength);
        for(i=0;i<activeSSTVParam->numberOfPixels;i++)
					{
            pixelPositionTable[i]=(unsigned int)round(start+(((float)(i+ofx)*visibleLineLength)/activeSSTVParam->numberOfPixels));
					}
			break;
		}
}

void modePD::showLine()
{
	yuvConversion(yArrayPtr);
	yuvConversion(greenArrayPtr);
}

modeBase::embState modePD::txSetupLine()
{
    start=lineTimeTableTX[lineCounter];
    switch(subLine)
		{
			case 0:
				calcPixelPositionTable(YLINEODD,TRUE);
				pixelArrayPtr=yArrayPtr;
				return MBPIXELS;
			case 1:
				txFreq=1500.;
				txDur=(unsigned int)rint(blank);
				return MBTXGAP;
			case 2:
				calcPixelPositionTable(REDLINE,TRUE);
				pixelArrayPtr=redArrayPtr;
				return MBPIXELS;
			case 3:
				txFreq=1500;
				txDur=(unsigned int)rint(blank);
				return MBTXGAP;
			case 4:
				calcPixelPositionTable(BLUELINE,TRUE);
				pixelArrayPtr=blueArrayPtr;
				return MBPIXELS;
			case 5:
				txFreq=1500;
				txDur=(unsigned int)rint(blank);
				return MBTXGAP;
			case 6:
				calcPixelPositionTable(YLINEEVEN,TRUE);
				pixelArrayPtr=greenArrayPtr;
				return MBPIXELS;
			case 7:
				txFreq=1500;
				txDur=(unsigned int)rint(fp);
				return MBTXGAP;
			case 8:
				txFreq=1200;
				txDur=(unsigned int)rint(syncDuration);
				return MBTXGAP;
			case 9:
				txFreq=1500;
				txDur=(unsigned int)rint(bp);
				return MBTXGAP;
			default:
//				lineCounter++;
				return MBENDOFLINE;
		}
}


void  modePD::getLine()
{
	getLineY(TRUE);
}
