/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1
import Ubuntu.OnlineAccounts 0.1
import Friends 0.2

/*!
    \brief MainView with a TextArea and send button which post with qml-friends
*/

MainView {
    // objectName for functional testing purposes (autopilot-qt5)
    objectName: "mainView"
    applicationName: "poster"
    
    width: units.gu(50)
    height: units.gu(20)

    AccountServiceModel {
        id: accounts
        // Set serviceType to get all accounts for a type, like microblogging
        //serviceType: "microblogging"
        // Set provider to get all accounts for a single provider, like twitter
        provider: "twitter"
    }

    FriendsDispatcher {
        id: friends
        // use this to check if the send was successfull
        onSendComplete: {
             if (success) {
                 activitySpinner.visible = false;
                 entry.text = "";
                 console.log ("Send completed successfully");
             } else {
                 activitySpinner.visible = false;
                 console.log ("Send failed: " + errorMessage);
             }
         }
    }

    Column {
        anchors.centerIn: parent
        width: units.gu(40)
        spacing: units.gu(2)

        TextArea {
            id: entry
            objectName: "entry"
            anchors {
                left: parent.left
                leftMargin: units.gu(1)
                right: sendButton.left
                rightMargin: units.gu(1)
                bottomMargin: units.gu(1.5)
            }
            focus: true
            font.pixelSize: FontUtils.sizeToPixels("medium")
            font.family: "Ubuntu"
            // send message if return was pressed
            Keys.onReturnPressed: sendButton.clicked(null)
            Keys.onEscapePressed: text = ""
            height: units.gu(4)
            placeholderText: i18n.tr("Compose")
            autoSize: true
            maximumLineCount: 0
            ActivityIndicator {
                id: activitySpinner
                objectName: "activitySpinner"
                anchors.centerIn: entry
                visible: false
                running: visible
            }
        }
        Button {
            id: sendButton
            objectName: "sendButton"
            anchors {
                right: parent.right
                rightMargin: units.gu(1)
                left: entry.right
                bottom: entry.bottom
            }
            width: units.gu(9)
            height: units.gu(4)
            color: "#dd4814"
            text: i18n.tr("Send")
            onClicked: {
                console.log ("Post: " + entry.text);
                activitySpinner.visible = true
                for (var i = 0; i < accounts.count; i++) {
                    var account = accounts.get(i, "accountId");
                    friends.sendForAccountAsync(account, entry.text);
                }
            }
        }
    }
}
