/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef USERINFO_H
#define USERINFO_H

#include <QPixmap>
#include <QObject>
#include <QDate>
#include <QImage>
#include <QMap>
#include <QHostAddress>

struct QC_DatagramHeader;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class UserInfo
{
  private:
    static UserInfo* m_myInfo;

    bool     m_enabled;

    quint16  m_programVerID;
    QString  m_programVerName;
    quint16  m_status;
    quint64  m_ip;
    QString  m_compName;
    QString  m_statusDescription;

    // USER_DETAILS:
    int      m_gender; // 'm' - male, 'f' - female, 0 - not sure )
    QString  m_nickname;
    QString  m_firstName;
    QString  m_lastName;
    QString  m_secondName;
    QDate    m_dateOfBorn;
    QString  m_address;
    QString  m_homePhone;
    QString  m_workPhone;
    QString  m_mobilePhone;
    QString  m_email;
    QString  m_ICQ;
    QString  m_homepage;
    QString  m_aboutInfo;

    QString  m_pictureFilename;
    QString  m_photoFilename;
    QByteArray m_pictureHash;
    QByteArray m_photoHash;
    mutable QByteArray m_avatarHash;
    QPixmap*   m_avatar;

    // here storing values for all channels
    QMap<QString, quint16> m_statuses;
    QMap<QString, QString> m_descriptions;

    // user id on server
    uint m_uid;

  private:
    void setPictureOrPhoto(const QString &, QString &, QByteArray &);

  public:
    UserInfo (const QHostAddress& = QHostAddress(), const QString & = "", int = 0);
    UserInfo (QC_DatagramHeader* );
    ~UserInfo();

    void setEnabled(bool enable){m_enabled = enable;}

    bool     enabled                  () const { return m_enabled          ; }
    quint64  ip                       () const { return m_ip               ; }
    quint16  status                   () const { return m_status           ; }
    quint16  programVerID             () const { return m_programVerID     ; }
    const QString & nickname          () const { return m_nickname         ; }
    const QString & lastName          () const { return m_lastName         ; }
    const QString & firstName         () const { return m_firstName        ; }
    const QString & secondName        () const { return m_secondName       ; }
    const QDate   & dateOfBorn        () const { return m_dateOfBorn       ; }
    const QString & address           () const { return m_address          ; }
    const QString & homePhone         () const { return m_homePhone        ; }
    const QString & workPhone         () const { return m_workPhone        ; }
    const QString & mobilePhone       () const { return m_mobilePhone      ; }
    const QString & e_mail            () const { return m_email            ; }
    const QString & icq               () const { return m_ICQ              ; }
    const QString & homepage          () const { return m_homepage         ; }
    const QString & aboutInfo         () const { return m_aboutInfo        ; }
    const QString & compName          () const { return m_compName         ; }
    const QString & statusDescription () const { return m_statusDescription; }
    const QString & programVerName    () const { return m_programVerName   ; }
    const QString & photoFilename     () const { return m_photoFilename    ; }
    const QString & pictureFilename   () const { return m_pictureFilename  ; }

    const QByteArray & pictureHash    () const { return m_pictureHash      ; }
    const QByteArray & photoHash      () const { return m_photoHash        ; }
    void  setPictureHash(const QByteArray & ba){m_pictureHash = ba;}
    void  setPhotoHash  (const QByteArray & ba){m_photoHash   = ba;}

    QPixmap* newPhoto   () const {return new QPixmap(m_photoFilename);}
    QPixmap* newPicture () const {return new QPixmap(m_pictureFilename);}
    QPixmap* newIcon    (uint = 32, uint = 32, bool = false) const;

    QImage* newPhotoImg   () const {return new QImage(m_photoFilename);}
    QImage* newPictureImg () const {return new QImage(m_pictureFilename);}
    QImage* newIconImg    (uint = 32, uint = 32) const;

    void setProgramVerName(QString str){m_programVerName = str;}

    void setIP               (quint64 ip          ) {m_ip = ip;}
    void setStatus           (quint16 status      ) {m_status = status;}
    void setStatusDescription(const QString & des ) {if(!des.isNull()) m_statusDescription = des;}
    void setCompName         (const QString & str ) {if(!str.isNull()) m_compName    = str;}
    void setNickname         (const QString & str ) {if(!str.isNull()) m_nickname    = str;}
    void setFirstName        (const QString & str ) {if(!str.isNull()) m_firstName   = str;}
    void setLastName         (const QString & str ) {if(!str.isNull()) m_lastName    = str;}
    void setSecondName       (const QString & str ) {if(!str.isNull()) m_secondName  = str;}
    void setDateOfBorn       (const QDate   & dte ) {if(!dte.isNull()) m_dateOfBorn  = dte;}
    void setAddress          (const QString & str ) {if(!str.isNull()) m_address     = str;}
    void setHomePhone        (const QString & str ) {if(!str.isNull()) m_homePhone   = str;}
    void setWorkPhone        (const QString & str ) {if(!str.isNull()) m_workPhone   = str;}
    void setMobilePhone      (const QString & str ) {if(!str.isNull()) m_mobilePhone = str;}
    void setE_mail           (const QString & str ) {if(!str.isNull()) m_email       = str;}
    void setICQ              (const QString & str ) {if(!str.isNull()) m_ICQ         = str;}
    void setHomepage         (const QString & str ) {if(!str.isNull()) m_homepage    = str;}
    void setAboutInfo        (const QString & str ) {if(!str.isNull()) m_aboutInfo   = str;}

    void setPhoto            (const QString & fname){setPictureOrPhoto(fname, m_photoFilename, m_photoHash);}
    void setPicture          (const QString & fname){setPictureOrPhoto(fname, m_pictureFilename, m_pictureHash);}
    void setPhoto            (const QByteArray &);
    void setPicture          (const QByteArray &);

    void setGender(int value){m_gender = value;}
    int gender() const {return m_gender;}

    void setAvatarHash(const QByteArray& value){m_avatarHash = value;}
    const QByteArray & avatarHash() const {return m_avatarHash;}

    void setAvatar(QPixmap* value){m_avatar = value;}
    QPixmap* avatar() const {return m_avatar;}

    void setStatus(const QString & channel, quint16 status){m_statuses[channel] = status;}
    uint status(const QString & channel) const {return m_statuses[channel];}

    void setStatusDescription(const QString & channel, const QString & descr){m_descriptions[channel] = descr;}
    QString statusDescription(const QString & channel) const {return m_descriptions[channel];}

    void setUid( const uint& theValue ){m_uid = theValue;}
    uint uid() const {return m_uid;}

    static void setMyInfo  (UserInfo* info){m_myInfo = info;}
    static UserInfo* myInfo() {return m_myInfo;}
};

#endif
