# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.workloadssapvirtualinstance import WorkloadsSapVirtualInstanceMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-workloadssapvirtualinstance
# USAGE
    python sap_virtual_instances_create_install_ds.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = WorkloadsSapVirtualInstanceMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.sap_virtual_instances.begin_create(
        resource_group_name="test-rg",
        sap_virtual_instance_name="X00",
        resource={
            "location": "eastus2",
            "properties": {
                "configuration": {
                    "appLocation": "eastus",
                    "configurationType": "DeploymentWithOSConfig",
                    "infrastructureConfiguration": {
                        "appResourceGroup": "{{resourcegrp}}",
                        "applicationServer": {
                            "instanceCount": 2,
                            "subnetId": "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
                            "virtualMachineConfiguration": {
                                "imageReference": {
                                    "offer": "RHEL-SAP-HA",
                                    "publisher": "RedHat",
                                    "sku": "8.2",
                                    "version": "8.2.2021091201",
                                },
                                "osProfile": {
                                    "adminUsername": "azureuser",
                                    "osConfiguration": {
                                        "disablePasswordAuthentication": True,
                                        "osType": "Linux",
                                        "sshKeyPair": {"privateKey": "{{privateKey}}", "publicKey": "{{sshkey}}"},
                                    },
                                },
                                "vmSize": "Standard_E4ds_v4",
                            },
                        },
                        "centralServer": {
                            "instanceCount": 1,
                            "subnetId": "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
                            "virtualMachineConfiguration": {
                                "imageReference": {
                                    "offer": "RHEL-SAP-HA",
                                    "publisher": "RedHat",
                                    "sku": "8.2",
                                    "version": "8.2.2021091201",
                                },
                                "osProfile": {
                                    "adminUsername": "azureuser",
                                    "osConfiguration": {
                                        "disablePasswordAuthentication": True,
                                        "osType": "Linux",
                                        "sshKeyPair": {"privateKey": "{{privateKey}}", "publicKey": "{{sshkey}}"},
                                    },
                                },
                                "vmSize": "Standard_E4ds_v4",
                            },
                        },
                        "databaseServer": {
                            "instanceCount": 1,
                            "subnetId": "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
                            "virtualMachineConfiguration": {
                                "imageReference": {
                                    "offer": "RHEL-SAP-HA",
                                    "publisher": "RedHat",
                                    "sku": "8.2",
                                    "version": "8.2.2021091201",
                                },
                                "osProfile": {
                                    "adminUsername": "azureuser",
                                    "osConfiguration": {
                                        "disablePasswordAuthentication": True,
                                        "osType": "Linux",
                                        "sshKeyPair": {"privateKey": "{{privateKey}}", "publicKey": "{{sshkey}}"},
                                    },
                                },
                                "vmSize": "Standard_M32ts",
                            },
                        },
                        "deploymentType": "ThreeTier",
                        "networkConfiguration": {"isSecondaryIpEnabled": True},
                    },
                    "osSapConfiguration": {"sapFqdn": "sap.bpaas.com"},
                    "softwareConfiguration": {
                        "bomUrl": "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml",
                        "sapBitsStorageAccountId": "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
                        "softwareInstallationType": "SAPInstallWithoutOSConfig",
                        "softwareVersion": "SAP S/4HANA 1909 SPS 03",
                    },
                },
                "environment": "Prod",
                "sapProduct": "S4HANA",
            },
            "tags": {"created by": "azureuser"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2024-09-01/SapVirtualInstances_CreateInstallDS.json
if __name__ == "__main__":
    main()
