# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models
from .._serialization import Deserializer, Serializer
from ._configuration import PeeringManagementClientConfiguration
from .operations import (
    CdnPeeringPrefixesOperations,
    ConnectionMonitorTestsOperations,
    LegacyPeeringsOperations,
    LookingGlassOperations,
    Operations,
    PeerAsnsOperations,
    PeeringLocationsOperations,
    PeeringManagementClientOperationsMixin,
    PeeringServiceCountriesOperations,
    PeeringServiceLocationsOperations,
    PeeringServiceProvidersOperations,
    PeeringServicesOperations,
    PeeringsOperations,
    PrefixesOperations,
    ReceivedRoutesOperations,
    RegisteredAsnsOperations,
    RegisteredPrefixesOperations,
    RpUnbilledPrefixesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class PeeringManagementClient(
    PeeringManagementClientOperationsMixin
):  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Peering Client.

    :ivar cdn_peering_prefixes: CdnPeeringPrefixesOperations operations
    :vartype cdn_peering_prefixes: azure.mgmt.peering.aio.operations.CdnPeeringPrefixesOperations
    :ivar legacy_peerings: LegacyPeeringsOperations operations
    :vartype legacy_peerings: azure.mgmt.peering.aio.operations.LegacyPeeringsOperations
    :ivar looking_glass: LookingGlassOperations operations
    :vartype looking_glass: azure.mgmt.peering.aio.operations.LookingGlassOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.peering.aio.operations.Operations
    :ivar peer_asns: PeerAsnsOperations operations
    :vartype peer_asns: azure.mgmt.peering.aio.operations.PeerAsnsOperations
    :ivar peering_locations: PeeringLocationsOperations operations
    :vartype peering_locations: azure.mgmt.peering.aio.operations.PeeringLocationsOperations
    :ivar registered_asns: RegisteredAsnsOperations operations
    :vartype registered_asns: azure.mgmt.peering.aio.operations.RegisteredAsnsOperations
    :ivar registered_prefixes: RegisteredPrefixesOperations operations
    :vartype registered_prefixes: azure.mgmt.peering.aio.operations.RegisteredPrefixesOperations
    :ivar peerings: PeeringsOperations operations
    :vartype peerings: azure.mgmt.peering.aio.operations.PeeringsOperations
    :ivar received_routes: ReceivedRoutesOperations operations
    :vartype received_routes: azure.mgmt.peering.aio.operations.ReceivedRoutesOperations
    :ivar connection_monitor_tests: ConnectionMonitorTestsOperations operations
    :vartype connection_monitor_tests:
     azure.mgmt.peering.aio.operations.ConnectionMonitorTestsOperations
    :ivar peering_service_countries: PeeringServiceCountriesOperations operations
    :vartype peering_service_countries:
     azure.mgmt.peering.aio.operations.PeeringServiceCountriesOperations
    :ivar peering_service_locations: PeeringServiceLocationsOperations operations
    :vartype peering_service_locations:
     azure.mgmt.peering.aio.operations.PeeringServiceLocationsOperations
    :ivar prefixes: PrefixesOperations operations
    :vartype prefixes: azure.mgmt.peering.aio.operations.PrefixesOperations
    :ivar peering_service_providers: PeeringServiceProvidersOperations operations
    :vartype peering_service_providers:
     azure.mgmt.peering.aio.operations.PeeringServiceProvidersOperations
    :ivar peering_services: PeeringServicesOperations operations
    :vartype peering_services: azure.mgmt.peering.aio.operations.PeeringServicesOperations
    :ivar rp_unbilled_prefixes: RpUnbilledPrefixesOperations operations
    :vartype rp_unbilled_prefixes: azure.mgmt.peering.aio.operations.RpUnbilledPrefixesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The Azure subscription ID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-10-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = PeeringManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.cdn_peering_prefixes = CdnPeeringPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.legacy_peerings = LegacyPeeringsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.looking_glass = LookingGlassOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.peer_asns = PeerAsnsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.peering_locations = PeeringLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.registered_asns = RegisteredAsnsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.registered_prefixes = RegisteredPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.peerings = PeeringsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.received_routes = ReceivedRoutesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.connection_monitor_tests = ConnectionMonitorTestsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.peering_service_countries = PeeringServiceCountriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.peering_service_locations = PeeringServiceLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.prefixes = PrefixesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.peering_service_providers = PeeringServiceProvidersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.peering_services = PeeringServicesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.rp_unbilled_prefixes = RpUnbilledPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "PeeringManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
