# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.elasticsan.aio import ElasticSanMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestElasticSanMgmtElasticSansOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ElasticSanMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_subscription(self, resource_group):
        response = self.client.elastic_sans.list_by_subscription(
            api_version="2024-06-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = self.client.elastic_sans.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-06-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create(self, resource_group):
        response = await (
            await self.client.elastic_sans.begin_create(
                resource_group_name=resource_group.name,
                elastic_san_name="str",
                parameters={
                    "location": "str",
                    "properties": {
                        "baseSizeTiB": 0,
                        "extendedCapacitySizeTiB": 0,
                        "sku": {"name": "str", "tier": "str"},
                        "autoScaleProperties": {
                            "scaleUpProperties": {
                                "autoScalePolicyEnforcement": "str",
                                "capacityUnitScaleUpLimitTiB": 0,
                                "increaseCapacityUnitByTiB": 0,
                                "unusedSizeTiB": 0,
                            }
                        },
                        "availabilityZones": ["str"],
                        "privateEndpointConnections": [
                            {
                                "properties": {
                                    "privateLinkServiceConnectionState": {
                                        "actionsRequired": "str",
                                        "description": "str",
                                        "status": "str",
                                    },
                                    "groupIds": ["str"],
                                    "privateEndpoint": {"id": "str"},
                                    "provisioningState": "str",
                                },
                                "id": "str",
                                "name": "str",
                                "systemData": {
                                    "createdAt": "2020-02-20 00:00:00",
                                    "createdBy": "str",
                                    "createdByType": "str",
                                    "lastModifiedAt": "2020-02-20 00:00:00",
                                    "lastModifiedBy": "str",
                                    "lastModifiedByType": "str",
                                },
                                "type": "str",
                            }
                        ],
                        "provisioningState": "str",
                        "publicNetworkAccess": "str",
                        "totalIops": 0,
                        "totalMBps": 0,
                        "totalSizeTiB": 0,
                        "totalVolumeSizeGiB": 0,
                        "volumeGroupCount": 0,
                    },
                    "id": "str",
                    "name": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.elastic_sans.begin_update(
                resource_group_name=resource_group.name,
                elastic_san_name="str",
                parameters={
                    "properties": {
                        "autoScaleProperties": {
                            "scaleUpProperties": {
                                "autoScalePolicyEnforcement": "str",
                                "capacityUnitScaleUpLimitTiB": 0,
                                "increaseCapacityUnitByTiB": 0,
                                "unusedSizeTiB": 0,
                            }
                        },
                        "baseSizeTiB": 0,
                        "extendedCapacitySizeTiB": 0,
                        "publicNetworkAccess": "str",
                    },
                    "tags": {"str": "str"},
                },
                api_version="2024-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.elastic_sans.begin_delete(
                resource_group_name=resource_group.name,
                elastic_san_name="str",
                api_version="2024-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.elastic_sans.get(
            resource_group_name=resource_group.name,
            elastic_san_name="str",
            api_version="2024-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...
