# Pyntor::Flags - Display flags
# Copyright (C) 2004 - 2006 Josef Spillner <josef@coolprojects.org>
# Published under GNU GPL conditions

import pygame
from pygame.locals import *
import sys
import time
import random
import os, pwd

class Flags:
	def walker(self, arg, dirname, fnames):
		for file in fnames:
			path = os.path.join(dirname, file)
			img = pygame.image.load(path)
			self.flags.append(img)

	def init(self, options):
		flagdir = options["flagdir"]

		self.flags = []
		os.path.walk(flagdir, self.walker, None)

		if not self.flags:
			print "(Flags) no flags found"
			self.disabled = 1
			return

		self.pages = 1

		self.counter = 0
		self.flag = None

	def render(self, screen, page, globalpage):
		if self.counter == 0:
			flag = random.choice(self.flags)
			flag = flag.convert()
			flag.set_alpha(5)
			w = screen.get_width() - flag.get_width()
			h = screen.get_height() - flag.get_height()
			if w < 0:
				w = 0
			if h < 0:
				h = 0
			flagw = random.randint(0, w)
			flagh = random.randint(0, h)
			self.flag = (flag, flagw, flagh)

		(flag, flagw, flagh) = self.flag
		#surface.blit(flag, (flagw, flagh))
		screen.blit(flag, (flagw, flagh))

		#screen.blit(surface, (0, 0))
		#pygame.display.flip()

	def interactive(self, event):
		if event.type == KEYDOWN:
			key = event.key
			if key == K_ESCAPE or pygame.event.peek(QUIT):
				return "exit"
			if key == K_RETURN:
				return "next"
			if key == K_BACKSPACE:
				return "previous"
			if key == K_s:
				filename = "intro" + ".bmp"
				# FIXME: screen?
				pygame.image.save(screen, os.path.join("static", filename))

		self.counter = (self.counter + 1) % 35
		#if self.counter == 0:
		return "reload"

component = Flags()

parameters = (
	("flagdir", "Directory containing the flag images", None),
)

metainfo = {
	"version": "0.2",
	"author": "Josef Spillner",
	"authoremail": "<josef@coolprojects.org>",
	"licence": "GPL"
}

doc = """
Flags: display flags (or other images) with blend effect

Usage: 'flags' -flagdir <flagdir>
 Where <flagdir> is a directory containing images of various sizes

Display: yes

Interactivity: no (but contains timer events), cancel with escape
"""

