/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableClassifier;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.Matrix;

public class SimpleCart
extends RandomizableClassifier
implements AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = 4154189200352566053L;
    protected Instances m_train;
    protected SimpleCart[] m_Successors;
    protected Attribute m_Attribute;
    protected double m_SplitValue;
    protected String m_SplitString;
    protected double m_ClassValue;
    protected Attribute m_ClassAttribute;
    protected double m_minNumObj = 2.0;
    protected int m_numFoldsPruning = 5;
    protected double m_Alpha;
    protected double m_numIncorrectModel;
    protected double m_numIncorrectTree;
    protected boolean m_isLeaf;
    protected boolean m_Prune = true;
    protected int m_totalTrainInstances;
    protected double[] m_Props;
    protected double[] m_ClassProbs = null;
    protected double[] m_Distribution;
    protected boolean m_Heuristic = true;
    protected boolean m_UseOneSE = false;
    protected double m_SizePer = 1.0;

    public String globalInfo() {
        return "Class implementing minimal cost-complexity pruning.\nNote when dealing with missing values, use \"fractional instances\" method instead of surrogate split method.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Leo Breiman and Jerome H. Friedman and Richard A. Olshen and Charles J. Stone");
        result.setValue(TechnicalInformation.Field.YEAR, "1984");
        result.setValue(TechnicalInformation.Field.TITLE, "Classification and Regression Trees");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Wadsworth International Group");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Belmont, California");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (!this.m_Prune) {
            int[][] sortedIndices = new int[data.numAttributes()][0];
            double[][] weights = new double[data.numAttributes()][0];
            double[] classProbs = new double[data.numClasses()];
            double totalWeight = this.computeSortedInfo(data, sortedIndices, weights, classProbs);
            this.makeTree(data, data.numInstances(), sortedIndices, weights, classProbs, totalWeight, this.m_minNumObj, this.m_Heuristic);
            return;
        }
        Random random = new Random(this.m_Seed);
        Instances cvData = new Instances(data);
        cvData.randomize(random);
        cvData = new Instances(cvData, 0, (int)((double)cvData.numInstances() * this.m_SizePer) - 1);
        cvData.stratify(this.m_numFoldsPruning);
        double[][] alphas = new double[this.m_numFoldsPruning][];
        double[][] errors = new double[this.m_numFoldsPruning][];
        for (int i = 0; i < this.m_numFoldsPruning; ++i) {
            Instances train = cvData.trainCV(this.m_numFoldsPruning, i);
            Instances test = cvData.testCV(this.m_numFoldsPruning, i);
            int[][] sortedIndices = new int[train.numAttributes()][0];
            double[][] weights = new double[train.numAttributes()][0];
            double[] classProbs = new double[train.numClasses()];
            double totalWeight = this.computeSortedInfo(train, sortedIndices, weights, classProbs);
            this.makeTree(train, train.numInstances(), sortedIndices, weights, classProbs, totalWeight, this.m_minNumObj, this.m_Heuristic);
            int numNodes = this.numInnerNodes();
            alphas[i] = new double[numNodes + 2];
            errors[i] = new double[numNodes + 2];
            this.prune(alphas[i], errors[i], test);
        }
        int[][] sortedIndices = new int[data.numAttributes()][0];
        double[][] weights = new double[data.numAttributes()][0];
        double[] classProbs = new double[data.numClasses()];
        double totalWeight = this.computeSortedInfo(data, sortedIndices, weights, classProbs);
        this.makeTree(data, data.numInstances(), sortedIndices, weights, classProbs, totalWeight, this.m_minNumObj, this.m_Heuristic);
        int numNodes = this.numInnerNodes();
        double[] treeAlphas = new double[numNodes + 2];
        int iterations = this.prune(treeAlphas, null, null);
        double[] treeErrors = new double[numNodes + 2];
        for (int i = 0; i <= iterations; ++i) {
            double alpha = Math.sqrt(treeAlphas[i] * treeAlphas[i + 1]);
            double error = 0.0;
            for (int k = 0; k < this.m_numFoldsPruning; ++k) {
                int l = 0;
                while (alphas[k][l] <= alpha) {
                    ++l;
                }
                error += errors[k][l - 1];
            }
            treeErrors[i] = error / (double)this.m_numFoldsPruning;
        }
        int best = -1;
        double bestError = Double.MAX_VALUE;
        for (int i = iterations; i >= 0; --i) {
            if (!(treeErrors[i] < bestError)) continue;
            bestError = treeErrors[i];
            best = i;
        }
        if (this.m_UseOneSE) {
            double oneSE = Math.sqrt(bestError * (1.0 - bestError) / (double)data.numInstances());
            for (int i = iterations; i >= 0; --i) {
                if (!(treeErrors[i] <= bestError + oneSE)) continue;
                best = i;
                break;
            }
        }
        double bestAlpha = Math.sqrt(treeAlphas[best] * treeAlphas[best + 1]);
        this.unprune();
        this.prune(bestAlpha);
    }

    protected void makeTree(Instances data, int totalInstances, int[][] sortedIndices, double[][] weights, double[] classProbs, double totalWeight, double minNumObj, boolean useHeuristic) throws Exception {
        if (totalWeight == 0.0) {
            this.m_Attribute = null;
            this.m_ClassValue = Instance.missingValue();
            this.m_Distribution = new double[data.numClasses()];
            return;
        }
        this.m_totalTrainInstances = totalInstances;
        this.m_isLeaf = true;
        this.m_ClassProbs = new double[classProbs.length];
        this.m_Distribution = new double[classProbs.length];
        System.arraycopy(classProbs, 0, this.m_ClassProbs, 0, classProbs.length);
        System.arraycopy(classProbs, 0, this.m_Distribution, 0, classProbs.length);
        if (Utils.sum(this.m_ClassProbs) != 0.0) {
            Utils.normalize(this.m_ClassProbs);
        }
        double[][][] dists = new double[data.numAttributes()][0][0];
        double[][] props = new double[data.numAttributes()][0];
        double[][] totalSubsetWeights = new double[data.numAttributes()][2];
        double[] splits = new double[data.numAttributes()];
        String[] splitString = new String[data.numAttributes()];
        double[] giniGains = new double[data.numAttributes()];
        for (int i = 0; i < data.numAttributes(); ++i) {
            Attribute att = data.attribute(i);
            if (i == data.classIndex()) continue;
            if (att.isNumeric()) {
                splits[i] = this.numericDistribution(props, dists, att, sortedIndices[i], weights[i], totalSubsetWeights, giniGains, data);
                continue;
            }
            splitString[i] = this.nominalDistribution(props, dists, att, sortedIndices[i], weights[i], totalSubsetWeights, giniGains, data, useHeuristic);
        }
        int attIndex = Utils.maxIndex(giniGains);
        this.m_Attribute = data.attribute(attIndex);
        this.m_train = new Instances(data, sortedIndices[attIndex].length);
        for (int i = 0; i < sortedIndices[attIndex].length; ++i) {
            Instance inst = data.instance(sortedIndices[attIndex][i]);
            Instance instCopy = (Instance)inst.copy();
            instCopy.setWeight(weights[attIndex][i]);
            this.m_train.add(instCopy);
        }
        if (totalWeight < 2.0 * minNumObj || giniGains[attIndex] == 0.0 || props[attIndex][0] == 0.0 || props[attIndex][1] == 0.0) {
            this.makeLeaf(data);
        } else {
            this.m_Props = props[attIndex];
            int[][][] subsetIndices = new int[2][data.numAttributes()][0];
            double[][][] subsetWeights = new double[2][data.numAttributes()][0];
            if (this.m_Attribute.isNumeric()) {
                this.m_SplitValue = splits[attIndex];
            } else {
                this.m_SplitString = splitString[attIndex];
            }
            this.splitData(subsetIndices, subsetWeights, this.m_Attribute, this.m_SplitValue, this.m_SplitString, sortedIndices, weights, data);
            if ((double)subsetIndices[0][attIndex].length < minNumObj || (double)subsetIndices[1][attIndex].length < minNumObj) {
                this.makeLeaf(data);
                return;
            }
            this.m_isLeaf = false;
            this.m_Successors = new SimpleCart[2];
            for (int i = 0; i < 2; ++i) {
                this.m_Successors[i] = new SimpleCart();
                this.m_Successors[i].makeTree(data, this.m_totalTrainInstances, subsetIndices[i], subsetWeights[i], dists[attIndex][i], totalSubsetWeights[attIndex][i], minNumObj, useHeuristic);
            }
        }
    }

    public void prune(double alpha) throws Exception {
        this.modelErrors();
        this.treeErrors();
        this.calculateAlphas();
        Vector nodeList = this.getInnerNodes();
        boolean prune = nodeList.size() > 0;
        double preAlpha = Double.MAX_VALUE;
        while (prune) {
            SimpleCart nodeToPrune = this.nodeToPrune(nodeList);
            if (nodeToPrune.m_Alpha > alpha) break;
            nodeToPrune.makeLeaf(nodeToPrune.m_train);
            if (nodeToPrune.m_Alpha == preAlpha) {
                nodeToPrune.makeLeaf(nodeToPrune.m_train);
                this.treeErrors();
                this.calculateAlphas();
                nodeList = this.getInnerNodes();
                prune = nodeList.size() > 0;
                continue;
            }
            preAlpha = nodeToPrune.m_Alpha;
            this.treeErrors();
            this.calculateAlphas();
            nodeList = this.getInnerNodes();
            prune = nodeList.size() > 0;
        }
    }

    public int prune(double[] alphas, double[] errors, Instances test) throws Exception {
        Evaluation eval;
        this.modelErrors();
        this.treeErrors();
        this.calculateAlphas();
        Vector nodeList = this.getInnerNodes();
        boolean prune = nodeList.size() > 0;
        alphas[0] = 0.0;
        if (errors != null) {
            eval = new Evaluation(test);
            eval.evaluateModel(this, test, new Object[0]);
            errors[0] = eval.errorRate();
        }
        int iteration = 0;
        double preAlpha = Double.MAX_VALUE;
        while (prune) {
            ++iteration;
            SimpleCart nodeToPrune = this.nodeToPrune(nodeList);
            nodeToPrune.m_isLeaf = true;
            if (nodeToPrune.m_Alpha == preAlpha) {
                --iteration;
                this.treeErrors();
                this.calculateAlphas();
                nodeList = this.getInnerNodes();
                prune = nodeList.size() > 0;
                continue;
            }
            alphas[iteration] = nodeToPrune.m_Alpha;
            if (errors != null) {
                eval = new Evaluation(test);
                eval.evaluateModel(this, test, new Object[0]);
                errors[iteration] = eval.errorRate();
            }
            preAlpha = nodeToPrune.m_Alpha;
            this.treeErrors();
            this.calculateAlphas();
            nodeList = this.getInnerNodes();
            prune = nodeList.size() > 0;
        }
        alphas[iteration + 1] = 1.0;
        return iteration;
    }

    protected void unprune() {
        if (this.m_Successors != null) {
            this.m_isLeaf = false;
            for (int i = 0; i < this.m_Successors.length; ++i) {
                this.m_Successors[i].unprune();
            }
        }
    }

    protected double numericDistribution(double[][] props, double[][][] dists, Attribute att, int[] sortedIndices, double[] weights, double[][] subsetWeights, double[] giniGains, Instances data) throws Exception {
        Instance inst;
        double splitPoint = Double.NaN;
        double[][] dist = null;
        int numClasses = data.numClasses();
        double[][] currDist = new double[2][numClasses];
        dist = new double[2][numClasses];
        double[] parentDist = new double[numClasses];
        int missingStart = 0;
        for (int j = 0; j < sortedIndices.length; ++j) {
            Instance inst2 = data.instance(sortedIndices[j]);
            if (!inst2.isMissing(att)) {
                ++missingStart;
                double[] dArray = currDist[1];
                int n = (int)inst2.classValue();
                dArray[n] = dArray[n] + weights[j];
            }
            int n = (int)inst2.classValue();
            parentDist[n] = parentDist[n] + weights[j];
        }
        System.arraycopy(currDist[1], 0, dist[1], 0, dist[1].length);
        double currSplit = data.instance(sortedIndices[0]).value(att);
        double bestGiniGain = -1.7976931348623157E308;
        for (int i = 0; i < sortedIndices.length && !(inst = data.instance(sortedIndices[i])).isMissing(att); ++i) {
            if (inst.value(att) > currSplit) {
                double[][] tempDist = new double[2][numClasses];
                for (int k = 0; k < 2; ++k) {
                    System.arraycopy(currDist[k], 0, tempDist[k], 0, tempDist[k].length);
                }
                double[] tempProps = new double[2];
                for (int k = 0; k < 2; ++k) {
                    tempProps[k] = Utils.sum(tempDist[k]);
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                for (int index = missingStart; index < sortedIndices.length; ++index) {
                    Instance insta = data.instance(sortedIndices[index]);
                    for (int j = 0; j < 2; ++j) {
                        double[] dArray = tempDist[j];
                        int n = (int)insta.classValue();
                        dArray[n] = dArray[n] + tempProps[j] * weights[index];
                    }
                }
                double currGiniGain = this.computeGiniGain(parentDist, tempDist);
                if (currGiniGain > bestGiniGain) {
                    bestGiniGain = currGiniGain;
                    splitPoint = (inst.value(att) + currSplit) / 2.0;
                    for (int j = 0; j < currDist.length; ++j) {
                        System.arraycopy(tempDist[j], 0, dist[j], 0, dist[j].length);
                    }
                }
            }
            currSplit = inst.value(att);
            double[] dArray = currDist[0];
            int n = (int)inst.classValue();
            dArray[n] = dArray[n] + weights[i];
            double[] dArray2 = currDist[1];
            int n2 = (int)inst.classValue();
            dArray2[n2] = dArray2[n2] - weights[i];
        }
        int attIndex = att.index();
        props[attIndex] = new double[2];
        for (int k = 0; k < 2; ++k) {
            props[attIndex][k] = Utils.sum(dist[k]);
        }
        if (Utils.sum(props[attIndex]) != 0.0) {
            Utils.normalize(props[attIndex]);
        }
        subsetWeights[attIndex] = new double[2];
        for (int j = 0; j < 2; ++j) {
            double[] dArray = subsetWeights[attIndex];
            int n = j;
            dArray[n] = dArray[n] + Utils.sum(dist[j]);
        }
        giniGains[attIndex] = bestGiniGain;
        dists[attIndex] = dist;
        return splitPoint;
    }

    protected String nominalDistribution(double[][] props, double[][][] dists, Attribute att, int[] sortedIndices, double[] weights, double[][] subsetWeights, double[] giniGains, Instances data, boolean useHeuristic) throws Exception {
        int j;
        int k;
        String[] values = new String[att.numValues()];
        int numCat = values.length;
        int numClasses = data.numClasses();
        String bestSplitString = "";
        double bestGiniGain = -1.7976931348623157E308;
        int[] classFreq = new int[numCat];
        for (int j2 = 0; j2 < numCat; ++j2) {
            classFreq[j2] = 0;
        }
        double[] parentDist = new double[numClasses];
        double[][] currDist = new double[2][numClasses];
        double[][] dist = new double[2][numClasses];
        int missingStart = 0;
        for (int i = 0; i < sortedIndices.length; ++i) {
            Instance inst = data.instance(sortedIndices[i]);
            if (!inst.isMissing(att)) {
                ++missingStart;
                int n = (int)inst.value(att);
                classFreq[n] = classFreq[n] + 1;
            }
            int n = (int)inst.classValue();
            parentDist[n] = parentDist[n] + weights[i];
        }
        int nonEmpty = 0;
        for (int j3 = 0; j3 < numCat; ++j3) {
            if (classFreq[j3] == 0) continue;
            ++nonEmpty;
        }
        String[] nonEmptyValues = new String[nonEmpty];
        int nonEmptyIndex = 0;
        for (int j4 = 0; j4 < numCat; ++j4) {
            if (classFreq[j4] == 0) continue;
            nonEmptyValues[nonEmptyIndex] = att.value(j4);
            ++nonEmptyIndex;
        }
        int empty = numCat - nonEmpty;
        String[] emptyValues = new String[empty];
        int emptyIndex = 0;
        for (int j5 = 0; j5 < numCat; ++j5) {
            if (classFreq[j5] != 0) continue;
            emptyValues[emptyIndex] = att.value(j5);
            ++emptyIndex;
        }
        if (nonEmpty <= 1) {
            giniGains[att.index()] = 0.0;
            return "";
        }
        if (data.numClasses() == 2) {
            int j6;
            Instance inst;
            int j7;
            double[] pClass0 = new double[nonEmpty];
            double[][] valDist = new double[nonEmpty][2];
            for (j7 = 0; j7 < nonEmpty; ++j7) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    valDist[j7][k2] = 0.0;
                }
            }
            block7: for (int i = 0; i < sortedIndices.length && !(inst = data.instance(sortedIndices[i])).isMissing(att); ++i) {
                for (j6 = 0; j6 < nonEmpty; ++j6) {
                    if (att.value((int)inst.value(att)).compareTo(nonEmptyValues[j6]) != 0) continue;
                    double[] dArray = valDist[j6];
                    int n = (int)inst.classValue();
                    dArray[n] = dArray[n] + inst.weight();
                    continue block7;
                }
            }
            for (j7 = 0; j7 < nonEmpty; ++j7) {
                double distSum = Utils.sum(valDist[j7]);
                pClass0[j7] = distSum == 0.0 ? 0.0 : valDist[j7][0] / distSum;
            }
            String[] sortedValues = new String[nonEmpty];
            for (int j8 = 0; j8 < nonEmpty; ++j8) {
                sortedValues[j8] = nonEmptyValues[Utils.minIndex(pClass0)];
                pClass0[Utils.minIndex((double[])pClass0)] = Double.MAX_VALUE;
            }
            String tempStr = "";
            for (j6 = 0; j6 < nonEmpty - 1; ++j6) {
                Instance inst2;
                currDist = new double[2][numClasses];
                tempStr = tempStr == "" ? "(" + sortedValues[j6] + ")" : tempStr + "|(" + sortedValues[j6] + ")";
                for (int i = 0; i < sortedIndices.length && !(inst2 = data.instance(sortedIndices[i])).isMissing(att); ++i) {
                    if (tempStr.indexOf("(" + att.value((int)inst2.value(att)) + ")") != -1) {
                        double[] dArray = currDist[0];
                        int n = (int)inst2.classValue();
                        dArray[n] = dArray[n] + weights[i];
                        continue;
                    }
                    double[] dArray = currDist[1];
                    int n = (int)inst2.classValue();
                    dArray[n] = dArray[n] + weights[i];
                }
                double[][] tempDist = new double[2][numClasses];
                for (int kk = 0; kk < 2; ++kk) {
                    tempDist[kk] = currDist[kk];
                }
                double[] tempProps = new double[2];
                for (int kk = 0; kk < 2; ++kk) {
                    tempProps[kk] = Utils.sum(tempDist[kk]);
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                for (int mstart = missingStart; mstart < sortedIndices.length; ++mstart) {
                    Instance insta = data.instance(sortedIndices[mstart]);
                    for (int jj = 0; jj < 2; ++jj) {
                        double[] dArray = tempDist[jj];
                        int n = (int)insta.classValue();
                        dArray[n] = dArray[n] + tempProps[jj] * weights[mstart];
                    }
                }
                double currGiniGain = this.computeGiniGain(parentDist, tempDist);
                if (!(currGiniGain > bestGiniGain)) continue;
                bestGiniGain = currGiniGain;
                bestSplitString = tempStr;
                for (int jj = 0; jj < 2; ++jj) {
                    System.arraycopy(tempDist[jj], 0, dist[jj], 0, dist[jj].length);
                }
            }
        } else if (!useHeuristic || nonEmpty <= 4) {
            for (int i = 0; i < (int)Math.pow(2.0, nonEmpty - 1); ++i) {
                Instance inst;
                int j9;
                String tempStr = "";
                currDist = new double[2][numClasses];
                int bit10 = i;
                for (j9 = nonEmpty - 1; j9 >= 0; --j9) {
                    int mod = bit10 % 2;
                    if (mod == 1) {
                        tempStr = tempStr == "" ? "(" + nonEmptyValues[j9] + ")" : tempStr + "|(" + nonEmptyValues[j9] + ")";
                    }
                    bit10 /= 2;
                }
                for (j9 = 0; j9 < sortedIndices.length && !(inst = data.instance(sortedIndices[j9])).isMissing(att); ++j9) {
                    if (tempStr.indexOf("(" + att.value((int)inst.value(att)) + ")") != -1) {
                        double[] dArray = currDist[0];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + weights[j9];
                        continue;
                    }
                    double[] dArray = currDist[1];
                    int n = (int)inst.classValue();
                    dArray[n] = dArray[n] + weights[j9];
                }
                double[][] tempDist = new double[2][numClasses];
                for (int k3 = 0; k3 < 2; ++k3) {
                    tempDist[k3] = currDist[k3];
                }
                double[] tempProps = new double[2];
                for (int k4 = 0; k4 < 2; ++k4) {
                    tempProps[k4] = Utils.sum(tempDist[k4]);
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                for (int index = missingStart; index < sortedIndices.length; ++index) {
                    Instance insta = data.instance(sortedIndices[index]);
                    for (int j10 = 0; j10 < 2; ++j10) {
                        double[] dArray = tempDist[j10];
                        int n = (int)insta.classValue();
                        dArray[n] = dArray[n] + tempProps[j10] * weights[index];
                    }
                }
                double currGiniGain = this.computeGiniGain(parentDist, tempDist);
                if (!(currGiniGain > bestGiniGain)) continue;
                bestGiniGain = currGiniGain;
                bestSplitString = tempStr;
                for (int j11 = 0; j11 < 2; ++j11) {
                    System.arraycopy(tempDist[j11], 0, dist[j11], 0, dist[j11].length);
                }
            }
        } else {
            int i;
            int j12;
            int n = nonEmpty;
            int k5 = data.numClasses();
            double[][] P = new double[n][k5];
            int[] numInstancesValue = new int[n];
            double[] meanClass = new double[k5];
            int numInstances = data.numInstances();
            for (j12 = 0; j12 < meanClass.length; ++j12) {
                meanClass[j12] = 0.0;
            }
            for (j12 = 0; j12 < numInstances; ++j12) {
                Instance inst = data.instance(j12);
                int valueIndex = 0;
                for (int i2 = 0; i2 < nonEmpty; ++i2) {
                    if (att.value((int)inst.value(att)).compareToIgnoreCase(nonEmptyValues[i2]) != 0) continue;
                    valueIndex = i2;
                    break;
                }
                double[] dArray = P[valueIndex];
                int n2 = (int)inst.classValue();
                dArray[n2] = dArray[n2] + 1.0;
                int n3 = valueIndex;
                numInstancesValue[n3] = numInstancesValue[n3] + 1;
                int n4 = (int)inst.classValue();
                meanClass[n4] = meanClass[n4] + 1.0;
            }
            for (i = 0; i < P.length; ++i) {
                for (int j13 = 0; j13 < P[0].length; ++j13) {
                    if (numInstancesValue[i] == 0) {
                        P[i][j13] = 0.0;
                        continue;
                    }
                    double[] dArray = P[i];
                    int n5 = j13;
                    dArray[n5] = dArray[n5] / (double)numInstancesValue[i];
                }
            }
            i = 0;
            while (i < meanClass.length) {
                int n6 = i++;
                meanClass[n6] = meanClass[n6] / (double)numInstances;
            }
            double[][] covariance = new double[k5][k5];
            for (int i1 = 0; i1 < k5; ++i1) {
                for (int i2 = 0; i2 < k5; ++i2) {
                    double element = 0.0;
                    for (int j14 = 0; j14 < n; ++j14) {
                        element += (P[j14][i2] - meanClass[i2]) * (P[j14][i1] - meanClass[i1]) * (double)numInstancesValue[j14];
                    }
                    covariance[i1][i2] = element;
                }
            }
            Matrix matrix = new Matrix(covariance);
            EigenvalueDecomposition eigen = new EigenvalueDecomposition(matrix);
            double[] eigenValues = eigen.getRealEigenvalues();
            int index = 0;
            double largest = eigenValues[0];
            for (int i3 = 1; i3 < eigenValues.length; ++i3) {
                if (!(eigenValues[i3] > largest)) continue;
                index = i3;
                largest = eigenValues[i3];
            }
            double[] FPC = new double[k5];
            Matrix eigenVector = eigen.getV();
            double[][] vectorArray = eigenVector.getArray();
            for (int i4 = 0; i4 < FPC.length; ++i4) {
                FPC[i4] = vectorArray[i4][index];
            }
            double[] Sa = new double[n];
            for (int i5 = 0; i5 < Sa.length; ++i5) {
                Sa[i5] = 0.0;
                for (int j15 = 0; j15 < k5; ++j15) {
                    int n7 = i5;
                    Sa[n7] = Sa[n7] + FPC[j15] * P[i5][j15];
                }
            }
            double[] pCopy = new double[n];
            System.arraycopy(Sa, 0, pCopy, 0, n);
            String[] sortedValues = new String[n];
            Arrays.sort(Sa);
            for (int j16 = 0; j16 < n; ++j16) {
                sortedValues[j16] = nonEmptyValues[Utils.minIndex(pCopy)];
                pCopy[Utils.minIndex((double[])pCopy)] = Double.MAX_VALUE;
            }
            String tempStr = "";
            for (int j17 = 0; j17 < nonEmpty - 1; ++j17) {
                Instance inst;
                currDist = new double[2][numClasses];
                tempStr = tempStr == "" ? "(" + sortedValues[j17] + ")" : tempStr + "|(" + sortedValues[j17] + ")";
                for (int i6 = 0; i6 < sortedIndices.length && !(inst = data.instance(sortedIndices[i6])).isMissing(att); ++i6) {
                    if (tempStr.indexOf("(" + att.value((int)inst.value(att)) + ")") != -1) {
                        double[] dArray = currDist[0];
                        int n8 = (int)inst.classValue();
                        dArray[n8] = dArray[n8] + weights[i6];
                        continue;
                    }
                    double[] dArray = currDist[1];
                    int n9 = (int)inst.classValue();
                    dArray[n9] = dArray[n9] + weights[i6];
                }
                double[][] tempDist = new double[2][numClasses];
                for (int kk = 0; kk < 2; ++kk) {
                    tempDist[kk] = currDist[kk];
                }
                double[] tempProps = new double[2];
                for (int kk = 0; kk < 2; ++kk) {
                    tempProps[kk] = Utils.sum(tempDist[kk]);
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                for (int mstart = missingStart; mstart < sortedIndices.length; ++mstart) {
                    Instance insta = data.instance(sortedIndices[mstart]);
                    for (int jj = 0; jj < 2; ++jj) {
                        double[] dArray = tempDist[jj];
                        int n10 = (int)insta.classValue();
                        dArray[n10] = dArray[n10] + tempProps[jj] * weights[mstart];
                    }
                }
                double currGiniGain = this.computeGiniGain(parentDist, tempDist);
                if (!(currGiniGain > bestGiniGain)) continue;
                bestGiniGain = currGiniGain;
                bestSplitString = tempStr;
                for (int jj = 0; jj < 2; ++jj) {
                    System.arraycopy(tempDist[jj], 0, dist[jj], 0, dist[jj].length);
                }
            }
        }
        int attIndex = att.index();
        props[attIndex] = new double[2];
        for (k = 0; k < 2; ++k) {
            props[attIndex][k] = Utils.sum(dist[k]);
        }
        if (!(Utils.sum(props[attIndex]) > 0.0)) {
            for (k = 0; k < props[attIndex].length; ++k) {
                props[attIndex][k] = 1.0 / (double)props[attIndex].length;
            }
        } else {
            Utils.normalize(props[attIndex]);
        }
        subsetWeights[attIndex] = new double[2];
        for (j = 0; j < 2; ++j) {
            double[] dArray = subsetWeights[attIndex];
            int n = j;
            dArray[n] = dArray[n] + Utils.sum(dist[j]);
        }
        for (j = 0; j < empty; ++j) {
            if (!(props[attIndex][0] >= props[attIndex][1])) continue;
            bestSplitString = bestSplitString == "" ? "(" + emptyValues[j] + ")" : bestSplitString + "|(" + emptyValues[j] + ")";
        }
        giniGains[attIndex] = bestGiniGain;
        dists[attIndex] = dist;
        return bestSplitString;
    }

    protected void splitData(int[][][] subsetIndices, double[][][] subsetWeights, Attribute att, double splitPoint, String splitStr, int[][] sortedIndices, double[][] weights, Instances data) throws Exception {
        for (int i = 0; i < data.numAttributes(); ++i) {
            int k;
            if (i == data.classIndex()) continue;
            int[] num = new int[2];
            for (k = 0; k < 2; ++k) {
                subsetIndices[k][i] = new int[sortedIndices[i].length];
                subsetWeights[k][i] = new double[weights[i].length];
            }
            for (int j = 0; j < sortedIndices[i].length; ++j) {
                Instance inst = data.instance(sortedIndices[i][j]);
                if (inst.isMissing(att)) {
                    for (int k2 = 0; k2 < 2; ++k2) {
                        if (!(this.m_Props[k2] > 0.0)) continue;
                        subsetIndices[k2][i][num[k2]] = sortedIndices[i][j];
                        subsetWeights[k2][i][num[k2]] = this.m_Props[k2] * weights[i][j];
                        int n = k2;
                        num[n] = num[n] + 1;
                    }
                    continue;
                }
                int subset = att.isNumeric() ? (inst.value(att) < splitPoint ? 0 : 1) : (splitStr.indexOf("(" + att.value((int)inst.value(att.index())) + ")") != -1 ? 0 : 1);
                subsetIndices[subset][i][num[subset]] = sortedIndices[i][j];
                subsetWeights[subset][i][num[subset]] = weights[i][j];
                int n = subset;
                num[n] = num[n] + 1;
            }
            for (k = 0; k < 2; ++k) {
                int[] copy = new int[num[k]];
                System.arraycopy(subsetIndices[k][i], 0, copy, 0, num[k]);
                subsetIndices[k][i] = copy;
                double[] copyWeights = new double[num[k]];
                System.arraycopy(subsetWeights[k][i], 0, copyWeights, 0, num[k]);
                subsetWeights[k][i] = copyWeights;
            }
        }
    }

    public void modelErrors() throws Exception {
        Evaluation eval = new Evaluation(this.m_train);
        if (!this.m_isLeaf) {
            this.m_isLeaf = true;
            eval.evaluateModel(this, this.m_train, new Object[0]);
            this.m_numIncorrectModel = eval.incorrect();
            this.m_isLeaf = false;
            for (int i = 0; i < this.m_Successors.length; ++i) {
                this.m_Successors[i].modelErrors();
            }
        } else {
            eval.evaluateModel(this, this.m_train, new Object[0]);
            this.m_numIncorrectModel = eval.incorrect();
        }
    }

    public void treeErrors() throws Exception {
        if (this.m_isLeaf) {
            this.m_numIncorrectTree = this.m_numIncorrectModel;
        } else {
            this.m_numIncorrectTree = 0.0;
            for (int i = 0; i < this.m_Successors.length; ++i) {
                this.m_Successors[i].treeErrors();
                this.m_numIncorrectTree += this.m_Successors[i].m_numIncorrectTree;
            }
        }
    }

    public void calculateAlphas() throws Exception {
        if (!this.m_isLeaf) {
            double errorDiff = this.m_numIncorrectModel - this.m_numIncorrectTree;
            if (errorDiff <= 0.0) {
                this.makeLeaf(this.m_train);
                this.m_Alpha = Double.MAX_VALUE;
            } else {
                this.m_Alpha = (errorDiff /= (double)this.m_totalTrainInstances) / (double)(this.numLeaves() - 1);
                long alphaLong = Math.round(this.m_Alpha * Math.pow(10.0, 10.0));
                this.m_Alpha = (double)alphaLong / Math.pow(10.0, 10.0);
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    this.m_Successors[i].calculateAlphas();
                }
            }
        } else {
            this.m_Alpha = Double.MAX_VALUE;
        }
    }

    protected SimpleCart nodeToPrune(Vector nodeList) {
        if (nodeList.size() == 0) {
            return null;
        }
        if (nodeList.size() == 1) {
            return (SimpleCart)nodeList.elementAt(0);
        }
        SimpleCart returnNode = (SimpleCart)nodeList.elementAt(0);
        double baseAlpha = returnNode.m_Alpha;
        for (int i = 1; i < nodeList.size(); ++i) {
            SimpleCart node = (SimpleCart)nodeList.elementAt(i);
            if (node.m_Alpha < baseAlpha) {
                baseAlpha = node.m_Alpha;
                returnNode = node;
                continue;
            }
            if (node.m_Alpha != baseAlpha || node.numLeaves() <= returnNode.numLeaves()) continue;
            returnNode = node;
        }
        return returnNode;
    }

    protected double computeSortedInfo(Instances data, int[][] sortedIndices, double[][] weights, double[] classProbs) throws Exception {
        Instance inst;
        int i;
        double[] vals = new double[data.numInstances()];
        for (int j = 0; j < data.numAttributes(); ++j) {
            int i2;
            if (j == data.classIndex()) continue;
            weights[j] = new double[data.numInstances()];
            if (data.attribute(j).isNominal()) {
                sortedIndices[j] = new int[data.numInstances()];
                int count = 0;
                for (i = 0; i < data.numInstances(); ++i) {
                    inst = data.instance(i);
                    if (inst.isMissing(j)) continue;
                    sortedIndices[j][count] = i;
                    weights[j][count] = inst.weight();
                    ++count;
                }
                for (i = 0; i < data.numInstances(); ++i) {
                    inst = data.instance(i);
                    if (!inst.isMissing(j)) continue;
                    sortedIndices[j][count] = i;
                    weights[j][count] = inst.weight();
                    ++count;
                }
                continue;
            }
            for (i2 = 0; i2 < data.numInstances(); ++i2) {
                Instance inst2 = data.instance(i2);
                vals[i2] = inst2.value(j);
            }
            sortedIndices[j] = Utils.sort(vals);
            for (i2 = 0; i2 < data.numInstances(); ++i2) {
                weights[j][i2] = data.instance(sortedIndices[j][i2]).weight();
            }
        }
        double totalWeight = 0.0;
        for (i = 0; i < data.numInstances(); ++i) {
            inst = data.instance(i);
            int n = (int)inst.classValue();
            classProbs[n] = classProbs[n] + inst.weight();
            totalWeight += inst.weight();
        }
        return totalWeight;
    }

    protected double computeGiniGain(double[] parentDist, double[][] childDist) {
        double totalWeight = Utils.sum(parentDist);
        if (totalWeight == 0.0) {
            return 0.0;
        }
        double leftWeight = Utils.sum(childDist[0]);
        double rightWeight = Utils.sum(childDist[1]);
        double parentGini = this.computeGini(parentDist, totalWeight);
        double leftGini = this.computeGini(childDist[0], leftWeight);
        double rightGini = this.computeGini(childDist[1], rightWeight);
        return parentGini - leftWeight / totalWeight * leftGini - rightWeight / totalWeight * rightGini;
    }

    protected double computeGini(double[] dist, double total) {
        if (total == 0.0) {
            return 0.0;
        }
        double val = 0.0;
        for (int i = 0; i < dist.length; ++i) {
            val += dist[i] / total * (dist[i] / total);
        }
        return 1.0 - val;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.m_isLeaf) {
            if (instance.isMissing(this.m_Attribute)) {
                double[] returnedDist = new double[this.m_ClassProbs.length];
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    double[] help = this.m_Successors[i].distributionForInstance(instance);
                    if (help == null) continue;
                    for (int j = 0; j < help.length; ++j) {
                        int n = j;
                        returnedDist[n] = returnedDist[n] + this.m_Props[i] * help[j];
                    }
                }
                return returnedDist;
            }
            if (this.m_Attribute.isNominal()) {
                if (this.m_SplitString.indexOf("(" + this.m_Attribute.value((int)instance.value(this.m_Attribute)) + ")") != -1) {
                    return this.m_Successors[0].distributionForInstance(instance);
                }
                return this.m_Successors[1].distributionForInstance(instance);
            }
            if (instance.value(this.m_Attribute) < this.m_SplitValue) {
                return this.m_Successors[0].distributionForInstance(instance);
            }
            return this.m_Successors[1].distributionForInstance(instance);
        }
        return this.m_ClassProbs;
    }

    protected void makeLeaf(Instances data) {
        this.m_Attribute = null;
        this.m_isLeaf = true;
        this.m_ClassValue = Utils.maxIndex(this.m_ClassProbs);
        this.m_ClassAttribute = data.classAttribute();
    }

    public String toString() {
        if (this.m_ClassProbs == null && this.m_Successors == null) {
            return "CART Tree: No model built yet.";
        }
        return "CART Decision Tree\n" + this.toString(0) + "\n\n" + "Number of Leaf Nodes: " + this.numLeaves() + "\n\n" + "Size of the Tree: " + this.numNodes();
    }

    protected String toString(int level) {
        StringBuffer text = new StringBuffer();
        if (this.m_Attribute == null) {
            if (Instance.isMissingValue(this.m_ClassValue)) {
                text.append(": null");
            } else {
                double correctNum = (double)((int)(this.m_Distribution[Utils.maxIndex(this.m_Distribution)] * 100.0)) / 100.0;
                double wrongNum = (double)((int)((Utils.sum(this.m_Distribution) - this.m_Distribution[Utils.maxIndex(this.m_Distribution)]) * 100.0)) / 100.0;
                String str = "(" + correctNum + "/" + wrongNum + ")";
                text.append(": " + this.m_ClassAttribute.value((int)this.m_ClassValue) + str);
            }
        } else {
            for (int j = 0; j < 2; ++j) {
                text.append("\n");
                for (int i = 0; i < level; ++i) {
                    text.append("|  ");
                }
                if (j == 0) {
                    if (this.m_Attribute.isNumeric()) {
                        text.append(this.m_Attribute.name() + " < " + this.m_SplitValue);
                    } else {
                        text.append(this.m_Attribute.name() + "=" + this.m_SplitString);
                    }
                } else if (this.m_Attribute.isNumeric()) {
                    text.append(this.m_Attribute.name() + " >= " + this.m_SplitValue);
                } else {
                    text.append(this.m_Attribute.name() + "!=" + this.m_SplitString);
                }
                text.append(this.m_Successors[j].toString(level + 1));
            }
        }
        return text.toString();
    }

    public int numNodes() {
        if (this.m_isLeaf) {
            return 1;
        }
        int size = 1;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            size += this.m_Successors[i].numNodes();
        }
        return size;
    }

    public int numInnerNodes() {
        if (this.m_Attribute == null) {
            return 0;
        }
        int numNodes = 1;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            numNodes += this.m_Successors[i].numInnerNodes();
        }
        return numNodes;
    }

    protected Vector getInnerNodes() {
        Vector nodeList = new Vector();
        this.fillInnerNodes(nodeList);
        return nodeList;
    }

    protected void fillInnerNodes(Vector nodeList) {
        if (!this.m_isLeaf) {
            nodeList.add(this);
            for (int i = 0; i < this.m_Successors.length; ++i) {
                this.m_Successors[i].fillInnerNodes(nodeList);
            }
        }
    }

    public int numLeaves() {
        if (this.m_isLeaf) {
            return 1;
        }
        int size = 0;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            size += this.m_Successors[i].numLeaves();
        }
        return size;
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tThe minimal number of instances at the terminal nodes.\n\t(default 2)", "M", 1, "-M <min no>"));
        result.addElement(new Option("\tThe number of folds used in the minimal cost-complexity pruning.\n\t(default 5)", "N", 1, "-N <num folds>"));
        result.addElement(new Option("\tDon't use the minimal cost-complexity pruning.\n\t(default yes).", "U", 0, "-U"));
        result.addElement(new Option("\tDon't use the heuristic method for binary split.\n\t(default true).", "H", 0, "-H"));
        result.addElement(new Option("\tUse 1 SE rule to make pruning decision.\n\t(default no).", "A", 0, "-A"));
        result.addElement(new Option("\tPercentage of training data size (0-1].\n\t(default 1).", "C", 1, "-C"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('M', options);
        if (tmpStr.length() != 0) {
            this.setMinNumObj(Double.parseDouble(tmpStr));
        } else {
            this.setMinNumObj(2.0);
        }
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNumFoldsPruning(Integer.parseInt(tmpStr));
        } else {
            this.setNumFoldsPruning(5);
        }
        this.setUsePrune(!Utils.getFlag('U', options));
        this.setHeuristic(!Utils.getFlag('H', options));
        this.setUseOneSE(Utils.getFlag('A', options));
        tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setSizePer(Double.parseDouble(tmpStr));
        } else {
            this.setSizePer(1.0);
        }
        Utils.checkForRemainingOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-M");
        result.add("" + this.getMinNumObj());
        result.add("-N");
        result.add("" + this.getNumFoldsPruning());
        if (!this.getUsePrune()) {
            result.add("-U");
        }
        if (!this.getHeuristic()) {
            result.add("-H");
        }
        if (this.getUseOneSE()) {
            result.add("-A");
        }
        result.add("-C");
        result.add("" + this.getSizePer());
        return result.toArray(new String[result.size()]);
    }

    public Enumeration enumerateMeasures() {
        Vector<String> result = new Vector<String>();
        result.addElement("measureTreeSize");
        return result.elements();
    }

    public double measureTreeSize() {
        return this.numNodes();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (Cart pruning)");
    }

    public String minNumObjTipText() {
        return "The minimal number of observations at the terminal nodes (default 2).";
    }

    public void setMinNumObj(double value) {
        this.m_minNumObj = value;
    }

    public double getMinNumObj() {
        return this.m_minNumObj;
    }

    public String numFoldsPruningTipText() {
        return "The number of folds in the internal cross-validation (default 5).";
    }

    public void setNumFoldsPruning(int value) {
        this.m_numFoldsPruning = value;
    }

    public int getNumFoldsPruning() {
        return this.m_numFoldsPruning;
    }

    public String usePruneTipText() {
        return "Use minimal cost-complexity pruning (default yes).";
    }

    public void setUsePrune(boolean value) {
        this.m_Prune = value;
    }

    public boolean getUsePrune() {
        return this.m_Prune;
    }

    public String heuristicTipText() {
        return "If heuristic search is used for binary split for nominal attributes in multi-class problems (default yes).";
    }

    public void setHeuristic(boolean value) {
        this.m_Heuristic = value;
    }

    public boolean getHeuristic() {
        return this.m_Heuristic;
    }

    public String useOneSETipText() {
        return "Use the 1SE rule to make pruning decisoin.";
    }

    public void setUseOneSE(boolean value) {
        this.m_UseOneSE = value;
    }

    public boolean getUseOneSE() {
        return this.m_UseOneSE;
    }

    public String sizePerTipText() {
        return "The percentage of the training set size (0-1, 0 not included).";
    }

    public void setSizePer(double value) {
        if (value <= 0.0 || value > 1.0) {
            System.err.println("The percentage of the training set size must be in range 0 to 1 (0 not included) - ignored!");
        } else {
            this.m_SizePer = value;
        }
    }

    public double getSizePer() {
        return this.m_SizePer;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }

    public static void main(String[] args) {
        SimpleCart.runClassifier(new SimpleCart(), args);
    }
}

