/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.GainRatioAttributeEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.Ranker;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class RankSearch
extends ASSearch
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -7992268736874353755L;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private BitSet m_best_group;
    private ASEvaluation m_ASEval;
    private ASEvaluation m_SubsetEval;
    private Instances m_Instances;
    private double m_bestMerit;
    private int[] m_Ranking;
    protected int m_add = 1;
    protected int m_startPoint = 0;

    public String globalInfo() {
        return "RankSearch : \n\nUses an attribute/subset evaluator to rank all attributes. If a subset evaluator is specified, then a forward selection search is used to generate a ranked list. From the ranked list of attributes, subsets of increasing size are evaluated, ie. The best attribute, the best attribute plus the next best attribute, etc.... The best attribute set is reported. RankSearch is linear in the number of attributes if a simple attribute evaluator is used such as GainRatioAttributeEval. For more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Mark Hall and Geoffrey Holmes");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.TITLE, "Benchmarking attribute selection techniques for discrete class data mining");
        result.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Knowledge and Data Engineering");
        result.setValue(TechnicalInformation.Field.VOLUME, "15");
        result.setValue(TechnicalInformation.Field.NUMBER, "6");
        result.setValue(TechnicalInformation.Field.PAGES, "1437-1447");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "IEEE Computer Society");
        return result;
    }

    public RankSearch() {
        this.resetOptions();
    }

    public String attributeEvaluatorTipText() {
        return "Attribute evaluator to use for generating a ranking.";
    }

    public void setAttributeEvaluator(ASEvaluation newEvaluator) {
        this.m_ASEval = newEvaluator;
    }

    public ASEvaluation getAttributeEvaluator() {
        return this.m_ASEval;
    }

    public String stepSizeTipText() {
        return "Add this many attributes from the ranking in each iteration.";
    }

    public void setStepSize(int ss) {
        if (ss > 0) {
            this.m_add = ss;
        }
    }

    public int getStepSize() {
        return this.m_add;
    }

    public String startPointTipText() {
        return "Start evaluating from this point in the ranking.";
    }

    public void setStartPoint(int sp) {
        if (sp >= 0) {
            this.m_startPoint = sp;
        }
    }

    public int getStartPoint() {
        return this.m_startPoint;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tclass name of attribute evaluator to use for ranking. Place any\n\tevaluator options LAST on the command line following a \"--\".\n\teg.:\n\t\t-A weka.attributeSelection.GainRatioAttributeEval ... -- -M\n\t(default: weka.attributeSelection.GainRatioAttributeEval)", "A", 1, "-A <attribute evaluator>"));
        newVector.addElement(new Option("\tnumber of attributes to be added from the\n\tranking in each iteration (default = 1).", "S", 1, "-S <step size>"));
        newVector.addElement(new Option("\tpoint in the ranking to start evaluating from. \n\t(default = 0, ie. the head of the ranking).", "R", 1, "-R <start point>"));
        if (this.m_ASEval != null && this.m_ASEval instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to evaluator " + this.m_ASEval.getClass().getName() + ":"));
            Enumeration enu = ((OptionHandler)((Object)this.m_ASEval)).listOptions();
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('S', options);
        if (optionString.length() != 0) {
            this.setStepSize(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('R', options)).length() != 0) {
            this.setStartPoint(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('A', options)).length() == 0) {
            optionString = GainRatioAttributeEval.class.getName();
        }
        this.setAttributeEvaluator(ASEvaluation.forName(optionString, Utils.partitionOptions(options)));
    }

    public String[] getOptions() {
        String[] evaluatorOptions = new String[]{};
        if (this.m_ASEval != null && this.m_ASEval instanceof OptionHandler) {
            evaluatorOptions = ((OptionHandler)((Object)this.m_ASEval)).getOptions();
        }
        String[] options = new String[8 + evaluatorOptions.length];
        int current = 0;
        options[current++] = "-S";
        options[current++] = "" + this.getStepSize();
        options[current++] = "-R";
        options[current++] = "" + this.getStartPoint();
        if (this.getAttributeEvaluator() != null) {
            options[current++] = "-A";
            options[current++] = this.getAttributeEvaluator().getClass().getName();
        }
        if (evaluatorOptions.length > 0) {
            options[current++] = "--";
            System.arraycopy(evaluatorOptions, 0, options, current, evaluatorOptions.length);
            current += evaluatorOptions.length;
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    protected void resetOptions() {
        this.m_ASEval = new GainRatioAttributeEval();
        this.m_Ranking = null;
    }

    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        double best_merit = -1.7976931348623157E308;
        BitSet best_group = null;
        if (!(ASEval instanceof SubsetEvaluator)) {
            throw new Exception(ASEval.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        this.m_SubsetEval = ASEval;
        this.m_Instances = data;
        this.m_numAttribs = this.m_Instances.numAttributes();
        if (this.m_ASEval instanceof UnsupervisedAttributeEvaluator || this.m_ASEval instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = this.m_Instances.classIndex();
        }
        if (this.m_ASEval instanceof AttributeEvaluator) {
            Ranker ranker = new Ranker();
            this.m_ASEval.buildEvaluator(this.m_Instances);
            if (this.m_ASEval instanceof AttributeTransformer) {
                this.m_Instances = ((AttributeTransformer)((Object)this.m_ASEval)).transformedData(this.m_Instances);
                this.m_SubsetEval.buildEvaluator(this.m_Instances);
            }
            this.m_Ranking = ranker.search(this.m_ASEval, this.m_Instances);
        } else {
            GreedyStepwise fs = new GreedyStepwise();
            fs.setGenerateRanking(true);
            this.m_ASEval.buildEvaluator(this.m_Instances);
            fs.search(this.m_ASEval, this.m_Instances);
            double[][] rankres = fs.rankedAttributes();
            this.m_Ranking = new int[rankres.length];
            for (int i = 0; i < rankres.length; ++i) {
                this.m_Ranking[i] = (int)rankres[i][0];
            }
        }
        for (int i = this.m_startPoint; i < this.m_Ranking.length; i += this.m_add) {
            BitSet temp_group = new BitSet(this.m_numAttribs);
            for (int j = 0; j <= i; ++j) {
                temp_group.set(this.m_Ranking[j]);
            }
            double temp_merit = ((SubsetEvaluator)((Object)this.m_SubsetEval)).evaluateSubset(temp_group);
            if (!(temp_merit > best_merit)) continue;
            best_merit = temp_merit;
            best_group = temp_group;
        }
        this.m_bestMerit = best_merit;
        return this.attributeList(best_group);
    }

    private int[] attributeList(BitSet group) {
        int count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            ++count;
        }
        int[] list = new int[count];
        count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            list[count++] = i;
        }
        return list;
    }

    public String toString() {
        int i;
        StringBuffer text = new StringBuffer();
        text.append("\tRankSearch :\n");
        text.append("\tAttribute evaluator : " + this.getAttributeEvaluator().getClass().getName() + " ");
        if (this.m_ASEval instanceof OptionHandler) {
            String[] evaluatorOptions = new String[]{};
            evaluatorOptions = ((OptionHandler)((Object)this.m_ASEval)).getOptions();
            for (i = 0; i < evaluatorOptions.length; ++i) {
                text.append(evaluatorOptions[i] + ' ');
            }
        }
        text.append("\n");
        text.append("\tAttribute ranking : \n");
        int rlength = (int)(Math.log(this.m_Ranking.length) / Math.log(10.0) + 1.0);
        for (i = 0; i < this.m_Ranking.length; ++i) {
            text.append("\t " + Utils.doubleToString(this.m_Ranking[i] + 1, rlength, 0) + " " + this.m_Instances.attribute(this.m_Ranking[i]).name() + '\n');
        }
        text.append("\tMerit of best subset found : ");
        int fieldwidth = 3;
        double precision = this.m_bestMerit - (double)((int)this.m_bestMerit);
        if (Math.abs(this.m_bestMerit) > 0.0) {
            fieldwidth = (int)Math.abs(Math.log(Math.abs(this.m_bestMerit)) / Math.log(10.0)) + 2;
        }
        precision = Math.abs(precision) > 0.0 ? Math.abs(Math.log(Math.abs(precision)) / Math.log(10.0)) + 3.0 : 2.0;
        text.append(Utils.doubleToString(Math.abs(this.m_bestMerit), fieldwidth + (int)precision, (int)precision) + "\n");
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6253 $");
    }
}

