/*
 * Picviz - Parallel coordinates ploter
 * Copyright (C) 2008 Sebastien Tricaud <toady@gscore.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $Id: debug.h 369 2008-12-22 00:24:39Z toady $
 */

#ifndef _DEBUG_H_
#define _DEBUG_H_

#include <picviz.h>

#ifdef __cplusplus
 extern "C" {
#endif

#define PICVIZ_DEBUG_NOTICE   0x0001
#define PICVIZ_DEBUG_WARNING  0x0002
#define PICVIZ_DEBUG_CRITICAL 0x0004

#define PICVIZ_AREA_CORE   0x0001
#define PICVIZ_AREA_PLUGIN 0x0002
#define PICVIZ_AREA_RENDER 0x0004
#define PICVIZ_AREA_PARSER 0x0008

void picviz_debug(int level, int area, const char *format, ...);
void picviz_debug_print_axisplot(PicvizAxisPlot *ap);

#ifdef __cplusplus
 }
#endif

#endif /* _DEBUG_H_ */
