// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtCurve2DWriter.h                            //
// ************************************************************************* //

#ifndef AVT_CURVE2D_WRITER_H
#define AVT_CURVE2D_WRITER_H

#include <avtDatabaseWriter.h>

#include <string>

class DBOptionsAttributes;

// ****************************************************************************
//  Class: avtCurve2DWriter
//
//  Purpose:
//      A module that writes out Curve2D files.
//
//  Programmer: whitlock2 -- generated by xml2avt
//  Creation:   Thu Jul 26 16:32:43 PST 2012
//
//  Modifications:
//    Kathleen Biagas, Fri Aug 31 14:18:02 PDT 2018
//    Added commentStyle Write Option.
//
// ****************************************************************************

class
avtCurve2DWriter : public avtDatabaseWriter
{
  public:
                   avtCurve2DWriter(DBOptionsAttributes *);
    virtual       ~avtCurve2DWriter() {;}

  protected:
    std::string    stem;
    int            nBlocks;
    std::string    commentStyle;

    virtual void   OpenFile(const std::string &, int nb);
    virtual void   WriteHeaders(const avtDatabaseMetaData *,
                                const std::vector<std::string> &, 
                                const std::vector<std::string> &,
                                const std::vector<std::string> &);
    virtual void   WriteChunk(vtkDataSet *, int);
    virtual void   CloseFile(void);

    std::string    SanitizeName(const std::string &name) const;
};


#endif
