###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for CDE dtlogin HPSBUX01038
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835071);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "01038");
  script_name( "HP-UX Update for CDE dtlogin HPSBUX01038");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  CDE dtlogin software, where the potential vulnerability may be exploited 
  locally or remotely to allow unauthorized privileged access or a Denial of 
  Service (DoS). 

  Impact:
  Remote unauthorized privileged access
  denial of service (DoS)

  Affected Software/OS:
  CDE dtlogin on
  HP-UX B.11.00, B.11.04, B.11.11, B.11.22, and B.11.23 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00957752-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of CDE dtlogin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_30670'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_30671'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_30807'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_30668'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_30669'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}