#
#ADV FreeBSD-SA-05:17.devfs.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(54382);
 script_bugtraq_id(14334);
 script_cve_id("CVE-2005-2218");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Security Advisory (FreeBSD-SA-05:17.devfs.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-05:17.devfs.asc

The jail(2) system call allows a system administrator to lock a process
and all of its descendants inside an environment with a very limited
ability to affect the system outside that environment, even for
processes with superuser privileges.  It is an extension of, but
far more powerful than, the traditional UNIX chroot(2) system call.

The device file system, or devfs(5), provides access to kernel's device
namespace in the global file system namespace.  This includes access to
to system devices such as storage devices, kernel and system memory
devices, BPF devices, and serial port devices.  Devfs is is generally
mounted as /dev.  Devfs rulesets allow an administrator to hide
certain device nodes; this is most commonly applied to a devfs mounted
for use inside a jail, in order to make devices inaccessible to
processes within that jail.

Due to insufficient parameter checking of the node type during device
creation, any user can expose hidden device nodes on devfs mounted
file systems within their jail.  Device nodes will be created in the
jail with their normal default access permissions.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-05:17.devfs.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-05:17.devfs.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"5.4", patchlevel:"5")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.3", patchlevel:"19")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
