# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 519-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53209);
 script_cve_id("CVE-2004-0416", "CVE-2004-0417", "CVE-2004-0418");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 519-1 (cvs)";
 script_name(name);

 desc = "The remote host is missing an update to cvs
announced via advisory DSA 519-1.

Sebastian Krahmer and Stefan Esser discovered several vulnerabilities
in the CVS server, which serves the popular Concurrent Versions
System.  The Common Vulnerability and Exposures project identifies the
following problems:

CVE-2004-0416: double-free() in error_prog_name

CVE-2004-0417: argument integer overflow

CVE-2004-0418: out of bound writes in serve_notify()

For the stable distribution (woody) this problem has been fixed in
version 1.11.1p1debian-9woody7.

For the unstable distribution (sid) this problem has been fixed in
version 1.12.9-1.

We recommend that you upgrade your cvs package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20519-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 519-1 (cvs)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cvs", ver:"1.11.1p1debian-9woody7", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
