# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1318-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58424);
 script_cve_id("CVE-2005-2370", "CVE-2005-2448", "CVE-2007-1663", "CVE-2007-1664", "CVE-2007-1665");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1318-1 (ekg)";
 script_name(name);

 desc = "The remote host is missing an update to ekg
announced via advisory DSA 1318-1.

Several remote vulnerabilities have been discovered in ekg, a console
Gadu Gadu client. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2005-2370

It was discovered that memory alignment errors may allow remote
attackers to cause a denial of service on certain architectures
such as sparc. This only affects Debian Sarge.

CVE-2005-2448

It was discovered that several endianess errors may allow remote
attackers to cause a denial of service. This only affects
Debian Sarge.

CVE-2007-1663

It was discovered that a memory leak in handling image messages may
lead to denial of service. This only affects Debian Etch.

CVE-2007-1664

It was discovered that a null pointer deference in the token OCR code
may lead to denial of service. This only affects Debian Etch.

CVE-2007-1665

It was discovered that a memory leak in the token OCR code may lead
to denial of service. This only affects Debian Etch.

For the oldstable distribution (sarge) these problems have been fixed in
version 1.5+20050411-7. This updates lacks updated packages for the m68k
architecture. They will be provided later.

For the stable distribution (etch) these problems have been fixed
in version 1:1.7~rc2-1etch1.

For the unstable distribution (sid) these problems have been fixed in
version 1:1.7~rc2-2.

We recommend that you upgrade your ekg packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201318-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1318-1 (ekg)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ekg", ver:"1.5+20050411-7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgadu-dev", ver:"1.5+20050411-7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgadu3", ver:"1.5+20050411-7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ekg", ver:"1.7~rc2-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgadu-dev", ver:"1.7~rc2-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgadu3", ver:"1.7~rc2-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
