# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 118-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53576);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 118-1 (xsane)";
 script_name(name);

 desc = "The remote host is missing an update to xsane
announced via advisory DSA 118-1.

Tim Waugh found several insecure uses of temporary files in the xsane
program, which is used for scanning.  This was fixed for Debian/stable
by moving those files into a securely created directory within the
/tmp directory.

This problem has been fixed in version 0.50-5.1 for the stable Debian
distribution and in version 0.84-0.1 for the testing and unstable
distribution of Debian.

We recommend that you upgrade your xsane package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20118-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 118-1 (xsane)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xsane", ver:"0.50-5.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
