/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "BrushWrap_p.h"

#include <cmath>

#include <GTLCore/wrappers/Allocate.h>
#include <GTLFragment/wrappers/ColorWrap_p.h>

#include <OpenRijn/AbstractBrush.h>
#include <OpenRijn/AbstractCanvas.h>

#include "CanvasWrap_p.h"
#include <DrawingPoint.h>
#include <AbstractCanvas_p.h>

BrushWrap* wrapBrush(OpenRijn::AbstractBrush* brush)
{
  BrushWrap* b = gtlAllocate<BrushWrap>();
  b->brush = brush;
  wrapColor(b->paintColor, 0,0,0,1);
  brush->setPaintColor(colorWrapToGTLCoreColor(b->paintColor));
  return b;
}
#include<iostream>
inline void sync_brush(BrushWrap* brush)
{
  brush->brush->setPaintColor(colorWrapToGTLCoreColor(brush->paintColor));
}

extern "C" {
void brush_wrap_draw_point(BrushWrap* brush, CanvasWrap* canvas, float x, float y, float t1, float angle)
{
  sync_brush(brush);
  OpenRijn::AbstractCanvas::Private* c_d = canvas->canvas->d;
  OpenRijn::DrawingPoint pt(x, y, t1, angle);
  float sp = brush->brush->drawPoint(canvas->canvas, pt);
  c_d->lastInfo.distance = 0.0;
  c_d->lastInfo.spacing = sp;
  c_d->lastPt = pt;
}

void brush_wrap_draw_line(BrushWrap* brush, CanvasWrap* canvas, float x1, float y1, float t1, float x2, float y2, float t2)
{
  sync_brush(brush);
  OpenRijn::AbstractCanvas::Private* c_d = canvas->canvas->d;
  OpenRijn::DistanceInformation info;
  if( std::fabs(x1 - c_d->lastPt.x) < 0.01 and std::fabs(y1 - c_d->lastPt.y) < 0.01)
  {
    info = c_d->lastInfo;
  }
  OpenRijn::DrawingPoint pt2(x2, y2, t2, 0.0);
  c_d->lastInfo = brush->brush->drawLine(canvas->canvas, OpenRijn::DrawingPoint(x1, y1, t1, 0.0), pt2, info);
  c_d->lastPt = pt2;
}

void brush_wrap_draw_line_to(BrushWrap* brush, CanvasWrap* canvas, float x2, float y2, float t2)
{
  sync_brush(brush);
  OpenRijn::AbstractCanvas::Private* c_d = canvas->canvas->d;
  OpenRijn::DistanceInformation info = c_d->lastInfo;
  OpenRijn::DrawingPoint pt2(x2, y2, t2, 0.0);
  c_d->lastInfo = brush->brush->drawLine(canvas->canvas, c_d->lastPt, pt2, info);
  c_d->lastPt = pt2;
}

}
