#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_PowerManagementService.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_PowerManagementService provider module";
Name = "PowerManagement_OpenDRIM_PowerManagementServiceModule";
Location = "cmpiPowerManagement_OpenDRIM_PowerManagementServiceProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_PowerManagementService provider";
Name = "PowerManagement_OpenDRIM_PowerManagementServiceProvider";
ProviderModuleName = "PowerManagement_OpenDRIM_PowerManagementServiceModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_PowerManagementService provider capabilities";
ProviderModuleName = "PowerManagement_OpenDRIM_PowerManagementServiceModule";
ProviderName = "PowerManagement_OpenDRIM_PowerManagementServiceProvider";
ClassName = "OpenDRIM_PowerManagementService";
ProviderType = {2, 5};
Namespaces = {"$1"};
SupportedProperties = {"InstanceID", "Caption", "Description", "ElementName", "InstallDate", "OperationalStatus", "StatusDescriptions", "Status", "HealthState", "CommunicationStatus", "DetailedStatus", "OperatingStatus", "PrimaryStatus", "EnabledState", "OtherEnabledState", "RequestedState", "EnabledDefault", "TimeOfLastStateChange", "AvailableRequestedStates", "TransitioningToState", "SystemCreationClassName", "SystemName", "CreationClassName", "Name", "PrimaryOwnerName", "PrimaryOwnerContact", "StartMode", "Started"};
SupportedMethods = {"RequestStateChange", "StartService", "StopService", "SetPowerState", "RequestPowerStateChange"};
CapabilityID = "PowerManagement_OpenDRIM_PowerManagementService";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_PowerManagementService.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_PowerManagementService]   
   provider: PowerManagement_OpenDRIM_PowerManagementServiceProvider
   location: cmpiPowerManagement_OpenDRIM_PowerManagementServiceProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_PowerManagementService.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_PowerManagementService-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_PowerManagementService.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
