/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_OPERATINGSYSTEMSTATISTICS_H_
#define OPENDRIM_OPERATINGSYSTEMSTATISTICS_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiOpenDRIM_OperatingSystem.h"
#include "OpenDRIM_OperatingSystemAccess.h"
#include "cmpiOpenDRIM_OperatingSystemLoadAverages.h"
#include "OpenDRIM_OperatingSystemLoadAveragesAccess.h"
*/

const static char* OpenDRIM_OperatingSystemStatistics_classnames[] = {"OpenDRIM_OperatingSystemStatistics"};
static string OpenDRIM_OperatingSystemStatistics_NAMESPACE = _NAMESPACE;
const static string Element_role = "Element";
const static char* Element_classnames[] = {"OpenDRIM_OperatingSystem"};
const static string Element_NAMESPACE = _NAMESPACE;

const static string Stats_role = "Stats";
const static char* Stats_classnames[] = {"OpenDRIM_OperatingSystemLoadAverages"};
const static string Stats_NAMESPACE = _NAMESPACE;

class OpenDRIM_OperatingSystemStatistics {

public:
	
	Objectpath Stats;
	bool Stats_isNULL;
	
	Objectpath Element;
	bool Element_isNULL;
	
	OpenDRIM_OperatingSystemStatistics() {
		Stats_isNULL = true;
		Element_isNULL = true;
	}
	
	~OpenDRIM_OperatingSystemStatistics() {}
	
	string getKeys() const {
		return CF_toLowCase(".Stats=\"" + CF_quoteString(Stats.toString()) + "\""".Element=\"" + CF_quoteString(Element.toString()) + "\"");
	}

	int getStats(Objectpath& value) const {
		if (Stats_isNULL==true)
			return NOT_FOUND;
		value = Stats;
		return OK;
	}
	
	int setStats(const Objectpath& newValue) {
		Stats = newValue;
		Stats.setNamespace(Stats_NAMESPACE);
		Stats_isNULL = false;
		return OK;
	}

	int getElement(Objectpath& value) const {
		if (Element_isNULL==true)
			return NOT_FOUND;
		value = Element;
		return OK;
	}
	
	int setElement(const Objectpath& newValue) {
		Element = newValue;
		Element.setNamespace(Element_NAMESPACE);
		Element_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_OPERATINGSYSTEMSTATISTICS_H_*/
