/*
Script: Language.de.js
	MooTools FileManager - Language Strings in German

Translation:
	[Christoph Pojer](http://cpojer.net)
*/

FileManager.Language.de = {
	more: 'Details',
	width: 'Breite:',
	height: 'Höhe:',
	
	ok: 'Ok',
	open: 'Datei wählen',
	upload: 'Datei hochladen',
	create: 'Ordner erstellen',
	createdir: 'Bitte gib einen Ordnernamen ein:',
	cancel: 'Abbrechen',
	
	information: 'Information',
	type: 'Typ:',
	size: 'Größe:',
	dir: 'Verzeichnis:',
	modified: 'Zuletzt bearbeitet:',
	preview: 'Vorschau',
	close: 'Schließen',
	destroy: 'Löschen',
	destroyfile: 'Bist du sicher, dass du diese Datei löschen möchtest?',
	
	rename: 'Umbenennen',
	renamefile: 'Gib einen neuen Dateinamen ein:',
	
	download: 'Download',
	nopreview: '<i>Keine Vorschau verfügbar</i>',
	
	title: 'Titel:',
	artist: 'Artist:',
	album: 'Album:',
	length: 'Länge:',
	bitrate: 'Bitrate:',
	
	deselect: 'Entfernen',
	
	nodestroy: 'Dateien löschen wurde auf diesem Server deaktiviert.',
	
	'upload.disabled': 'Der Datei-Upload wurde auf diesem Server deaktiviert.',
	'upload.authenticated': 'Upload fehlgeschlagen: Du bist nicht authentifiziert.',
	'upload.path': 'Der angegebene Upload-Ordner existiert nicht. Bitte kontaktiere den Administrator dieser Website.',
	'upload.exists': 'Der angegebene Upload-Speicherort existiert bereits. Bitte kontaktiere den Administrator dieser Website.',
	'upload.mime': 'Der angegebene Dateityp ist nicht erlaubt.',
	'upload.extension': 'Die Datei hat eine unbekannte oder unerlaubte Datei-Erweiterung.',
	'upload.size': 'Die Datei, die du hochgeladen hast, ist zu groß um sie auf diesem Server zu verarbeiten. Bitte lade eine kleinere Datei hoch.',
	'upload.partial': 'Die Datei wurde nur teilweise hochgeladen. Bitte lade sie erneut hoch.',
	'upload.nofile': 'Es wurde keine Datei hochgeladen.',
	'upload.default': 'Der Datei-Upload ist fehlgeschlagen.',
	
	/* FU */
	uploader: {
		unknown: 'Unbekannter Fehler',
		sizeLimitMin: 'Die Datei "<em>${name}</em>" (${size}), ist zu klein. Minimaldateigröße: <strong>${size_min}</strong>!',
		sizeLimitMax: 'Die Datei "<em>${name}</em>" (${size}), ist zu groß. Dateigrößen-Limit: <strong>${size_max}</strong>!'
	},
	
	flash: {
		hidden: 'Um den Uploader benutzen zu können, muss er im Browser freigegeben werden und die Seite muss neu geladen werden (Adblock).',
		disabled: 'Um den Uploader benutzen zu können, muss die geblockte Flash Datei freigegeben werden und die Seite muss neu geladen werden (Flashblock).',
		flash: 'Um Dateien hochzuladen muss <a href="http://www.adobe.com/shockwave/download/download.cgi?P1_Prod_Version=ShockwaveFlash">Adobe Flash</a> installiert werden.'
	},
	
	resizeImages: 'Große Bilder bei Upload verkleinern',

	serialize: 'Galerie speichern',
	gallery: {
		text: 'Bildtext',
		save: 'Speichern',
		remove: 'Entfernen',
		drag: 'Verschiebe Bilder in diesen Bereich um eine Galerie zu erstellen...'
	}
};