/***************************************************************************
                          fileio_opts.h  -  description
                             -------------------
    begin                : Mon Nov 13 2006
    copyright            : (C) 2001 by Thies Jochimsen
    email                : jochimse@cns.mpg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEIO_OPTS_H
#define FILEIO_OPTS_H

#include <odinpara/jdxblock.h>
#include <odinpara/jdxtypes.h>
#include <odinpara/jdxnumbers.h>

/**
  * @addtogroup odindata
  * @{
  */

/**
  * Options for autoread
  */
struct FileReadOpts : JcampDxBlock {

  FileReadOpts();

  JDXenum   format;
  JDXstring jdx;
  JDXenum   cplx;
  JDXint    skip;
  JDXstring dset;
  JDXstring filter;
  JDXstring dialect;
  JDXbool   fmap;
};

//////////////////////////////////////////////////////////////////////////

/**
  * Options for autowrite
  */
struct FileWriteOpts : JcampDxBlock {

  FileWriteOpts();

  JDXenum   format;
  JDXbool   append;
  JDXstring wprot;
  JDXbool   split;
  JDXstring dialect;
  JDXenum   datatype;
  JDXstring fnamepar;
};



/** @}
  */



#endif
