%%NAME
%%  ecolor2gray  - convert colormap to graymap
%%
%%SYNOPSIS
%%  grayMap=ecolor2gray(colorMap)
%%
%%PARAMETER(S)
%%  colorMap    RGB colormap
%%  grayMap     RGB graymap
%% 
% written by stefan.mueller@fhr.fraunhofer.de (C) 2012
function grayMap= ecolor2gray(colorMap)
  if (nargin<1)
    eusage('grayMap = ecolor2gray(colorMap)');
  end
  minValue=min(min(colorMap))
  maxValue=max(max(colorMap))
  if (minValue>=0) && (maxValue<=1) 
    gray=(colorMap(:,1)+colorMap(:,2)+colorMap(:,3))/3;
    grayMap=[gray gray gray];
  end
