// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESSolid_SphericalSurface_HeaderFile
#define _IGESSolid_SphericalSurface_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IGESSolid_SphericalSurface.hxx>

#include <Handle_IGESGeom_Point.hxx>
#include <Standard_Real.hxx>
#include <Handle_IGESGeom_Direction.hxx>
#include <IGESData_IGESEntity.hxx>
#include <Standard_Boolean.hxx>
class IGESGeom_Point;
class IGESGeom_Direction;
class gp_Pnt;


//! defines SphericalSurface, Type <196> Form Number <0,1>
//! in package IGESSolid
//! Spherical surface is defined by a center and radius.
//! In case of parametrised surface an axis and a
//! reference direction is provided.
class IGESSolid_SphericalSurface : public IGESData_IGESEntity
{

public:

  
  Standard_EXPORT IGESSolid_SphericalSurface();
  
  //! This method is used to set the fields of the class
  //! SphericalSurface
  //! - aCenter : the coordinates of the center point
  //! - aRadius : value of radius
  //! - anAxis  : the direction of the axis
  //! Null in case of Unparametrised surface
  //! - aRefdir : the reference direction
  //! Null in case of Unparametrised surface
  Standard_EXPORT   void Init (const Handle(IGESGeom_Point)& aCenter, const Standard_Real aRadius, const Handle(IGESGeom_Direction)& anAxis, const Handle(IGESGeom_Direction)& aRefdir) ;
  
  //! returns the center of the spherical surface
  Standard_EXPORT   Handle(IGESGeom_Point) Center()  const;
  
  //! returns the center of the spherical surface after applying
  //! TransformationMatrix
  Standard_EXPORT   gp_Pnt TransformedCenter()  const;
  
  //! returns the radius of the spherical surface
  Standard_EXPORT   Standard_Real Radius()  const;
  
  //! returns the direction of the axis (Parametrised surface)
  //! Null is returned if the surface is not parametrised
  Standard_EXPORT   Handle(IGESGeom_Direction) Axis()  const;
  
  //! returns the reference direction (Parametrised surface)
  //! Null is returned if the surface is not parametrised
  Standard_EXPORT   Handle(IGESGeom_Direction) ReferenceDir()  const;
  
  //! Returns True if the surface is parametrised, else False
  Standard_EXPORT   Standard_Boolean IsParametrised()  const;




  DEFINE_STANDARD_RTTI(IGESSolid_SphericalSurface)

protected:




private: 


  Handle(IGESGeom_Point) theCenter;
  Standard_Real theRadius;
  Handle(IGESGeom_Direction) theAxis;
  Handle(IGESGeom_Direction) theRefDir;


};







#endif // _IGESSolid_SphericalSurface_HeaderFile
