# Snapshot report for `tests/cli.js`

The actual snapshot is saved in `cli.js.snap`.

Generated by [AVA](https://avajs.dev).

## run `cli --help`

> Should report help menu.

    {
      args: [
        '--help',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `Usage: sort-package-json [options] [file/glob ...]␊
        ␊
        Sort package.json files.␊
        If file/glob is omitted, './package.json' file will be processed.␊
        ␊
          -c, --check   Check if files are sorted␊
          -q, --quiet   Don't output success messages␊
          -h, --help    Display this help␊
          -v, --version Display the package version␊
          --stdin       Read package.json from stdin␊
          ␊
        `,
      },
    }

## run `cli --help --quiet`

> Should report help menu overriding quiet.

    {
      args: [
        '--help',
        '--quiet',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `Usage: sort-package-json [options] [file/glob ...]␊
        ␊
        Sort package.json files.␊
        If file/glob is omitted, './package.json' file will be processed.␊
        ␊
          -c, --check   Check if files are sorted␊
          -q, --quiet   Don't output success messages␊
          -h, --help    Display this help␊
          -v, --version Display the package version␊
          --stdin       Read package.json from stdin␊
          ␊
        `,
      },
    }

## run `cli -h`

> Should support help alias.

    {
      args: [
        '-h',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `Usage: sort-package-json [options] [file/glob ...]␊
        ␊
        Sort package.json files.␊
        If file/glob is omitted, './package.json' file will be processed.␊
        ␊
          -c, --check   Check if files are sorted␊
          -q, --quiet   Don't output success messages␊
          -h, --help    Display this help␊
          -v, --version Display the package version␊
          --stdin       Read package.json from stdin␊
          ␊
        `,
      },
    }

## run `cli --help` with other arguments

> Should prioritize help argument.

    {
      args: [
        'NONE_EXISTS_FILE',
        '--help',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `Usage: sort-package-json [options] [file/glob ...]␊
        ␊
        Sort package.json files.␊
        If file/glob is omitted, './package.json' file will be processed.␊
        ␊
          -c, --check   Check if files are sorted␊
          -q, --quiet   Don't output success messages␊
          -h, --help    Display this help␊
          -v, --version Display the package version␊
          --stdin       Read package.json from stdin␊
          ␊
        `,
      },
    }

## run `cli --version`

> Should report version number.

    {
      args: [
        '--version',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `sort-package-json 0.0.0-development␊
        `,
      },
    }

## run `cli --version --quiet`

> Should report version overriding quiet.

    {
      args: [
        '--version',
        '--quiet',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `sort-package-json 0.0.0-development␊
        `,
      },
    }

## run `cli -v`

> Should support version alias.

    {
      args: [
        '-v',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `sort-package-json 0.0.0-development␊
        `,
      },
    }

## run `cli --version` with other arguments

> Should prioritize version argument.

    {
      args: [
        'NONE_EXISTS_FILE',
        '--version',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `sort-package-json 0.0.0-development␊
        `,
      },
    }

## run `cli --help` with `--version`

> Should prioritize help over version.

    {
      args: [
        '--version',
        '--help',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `Usage: sort-package-json [options] [file/glob ...]␊
        ␊
        Sort package.json files.␊
        If file/glob is omitted, './package.json' file will be processed.␊
        ␊
          -c, --check   Check if files are sorted␊
          -q, --quiet   Don't output success messages␊
          -h, --help    Display this help␊
          -v, --version Display the package version␊
          --stdin       Read package.json from stdin␊
          ␊
        `,
      },
    }

## run `cli` with no patterns

> Should format package.json.

    {
      args: [],
      fixtures: [
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `package.json is sorted!␊
        ␊
        Found 1 file.␊
        1 file successfully sorted.␊
        `,
      },
    }

## run `cli --quiet` with no patterns

> Should format package.json without message.

    {
      args: [
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: null,
        stderr: '',
        stdout: '',
      },
    }

## run `cli -q` with no patterns

> Should support -q alias.

    {
      args: [
        '-q',
      ],
      fixtures: [
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: null,
        stderr: '',
        stdout: '',
      },
    }

## run `cli --check` with no patterns

> Should not sort package.json

    {
      args: [
        '--check',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: `package.json␊
        ␊
        Found 1 file.␊
        1 file was not sorted.␊
        `,
      },
    }

## run `cli --check --quiet` with no patterns

> Should not sort package.json or report a message.

    {
      args: [
        '--check',
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: '',
      },
    }

## run `cli -c` with no patterns

> Should support `-c` alias

    {
      args: [
        '-c',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: `package.json␊
        ␊
        Found 1 file.␊
        1 file was not sorted.␊
        `,
      },
    }

## run `cli -c -q` with no patterns

> Should support `-q` alias

    {
      args: [
        '-c',
        '-q',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: '',
      },
    }

## run `cli` on 1 bad file

> Should format 1 file.

    {
      args: [
        '*/package.json',
      ],
      fixtures: [
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `bad/package.json is sorted!␊
        ␊
        Found 1 file.␊
        1 file successfully sorted.␊
        `,
      },
    }

## run `cli --quiet` on 1 bad file

> Should format 1 file without message.

    {
      args: [
        '*/package.json',
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: null,
        stderr: '',
        stdout: '',
      },
    }

## run `cli --check` on 1 bad file

> Should report 1 file.

    {
      args: [
        '*/package.json',
        '--check',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: `bad/package.json␊
        ␊
        Found 1 file.␊
        1 file was not sorted.␊
        `,
      },
    }

## run `cli --check --quiet` on 1 bad file

> Should exit code 1 without report.

    {
      args: [
        '*/package.json',
        '--check',
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: '',
      },
    }

## run `cli` on 2 bad files

> Should format 2 files.

    {
      args: [
        '*/package.json',
      ],
      fixtures: [
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad-2/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `bad-1/package.json is sorted!␊
        bad-2/package.json is sorted!␊
        ␊
        Found 2 files.␊
        2 files successfully sorted.␊
        `,
      },
    }

## run `cli --check` on 2 bad files

> Should report 2 files.

    {
      args: [
        '*/package.json',
        '--check',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad-2/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: `bad-1/package.json␊
        bad-2/package.json␊
        ␊
        Found 2 files.␊
        2 files were not sorted.␊
        `,
      },
    }

## run `cli --quiet` on 2 bad files

> Should format 2 files without messages.

    {
      args: [
        '*/package.json',
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad-2/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: null,
        stderr: '',
        stdout: '',
      },
    }

## run `cli --check --quiet` on 2 bad files

> Should exit code 2.

    {
      args: [
        '*/package.json',
        '--check',
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad-2/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: '',
      },
    }

## run `cli` on 2 good files and 2 bad files

> Should format 2 files.

    {
      args: [
        '*/package.json',
      ],
      fixtures: [
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad-2/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-1/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-2/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
      ],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `bad-1/package.json is sorted!␊
        bad-2/package.json is sorted!␊
        ␊
        Found 4 files.␊
        2 files successfully sorted.␊
        2 files were already sorted.␊
        `,
      },
    }

## run `cli --quiet` on 2 good files and 2 bad files

> Should format 2 files.

    {
      args: [
        '*/package.json',
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad-2/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-1/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-2/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
      ],
      result: {
        errorCode: null,
        stderr: '',
        stdout: '',
      },
    }

## run `cli --check` on 2 good files and 2 bad files

> Should report 2 files.

    {
      args: [
        '*/package.json',
        '--check',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad-2/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-1/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-2/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: `bad-1/package.json␊
        bad-2/package.json␊
        ␊
        Found 4 files.␊
        2 files were not sorted.␊
        2 files were already sorted.␊
        `,
      },
    }

## run `cli --check --quiet` on 2 good files and 2 bad files

> Should exit code 2.

    {
      args: [
        '*/package.json',
        '--check',
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad-2/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-1/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-2/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: '',
      },
    }

## run `cli` on none exists file

> Should report no files matching.

    {
      args: [
        'NONE_EXISTS_FILE',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 2,
        stderr: `No matching files.␊
        `,
        stdout: '',
      },
    }

## run `cli --quiet` on none exists file

> Should report no files matching.

    {
      args: [
        'NONE_EXISTS_FILE',
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 2,
        stderr: `No matching files.␊
        `,
        stdout: '',
      },
    }

## run `cli --check` on none exists file

> Should report no files matching.

    {
      args: [
        'NONE_EXISTS_FILE',
        '--check',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 2,
        stderr: `No matching files.␊
        `,
        stdout: '',
      },
    }

## run `cli --check --quiet` on none exists file

> Should report no files matching regardless of quiet.

    {
      args: [
        'NONE_EXISTS_FILE',
        '--check',
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
      ],
      result: {
        errorCode: 2,
        stderr: `No matching files.␊
        `,
        stdout: '',
      },
    }

## run `cli` on duplicate patterns

> Should not format `bad-1/package.json` more than once.

    {
      args: [
        'bad-1/package.json',
        'bad-1/package.json',
        'bad-*/package.json',
        '*/package.json',
      ],
      fixtures: [
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-1/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-2/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
      ],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `bad-1/package.json is sorted!␊
        ␊
        Found 3 files.␊
        1 file successfully sorted.␊
        2 files were already sorted.␊
        `,
      },
    }

## run `cli --check` on duplicate patterns

> Should not list `bad-1/package.json` more than once.

    {
      args: [
        'bad-1/package.json',
        'bad-1/package.json',
        'bad-*/package.json',
        '*/package.json',
        '--check',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-1/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-2/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: `bad-1/package.json␊
        ␊
        Found 3 files.␊
        1 file was not sorted.␊
        2 files were already sorted.␊
        `,
      },
    }

## run `cli --check --quiet` on duplicate patterns

> Should not count `bad-1/package.json` more than once. Exit code 1

    {
      args: [
        'bad-1/package.json',
        'bad-1/package.json',
        'bad-*/package.json',
        '*/package.json',
        '--check',
        '--quiet',
      ],
      fixtures: [
        {
          expect: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
          file: 'bad-1/package.json',
          original: `{␊
            "version": "1.0.0",␊
            "name": "sort-package-json"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-1/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
        {
          expect: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
          file: 'good-2/package.json',
          original: `{␊
            "name": "sort-package-json",␊
            "version": "1.0.0"␊
          }`,
        },
      ],
      result: {
        errorCode: 1,
        stderr: '',
        stdout: '',
      },
    }

## run `cli --check` on 1 non-json file

> Should fail to check, but not end execution.

    {
      args: [
        '*/package.json',
        '--check',
      ],
      fixtures: [
        {
          expect: '',
          file: 'notJson/package.json',
          original: '',
        },
      ],
      result: {
        errorCode: 2,
        stderr: `Error on: notJson/package.json␊
        Unexpected end of JSON input␊
        `,
        stdout: `␊
        Found 1 file.␊
        1 file could not be checked.␊
        `,
      },
    }

## run `cli --check --quiet` on 1 non-json file

> Should output error message, but not count.

    {
      args: [
        '*/package.json',
        '--check',
        '--quiet',
      ],
      fixtures: [
        {
          expect: '',
          file: 'notJson/package.json',
          original: '',
        },
      ],
      result: {
        errorCode: 2,
        stderr: `Error on: notJson/package.json␊
        `,
        stdout: '',
      },
    }

## run `cli` on 1 non-json file

> Should fail to check, but not end execution.

    {
      args: [
        '*/package.json',
      ],
      fixtures: [
        {
          expect: '',
          file: 'notJson/package.json',
          original: '',
        },
      ],
      result: {
        errorCode: 2,
        stderr: `Error on: notJson/package.json␊
        Unexpected end of JSON input␊
        `,
        stdout: `␊
        Found 1 file.␊
        1 file could not be sorted.␊
        `,
      },
    }

## run `cli --quiet` on 1 non-json file

> Should output error message

    {
      args: [
        '*/package.json',
        '--quiet',
      ],
      fixtures: [
        {
          expect: '',
          file: 'notJson/package.json',
          original: '',
        },
      ],
      result: {
        errorCode: 2,
        stderr: `Error on: notJson/package.json␊
        `,
        stdout: '',
      },
    }

## run `cli --stdin` with input from stdin

> Should output sorted json

    {
      args: [
        '--stdin',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `{␊
          "name": "Name",␊
          "description": "Description"␊
        }␊
        `,
      },
    }

## run `cli --stdin` with input from stdin with \r\n

> The line feed should be CRLF in output

    {
      args: [
        '--stdin',
      ],
      fixtures: [],
      result: {
        errorCode: null,
        stderr: '',
        stdout: `{␍␊
          "name": "Name",␍␊
          "description": "Description"␍␊
        }␍␊
        `,
      },
    }
