export type IconFamily = "classic" | "duotone" | "sharp" | "sharp-duotone";
export type IconPrefix = "fas" | "fass" | "far" | "fasr" | "fal" | "fasl" | "fat" | "fast" | "fad" | "fadr" | "fadl" | "fadt" | "fasds" | "fasdr" | "fasdl" | "fasdt" | "fab" | "fak" | "fakd";
export type CssStyleClass = "fa-solid" | "fa-regular" | "fa-light" | "fa-thin" | "fa-duotone" | "fa-brands";
export type IconStyle = "solid" | "regular" | "light" | "thin" | "duotone" | "brands";
export type IconPathData = string | string[]

export interface IconLookup {
  prefix: IconPrefix;
  // IconName is defined in the code that will be generated at build time and bundled with this file.
  iconName: IconName;
}

export interface IconDefinition extends IconLookup {
  icon: [
    number, // width
    number, // height
    string[], // ligatures
    string, // unicode
    IconPathData // svgPathData
  ];
}

export interface IconPack {
  [key: string]: IconDefinition;
}

export type IconName = '0' | 
  '1' | 
  '2' | 
  '3' | 
  '4' | 
  '42-group' | 
  '5' | 
  '500px' | 
  '6' | 
  '7' | 
  '8' | 
  '9' | 
  'a' | 
  'accessible-icon' | 
  'accusoft' | 
  'ad' | 
  'add' | 
  'address-book' | 
  'address-card' | 
  'adjust' | 
  'adn' | 
  'adversal' | 
  'affiliatetheme' | 
  'air-freshener' | 
  'airbnb' | 
  'algolia' | 
  'align-center' | 
  'align-justify' | 
  'align-left' | 
  'align-right' | 
  'alipay' | 
  'allergies' | 
  'amazon' | 
  'amazon-pay' | 
  'ambulance' | 
  'american-sign-language-interpreting' | 
  'amilia' | 
  'anchor' | 
  'anchor-circle-check' | 
  'anchor-circle-exclamation' | 
  'anchor-circle-xmark' | 
  'anchor-lock' | 
  'android' | 
  'angellist' | 
  'angle-double-down' | 
  'angle-double-left' | 
  'angle-double-right' | 
  'angle-double-up' | 
  'angle-down' | 
  'angle-left' | 
  'angle-right' | 
  'angle-up' | 
  'angles-down' | 
  'angles-left' | 
  'angles-right' | 
  'angles-up' | 
  'angry' | 
  'angrycreative' | 
  'angular' | 
  'ankh' | 
  'app-store' | 
  'app-store-ios' | 
  'apper' | 
  'apple' | 
  'apple-alt' | 
  'apple-pay' | 
  'apple-whole' | 
  'archive' | 
  'archway' | 
  'area-chart' | 
  'arrow-alt-circle-down' | 
  'arrow-alt-circle-left' | 
  'arrow-alt-circle-right' | 
  'arrow-alt-circle-up' | 
  'arrow-circle-down' | 
  'arrow-circle-left' | 
  'arrow-circle-right' | 
  'arrow-circle-up' | 
  'arrow-down' | 
  'arrow-down-1-9' | 
  'arrow-down-9-1' | 
  'arrow-down-a-z' | 
  'arrow-down-long' | 
  'arrow-down-short-wide' | 
  'arrow-down-up-across-line' | 
  'arrow-down-up-lock' | 
  'arrow-down-wide-short' | 
  'arrow-down-z-a' | 
  'arrow-left' | 
  'arrow-left-long' | 
  'arrow-left-rotate' | 
  'arrow-pointer' | 
  'arrow-right' | 
  'arrow-right-arrow-left' | 
  'arrow-right-from-bracket' | 
  'arrow-right-from-file' | 
  'arrow-right-long' | 
  'arrow-right-rotate' | 
  'arrow-right-to-bracket' | 
  'arrow-right-to-city' | 
  'arrow-right-to-file' | 
  'arrow-rotate-back' | 
  'arrow-rotate-backward' | 
  'arrow-rotate-forward' | 
  'arrow-rotate-left' | 
  'arrow-rotate-right' | 
  'arrow-trend-down' | 
  'arrow-trend-up' | 
  'arrow-turn-down' | 
  'arrow-turn-up' | 
  'arrow-up' | 
  'arrow-up-1-9' | 
  'arrow-up-9-1' | 
  'arrow-up-a-z' | 
  'arrow-up-from-bracket' | 
  'arrow-up-from-ground-water' | 
  'arrow-up-from-water-pump' | 
  'arrow-up-long' | 
  'arrow-up-right-dots' | 
  'arrow-up-right-from-square' | 
  'arrow-up-short-wide' | 
  'arrow-up-wide-short' | 
  'arrow-up-z-a' | 
  'arrows' | 
  'arrows-alt' | 
  'arrows-alt-h' | 
  'arrows-alt-v' | 
  'arrows-down-to-line' | 
  'arrows-down-to-people' | 
  'arrows-h' | 
  'arrows-left-right' | 
  'arrows-left-right-to-line' | 
  'arrows-rotate' | 
  'arrows-spin' | 
  'arrows-split-up-and-left' | 
  'arrows-to-circle' | 
  'arrows-to-dot' | 
  'arrows-to-eye' | 
  'arrows-turn-right' | 
  'arrows-turn-to-dots' | 
  'arrows-up-down' | 
  'arrows-up-down-left-right' | 
  'arrows-up-to-line' | 
  'arrows-v' | 
  'artstation' | 
  'asl-interpreting' | 
  'assistive-listening-systems' | 
  'asterisk' | 
  'asymmetrik' | 
  'at' | 
  'atlas' | 
  'atlassian' | 
  'atom' | 
  'audible' | 
  'audio-description' | 
  'austral-sign' | 
  'automobile' | 
  'autoprefixer' | 
  'avianex' | 
  'aviato' | 
  'award' | 
  'aws' | 
  'b' | 
  'baby' | 
  'baby-carriage' | 
  'backspace' | 
  'backward' | 
  'backward-fast' | 
  'backward-step' | 
  'bacon' | 
  'bacteria' | 
  'bacterium' | 
  'bag-shopping' | 
  'bahai' | 
  'baht-sign' | 
  'balance-scale' | 
  'balance-scale-left' | 
  'balance-scale-right' | 
  'ban' | 
  'ban-smoking' | 
  'band-aid' | 
  'bandage' | 
  'bandcamp' | 
  'bangladeshi-taka-sign' | 
  'bank' | 
  'bar-chart' | 
  'barcode' | 
  'bars' | 
  'bars-progress' | 
  'bars-staggered' | 
  'baseball' | 
  'baseball-ball' | 
  'baseball-bat-ball' | 
  'basket-shopping' | 
  'basketball' | 
  'basketball-ball' | 
  'bath' | 
  'bathtub' | 
  'battery' | 
  'battery-0' | 
  'battery-2' | 
  'battery-3' | 
  'battery-4' | 
  'battery-5' | 
  'battery-car' | 
  'battery-empty' | 
  'battery-full' | 
  'battery-half' | 
  'battery-quarter' | 
  'battery-three-quarters' | 
  'battle-net' | 
  'bed' | 
  'bed-pulse' | 
  'beer' | 
  'beer-mug-empty' | 
  'behance' | 
  'behance-square' | 
  'bell' | 
  'bell-concierge' | 
  'bell-slash' | 
  'bezier-curve' | 
  'bible' | 
  'bicycle' | 
  'biking' | 
  'bilibili' | 
  'bimobject' | 
  'binoculars' | 
  'biohazard' | 
  'birthday-cake' | 
  'bitbucket' | 
  'bitcoin' | 
  'bitcoin-sign' | 
  'bity' | 
  'black-tie' | 
  'blackberry' | 
  'blackboard' | 
  'blender' | 
  'blender-phone' | 
  'blind' | 
  'blog' | 
  'blogger' | 
  'blogger-b' | 
  'bluesky' | 
  'bluetooth' | 
  'bluetooth-b' | 
  'bold' | 
  'bolt' | 
  'bolt-lightning' | 
  'bomb' | 
  'bone' | 
  'bong' | 
  'book' | 
  'book-atlas' | 
  'book-bible' | 
  'book-bookmark' | 
  'book-dead' | 
  'book-journal-whills' | 
  'book-medical' | 
  'book-open' | 
  'book-open-reader' | 
  'book-quran' | 
  'book-reader' | 
  'book-skull' | 
  'book-tanakh' | 
  'bookmark' | 
  'bootstrap' | 
  'border-all' | 
  'border-none' | 
  'border-style' | 
  'border-top-left' | 
  'bore-hole' | 
  'bots' | 
  'bottle-droplet' | 
  'bottle-water' | 
  'bowl-food' | 
  'bowl-rice' | 
  'bowling-ball' | 
  'box' | 
  'box-archive' | 
  'box-open' | 
  'box-tissue' | 
  'boxes' | 
  'boxes-alt' | 
  'boxes-packing' | 
  'boxes-stacked' | 
  'braille' | 
  'brain' | 
  'brave' | 
  'brave-reverse' | 
  'brazilian-real-sign' | 
  'bread-slice' | 
  'bridge' | 
  'bridge-circle-check' | 
  'bridge-circle-exclamation' | 
  'bridge-circle-xmark' | 
  'bridge-lock' | 
  'bridge-water' | 
  'briefcase' | 
  'briefcase-clock' | 
  'briefcase-medical' | 
  'broadcast-tower' | 
  'broom' | 
  'broom-ball' | 
  'brush' | 
  'btc' | 
  'bucket' | 
  'buffer' | 
  'bug' | 
  'bug-slash' | 
  'bugs' | 
  'building' | 
  'building-circle-arrow-right' | 
  'building-circle-check' | 
  'building-circle-exclamation' | 
  'building-circle-xmark' | 
  'building-columns' | 
  'building-flag' | 
  'building-lock' | 
  'building-ngo' | 
  'building-shield' | 
  'building-un' | 
  'building-user' | 
  'building-wheat' | 
  'bullhorn' | 
  'bullseye' | 
  'burger' | 
  'burn' | 
  'buromobelexperte' | 
  'burst' | 
  'bus' | 
  'bus-alt' | 
  'bus-simple' | 
  'business-time' | 
  'buy-n-large' | 
  'buysellads' | 
  'c' | 
  'cab' | 
  'cable-car' | 
  'cake' | 
  'cake-candles' | 
  'calculator' | 
  'calendar' | 
  'calendar-alt' | 
  'calendar-check' | 
  'calendar-day' | 
  'calendar-days' | 
  'calendar-minus' | 
  'calendar-plus' | 
  'calendar-times' | 
  'calendar-week' | 
  'calendar-xmark' | 
  'camera' | 
  'camera-alt' | 
  'camera-retro' | 
  'camera-rotate' | 
  'campground' | 
  'canadian-maple-leaf' | 
  'cancel' | 
  'candy-cane' | 
  'cannabis' | 
  'capsules' | 
  'car' | 
  'car-alt' | 
  'car-battery' | 
  'car-burst' | 
  'car-crash' | 
  'car-on' | 
  'car-rear' | 
  'car-side' | 
  'car-tunnel' | 
  'caravan' | 
  'caret-down' | 
  'caret-left' | 
  'caret-right' | 
  'caret-square-down' | 
  'caret-square-left' | 
  'caret-square-right' | 
  'caret-square-up' | 
  'caret-up' | 
  'carriage-baby' | 
  'carrot' | 
  'cart-arrow-down' | 
  'cart-flatbed' | 
  'cart-flatbed-suitcase' | 
  'cart-plus' | 
  'cart-shopping' | 
  'cash-register' | 
  'cat' | 
  'cc-amazon-pay' | 
  'cc-amex' | 
  'cc-apple-pay' | 
  'cc-diners-club' | 
  'cc-discover' | 
  'cc-jcb' | 
  'cc-mastercard' | 
  'cc-paypal' | 
  'cc-stripe' | 
  'cc-visa' | 
  'cedi-sign' | 
  'cent-sign' | 
  'centercode' | 
  'centos' | 
  'certificate' | 
  'chain' | 
  'chain-broken' | 
  'chain-slash' | 
  'chair' | 
  'chalkboard' | 
  'chalkboard-teacher' | 
  'chalkboard-user' | 
  'champagne-glasses' | 
  'charging-station' | 
  'chart-area' | 
  'chart-bar' | 
  'chart-column' | 
  'chart-diagram' | 
  'chart-gantt' | 
  'chart-line' | 
  'chart-pie' | 
  'chart-simple' | 
  'check' | 
  'check-circle' | 
  'check-double' | 
  'check-square' | 
  'check-to-slot' | 
  'cheese' | 
  'chess' | 
  'chess-bishop' | 
  'chess-board' | 
  'chess-king' | 
  'chess-knight' | 
  'chess-pawn' | 
  'chess-queen' | 
  'chess-rook' | 
  'chevron-circle-down' | 
  'chevron-circle-left' | 
  'chevron-circle-right' | 
  'chevron-circle-up' | 
  'chevron-down' | 
  'chevron-left' | 
  'chevron-right' | 
  'chevron-up' | 
  'child' | 
  'child-combatant' | 
  'child-dress' | 
  'child-reaching' | 
  'child-rifle' | 
  'children' | 
  'chrome' | 
  'chromecast' | 
  'church' | 
  'circle' | 
  'circle-arrow-down' | 
  'circle-arrow-left' | 
  'circle-arrow-right' | 
  'circle-arrow-up' | 
  'circle-check' | 
  'circle-chevron-down' | 
  'circle-chevron-left' | 
  'circle-chevron-right' | 
  'circle-chevron-up' | 
  'circle-dollar-to-slot' | 
  'circle-dot' | 
  'circle-down' | 
  'circle-exclamation' | 
  'circle-h' | 
  'circle-half-stroke' | 
  'circle-info' | 
  'circle-left' | 
  'circle-minus' | 
  'circle-nodes' | 
  'circle-notch' | 
  'circle-pause' | 
  'circle-play' | 
  'circle-plus' | 
  'circle-question' | 
  'circle-radiation' | 
  'circle-right' | 
  'circle-stop' | 
  'circle-up' | 
  'circle-user' | 
  'circle-xmark' | 
  'city' | 
  'clapperboard' | 
  'clinic-medical' | 
  'clipboard' | 
  'clipboard-check' | 
  'clipboard-list' | 
  'clipboard-question' | 
  'clipboard-user' | 
  'clock' | 
  'clock-four' | 
  'clock-rotate-left' | 
  'clone' | 
  'close' | 
  'closed-captioning' | 
  'cloud' | 
  'cloud-arrow-down' | 
  'cloud-arrow-up' | 
  'cloud-bolt' | 
  'cloud-download' | 
  'cloud-download-alt' | 
  'cloud-meatball' | 
  'cloud-moon' | 
  'cloud-moon-rain' | 
  'cloud-rain' | 
  'cloud-showers-heavy' | 
  'cloud-showers-water' | 
  'cloud-sun' | 
  'cloud-sun-rain' | 
  'cloud-upload' | 
  'cloud-upload-alt' | 
  'cloudflare' | 
  'cloudscale' | 
  'cloudsmith' | 
  'cloudversify' | 
  'clover' | 
  'cmplid' | 
  'cny' | 
  'cocktail' | 
  'code' | 
  'code-branch' | 
  'code-commit' | 
  'code-compare' | 
  'code-fork' | 
  'code-merge' | 
  'code-pull-request' | 
  'codepen' | 
  'codiepie' | 
  'coffee' | 
  'cog' | 
  'cogs' | 
  'coins' | 
  'colon-sign' | 
  'columns' | 
  'comment' | 
  'comment-alt' | 
  'comment-dollar' | 
  'comment-dots' | 
  'comment-medical' | 
  'comment-nodes' | 
  'comment-slash' | 
  'comment-sms' | 
  'commenting' | 
  'comments' | 
  'comments-dollar' | 
  'compact-disc' | 
  'compass' | 
  'compass-drafting' | 
  'compress' | 
  'compress-alt' | 
  'compress-arrows-alt' | 
  'computer' | 
  'computer-mouse' | 
  'concierge-bell' | 
  'confluence' | 
  'connectdevelop' | 
  'contact-book' | 
  'contact-card' | 
  'contao' | 
  'cookie' | 
  'cookie-bite' | 
  'copy' | 
  'copyright' | 
  'cotton-bureau' | 
  'couch' | 
  'cow' | 
  'cpanel' | 
  'creative-commons' | 
  'creative-commons-by' | 
  'creative-commons-nc' | 
  'creative-commons-nc-eu' | 
  'creative-commons-nc-jp' | 
  'creative-commons-nd' | 
  'creative-commons-pd' | 
  'creative-commons-pd-alt' | 
  'creative-commons-remix' | 
  'creative-commons-sa' | 
  'creative-commons-sampling' | 
  'creative-commons-sampling-plus' | 
  'creative-commons-share' | 
  'creative-commons-zero' | 
  'credit-card' | 
  'credit-card-alt' | 
  'critical-role' | 
  'crop' | 
  'crop-alt' | 
  'crop-simple' | 
  'cross' | 
  'crosshairs' | 
  'crow' | 
  'crown' | 
  'crutch' | 
  'cruzeiro-sign' | 
  'css' | 
  'css3' | 
  'css3-alt' | 
  'cube' | 
  'cubes' | 
  'cubes-stacked' | 
  'cut' | 
  'cutlery' | 
  'cuttlefish' | 
  'd' | 
  'd-and-d' | 
  'd-and-d-beyond' | 
  'dailymotion' | 
  'dart-lang' | 
  'dashboard' | 
  'dashcube' | 
  'database' | 
  'deaf' | 
  'deafness' | 
  'debian' | 
  'dedent' | 
  'deezer' | 
  'delete-left' | 
  'delicious' | 
  'democrat' | 
  'deploydog' | 
  'deskpro' | 
  'desktop' | 
  'desktop-alt' | 
  'dev' | 
  'deviantart' | 
  'dharmachakra' | 
  'dhl' | 
  'diagnoses' | 
  'diagram-next' | 
  'diagram-predecessor' | 
  'diagram-project' | 
  'diagram-successor' | 
  'diamond' | 
  'diamond-turn-right' | 
  'diaspora' | 
  'dice' | 
  'dice-d20' | 
  'dice-d6' | 
  'dice-five' | 
  'dice-four' | 
  'dice-one' | 
  'dice-six' | 
  'dice-three' | 
  'dice-two' | 
  'digg' | 
  'digging' | 
  'digital-ocean' | 
  'digital-tachograph' | 
  'directions' | 
  'discord' | 
  'discourse' | 
  'disease' | 
  'display' | 
  'divide' | 
  'dizzy' | 
  'dna' | 
  'dochub' | 
  'docker' | 
  'dog' | 
  'dollar' | 
  'dollar-sign' | 
  'dolly' | 
  'dolly-box' | 
  'dolly-flatbed' | 
  'donate' | 
  'dong-sign' | 
  'door-closed' | 
  'door-open' | 
  'dot-circle' | 
  'dove' | 
  'down-left-and-up-right-to-center' | 
  'down-long' | 
  'download' | 
  'draft2digital' | 
  'drafting-compass' | 
  'dragon' | 
  'draw-polygon' | 
  'dribbble' | 
  'dribbble-square' | 
  'drivers-license' | 
  'dropbox' | 
  'droplet' | 
  'droplet-slash' | 
  'drum' | 
  'drum-steelpan' | 
  'drumstick-bite' | 
  'drupal' | 
  'dumbbell' | 
  'dumpster' | 
  'dumpster-fire' | 
  'dungeon' | 
  'dyalog' | 
  'e' | 
  'ear-deaf' | 
  'ear-listen' | 
  'earlybirds' | 
  'earth' | 
  'earth-africa' | 
  'earth-america' | 
  'earth-americas' | 
  'earth-asia' | 
  'earth-europe' | 
  'earth-oceania' | 
  'ebay' | 
  'edge' | 
  'edge-legacy' | 
  'edit' | 
  'egg' | 
  'eject' | 
  'elementor' | 
  'elevator' | 
  'ellipsis' | 
  'ellipsis-h' | 
  'ellipsis-v' | 
  'ellipsis-vertical' | 
  'ello' | 
  'ember' | 
  'empire' | 
  'envelope' | 
  'envelope-circle-check' | 
  'envelope-open' | 
  'envelope-open-text' | 
  'envelope-square' | 
  'envelopes-bulk' | 
  'envira' | 
  'equals' | 
  'eraser' | 
  'erlang' | 
  'ethereum' | 
  'ethernet' | 
  'etsy' | 
  'eur' | 
  'euro' | 
  'euro-sign' | 
  'evernote' | 
  'exchange' | 
  'exchange-alt' | 
  'exclamation' | 
  'exclamation-circle' | 
  'exclamation-triangle' | 
  'expand' | 
  'expand-alt' | 
  'expand-arrows-alt' | 
  'expeditedssl' | 
  'explosion' | 
  'external-link' | 
  'external-link-alt' | 
  'external-link-square' | 
  'external-link-square-alt' | 
  'eye' | 
  'eye-dropper' | 
  'eye-dropper-empty' | 
  'eye-low-vision' | 
  'eye-slash' | 
  'eyedropper' | 
  'f' | 
  'face-angry' | 
  'face-dizzy' | 
  'face-flushed' | 
  'face-frown' | 
  'face-frown-open' | 
  'face-grimace' | 
  'face-grin' | 
  'face-grin-beam' | 
  'face-grin-beam-sweat' | 
  'face-grin-hearts' | 
  'face-grin-squint' | 
  'face-grin-squint-tears' | 
  'face-grin-stars' | 
  'face-grin-tears' | 
  'face-grin-tongue' | 
  'face-grin-tongue-squint' | 
  'face-grin-tongue-wink' | 
  'face-grin-wide' | 
  'face-grin-wink' | 
  'face-kiss' | 
  'face-kiss-beam' | 
  'face-kiss-wink-heart' | 
  'face-laugh' | 
  'face-laugh-beam' | 
  'face-laugh-squint' | 
  'face-laugh-wink' | 
  'face-meh' | 
  'face-meh-blank' | 
  'face-rolling-eyes' | 
  'face-sad-cry' | 
  'face-sad-tear' | 
  'face-smile' | 
  'face-smile-beam' | 
  'face-smile-wink' | 
  'face-surprise' | 
  'face-tired' | 
  'facebook' | 
  'facebook-f' | 
  'facebook-messenger' | 
  'facebook-square' | 
  'fan' | 
  'fantasy-flight-games' | 
  'fast-backward' | 
  'fast-forward' | 
  'faucet' | 
  'faucet-drip' | 
  'fax' | 
  'feather' | 
  'feather-alt' | 
  'feather-pointed' | 
  'fedex' | 
  'fedora' | 
  'feed' | 
  'female' | 
  'ferry' | 
  'fighter-jet' | 
  'figma' | 
  'file' | 
  'file-alt' | 
  'file-archive' | 
  'file-arrow-down' | 
  'file-arrow-up' | 
  'file-audio' | 
  'file-circle-check' | 
  'file-circle-exclamation' | 
  'file-circle-minus' | 
  'file-circle-plus' | 
  'file-circle-question' | 
  'file-circle-xmark' | 
  'file-clipboard' | 
  'file-code' | 
  'file-contract' | 
  'file-csv' | 
  'file-download' | 
  'file-edit' | 
  'file-excel' | 
  'file-export' | 
  'file-fragment' | 
  'file-half-dashed' | 
  'file-image' | 
  'file-import' | 
  'file-invoice' | 
  'file-invoice-dollar' | 
  'file-lines' | 
  'file-medical' | 
  'file-medical-alt' | 
  'file-pdf' | 
  'file-pen' | 
  'file-powerpoint' | 
  'file-prescription' | 
  'file-shield' | 
  'file-signature' | 
  'file-text' | 
  'file-upload' | 
  'file-video' | 
  'file-waveform' | 
  'file-word' | 
  'file-zipper' | 
  'files-pinwheel' | 
  'fill' | 
  'fill-drip' | 
  'film' | 
  'filter' | 
  'filter-circle-dollar' | 
  'filter-circle-xmark' | 
  'fingerprint' | 
  'fire' | 
  'fire-alt' | 
  'fire-burner' | 
  'fire-extinguisher' | 
  'fire-flame-curved' | 
  'fire-flame-simple' | 
  'firefox' | 
  'firefox-browser' | 
  'first-aid' | 
  'first-order' | 
  'first-order-alt' | 
  'firstdraft' | 
  'fish' | 
  'fish-fins' | 
  'fist-raised' | 
  'flag' | 
  'flag-checkered' | 
  'flag-usa' | 
  'flask' | 
  'flask-vial' | 
  'flickr' | 
  'flipboard' | 
  'floppy-disk' | 
  'florin-sign' | 
  'flushed' | 
  'flutter' | 
  'fly' | 
  'folder' | 
  'folder-blank' | 
  'folder-closed' | 
  'folder-minus' | 
  'folder-open' | 
  'folder-plus' | 
  'folder-tree' | 
  'font' | 
  'font-awesome' | 
  'font-awesome-alt' | 
  'font-awesome-flag' | 
  'font-awesome-logo-full' | 
  'fonticons' | 
  'fonticons-fi' | 
  'football' | 
  'football-ball' | 
  'fort-awesome' | 
  'fort-awesome-alt' | 
  'forumbee' | 
  'forward' | 
  'forward-fast' | 
  'forward-step' | 
  'foursquare' | 
  'franc-sign' | 
  'free-code-camp' | 
  'freebsd' | 
  'frog' | 
  'frown' | 
  'frown-open' | 
  'fulcrum' | 
  'funnel-dollar' | 
  'futbol' | 
  'futbol-ball' | 
  'g' | 
  'galactic-republic' | 
  'galactic-senate' | 
  'gamepad' | 
  'gas-pump' | 
  'gauge' | 
  'gauge-high' | 
  'gauge-med' | 
  'gauge-simple' | 
  'gauge-simple-high' | 
  'gauge-simple-med' | 
  'gavel' | 
  'gbp' | 
  'gear' | 
  'gears' | 
  'gem' | 
  'genderless' | 
  'get-pocket' | 
  'gg' | 
  'gg-circle' | 
  'ghost' | 
  'gift' | 
  'gifts' | 
  'git' | 
  'git-alt' | 
  'git-square' | 
  'github' | 
  'github-alt' | 
  'github-square' | 
  'gitkraken' | 
  'gitlab' | 
  'gitlab-square' | 
  'gitter' | 
  'glass-cheers' | 
  'glass-martini' | 
  'glass-martini-alt' | 
  'glass-water' | 
  'glass-water-droplet' | 
  'glass-whiskey' | 
  'glasses' | 
  'glide' | 
  'glide-g' | 
  'globe' | 
  'globe-africa' | 
  'globe-americas' | 
  'globe-asia' | 
  'globe-europe' | 
  'globe-oceania' | 
  'gofore' | 
  'golang' | 
  'golf-ball' | 
  'golf-ball-tee' | 
  'goodreads' | 
  'goodreads-g' | 
  'google' | 
  'google-drive' | 
  'google-pay' | 
  'google-play' | 
  'google-plus' | 
  'google-plus-g' | 
  'google-plus-square' | 
  'google-scholar' | 
  'google-wallet' | 
  'gopuram' | 
  'graduation-cap' | 
  'gratipay' | 
  'grav' | 
  'greater-than' | 
  'greater-than-equal' | 
  'grimace' | 
  'grin' | 
  'grin-alt' | 
  'grin-beam' | 
  'grin-beam-sweat' | 
  'grin-hearts' | 
  'grin-squint' | 
  'grin-squint-tears' | 
  'grin-stars' | 
  'grin-tears' | 
  'grin-tongue' | 
  'grin-tongue-squint' | 
  'grin-tongue-wink' | 
  'grin-wink' | 
  'grip' | 
  'grip-horizontal' | 
  'grip-lines' | 
  'grip-lines-vertical' | 
  'grip-vertical' | 
  'gripfire' | 
  'group-arrows-rotate' | 
  'grunt' | 
  'guarani-sign' | 
  'guilded' | 
  'guitar' | 
  'gulp' | 
  'gun' | 
  'h' | 
  'h-square' | 
  'hacker-news' | 
  'hacker-news-square' | 
  'hackerrank' | 
  'hamburger' | 
  'hammer' | 
  'hamsa' | 
  'hand' | 
  'hand-back-fist' | 
  'hand-dots' | 
  'hand-fist' | 
  'hand-holding' | 
  'hand-holding-dollar' | 
  'hand-holding-droplet' | 
  'hand-holding-hand' | 
  'hand-holding-heart' | 
  'hand-holding-medical' | 
  'hand-holding-usd' | 
  'hand-holding-water' | 
  'hand-lizard' | 
  'hand-middle-finger' | 
  'hand-paper' | 
  'hand-peace' | 
  'hand-point-down' | 
  'hand-point-left' | 
  'hand-point-right' | 
  'hand-point-up' | 
  'hand-pointer' | 
  'hand-rock' | 
  'hand-scissors' | 
  'hand-sparkles' | 
  'hand-spock' | 
  'handcuffs' | 
  'hands' | 
  'hands-american-sign-language-interpreting' | 
  'hands-asl-interpreting' | 
  'hands-bound' | 
  'hands-bubbles' | 
  'hands-clapping' | 
  'hands-helping' | 
  'hands-holding' | 
  'hands-holding-child' | 
  'hands-holding-circle' | 
  'hands-praying' | 
  'hands-wash' | 
  'handshake' | 
  'handshake-alt' | 
  'handshake-alt-slash' | 
  'handshake-angle' | 
  'handshake-simple' | 
  'handshake-simple-slash' | 
  'handshake-slash' | 
  'hanukiah' | 
  'hard-drive' | 
  'hard-hat' | 
  'hard-of-hearing' | 
  'hashnode' | 
  'hashtag' | 
  'hat-cowboy' | 
  'hat-cowboy-side' | 
  'hat-hard' | 
  'hat-wizard' | 
  'haykal' | 
  'hdd' | 
  'head-side-cough' | 
  'head-side-cough-slash' | 
  'head-side-mask' | 
  'head-side-virus' | 
  'header' | 
  'heading' | 
  'headphones' | 
  'headphones-alt' | 
  'headphones-simple' | 
  'headset' | 
  'heart' | 
  'heart-broken' | 
  'heart-circle-bolt' | 
  'heart-circle-check' | 
  'heart-circle-exclamation' | 
  'heart-circle-minus' | 
  'heart-circle-plus' | 
  'heart-circle-xmark' | 
  'heart-crack' | 
  'heart-music-camera-bolt' | 
  'heart-pulse' | 
  'heartbeat' | 
  'helicopter' | 
  'helicopter-symbol' | 
  'helmet-safety' | 
  'helmet-un' | 
  'hexagon-nodes' | 
  'hexagon-nodes-bolt' | 
  'highlighter' | 
  'hiking' | 
  'hill-avalanche' | 
  'hill-rockslide' | 
  'hippo' | 
  'hips' | 
  'hire-a-helper' | 
  'history' | 
  'hive' | 
  'hockey-puck' | 
  'holly-berry' | 
  'home' | 
  'home-alt' | 
  'home-lg' | 
  'home-lg-alt' | 
  'home-user' | 
  'hooli' | 
  'hornbill' | 
  'horse' | 
  'horse-head' | 
  'hospital' | 
  'hospital-alt' | 
  'hospital-symbol' | 
  'hospital-user' | 
  'hospital-wide' | 
  'hot-tub' | 
  'hot-tub-person' | 
  'hotdog' | 
  'hotel' | 
  'hotjar' | 
  'hourglass' | 
  'hourglass-1' | 
  'hourglass-2' | 
  'hourglass-3' | 
  'hourglass-empty' | 
  'hourglass-end' | 
  'hourglass-half' | 
  'hourglass-start' | 
  'house' | 
  'house-chimney' | 
  'house-chimney-crack' | 
  'house-chimney-medical' | 
  'house-chimney-user' | 
  'house-chimney-window' | 
  'house-circle-check' | 
  'house-circle-exclamation' | 
  'house-circle-xmark' | 
  'house-crack' | 
  'house-damage' | 
  'house-fire' | 
  'house-flag' | 
  'house-flood-water' | 
  'house-flood-water-circle-arrow-right' | 
  'house-laptop' | 
  'house-lock' | 
  'house-medical' | 
  'house-medical-circle-check' | 
  'house-medical-circle-exclamation' | 
  'house-medical-circle-xmark' | 
  'house-medical-flag' | 
  'house-signal' | 
  'house-tsunami' | 
  'house-user' | 
  'houzz' | 
  'hryvnia' | 
  'hryvnia-sign' | 
  'html5' | 
  'hubspot' | 
  'hurricane' | 
  'i' | 
  'i-cursor' | 
  'ice-cream' | 
  'icicles' | 
  'icons' | 
  'id-badge' | 
  'id-card' | 
  'id-card-alt' | 
  'id-card-clip' | 
  'ideal' | 
  'igloo' | 
  'ils' | 
  'image' | 
  'image-portrait' | 
  'images' | 
  'imdb' | 
  'inbox' | 
  'indent' | 
  'indian-rupee' | 
  'indian-rupee-sign' | 
  'industry' | 
  'infinity' | 
  'info' | 
  'info-circle' | 
  'innosoft' | 
  'inr' | 
  'instagram' | 
  'instagram-square' | 
  'instalod' | 
  'institution' | 
  'intercom' | 
  'internet-explorer' | 
  'invision' | 
  'ioxhost' | 
  'italic' | 
  'itch-io' | 
  'itunes' | 
  'itunes-note' | 
  'j' | 
  'jar' | 
  'jar-wheat' | 
  'java' | 
  'jedi' | 
  'jedi-order' | 
  'jenkins' | 
  'jet-fighter' | 
  'jet-fighter-up' | 
  'jira' | 
  'joget' | 
  'joint' | 
  'joomla' | 
  'journal-whills' | 
  'jpy' | 
  'js' | 
  'js-square' | 
  'jsfiddle' | 
  'jug-detergent' | 
  'jxl' | 
  'k' | 
  'kaaba' | 
  'kaggle' | 
  'key' | 
  'keybase' | 
  'keyboard' | 
  'keycdn' | 
  'khanda' | 
  'kickstarter' | 
  'kickstarter-k' | 
  'kip-sign' | 
  'kiss' | 
  'kiss-beam' | 
  'kiss-wink-heart' | 
  'kit-medical' | 
  'kitchen-set' | 
  'kiwi-bird' | 
  'korvue' | 
  'krw' | 
  'l' | 
  'ladder-water' | 
  'land-mine-on' | 
  'landmark' | 
  'landmark-alt' | 
  'landmark-dome' | 
  'landmark-flag' | 
  'language' | 
  'laptop' | 
  'laptop-code' | 
  'laptop-file' | 
  'laptop-house' | 
  'laptop-medical' | 
  'laravel' | 
  'lari-sign' | 
  'lastfm' | 
  'lastfm-square' | 
  'laugh' | 
  'laugh-beam' | 
  'laugh-squint' | 
  'laugh-wink' | 
  'layer-group' | 
  'leaf' | 
  'leanpub' | 
  'left-long' | 
  'left-right' | 
  'legal' | 
  'lemon' | 
  'less' | 
  'less-than' | 
  'less-than-equal' | 
  'letterboxd' | 
  'level-down' | 
  'level-down-alt' | 
  'level-up' | 
  'level-up-alt' | 
  'life-ring' | 
  'lightbulb' | 
  'line' | 
  'line-chart' | 
  'lines-leaning' | 
  'link' | 
  'link-slash' | 
  'linkedin' | 
  'linkedin-in' | 
  'linode' | 
  'linux' | 
  'lira-sign' | 
  'list' | 
  'list-1-2' | 
  'list-alt' | 
  'list-check' | 
  'list-dots' | 
  'list-numeric' | 
  'list-ol' | 
  'list-squares' | 
  'list-ul' | 
  'litecoin-sign' | 
  'location' | 
  'location-arrow' | 
  'location-crosshairs' | 
  'location-dot' | 
  'location-pin' | 
  'location-pin-lock' | 
  'lock' | 
  'lock-open' | 
  'locust' | 
  'long-arrow-alt-down' | 
  'long-arrow-alt-left' | 
  'long-arrow-alt-right' | 
  'long-arrow-alt-up' | 
  'long-arrow-down' | 
  'long-arrow-left' | 
  'long-arrow-right' | 
  'long-arrow-up' | 
  'low-vision' | 
  'luggage-cart' | 
  'lungs' | 
  'lungs-virus' | 
  'lyft' | 
  'm' | 
  'magento' | 
  'magic' | 
  'magic-wand-sparkles' | 
  'magnet' | 
  'magnifying-glass' | 
  'magnifying-glass-arrow-right' | 
  'magnifying-glass-chart' | 
  'magnifying-glass-dollar' | 
  'magnifying-glass-location' | 
  'magnifying-glass-minus' | 
  'magnifying-glass-plus' | 
  'mail-bulk' | 
  'mail-forward' | 
  'mail-reply' | 
  'mail-reply-all' | 
  'mailchimp' | 
  'male' | 
  'manat-sign' | 
  'mandalorian' | 
  'map' | 
  'map-location' | 
  'map-location-dot' | 
  'map-marked' | 
  'map-marked-alt' | 
  'map-marker' | 
  'map-marker-alt' | 
  'map-pin' | 
  'map-signs' | 
  'markdown' | 
  'marker' | 
  'mars' | 
  'mars-and-venus' | 
  'mars-and-venus-burst' | 
  'mars-double' | 
  'mars-stroke' | 
  'mars-stroke-h' | 
  'mars-stroke-right' | 
  'mars-stroke-up' | 
  'mars-stroke-v' | 
  'martini-glass' | 
  'martini-glass-citrus' | 
  'martini-glass-empty' | 
  'mask' | 
  'mask-face' | 
  'mask-ventilator' | 
  'masks-theater' | 
  'mastodon' | 
  'mattress-pillow' | 
  'maxcdn' | 
  'maximize' | 
  'mdb' | 
  'medal' | 
  'medapps' | 
  'medium' | 
  'medium-m' | 
  'medkit' | 
  'medrt' | 
  'meetup' | 
  'megaport' | 
  'meh' | 
  'meh-blank' | 
  'meh-rolling-eyes' | 
  'memory' | 
  'mendeley' | 
  'menorah' | 
  'mercury' | 
  'message' | 
  'meta' | 
  'meteor' | 
  'microblog' | 
  'microchip' | 
  'microphone' | 
  'microphone-alt' | 
  'microphone-alt-slash' | 
  'microphone-lines' | 
  'microphone-lines-slash' | 
  'microphone-slash' | 
  'microscope' | 
  'microsoft' | 
  'mill-sign' | 
  'minimize' | 
  'mintbit' | 
  'minus' | 
  'minus-circle' | 
  'minus-square' | 
  'mitten' | 
  'mix' | 
  'mixcloud' | 
  'mixer' | 
  'mizuni' | 
  'mobile' | 
  'mobile-alt' | 
  'mobile-android' | 
  'mobile-android-alt' | 
  'mobile-button' | 
  'mobile-phone' | 
  'mobile-retro' | 
  'mobile-screen' | 
  'mobile-screen-button' | 
  'modx' | 
  'monero' | 
  'money-bill' | 
  'money-bill-1' | 
  'money-bill-1-wave' | 
  'money-bill-alt' | 
  'money-bill-transfer' | 
  'money-bill-trend-up' | 
  'money-bill-wave' | 
  'money-bill-wave-alt' | 
  'money-bill-wheat' | 
  'money-bills' | 
  'money-check' | 
  'money-check-alt' | 
  'money-check-dollar' | 
  'monument' | 
  'moon' | 
  'mortar-board' | 
  'mortar-pestle' | 
  'mosque' | 
  'mosquito' | 
  'mosquito-net' | 
  'motorcycle' | 
  'mound' | 
  'mountain' | 
  'mountain-city' | 
  'mountain-sun' | 
  'mouse' | 
  'mouse-pointer' | 
  'mug-hot' | 
  'mug-saucer' | 
  'multiply' | 
  'museum' | 
  'music' | 
  'n' | 
  'naira-sign' | 
  'napster' | 
  'navicon' | 
  'neos' | 
  'network-wired' | 
  'neuter' | 
  'newspaper' | 
  'nfc-directional' | 
  'nfc-symbol' | 
  'nimblr' | 
  'node' | 
  'node-js' | 
  'not-equal' | 
  'notdef' | 
  'note-sticky' | 
  'notes-medical' | 
  'npm' | 
  'ns8' | 
  'nutritionix' | 
  'o' | 
  'object-group' | 
  'object-ungroup' | 
  'octopus-deploy' | 
  'odnoklassniki' | 
  'odnoklassniki-square' | 
  'odysee' | 
  'oil-can' | 
  'oil-well' | 
  'old-republic' | 
  'om' | 
  'opencart' | 
  'openid' | 
  'opensuse' | 
  'opera' | 
  'optin-monster' | 
  'orcid' | 
  'osi' | 
  'otter' | 
  'outdent' | 
  'p' | 
  'padlet' | 
  'page4' | 
  'pagelines' | 
  'pager' | 
  'paint-brush' | 
  'paint-roller' | 
  'paintbrush' | 
  'palette' | 
  'palfed' | 
  'pallet' | 
  'panorama' | 
  'paper-plane' | 
  'paperclip' | 
  'parachute-box' | 
  'paragraph' | 
  'parking' | 
  'passport' | 
  'pastafarianism' | 
  'paste' | 
  'patreon' | 
  'pause' | 
  'pause-circle' | 
  'paw' | 
  'paypal' | 
  'peace' | 
  'pen' | 
  'pen-alt' | 
  'pen-clip' | 
  'pen-fancy' | 
  'pen-nib' | 
  'pen-ruler' | 
  'pen-square' | 
  'pen-to-square' | 
  'pencil' | 
  'pencil-alt' | 
  'pencil-ruler' | 
  'pencil-square' | 
  'people-arrows' | 
  'people-arrows-left-right' | 
  'people-carry' | 
  'people-carry-box' | 
  'people-group' | 
  'people-line' | 
  'people-pulling' | 
  'people-robbery' | 
  'people-roof' | 
  'pepper-hot' | 
  'perbyte' | 
  'percent' | 
  'percentage' | 
  'periscope' | 
  'person' | 
  'person-arrow-down-to-line' | 
  'person-arrow-up-from-line' | 
  'person-biking' | 
  'person-booth' | 
  'person-breastfeeding' | 
  'person-burst' | 
  'person-cane' | 
  'person-chalkboard' | 
  'person-circle-check' | 
  'person-circle-exclamation' | 
  'person-circle-minus' | 
  'person-circle-plus' | 
  'person-circle-question' | 
  'person-circle-xmark' | 
  'person-digging' | 
  'person-dots-from-line' | 
  'person-dress' | 
  'person-dress-burst' | 
  'person-drowning' | 
  'person-falling' | 
  'person-falling-burst' | 
  'person-half-dress' | 
  'person-harassing' | 
  'person-hiking' | 
  'person-military-pointing' | 
  'person-military-rifle' | 
  'person-military-to-person' | 
  'person-praying' | 
  'person-pregnant' | 
  'person-rays' | 
  'person-rifle' | 
  'person-running' | 
  'person-shelter' | 
  'person-skating' | 
  'person-skiing' | 
  'person-skiing-nordic' | 
  'person-snowboarding' | 
  'person-swimming' | 
  'person-through-window' | 
  'person-walking' | 
  'person-walking-arrow-loop-left' | 
  'person-walking-arrow-right' | 
  'person-walking-dashed-line-arrow-right' | 
  'person-walking-luggage' | 
  'person-walking-with-cane' | 
  'peseta-sign' | 
  'peso-sign' | 
  'phabricator' | 
  'phoenix-framework' | 
  'phoenix-squadron' | 
  'phone' | 
  'phone-alt' | 
  'phone-flip' | 
  'phone-slash' | 
  'phone-square' | 
  'phone-square-alt' | 
  'phone-volume' | 
  'photo-film' | 
  'photo-video' | 
  'php' | 
  'pie-chart' | 
  'pied-piper' | 
  'pied-piper-alt' | 
  'pied-piper-hat' | 
  'pied-piper-pp' | 
  'pied-piper-square' | 
  'piggy-bank' | 
  'pills' | 
  'ping-pong-paddle-ball' | 
  'pinterest' | 
  'pinterest-p' | 
  'pinterest-square' | 
  'pix' | 
  'pixiv' | 
  'pizza-slice' | 
  'place-of-worship' | 
  'plane' | 
  'plane-arrival' | 
  'plane-circle-check' | 
  'plane-circle-exclamation' | 
  'plane-circle-xmark' | 
  'plane-departure' | 
  'plane-lock' | 
  'plane-slash' | 
  'plane-up' | 
  'plant-wilt' | 
  'plate-wheat' | 
  'play' | 
  'play-circle' | 
  'playstation' | 
  'plug' | 
  'plug-circle-bolt' | 
  'plug-circle-check' | 
  'plug-circle-exclamation' | 
  'plug-circle-minus' | 
  'plug-circle-plus' | 
  'plug-circle-xmark' | 
  'plus' | 
  'plus-circle' | 
  'plus-minus' | 
  'plus-square' | 
  'podcast' | 
  'poll' | 
  'poll-h' | 
  'poo' | 
  'poo-bolt' | 
  'poo-storm' | 
  'poop' | 
  'portrait' | 
  'pound-sign' | 
  'power-off' | 
  'pray' | 
  'praying-hands' | 
  'prescription' | 
  'prescription-bottle' | 
  'prescription-bottle-alt' | 
  'prescription-bottle-medical' | 
  'print' | 
  'procedures' | 
  'product-hunt' | 
  'project-diagram' | 
  'pump-medical' | 
  'pump-soap' | 
  'pushed' | 
  'puzzle-piece' | 
  'python' | 
  'q' | 
  'qq' | 
  'qrcode' | 
  'question' | 
  'question-circle' | 
  'quidditch' | 
  'quidditch-broom-ball' | 
  'quinscape' | 
  'quora' | 
  'quote-left' | 
  'quote-left-alt' | 
  'quote-right' | 
  'quote-right-alt' | 
  'quran' | 
  'r' | 
  'r-project' | 
  'radiation' | 
  'radiation-alt' | 
  'radio' | 
  'rainbow' | 
  'random' | 
  'ranking-star' | 
  'raspberry-pi' | 
  'ravelry' | 
  'react' | 
  'reacteurope' | 
  'readme' | 
  'rebel' | 
  'receipt' | 
  'record-vinyl' | 
  'rectangle-ad' | 
  'rectangle-list' | 
  'rectangle-times' | 
  'rectangle-xmark' | 
  'recycle' | 
  'red-river' | 
  'reddit' | 
  'reddit-alien' | 
  'reddit-square' | 
  'redhat' | 
  'redo' | 
  'redo-alt' | 
  'refresh' | 
  'registered' | 
  'remove' | 
  'remove-format' | 
  'rendact' | 
  'renren' | 
  'reorder' | 
  'repeat' | 
  'reply' | 
  'reply-all' | 
  'replyd' | 
  'republican' | 
  'researchgate' | 
  'resolving' | 
  'restroom' | 
  'retweet' | 
  'rev' | 
  'ribbon' | 
  'right-from-bracket' | 
  'right-left' | 
  'right-long' | 
  'right-to-bracket' | 
  'ring' | 
  'rmb' | 
  'road' | 
  'road-barrier' | 
  'road-bridge' | 
  'road-circle-check' | 
  'road-circle-exclamation' | 
  'road-circle-xmark' | 
  'road-lock' | 
  'road-spikes' | 
  'robot' | 
  'rocket' | 
  'rocketchat' | 
  'rockrms' | 
  'rod-asclepius' | 
  'rod-snake' | 
  'rotate' | 
  'rotate-back' | 
  'rotate-backward' | 
  'rotate-forward' | 
  'rotate-left' | 
  'rotate-right' | 
  'rouble' | 
  'route' | 
  'rss' | 
  'rss-square' | 
  'rub' | 
  'ruble' | 
  'ruble-sign' | 
  'rug' | 
  'ruler' | 
  'ruler-combined' | 
  'ruler-horizontal' | 
  'ruler-vertical' | 
  'running' | 
  'rupee' | 
  'rupee-sign' | 
  'rupiah-sign' | 
  'rust' | 
  's' | 
  'sack-dollar' | 
  'sack-xmark' | 
  'sad-cry' | 
  'sad-tear' | 
  'safari' | 
  'sailboat' | 
  'salesforce' | 
  'sass' | 
  'satellite' | 
  'satellite-dish' | 
  'save' | 
  'scale-balanced' | 
  'scale-unbalanced' | 
  'scale-unbalanced-flip' | 
  'schlix' | 
  'school' | 
  'school-circle-check' | 
  'school-circle-exclamation' | 
  'school-circle-xmark' | 
  'school-flag' | 
  'school-lock' | 
  'scissors' | 
  'screenpal' | 
  'screwdriver' | 
  'screwdriver-wrench' | 
  'scribd' | 
  'scroll' | 
  'scroll-torah' | 
  'sd-card' | 
  'search' | 
  'search-dollar' | 
  'search-location' | 
  'search-minus' | 
  'search-plus' | 
  'searchengin' | 
  'section' | 
  'seedling' | 
  'sellcast' | 
  'sellsy' | 
  'server' | 
  'servicestack' | 
  'shapes' | 
  'share' | 
  'share-alt' | 
  'share-alt-square' | 
  'share-from-square' | 
  'share-nodes' | 
  'share-square' | 
  'sheet-plastic' | 
  'shekel' | 
  'shekel-sign' | 
  'sheqel' | 
  'sheqel-sign' | 
  'shield' | 
  'shield-alt' | 
  'shield-blank' | 
  'shield-cat' | 
  'shield-dog' | 
  'shield-halved' | 
  'shield-heart' | 
  'shield-virus' | 
  'ship' | 
  'shipping-fast' | 
  'shirt' | 
  'shirtsinbulk' | 
  'shoe-prints' | 
  'shoelace' | 
  'shop' | 
  'shop-lock' | 
  'shop-slash' | 
  'shopify' | 
  'shopping-bag' | 
  'shopping-basket' | 
  'shopping-cart' | 
  'shopware' | 
  'shower' | 
  'shrimp' | 
  'shuffle' | 
  'shuttle-space' | 
  'shuttle-van' | 
  'sign' | 
  'sign-hanging' | 
  'sign-in' | 
  'sign-in-alt' | 
  'sign-language' | 
  'sign-out' | 
  'sign-out-alt' | 
  'signal' | 
  'signal-5' | 
  'signal-messenger' | 
  'signal-perfect' | 
  'signature' | 
  'signing' | 
  'signs-post' | 
  'sim-card' | 
  'simplybuilt' | 
  'sink' | 
  'sistrix' | 
  'sitemap' | 
  'sith' | 
  'sitrox' | 
  'skating' | 
  'sketch' | 
  'skiing' | 
  'skiing-nordic' | 
  'skull' | 
  'skull-crossbones' | 
  'skyatlas' | 
  'skype' | 
  'slack' | 
  'slack-hash' | 
  'slash' | 
  'sleigh' | 
  'sliders' | 
  'sliders-h' | 
  'slideshare' | 
  'smile' | 
  'smile-beam' | 
  'smile-wink' | 
  'smog' | 
  'smoking' | 
  'smoking-ban' | 
  'sms' | 
  'snapchat' | 
  'snapchat-ghost' | 
  'snapchat-square' | 
  'snowboarding' | 
  'snowflake' | 
  'snowman' | 
  'snowplow' | 
  'soap' | 
  'soccer-ball' | 
  'socks' | 
  'solar-panel' | 
  'sort' | 
  'sort-alpha-asc' | 
  'sort-alpha-desc' | 
  'sort-alpha-down' | 
  'sort-alpha-down-alt' | 
  'sort-alpha-up' | 
  'sort-alpha-up-alt' | 
  'sort-amount-asc' | 
  'sort-amount-desc' | 
  'sort-amount-down' | 
  'sort-amount-down-alt' | 
  'sort-amount-up' | 
  'sort-amount-up-alt' | 
  'sort-asc' | 
  'sort-desc' | 
  'sort-down' | 
  'sort-numeric-asc' | 
  'sort-numeric-desc' | 
  'sort-numeric-down' | 
  'sort-numeric-down-alt' | 
  'sort-numeric-up' | 
  'sort-numeric-up-alt' | 
  'sort-up' | 
  'soundcloud' | 
  'sourcetree' | 
  'spa' | 
  'space-awesome' | 
  'space-shuttle' | 
  'spaghetti-monster-flying' | 
  'speakap' | 
  'speaker-deck' | 
  'spell-check' | 
  'spider' | 
  'spinner' | 
  'splotch' | 
  'spoon' | 
  'spotify' | 
  'spray-can' | 
  'spray-can-sparkles' | 
  'sprout' | 
  'square' | 
  'square-arrow-up-right' | 
  'square-behance' | 
  'square-binary' | 
  'square-bluesky' | 
  'square-caret-down' | 
  'square-caret-left' | 
  'square-caret-right' | 
  'square-caret-up' | 
  'square-check' | 
  'square-dribbble' | 
  'square-envelope' | 
  'square-facebook' | 
  'square-font-awesome' | 
  'square-font-awesome-stroke' | 
  'square-full' | 
  'square-git' | 
  'square-github' | 
  'square-gitlab' | 
  'square-google-plus' | 
  'square-h' | 
  'square-hacker-news' | 
  'square-instagram' | 
  'square-js' | 
  'square-kickstarter' | 
  'square-lastfm' | 
  'square-letterboxd' | 
  'square-minus' | 
  'square-nfi' | 
  'square-odnoklassniki' | 
  'square-parking' | 
  'square-pen' | 
  'square-person-confined' | 
  'square-phone' | 
  'square-phone-flip' | 
  'square-pied-piper' | 
  'square-pinterest' | 
  'square-plus' | 
  'square-poll-horizontal' | 
  'square-poll-vertical' | 
  'square-reddit' | 
  'square-root-alt' | 
  'square-root-variable' | 
  'square-rss' | 
  'square-share-nodes' | 
  'square-snapchat' | 
  'square-steam' | 
  'square-threads' | 
  'square-tumblr' | 
  'square-twitter' | 
  'square-up-right' | 
  'square-upwork' | 
  'square-viadeo' | 
  'square-vimeo' | 
  'square-virus' | 
  'square-web-awesome' | 
  'square-web-awesome-stroke' | 
  'square-whatsapp' | 
  'square-x-twitter' | 
  'square-xing' | 
  'square-xmark' | 
  'square-youtube' | 
  'squarespace' | 
  'stack-exchange' | 
  'stack-overflow' | 
  'stackpath' | 
  'staff-aesculapius' | 
  'staff-snake' | 
  'stairs' | 
  'stamp' | 
  'stapler' | 
  'star' | 
  'star-and-crescent' | 
  'star-half' | 
  'star-half-alt' | 
  'star-half-stroke' | 
  'star-of-david' | 
  'star-of-life' | 
  'staylinked' | 
  'steam' | 
  'steam-square' | 
  'steam-symbol' | 
  'step-backward' | 
  'step-forward' | 
  'sterling-sign' | 
  'stethoscope' | 
  'sticker-mule' | 
  'sticky-note' | 
  'stop' | 
  'stop-circle' | 
  'stopwatch' | 
  'stopwatch-20' | 
  'store' | 
  'store-alt' | 
  'store-alt-slash' | 
  'store-slash' | 
  'strava' | 
  'stream' | 
  'street-view' | 
  'strikethrough' | 
  'stripe' | 
  'stripe-s' | 
  'stroopwafel' | 
  'stubber' | 
  'studiovinari' | 
  'stumbleupon' | 
  'stumbleupon-circle' | 
  'subscript' | 
  'subtract' | 
  'subway' | 
  'suitcase' | 
  'suitcase-medical' | 
  'suitcase-rolling' | 
  'sun' | 
  'sun-plant-wilt' | 
  'superpowers' | 
  'superscript' | 
  'supple' | 
  'surprise' | 
  'suse' | 
  'swatchbook' | 
  'swift' | 
  'swimmer' | 
  'swimming-pool' | 
  'symfony' | 
  'synagogue' | 
  'sync' | 
  'sync-alt' | 
  'syringe' | 
  't' | 
  't-shirt' | 
  'table' | 
  'table-cells' | 
  'table-cells-column-lock' | 
  'table-cells-large' | 
  'table-cells-row-lock' | 
  'table-cells-row-unlock' | 
  'table-columns' | 
  'table-list' | 
  'table-tennis' | 
  'table-tennis-paddle-ball' | 
  'tablet' | 
  'tablet-alt' | 
  'tablet-android' | 
  'tablet-button' | 
  'tablet-screen-button' | 
  'tablets' | 
  'tachograph-digital' | 
  'tachometer' | 
  'tachometer-alt' | 
  'tachometer-alt-average' | 
  'tachometer-alt-fast' | 
  'tachometer-average' | 
  'tachometer-fast' | 
  'tag' | 
  'tags' | 
  'tanakh' | 
  'tape' | 
  'tarp' | 
  'tarp-droplet' | 
  'tasks' | 
  'tasks-alt' | 
  'taxi' | 
  'teamspeak' | 
  'teeth' | 
  'teeth-open' | 
  'telegram' | 
  'telegram-plane' | 
  'teletype' | 
  'television' | 
  'temperature-0' | 
  'temperature-1' | 
  'temperature-2' | 
  'temperature-3' | 
  'temperature-4' | 
  'temperature-arrow-down' | 
  'temperature-arrow-up' | 
  'temperature-down' | 
  'temperature-empty' | 
  'temperature-full' | 
  'temperature-half' | 
  'temperature-high' | 
  'temperature-low' | 
  'temperature-quarter' | 
  'temperature-three-quarters' | 
  'temperature-up' | 
  'tencent-weibo' | 
  'tenge' | 
  'tenge-sign' | 
  'tent' | 
  'tent-arrow-down-to-line' | 
  'tent-arrow-left-right' | 
  'tent-arrow-turn-left' | 
  'tent-arrows-down' | 
  'tents' | 
  'terminal' | 
  'text-height' | 
  'text-slash' | 
  'text-width' | 
  'th' | 
  'th-large' | 
  'th-list' | 
  'the-red-yeti' | 
  'theater-masks' | 
  'themeco' | 
  'themeisle' | 
  'thermometer' | 
  'thermometer-0' | 
  'thermometer-1' | 
  'thermometer-2' | 
  'thermometer-3' | 
  'thermometer-4' | 
  'thermometer-empty' | 
  'thermometer-full' | 
  'thermometer-half' | 
  'thermometer-quarter' | 
  'thermometer-three-quarters' | 
  'think-peaks' | 
  'threads' | 
  'thumb-tack' | 
  'thumb-tack-slash' | 
  'thumbs-down' | 
  'thumbs-up' | 
  'thumbtack' | 
  'thumbtack-slash' | 
  'thunderstorm' | 
  'ticket' | 
  'ticket-alt' | 
  'ticket-simple' | 
  'tiktok' | 
  'timeline' | 
  'times' | 
  'times-circle' | 
  'times-rectangle' | 
  'times-square' | 
  'tint' | 
  'tint-slash' | 
  'tired' | 
  'toggle-off' | 
  'toggle-on' | 
  'toilet' | 
  'toilet-paper' | 
  'toilet-paper-slash' | 
  'toilet-portable' | 
  'toilets-portable' | 
  'toolbox' | 
  'tools' | 
  'tooth' | 
  'torah' | 
  'torii-gate' | 
  'tornado' | 
  'tower-broadcast' | 
  'tower-cell' | 
  'tower-observation' | 
  'tractor' | 
  'trade-federation' | 
  'trademark' | 
  'traffic-light' | 
  'trailer' | 
  'train' | 
  'train-subway' | 
  'train-tram' | 
  'tram' | 
  'transgender' | 
  'transgender-alt' | 
  'trash' | 
  'trash-alt' | 
  'trash-arrow-up' | 
  'trash-can' | 
  'trash-can-arrow-up' | 
  'trash-restore' | 
  'trash-restore-alt' | 
  'tree' | 
  'tree-city' | 
  'trello' | 
  'triangle-circle-square' | 
  'triangle-exclamation' | 
  'trophy' | 
  'trowel' | 
  'trowel-bricks' | 
  'truck' | 
  'truck-arrow-right' | 
  'truck-droplet' | 
  'truck-fast' | 
  'truck-field' | 
  'truck-field-un' | 
  'truck-front' | 
  'truck-loading' | 
  'truck-medical' | 
  'truck-monster' | 
  'truck-moving' | 
  'truck-pickup' | 
  'truck-plane' | 
  'truck-ramp-box' | 
  'try' | 
  'tshirt' | 
  'tty' | 
  'tumblr' | 
  'tumblr-square' | 
  'turkish-lira' | 
  'turkish-lira-sign' | 
  'turn-down' | 
  'turn-up' | 
  'tv' | 
  'tv-alt' | 
  'twitch' | 
  'twitter' | 
  'twitter-square' | 
  'typo3' | 
  'u' | 
  'uber' | 
  'ubuntu' | 
  'uikit' | 
  'umbraco' | 
  'umbrella' | 
  'umbrella-beach' | 
  'uncharted' | 
  'underline' | 
  'undo' | 
  'undo-alt' | 
  'uniregistry' | 
  'unity' | 
  'universal-access' | 
  'university' | 
  'unlink' | 
  'unlock' | 
  'unlock-alt' | 
  'unlock-keyhole' | 
  'unsorted' | 
  'unsplash' | 
  'untappd' | 
  'up-down' | 
  'up-down-left-right' | 
  'up-long' | 
  'up-right-and-down-left-from-center' | 
  'up-right-from-square' | 
  'upload' | 
  'ups' | 
  'upwork' | 
  'usb' | 
  'usd' | 
  'user' | 
  'user-alt' | 
  'user-alt-slash' | 
  'user-astronaut' | 
  'user-check' | 
  'user-circle' | 
  'user-clock' | 
  'user-cog' | 
  'user-doctor' | 
  'user-edit' | 
  'user-friends' | 
  'user-gear' | 
  'user-graduate' | 
  'user-group' | 
  'user-injured' | 
  'user-large' | 
  'user-large-slash' | 
  'user-lock' | 
  'user-md' | 
  'user-minus' | 
  'user-ninja' | 
  'user-nurse' | 
  'user-pen' | 
  'user-plus' | 
  'user-secret' | 
  'user-shield' | 
  'user-slash' | 
  'user-tag' | 
  'user-tie' | 
  'user-times' | 
  'user-xmark' | 
  'users' | 
  'users-between-lines' | 
  'users-cog' | 
  'users-gear' | 
  'users-line' | 
  'users-rays' | 
  'users-rectangle' | 
  'users-slash' | 
  'users-viewfinder' | 
  'usps' | 
  'ussunnah' | 
  'utensil-spoon' | 
  'utensils' | 
  'v' | 
  'vaadin' | 
  'van-shuttle' | 
  'vault' | 
  'vcard' | 
  'vector-square' | 
  'venus' | 
  'venus-double' | 
  'venus-mars' | 
  'vest' | 
  'vest-patches' | 
  'viacoin' | 
  'viadeo' | 
  'viadeo-square' | 
  'vial' | 
  'vial-circle-check' | 
  'vial-virus' | 
  'vials' | 
  'viber' | 
  'video' | 
  'video-camera' | 
  'video-slash' | 
  'vihara' | 
  'vimeo' | 
  'vimeo-square' | 
  'vimeo-v' | 
  'vine' | 
  'virus' | 
  'virus-covid' | 
  'virus-covid-slash' | 
  'virus-slash' | 
  'viruses' | 
  'vk' | 
  'vnv' | 
  'voicemail' | 
  'volcano' | 
  'volleyball' | 
  'volleyball-ball' | 
  'volume-control-phone' | 
  'volume-down' | 
  'volume-high' | 
  'volume-low' | 
  'volume-mute' | 
  'volume-off' | 
  'volume-times' | 
  'volume-up' | 
  'volume-xmark' | 
  'vote-yea' | 
  'vr-cardboard' | 
  'vuejs' | 
  'w' | 
  'walkie-talkie' | 
  'walking' | 
  'wallet' | 
  'wand-magic' | 
  'wand-magic-sparkles' | 
  'wand-sparkles' | 
  'warehouse' | 
  'warning' | 
  'watchman-monitoring' | 
  'water' | 
  'water-ladder' | 
  'wave-square' | 
  'waze' | 
  'web-awesome' | 
  'webflow' | 
  'weebly' | 
  'weibo' | 
  'weight' | 
  'weight-hanging' | 
  'weight-scale' | 
  'weixin' | 
  'whatsapp' | 
  'whatsapp-square' | 
  'wheat-alt' | 
  'wheat-awn' | 
  'wheat-awn-circle-exclamation' | 
  'wheelchair' | 
  'wheelchair-alt' | 
  'wheelchair-move' | 
  'whiskey-glass' | 
  'whmcs' | 
  'wifi' | 
  'wifi-3' | 
  'wifi-strong' | 
  'wikipedia-w' | 
  'wind' | 
  'window-close' | 
  'window-maximize' | 
  'window-minimize' | 
  'window-restore' | 
  'windows' | 
  'wine-bottle' | 
  'wine-glass' | 
  'wine-glass-alt' | 
  'wine-glass-empty' | 
  'wirsindhandwerk' | 
  'wix' | 
  'wizards-of-the-coast' | 
  'wodu' | 
  'wolf-pack-battalion' | 
  'won' | 
  'won-sign' | 
  'wordpress' | 
  'wordpress-simple' | 
  'worm' | 
  'wpbeginner' | 
  'wpexplorer' | 
  'wpforms' | 
  'wpressr' | 
  'wrench' | 
  'wsh' | 
  'x' | 
  'x-ray' | 
  'x-twitter' | 
  'xbox' | 
  'xing' | 
  'xing-square' | 
  'xmark' | 
  'xmark-circle' | 
  'xmark-square' | 
  'xmarks-lines' | 
  'y' | 
  'y-combinator' | 
  'yahoo' | 
  'yammer' | 
  'yandex' | 
  'yandex-international' | 
  'yarn' | 
  'yelp' | 
  'yen' | 
  'yen-sign' | 
  'yin-yang' | 
  'yoast' | 
  'youtube' | 
  'youtube-square' | 
  'z' | 
  'zap' | 
  'zhihu';
