/*  $Id: ecnum_specific.inc 649356 2022-05-02 17:22:41Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  The Enzyme Commission
 *
 * File Description:
 *   Built-in copy of ecnum_specific.txt.
 *
 */

static const char* const kECNum_specific[] = {
    "1.1.1.1\tAlcohol dehydrogenase",
    "1.1.1.2\tAlcohol dehydrogenase (NADP(+))",
    "1.1.1.3\tHomoserine dehydrogenase",
    "1.1.1.4\t(R,R)-butanediol dehydrogenase",
    "1.1.1.6\tGlycerol dehydrogenase",
    "1.1.1.7\tPropanediol-phosphate dehydrogenase",
    "1.1.1.8\tGlycerol-3-phosphate dehydrogenase (NAD(+))",
    "1.1.1.9\tD-xylulose reductase",
    "1.1.1.10\tL-xylulose reductase",
    "1.1.1.11\tD-arabinitol 4-dehydrogenase",
    "1.1.1.12\tL-arabinitol 4-dehydrogenase",
    "1.1.1.13\tL-arabinitol 2-dehydrogenase",
    "1.1.1.14\tL-iditol 2-dehydrogenase",
    "1.1.1.15\tD-iditol 2-dehydrogenase",
    "1.1.1.16\tGalactitol 2-dehydrogenase",
    "1.1.1.17\tMannitol-1-phosphate 5-dehydrogenase",
    "1.1.1.18\tInositol 2-dehydrogenase",
    "1.1.1.19\tGlucuronate reductase",
    "1.1.1.20\tGlucuronolactone reductase",
    "1.1.1.21\tAldose reductase",
    "1.1.1.22\tUDP-glucose 6-dehydrogenase",
    "1.1.1.23\tHistidinol dehydrogenase",
    "1.1.1.24\tQuinate/shikimate dehydrogenase (NAD(+))",
    "1.1.1.25\tShikimate dehydrogenase (NADP(+))",
    "1.1.1.26\tGlyoxylate reductase",
    "1.1.1.27\tL-lactate dehydrogenase",
    "1.1.1.28\tD-lactate dehydrogenase",
    "1.1.1.29\tGlycerate dehydrogenase",
    "1.1.1.30\t3-hydroxybutyrate dehydrogenase",
    "1.1.1.31\t3-hydroxyisobutyrate dehydrogenase",
    "1.1.1.32\tMevaldate reductase",
    "1.1.1.33\tMevaldate reductase (NADPH)",
    "1.1.1.34\tHydroxymethylglutaryl-CoA reductase (NADPH)",
    "1.1.1.35\t3-hydroxyacyl-CoA dehydrogenase",
    "1.1.1.36\tAcetoacetyl-CoA reductase",
    "1.1.1.37\tMalate dehydrogenase",
    "1.1.1.38\tMalate dehydrogenase (oxaloacetate-decarboxylating)",
    "1.1.1.39\tMalate dehydrogenase (decarboxylating)",
    "1.1.1.40\tMalate dehydrogenase (oxaloacetate-decarboxylating) (NADP(+))",
    "1.1.1.41\tIsocitrate dehydrogenase (NAD(+))",
    "1.1.1.42\tIsocitrate dehydrogenase (NADP(+))",
    "1.1.1.43\tPhosphogluconate 2-dehydrogenase",
    "1.1.1.44\tPhosphogluconate dehydrogenase (NADP(+)-dependent, decarboxylating)",
    "1.1.1.45\tL-gulonate 3-dehydrogenase",
    "1.1.1.46\tL-arabinose 1-dehydrogenase",
    "1.1.1.47\tGlucose 1-dehydrogenase (NAD(P)(+))",
    "1.1.1.48\tD-galactose 1-dehydrogenase",
    "1.1.1.49\tGlucose-6-phosphate dehydrogenase (NADP(+))",
    "1.1.1.50\t3-alpha-hydroxysteroid 3-dehydrogenase (Si-specific)",
    "1.1.1.51\t3(or 17)-beta-hydroxysteroid dehydrogenase",
    "1.1.1.52\t3-alpha-hydroxycholanate dehydrogenase (NAD(+))",
    "1.1.1.53\t3-alpha(or 20-beta)-hydroxysteroid dehydrogenase",
    "1.1.1.54\tAllyl-alcohol dehydrogenase",
    "1.1.1.55\tLactaldehyde reductase (NADPH)",
    "1.1.1.56\tRibitol 2-dehydrogenase",
    "1.1.1.57\tFructuronate reductase",
    "1.1.1.58\tTagaturonate reductase",
    "1.1.1.59\t3-hydroxypropionate dehydrogenase",
    "1.1.1.60\t2-hydroxy-3-oxopropionate reductase",
    "1.1.1.61\t4-hydroxybutyrate dehydrogenase",
    "1.1.1.62\t17-beta-estradiol 17-dehydrogenase",
    "1.1.1.64\tTestosterone 17-beta-dehydrogenase (NADP(+))",
    "1.1.1.65\tPyridoxine 4-dehydrogenase",
    "1.1.1.66\tOmega-hydroxydecanoate dehydrogenase",
    "1.1.1.67\tMannitol 2-dehydrogenase",
    "1.1.1.69\tGluconate 5-dehydrogenase",
    "1.1.1.71\tAlcohol dehydrogenase (NAD(P)(+))",
    "1.1.1.72\tGlycerol dehydrogenase (NADP(+))",
    "1.1.1.73\tOctanol dehydrogenase",
    "1.1.1.75\t(R)-aminopropanol dehydrogenase",
    "1.1.1.76\t(S,S)-butanediol dehydrogenase",
    "1.1.1.77\tLactaldehyde reductase",
    "1.1.1.78\tMethylglyoxal reductase (NADH)",
    "1.1.1.79\tGlyoxylate reductase (NADP(+))",
    "1.1.1.80\tIsopropanol dehydrogenase (NADP(+))",
    "1.1.1.81\tHydroxypyruvate reductase",
    "1.1.1.82\tMalate dehydrogenase (NADP(+))",
    "1.1.1.83\tD-malate dehydrogenase (decarboxylating)",
    "1.1.1.84\tDimethylmalate dehydrogenase",
    "1.1.1.85\t3-isopropylmalate dehydrogenase",
    "1.1.1.86\tKetol-acid reductoisomerase (NADP(+))",
    "1.1.1.87\tHomoisocitrate dehydrogenase",
    "1.1.1.88\tHydroxymethylglutaryl-CoA reductase",
    "1.1.1.90\tAryl-alcohol dehydrogenase",
    "1.1.1.91\tAryl-alcohol dehydrogenase (NADP(+))",
    "1.1.1.92\tOxaloglycolate reductase (decarboxylating)",
    "1.1.1.93\tTartrate dehydrogenase",
    "1.1.1.94\tGlycerol-3-phosphate dehydrogenase (NAD(P)(+))",
    "1.1.1.95\tPhosphoglycerate dehydrogenase",
    "1.1.1.96\tDiiodophenylpyruvate reductase",
    "1.1.1.97\t3-hydroxybenzyl-alcohol dehydrogenase",
    "1.1.1.98\t(R)-2-hydroxy-fatty-acid dehydrogenase",
    "1.1.1.99\t(S)-2-hydroxy-fatty-acid dehydrogenase",
    "1.1.1.100\t3-oxoacyl-[acyl-carrier-protein] reductase",
    "1.1.1.101\tAcylglycerone-phosphate reductase",
    "1.1.1.102\t3-dehydrosphinganine reductase",
    "1.1.1.103\tL-threonine 3-dehydrogenase",
    "1.1.1.104\t4-oxoproline reductase",
    "1.1.1.105\tAll-trans-retinol dehydrogenase (NAD(+))",
    "1.1.1.106\tPantoate 4-dehydrogenase",
    "1.1.1.107\tPyridoxal 4-dehydrogenase",
    "1.1.1.108\tCarnitine 3-dehydrogenase",
    "1.1.1.110\tAromatic 2-oxoacid reductase",
    "1.1.1.111\t3-(imidazol-5-yl)lactate dehydrogenase",
    "1.1.1.112\tIndanol dehydrogenase",
    "1.1.1.113\tL-xylose 1-dehydrogenase",
    "1.1.1.114\tApiose 1-reductase",
    "1.1.1.115\tRibose 1-dehydrogenase (NADP(+))",
    "1.1.1.116\tD-arabinose 1-dehydrogenase (NAD(+))",
    "1.1.1.117\tD-arabinose 1-dehydrogenase (NAD(P)(+))",
    "1.1.1.118\tGlucose 1-dehydrogenase (NAD(+))",
    "1.1.1.119\tGlucose 1-dehydrogenase (NADP(+))",
    "1.1.1.120\tGalactose 1-dehydrogenase (NADP(+))",
    "1.1.1.121\tAldose 1-dehydrogenase (NAD(+))",
    "1.1.1.122\tD-threo-aldose 1-dehydrogenase",
    "1.1.1.123\tSorbose 5-dehydrogenase (NADP(+))",
    "1.1.1.124\tFructose 5-dehydrogenase (NADP(+))",
    "1.1.1.125\t2-deoxy-D-gluconate 3-dehydrogenase",
    "1.1.1.126\t2-dehydro-3-deoxy-D-gluconate 6-dehydrogenase",
    "1.1.1.127\t2-dehydro-3-deoxy-D-gluconate 5-dehydrogenase",
    "1.1.1.129\tL-threonate 3-dehydrogenase",
    "1.1.1.130\t3-dehydro-L-gulonate 2-dehydrogenase",
    "1.1.1.131\tMannuronate reductase",
    "1.1.1.132\tGDP-mannose 6-dehydrogenase",
    "1.1.1.133\tdTDP-4-dehydrorhamnose reductase",
    "1.1.1.134\tdTDP-6-deoxy-L-talose 4-dehydrogenase",
    "1.1.1.135\tGDP-6-deoxy-D-talose 4-dehydrogenase",
    "1.1.1.136\tUDP-N-acetylglucosamine 6-dehydrogenase",
    "1.1.1.137\tRibitol-5-phosphate 2-dehydrogenase",
    "1.1.1.138\tMannitol 2-dehydrogenase (NADP(+))",
    "1.1.1.140\tSorbitol-6-phosphate 2-dehydrogenase",
    "1.1.1.141\t15-hydroxyprostaglandin dehydrogenase (NAD(+))",
    "1.1.1.142\tD-pinitol dehydrogenase",
    "1.1.1.143\tSequoyitol dehydrogenase",
    "1.1.1.144\tPerillyl-alcohol dehydrogenase",
    "1.1.1.145\t3-beta-hydroxy-Delta(5)-steroid dehydrogenase",
    "1.1.1.146\t11-beta-hydroxysteroid dehydrogenase",
    "1.1.1.147\t16-alpha-hydroxysteroid dehydrogenase",
    "1.1.1.148\tEstradiol 17-alpha-dehydrogenase",
    "1.1.1.149\t20-alpha-hydroxysteroid dehydrogenase",
    "1.1.1.150\t21-hydroxysteroid dehydrogenase (NAD(+))",
    "1.1.1.151\t21-hydroxysteroid dehydrogenase (NADP(+))",
    "1.1.1.152\t3-alpha-hydroxy-5-beta-androstane-17-one 3-alpha-dehydrogenase",
    "1.1.1.153\tSepiapterin reductase (L-erythro-7,8-dihydrobiopterin forming)",
    "1.1.1.154\tUreidoglycolate dehydrogenase",
    "1.1.1.156\tGlycerol 2-dehydrogenase (NADP(+))",
    "1.1.1.157\t3-hydroxybutyryl-CoA dehydrogenase",
    "1.1.1.159\t7-alpha-hydroxysteroid dehydrogenase",
    "1.1.1.160\tDihydrobunolol dehydrogenase",
    "1.1.1.162\tErythrulose reductase",
    "1.1.1.163\tCyclopentanol dehydrogenase",
    "1.1.1.164\tHexadecanol dehydrogenase",
    "1.1.1.165\t2-alkyn-1-ol dehydrogenase",
    "1.1.1.166\tHydroxycyclohexanecarboxylate dehydrogenase",
    "1.1.1.167\tHydroxymalonate dehydrogenase",
    "1.1.1.168\t2-dehydropantolactone reductase (Re-specific)",
    "1.1.1.169\t2-dehydropantoate 2-reductase",
    "1.1.1.170\t3-beta-hydroxysteroid-4-alpha-carboxylate 3-dehydrogenase (decarboxylating)",
    "1.1.1.172\t2-oxoadipate reductase",
    "1.1.1.173\tL-rhamnose 1-dehydrogenase",
    "1.1.1.174\tCyclohexane-1,2-diol dehydrogenase",
    "1.1.1.175\tD-xylose 1-dehydrogenase",
    "1.1.1.176\t12-alpha-hydroxysteroid dehydrogenase",
    "1.1.1.177\tGlycerol-3-phosphate 1-dehydrogenase (NADP(+))",
    "1.1.1.178\t3-hydroxy-2-methylbutyryl-CoA dehydrogenase",
    "1.1.1.179\tD-xylose 1-dehydrogenase (NADP(+), D-xylono-1,5-lactone-forming)",
    "1.1.1.181\tCholest-5-ene-3-beta,7-alpha-diol 3-beta-dehydrogenase",
    "1.1.1.183\tGeraniol dehydrogenase (NADP(+))",
    "1.1.1.184\tCarbonyl reductase (NADPH)",
    "1.1.1.185\tL-glycol dehydrogenase",
    "1.1.1.186\tdTDP-galactose 6-dehydrogenase",
    "1.1.1.187\tGDP-4-dehydro-D-rhamnose reductase",
    "1.1.1.188\tProstaglandin-F synthase",
    "1.1.1.189\tProstaglandin-E(2) 9-reductase",
    "1.1.1.190\tIndole-3-acetaldehyde reductase (NADH)",
    "1.1.1.191\tIndole-3-acetaldehyde reductase (NADPH)",
    "1.1.1.192\tLong-chain-alcohol dehydrogenase",
    "1.1.1.193\t5-amino-6-(5-phosphoribosylamino)uracil reductase",
    "1.1.1.194\tConiferyl-alcohol dehydrogenase",
    "1.1.1.195\tCinnamyl-alcohol dehydrogenase",
    "1.1.1.196\t15-hydroxyprostaglandin-D dehydrogenase (NADP(+))",
    "1.1.1.197\t15-hydroxyprostaglandin dehydrogenase (NADP(+))",
    "1.1.1.198\t(+)-borneol dehydrogenase",
    "1.1.1.199\t(S)-usnate reductase",
    "1.1.1.200\tAldose-6-phosphate reductase (NADPH)",
    "1.1.1.201\t7-beta-hydroxysteroid dehydrogenase (NADP(+))",
    "1.1.1.202\t1,3-propanediol dehydrogenase",
    "1.1.1.203\tUronate dehydrogenase",
    "1.1.1.205\tIMP dehydrogenase",
    "1.1.1.206\tTropinone reductase I",
    "1.1.1.207\t(-)-menthol dehydrogenase",
    "1.1.1.208\t(+)-neomenthol dehydrogenase",
    "1.1.1.209\t3(or 17)-alpha-hydroxysteroid dehydrogenase",
    "1.1.1.210\t3-beta-(or 20-alpha)-hydroxysteroid dehydrogenase",
    "1.1.1.211\tLong-chain-3-hydroxyacyl-CoA dehydrogenase",
    "1.1.1.212\t3-oxoacyl-[acyl-carrier-protein] reductase (NADH)",
    "1.1.1.213\t3-alpha-hydroxysteroid dehydrogenase (Re-specific)",
    "1.1.1.214\t2-dehydropantolactone reductase (Si-specific)",
    "1.1.1.215\tGluconate 2-dehydrogenase",
    "1.1.1.216\tFarnesol dehydrogenase",
    "1.1.1.217\tBenzyl-2-methyl-hydroxybutyrate dehydrogenase",
    "1.1.1.218\tMorphine 6-dehydrogenase",
    "1.1.1.219\tDihydroflavanol 4-reductase",
    "1.1.1.220\t6-pyruvoyltetrahydropterin 2'-reductase",
    "1.1.1.221\tVomifoliol dehydrogenase",
    "1.1.1.222\t(R)-4-hydroxyphenyllactate dehydrogenase",
    "1.1.1.223\tIsopiperitenol dehydrogenase",
    "1.1.1.224\tMannose-6-phosphate 6-reductase",
    "1.1.1.225\tChlordecone reductase",
    "1.1.1.226\t4-hydroxycyclohexanecarboxylate dehydrogenase",
    "1.1.1.227\t(-)-borneol dehydrogenase",
    "1.1.1.228\t(+)-sabinol dehydrogenase",
    "1.1.1.229\tDiethyl 2-methyl-3-oxosuccinate reductase",
    "1.1.1.230\t3-alpha-hydroxyglycyrrhetinate dehydrogenase",
    "1.1.1.231\t15-hydroxyprostaglandin-I dehydrogenase (NADP(+))",
    "1.1.1.232\t15-hydroxyicosatetraenoate dehydrogenase",
    "1.1.1.233\tN-acylmannosamine 1-dehydrogenase",
    "1.1.1.234\tFlavanone 4-reductase",
    "1.1.1.235\t8-oxocoformycin reductase",
    "1.1.1.236\tTropinone reductase II",
    "1.1.1.237\tHydroxyphenylpyruvate reductase",
    "1.1.1.238\t12-beta-hydroxysteroid dehydrogenase",
    "1.1.1.239\t3-alpha-(17-beta)-hydroxysteroid dehydrogenase (NAD(+))",
    "1.1.1.240\tN-acetylhexosamine 1-dehydrogenase",
    "1.1.1.241\t6-endo-hydroxycineole dehydrogenase",
    "1.1.1.243\tCarveol dehydrogenase",
    "1.1.1.244\tMethanol dehydrogenase",
    "1.1.1.245\tCyclohexanol dehydrogenase",
    "1.1.1.247\tCodeinone reductase (NADPH)",
    "1.1.1.248\tSalutaridine reductase (NADPH)",
    "1.1.1.250\tD-arabinitol 2-dehydrogenase",
    "1.1.1.251\tGalactitol-1-phosphate 5-dehydrogenase",
    "1.1.1.252\tTetrahydroxynaphthalene reductase",
    "1.1.1.254\t(S)-carnitine 3-dehydrogenase",
    "1.1.1.255\tMannitol dehydrogenase",
    "1.1.1.256\tFluoren-9-ol dehydrogenase",
    "1.1.1.257\t4-(hydroxymethyl)benzenesulfonate dehydrogenase",
    "1.1.1.258\t6-hydroxyhexanoate dehydrogenase",
    "1.1.1.259\t3-hydroxypimeloyl-CoA dehydrogenase",
    "1.1.1.260\tSulcatone reductase",
    "1.1.1.261\tsn-glycerol-1-phosphate dehydrogenase",
    "1.1.1.262\t4-hydroxythreonine-4-phosphate dehydrogenase",
    "1.1.1.263\t1,5-anhydro-D-fructose reductase",
    "1.1.1.264\tL-idonate 5-dehydrogenase (NAD(P)(+))",
    "1.1.1.265\t3-methylbutanal reductase",
    "1.1.1.266\tdTDP-4-dehydro-6-deoxyglucose reductase",
    "1.1.1.267\t1-deoxy-D-xylulose-5-phosphate reductoisomerase",
    "1.1.1.268\t2-(R)-hydroxypropyl-CoM dehydrogenase",
    "1.1.1.269\t2-(S)-hydroxypropyl-CoM dehydrogenase",
    "1.1.1.270\t3-beta-hydroxysteroid 3-dehydrogenase",
    "1.1.1.271\tGDP-L-fucose synthase",
    "1.1.1.272\tD-2-hydroxyacid dehydrogenase (NADP(+))",
    "1.1.1.273\tVellosimine dehydrogenase",
    "1.1.1.274\t2,5-didehydrogluconate reductase (2-dehydro-D-gluconate-forming)",
    "1.1.1.275\t(+)-trans-carveol dehydrogenase",
    "1.1.1.276\tSerine 3-dehydrogenase (NADP(+))",
    "1.1.1.277\t3-beta-hydroxy-5-beta-steroid dehydrogenase",
    "1.1.1.278\t3-beta-hydroxy-5-alpha-steroid dehydrogenase",
    "1.1.1.279\t(R)-3-hydroxyacid-ester dehydrogenase",
    "1.1.1.280\t(S)-3-hydroxyacid-ester dehydrogenase",
    "1.1.1.281\tGDP-4-dehydro-6-deoxy-D-mannose reductase",
    "1.1.1.282\tQuinate/shikimate dehydrogenase (NAD(P)(+))",
    "1.1.1.283\tMethylglyoxal reductase (NADPH)",
    "1.1.1.284\tS-(hydroxymethyl)glutathione dehydrogenase",
    "1.1.1.285\t3''-deamino-3''-oxonicotianamine reductase",
    "1.1.1.286\tIsocitrate--homoisocitrate dehydrogenase",
    "1.1.1.287\tD-arabinitol dehydrogenase (NADP(+))",
    "1.1.1.288\tXanthoxin dehydrogenase",
    "1.1.1.289\tSorbose reductase",
    "1.1.1.290\t4-phosphoerythronate dehydrogenase",
    "1.1.1.291\t2-hydroxymethylglutarate dehydrogenase",
    "1.1.1.292\t1,5-anhydro-D-fructose reductase (1,5-anhydro-D-mannitol-forming)",
    "1.1.1.294\tChlorophyll(ide) b reductase",
    "1.1.1.295\tMomilactone-A synthase",
    "1.1.1.296\tDihydrocarveol dehydrogenase",
    "1.1.1.297\tLimonene-1,2-diol dehydrogenase",
    "1.1.1.298\t3-hydroxypropionate dehydrogenase (NADP(+))",
    "1.1.1.299\tMalate dehydrogenase (NAD(P)(+))",
    "1.1.1.300\tNADP-retinol dehydrogenase",
    "1.1.1.301\tD-arabitol-phosphate dehydrogenase",
    "1.1.1.302\t2,5-diamino-6-(ribosylamino)-4(3H)-pyrimidinone 5'-phosphate reductase",
    "1.1.1.303\tDiacetyl reductase ((R)-acetoin forming)",
    "1.1.1.304\tDiacetyl reductase ((S)-acetoin forming)",
    "1.1.1.305\tUDP-glucuronic acid oxidase (UDP-4-keto-hexauronic acid decarboxylating)",
    "1.1.1.306\tS-(hydroxymethyl)mycothiol dehydrogenase",
    "1.1.1.307\tD-xylose reductase",
    "1.1.1.308\tSulfopropanediol 3-dehydrogenase",
    "1.1.1.309\tPhosphonoacetaldehyde reductase (NADH)",
    "1.1.1.310\t(S)-sulfolactate dehydrogenase",
    "1.1.1.311\t(S)-1-phenylethanol dehydrogenase",
    "1.1.1.312\t2-hydroxy-4-carboxymuconate semialdehyde hemiacetal dehydrogenase",
    "1.1.1.313\tSulfoacetaldehyde reductase",
    "1.1.1.314\tGermacrene A alcohol dehydrogenase",
    "1.1.1.315\t11-cis-retinol dehydrogenase",
    "1.1.1.316\tL-galactose 1-dehydrogenase",
    "1.1.1.317\tPerakine reductase",
    "1.1.1.318\tEugenol synthase",
    "1.1.1.319\tIsoeugenol synthase",
    "1.1.1.320\tBenzil reductase ((S)-benzoin forming)",
    "1.1.1.321\tBenzil reductase ((R)-benzoin forming)",
    "1.1.1.322\t(-)-endo-fenchol dehydrogenase",
    "1.1.1.323\t(+)-thujan-3-ol dehydrogenase",
    "1.1.1.324\t8-hydroxygeraniol dehydrogenase",
    "1.1.1.325\tSepiapterin reductase (L-threo-7,8-dihydrobiopterin forming)",
    "1.1.1.326\tZerumbone synthase",
    "1.1.1.327\t5-exo-hydroxycamphor dehydrogenase",
    "1.1.1.328\tNicotine blue oxidoreductase",
    "1.1.1.329\t2-deoxy-scyllo-inosamine dehydrogenase",
    "1.1.1.330\tVery-long-chain 3-oxoacyl-CoA reductase",
    "1.1.1.331\tSecoisolariciresinol dehydrogenase",
    "1.1.1.332\tChanoclavine-I dehydrogenase",
    "1.1.1.333\tDecaprenylphospho-beta-D-erythro-pentofuranosid-2-ulose 2-reductase",
    "1.1.1.334\tMethylecgonone reductase",
    "1.1.1.335\tUDP-N-acetyl-2-amino-2-deoxyglucuronate dehydrogenase",
    "1.1.1.336\tUDP-N-acetyl-D-mannosamine dehydrogenase",
    "1.1.1.337\tL-2-hydroxycarboxylate dehydrogenase (NAD(+))",
    "1.1.1.338\t(2R)-3-sulfolactate dehydrogenase (NADP(+))",
    "1.1.1.339\tdTDP-6-deoxy-L-talose 4-dehydrogenase (NAD(+))",
    "1.1.1.340\t1-deoxy-11-beta-hydroxypentalenate dehydrogenase",
    "1.1.1.341\tCDP-abequose synthase",
    "1.1.1.342\tCDP-paratose synthase",
    "1.1.1.343\tPhosphogluconate dehydrogenase (NAD(+)-dependent, decarboxylating)",
    "1.1.1.344\tdTDP-6-deoxy-L-talose 4-dehydrogenase (NAD(P)(+))",
    "1.1.1.345\tD-2-hydroxyacid dehydrogenase (NAD(+))",
    "1.1.1.346\t2,5-didehydrogluconate reductase (2-dehydro-L-gulonate-forming)",
    "1.1.1.347\tGeraniol dehydrogenase (NAD(+))",
    "1.1.1.348\t(3R)-2'-hydroxyisoflavanone reductase",
    "1.1.1.349\tNorsolorinic acid ketoreductase",
    "1.1.1.350\tUreidoglycolate dehydrogenase (NAD(+))",
    "1.1.1.351\tPhosphogluconate dehydrogenase (NAD(P)(+)-dependent, decarboxylating)",
    "1.1.1.352\t5'-hydroxyaverantin dehydrogenase",
    "1.1.1.353\tVersiconal hemiacetal acetate reductase",
    "1.1.1.354\tFarnesol dehydrogenase (NAD(+))",
    "1.1.1.355\t2'-dehydrokanamycin reductase",
    "1.1.1.356\tGDP-L-colitose synthase",
    "1.1.1.357\t3-alpha-hydroxysteroid 3-dehydrogenase",
    "1.1.1.358\t2-dehydropantolactone reductase",
    "1.1.1.359\tAldose 1-dehydrogenase (NAD(P)(+))",
    "1.1.1.360\tGlucose/galactose 1-dehydrogenase",
    "1.1.1.361\tGlucose-6-phosphate 3-dehydrogenase",
    "1.1.1.362\tAklaviketone reductase",
    "1.1.1.363\tGlucose-6-phosphate dehydrogenase (NAD(P)(+))",
    "1.1.1.364\tdTDP-4-dehydro-6-deoxy-alpha-D-gulose 4-ketoreductase",
    "1.1.1.365\tD-galacturonate reductase",
    "1.1.1.366\tL-idonate 5-dehydrogenase (NAD(+))",
    "1.1.1.367\tUDP-2-acetamido-2,6-beta-L-arabino-hexul-4-ose reductase",
    "1.1.1.368\t6-hydroxycyclohex-1-ene-1-carbonyl-CoA dehydrogenase",
    "1.1.1.369\tD-chiro-inositol 1-dehydrogenase",
    "1.1.1.370\tScyllo-inositol 2-dehydrogenase (NAD(+))",
    "1.1.1.371\tScyllo-inositol 2-dehydrogenase (NADP(+))",
    "1.1.1.372\tD/L-glyceraldehyde reductase",
    "1.1.1.373\tSulfolactaldehyde 3-reductase",
    "1.1.1.374\tUDP-N-acetylglucosamine 3-dehydrogenase",
    "1.1.1.375\tL-2-hydroxycarboxylate dehydrogenase (NAD(P)(+))",
    "1.1.1.376\tL-arabinose 1-dehydrogenase (NAD(P)(+))",
    "1.1.1.377\tL-rhamnose 1-dehydrogenase (NADP(+))",
    "1.1.1.378\tL-rhamnose 1-dehydrogenase (NAD(P)(+))",
    "1.1.1.379\t(R)-mandelate dehydrogenase",
    "1.1.1.380\tL-gulonate 5-dehydrogenase",
    "1.1.1.381\t3-hydroxy acid dehydrogenase",
    "1.1.1.382\tKetol-acid reductoisomerase (NAD(+))",
    "1.1.1.383\tKetol-acid reductoisomerase (NAD(P)(+))",
    "1.1.1.384\tdTDP-3,4-didehydro-2,6-dideoxy-alpha-D-glucose 3-reductase",
    "1.1.1.385\tDihydroanticapsin 7-dehydrogenase",
    "1.1.1.386\tIpsdienol dehydrogenase",
    "1.1.1.387\tL-serine 3-dehydrogenase (NAD(+))",
    "1.1.1.388\tGlucose-6-phosphate dehydrogenase (NAD(+))",
    "1.1.1.389\t2-dehydro-3-deoxy-L-galactonate 5-dehydrogenase",
    "1.1.1.390\tSulfoquinovose 1-dehydrogenase",
    "1.1.1.391\t3-beta-hydroxycholanate 3-dehydrogenase (NAD(+))",
    "1.1.1.392\t3-alpha-hydroxycholanate dehydrogenase (NADP(+))",
    "1.1.1.393\t3-beta-hydroxycholanate 3-dehydrogenase (NADP(+))",
    "1.1.1.394\tAurachin B dehydrogenase",
    "1.1.1.395\t3-alpha-hydroxybile acid CoA 3-dehydrogenase",
    "1.1.1.396\tBacteriochlorophyllide-a dehydrogenase",
    "1.1.1.397\tBeta-methylindole-3-pyruvate reductase",
    "1.1.1.398\t2-glutathionyl-2-methylbut-3-en-1-ol dehydrogenase",
    "1.1.1.399\t2-oxoglutarate reductase",
    "1.1.1.400\t2-methyl-1,2-propanediol dehydrogenase",
    "1.1.1.401\t2-dehydro-3-deoxy-L-rhamnonate dehydrogenase (NAD(+))",
    "1.1.1.402\tD-erythritol 1-phosphate dehydrogenase",
    "1.1.1.403\tD-threitol dehydrogenase (NAD(+))",
    "1.1.1.404\tTetrachlorobenzoquinone reductase",
    "1.1.1.405\tRibitol-5-phosphate 2-dehydrogenase (NADP(+))",
    "1.1.1.406\tGalactitol 2-dehydrogenase (L-tagatose-forming)",
    "1.1.1.407\tD-altritol 5-dehydrogenase",
    "1.1.1.408\t4-phospho-D-threonate 3-dehydrogenase",
    "1.1.1.409\t4-phospho-D-erythronate 3-dehydrogenase",
    "1.1.1.410\tD-erythronate 2-dehydrogenase",
    "1.1.1.411\tL-threonate 2-dehydrogenase",
    "1.1.1.412\t2-alkyl-3-oxoalkanoate reductase",
    "1.1.1.413\tA-factor type gamma-butyrolactone 1'-reductase (1S-forming)",
    "1.1.1.414\tL-galactonate 5-dehydrogenase",
    "1.1.1.415\tNoscapine synthase",
    "1.1.1.416\tIsopyridoxal dehydrogenase (5-pyridoxolactone-forming)",
    "1.1.1.417\t3-beta-hydroxysteroid-4-beta-carboxylate 3-dehydrogenase (decarboxylating)",
    "1.1.1.418\tPlant 3-beta-hydroxysteroid-4-alpha-carboxylate 3-dehydrogenase (decarboxylating)",
    "1.1.1.419\tNepetalactol dehydrogenase",
    "1.1.1.420\tD-apiose dehydrogenase",
    "1.1.1.421\tD-apionate oxidoisomerase",
    "1.1.1.422\tPseudoephedrine dehydrogenase",
    "1.1.1.423\t(1R,2S)-ephedrine 1-dehydrogenase",
    "1.1.1.424\tD-xylose 1-dehydrogenase (NADP(+), D-xylono-1,4-lactone-forming)",
    "1.1.1.425\tLevoglucosan dehydrogenase",
    "1.1.1.426\tUDP-N-acetyl-alpha-D-quinovosamine dehydrogenase",
    "1.1.1.n4\t(-)-trans-carveol dehydrogenase",
    "1.1.1.n5\t3-methylmalate dehydrogenase",
    "1.1.1.n11\tSuccinic semialdehyde reductase",
    "1.1.1.n12\t(3R)-hydroxyacyl-CoA dehydrogenase",
    "1.1.2.2\tMannitol dehydrogenase (cytochrome)",
    "1.1.2.3\tL-lactate dehydrogenase (cytochrome)",
    "1.1.2.4\tD-lactate dehydrogenase (cytochrome)",
    "1.1.2.5\tD-lactate dehydrogenase (cytochrome c-553)",
    "1.1.2.6\tPolyvinyl alcohol dehydrogenase (cytochrome)",
    "1.1.2.7\tMethanol dehydrogenase (cytochrome c)",
    "1.1.2.8\tAlcohol dehydrogenase (cytochrome c)",
    "1.1.2.9\t1-butanol dehydrogenase (cytochrome c)",
    "1.1.2.10\tLanthanide-dependent methanol dehydrogenase",
    "1.1.3.4\tGlucose oxidase",
    "1.1.3.5\tHexose oxidase",
    "1.1.3.6\tCholesterol oxidase",
    "1.1.3.7\tAryl-alcohol oxidase",
    "1.1.3.8\tL-gulonolactone oxidase",
    "1.1.3.9\tGalactose oxidase",
    "1.1.3.10\tPyranose oxidase",
    "1.1.3.11\tL-sorbose oxidase",
    "1.1.3.12\tPyridoxine 4-oxidase",
    "1.1.3.13\tAlcohol oxidase",
    "1.1.3.14\tCatechol oxidase (dimerizing)",
    "1.1.3.15\t(S)-2-hydroxy-acid oxidase",
    "1.1.3.16\tEcdysone oxidase",
    "1.1.3.17\tCholine oxidase",
    "1.1.3.18\tSecondary-alcohol oxidase",
    "1.1.3.19\t4-hydroxymandelate oxidase (decarboxylating)",
    "1.1.3.20\tLong-chain-alcohol oxidase",
    "1.1.3.21\tGlycerol-3-phosphate oxidase",
    "1.1.3.23\tThiamine oxidase",
    "1.1.3.27\tHydroxyphytanate oxidase",
    "1.1.3.28\tNucleoside oxidase",
    "1.1.3.29\tN-acylhexosamine oxidase",
    "1.1.3.30\tPolyvinyl-alcohol oxidase",
    "1.1.3.37\tD-arabinono-1,4-lactone oxidase",
    "1.1.3.38\tVanillyl-alcohol oxidase",
    "1.1.3.39\tNucleoside oxidase (H(2)O(2)-forming)",
    "1.1.3.40\tD-mannitol oxidase",
    "1.1.3.41\tAlditol oxidase",
    "1.1.3.42\tProsolanapyrone-II oxidase",
    "1.1.3.43\tParomamine 6'-oxidase",
    "1.1.3.44\t6'''-hydroxyneomycin C oxidase",
    "1.1.3.45\tAclacinomycin-N oxidase",
    "1.1.3.46\t4-hydroxymandelate oxidase",
    "1.1.3.47\t5-(hydroxymethyl)furfural oxidase",
    "1.1.3.48\t3-deoxy-alpha-D-manno-octulosonate 8-oxidase",
    "1.1.3.49\t(R)-mandelonitrile oxidase",
    "1.1.5.2\tQuinoprotein glucose dehydrogenase (PQQ, quinone)",
    "1.1.5.3\tGlycerol-3-phosphate dehydrogenase",
    "1.1.5.4\tMalate dehydrogenase (quinone)",
    "1.1.5.5\tAlcohol dehydrogenase (quinone)",
    "1.1.5.7\tCyclic alcohol dehydrogenase (quinone)",
    "1.1.5.8\tQuinate/shikimate dehydrogenase (quinone)",
    "1.1.5.9\tGlucose 1-dehydrogenase (FAD, quinone)",
    "1.1.5.10\tD-2-hydroxyacid dehydrogenase (quinone)",
    "1.1.5.11\t1-butanol dehydrogenase (quinone)",
    "1.1.5.12\tD-lactate dehydrogenase (quinone)",
    "1.1.5.13\t(S)-2-hydroxyglutarate dehydrogenase",
    "1.1.5.14\tFructose 5-dehydrogenase",
    "1.1.5.n1\tQuinoprotein inositol dehydrogenase",
    "1.1.7.1\t4-hydroxybenzoyl-CoA reductase",
    "1.1.9.1\tAlcohol dehydrogenase (azurin)",
    "1.1.98.2\tGlucose-6-phosphate dehydrogenase (coenzyme-F420)",
    "1.1.98.3\tDecaprenylphospho-beta-D-ribofuranose 2-dehydrogenase",
    "1.1.98.4\tF420H(2):quinone oxidoreductase",
    "1.1.98.5\tSecondary-alcohol dehydrogenase (coenzyme-F420)",
    "1.1.98.6\tRibonucleoside-triphosphate reductase (formate)",
    "1.1.98.7\tSerine-type anaerobic sulfatase-maturating enzyme",
    "1.1.99.1\tCholine dehydrogenase",
    "1.1.99.2\tL-2-hydroxyglutarate dehydrogenase",
    "1.1.99.3\tGluconate 2-dehydrogenase (acceptor)",
    "1.1.99.4\tDehydrogluconate dehydrogenase",
    "1.1.99.6\tD-lactate dehydrogenase (acceptor)",
    "1.1.99.7\tLactate--malate transhydrogenase",
    "1.1.99.9\tPyridoxine 5-dehydrogenase",
    "1.1.99.12\tSorbose dehydrogenase",
    "1.1.99.13\tGlucoside 3-dehydrogenase",
    "1.1.99.14\tGlycolate dehydrogenase",
    "1.1.99.18\tCellobiose dehydrogenase (acceptor)",
    "1.1.99.20\tAlkan-1-ol dehydrogenase (acceptor)",
    "1.1.99.21\tD-sorbitol dehydrogenase (acceptor)",
    "1.1.99.22\tGlycerol dehydrogenase (acceptor)",
    "1.1.99.24\tHydroxyacid-oxoacid transhydrogenase",
    "1.1.99.26\t3-hydroxycyclohexanone dehydrogenase",
    "1.1.99.27\t(R)-pantolactone dehydrogenase (flavin)",
    "1.1.99.28\tGlucose-fructose oxidoreductase",
    "1.1.99.29\tPyranose dehydrogenase (acceptor)",
    "1.1.99.30\t2-oxo-acid reductase",
    "1.1.99.31\t(S)-mandelate dehydrogenase",
    "1.1.99.32\tL-sorbose 1-dehydrogenase",
    "1.1.99.35\tSoluble quinoprotein glucose dehydrogenase",
    "1.1.99.36\tAlcohol dehydrogenase (nicotinoprotein)",
    "1.1.99.37\tMethanol dehydrogenase (nicotinoprotein)",
    "1.1.99.38\t2-deoxy-scyllo-inosamine dehydrogenase (AdoMet-dependent)",
    "1.1.99.39\tD-2-hydroxyglutarate dehydrogenase",
    "1.1.99.40\t(R)-2-hydroxyglutarate--pyruvate transhydrogenase",
    "1.1.99.41\t3-hydroxy-1,2-didehydro-2,3-dihydrotabersonine reductase",
    "1.1.99.42\t4-pyridoxate dehydrogenase",
    "1.2.1.3\tAldehyde dehydrogenase (NAD(+))",
    "1.2.1.4\tAldehyde dehydrogenase (NADP(+))",
    "1.2.1.5\tAldehyde dehydrogenase (NAD(P)(+))",
    "1.2.1.7\tBenzaldehyde dehydrogenase (NADP(+))",
    "1.2.1.8\tBetaine-aldehyde dehydrogenase",
    "1.2.1.9\tGlyceraldehyde-3-phosphate dehydrogenase (NADP(+))",
    "1.2.1.10\tAcetaldehyde dehydrogenase (acetylating)",
    "1.2.1.11\tAspartate-semialdehyde dehydrogenase",
    "1.2.1.12\tGlyceraldehyde-3-phosphate dehydrogenase (phosphorylating)",
    "1.2.1.13\tGlyceraldehyde-3-phosphate dehydrogenase (NADP(+)) (phosphorylating)",
    "1.2.1.15\tMalonate-semialdehyde dehydrogenase",
    "1.2.1.16\tSuccinate-semialdehyde dehydrogenase (NAD(P)(+))",
    "1.2.1.17\tGlyoxylate dehydrogenase (acylating)",
    "1.2.1.18\tMalonate-semialdehyde dehydrogenase (acetylating)",
    "1.2.1.19\tAminobutyraldehyde dehydrogenase",
    "1.2.1.20\tGlutarate-semialdehyde dehydrogenase",
    "1.2.1.21\tGlycolaldehyde dehydrogenase",
    "1.2.1.22\tLactaldehyde dehydrogenase",
    "1.2.1.23\t2-oxoaldehyde dehydrogenase (NAD(+))",
    "1.2.1.24\tSuccinate-semialdehyde dehydrogenase (NAD(+))",
    "1.2.1.25\tBranched-chain alpha-keto acid dehydrogenase system",
    "1.2.1.26\t2,5-dioxovalerate dehydrogenase",
    "1.2.1.27\tMethylmalonate-semialdehyde dehydrogenase (CoA acylating)",
    "1.2.1.28\tBenzaldehyde dehydrogenase (NAD(+))",
    "1.2.1.29\tAryl-aldehyde dehydrogenase",
    "1.2.1.30\tCarboxylate reductase (NADP(+))",
    "1.2.1.31\tL-aminoadipate-semialdehyde dehydrogenase",
    "1.2.1.32\tAminomuconate-semialdehyde dehydrogenase",
    "1.2.1.33\t(R)-dehydropantoate dehydrogenase",
    "1.2.1.36\tRetinal dehydrogenase",
    "1.2.1.38\tN-acetyl-gamma-glutamyl-phosphate reductase",
    "1.2.1.39\tPhenylacetaldehyde dehydrogenase",
    "1.2.1.41\tGlutamate-5-semialdehyde dehydrogenase",
    "1.2.1.42\tHexadecanal dehydrogenase (acylating)",
    "1.2.1.44\tCinnamoyl-CoA reductase",
    "1.2.1.46\tFormaldehyde dehydrogenase",
    "1.2.1.47\t4-trimethylammoniobutyraldehyde dehydrogenase",
    "1.2.1.48\tLong-chain-aldehyde dehydrogenase",
    "1.2.1.49\t2-oxoaldehyde dehydrogenase (NADP(+))",
    "1.2.1.50\tLong-chain-fatty-acyl-CoA reductase",
    "1.2.1.51\tPyruvate dehydrogenase (NADP(+))",
    "1.2.1.52\tOxoglutarate dehydrogenase (NADP(+))",
    "1.2.1.53\t4-hydroxyphenylacetaldehyde dehydrogenase",
    "1.2.1.54\tGamma-guanidinobutyraldehyde dehydrogenase",
    "1.2.1.57\tButanal dehydrogenase",
    "1.2.1.58\tPhenylglyoxylate dehydrogenase (acylating)",
    "1.2.1.59\tGlyceraldehyde-3-phosphate dehydrogenase (NAD(P)(+)) (phosphorylating)",
    "1.2.1.60\t5-carboxymethyl-2-hydroxymuconic-semialdehyde dehydrogenase",
    "1.2.1.61\t4-hydroxymuconic-semialdehyde dehydrogenase",
    "1.2.1.62\t4-formylbenzenesulfonate dehydrogenase",
    "1.2.1.63\t6-oxohexanoate dehydrogenase",
    "1.2.1.64\t4-hydroxybenzaldehyde dehydrogenase (NAD(+))",
    "1.2.1.65\tSalicylaldehyde dehydrogenase",
    "1.2.1.67\tVanillin dehydrogenase",
    "1.2.1.68\tConiferyl-aldehyde dehydrogenase",
    "1.2.1.69\tFluoroacetaldehyde dehydrogenase",
    "1.2.1.70\tGlutamyl-tRNA reductase",
    "1.2.1.71\tSuccinylglutamate-semialdehyde dehydrogenase",
    "1.2.1.72\tErythrose-4-phosphate dehydrogenase",
    "1.2.1.73\tSulfoacetaldehyde dehydrogenase",
    "1.2.1.74\tAbieta-7,13-dien-18-al dehydrogenase",
    "1.2.1.75\tMalonyl CoA reductase (malonate semialdehyde-forming)",
    "1.2.1.76\tSuccinate-semialdehyde dehydrogenase (acetylating)",
    "1.2.1.77\t3,4-dehydroadipyl-CoA semialdehyde dehydrogenase (NADP(+))",
    "1.2.1.78\t2-formylbenzoate dehydrogenase",
    "1.2.1.79\tSuccinate-semialdehyde dehydrogenase (NADP(+))",
    "1.2.1.80\tLong-chain acyl-[acyl-carrier-protein] reductase",
    "1.2.1.81\tSulfoacetaldehyde dehydrogenase (acylating)",
    "1.2.1.82\tBeta-apo-4'-carotenal oxygenase",
    "1.2.1.83\t3-succinoylsemialdehyde-pyridine dehydrogenase",
    "1.2.1.84\tAlcohol-forming fatty acyl-CoA reductase",
    "1.2.1.85\t2-hydroxymuconate-6-semialdehyde dehydrogenase",
    "1.2.1.86\tGeranial dehydrogenase",
    "1.2.1.87\tPropanal dehydrogenase (CoA-propanoylating)",
    "1.2.1.88\tL-glutamate gamma-semialdehyde dehydrogenase",
    "1.2.1.89\tD-glyceraldehyde dehydrogenase (NADP(+))",
    "1.2.1.90\tGlyceraldehyde-3-phosphate dehydrogenase (NAD(P)(+))",
    "1.2.1.91\t3-oxo-5,6-dehydrosuberyl-CoA semialdehyde dehydrogenase",
    "1.2.1.92\t3,6-anhydro-alpha-L-galactose dehydrogenase",
    "1.2.1.94\tFarnesal dehydrogenase",
    "1.2.1.95\tL-2-aminoadipate reductase",
    "1.2.1.96\t4-hydroxybenzaldehyde dehydrogenase (NADP(+))",
    "1.2.1.97\t3-sulfolactaldehyde dehydrogenase",
    "1.2.1.98\t2-hydroxy-2-methylpropanal dehydrogenase",
    "1.2.1.99\t4-(gamma-glutamylamino)butanal dehydrogenase",
    "1.2.1.100\t5-formyl-3-hydroxy-2-methylpyridine 4-carboxylate 5-dehydrogenase",
    "1.2.1.101\tL-tyrosine reductase",
    "1.2.1.102\tIsopyridoxal dehydrogenase (5-pyridoxate-forming)",
    "1.2.1.103\t[Amino-group carrier protein]-6-phospho-L-2-aminoadipate reductase",
    "1.2.1.104\tPyruvate dehydrogenase system",
    "1.2.1.105\t2-oxoglutarate dehydrogenase system",
    "1.2.1.106\t[Amino-group carrier protein]-5-phospho-L-glutamate reductase",
    "1.2.1.107\tGlyceraldehyde-3-phosphate dehydrogenase (arsenate-transferring)",
    "1.2.1.n2\tFatty acyl-CoA reductase",
    "1.2.2.1\tFormate dehydrogenase (cytochrome)",
    "1.2.3.1\tAldehyde oxidase",
    "1.2.3.3\tPyruvate oxidase",
    "1.2.3.4\tOxalate oxidase",
    "1.2.3.5\tGlyoxylate oxidase",
    "1.2.3.6\tPyruvate oxidase (CoA-acetylating)",
    "1.2.3.7\tIndole-3-acetaldehyde oxidase",
    "1.2.3.8\tPyridoxal oxidase",
    "1.2.3.9\tAryl-aldehyde oxidase",
    "1.2.3.13\t4-hydroxyphenylpyruvate oxidase",
    "1.2.3.14\tAbscisic-aldehyde oxidase",
    "1.2.3.15\t(Methyl)glyoxal oxidase",
    "1.2.4.1\tPyruvate dehydrogenase (acetyl-transferring)",
    "1.2.4.2\tOxoglutarate dehydrogenase (succinyl-transferring)",
    "1.2.4.4\t3-methyl-2-oxobutanoate dehydrogenase (2-methylpropanoyl-transferring)",
    "1.2.5.1\tPyruvate dehydrogenase (quinone)",
    "1.2.5.2\tAldehyde dehydrogenase (quinone)",
    "1.2.5.3\tAerobic carbon monoxide dehydrogenase",
    "1.2.7.1\tPyruvate synthase",
    "1.2.7.3\t2-oxoglutarate synthase",
    "1.2.7.4\tAnaerobic carbon-monoxide dehydrogenase",
    "1.2.7.5\tAldehyde ferredoxin oxidoreductase",
    "1.2.7.6\tGlyceraldehyde-3-phosphate dehydrogenase (ferredoxin)",
    "1.2.7.7\t3-methyl-2-oxobutanoate dehydrogenase (ferredoxin)",
    "1.2.7.8\tIndolepyruvate ferredoxin oxidoreductase",
    "1.2.7.10\tOxalate oxidoreductase",
    "1.2.7.11\t2-oxoacid oxidoreductase (ferredoxin)",
    "1.2.7.12\tFormylmethanofuran dehydrogenase",
    "1.2.98.1\tFormaldehyde dismutase",
    "1.2.99.6\tCarboxylate reductase",
    "1.2.99.7\tAldehyde dehydrogenase (FAD-independent)",
    "1.2.99.8\tGlyceraldehyde dehydrogenase (FAD-containing)",
    "1.2.99.10\t4,4'-diapolycopenoate synthase",
    "1.3.1.1\tDihydrouracil dehydrogenase (NAD(+))",
    "1.3.1.2\tDihydropyrimidine dehydrogenase (NADP(+))",
    "1.3.1.3\tDelta(4)-3-oxosteroid 5-beta-reductase",
    "1.3.1.5\tCucurbitacin Delta(23)-reductase",
    "1.3.1.6\tFumarate reductase (NADH)",
    "1.3.1.7\tMeso-tartrate dehydrogenase",
    "1.3.1.8\tAcyl-CoA dehydrogenase (NADP(+))",
    "1.3.1.9\tEnoyl-[acyl-carrier-protein] reductase (NADH)",
    "1.3.1.10\tEnoyl-[acyl-carrier-protein] reductase (NADPH, Si-specific)",
    "1.3.1.11\t2-coumarate reductase",
    "1.3.1.12\tPrephenate dehydrogenase",
    "1.3.1.13\tPrephenate dehydrogenase (NADP(+))",
    "1.3.1.14\tDihydroorotate dehydrogenase (NAD(+))",
    "1.3.1.15\tDihydroorotate dehydrogenase (NADP(+))",
    "1.3.1.16\tBeta-nitroacrylate reductase",
    "1.3.1.17\t3-methyleneoxindole reductase",
    "1.3.1.18\tKynurenate-7,8-dihydrodiol dehydrogenase",
    "1.3.1.19\tCis-1,2-dihydrobenzene-1,2-diol dehydrogenase",
    "1.3.1.20\tTrans-1,2-dihydrobenzene-1,2-diol dehydrogenase",
    "1.3.1.21\t7-dehydrocholesterol reductase",
    "1.3.1.22\t3-oxo-5-alpha-steroid 4-dehydrogenase (NADP(+))",
    "1.3.1.24\tBiliverdin reductase",
    "1.3.1.25\t1,6-dihydroxycyclohexa-2,4-diene-1-carboxylate dehydrogenase",
    "1.3.1.27\t2-hexadecenal reductase",
    "1.3.1.28\t2,3-dihydro-2,3-dihydroxybenzoate dehydrogenase",
    "1.3.1.29\tCis-1,2-dihydro-1,2-dihydroxynaphthalene dehydrogenase",
    "1.3.1.31\t2-enoate reductase",
    "1.3.1.32\tMaleylacetate reductase",
    "1.3.1.33\tProtochlorophyllide reductase",
    "1.3.1.34\t2,4-dienoyl-CoA reductase ((2E)-enoyl-CoA-producing)",
    "1.3.1.36\tGeissoschizine dehydrogenase",
    "1.3.1.37\tCis-2-enoyl-CoA reductase (NADPH)",
    "1.3.1.38\tTrans-2-enoyl-CoA reductase (NADPH)",
    "1.3.1.39\tEnoyl-[acyl-carrier-protein] reductase (NADPH, Re-specific)",
    "1.3.1.40\t2-hydroxy-6-oxo-6-phenylhexa-2,4-dienoate reductase",
    "1.3.1.41\tXanthommatin reductase",
    "1.3.1.42\t12-oxophytodienoate reductase",
    "1.3.1.43\tArogenate dehydrogenase",
    "1.3.1.44\tTrans-2-enoyl-CoA reductase (NAD(+))",
    "1.3.1.45\t2'-hydroxyisoflavone reductase",
    "1.3.1.46\tBiochanin-A reductase",
    "1.3.1.47\tAlpha-santonin 1,2-reductase",
    "1.3.1.48\t15-oxoprostaglandin 13-reductase",
    "1.3.1.49\tCis-3,4-dihydrophenanthrene-3,4-diol dehydrogenase",
    "1.3.1.51\t2'-hydroxydaidzein reductase",
    "1.3.1.53\t(3S,4R)-3,4-dihydroxycyclohexa-1,5-diene-1,4-dicarboxylate dehydrogenase",
    "1.3.1.54\tPrecorrin-6A reductase",
    "1.3.1.56\tCis-2,3-dihydrobiphenyl-2,3-diol dehydrogenase",
    "1.3.1.57\tPhloroglucinol reductase",
    "1.3.1.58\t2,3-dihydroxy-2,3-dihydro-p-cumate dehydrogenase",
    "1.3.1.60\tDibenzothiophene dihydrodiol dehydrogenase",
    "1.3.1.62\tPimeloyl-CoA dehydrogenase",
    "1.3.1.64\tPhthalate 4,5-cis-dihydrodiol dehydrogenase",
    "1.3.1.65\t5,6-dihydroxy-3-methyl-2-oxo-1,2,5,6-tetrahydroquinoline dehydrogenase",
    "1.3.1.66\tCis-dihydroethylcatechol dehydrogenase",
    "1.3.1.67\tCis-1,2-dihydroxy-4-methylcyclohexa-3,5-diene-1-carboxylate dehydrogenase",
    "1.3.1.68\t1,2-dihydroxy-6-methylcyclohexa-3,5-dienecarboxylate dehydrogenase",
    "1.3.1.69\tZeatin reductase",
    "1.3.1.70\tDelta(14)-sterol reductase",
    "1.3.1.71\tDelta(24(24(1)))-sterol reductase",
    "1.3.1.72\tDelta(24)-sterol reductase",
    "1.3.1.73\t1,2-dihydrovomilenine reductase",
    "1.3.1.74\t2-alkenal reductase (NAD(P)(+))",
    "1.3.1.75\t3,8-divinyl protochlorophyllide a 8-vinyl-reductase (NADPH)",
    "1.3.1.76\tPrecorrin-2 dehydrogenase",
    "1.3.1.77\tAnthocyanidin reductase ((2R,3R)-flavan-3-ol-forming)",
    "1.3.1.78\tArogenate dehydrogenase (NADP(+))",
    "1.3.1.79\tArogenate dehydrogenase (NAD(P)(+))",
    "1.3.1.81\t(+)-pulegone reductase",
    "1.3.1.82\t(-)-isopiperitenone reductase",
    "1.3.1.83\tGeranylgeranyl diphosphate reductase",
    "1.3.1.84\tAcrylyl-CoA reductase (NADPH)",
    "1.3.1.85\tCrotonyl-CoA carboxylase/reductase",
    "1.3.1.86\tCrotonyl-CoA reductase",
    "1.3.1.87\t3-(cis-5,6-dihydroxycyclohexa-1,3-dien-1-yl)propanoate dehydrogenase",
    "1.3.1.88\ttRNA-dihydrouridine(16/17) synthase (NAD(P)(+))",
    "1.3.1.89\ttRNA-dihydrouridine(47) synthase (NAD(P)(+))",
    "1.3.1.90\ttRNA-dihydrouridine(20a/20b) synthase (NAD(P)(+))",
    "1.3.1.91\ttRNA-dihydrouridine(20) synthase (NAD(P)(+))",
    "1.3.1.92\tArtemisinic aldehyde Delta(11(13)) reductase",
    "1.3.1.93\tVery-long-chain enoyl-CoA reductase",
    "1.3.1.94\tPolyprenol reductase",
    "1.3.1.95\tAcryloyl-CoA reductase (NADH)",
    "1.3.1.96\tBotryococcus squalene synthase",
    "1.3.1.97\tBotryococcene synthase",
    "1.3.1.98\tUDP-N-acetylmuramate dehydrogenase",
    "1.3.1.100\tChanoclavine-I aldehyde reductase",
    "1.3.1.101\t2,3-bis-O-geranylgeranyl-sn-glycerol 1-phosphate reductase (NAD(P)H)",
    "1.3.1.102\t2-alkenal reductase (NADP(+))",
    "1.3.1.103\t2-haloacrylate reductase",
    "1.3.1.104\tEnoyl-[acyl-carrier-protein] reductase",
    "1.3.1.105\t2-methylene-furan-3-one reductase",
    "1.3.1.106\tCobalt-precorrin-6A reductase",
    "1.3.1.107\tSanguinarine reductase",
    "1.3.1.108\tCaffeoyl-CoA reductase",
    "1.3.1.109\tButanoyl-CoA dehydrogenase complex (NAD(+), ferredoxin)",
    "1.3.1.110\tLactate dehydrogenase (NAD(+),ferredoxin)",
    "1.3.1.111\tGeranylgeranyl-bacteriochlorophyllide a reductase",
    "1.3.1.112\tAnthocyanidin reductase ((2S)-flavan-3-ol-forming)",
    "1.3.1.113\t(4-alkanoyl-5-oxo-2,5-dihydrofuran-3-yl)methyl phosphate reductase",
    "1.3.1.114\t3-dehydro-bile acid Delta(4,6)-reductase",
    "1.3.1.115\t3-oxocholoyl-CoA 4-desaturase",
    "1.3.1.116\t7-beta-hydroxy-3-oxochol-24-oyl-CoA 4-desaturase",
    "1.3.1.117\tHydroxycinnamoyl-CoA reductase",
    "1.3.1.118\tMeromycolic acid enoyl-[acyl-carrier-protein] reductase",
    "1.3.1.119\tChlorobenzene dihydrodiol dehydrogenase",
    "1.3.1.120\tCyclohexane-1-carbonyl-CoA reductase (NADP(+))",
    "1.3.1.121\t4-amino-4-deoxyprephenate dehydrogenase",
    "1.3.1.122\t(S)-8-oxocitronellyl enol synthase",
    "1.3.1.123\t7-epi-iridoid synthase",
    "1.3.1.124\t2,4-dienoyl-CoA reductase ((3E)-enoyl-CoA-producing)",
    "1.3.1.n3\tCurcumin reductase",
    "1.3.2.3\tL-galactonolactone dehydrogenase",
    "1.3.3.3\tCoproporphyrinogen oxidase",
    "1.3.3.4\tProtoporphyrinogen oxidase",
    "1.3.3.5\tBilirubin oxidase",
    "1.3.3.6\tAcyl-CoA oxidase",
    "1.3.3.7\tDihydrouracil oxidase",
    "1.3.3.8\tTetrahydroberberine oxidase",
    "1.3.3.10\tTryptophan alpha,beta-oxidase",
    "1.3.3.11\tPyrroloquinoline-quinone synthase",
    "1.3.3.12\tL-galactonolactone oxidase",
    "1.3.3.13\tAlbonoursin synthase",
    "1.3.3.14\tAclacinomycin-A oxidase",
    "1.3.3.15\tCoproporphyrinogen III oxidase (coproporphyrin-forming)",
    "1.3.3.16\tOxazoline dehydrogenase",
    "1.3.4.1\tFumarate reductase (CoM/CoB)",
    "1.3.5.1\tSuccinate dehydrogenase (quinone)",
    "1.3.5.2\tDihydroorotate dehydrogenase (quinone)",
    "1.3.5.3\tProtoporphyrinogen IX dehydrogenase (quinone)",
    "1.3.5.4\tFumarate reductase (quinol)",
    "1.3.5.5\t15-cis-phytoene desaturase",
    "1.3.5.6\t9,9'-di-cis-zeta-carotene desaturase",
    "1.3.7.1\t6-hydroxynicotinate reductase",
    "1.3.7.2\t15,16-dihydrobiliverdin:ferredoxin oxidoreductase",
    "1.3.7.3\tPhycoerythrobilin:ferredoxin oxidoreductase",
    "1.3.7.4\tPhytochromobilin:ferredoxin oxidoreductase",
    "1.3.7.5\tPhycocyanobilin:ferredoxin oxidoreductase",
    "1.3.7.6\tPhycoerythrobilin synthase",
    "1.3.7.7\tFerredoxin:protochlorophyllide reductase (ATP-dependent)",
    "1.3.7.8\tBenzoyl-CoA reductase",
    "1.3.7.11\t2,3-bis-O-geranylgeranyl-sn-glycero-phospholipid reductase",
    "1.3.7.12\tRed chlorophyll catabolite reductase",
    "1.3.7.13\t3,8-divinyl protochlorophyllide a 8-vinyl-reductase (ferredoxin)",
    "1.3.7.14\t3,8-divinyl chlorophyllide a reductase",
    "1.3.7.15\tChlorophyllide a reductase",
    "1.3.8.1\tShort-chain acyl-CoA dehydrogenase",
    "1.3.8.2\t4,4'-diapophytoene desaturase (4,4'-diapolycopene-forming)",
    "1.3.8.3\t(R)-benzylsuccinyl-CoA dehydrogenase",
    "1.3.8.4\tIsovaleryl-CoA dehydrogenase",
    "1.3.8.5\tShort-chain 2-methylacyl-CoA dehydrogenase",
    "1.3.8.6\tGlutaryl-CoA dehydrogenase (ETF)",
    "1.3.8.7\tMedium-chain acyl-CoA dehydrogenase",
    "1.3.8.8\tLong-chain-acyl-CoA dehydrogenase",
    "1.3.8.9\tVery-long-chain acyl-CoA dehydrogenase",
    "1.3.8.10\tCyclohex-1-ene-1-carbonyl-CoA dehydrogenase",
    "1.3.8.11\tCyclohexane-1-carbonyl-CoA dehydrogenase (electron-transfer flavoprotein)",
    "1.3.8.12\t(2S)-methylsuccinyl-CoA dehydrogenase",
    "1.3.8.13\tCrotonobetainyl-CoA reductase",
    "1.3.8.14\tL-prolyl-[peptidyl-carrier protein] dehydrogenase",
    "1.3.8.15\t3-(aryl)acrylate reductase",
    "1.3.8.16\t2-amino-4-deoxychorismate dehydrogenase",
    "1.3.8.17\tDehydro coenzyme F420 reductase",
    "1.3.98.1\tDihydroorotate oxidase (fumarate)",
    "1.3.98.3\tCoproporphyrinogen dehydrogenase",
    "1.3.98.4\t5a,11a-dehydrotetracycline reductase",
    "1.3.98.5\tHydrogen peroxide-dependent heme synthase",
    "1.3.98.6\tAdoMet-dependent heme synthase",
    "1.3.98.7\t[Mycofactocin precursor peptide]-tyrosine decarboxylase",
    "1.3.99.4\t3-oxosteroid 1-dehydrogenase",
    "1.3.99.5\t3-oxo-5-alpha-steroid 4-dehydrogenase (acceptor)",
    "1.3.99.6\t3-oxo-5-beta-steroid 4-dehydrogenase",
    "1.3.99.8\t2-furoyl-CoA dehydrogenase",
    "1.3.99.12\t2-methylacyl-CoA dehydrogenase",
    "1.3.99.14\tCyclohexanone dehydrogenase",
    "1.3.99.16\tIsoquinoline 1-oxidoreductase",
    "1.3.99.17\tQuinoline 2-oxidoreductase",
    "1.3.99.18\tQuinaldate 4-oxidoreductase",
    "1.3.99.19\tQuinoline-4-carboxylate 2-oxidoreductase",
    "1.3.99.23\tAll-trans-retinol 13,14-reductase",
    "1.3.99.25\tCarvone reductase",
    "1.3.99.26\tAll-trans-zeta-carotene desaturase",
    "1.3.99.27\t1-hydroxycarotenoid 3,4-desaturase",
    "1.3.99.28\tPhytoene desaturase (neurosporene-forming)",
    "1.3.99.29\tPhytoene desaturase (zeta-carotene-forming)",
    "1.3.99.30\tPhytoene desaturase (3,4-didehydrolycopene-forming)",
    "1.3.99.31\tPhytoene desaturase (lycopene-forming)",
    "1.3.99.32\tGlutaryl-CoA dehydrogenase (acceptor)",
    "1.3.99.33\tUrocanate reductase",
    "1.3.99.36\tCypemycin cysteine dehydrogenase (decarboxylating)",
    "1.3.99.37\t1-hydroxy-2-isopentenylcarotenoid 3,4-desaturase",
    "1.3.99.38\tMenaquinone-9-beta-reductase",
    "1.3.99.39\tCarotenoid phi-ring synthase",
    "1.3.99.40\tCarotenoid chi-ring synthase",
    "1.3.99.n1\t3-hydroxybenzoyl-CoA reductase",
    "1.4.1.1\tAlanine dehydrogenase",
    "1.4.1.2\tGlutamate dehydrogenase",
    "1.4.1.3\tGlutamate dehydrogenase (NAD(P)(+))",
    "1.4.1.4\tGlutamate dehydrogenase (NADP(+))",
    "1.4.1.5\tL-amino-acid dehydrogenase",
    "1.4.1.7\tSerine 2-dehydrogenase",
    "1.4.1.8\tValine dehydrogenase (NADP(+))",
    "1.4.1.9\tLeucine dehydrogenase",
    "1.4.1.10\tGlycine dehydrogenase",
    "1.4.1.11\tL-erythro-3,5-diaminohexanoate dehydrogenase",
    "1.4.1.12\t2,4-diaminopentanoate dehydrogenase",
    "1.4.1.13\tGlutamate synthase (NADPH)",
    "1.4.1.14\tGlutamate synthase (NADH)",
    "1.4.1.15\tLysine dehydrogenase",
    "1.4.1.16\tDiaminopimelate dehydrogenase",
    "1.4.1.17\tN-methylalanine dehydrogenase",
    "1.4.1.18\tLysine 6-dehydrogenase",
    "1.4.1.19\tTryptophan dehydrogenase",
    "1.4.1.20\tPhenylalanine dehydrogenase",
    "1.4.1.21\tAspartate dehydrogenase",
    "1.4.1.23\tValine dehydrogenase (NAD(+))",
    "1.4.1.24\t3-dehydroquinate synthase II",
    "1.4.1.25\tL-arginine dehydrogenase",
    "1.4.1.26\t2,4-diaminopentanoate dehydrogenase (NAD(+))",
    "1.4.1.27\tGlycine cleavage system",
    "1.4.2.1\tGlycine dehydrogenase (cytochrome)",
    "1.4.3.1\tD-aspartate oxidase",
    "1.4.3.2\tL-amino-acid oxidase",
    "1.4.3.3\tD-amino-acid oxidase",
    "1.4.3.4\tMonoamine oxidase",
    "1.4.3.5\tPyridoxal 5'-phosphate synthase",
    "1.4.3.7\tD-glutamate oxidase",
    "1.4.3.8\tEthanolamine oxidase",
    "1.4.3.10\tPutrescine oxidase",
    "1.4.3.11\tL-glutamate oxidase",
    "1.4.3.12\tCyclohexylamine oxidase",
    "1.4.3.13\tProtein-lysine 6-oxidase",
    "1.4.3.14\tL-lysine oxidase",
    "1.4.3.15\tD-glutamate(D-aspartate) oxidase",
    "1.4.3.16\tL-aspartate oxidase",
    "1.4.3.19\tGlycine oxidase",
    "1.4.3.20\tL-lysine 6-oxidase",
    "1.4.3.21\tPrimary-amine oxidase",
    "1.4.3.22\tDiamine oxidase",
    "1.4.3.23\t7-chloro-L-tryptophan oxidase",
    "1.4.3.24\tPseudooxynicotine oxidase",
    "1.4.3.25\tL-arginine oxidase",
    "1.4.3.26\tPre-mycofactocin synthase",
    "1.4.4.2\tGlycine dehydrogenase (aminomethyl-transferring)",
    "1.4.5.1\tD-amino acid dehydrogenase (quinone)",
    "1.4.7.1\tGlutamate synthase (ferredoxin)",
    "1.4.9.1\tMethylamine dehydrogenase (amicyanin)",
    "1.4.9.2\tAralkylamine dehydrogenase (azurin)",
    "1.4.99.2\tTaurine dehydrogenase",
    "1.4.99.5\tGlycine dehydrogenase (cyanide-forming)",
    "1.4.99.6\tD-arginine dehydrogenase",
    "1.5.1.1\t1-piperideine-2-carboxylate/1-pyrroline-2-carboxylate reductase (NAD(P)H)",
    "1.5.1.2\tPyrroline-5-carboxylate reductase",
    "1.5.1.3\tDihydrofolate reductase",
    "1.5.1.5\tMethylenetetrahydrofolate dehydrogenase (NADP(+))",
    "1.5.1.6\tFormyltetrahydrofolate dehydrogenase",
    "1.5.1.7\tSaccharopine dehydrogenase (NAD(+), L-lysine-forming)",
    "1.5.1.8\tSaccharopine dehydrogenase (NADP(+), L-lysine-forming)",
    "1.5.1.9\tSaccharopine dehydrogenase (NAD(+), L-glutamate-forming)",
    "1.5.1.10\tSaccharopine dehydrogenase (NADP(+), L-glutamate-forming)",
    "1.5.1.11\tD-octopine dehydrogenase",
    "1.5.1.15\tMethylenetetrahydrofolate dehydrogenase (NAD(+))",
    "1.5.1.16\tD-lysopine dehydrogenase",
    "1.5.1.17\tAlanopine dehydrogenase",
    "1.5.1.18\t(-)-ephedrine dehydrogenase",
    "1.5.1.19\tD-nopaline dehydrogenase",
    "1.5.1.20\tMethylenetetrahydrofolate reductase (NAD(P)H)",
    "1.5.1.21\t1-piperideine-2-carboxylate/1-pyrroline-2-carboxylate reductase (NADPH)",
    "1.5.1.22\tStrombine dehydrogenase",
    "1.5.1.23\tTauropine dehydrogenase",
    "1.5.1.24\tN(5)-(carboxyethyl)ornithine synthase",
    "1.5.1.25\tThiomorpholine-carboxylate dehydrogenase",
    "1.5.1.26\tBeta-alanopine dehydrogenase",
    "1.5.1.27\t1,2-dehydroreticulinium reductase (NADPH)",
    "1.5.1.28\tOpine dehydrogenase",
    "1.5.1.30\tFlavin reductase (NADPH)",
    "1.5.1.31\tBerberine reductase",
    "1.5.1.32\tVomilenine reductase",
    "1.5.1.33\tPteridine reductase",
    "1.5.1.34\t6,7-dihydropteridine reductase",
    "1.5.1.36\tFlavin reductase (NADH)",
    "1.5.1.37\tFAD reductase (NADH)",
    "1.5.1.38\tFMN reductase (NADPH)",
    "1.5.1.39\tFMN reductase (NAD(P)H)",
    "1.5.1.40\t8-hydroxy-5-deazaflavin:NADPH oxidoreductase",
    "1.5.1.41\tRiboflavin reductase (NAD(P)H)",
    "1.5.1.42\tFMN reductase (NADH)",
    "1.5.1.43\tCarboxynorspermidine synthase",
    "1.5.1.44\tFestuclavine dehydrogenase",
    "1.5.1.45\tFAD reductase (NAD(P)H)",
    "1.5.1.46\tAgroclavine dehydrogenase",
    "1.5.1.47\tDihydromethanopterin reductase (NAD(P)(+))",
    "1.5.1.48\t2-methyl-1-pyrroline reductase",
    "1.5.1.49\t1-pyrroline-2-carboxylate reductase (NAD(P)H)",
    "1.5.1.50\tDihydromonapterin reductase",
    "1.5.1.51\tN-((2S)-2-amino-2-carboxyethyl)-L-glutamate dehydrogenase",
    "1.5.1.52\tStaphylopine dehydrogenase",
    "1.5.1.53\tMethylenetetrahydrofolate reductase (NADPH)",
    "1.5.1.54\tMethylenetetrahydrofolate reductase (NADH)",
    "1.5.3.1\tSarcosine oxidase",
    "1.5.3.2\tN-methyl-L-amino-acid oxidase",
    "1.5.3.4\tN(6)-methyl-lysine oxidase",
    "1.5.3.5\t(S)-6-hydroxynicotine oxidase",
    "1.5.3.6\t(R)-6-hydroxynicotine oxidase",
    "1.5.3.7\tL-pipecolate oxidase",
    "1.5.3.10\tDimethylglycine oxidase",
    "1.5.3.12\tDihydrobenzophenanthridine oxidase",
    "1.5.3.13\tN(1)-acetylpolyamine oxidase",
    "1.5.3.14\tPolyamine oxidase (propane-1,3-diamine-forming)",
    "1.5.3.15\tN(8)-acetylspermidine oxidase (propane-1,3-diamine-forming)",
    "1.5.3.16\tSpermine oxidase",
    "1.5.3.17\tNon-specific polyamine oxidase",
    "1.5.3.18\tL-saccharopine oxidase",
    "1.5.3.19\t4-methylaminobutanoate oxidase (formaldehyde-forming)",
    "1.5.3.20\tN-alkylglycine oxidase",
    "1.5.3.21\t4-methylaminobutanoate oxidase (methylamine-forming)",
    "1.5.3.22\tCoenzyme F420H(2) oxidase",
    "1.5.3.23\tGlyphosate oxidoreductase",
    "1.5.4.1\tPyrimidodiazepine synthase",
    "1.5.5.1\tElectron-transferring-flavoprotein dehydrogenase",
    "1.5.5.2\tProline dehydrogenase",
    "1.5.5.3\tHydroxyproline dehydrogenase",
    "1.5.7.1\tMethylenetetrahydrofolate reductase (ferredoxin)",
    "1.5.7.2\tCoenzyme F420 oxidoreductase (ferredoxin)",
    "1.5.8.1\tDimethylamine dehydrogenase",
    "1.5.8.2\tTrimethylamine dehydrogenase",
    "1.5.8.3\tSarcosine dehydrogenase",
    "1.5.8.4\tDimethylglycine dehydrogenase",
    "1.5.98.1\tMethylenetetrahydromethanopterin dehydrogenase",
    "1.5.98.2\t5,10-methylenetetrahydromethanopterin reductase",
    "1.5.98.3\tCoenzyme F420:methanophenazine dehydrogenase",
    "1.5.99.3\tL-pipecolate dehydrogenase",
    "1.5.99.4\tNicotine dehydrogenase",
    "1.5.99.5\tMethylglutamate dehydrogenase",
    "1.5.99.6\tSpermidine dehydrogenase",
    "1.5.99.12\tCytokinin dehydrogenase",
    "1.5.99.13\tD-proline dehydrogenase",
    "1.5.99.14\t6-hydroxypseudooxynicotine dehydrogenase",
    "1.5.99.15\tDihydromethanopterin reductase (acceptor)",
    "1.6.1.1\tNAD(P)(+) transhydrogenase (Si-specific)",
    "1.6.1.2\tNAD(P)(+) transhydrogenase (Re/Si-specific)",
    "1.6.1.3\tNAD(P)(+) transhydrogenase",
    "1.6.1.4\tNAD(P)(+) transhydrogenase (ferredoxin)",
    "1.6.2.2\tCytochrome-b5 reductase",
    "1.6.2.4\tNADPH--hemoprotein reductase",
    "1.6.2.5\tNADPH--cytochrome-c2 reductase",
    "1.6.2.6\tLeghemoglobin reductase",
    "1.6.3.1\tNAD(P)H oxidase (H(2)O(2)-forming)",
    "1.6.3.2\tNAD(P)H oxidase (H(2)O-forming)",
    "1.6.3.3\tNADH oxidase (H(2)O(2)-forming)",
    "1.6.3.4\tNADH oxidase (H(2)O-forming)",
    "1.6.3.5\tRenalase",
    "1.6.5.2\tNAD(P)H dehydrogenase (quinone)",
    "1.6.5.4\tMonodehydroascorbate reductase (NADH)",
    "1.6.5.5\tNADPH:quinone reductase",
    "1.6.5.6\tp-benzoquinone reductase (NADPH)",
    "1.6.5.7\t2-hydroxy-1,4-benzoquinone reductase",
    "1.6.5.9\tNADH:ubiquinone reductase (non-electrogenic)",
    "1.6.5.10\tNADPH dehydrogenase (quinone)",
    "1.6.5.11\tNADH dehydrogenase (quinone)",
    "1.6.5.12\tDemethylphylloquinone reductase",
    "1.6.99.1\tNADPH dehydrogenase",
    "1.6.99.n1\tNADPH dehydrogenase (coenzyme F420 dependent)",
    "1.7.1.1\tNitrate reductase (NADH)",
    "1.7.1.2\tNitrate reductase (NAD(P)H)",
    "1.7.1.3\tNitrate reductase (NADPH)",
    "1.7.1.4\tNitrite reductase (NAD(P)H)",
    "1.7.1.5\tHyponitrite reductase",
    "1.7.1.6\tAzobenzene reductase",
    "1.7.1.7\tGMP reductase",
    "1.7.1.9\tNitroquinoline-N-oxide reductase",
    "1.7.1.10\tHydroxylamine reductase (NADH)",
    "1.7.1.11\t4-(dimethylamino)phenylazoxybenzene reductase",
    "1.7.1.12\tN-hydroxy-2-acetamidofluorene reductase",
    "1.7.1.13\tPreQ(1) synthase",
    "1.7.1.14\tNitric oxide reductase (NAD(P)(+), nitrous oxide-forming)",
    "1.7.1.15\tNitrite reductase (NADH)",
    "1.7.1.16\tNitrobenzene nitroreductase",
    "1.7.1.17\tFMN-dependent NADH-azoreductase",
    "1.7.2.1\tNitrite reductase (NO-forming)",
    "1.7.2.2\tNitrite reductase (cytochrome; ammonia-forming)",
    "1.7.2.3\tTrimethylamine-N-oxide reductase",
    "1.7.2.4\tNitrous-oxide reductase",
    "1.7.2.5\tNitric-oxide reductase (cytochrome c)",
    "1.7.2.6\tHydroxylamine dehydrogenase",
    "1.7.2.7\tHydrazine synthase",
    "1.7.2.8\tHydrazine dehydrogenase",
    "1.7.3.1\tNitroalkane oxidase",
    "1.7.3.2\tAcetylindoxyl oxidase",
    "1.7.3.3\tFactor independent urate hydroxylase",
    "1.7.3.5\t3-aci-nitropropanoate oxidase",
    "1.7.3.6\tHydroxylamine oxidase (cytochrome)",
    "1.7.5.1\tNitrate reductase (quinone)",
    "1.7.5.2\tNitric oxide reductase (menaquinol)",
    "1.7.6.1\tNitrite dismutase",
    "1.7.7.1\tFerredoxin--nitrite reductase",
    "1.7.7.2\tFerredoxin--nitrate reductase",
    "1.7.99.1\tHydroxylamine reductase",
    "1.7.99.4\tNitrate reductase",
    "1.8.1.2\tAssimilatory sulfite reductase (NADPH)",
    "1.8.1.3\tHypotaurine dehydrogenase",
    "1.8.1.4\tDihydrolipoyl dehydrogenase",
    "1.8.1.5\t2-oxopropyl-CoM reductase (carboxylating)",
    "1.8.1.6\tCystine reductase",
    "1.8.1.7\tGlutathione-disulfide reductase",
    "1.8.1.8\tProtein-disulfide reductase",
    "1.8.1.9\tThioredoxin-disulfide reductase",
    "1.8.1.10\tCoA-glutathione reductase",
    "1.8.1.11\tAsparagusate reductase",
    "1.8.1.12\tTrypanothione-disulfide reductase",
    "1.8.1.13\tBis-gamma-glutamylcystine reductase",
    "1.8.1.14\tCoA-disulfide reductase",
    "1.8.1.15\tMycothione reductase",
    "1.8.1.16\tGlutathione amide reductase",
    "1.8.1.17\tDimethylsulfone reductase",
    "1.8.1.18\tNAD(P)H sulfur oxidoreductase (CoA-dependent)",
    "1.8.1.19\tSulfide dehydrogenase",
    "1.8.1.20\t4,4'-dithiodibutanoate disulfide reductase",
    "1.8.1.21\tDissimilatory dimethyldisulfide reductase",
    "1.8.2.1\tSulfite dehydrogenase (cytochrome)",
    "1.8.2.2\tThiosulfate dehydrogenase",
    "1.8.2.3\tSulfide-cytochrome-c reductase (flavocytochrome c)",
    "1.8.2.4\tDimethyl sulfide:cytochrome c2 reductase",
    "1.8.2.5\tThiosulfate reductase (cytochrome)",
    "1.8.2.6\tS-disulfanyl-L-cysteine oxidoreductase",
    "1.8.2.7\tThiocyanate desulfurase",
    "1.8.3.1\tSulfite oxidase",
    "1.8.3.2\tThiol oxidase",
    "1.8.3.3\tGlutathione oxidase",
    "1.8.3.4\tMethanethiol oxidase",
    "1.8.3.5\tPrenylcysteine oxidase",
    "1.8.3.6\tFarnesylcysteine lyase",
    "1.8.3.7\tFormylglycine-generating enzyme",
    "1.8.4.1\tGlutathione--homocystine transhydrogenase",
    "1.8.4.2\tProtein-disulfide reductase (glutathione)",
    "1.8.4.3\tGlutathione--CoA-glutathione transhydrogenase",
    "1.8.4.4\tGlutathione--cystine transhydrogenase",
    "1.8.4.7\tEnzyme-thiol transhydrogenase (glutathione-disulfide)",
    "1.8.4.8\tPhosphoadenylyl-sulfate reductase (thioredoxin)",
    "1.8.4.9\tAdenylyl-sulfate reductase (glutathione)",
    "1.8.4.10\tAdenylyl-sulfate reductase (thioredoxin)",
    "1.8.4.11\tPeptide-methionine (S)-S-oxide reductase",
    "1.8.4.12\tPeptide-methionine (R)-S-oxide reductase",
    "1.8.4.13\tL-methionine (S)-S-oxide reductase",
    "1.8.4.14\tL-methionine (R)-S-oxide reductase",
    "1.8.4.15\tProtein dithiol oxidoreductase (disulfide-forming)",
    "1.8.4.16\tThioredoxin:protein disulfide reductase",
    "1.8.5.1\tGlutathione dehydrogenase (ascorbate)",
    "1.8.5.2\tThiosulfate dehydrogenase (quinone)",
    "1.8.5.3\tRespiratory dimethylsulfoxide reductase",
    "1.8.5.4\tBacterial sulfide:quinone reductase",
    "1.8.5.5\tThiosulfate reductase (quinone)",
    "1.8.5.6\tSulfite dehydrogenase (quinone)",
    "1.8.5.7\tGlutathionyl-hydroquinone reductase",
    "1.8.5.8\tEukaryotic sulfide quinone oxidoreductase",
    "1.8.5.9\tProtein dithiol:quinone oxidoreductase DsbB",
    "1.8.7.1\tAssimilatory sulfite reductase (ferredoxin)",
    "1.8.7.2\tFerredoxin:thioredoxin reductase",
    "1.8.7.3\tFerredoxin:CoB-CoM heterodisulfide reductase",
    "1.8.98.1\tDihydromethanophenazine:CoB--CoM heterodisulfide reductase",
    "1.8.98.2\tSulfiredoxin",
    "1.8.98.3\tSulfite reductase (coenzyme F420)",
    "1.8.98.4\tCoenzyme F420:CoB-CoM heterodisulfide,ferredoxin reductase",
    "1.8.98.5\tH(2):CoB-CoM heterodisulfide,ferredoxin reductase",
    "1.8.98.6\tFormate:CoB-CoM heterodisulfide,ferredoxin reductase",
    "1.8.98.7\tCysteine-type anaerobic sulfatase-maturating enzyme",
    "1.8.99.2\tAdenylyl-sulfate reductase",
    "1.8.99.5\tDissimilatory sulfite reductase",
    "1.9.6.1\tNitrate reductase (cytochrome)",
    "1.9.98.1\tIron--cytochrome-c reductase",
    "1.10.1.1\tTrans-acenaphthene-1,2-diol dehydrogenase",
    "1.10.3.1\tCatechol oxidase",
    "1.10.3.2\tLaccase",
    "1.10.3.3\tL-ascorbate oxidase",
    "1.10.3.4\to-aminophenol oxidase",
    "1.10.3.5\t3-hydroxyanthranilate oxidase",
    "1.10.3.6\tRifamycin-B oxidase",
    "1.10.3.9\tPhotosystem II",
    "1.10.3.11\tUbiquinol oxidase (non-electrogenic)",
    "1.10.3.15\tGrixazone synthase",
    "1.10.3.16\tDihydrophenazinedicarboxylate synthase",
    "1.10.3.17\tSuperoxide oxidase",
    "1.10.5.1\tRibosyldihydronicotinamide dehydrogenase (quinone)",
    "1.11.1.1\tNADH peroxidase",
    "1.11.1.2\tNADPH peroxidase",
    "1.11.1.3\tFatty-acid peroxidase",
    "1.11.1.5\tCytochrome-c peroxidase",
    "1.11.1.6\tCatalase",
    "1.11.1.7\tPeroxidase",
    "1.11.1.8\tIodide peroxidase",
    "1.11.1.9\tGlutathione peroxidase",
    "1.11.1.10\tChloride peroxidase",
    "1.11.1.11\tL-ascorbate peroxidase",
    "1.11.1.12\tPhospholipid-hydroperoxide glutathione peroxidase",
    "1.11.1.13\tManganese peroxidase",
    "1.11.1.14\tLignin peroxidase",
    "1.11.1.16\tVersatile peroxidase",
    "1.11.1.17\tGlutathione amide-dependent peroxidase",
    "1.11.1.18\tBromide peroxidase",
    "1.11.1.19\tDye decolorizing peroxidase",
    "1.11.1.20\tProstamide/prostaglandin F(2-alpha) synthase",
    "1.11.1.21\tCatalase peroxidase",
    "1.11.1.22\tHydroperoxy fatty acid reductase",
    "1.11.1.23\t(S)-2-hydroxypropylphosphonic acid epoxidase",
    "1.11.1.24\tThioredoxin-dependent peroxiredoxin",
    "1.11.1.25\tGlutaredoxin-dependent peroxiredoxin",
    "1.11.1.26\tNADH-dependent peroxiredoxin",
    "1.11.1.27\tGlutathione-dependent peroxiredoxin",
    "1.11.1.28\tLipoyl-dependent peroxiredoxin",
    "1.11.1.29\tMycoredoxin-dependent peroxiredoxin",
    "1.11.2.1\tUnspecific peroxygenase",
    "1.11.2.2\tMyeloperoxidase",
    "1.11.2.3\tPlant seed peroxygenase",
    "1.11.2.4\tFatty-acid peroxygenase",
    "1.11.2.5\t3-methyl-L-tyrosine peroxygenase",
    "1.11.2.6\tL-tyrosine peroxygenase",
    "1.12.1.2\tHydrogen dehydrogenase",
    "1.12.1.3\tHydrogen dehydrogenase (NADP(+))",
    "1.12.1.4\tHydrogenase (NAD(+), ferredoxin)",
    "1.12.1.5\tHydrogen dehydrogenase (NAD(P)(+))",
    "1.12.2.1\tCytochrome-c3 hydrogenase",
    "1.12.5.1\tHydrogen:quinone oxidoreductase",
    "1.12.7.2\tFerredoxin hydrogenase",
    "1.12.98.1\tCoenzyme F420 hydrogenase",
    "1.12.98.2\t5,10-methenyltetrahydromethanopterin hydrogenase",
    "1.12.98.3\tMethanosarcina-phenazine hydrogenase",
    "1.12.98.4\tSulfhydrogenase",
    "1.12.99.6\tHydrogenase (acceptor)",
    "1.13.11.1\tCatechol 1,2-dioxygenase",
    "1.13.11.2\tCatechol 2,3-dioxygenase",
    "1.13.11.3\tProtocatechuate 3,4-dioxygenase",
    "1.13.11.4\tGentisate 1,2-dioxygenase",
    "1.13.11.5\tHomogentisate 1,2-dioxygenase",
    "1.13.11.6\t3-hydroxyanthranilate 3,4-dioxygenase",
    "1.13.11.8\tProtocatechuate 4,5-dioxygenase",
    "1.13.11.9\t2,5-dihydroxypyridine 5,6-dioxygenase",
    "1.13.11.10\t7,8-dihydroxykynurenate 8,8a-dioxygenase",
    "1.13.11.11\tTryptophan 2,3-dioxygenase",
    "1.13.11.12\tLinoleate 13S-lipoxygenase",
    "1.13.11.14\t2,3-dihydroxybenzoate 3,4-dioxygenase",
    "1.13.11.15\t3,4-dihydroxyphenylacetate 2,3-dioxygenase",
    "1.13.11.16\t3-carboxyethylcatechol 2,3-dioxygenase",
    "1.13.11.17\tIndole 2,3-dioxygenase",
    "1.13.11.18\tPersulfide dioxygenase",
    "1.13.11.19\tCysteamine dioxygenase",
    "1.13.11.20\tCysteine dioxygenase",
    "1.13.11.22\tCaffeate 3,4-dioxygenase",
    "1.13.11.23\t2,3-dihydroxyindole 2,3-dioxygenase",
    "1.13.11.24\tQuercetin 2,3-dioxygenase",
    "1.13.11.25\t3,4-dihydroxy-9,10-secoandrosta-1,3,5(10)-triene-9,17-dione 4,5-dioxygenase",
    "1.13.11.26\tPeptide-tryptophan 2,3-dioxygenase",
    "1.13.11.27\t4-hydroxyphenylpyruvate dioxygenase",
    "1.13.11.28\t2,3-dihydroxybenzoate 2,3-dioxygenase",
    "1.13.11.29\tStizolobate synthase",
    "1.13.11.30\tStizolobinate synthase",
    "1.13.11.31\tArachidonate 12-lipoxygenase",
    "1.13.11.33\tArachidonate 15-lipoxygenase",
    "1.13.11.34\tArachidonate 5-lipoxygenase",
    "1.13.11.35\tPyrogallol 1,2-oxygenase",
    "1.13.11.36\tChloridazon-catechol dioxygenase",
    "1.13.11.37\tHydroxyquinol 1,2-dioxygenase",
    "1.13.11.38\t1-hydroxy-2-naphthoate 1,2-dioxygenase",
    "1.13.11.39\tBiphenyl-2,3-diol 1,2-dioxygenase",
    "1.13.11.40\tArachidonate 8-lipoxygenase",
    "1.13.11.41\t2,4'-dihydroxyacetophenone dioxygenase",
    "1.13.11.43\tLignostilbene alpha-beta-dioxygenase",
    "1.13.11.45\tLinoleate 11-lipoxygenase",
    "1.13.11.46\t4-hydroxymandelate synthase",
    "1.13.11.47\t3-hydroxy-4-oxoquinoline 2,4-dioxygenase",
    "1.13.11.48\t3-hydroxy-2-methylquinolin-4-one 2,4-dioxygenase",
    "1.13.11.49\tChlorite O(2)-lyase",
    "1.13.11.50\tAcetylacetone-cleaving enzyme",
    "1.13.11.51\t9-cis-epoxycarotenoid dioxygenase",
    "1.13.11.52\tIndoleamine 2,3-dioxygenase",
    "1.13.11.53\tAcireductone dioxygenase (Ni(2+)-requiring)",
    "1.13.11.54\tAcireductone dioxygenase (Fe(2+)-requiring)",
    "1.13.11.55\tSulfur oxygenase/reductase",
    "1.13.11.56\t1,2-dihydroxynaphthalene dioxygenase",
    "1.13.11.57\tGallate dioxygenase",
    "1.13.11.58\tLinoleate 9S-lipoxygenase",
    "1.13.11.59\tTorulene dioxygenase",
    "1.13.11.60\tLinoleate 8R-lipoxygenase",
    "1.13.11.61\tLinolenate 9R-lipoxygenase",
    "1.13.11.62\tLinoleate 10R-lipoxygenase",
    "1.13.11.63\tBeta-carotene 15,15'-dioxygenase",
    "1.13.11.64\t5-nitrosalicylate dioxygenase",
    "1.13.11.65\tCarotenoid isomerooxygenase",
    "1.13.11.66\tHydroquinone 1,2-dioxygenase",
    "1.13.11.67\t8'-apo-beta-carotenoid 14',13'-cleaving dioxygenase",
    "1.13.11.68\t9-cis-beta-carotene 9',10'-cleaving dioxygenase",
    "1.13.11.69\tCarlactone synthase",
    "1.13.11.70\tAll-trans-10'-apo-beta-carotenal 13,14-cleaving dioxygenase",
    "1.13.11.71\tCarotenoid-9',10'-cleaving dioxygenase",
    "1.13.11.72\t2-hydroxyethylphosphonate dioxygenase",
    "1.13.11.73\tMethylphosphonate synthase",
    "1.13.11.74\t2-aminophenol 1,6-dioxygenase",
    "1.13.11.75\tAll-trans-8'-apo-beta-carotenal 15,15'-oxygenase",
    "1.13.11.76\t2-amino-5-chlorophenol 1,6-dioxygenase",
    "1.13.11.77\tOleate 10S-lipoxygenase",
    "1.13.11.78\t2-amino-1-hydroxyethylphosphonate dioxygenase (glycine-forming)",
    "1.13.11.79\tAerobic 5,6-dimethylbenzimidazole synthase",
    "1.13.11.80\t(3,5-dihydroxyphenyl)acetyl-CoA 1,2-dioxygenase",
    "1.13.11.81\t7,8-dihydroneopterin oxygenase",
    "1.13.11.82\t8'-apo-carotenoid 13,14-cleaving dioxygenase",
    "1.13.11.83\t4-hydroxy-3-prenylphenylpyruvate oxygenase",
    "1.13.11.84\tCrocetin dialdehyde synthase",
    "1.13.11.85\tExo-cleaving rubber dioxygenase",
    "1.13.11.86\t5-aminosalicylate 1,2-dioxygenase",
    "1.13.11.87\tEndo-cleaving rubber dioxygenase",
    "1.13.11.88\tIsoeugenol monooxygenase",
    "1.13.11.89\t(Hydroxymethyl)phosphonate dioxygenase",
    "1.13.11.90\t(1-hydroxy-2-(trimethylamino)ethyl)phosphonate dioxygenase (glycine-betaine-forming)",
    "1.13.11.91\t3-mercaptopropionate dioxygenase",
    "1.13.11.92\tFatty acid alpha-dioxygenase",
    "1.13.12.1\tArginine 2-monooxygenase",
    "1.13.12.2\tLysine 2-monooxygenase",
    "1.13.12.3\tTryptophan 2-monooxygenase",
    "1.13.12.4\tLactate 2-monooxygenase",
    "1.13.12.5\tRenilla-type luciferase",
    "1.13.12.6\tCypridina-luciferin 2-monooxygenase",
    "1.13.12.7\tFirefly luciferase",
    "1.13.12.8\tWatasenia-luciferin 2-monooxygenase",
    "1.13.12.9\tPhenylalanine 2-monooxygenase",
    "1.13.12.13\tOplophorus-luciferin 2-monooxygenase",
    "1.13.12.15\t3,4-dihydroxyphenylalanine oxidative deaminase",
    "1.13.12.16\tNitronate monooxygenase",
    "1.13.12.17\tDichloroarcyriaflavin A synthase",
    "1.13.12.18\tDinoflagellate luciferase",
    "1.13.12.19\t2-oxoglutarate dioxygenase (ethene-forming)",
    "1.13.12.20\tNoranthrone monooxygenase",
    "1.13.12.21\tTetracenomycin-F1 monooxygenase",
    "1.13.12.22\tDeoxynogalonate monooxygenase",
    "1.13.12.23\t4-hydroxy-3-prenylbenzoate synthase",
    "1.13.12.24\tCalcium-regulated photoprotein",
    "1.13.99.1\tInositol oxygenase",
    "1.13.99.3\tTryptophan 2'-dioxygenase",
    "1.14.11.1\tGamma-butyrobetaine dioxygenase",
    "1.14.11.2\tProcollagen-proline 4-dioxygenase",
    "1.14.11.3\tPyrimidine-deoxynucleoside 2'-dioxygenase",
    "1.14.11.4\tProcollagen-lysine 5-dioxygenase",
    "1.14.11.6\tThymine dioxygenase",
    "1.14.11.7\tProcollagen-proline 3-dioxygenase",
    "1.14.11.8\tTrimethyllysine dioxygenase",
    "1.14.11.9\tFlavanone 3-dioxygenase",
    "1.14.11.10\tPyrimidine-deoxynucleoside 1'-dioxygenase",
    "1.14.11.11\tHyoscyamine (6S)-dioxygenase",
    "1.14.11.12\tGibberellin-44 dioxygenase",
    "1.14.11.13\tGibberellin 2-beta-dioxygenase",
    "1.14.11.15\tGibberellin 3-beta-dioxygenase",
    "1.14.11.16\tPeptide-aspartate beta-dioxygenase",
    "1.14.11.17\tTaurine dioxygenase",
    "1.14.11.18\tPhytanoyl-CoA dioxygenase",
    "1.14.11.20\tDeacetoxyvindoline 4-hydroxylase",
    "1.14.11.21\tClavaminate synthase",
    "1.14.11.24\t2'-deoxymugineic-acid 2'-dioxygenase",
    "1.14.11.25\tMugineic-acid 3-dioxygenase",
    "1.14.11.26\tDeacetoxycephalosporin-C hydroxylase",
    "1.14.11.27\t[Histone H3]-dimethyl-L-lysine(36) demethylase",
    "1.14.11.28\tProline 3-hydroxylase",
    "1.14.11.29\tHypoxia-inducible factor-proline dioxygenase",
    "1.14.11.30\tHypoxia-inducible factor-asparagine dioxygenase",
    "1.14.11.31\tThebaine 6-O-demethylase",
    "1.14.11.32\tCodeine 3-O-demethylase",
    "1.14.11.33\tDNA oxidative demethylase",
    "1.14.11.35\t1-deoxypentalenic acid 11-beta-hydroxylase",
    "1.14.11.36\tPentalenolactone F synthase",
    "1.14.11.37\tKanamycin B dioxygenase",
    "1.14.11.38\tVerruculogen synthase",
    "1.14.11.39\tL-asparagine oxygenase",
    "1.14.11.40\tEnduracididine beta-hydroxylase",
    "1.14.11.41\tL-arginine hydroxylase",
    "1.14.11.42\ttRNA(Phe) (7-(3-amino-3-carboxypropyl)wyosine(37)-C(2))-hydroxylase",
    "1.14.11.43\t(S)-dichlorprop dioxygenase (2-oxoglutarate)",
    "1.14.11.44\t(R)-dichlorprop dioxygenase (2-oxoglutarate)",
    "1.14.11.45\tL-isoleucine 4-hydroxylase",
    "1.14.11.46\t2-aminoethylphosphonate dioxygenase",
    "1.14.11.47\t[50S ribosomal protein L16]-arginine 3-hydroxylase",
    "1.14.11.48\tXanthine dioxygenase",
    "1.14.11.49\tUridine-5'-phosphate dioxygenase",
    "1.14.11.51\tDNA N(6)-methyladenine demethylase",
    "1.14.11.52\tValidamycin A dioxygenase",
    "1.14.11.53\tmRNA N(6)-methyladenine demethylase",
    "1.14.11.54\tmRNA N(1)-methyladenine demethylase",
    "1.14.11.55\tEctoine hydroxylase",
    "1.14.11.56\tL-proline cis-4-hydroxylase",
    "1.14.11.57\tL-proline trans-4-hydroxylase",
    "1.14.11.58\tOrnithine lipid ester-linked acyl 2-hydroxylase",
    "1.14.11.59\t2,4-dihydroxy-1,4-benzoxazin-3-one-glucoside dioxygenase",
    "1.14.11.60\tScopoletin 8-hydroxylase",
    "1.14.11.61\tFeruloyl-CoA 6-hydroxylase",
    "1.14.11.62\tTrans-4-coumaroyl-CoA 2'-hydroxylase",
    "1.14.11.63\tPeptidyl-lysine (3S)-dioxygenase",
    "1.14.11.64\tGlutarate dioxygenase",
    "1.14.11.65\t[Histone H3]-dimethyl-L-lysine(9) demethylase",
    "1.14.11.66\t[Histone H3]-trimethyl-L-lysine(9) demethylase",
    "1.14.11.67\t[Histone H3]-trimethyl-L-lysine(4) demethylase",
    "1.14.11.68\t[Histone H3]-trimethyl-L-lysine(27) demethylase",
    "1.14.11.69\t[Histone H3]-trimethyl-L-lysine(36) demethylase",
    "1.14.11.70\t7-deoxycylindrospermopsin hydroxylase",
    "1.14.11.71\tMethylphosphonate hydroxylase",
    "1.14.11.72\t(2-(trimethylamino)ethyl)phosphonate dioxygenase",
    "1.14.11.73\t[Protein]-arginine 3-hydroxylase",
    "1.14.11.74\tL-isoleucine 3(1)-dioxygenase",
    "1.14.11.75\t3(1)-hydroxy-L-isoleucine 4-dioxygenase",
    "1.14.11.76\tL-glutamate 3(R)-hydroxylase",
    "1.14.11.77\tAlkyl sulfatase",
    "1.14.11.n2\tMethylcytosine dioxygenase",
    "1.14.11.n4\tAnkyrin-repeat-histidine dioxagenase",
    "1.14.12.1\tAnthranilate 1,2-dioxygenase (deaminating, decarboxylating)",
    "1.14.12.3\tBenzene 1,2-dioxygenase",
    "1.14.12.7\tPhthalate 4,5-dioxygenase",
    "1.14.12.8\t4-sulfobenzoate 3,4-dioxygenase",
    "1.14.12.9\t4-chlorophenylacetate 3,4-dioxygenase",
    "1.14.12.10\tBenzoate 1,2-dioxygenase",
    "1.14.12.11\tToluene dioxygenase",
    "1.14.12.12\tNaphthalene 1,2-dioxygenase",
    "1.14.12.13\t2-halobenzoate 1,2-dioxygenase",
    "1.14.12.14\t2-aminobenzenesulfonate 2,3-dioxygenase",
    "1.14.12.15\tTerephthalate 1,2-dioxygenase",
    "1.14.12.16\t2-hydroxyquinoline 5,6-dioxygenase",
    "1.14.12.17\tNitric oxide dioxygenase",
    "1.14.12.18\tBiphenyl 2,3-dioxygenase",
    "1.14.12.19\t3-phenylpropanoate dioxygenase",
    "1.14.12.22\tCarbazole 1,9a-dioxygenase",
    "1.14.12.23\tNitroarene dioxygenase",
    "1.14.12.24\t2,4-dinitrotoluene dioxygenase",
    "1.14.12.25\tp-cumate 2,3-dioxygenase",
    "1.14.12.26\tChlorobenzene dioxygenase",
    "1.14.13.1\tSalicylate 1-monooxygenase",
    "1.14.13.2\t4-hydroxybenzoate 3-monooxygenase",
    "1.14.13.4\tMelilotate 3-monooxygenase",
    "1.14.13.5\tImidazoleacetate 4-monooxygenase",
    "1.14.13.6\tOrcinol 2-monooxygenase",
    "1.14.13.7\tPhenol 2-monooxygenase (NADPH)",
    "1.14.13.8\tFlavin-containing monooxygenase",
    "1.14.13.9\tKynurenine 3-monooxygenase",
    "1.14.13.10\t2,6-dihydroxypyridine 3-monooxygenase",
    "1.14.13.14\tTrans-cinnamate 2-monooxygenase",
    "1.14.13.16\tCyclopentanone monooxygenase",
    "1.14.13.18\t4-hydroxyphenylacetate 1-monooxygenase",
    "1.14.13.19\tTaxifolin 8-monooxygenase",
    "1.14.13.20\t2,4-dichlorophenol 6-monooxygenase",
    "1.14.13.22\tCyclohexanone monooxygenase",
    "1.14.13.23\t3-hydroxybenzoate 4-monooxygenase",
    "1.14.13.24\t3-hydroxybenzoate 6-monooxygenase",
    "1.14.13.25\tMethane monooxygenase (soluble)",
    "1.14.13.27\t4-aminobenzoate 1-monooxygenase",
    "1.14.13.29\t4-nitrophenol 2-monooxygenase",
    "1.14.13.31\t2-nitrophenol 2-monooxygenase",
    "1.14.13.32\tAlbendazole monooxygenase",
    "1.14.13.33\t4-hydroxybenzoate 3-monooxygenase (NAD(P)H)",
    "1.14.13.34\tLeukotriene-E(4) 20-monooxygenase",
    "1.14.13.35\tAnthranilate 3-monooxygenase (deaminating)",
    "1.14.13.38\tAnhydrotetracycline 6-monooxygenase",
    "1.14.13.39\tNitric-oxide synthase (NADPH)",
    "1.14.13.40\tAnthraniloyl-CoA monooxygenase",
    "1.14.13.43\tQuestin monooxygenase",
    "1.14.13.44\t2-hydroxybiphenyl 3-monooxygenase",
    "1.14.13.46\t(-)-menthol monooxygenase",
    "1.14.13.50\tPentachlorophenol monooxygenase",
    "1.14.13.51\t6-oxocineole dehydrogenase",
    "1.14.13.54\tKetosteroid monooxygenase",
    "1.14.13.58\tBenzoyl-CoA 3-monooxygenase",
    "1.14.13.59\tL-lysine N(6)-monooxygenase (NADPH)",
    "1.14.13.61\t2-hydroxyquinoline 8-monooxygenase",
    "1.14.13.62\t4-hydroxyquinoline 3-monooxygenase",
    "1.14.13.63\t3-hydroxyphenylacetate 6-hydroxylase",
    "1.14.13.64\t4-hydroxybenzoate 1-hydroxylase",
    "1.14.13.66\t2-hydroxycyclohexanone 2-monooxygenase",
    "1.14.13.69\tAlkene monooxygenase",
    "1.14.13.81\tMagnesium-protoporphyrin IX monomethyl ester (oxidative) cyclase",
    "1.14.13.82\tVanillate monooxygenase",
    "1.14.13.83\tPrecorrin-3B synthase",
    "1.14.13.84\t4-hydroxyacetophenone monooxygenase",
    "1.14.13.92\tPhenylacetone monooxygenase",
    "1.14.13.101\tSenecionine N-oxygenase",
    "1.14.13.105\tMonocyclic monoterpene ketone monooxygenase",
    "1.14.13.107\tLimonene 1,2-monooxygenase",
    "1.14.13.111\tMethanesulfonate monooxygenase (NADH)",
    "1.14.13.113\tFAD-dependent urate hydroxylase",
    "1.14.13.114\t6-hydroxynicotinate 3-monooxygenase",
    "1.14.13.122\tChlorophyllide a oxygenase",
    "1.14.13.127\t3-(3-hydroxy-phenyl)propanoic acid hydroxylase",
    "1.14.13.128\t7-methylxanthine demethylase",
    "1.14.13.130\tPyrrole-2-carboxylate monooxygenase",
    "1.14.13.131\tDissimilatory dimethyl-sulfide monooxygenase",
    "1.14.13.135\t1-hydroxy-2-naphthoate hydroxylase",
    "1.14.13.146\tTaxoid 14-beta-hydroxylase",
    "1.14.13.147\tTaxoid 7-beta-hydroxylase",
    "1.14.13.148\tTrimethylamine monooxygenase",
    "1.14.13.149\tPhenylacetyl-CoA 1,2-epoxidase",
    "1.14.13.153\t(+)-sabinene 3-hydroxylase",
    "1.14.13.154\tErythromycin 12 hydroxylase",
    "1.14.13.155\tAlpha-pinene monooxygenase",
    "1.14.13.160\t(2,2,3-trimethyl-5-oxocyclopent-3-enyl)acetyl-CoA 1,5-monooxygenase",
    "1.14.13.161\t(+)-camphor 6-exo-hydroxylase",
    "1.14.13.163\t6-hydroxy-3-succinoylpyridine 3-monooxygenase",
    "1.14.13.166\t4-nitrocatechol 4-monooxygenase",
    "1.14.13.167\t4-nitrophenol 4-monooxygenase",
    "1.14.13.168\tIndole-3-pyruvate monooxygenase",
    "1.14.13.170\tPentalenolactone D synthase",
    "1.14.13.171\tNeopentalenolactone D synthase",
    "1.14.13.172\tSalicylate 5-hydroxylase",
    "1.14.13.178\tMethylxanthine N(1)-demethylase",
    "1.14.13.179\tMethylxanthine N(3)-demethylase",
    "1.14.13.180\tAklavinone 12-hydroxylase",
    "1.14.13.181\t13-deoxydaunorubicin hydroxylase",
    "1.14.13.182\t2-heptyl-3-hydroxy-4(1H)-quinolone synthase",
    "1.14.13.187\tL-evernosamine nitrososynthase",
    "1.14.13.189\t5-methyl-1-naphthoate 3-hydroxylase",
    "1.14.13.195\tL-ornithine N(5)-monooxygenase (NADPH)",
    "1.14.13.196\tL-ornithine N(5)-monooxygenase (NAD(P)H)",
    "1.14.13.200\tTetracenomycin A2 monooxygenase-diooxygenase",
    "1.14.13.208\tBenzoyl-CoA 2,3-epoxidase",
    "1.14.13.209\tSalicyloyl-CoA 5-hydroxylase",
    "1.14.13.210\t4-methyl-5-nitrocatechol 5-monooxygenase",
    "1.14.13.211\tRifampicin monooxygenase",
    "1.14.13.212\t1,3,7-trimethyluric acid 5-monooxygenase",
    "1.14.13.215\tProtoasukamycin 4-monooxygenase",
    "1.14.13.216\tAsperlicin C monooxygenase",
    "1.14.13.217\tProtodeoxyviolaceinate monooxygenase",
    "1.14.13.218\t5-methylphenazine-1-carboxylate 1-monooxygenase",
    "1.14.13.219\tResorcinol 4-hydroxylase (NADPH)",
    "1.14.13.220\tResorcinol 4-hydroxylase (NADH)",
    "1.14.13.222\tAurachin C monooxygenase/isomerase",
    "1.14.13.223\t3-hydroxy-4-methyl-anthranilyl-[aryl-carrier protein] 5-monooxygenase",
    "1.14.13.224\tViolacein synthase",
    "1.14.13.225\tF-actin monooxygenase",
    "1.14.13.226\tAcetone monooxygenase (methyl acetate-forming)",
    "1.14.13.227\tPropane 2-monooxygenase",
    "1.14.13.228\tJasmomic acid 12-hydroxylase",
    "1.14.13.229\tTert-butanol monooxygenase",
    "1.14.13.230\tButane monooxygenase (soluble)",
    "1.14.13.231\tTetracycline 11a-monooxygenase",
    "1.14.13.232\t6-methylpretetramide 4-monooxygenase",
    "1.14.13.233\t4-hydroxy-6-methylpretetramide 12a-monooxygenase",
    "1.14.13.234\t12-dehydrotetracycline 5-monooxygenase",
    "1.14.13.235\tIndole-3-acetate monooxygenase",
    "1.14.13.236\tToluene 4-monooxygenase",
    "1.14.13.237\tAliphatic glucosinolate S-oxygenase",
    "1.14.13.238\tDimethylamine monooxygenase",
    "1.14.13.239\tCarnitine monooxygenase",
    "1.14.13.240\t2-polyprenylphenol 6-hydroxylase",
    "1.14.13.241\t5-pyridoxate monooxygenase",
    "1.14.13.242\t3-hydroxy-2-methylpyridine-5-carboxylate monooxygenase",
    "1.14.13.243\tToluene 2-monooxygenase",
    "1.14.13.244\tPhenol 2-monooxygenase (NADH)",
    "1.14.13.245\tAssimilatory dimethylsulfide S-monooxygenase",
    "1.14.13.246\t4-beta-methylsterol monooxygenase",
    "1.14.13.247\tStachydrine N-demethylase",
    "1.14.13.n6\tHexahomomethionine N-hydroxylase",
    "1.14.13.n7\t4-nitrophenol 2-hydroxylase",
    "1.14.14.1\tUnspecific monooxygenase",
    "1.14.14.3\tBacterial luciferase",
    "1.14.14.5\tAlkanesulfonate monooxygenase",
    "1.14.14.8\tAnthranilate 3-monooxygenase (FAD)",
    "1.14.14.9\t4-hydroxyphenylacetate 3-monooxygenase",
    "1.14.14.10\tNitrilotriacetate monooxygenase",
    "1.14.14.11\tStyrene monooxygenase",
    "1.14.14.12\t3-hydroxy-9,10-secoandrosta-1,3,5(10)-triene-9,17-dione monooxygenase",
    "1.14.14.13\t4-(gamma-L-glutamylamino)butanoyl-[BtrI acyl-carrier protein] monooxygenase",
    "1.14.14.14\tAromatase",
    "1.14.14.15\t(3S)-3-amino-3-(3-chloro-4-hydroxyphenyl)propanoyl-[peptidyl-carrier protein SgcC2] monooxygenase",
    "1.14.14.16\tSteroid 21-monooxygenase",
    "1.14.14.17\tSqualene monooxygenase",
    "1.14.14.18\tHeme oxygenase (biliverdin-producing)",
    "1.14.14.19\tSteroid 17-alpha-monooxygenase",
    "1.14.14.20\tPhenol 2-monooxygenase (FADH(2))",
    "1.14.14.21\tDibenzothiophene monooxygenase",
    "1.14.14.22\tDibenzothiophene sulfone monooxygenase",
    "1.14.14.23\tCholesterol 7-alpha-monooxygenase",
    "1.14.14.24\tVitamin D 25-hydroxylase",
    "1.14.14.25\tCholesterol 24-hydroxylase",
    "1.14.14.26\t24-hydroxycholesterol 7-alpha-hydroxylase",
    "1.14.14.27\tResorcinol 4-hydroxylase (FADH(2))",
    "1.14.14.28\tLong-chain alkane monooxygenase",
    "1.14.14.29\t25/26-hydroxycholesterol 7-alpha-hydroxylase",
    "1.14.14.30\tIsobutylamine N-monooxygenase",
    "1.14.14.31\tIpsdienol synthase",
    "1.14.14.32\t17-alpha-hydroxyprogesterone deacetylase",
    "1.14.14.33\tEthylenediaminetetraacetate monooxygenase",
    "1.14.14.34\tMethanesulfonate monooxygenase (FMNH(2))",
    "1.14.14.35\tDimethylsulfone monooxygenase",
    "1.14.14.36\tTyrosine N-monooxygenase",
    "1.14.14.37\t4-hydroxyphenylacetaldehyde oxime monooxygenase",
    "1.14.14.38\tValine N-monooxygenase",
    "1.14.14.39\tIsoleucine N-monooxygenase",
    "1.14.14.40\tPhenylalanine N-monooxygenase",
    "1.14.14.41\t(E)-2-methylbutanal oxime monooxygenase",
    "1.14.14.42\tHomomethionine N-monooxygenase",
    "1.14.14.43\t(Methylsulfanyl)alkanaldoxime N-monooxygenase",
    "1.14.14.44\tPhenylacetaldehyde oxime monooxygenase",
    "1.14.14.45\tAromatic aldoxime N-monooxygenase",
    "1.14.14.46\tPimeloyl-[acyl-carrier protein] synthase",
    "1.14.14.47\tNitric-oxide synthase (flavodoxin)",
    "1.14.14.48\tJasmonoyl-L-amino acid 12-hydroxylase",
    "1.14.14.49\t12-hydroxyjasmonoyl-L-amino acid 12-hydroxylase",
    "1.14.14.50\tTabersonine 3-oxygenase",
    "1.14.14.51\t(S)-limonene 6-monooxygenase",
    "1.14.14.52\t(S)-limonene 7-monooxygenase",
    "1.14.14.53\t(R)-limonene 6-monooxygenase",
    "1.14.14.54\tPhenylacetate 2-hydroxylase",
    "1.14.14.55\tQuinine 3-monooxygenase",
    "1.14.14.56\t1,8-cineole 2-exo-monooxygenase",
    "1.14.14.57\tTaurochenodeoxycholate 6-alpha-hydroxylase",
    "1.14.14.58\tTrimethyltridecatetraene synthase",
    "1.14.14.59\tDimethylnonatriene synthase",
    "1.14.14.60\tFerruginol monooxygenase",
    "1.14.14.61\tCarnosic acid synthase",
    "1.14.14.62\tSalviol synthase",
    "1.14.14.63\tBeta-amyrin 16-beta-monooxygenase",
    "1.14.14.64\tBeta-amyrin 6-beta-monooxygenase",
    "1.14.14.65\tSugiol synthase",
    "1.14.14.66\tMarmesin synthase",
    "1.14.14.67\t11-hydroxysugiol 20-monooxygenase",
    "1.14.14.68\tSyn-pimaradiene 3-monooxygenase",
    "1.14.14.69\tEnt-cassadiene hydroxylase",
    "1.14.14.70\tEnt-sandaracopimaradiene 3-hydroxylase",
    "1.14.14.71\tCucurbitadienol 11-hydroxylase",
    "1.14.14.72\tDrimenol monooxygenase",
    "1.14.14.73\tAlbendazole monooxygenase (sufoxide-forming)",
    "1.14.14.74\tAlbendazole monooxygenase (hydroxylating)",
    "1.14.14.75\tFenbendazole monooxygenase (4'-hydroxylating)",
    "1.14.14.76\tEnt-isokaurene C2/C3-hydroxylase",
    "1.14.14.77\tPhenylacetonitrile alpha-monooxygenase",
    "1.14.14.78\tPhylloquinone omega-hydroxylase",
    "1.14.14.79\tDocosahexaenoic acid omega-hydroxylase",
    "1.14.14.80\tLong-chain fatty acid omega-monooxygenase",
    "1.14.14.81\tFlavonoid 3',5'-hydroxylase",
    "1.14.14.82\tFlavonoid 3'-monooxygenase",
    "1.14.14.83\tGeraniol 8-hydroxylase",
    "1.14.14.84\tLinalool 8-monooxygenase",
    "1.14.14.85\t7-deoxyloganate 7-hydroxylase",
    "1.14.14.86\tEnt-kaurene monooxygenase",
    "1.14.14.87\t2-hydroxyisoflavanone synthase",
    "1.14.14.88\tIsoflavone 3'-hydroxylase",
    "1.14.14.89\t4'-methoxyisoflavone 2'-hydroxylase",
    "1.14.14.90\tIsoflavone 2'-hydroxylase",
    "1.14.14.91\tTrans-cinnamate 4-monooxygenase",
    "1.14.14.92\tBenzoate 4-monooxygenase",
    "1.14.14.93\t3,9-dihydroxypterocarpan 6A-monooxygenase",
    "1.14.14.94\tLeukotriene-B(4) 20-monooxygenase",
    "1.14.14.95\tGermacrene A hydroxylase",
    "1.14.14.96\t5-O-(4-coumaroyl)-D-quinate 3'-monooxygenase",
    "1.14.14.97\tMethyltetrahydroprotoberberine 14-monooxygenase",
    "1.14.14.98\tProtopine 6-monooxygenase",
    "1.14.14.99\t(S)-limonene 3-monooxygenase",
    "1.14.14.100\tDihydrosanguinarine 10-monooxygenase",
    "1.14.14.101\tDihydrochelirubine 12-monooxygenase",
    "1.14.14.102\tN-methylcoclaurine 3'-monooxygenase",
    "1.14.14.103\tTabersonine 16-hydroxylase",
    "1.14.14.104\tVinorine hydroxylase",
    "1.14.14.105\tTaxane 10-beta-hydroxylase",
    "1.14.14.106\tTaxane 13-alpha-hydroxylase",
    "1.14.14.107\tEnt-kaurenoic acid monooxygenase",
    "1.14.14.108\t2,5-diketocamphane 1,2-monooxygenase",
    "1.14.14.109\t3-hydroxyindolin-2-one monooxygenase",
    "1.14.14.110\t2-hydroxy-1,4-benzoxazin-3-one monooxygenase",
    "1.14.14.111\t9-beta-pimara-7,15-diene oxidase",
    "1.14.14.112\tEnt-cassa-12,15-diene 11-hydroxylase",
    "1.14.14.113\tAlpha-humulene 10-hydroxylase",
    "1.14.14.114\tAmorpha-4,11-diene 12 monooxygenase",
    "1.14.14.115\t11-oxo-beta-amyrin 30-oxidase",
    "1.14.14.116\tAverantin hydroxylase",
    "1.14.14.117\tAflatoxin B synthase",
    "1.14.14.118\tTryprostatin B 6-hydroxylase",
    "1.14.14.119\tFumitremorgin C monooxygenase",
    "1.14.14.120\tDammarenediol 12-hydroxylase",
    "1.14.14.121\tProtopanaxadiol 6-hydroxylase",
    "1.14.14.122\tOryzalexin E synthase",
    "1.14.14.123\tOryzalexin D synthase",
    "1.14.14.124\tDihydromonacolin L hydroxylase",
    "1.14.14.125\tMonacolin L hydroxylase",
    "1.14.14.126\tBeta-amyrin 28-monooxygenase",
    "1.14.14.127\tMethyl farnesoate epoxidase",
    "1.14.14.128\tFarnesoate epoxidase",
    "1.14.14.129\tLong-chain acyl-CoA omega-monooxygenase",
    "1.14.14.130\tLaurate 7-monooxygenase",
    "1.14.14.131\tBursehernin 5'-monooxygenase",
    "1.14.14.132\t(-)-4'-demethyl-deoxypodophyllotoxin 4-hydroxylase",
    "1.14.14.133\t1,8-cineole 2-endo-monooxygenase",
    "1.14.14.134\tBeta-amyrin 24-hydroxylase",
    "1.14.14.135\tGlyceollin synthase",
    "1.14.14.136\tDeoxysarpagine hydroxylase",
    "1.14.14.137\t(+)-abscisic acid 8'-hydroxylase",
    "1.14.14.138\tLithocholate 6-beta-hydroxylase",
    "1.14.14.139\t5-beta-cholestane-3-alpha,7-alpha-diol 12-alpha-hydroxylase",
    "1.14.14.140\tLicodione synthase",
    "1.14.14.141\tPsoralen synthase",
    "1.14.14.142\t8-dimethylallylnaringenin 2'-hydroxylase",
    "1.14.14.143\t(+)-menthofuran synthase",
    "1.14.14.144\tAbieta-7,13-diene hydroxylase",
    "1.14.14.145\tAbieta-7,13-dien-18-ol hydroxylase",
    "1.14.14.146\tGeranylgeraniol 18-hydroxylase",
    "1.14.14.147\t3-epi-6-deoxocathasterone 23-monooxygenase",
    "1.14.14.148\tAngelicin synthase",
    "1.14.14.149\t5-epiaristolochene 1,3-dihydroxylase",
    "1.14.14.150\tCostunolide synthase",
    "1.14.14.151\tPremnaspirodiene oxygenase",
    "1.14.14.152\tBeta-amyrin 11-oxidase",
    "1.14.14.153\tIndole-2-monooxygenase",
    "1.14.14.154\tSterol 14-alpha-demethylase",
    "1.14.14.155\t3,6-diketocamphane 1,2-monooxygenase",
    "1.14.14.156\tTryptophan N-monooxygenase",
    "1.14.14.157\tIndolin-2-one monooxygenase",
    "1.14.14.158\tCarotene epsilon-hydroxylase",
    "1.14.14.159\tDolabradiene monooxygenase",
    "1.14.14.160\tZealexin A1 synthase",
    "1.14.14.161\tNepetalactol monooxygenase",
    "1.14.14.162\tFlavanone 2-hydroxylase",
    "1.14.14.163\t(S)-1-hydroxy-N-methylcanadine 13-hydroxylase",
    "1.14.14.164\tFraxetin 5-hydroxylase",
    "1.14.14.165\tIndole-3-carbonyl nitrile 4-hydroxylase",
    "1.14.14.166\t(S)-N-methylcanadine 1-hydroxylase",
    "1.14.14.167\t(13S,14R)-13-O-acetyl-1-hydroxy-N-methylcanadine 8-hydroxylase",
    "1.14.14.168\tGermacreene A acid 8-beta-hydroxylase",
    "1.14.14.169\tEupatolide synthase",
    "1.14.14.170\t8-epi-inunolide synthase",
    "1.14.14.171\tBeta-amyrin 16-alpha-hydroxylase",
    "1.14.14.172\t3,5,6-trichloropyridin-2-ol monooxygenase",
    "1.14.14.173\t2,4,6-trichlorophenol monooxygenase",
    "1.14.14.174\tGeranylhydroquinone 3''-hydroxylase",
    "1.14.14.175\tFerruginol synthase",
    "1.14.14.176\tTaxadiene 5-alpha-hydroxylase",
    "1.14.14.177\tUltra-long-chain fatty acid omega-hydroxylase",
    "1.14.15.1\tCamphor 5-monooxygenase",
    "1.14.15.3\tAlkane 1-monooxygenase",
    "1.14.15.4\tSteroid 11-beta-monooxygenase",
    "1.14.15.5\tCorticosterone 18-monooxygenase",
    "1.14.15.6\tCholesterol monooxygenase (side-chain-cleaving)",
    "1.14.15.7\tCholine monooxygenase",
    "1.14.15.8\tSteroid 15-beta-monooxygenase",
    "1.14.15.9\tSpheroidene monooxygenase",
    "1.14.15.10\t(+)-camphor 6-endo-hydroxylase",
    "1.14.15.11\tPentalenic acid synthase",
    "1.14.15.13\tPulcherriminic acid synthase",
    "1.14.15.14\tMethyl-branched lipid omega-hydroxylase",
    "1.14.15.15\tCholestanetriol 26-monooxygenase",
    "1.14.15.16\tVitamin D(3) 24-hydroxylase",
    "1.14.15.17\tPheophorbide a oxygenase",
    "1.14.15.18\tCalcidiol 1-monooxygenase",
    "1.14.15.19\tC-19 steroid 1-alpha-hydroxylase",
    "1.14.15.20\tHeme oxygenase (biliverdin-producing, ferredoxin)",
    "1.14.15.21\tZeaxanthin epoxidase",
    "1.14.15.22\tVitamin D 1,25-hydroxylase",
    "1.14.15.23\tChloroacetanilide N-alkylformylase",
    "1.14.15.24\tBeta-carotene 3-hydroxylase",
    "1.14.15.25\tp-cymene methyl-monooxygenase",
    "1.14.15.26\tToluene methyl-monooxygenase",
    "1.14.15.27\tBeta-dihydromenaquinone-9 omega-hydroxylase",
    "1.14.15.28\tCholest-4-en-3-one 26-monooxygenase ((25R)-3-oxocholest-4-en-26-oate forming)",
    "1.14.15.29\tCholest-4-en-3-one 26-monooxygenase ((25S)-3-oxocholest-4-en-26-oate forming)",
    "1.14.15.30\t3-ketosteroid 9-alpha-monooxygenase",
    "1.14.15.31\t2-hydroxy-5-methyl-1-naphthoate 7-hydroxylase",
    "1.14.15.32\tPentalenene oxygenase",
    "1.14.15.33\tPikromycin synthase",
    "1.14.15.34\t20-oxo-5-O-mycaminosyltylactone 23-monooxygenase",
    "1.14.15.35\t6-deoxyerythronolide B hydroxylase",
    "1.14.15.36\tSterol 14-alpha-demethylase (ferredoxin)",
    "1.14.15.37\tLuteothin monooxygenase",
    "1.14.15.38\tN,N-dimethyl phenylurea N-demethylase",
    "1.14.15.39\tEpi-isozizaene 5-monooxygenase",
    "1.14.16.1\tPhenylalanine 4-monooxygenase",
    "1.14.16.2\tTyrosine 3-monooxygenase",
    "1.14.16.4\tTryptophan 5-monooxygenase",
    "1.14.16.5\tAlkylglycerol monooxygenase",
    "1.14.16.6\tMandelate 4-monooxygenase",
    "1.14.16.7\tPhenylalanine 3-monooxygenase",
    "1.14.17.1\tDopamine beta-monooxygenase",
    "1.14.17.3\tPeptidylglycine monooxygenase",
    "1.14.17.4\tAminocyclopropanecarboxylate oxidase",
    "1.14.18.1\tTyrosinase",
    "1.14.18.2\tCMP-N-acetylneuraminate monooxygenase",
    "1.14.18.3\tMethane monooxygenase (particulate)",
    "1.14.18.4\tPhosphatidylcholine 12-monooxygenase",
    "1.14.18.5\tSphingolipid C4-monooxygenase",
    "1.14.18.6\t4-hydroxysphinganine ceramide fatty acyl 2-hydroxylase",
    "1.14.18.7\tDihydroceramide fatty acyl 2-hydroxylase",
    "1.14.18.8\t7-alpha-hydroxycholest-4-en-3-one 12-alpha-hydroxylase",
    "1.14.18.9\t4-alpha-methylsterol monooxygenase",
    "1.14.18.10\tPlant 4,4-dimethylsterol C-4-alpha-methyl-monooxygenase",
    "1.14.18.11\tPlant 4-alpha-monomethylsterol monooxygenase",
    "1.14.18.12\t2-hydroxy fatty acid dioxygenase",
    "1.14.19.1\tStearoyl-CoA 9-desaturase",
    "1.14.19.2\tStearoyl-[acyl-carrier-protein] 9-desaturase",
    "1.14.19.3\tAcyl-CoA 6-desaturase",
    "1.14.19.4\tAcyl-lipid (11-3)-desaturase",
    "1.14.19.5\tAcyl-CoA 11-(Z)-desaturase",
    "1.14.19.6\tAcyl-CoA (9+3)-desaturase",
    "1.14.19.8\tPentalenolactone synthase",
    "1.14.19.9\tTryptophan 7-halogenase",
    "1.14.19.10\tIcosanoyl-CoA 5-desaturase",
    "1.14.19.11\tAcyl-[acyl-carrier-protein] 4-desaturase",
    "1.14.19.12\tAcyl-lipid omega-(9-4) desaturase",
    "1.14.19.13\tAcyl-CoA 15-desaturase",
    "1.14.19.14\tLinoleoyl-lipid Delta(9) conjugase",
    "1.14.19.15\t(11Z)-hexadec-11-enoyl-CoA conjugase",
    "1.14.19.16\tLinoleoyl-lipid Delta(12) conjugase (11E,13Z-forming)",
    "1.14.19.17\tSphingolipid 4-desaturase",
    "1.14.19.18\tSphingolipid 8-(E)-desaturase",
    "1.14.19.19\tSphingolipid 10-desaturase",
    "1.14.19.20\tDelta(7)-sterol 5(6)-desaturase",
    "1.14.19.21\tCholesterol 7-desaturase",
    "1.14.19.22\tAcyl-lipid omega-6 desaturase (cytochrome b5)",
    "1.14.19.23\tAcyl-lipid (n+3)-(Z)-desaturase (ferredoxin)",
    "1.14.19.24\tAcyl-CoA 11-(E)-desaturase",
    "1.14.19.25\tAcyl-lipid omega-3 desaturase (cytochrome b5)",
    "1.14.19.26\tAcyl-[acyl-carrier-protein] 6-desaturase",
    "1.14.19.27\tsn-2 palmitoyl-lipid 9-desaturase",
    "1.14.19.28\tsn-1 stearoyl-lipid 9-desaturase",
    "1.14.19.29\tSphingolipid 8-(E/Z)-desaturase",
    "1.14.19.30\tAcyl-lipid (8-3)-desaturase",
    "1.14.19.31\tAcyl-lipid (7-3)-desaturase",
    "1.14.19.32\tPalmitoyl-CoA 14-(E/Z)-desaturase",
    "1.14.19.33\tDelta(12) acyl-lipid conjugase (11E,13E-forming)",
    "1.14.19.34\tAcyl-lipid (9+3)-(E)-desaturase",
    "1.14.19.35\tsn-2 acyl-lipid omega-3 desaturase (ferredoxin)",
    "1.14.19.36\tsn-1 acyl-lipid omega-3 desaturase (ferredoxin)",
    "1.14.19.37\tAcyl-CoA 5-desaturase",
    "1.14.19.38\tAcyl-lipid Delta(6)-acetylenase",
    "1.14.19.39\tAcyl-lipid Delta(12)-acetylenase",
    "1.14.19.40\tHex-5-enoyl-[acyl-carrier protein] acetylenase",
    "1.14.19.41\tSterol 22-desaturase",
    "1.14.19.42\tPalmitoyl-[glycerolipid] 7-desaturase",
    "1.14.19.43\tPalmitoyl-[glycerolipid] 3-(E)-desaturase",
    "1.14.19.44\tAcyl-CoA (8-3)-desaturase",
    "1.14.19.45\tsn-1 oleoyl-lipid 12-desaturase",
    "1.14.19.46\tsn-1 linoleoyl-lipid 6-desaturase",
    "1.14.19.47\tAcyl-lipid (9-3)-desaturase",
    "1.14.19.48\tTert-amyl alcohol desaturase",
    "1.14.19.49\tTetracycline 7-halogenase",
    "1.14.19.50\tNoroxomaritidine synthase",
    "1.14.19.51\t(S)-corytuberine synthase",
    "1.14.19.52\tCamalexin synthase",
    "1.14.19.53\tAll-trans-retinol 3,4-desaturase",
    "1.14.19.54\t1,2-dehydroreticuline synthase",
    "1.14.19.55\t4-hydroxybenzoate brominase (decarboxylating)",
    "1.14.19.56\t1H-pyrrole-2-carbonyl-[peptidyl-carrier protein] chlorinase",
    "1.14.19.57\t1H-pyrrole-2-carbonyl-[peptidyl-carrier protein] brominase",
    "1.14.19.58\tTryptophan 5-halogenase",
    "1.14.19.59\tTryptophan 6-halogenase",
    "1.14.19.60\t7-chloro-L-tryptophan 6-halogenase",
    "1.14.19.61\tDihydrorhizobitoxine desaturase",
    "1.14.19.62\tSecologanin synthase",
    "1.14.19.63\tPseudobaptigenin synthase",
    "1.14.19.64\t(S)-stylopine synthase",
    "1.14.19.65\t(S)-cheilanthifoline synthase",
    "1.14.19.66\tBerbamunine synthase",
    "1.14.19.67\tSalutaridine synthase",
    "1.14.19.68\t(S)-canadine synthase",
    "1.14.19.69\tBiflaviolin synthase",
    "1.14.19.70\tMycocyclosin synthase",
    "1.14.19.71\tFumitremorgin C synthase",
    "1.14.19.72\t(-)-pluviatolide synthase",
    "1.14.19.73\t(S)-nandinine synthase",
    "1.14.19.74\t(+)-piperitol/(+)-sesamin synthase",
    "1.14.19.75\tVery-long-chain acyl-lipid omega-9 desaturase",
    "1.14.19.76\tFlavone synthase II",
    "1.14.19.77\tPlasmanylethanolamine desaturase",
    "1.14.19.78\tDecanoyl-[acyl-carrier protein] acetylenase",
    "1.14.19.n4\tStearoyl-CoA 9-desaturase (NADPH)",
    "1.14.19.n5\tVersicolorin B desaturase",
    "1.14.20.1\tDeacetoxycephalosporin-C synthase",
    "1.14.20.3\t(5R)-carbapenem-3-carboxylate synthase",
    "1.14.20.4\tAnthocyanidin synthase",
    "1.14.20.5\tFlavone synthase I",
    "1.14.20.6\tFlavonol synthase",
    "1.14.20.7\t2-oxoglutarate/L-arginine monooxygenase/decarboxylase (succinate-forming)",
    "1.14.20.8\t(-)-deoxypodophyllotoxin synthase",
    "1.14.20.9\tTyrosine isonitrile desaturase",
    "1.14.20.10\tTyrosine isonitrile desaturase/decarboxylase",
    "1.14.20.11\t3-((Z)-2-isocyanoethenyl)-1H-indole synthase",
    "1.14.20.12\t3-((E)-2-isocyanoethenyl)-1H-indole synthase",
    "1.14.20.13\t6-beta-hydroxyhyoscyamine epoxidase",
    "1.14.20.14\tHapalindole-type alkaloid chlorinase",
    "1.14.20.15\tL-threonyl-[L-threonyl-carrier protein] 4-chlorinase",
    "1.14.99.1\tProstaglandin-endoperoxide synthase",
    "1.14.99.2\tKynurenine 7,8-hydroxylase",
    "1.14.99.4\tProgesterone monooxygenase",
    "1.14.99.11\tEstradiol 6-beta-monooxygenase",
    "1.14.99.12\tAndrost-4-ene-3,17-dione monooxygenase",
    "1.14.99.14\tProgesterone 11-alpha-monooxygenase",
    "1.14.99.15\t4-methoxybenzoate monooxygenase (O-demethylating)",
    "1.14.99.20\tPhylloquinone monooxygenase (2,3-epoxidizing)",
    "1.14.99.21\tLatia-luciferin monooxygenase (demethylating)",
    "1.14.99.22\tEcdysone 20-monooxygenase",
    "1.14.99.23\t3-hydroxybenzoate 2-monooxygenase",
    "1.14.99.24\tSteroid 9-alpha-monooxygenase",
    "1.14.99.26\t2-hydroxypyridine 5-monooxygenase",
    "1.14.99.29\tDeoxyhypusine monooxygenase",
    "1.14.99.34\tMonoprenyl isoflavone epoxidase",
    "1.14.99.35\tThiophene-2-carbonyl-CoA monooxygenase",
    "1.14.99.38\tCholesterol 25-monooxygenase",
    "1.14.99.39\tAmmonia monooxygenase",
    "1.14.99.44\tDiapolycopene oxygenase",
    "1.14.99.46\tPyrimidine monooxygenase",
    "1.14.99.47\t(+)-larreatricin hydroxylase",
    "1.14.99.48\tHeme oxygenase (staphylobilin-producing)",
    "1.14.99.50\tGamma-glutamyl hercynylcysteine S-oxide synthase",
    "1.14.99.51\tHercynylcysteine S-oxide synthase",
    "1.14.99.52\tL-cysteinyl-L-histidinylsulfoxide synthase",
    "1.14.99.53\tLytic chitin monooxygenase",
    "1.14.99.54\tLytic cellulose monooxygenase (C1-hydroxylating)",
    "1.14.99.55\tLytic starch monooxygenase",
    "1.14.99.56\tLytic cellulose monooxygenase (C4-dehydrogenating)",
    "1.14.99.57\tHeme oxygenase (mycobilin-producing)",
    "1.14.99.58\tHeme oxygenase (biliverdin-IX-beta and delta-forming)",
    "1.14.99.59\tTryptamine 4-monooxygenase",
    "1.14.99.60\t3-demethoxyubiquinol 3-hydroxylase",
    "1.14.99.61\tCyclooctat-9-en-7-ol 5-monooxygenase",
    "1.14.99.62\tCyclooctatin synthase",
    "1.14.99.63\tBeta-carotene 4-ketolase",
    "1.14.99.64\tZeaxanthin 4-ketolase",
    "1.14.99.65\t4-amino-L-phenylalanyl-[CmlP-peptidyl-carrier-protein] 3-hydroxylase",
    "1.14.99.66\t[Histone-H3]-N(6),N(6)-dimethyl-L-lysine(4) FAD-dependent demethylase",
    "1.14.99.67\tAlpha-N-dichloroacetyl-p-aminophenylserinol N-oxygenase",
    "1.14.99.68\t4-aminobenzoate N-oxygenase",
    "1.14.99.69\ttRNA 2-(methylsulfanyl)-N(6)-isopentenyladenosine(37) hydroxylase",
    "1.14.99.n4\tCarotenoid 9,10-dioxygenase",
    "1.15.1.1\tSuperoxide dismutase",
    "1.15.1.2\tSuperoxide reductase",
    "1.16.1.1\tMercury(II) reductase",
    "1.16.1.2\tDiferric-transferrin reductase",
    "1.16.1.4\tCob(II)alamin reductase",
    "1.16.1.6\tCyanocobalamin reductase",
    "1.16.1.7\tFerric-chelate reductase (NADH)",
    "1.16.1.8\t[Methionine synthase] reductase",
    "1.16.1.9\tFerric-chelate reductase (NADPH)",
    "1.16.1.10\tFerric-chelate reductase (NAD(P)H)",
    "1.16.3.1\tFerroxidase",
    "1.16.3.2\tBacterial non-heme ferritin",
    "1.16.3.3\tManganese oxidase",
    "1.16.8.1\tCob(II)yrinic acid a,c-diamide reductase",
    "1.16.9.1\tIron:rusticyanin reductase",
    "1.16.99.1\t[Co(II) methylated amine-specific corrinoid protein] reductase",
    "1.17.1.1\tCDP-4-dehydro-6-deoxyglucose reductase",
    "1.17.1.3\tLeucoanthocyanidin reductase",
    "1.17.1.4\tXanthine dehydrogenase",
    "1.17.1.5\tNicotinate dehydrogenase",
    "1.17.1.8\t4-hydroxy-tetrahydrodipicolinate reductase",
    "1.17.1.9\tFormate dehydrogenase",
    "1.17.1.10\tFormate dehydrogenase (NADP(+))",
    "1.17.1.11\tFormate dehydrogenase (NAD(+), ferredoxin)",
    "1.17.2.1\tNicotinate dehydrogenase (cytochrome)",
    "1.17.2.2\tLupanine 17-hydroxylase (cytochrome c)",
    "1.17.2.3\tFormate dehydrogenase (cytochrome c-553)",
    "1.17.3.1\tPteridine oxidase",
    "1.17.3.2\tXanthine oxidase",
    "1.17.3.3\t6-hydroxynicotinate dehydrogenase",
    "1.17.3.4\tJuglone 3-hydroxylase",
    "1.17.4.1\tRibonucleoside-diphosphate reductase",
    "1.17.4.2\tRibonucleoside-triphosphate reductase (thioredoxin)",
    "1.17.4.4\tVitamin-K-epoxide reductase (warfarin-sensitive)",
    "1.17.4.5\tVitamin-K-epoxide reductase (warfarin-insensitive)",
    "1.17.5.1\tPhenylacetyl-CoA dehydrogenase",
    "1.17.5.2\tCaffeine dehydrogenase",
    "1.17.5.3\tFormate dehydrogenase-N",
    "1.17.7.1\t(E)-4-hydroxy-3-methylbut-2-enyl-diphosphate synthase (ferredoxin)",
    "1.17.7.2\t7-hydroxymethyl chlorophyll a reductase",
    "1.17.7.3\t(E)-4-hydroxy-3-methylbut-2-enyl-diphosphate synthase (flavodoxin)",
    "1.17.7.4\t4-hydroxy-3-methylbut-2-enyl diphosphate reductase",
    "1.17.8.1\tHydroxysqualene dehydroxylase",
    "1.17.9.1\t4-methylphenol dehydrogenase (hydroxylating)",
    "1.17.9.2\t(+)-pinoresinol hydroxylase",
    "1.17.98.2\tBacteriochlorophyllide c C-7(1)-hydroxylase",
    "1.17.98.3\tFormate dehydrogenase (coenzyme F420)",
    "1.17.98.4\tFormate dehydrogenase (acceptor)",
    "1.17.99.2\tEthylbenzene hydroxylase",
    "1.17.99.3\t3-alpha,7-alpha,12-alpha-trihydroxy-5-beta-cholestanoyl-CoA 24-hydroxylase",
    "1.17.99.4\tUracil/thymine dehydrogenase",
    "1.17.99.6\tEpoxyqueuosine reductase",
    "1.17.99.8\tLimonene dehydrogenase",
    "1.17.99.9\tHeme a synthase",
    "1.17.99.10\tSteroid C-25 hydroxylase",
    "1.17.99.11\t3-oxo-Delta(1)-steroid hydratase/dehydrogenase",
    "1.18.1.1\tRubredoxin--NAD(+) reductase",
    "1.18.1.2\tFerredoxin--NADP(+) reductase",
    "1.18.1.3\tFerredoxin--NAD(+) reductase",
    "1.18.1.4\tRubredoxin--NAD(P)(+) reductase",
    "1.18.1.5\tPutidaredoxin--NAD(+) reductase",
    "1.18.1.6\tAdrenodoxin-NADP(+) reductase",
    "1.18.1.7\tFerredoxin--NAD(P)(+) reductase (naphthalene dioxygenase ferredoxin-specific)",
    "1.18.6.1\tNitrogenase",
    "1.18.6.2\tVanadium-dependent nitrogenase",
    "1.19.1.1\tFlavodoxin--NADP(+) reductase",
    "1.19.6.1\tNitrogenase (flavodoxin)",
    "1.20.1.1\tPhosphonate dehydrogenase",
    "1.20.2.1\tArsenate reductase (cytochrome c)",
    "1.20.4.1\tArsenate reductase (glutathione/glutaredoxin)",
    "1.20.4.2\tMethylarsonate reductase",
    "1.20.4.3\tMycoredoxin",
    "1.20.4.4\tArsenate reductase (thioredoxin)",
    "1.20.9.1\tArsenate reductase (azurin)",
    "1.20.99.1\tArsenate reductase (donor)",
    "1.21.1.1\tIodotyrosine deiodinase",
    "1.21.1.2\t2,4-dichlorobenzoyl-CoA reductase",
    "1.21.3.1\tIsopenicillin-N synthase",
    "1.21.3.2\tColumbamine oxidase",
    "1.21.3.3\tReticuline oxidase",
    "1.21.3.4\tSulochrin oxidase ((+)-bisdechlorogeodin-forming)",
    "1.21.3.5\tSulochrin oxidase ((-)-bisdechlorogeodin-forming)",
    "1.21.3.6\tAureusidin synthase",
    "1.21.3.7\tTetrahydrocannabinolic acid synthase",
    "1.21.3.8\tCannabidiolic acid synthase",
    "1.21.4.1\tD-proline reductase",
    "1.21.4.2\tGlycine reductase",
    "1.21.4.3\tSarcosine reductase",
    "1.21.4.4\tBetaine reductase",
    "1.21.4.5\tTetrachlorohydroquinone reductive dehalogenase",
    "1.21.98.1\tCyclic dehypoxanthinyl futalosine synthase",
    "1.21.98.2\tDichlorochromopyrrolate synthase",
    "1.21.98.3\tAnaerobic magnesium-protoporphyrin IX monomethyl ester cyclase",
    "1.21.98.4\tPqqA peptide cyclase",
    "1.21.99.1\tBeta-cyclopiazonate dehydrogenase",
    "1.21.99.3\tThyroxine 5-deiodinase",
    "1.21.99.4\tThyroxine 5'-deiodinase",
    "1.21.99.5\tTetrachloroethene reductive dehalogenase",
    "1.23.1.1\t(+)-pinoresinol reductase",
    "1.23.1.2\t(+)-lariciresinol reductase",
    "1.23.1.3\t(-)-pinoresinol reductase",
    "1.23.1.4\t(-)-lariciresinol reductase",
    "1.23.5.1\tViolaxanthin de-epoxidase",
    "1.97.1.1\tChlorate reductase",
    "1.97.1.2\tPyrogallol hydroxytransferase",
    "1.97.1.4\t[Formate-C-acetyltransferase]-activating enzyme",
    "1.97.1.9\tSelenate reductase",
    "1.97.1.12\tPhotosystem I",
    "2.1.1.1\tNicotinamide N-methyltransferase",
    "2.1.1.2\tGuanidinoacetate N-methyltransferase",
    "2.1.1.3\tThetin--homocysteine S-methyltransferase",
    "2.1.1.4\tAcetylserotonin O-methyltransferase",
    "2.1.1.5\tBetaine--homocysteine S-methyltransferase",
    "2.1.1.6\tCatechol O-methyltransferase",
    "2.1.1.7\tNicotinate N-methyltransferase",
    "2.1.1.8\tHistamine N-methyltransferase",
    "2.1.1.9\tThiol S-methyltransferase",
    "2.1.1.10\tHomocysteine S-methyltransferase",
    "2.1.1.11\tMagnesium protoporphyrin IX methyltransferase",
    "2.1.1.12\tMethionine S-methyltransferase",
    "2.1.1.13\tMethionine synthase",
    "2.1.1.14\t5-methyltetrahydropteroyltriglutamate--homocysteine S-methyltransferase",
    "2.1.1.15\tFatty-acid O-methyltransferase",
    "2.1.1.16\tMethylene-fatty-acyl-phospholipid synthase",
    "2.1.1.17\tPhosphatidylethanolamine N-methyltransferase",
    "2.1.1.18\tPolysaccharide O-methyltransferase",
    "2.1.1.19\tTrimethylsulfonium--tetrahydrofolate N-methyltransferase",
    "2.1.1.20\tGlycine N-methyltransferase",
    "2.1.1.21\tMethylamine--glutamate N-methyltransferase",
    "2.1.1.22\tCarnosine N-methyltransferase",
    "2.1.1.25\tPhenol O-methyltransferase",
    "2.1.1.26\tIodophenol O-methyltransferase",
    "2.1.1.27\tTyramine N-methyltransferase",
    "2.1.1.28\tPhenylethanolamine N-methyltransferase",
    "2.1.1.33\ttRNA (guanine(46)-N(7))-methyltransferase",
    "2.1.1.34\ttRNA (guanosine(18)-2'-O)-methyltransferase",
    "2.1.1.35\ttRNA (uracil(54)-C(5))-methyltransferase",
    "2.1.1.37\tDNA (cytosine-5-)-methyltransferase",
    "2.1.1.38\tO-demethylpuromycin O-methyltransferase",
    "2.1.1.39\tInositol 3-methyltransferase",
    "2.1.1.40\tInositol 1-methyltransferase",
    "2.1.1.41\tSterol 24-C-methyltransferase",
    "2.1.1.42\tFlavone 3'-O-methyltransferase",
    "2.1.1.44\tL-histidine N(alpha)-methyltransferase",
    "2.1.1.45\tThymidylate synthase",
    "2.1.1.46\tIsoflavone 4'-O-methyltransferase",
    "2.1.1.47\tIndolepyruvate C-methyltransferase",
    "2.1.1.49\tAmine N-methyltransferase",
    "2.1.1.50\tLoganate O-methyltransferase",
    "2.1.1.53\tPutrescine N-methyltransferase",
    "2.1.1.54\tDeoxycytidylate C-methyltransferase",
    "2.1.1.55\ttRNA (adenine-N(6)-)-methyltransferase",
    "2.1.1.56\tmRNA (guanine-N(7))-methyltransferase",
    "2.1.1.57\tMethyltransferase cap1",
    "2.1.1.59\t[Cytochrome c]-lysine N-methyltransferase",
    "2.1.1.60\tCalmodulin-lysine N-methyltransferase",
    "2.1.1.61\ttRNA 5-(aminomethyl)-2-thiouridylate-methyltransferase",
    "2.1.1.62\tmRNA (2'-O-methyladenosine-N(6)-)-methyltransferase",
    "2.1.1.63\tMethylated-DNA--[protein]-cysteine S-methyltransferase",
    "2.1.1.64\t3-demethylubiquinol 3-O-methyltransferase",
    "2.1.1.65\tLicodione 2'-O-methyltransferase",
    "2.1.1.67\tThiopurine S-methyltransferase",
    "2.1.1.68\tCaffeate O-methyltransferase",
    "2.1.1.69\t5-hydroxyfuranocoumarin 5-O-methyltransferase",
    "2.1.1.70\t8-hydroxyfuranocoumarin 8-O-methyltransferase",
    "2.1.1.71\tPhosphatidyl-N-methylethanolamine N-methyltransferase",
    "2.1.1.72\tSite-specific DNA-methyltransferase (adenine-specific)",
    "2.1.1.74\tMethylenetetrahydrofolate--tRNA-(uracil(54)-C(5))-methyltransferase (NAD(P)H-oxidizing)",
    "2.1.1.75\tApigenin 4'-O-methyltransferase",
    "2.1.1.76\tQuercetin 3-O-methyltransferase",
    "2.1.1.77\tProtein-L-isoaspartate(D-aspartate) O-methyltransferase",
    "2.1.1.78\tIsoorientin 3'-O-methyltransferase",
    "2.1.1.79\tCyclopropane-fatty-acyl-phospholipid synthase",
    "2.1.1.80\tProtein-glutamate O-methyltransferase",
    "2.1.1.82\t3-methylquercetin 7-O-methyltransferase",
    "2.1.1.83\t3,7-dimethylquercetin 4'-O-methyltransferase",
    "2.1.1.84\tMethylquercetagetin 6-O-methyltransferase",
    "2.1.1.85\tProtein-histidine N-methyltransferase",
    "2.1.1.86\tTetrahydromethanopterin S-methyltransferase",
    "2.1.1.87\tPyridine N-methyltransferase",
    "2.1.1.88\t8-hydroxyquercetin 8-O-methyltransferase",
    "2.1.1.89\tTetrahydrocolumbamine 2-O-methyltransferase",
    "2.1.1.90\tMethanol--corrinoid protein Co-methyltransferase",
    "2.1.1.91\tIsobutyraldoxime O-methyltransferase",
    "2.1.1.94\tTabersonine 16-O-methyltransferase",
    "2.1.1.95\tTocopherol C-methyltransferase",
    "2.1.1.96\tThioether S-methyltransferase",
    "2.1.1.97\t3-hydroxyanthranilate 4-C-methyltransferase",
    "2.1.1.98\tDiphthine synthase",
    "2.1.1.99\t3-hydroxy-16-methoxy-2,3-dihydrotabersonine N-methyltransferase",
    "2.1.1.100\tProtein-S-isoprenylcysteine O-methyltransferase",
    "2.1.1.101\tMacrocin O-methyltransferase",
    "2.1.1.102\tDemethylmacrocin O-methyltransferase",
    "2.1.1.103\tPhosphoethanolamine N-methyltransferase",
    "2.1.1.104\tCaffeoyl-CoA O-methyltransferase",
    "2.1.1.105\tN-benzoyl-4-hydroxyanthranilate 4-O-methyltransferase",
    "2.1.1.106\tTryptophan 2-C-methyltransferase",
    "2.1.1.107\tUroporphyrinogen-III C-methyltransferase",
    "2.1.1.108\t6-hydroxymellein O-methyltransferase",
    "2.1.1.109\tDemethylsterigmatocystin 6-O-methyltransferase",
    "2.1.1.110\tSterigmatocystin 8-O-methyltransferase",
    "2.1.1.111\tAnthranilate N-methyltransferase",
    "2.1.1.112\tGlucuronoxylan 4-O-methyltransferase",
    "2.1.1.113\tSite-specific DNA-methyltransferase (cytosine-N(4)-specific)",
    "2.1.1.114\tPolyprenyldihydroxybenzoate methyltransferase",
    "2.1.1.115\t(RS)-1-benzyl-1,2,3,4-tetrahydroisoquinoline N-methyltransferase",
    "2.1.1.116\t3'-hydroxy-N-methyl-(S)-coclaurine 4'-O-methyltransferase",
    "2.1.1.117\t(S)-scoulerine 9-O-methyltransferase",
    "2.1.1.118\tColumbamine O-methyltransferase",
    "2.1.1.119\t10-hydroxydihydrosanguinarine 10-O-methyltransferase",
    "2.1.1.120\t12-hydroxydihydrochelirubine 12-O-methyltransferase",
    "2.1.1.121\t6-O-methylnorlaudanosoline 5'-O-methyltransferase",
    "2.1.1.122\t(S)-tetrahydroprotoberberine N-methyltransferase",
    "2.1.1.123\t[Cytochrome c]-methionine S-methyltransferase",
    "2.1.1.127\t[Ribulose-bisphosphate carboxylase]-lysine N-methyltransferase",
    "2.1.1.128\t(RS)-norcoclaurine 6-O-methyltransferase",
    "2.1.1.129\tInositol 4-methyltransferase",
    "2.1.1.130\tPrecorrin-2 C(20)-methyltransferase",
    "2.1.1.131\tPrecorrin-3B C(17)-methyltransferase",
    "2.1.1.132\tPrecorrin-6B C(5,15)-methyltransferase (decarboxylating)",
    "2.1.1.133\tPrecorrin-4 C(11)-methyltransferase",
    "2.1.1.136\tChlorophenol O-methyltransferase",
    "2.1.1.137\tArsenite methyltransferase",
    "2.1.1.139\t3'-demethylstaurosporine O-methyltransferase",
    "2.1.1.140\t(S)-coclaurine-N-methyltransferase",
    "2.1.1.141\tJasmonate O-methyltransferase",
    "2.1.1.142\tCycloartenol 24-C-methyltransferase",
    "2.1.1.143\t24-methylenesterol C-methyltransferase",
    "2.1.1.144\tTrans-aconitate 2-methyltransferase",
    "2.1.1.145\tTrans-aconitate 3-methyltransferase",
    "2.1.1.146\t(Iso)eugenol O-methyltransferase",
    "2.1.1.147\tCorydaline synthase",
    "2.1.1.148\tThymidylate synthase (FAD)",
    "2.1.1.150\tIsoflavone 7-O-methyltransferase",
    "2.1.1.151\tCobalt-factor II C(20)-methyltransferase",
    "2.1.1.152\tPrecorrin-6A synthase (deacetylating)",
    "2.1.1.153\tVitexin 2''-O-rhamnoside 7-O-methyltransferase",
    "2.1.1.154\tIsoliquiritigenin 2'-O-methyltransferase",
    "2.1.1.155\tKaempferol 4'-O-methyltransferase",
    "2.1.1.156\tGlycine/sarcosine N-methyltransferase",
    "2.1.1.157\tSarcosine/dimethylglycine N-methyltransferase",
    "2.1.1.158\t7-methylxanthosine synthase",
    "2.1.1.159\tTheobromine synthase",
    "2.1.1.160\tCaffeine synthase",
    "2.1.1.161\tDimethylglycine N-methyltransferase",
    "2.1.1.162\tGlycine/sarcosine/dimethylglycine N-methyltransferase",
    "2.1.1.163\tDemethylmenaquinone methyltransferase",
    "2.1.1.164\tDemethylrebeccamycin-D-glucose O-methyltransferase",
    "2.1.1.165\tMethyl halide transferase",
    "2.1.1.166\t23S rRNA (uridine(2552)-2'-O)-methyltransferase",
    "2.1.1.167\t27S pre-rRNA (guanosine(2922)-2'-O)-methyltransferase",
    "2.1.1.168\t21S rRNA (uridine(2791)-2'-O)-methyltransferase",
    "2.1.1.169\tTricetin 3',4',5'-O-trimethyltransferase",
    "2.1.1.170\t16S rRNA (guanine(527)-N(7))-methyltransferase",
    "2.1.1.171\t16S rRNA (guanine(966)-N(2))-methyltransferase",
    "2.1.1.172\t16S rRNA (guanine(1207)-N(2))-methyltransferase",
    "2.1.1.173\t23S rRNA (guanine(2445)-N(2))-methyltransferase",
    "2.1.1.174\t23S rRNA (guanine(1835)-N(2))-methyltransferase",
    "2.1.1.175\tTricin synthase",
    "2.1.1.176\t16S rRNA (cytosine(967)-C(5))-methyltransferase",
    "2.1.1.177\t23S rRNA (pseudouridine(1915)-N(3))-methyltransferase",
    "2.1.1.178\t16S rRNA (cytosine(1407)-C(5))-methyltransferase",
    "2.1.1.179\t16S rRNA (guanine(1405)-N(7))-methyltransferase",
    "2.1.1.180\t16S rRNA (adenine(1408)-N(1))-methyltransferase",
    "2.1.1.181\t23S rRNA (adenine(1618)-N(6))-methyltransferase",
    "2.1.1.182\t16S rRNA (adenine(1518)-N(6)/adenine(1519)-N(6))-dimethyltransferase",
    "2.1.1.183\t18S rRNA (adenine(1779)-N(6)/adenine(1780)-N(6))-dimethyltransferase",
    "2.1.1.184\t23S rRNA (adenine(2085)-N(6))-dimethyltransferase",
    "2.1.1.185\t23S rRNA (guanosine(2251)-2'-O)-methyltransferase",
    "2.1.1.186\t23S rRNA (cytidine(2498)-2'-O)-methyltransferase",
    "2.1.1.187\t23S rRNA (guanine(745)-N(1))-methyltransferase",
    "2.1.1.188\t23S rRNA (guanine(748)-N(1))-methyltransferase",
    "2.1.1.189\t23S rRNA (uracil(747)-C(5))-methyltransferase",
    "2.1.1.190\t23S rRNA (uracil(1939)-C(5))-methyltransferase",
    "2.1.1.191\t23S rRNA (cytosine(1962)-C(5))-methyltransferase",
    "2.1.1.192\t23S rRNA (adenine(2503)-C(2))-methyltransferase",
    "2.1.1.193\t16S rRNA (uracil(1498)-N(3))-methyltransferase",
    "2.1.1.195\tCobalt-precorrin-5B (C(1))-methyltransferase",
    "2.1.1.196\tCobalt-precorrin-6B (C(15))-methyltransferase (decarboxylating)",
    "2.1.1.197\tMalonyl-[acyl-carrier protein] O-methyltransferase",
    "2.1.1.198\t16S rRNA (cytidine(1402)-2'-O)-methyltransferase",
    "2.1.1.199\t16S rRNA (cytosine(1402)-N(4))-methyltransferase",
    "2.1.1.200\ttRNA (cytidine(32)/uridine(32)-2'-O)-methyltransferase",
    "2.1.1.201\t2-methoxy-6-polyprenyl-1,4-benzoquinol methylase",
    "2.1.1.202\tMultisite-specific tRNA:(cytosine-C(5))-methyltransferase",
    "2.1.1.203\ttRNA (cytosine(34)-C(5))-methyltransferase",
    "2.1.1.204\ttRNA (cytosine(38)-C(5))-methyltransferase",
    "2.1.1.205\ttRNA (cytidine(32)/guanosine(34)-2'-O)-methyltransferase",
    "2.1.1.206\ttRNA (cytidine(56)-2'-O)-methyltransferase",
    "2.1.1.207\ttRNA (cytidine(34)-2'-O)-methyltransferase",
    "2.1.1.208\t23S rRNA (uridine(2479)-2'-O)-methyltransferase",
    "2.1.1.209\t23S rRNA (guanine(2535)-N(1))-methyltransferase",
    "2.1.1.210\tDemethylspheroidene O-methyltransferase",
    "2.1.1.211\ttRNA(Ser) (uridine(44)-2'-O)-methyltransferase",
    "2.1.1.212\t2,7,4'-trihydroxyisoflavanone 4'-O-methyltransferase",
    "2.1.1.213\ttRNA (guanine(10)-N(2))-dimethyltransferase",
    "2.1.1.214\ttRNA (guanine(10)-N(2))-methyltransferase",
    "2.1.1.215\ttRNA (guanine(26)-N(2)/guanine(27)-N(2))-dimethyltransferase",
    "2.1.1.216\ttRNA (guanine(26)-N(2))-dimethyltransferase",
    "2.1.1.217\ttRNA (adenine(22)-N(1))-methyltransferase",
    "2.1.1.218\ttRNA (adenine(9)-N(1))-methyltransferase",
    "2.1.1.219\ttRNA (adenine(57)-N(1)/adenine(58)-N(1))-methyltransferase",
    "2.1.1.220\ttRNA (adenine(58)-N(1))-methyltransferase",
    "2.1.1.221\ttRNA (guanine(9)-N(1))-methyltransferase",
    "2.1.1.222\t2-polyprenyl-6-hydroxyphenol methylase",
    "2.1.1.223\ttRNA(1)(Val) (adenine(37)-N(6))-methyltransferase",
    "2.1.1.224\t23S rRNA (adenine(2503)-C(8))-methyltransferase",
    "2.1.1.225\ttRNA:m(4)X modification enzyme",
    "2.1.1.226\t23S rRNA (cytidine(1920)-2'-O)-methyltransferase",
    "2.1.1.227\t16S rRNA (cytidine(1409)-2'-O)-methyltransferase",
    "2.1.1.228\ttRNA (guanine(37)-N(1))-methyltransferase",
    "2.1.1.229\ttRNA (carboxymethyluridine(34)-5-O)-methyltransferase",
    "2.1.1.230\t23S rRNA (adenosine(1067)-2'-O)-methyltransferase",
    "2.1.1.231\tFlavonoid 4'-O-methyltransferase",
    "2.1.1.232\tNaringenin 7-O-methyltransferase",
    "2.1.1.233\t[Phosphatase 2A protein]-leucine-carboxy methyltransferase",
    "2.1.1.234\tdTDP-3-amino-3,4,6-trideoxy-alpha-D-glucopyranose N,N-dimethyltransferase",
    "2.1.1.235\tdTDP-3-amino-3,6-dideoxy-alpha-D-glucopyranose N,N-dimethyltransferase",
    "2.1.1.236\tdTDP-3-amino-3,6-dideoxy-alpha-D-galactopyranose N,N-dimethyltransferase",
    "2.1.1.237\tMycinamicin III 3''-O-methyltransferase",
    "2.1.1.238\tMycinamicin VI 2''-O-methyltransferase",
    "2.1.1.239\tL-olivosyl-oleandolide 3-O-methyltransferase",
    "2.1.1.240\tTrans-resveratrol di-O-methyltransferase",
    "2.1.1.241\t2,4,7-trihydroxy-1,4-benzoxazin-3-one-glucoside 7-O-methyltransferase",
    "2.1.1.242\t16S rRNA (guanine(1516)-N(2))-methyltransferase",
    "2.1.1.243\t2-ketoarginine methyltransferase",
    "2.1.1.244\tProtein N-terminal methyltransferase",
    "2.1.1.245\t5-methyltetrahydrosarcinapterin:corrinoid/iron-sulfur protein Co-methyltransferase",
    "2.1.1.246\t[Methyl-Co(III) methanol-specific corrinoid protein]:coenzyme M methyltransferase",
    "2.1.1.247\t[Methyl-Co(III) methylamine-specific corrinoid protein]:coenzyme M methyltransferase",
    "2.1.1.248\t[Methylamine--corrinoid protein] Co-methyltransferase",
    "2.1.1.249\t[Dimethylamine--corrinoid protein] Co-methyltransferase",
    "2.1.1.250\t[Trimethylamine--corrinoid protein] Co-methyltransferase",
    "2.1.1.251\tMethylated-thiol--coenzyme M methyltransferase",
    "2.1.1.252\tTetramethylammonium--corrinoid protein Co-methyltransferase",
    "2.1.1.253\t[Methyl-Co(III) tetramethylammonium-specific corrinoid protein]:coenzyme M methyltransferase",
    "2.1.1.254\tErythromycin 3''-O-methyltransferase",
    "2.1.1.255\tGeranyl diphosphate 2-C-methyltransferase",
    "2.1.1.256\ttRNA (guanine(6)-N(2))-methyltransferase",
    "2.1.1.257\ttRNA (pseudouridine(54)-N(1))-methyltransferase",
    "2.1.1.258\t5-methyltetrahydrofolate:corrinoid/iron-sulfur protein Co-methyltransferase",
    "2.1.1.259\t[Fructose-bisphosphate aldolase]-lysine N-methyltransferase",
    "2.1.1.260\trRNA small subunit pseudouridine methyltransferase Nep1",
    "2.1.1.261\t4-dimethylallyltryptophan N-methyltransferase",
    "2.1.1.262\tSqualene methyltransferase",
    "2.1.1.263\tBotryococcene C-methyltransferase",
    "2.1.1.264\t23S rRNA (guanine(2069)-N(7))-methyltransferase",
    "2.1.1.265\tTellurite methyltransferase",
    "2.1.1.266\t23S rRNA (adenine(2030)-N(6))-methyltransferase",
    "2.1.1.267\tFlavonoid 3',5'-methyltransferase",
    "2.1.1.268\ttRNA(Thr) (cytosine(32)-N(3))-methyltransferase",
    "2.1.1.269\tDimethylsulfoniopropionate demethylase",
    "2.1.1.270\t(+)-6a-hydroxymaackiain 3-O-methyltransferase",
    "2.1.1.271\tCobalt-precorrin-4 methyltransferase",
    "2.1.1.272\tCobalt-factor III methyltransferase",
    "2.1.1.273\tBenzoate O-methyltransferase",
    "2.1.1.274\tSalicylate carboxymethyltransferase",
    "2.1.1.275\tGibberellin A(9) O-methyltransferase",
    "2.1.1.276\tGibberellin A(4) carboxyl methyltransferase",
    "2.1.1.277\tAnthranilate O-methyltransferase",
    "2.1.1.278\tIndole-3-acetate O-methyltransferase",
    "2.1.1.279\tTrans-anol O-methyltransferase",
    "2.1.1.280\tSelenocysteine Se-methyltransferase",
    "2.1.1.281\tPhenylpyruvate C(3)-methyltransferase",
    "2.1.1.282\ttRNA(Phe) 7-((3-amino-3-carboxypropyl)-4-demethylwyosine(37)-N(4))-methyltransferase",
    "2.1.1.283\tEmodin O-methyltransferase",
    "2.1.1.284\t8-demethylnovobiocic acid C(8)-methyltransferase",
    "2.1.1.285\tDemethyldecarbamoylnovobiocin O-methyltransferase",
    "2.1.1.286\t25S rRNA (adenine(2142)-N(1))-methyltransferase",
    "2.1.1.287\t25S rRNA (adenine(645)-N(1))-methyltransferase",
    "2.1.1.288\tAklanonic acid methyltransferase",
    "2.1.1.289\tCobalt-precorrin-7 (C(5))-methyltransferase",
    "2.1.1.290\ttRNA(Phe) (7-(3-amino-3-carboxypropyl)wyosine(37)-O)-methyltransferase",
    "2.1.1.291\t(R,S)-reticuline 7-O-methyltransferase",
    "2.1.1.292\tCarminomycin 4-O-methyltransferase",
    "2.1.1.293\t6-hydroxytryprostatin B O-methyltransferase",
    "2.1.1.294\t3-O-phospho-polymannosyl GlcNAc-diphospho-ditrans,octacis-undecaprenol 3-phospho-methyltransferase",
    "2.1.1.295\t2-methyl-6-phytyl-1,4-hydroquinone methyltransferase",
    "2.1.1.296\tMethyltransferase cap2",
    "2.1.1.297\tPeptide chain release factor N(5)-glutamine methyltransferase",
    "2.1.1.298\tRibosomal protein L3 N(5)-glutamine methyltransferase",
    "2.1.1.299\tProtein N-terminal monomethyltransferase",
    "2.1.1.300\tPavine N-methyltransferase",
    "2.1.1.301\tCypemycin N-terminal methyltransferase",
    "2.1.1.302\t3-hydroxy-5-methyl-1-naphthoate 3-O-methyltransferase",
    "2.1.1.303\t2,7-dihydroxy-5-methyl-1-naphthoate 7-O-methyltransferase",
    "2.1.1.304\tL-tyrosine C(3)-methyltransferase",
    "2.1.1.305\t8-demethyl-8-alpha-L-rhamnosyl tetracenomycin-C 2'-O-methyltransferase",
    "2.1.1.306\t8-demethyl-8-(2-methoxy-alpha-L-rhamnosyl)-tetracenomycin-C 3'-O-methyltransferase",
    "2.1.1.307\t8-demethyl-8-(2,3-dimethoxy-alpha-L-rhamnosyl)-tetracenomycin-C 4'-O-methyltransferase",
    "2.1.1.308\tCytidylyl-2-hydroxyethylphosphonate methyltransferase",
    "2.1.1.309\t18S rRNA (guanine(1575)-N(7))-methyltransferase",
    "2.1.1.310\t25S rRNA (cytosine(2870)-C(5))-methyltransferase",
    "2.1.1.311\t25S rRNA (cytosine(2278)-C(5))-methyltransferase",
    "2.1.1.312\t25S rRNA (uracil(2843)-N(3))-methyltransferase",
    "2.1.1.313\t25S rRNA (uracil(2634)-N(3))-methyltransferase",
    "2.1.1.314\tDiphthine methyl ester synthase",
    "2.1.1.315\t27-O-demethylrifamycin SV methyltransferase",
    "2.1.1.316\tMitomycin 6-O-methyltransferase",
    "2.1.1.317\tSphingolipid C(9)-methyltransferase",
    "2.1.1.318\t[Trehalose-6-phosphate synthase]-L-cysteine S-methyltransferase",
    "2.1.1.319\tType I protein arginine methyltransferase",
    "2.1.1.320\tType II protein arginine methyltransferase",
    "2.1.1.321\tType III protein arginine methyltransferase",
    "2.1.1.322\tType IV protein arginine methyltransferase",
    "2.1.1.323\t(-)-pluviatolide 4-O-methyltransferase",
    "2.1.1.324\tdTDP-4-amino-2,3,4,6-tetradeoxy-D-glucose N,N-dimethyltransferase",
    "2.1.1.325\tJuvenile hormone-III synthase",
    "2.1.1.326\tN-acetyl-demethylphosphinothricin P-methyltransferase",
    "2.1.1.327\tPhenazine-1-carboxylate N-methyltransferase",
    "2.1.1.328\tN-demethylindolmycin N-methyltransferase",
    "2.1.1.329\tDemethylphylloquinol methyltransferase",
    "2.1.1.330\t5'-demethylyatein 5'-O-methyltransferase",
    "2.1.1.331\tBacteriochlorophyllide d C-12(1)-methyltransferase",
    "2.1.1.332\tBacteriochlorophyllide d C-8(2)-methyltransferase",
    "2.1.1.333\tBacteriochlorophyllide d C-20 methyltransferase",
    "2.1.1.334\tMethanethiol S-methyltransferase",
    "2.1.1.335\t4-amino-anhydrotetracycline N(4)-methyltransferase",
    "2.1.1.336\tNorbelladine O-methyltransferase",
    "2.1.1.337\tReticuline N-methyltransferase",
    "2.1.1.338\tDesmethylxanthohumol 6'-O-methyltransferase",
    "2.1.1.339\tXanthohumol 4-O-methyltransferase",
    "2.1.1.340\t3-aminomethylindole N-methyltransferase",
    "2.1.1.341\tVanillate/3-O-methylgallate O-demethylase",
    "2.1.1.342\tAnaerobilin synthase",
    "2.1.1.343\t8-amino-8-demethylriboflavin N,N-dimethyltransferase",
    "2.1.1.344\tOrnithine lipid N-methyltransferase",
    "2.1.1.345\tPsilocybin synthase",
    "2.1.1.346\tU6 snRNA m(6)A methyltransferase",
    "2.1.1.347\t(+)-O-methylkolavelool synthase",
    "2.1.1.348\tmRNA m(6)A methyltransferase",
    "2.1.1.349\tToxoflavin synthase",
    "2.1.1.350\tMenaquinone C(8)-methyltransferase",
    "2.1.1.351\tNocamycin O-methyltransferase",
    "2.1.1.352\t3-O-acetyl-4'-O-demethylpapaveroxine 4'-O-methyltransferase",
    "2.1.1.353\tDemethylluteothin O-methyltransferase",
    "2.1.1.354\t[Histone H3]-lysine(4) N-trimethyltransferase",
    "2.1.1.355\t[Histone H3]-lysine(9) N-trimethyltransferase",
    "2.1.1.356\t[Histone H3]-lysine(27) N-trimethyltransferase",
    "2.1.1.357\t[Histone H3]-lysine(36) N-dimethyltransferase",
    "2.1.1.359\t[Histone H3]-lysine(36) N-trimethyltransferase",
    "2.1.1.360\t[Histone H3]-lysine(79) N-trimethyltransferase",
    "2.1.1.361\t[Histone H4]-lysine(20) N-methyltransferase",
    "2.1.1.362\t[Histone H4]-N-methyl-L-lysine(20) N-methyltransferase",
    "2.1.1.363\tPre-sodorifen synthase",
    "2.1.1.364\t[Histone H3]-lysine(4) N-methyltransferase",
    "2.1.1.365\tMMP 1-O-methyltransferase",
    "2.1.1.366\t[Histone H3]-N(6),N(6)-dimethyl-lysine(9) N-methyltransferase",
    "2.1.1.367\t[Histone H3]-lysine(9) N-methyltransferase",
    "2.1.1.368\t[Histone H3]-lysine(9) N-dimethyltransferase",
    "2.1.1.369\t[Histone H3]-lysine(27) N-methyltransferase",
    "2.1.1.370\t[Histone H3]-lysine(4) N-dimethyltransferase",
    "2.1.1.371\t[Histone H3]-lysine(27) N-dimethyltransferase",
    "2.1.1.372\t[Histone H4]-lysine(20) N-trimethyltransferase",
    "2.1.1.373\t2-hydroxy-4-(methylsulfanyl)butanoate S-methyltransferase",
    "2.1.1.374\t2-heptyl-1-hydroxyquinolin-4(1H)-one methyltransferase",
    "2.1.1.375\tNNS virus cap methyltransferase",
    "2.1.1.376\tGlycine betaine--corrinoid protein Co-methyltransferase",
    "2.1.1.377\t[Methyl-Co(III) glycine betaine-specific corrinoid protein]--coenzyme M methyltransferase",
    "2.1.1.378\t[Methyl-Co(III) glycine betaine-specific corrinoid protein]--tetrahydrofolate methyltransferase",
    "2.1.1.379\t[Methyl coenzyme M reductase]-L-arginine C-5-methyltransferase",
    "2.1.1.n1\tResorcinol O-methyltransferase",
    "2.1.1.n4\tThiocyanate methyltransferase",
    "2.1.1.n7\t5-pentadecatrienyl resorcinol O-methyltransferase",
    "2.1.1.n8\tSmall RNA 2'-O-methyltransferase",
    "2.1.1.n11\tMethylphosphotriester-DNA--[protein]-cysteine S-methyltransferase",
    "2.1.2.1\tGlycine hydroxymethyltransferase",
    "2.1.2.2\tPhosphoribosylglycinamide formyltransferase 1",
    "2.1.2.3\tPhosphoribosylaminoimidazolecarboxamide formyltransferase",
    "2.1.2.4\tGlycine formimidoyltransferase",
    "2.1.2.5\tGlutamate formimidoyltransferase",
    "2.1.2.7\tD-alanine 2-hydroxymethyltransferase",
    "2.1.2.8\tDeoxycytidylate 5-hydroxymethyltransferase",
    "2.1.2.9\tMethionyl-tRNA formyltransferase",
    "2.1.2.10\tAminomethyltransferase",
    "2.1.2.11\t3-methyl-2-oxobutanoate hydroxymethyltransferase",
    "2.1.2.13\tUDP-4-amino-4-deoxy-L-arabinose formyltransferase",
    "2.1.2.14\tGDP-perosamine N-formyltransferase",
    "2.1.3.1\tMethylmalonyl-CoA carboxytransferase",
    "2.1.3.2\tAspartate carbamoyltransferase",
    "2.1.3.3\tOrnithine carbamoyltransferase",
    "2.1.3.5\tOxamate carbamoyltransferase",
    "2.1.3.6\tPutrescine carbamoyltransferase",
    "2.1.3.7\t3-hydroxymethylcephem carbamoyltransferase",
    "2.1.3.8\tLysine carbamoyltransferase",
    "2.1.3.9\tN-acetylornithine carbamoyltransferase",
    "2.1.3.10\tMalonyl-S-ACP:biotin-protein carboxyltransferase",
    "2.1.3.11\tN-succinylornithine carbamoyltransferase",
    "2.1.3.12\tDecarbamoylnovobiocin carbamoyltransferase",
    "2.1.3.15\tAcetyl-CoA carboxytransferase",
    "2.1.4.1\tGlycine amidinotransferase",
    "2.1.4.2\tScyllo-inosamine-4-phosphate amidinotransferase",
    "2.1.4.3\tL-arginine:L-lysine amidinotransferase",
    "2.1.5.1\tSesamin methylene transferase",
    "2.2.1.1\tTransketolase",
    "2.2.1.2\tTransaldolase",
    "2.2.1.3\tFormaldehyde transketolase",
    "2.2.1.4\tAcetoin--ribose-5-phosphate transaldolase",
    "2.2.1.5\t2-hydroxy-3-oxoadipate synthase",
    "2.2.1.6\tAcetolactate synthase",
    "2.2.1.7\t1-deoxy-D-xylulose-5-phosphate synthase",
    "2.2.1.8\tFluorothreonine transaldolase",
    "2.2.1.9\t2-succinyl-5-enolpyruvyl-6-hydroxy-3-cyclohexene-1-carboxylic-acid synthase",
    "2.2.1.10\t2-amino-3,7-dideoxy-D-threo-hept-6-ulosonate synthase",
    "2.2.1.11\t6-deoxy-5-ketofructose 1-phosphate synthase",
    "2.2.1.12\t3-acetyloctanal synthase",
    "2.2.1.13\tApulose-4-phosphate transketolase",
    "2.2.1.14\t6-deoxy-6-sulfo-D-fructose transaldolase",
    "2.3.1.1\tAmino-acid N-acetyltransferase",
    "2.3.1.2\tImidazole N-acetyltransferase",
    "2.3.1.3\tGlucosamine N-acetyltransferase",
    "2.3.1.4\tGlucosamine-phosphate N-acetyltransferase",
    "2.3.1.5\tArylamine N-acetyltransferase",
    "2.3.1.6\tCholine O-acetyltransferase",
    "2.3.1.7\tCarnitine O-acetyltransferase",
    "2.3.1.8\tPhosphate acetyltransferase",
    "2.3.1.9\tAcetyl-CoA C-acetyltransferase",
    "2.3.1.10\tHydrogen-sulfide S-acetyltransferase",
    "2.3.1.11\tThioethanolamine S-acetyltransferase",
    "2.3.1.12\tDihydrolipoyllysine-residue acetyltransferase",
    "2.3.1.13\tGlycine N-acyltransferase",
    "2.3.1.14\tGlutamine N-phenylacetyltransferase",
    "2.3.1.15\tGlycerol-3-phosphate 1-O-acyltransferase",
    "2.3.1.16\tAcetyl-CoA C-acyltransferase",
    "2.3.1.17\tAspartate N-acetyltransferase",
    "2.3.1.18\tGalactoside O-acetyltransferase",
    "2.3.1.19\tPhosphate butyryltransferase",
    "2.3.1.20\tDiacylglycerol O-acyltransferase",
    "2.3.1.21\tCarnitine O-palmitoyltransferase",
    "2.3.1.22\t2-acylglycerol O-acyltransferase",
    "2.3.1.23\t1-acylglycerophosphocholine O-acyltransferase",
    "2.3.1.24\tSphingosine N-acyltransferase",
    "2.3.1.25\tPlasmalogen synthase",
    "2.3.1.26\tSterol O-acyltransferase",
    "2.3.1.27\tCortisol O-acetyltransferase",
    "2.3.1.28\tChloramphenicol O-acetyltransferase",
    "2.3.1.29\tGlycine C-acetyltransferase",
    "2.3.1.30\tSerine O-acetyltransferase",
    "2.3.1.31\tHomoserine O-acetyltransferase",
    "2.3.1.32\tLysine N-acetyltransferase",
    "2.3.1.33\tHistidine N-acetyltransferase",
    "2.3.1.34\tD-tryptophan N-acetyltransferase",
    "2.3.1.35\tGlutamate N-acetyltransferase",
    "2.3.1.36\tD-amino-acid N-acetyltransferase",
    "2.3.1.37\t5-aminolevulinate synthase",
    "2.3.1.38\t[Acyl-carrier-protein] S-acetyltransferase",
    "2.3.1.39\t[Acyl-carrier-protein] S-malonyltransferase",
    "2.3.1.40\tAcyl-[acyl-carrier-protein]--phospholipid O-acyltransferase",
    "2.3.1.41\tBeta-ketoacyl-[acyl-carrier-protein] synthase I",
    "2.3.1.42\tGlycerone-phosphate O-acyltransferase",
    "2.3.1.43\tPhosphatidylcholine--sterol O-acyltransferase",
    "2.3.1.44\tN-acetylneuraminate 4-O-acetyltransferase",
    "2.3.1.45\tN-acetylneuraminate 7-O(or 9-O)-acetyltransferase",
    "2.3.1.46\tHomoserine O-succinyltransferase",
    "2.3.1.47\t8-amino-7-oxononanoate synthase",
    "2.3.1.48\tHistone acetyltransferase",
    "2.3.1.49\tDeacetyl-[citrate-(pro-3S)-lyase] S-acetyltransferase",
    "2.3.1.50\tSerine C-palmitoyltransferase",
    "2.3.1.51\t1-acylglycerol-3-phosphate O-acyltransferase",
    "2.3.1.52\t2-acylglycerol-3-phosphate O-acyltransferase",
    "2.3.1.53\tPhenylalanine N-acetyltransferase",
    "2.3.1.54\tFormate C-acetyltransferase",
    "2.3.1.56\tAromatic-hydroxylamine O-acetyltransferase",
    "2.3.1.57\tDiamine N-acetyltransferase",
    "2.3.1.58\t2,3-diaminopropionate N-oxalyltransferase",
    "2.3.1.59\tGentamicin 2'-N-acetyltransferase",
    "2.3.1.60\tGentamicin 3-N-acetyltransferase",
    "2.3.1.61\tDihydrolipoyllysine-residue succinyltransferase",
    "2.3.1.62\t2-acylglycerophosphocholine O-acyltransferase",
    "2.3.1.63\t1-alkylglycerophosphocholine O-acyltransferase",
    "2.3.1.64\tAgmatine N(4)-coumaroyltransferase",
    "2.3.1.65\tBile acid-CoA:amino acid N-acyltransferase",
    "2.3.1.66\tLeucine N-acetyltransferase",
    "2.3.1.67\t1-alkylglycerophosphocholine O-acetyltransferase",
    "2.3.1.68\tGlutamine N-acyltransferase",
    "2.3.1.69\tMonoterpenol O-acetyltransferase",
    "2.3.1.71\tGlycine N-benzoyltransferase",
    "2.3.1.72\tIndoleacetylglucose--inositol O-acyltransferase",
    "2.3.1.73\tDiacylglycerol--sterol O-acyltransferase",
    "2.3.1.74\tChalcone synthase",
    "2.3.1.75\tLong-chain-alcohol O-fatty-acyltransferase",
    "2.3.1.76\tRetinol O-fatty-acyltransferase",
    "2.3.1.77\tTriacylglycerol--sterol O-acyltransferase",
    "2.3.1.78\tHeparan-alpha-glucosaminide N-acetyltransferase",
    "2.3.1.79\tMaltose O-acetyltransferase",
    "2.3.1.80\tCysteine-S-conjugate N-acetyltransferase",
    "2.3.1.81\tAminoglycoside N(3)-acetyltransferase",
    "2.3.1.82\tAminoglycoside 6'-N-acetyltransferase",
    "2.3.1.83\tPhosphatidylcholine--dolichol O-acyltransferase",
    "2.3.1.84\tAlcohol O-acetyltransferase",
    "2.3.1.85\tFatty-acid synthase system",
    "2.3.1.86\tFatty-acyl-CoA synthase system",
    "2.3.1.87\tAralkylamine N-acetyltransferase",
    "2.3.1.89\tTetrahydrodipicolinate N-acetyltransferase",
    "2.3.1.90\tBeta-glucogallin O-galloyltransferase",
    "2.3.1.91\tSinapoylglucose--choline O-sinapoyltransferase",
    "2.3.1.92\tSinapoylglucose--malate O-sinapoyltransferase",
    "2.3.1.93\t13-hydroxylupanine O-tigloyltransferase",
    "2.3.1.94\t6-deoxyerythronolide-B synthase",
    "2.3.1.95\tTrihydroxystilbene synthase",
    "2.3.1.97\tGlycylpeptide N-tetradecanoyltransferase",
    "2.3.1.98\tChlorogenate--glucarate O-hydroxycinnamoyltransferase",
    "2.3.1.99\tQuinate O-hydroxycinnamoyltransferase",
    "2.3.1.100\t[Myelin-proteolipid] O-palmitoyltransferase",
    "2.3.1.101\tFormylmethanofuran--tetrahydromethanopterin N-formyltransferase",
    "2.3.1.102\tN(6)-hydroxylysine O-acetyltransferase",
    "2.3.1.103\tSinapoylglucose--sinapoylglucose O-sinapoyltransferase",
    "2.3.1.105\tAlkylglycerophosphate 2-O-acetyltransferase",
    "2.3.1.106\tTartronate O-hydroxycinnamoyltransferase",
    "2.3.1.107\tDeacetylvindoline O-acetyltransferase",
    "2.3.1.108\tAlpha-tubulin N-acetyltransferase",
    "2.3.1.109\tArginine N-succinyltransferase",
    "2.3.1.110\tTyramine N-feruloyltransferase",
    "2.3.1.111\tMycocerosate synthase",
    "2.3.1.112\tD-tryptophan N-malonyltransferase",
    "2.3.1.113\tAnthranilate N-malonyltransferase",
    "2.3.1.114\t3,4-dichloroaniline N-malonyltransferase",
    "2.3.1.115\tIsoflavone-7-O-beta-glucoside 6''-O-malonyltransferase",
    "2.3.1.116\tFlavonol-3-O-beta-glucoside O-malonyltransferase",
    "2.3.1.117\t2,3,4,5-tetrahydropyridine-2,6-dicarboxylate N-succinyltransferase",
    "2.3.1.118\tN-hydroxyarylamine O-acetyltransferase",
    "2.3.1.121\t1-alkenylglycerophosphoethanolamine O-acyltransferase",
    "2.3.1.122\tTrehalose O-mycolyltransferase",
    "2.3.1.123\tDolichol O-acyltransferase",
    "2.3.1.125\t1-alkyl-2-acetylglycerol O-acyltransferase",
    "2.3.1.126\tIsocitrate O-dihydroxycinnamoyltransferase",
    "2.3.1.127\tOrnithine N-benzoyltransferase",
    "2.3.1.129\tAcyl-[acyl-carrier-protein]--UDP-N-acetylglucosamine O-acyltransferase",
    "2.3.1.130\tGalactarate O-hydroxycinnamoyltransferase",
    "2.3.1.131\tGlucarate O-hydroxycinnamoyltransferase",
    "2.3.1.132\tGlucarolactone O-hydroxycinnamoyltransferase",
    "2.3.1.133\tShikimate O-hydroxycinnamoyltransferase",
    "2.3.1.134\tGalactolipid O-acyltransferase",
    "2.3.1.135\tPhosphatidylcholine--retinol O-acyltransferase",
    "2.3.1.136\tPolysialic-acid O-acetyltransferase",
    "2.3.1.137\tCarnitine O-octanoyltransferase",
    "2.3.1.138\tPutrescine N-hydroxycinnamoyltransferase",
    "2.3.1.139\tEcdysone O-acyltransferase",
    "2.3.1.140\tRosmarinate synthase",
    "2.3.1.141\tGalactosylacylglycerol O-acyltransferase",
    "2.3.1.142\tGlycoprotein O-fatty-acyltransferase",
    "2.3.1.143\tBeta-glucogallin--tetrakisgalloylglucose O-galloyltransferase",
    "2.3.1.144\tAnthranilate N-benzoyltransferase",
    "2.3.1.145\tPiperidine N-piperoyltransferase",
    "2.3.1.146\tPinosylvin synthase",
    "2.3.1.147\tGlycerophospholipid arachidonoyl-transferase (CoA-independent)",
    "2.3.1.148\tGlycerophospholipid acyltransferase (CoA-dependent)",
    "2.3.1.149\tPlatelet-activating factor acetyltransferase",
    "2.3.1.150\tSalutaridinol 7-O-acetyltransferase",
    "2.3.1.151\t2,3',4,6-tetrahydroxybenzophenone synthase",
    "2.3.1.152\tAlcohol O-cinnamoyltransferase",
    "2.3.1.153\tAnthocyanin 5-(6'''-hydroxycinnamoyltransferase)",
    "2.3.1.155\tAcetyl-CoA C-myristoyltransferase",
    "2.3.1.156\tPhloroisovalerophenone synthase",
    "2.3.1.157\tGlucosamine-1-phosphate N-acetyltransferase",
    "2.3.1.158\tPhospholipid:diacylglycerol acyltransferase",
    "2.3.1.159\tAcridone synthase",
    "2.3.1.160\tVinorine synthase",
    "2.3.1.161\tLovastatin nonaketide synthase",
    "2.3.1.162\tTaxadien-5-alpha-ol O-acetyltransferase",
    "2.3.1.163\t10-hydroxytaxane O-acetyltransferase",
    "2.3.1.164\tIsopenicillin-N N-acyltransferase",
    "2.3.1.165\t6-methylsalicylic acid synthase",
    "2.3.1.166\t2-alpha-hydroxytaxane 2-O-benzoyltransferase",
    "2.3.1.167\t10-deacetylbaccatin III 10-O-acetyltransferase",
    "2.3.1.168\tDihydrolipoyllysine-residue (2-methylpropanoyl)transferase",
    "2.3.1.169\tCO-methylating acetyl-CoA synthase",
    "2.3.1.170\t6'-deoxychalcone synthase",
    "2.3.1.171\tAnthocyanin 6''-O-malonyltransferase",
    "2.3.1.172\tAnthocyanin 5-O-glucoside 6'''-O-malonyltransferase",
    "2.3.1.173\tFlavonol-3-O-triglucoside O-coumaroyltransferase",
    "2.3.1.174\t3-oxoadipyl-CoA thiolase",
    "2.3.1.175\tDeacetylcephalosporin-C acetyltransferase",
    "2.3.1.176\tPropanoyl-CoA C-acyltransferase",
    "2.3.1.177\t3,5-dihydroxybiphenyl synthase",
    "2.3.1.178\tDiaminobutyrate acetyltransferase",
    "2.3.1.179\tBeta-ketoacyl-[acyl-carrier-protein] synthase II",
    "2.3.1.180\tBeta-ketoacyl-[acyl-carrier-protein] synthase III",
    "2.3.1.181\tLipoyl(octanoyl) transferase",
    "2.3.1.182\t(R)-citramalate synthase",
    "2.3.1.183\tPhosphinothricin acetyltransferase",
    "2.3.1.184\tAcyl-homoserine-lactone synthase",
    "2.3.1.185\tTropine acyltransferase",
    "2.3.1.186\tPseudotropine acyltransferase",
    "2.3.1.187\tAcetyl-S-ACP:malonate ACP transferase",
    "2.3.1.188\tOmega-hydroxypalmitate O-feruloyl transferase",
    "2.3.1.189\tMycothiol synthase",
    "2.3.1.190\tAcetoin dehydrogenase system",
    "2.3.1.191\tUDP-3-O-(3-hydroxymyristoyl)glucosamine N-acyltransferase",
    "2.3.1.192\tGlycine N-phenylacetyltransferase",
    "2.3.1.193\ttRNA(Met) cytidine acetyltransferase",
    "2.3.1.194\tAcetoacetyl-CoA synthase",
    "2.3.1.195\t(Z)-3-hexen-1-ol acetyltransferase",
    "2.3.1.196\tBenzyl alcohol O-benzoyltransferase",
    "2.3.1.197\tdTDP-3-amino-3,6-dideoxy-alpha-D-galactopyranose 3-N-acetyltransferase",
    "2.3.1.198\tGlycerol-3-phosphate 2-O-acyltransferase",
    "2.3.1.199\tVery-long-chain 3-oxoacyl-CoA synthase",
    "2.3.1.200\tLipoyl amidotransferase",
    "2.3.1.201\tUDP-2-acetamido-3-amino-2,3-dideoxy-glucuronate N-acetyltransferase",
    "2.3.1.202\tUDP-4-amino-4,6-dideoxy-N-acetyl-beta-L-altrosamine N-acetyltransferase",
    "2.3.1.203\tUDP-N-acetylbacillosamine N-acetyltransferase",
    "2.3.1.204\tOctanoyl-[GcvH]:protein N-octanoyltransferase",
    "2.3.1.205\tFumigaclavine B O-acetyltransferase",
    "2.3.1.206\t3,5,7-trioxododecanoyl-CoA synthase",
    "2.3.1.207\tBeta-ketodecanoyl-[acyl-carrier-protein] synthase",
    "2.3.1.208\t4-hydroxycoumarin synthase",
    "2.3.1.209\tdTDP-4-amino-4,6-dideoxy-D-glucose acyltransferase",
    "2.3.1.210\tdTDP-4-amino-4,6-dideoxy-D-galactose acyltransferase",
    "2.3.1.211\tBisdemethoxycurcumin synthase",
    "2.3.1.212\tBenzalacetone synthase",
    "2.3.1.213\tCyanidin 3-O-(6-O-glucosyl-2-O-xylosylgalactoside) 6'''-O-hydroxycinnamoyltransferase",
    "2.3.1.214\tPelargonidin 3-O-(6-caffeoylglucoside) 5-O-(6-O-malonylglucoside) 4'''-malonyltransferase",
    "2.3.1.215\tAnthocyanidin 3-O-glucoside 6''-O-acyltransferase",
    "2.3.1.216\t5,7-dihydroxy-2-methylchromone synthase",
    "2.3.1.217\tCurcumin synthase",
    "2.3.1.218\tPhenylpropanoylacetyl-CoA synthase",
    "2.3.1.219\tDemethoxycurcumin synthase",
    "2.3.1.220\t2,4,6-trihydroxybenzophenone synthase",
    "2.3.1.221\tNoranthrone synthase",
    "2.3.1.222\tPhosphate propanoyltransferase",
    "2.3.1.223\t3-oxo-5,6-didehydrosuberyl-CoA thiolase",
    "2.3.1.224\tAcetyl-CoA-benzylalcohol acetyltransferase",
    "2.3.1.225\tProtein S-acyltransferase",
    "2.3.1.226\tCarboxymethylproline synthase",
    "2.3.1.227\tGDP-perosamine N-acetyltransferase",
    "2.3.1.228\tIsovaleryl-homoserine lactone synthase",
    "2.3.1.229\t4-coumaroyl-homoserine lactone synthase",
    "2.3.1.230\t2-heptyl-4(1H)-quinolone synthase",
    "2.3.1.231\ttRNA(Phe) (7-(3-amino-3-(methoxycarbonyl)propyl)wyosine(37)-N)-methoxycarbonyltransferase",
    "2.3.1.232\tMethanol O-anthraniloyltransferase",
    "2.3.1.233\t1,3,6,8-tetrahydroxynaphthalene synthase",
    "2.3.1.234\tN(6)-L-threonylcarbamoyladenine synthase",
    "2.3.1.235\tTetracenomycin F2 synthase",
    "2.3.1.236\t5-methylnaphthoic acid synthase",
    "2.3.1.237\tNeocarzinostatin naphthoate synthase",
    "2.3.1.238\tMonacolin J acid methylbutanoate transferase",
    "2.3.1.239\t10-deoxymethynolide syntase",
    "2.3.1.240\tNarbonolide synthase",
    "2.3.1.241\tKdo(2)-lipid IV(A) lauroyltransferase",
    "2.3.1.242\tKdo(2)-lipid IV(A) palmitoleoyltransferase",
    "2.3.1.243\tLauroyl-Kdo(2)-lipid IV(A) myristoyltransferase",
    "2.3.1.244\t2-methylbutanoate polyketide synthase",
    "2.3.1.245\t3-hydroxy-5-phosphooxypentane-2,4-dione thiolase",
    "2.3.1.246\t3,5-dihydroxyphenylacetyl-CoA synthase",
    "2.3.1.247\t3-keto-5-aminohexanoate cleavage enzyme",
    "2.3.1.248\tSpermidine disinapoyl transferase",
    "2.3.1.249\tSpermidine dicoumaroyl transferase",
    "2.3.1.250\t[Wnt protein] O-palmitoleoyl transferase",
    "2.3.1.251\tLipid IV(A) palmitoyltransferase",
    "2.3.1.252\tMycolipanoate synthase",
    "2.3.1.253\tPhloroglucinol synthase",
    "2.3.1.254\tN-terminal methionine N(alpha)-acetyltransferase NatB",
    "2.3.1.255\tN-terminal amino-acid N(alpha)-acetyltransferase NatA",
    "2.3.1.256\tN-terminal methionine N(alpha)-acetyltransferase NatC",
    "2.3.1.257\tN-terminal L-serine N(alpha)-acetyltransferase NatD",
    "2.3.1.258\tN-terminal methionine N(alpha)-acetyltransferase NatE",
    "2.3.1.259\tN-terminal methionine N(alpha)-acetyltransferase NatF",
    "2.3.1.260\tTetracycline polyketide synthase",
    "2.3.1.261\t(4-hydroxyphenyl)alkanoate synthase",
    "2.3.1.262\tAnthraniloyl-CoA anthraniloyltransferase",
    "2.3.1.263\t2-amino-4-oxopentanoate thiolase",
    "2.3.1.264\tBeta-lysine N(6)-acetyltransferase",
    "2.3.1.265\tPhosphatidylinositol dimannoside acyltransferase",
    "2.3.1.266\t[Ribosomal protein S18]-alanine N-acetyltransferase",
    "2.3.1.267\t[Ribosomal protein S5]-alanine N-acetyltransferase",
    "2.3.1.268\tEthanol O-acetyltransferase",
    "2.3.1.269\tApolipoprotein N-acyltransferase",
    "2.3.1.270\tLyso-ornithine lipid O-acyltransferase",
    "2.3.1.271\tL-glutamate-5-semialdehyde N-acetyltransferase",
    "2.3.1.272\t2-acetylphloroglucinol acetyltransferase",
    "2.3.1.273\tDiglucosylglycerate octanoyltransferase",
    "2.3.1.274\tPhosphate acyltransferase",
    "2.3.1.275\tAcyl phosphate:glycerol-3-phosphate acyltransferase",
    "2.3.1.276\tGalactosamine-1-phosphate N-acetyltransferase",
    "2.3.1.277\t2-oxo-3-(phosphooxy)propyl 3-oxoalkanoate synthase",
    "2.3.1.278\tMycolipenoyl-CoA--2-(long-chain-fatty acyl)-trehalose mycolipenoyltransferase",
    "2.3.1.279\tLong-chain-acyl-CoA--trehalose acyltransferase",
    "2.3.1.280\t(Aminoalkyl)phosphonate N-acetyltransferase",
    "2.3.1.281\tCoelimycin P1 polyketide synthase",
    "2.3.1.282\tPhenolphthiocerol/phthiocerol/phthiodiolone dimycocerosyl transferase",
    "2.3.1.283\t2'-acyl-2-O-sulfo-trehalose (hydroxy)phthioceranyltransferase",
    "2.3.1.284\t3'-(hydroxy)phthioceranyl-2'-palmitoyl(stearoyl)-2-O-sulfo-trehalose (hydroxy)phthioceranyltransferase",
    "2.3.1.285\t(13S,14R)-1,13-dihydroxy-N-methylcanadine 13-O-acetyltransferase",
    "2.3.1.286\tProtein acetyllysine N-acetyltransferase",
    "2.3.1.287\tPhthioceranic/hydroxyphthioceranic acid synthase",
    "2.3.1.288\t2-O-sulfo trehalose long-chain-acyltransferase",
    "2.3.1.289\tAureothin polyketide synthase system",
    "2.3.1.290\tSpectinabilin polyketide synthase system",
    "2.3.1.291\tSphingoid base N-palmitoyltransferase",
    "2.3.1.292\t(Phenol)carboxyphthiodiolenone synthase",
    "2.3.1.293\tMeromycolic acid 3-oxoacyl-(acyl carrier protein) synthase I",
    "2.3.1.294\tMeromycolic acid 3-oxoacyl-(acyl carrier protein) synthase II",
    "2.3.1.295\tMycoketide-CoA synthase",
    "2.3.1.296\tOmega-hydroxyceramide transacylase",
    "2.3.1.297\tVery-long-chain ceramide synthase",
    "2.3.1.298\tUltra-long-chain ceramide synthase",
    "2.3.1.299\tSphingoid base N-stearoyltransferase",
    "2.3.1.300\tBranched-chain beta-ketoacyl-[acyl-carrier-protein] synthase",
    "2.3.1.301\tMycobacterial beta-ketoacyl-[acyl carrier protein] synthase III",
    "2.3.1.302\tHydroxycinnamoyl-CoA:5-hydroxyanthranilate N-hydroxycinnamoyltransferase",
    "2.3.1.303\tAlpha-L-Rha-(1->2)-alpha-D-Man-(1->2)-alpha-D-Man-(1->3)-alpha-D-Gal-PP-Und 2(IV)-O-acetyltransferase",
    "2.3.1.304\tPoly((R)-3-hydroxyalkanoate) polymerase",
    "2.3.1.n4\t1-acyl-sn-glycerol-3-phosphate acyltransferase",
    "2.3.1.n5\tGlycerol-3-phosphate acyltransferase (acyl-[acyl-carrier-protein]-transferring)",
    "2.3.1.n6\t1-acylglycerophosphoserine O-acyltransferase",
    "2.3.1.n7\t1-acylglycerophosphoethanolamine O-acyltransferase",
    "2.3.1.n12\tSinapoyl-beta-D-glucose:anthocyanin sinapoyltransferase",
    "2.3.2.1\tD-glutamyltransferase",
    "2.3.2.2\tGamma-glutamyltransferase",
    "2.3.2.3\tLysyltransferase",
    "2.3.2.5\tGlutaminyl-peptide cyclotransferase",
    "2.3.2.6\tLysine/arginine leucyltransferase",
    "2.3.2.7\tAspartyltransferase",
    "2.3.2.8\tArginyltransferase",
    "2.3.2.9\tAgaritine gamma-glutamyltransferase",
    "2.3.2.10\tUDP-N-acetylmuramoylpentapeptide-lysine N(6)-alanyltransferase",
    "2.3.2.11\tAlanylphosphatidylglycerol synthase",
    "2.3.2.12\tPeptidyltransferase",
    "2.3.2.13\tProtein-glutamine gamma-glutamyltransferase",
    "2.3.2.14\tD-alanine gamma-glutamyltransferase",
    "2.3.2.15\tGlutathione gamma-glutamylcysteinyltransferase",
    "2.3.2.16\tLipid II:glycine glycyltransferase",
    "2.3.2.17\tN-acetylmuramoyl-L-alanyl-D-glutamyl-L-lysyl-(N(6)-glycyl)-D-alanyl-D-alanine-diphosphoundecaprenyl-N-acetylglucosamine:glycine glycyltransferase",
    "2.3.2.18\tN-acetylmuramoyl-L-alanyl-D-glutamyl-L-lysyl-(N(6)-triglycine)-D-alanyl-D-alanine-diphosphoundecaprenyl-N-acetylglucosamine:glycine glycyltransferase",
    "2.3.2.19\tRibostamycin:4-(gamma-L-glutamylamino)-(S)-2-hydroxybutanoyl-[BtrI acyl-carrier protein] 4-(gamma-L-glutamylamino)-(S)-2-hydroxybutanoate transferase",
    "2.3.2.20\tCyclo(L-leucyl-L-phenylalanyl) synthase",
    "2.3.2.21\tCyclo(L-tyrosyl-L-tyrosyl) synthase",
    "2.3.2.22\tCyclo(L-leucyl-L-leucyl) synthase",
    "2.3.2.23\tE2 ubiquitin-conjugating enzyme",
    "2.3.2.24\t(E3-independent) E2 ubiquitin-conjugating enzyme",
    "2.3.2.25\tN-terminal E2 ubiquitin-conjugating enzyme",
    "2.3.2.26\tHECT-type E3 ubiquitin transferase",
    "2.3.2.27\tRING-type E3 ubiquitin transferase",
    "2.3.2.28\tL-allo-isoleucyltransferase",
    "2.3.2.29\tAspartate/glutamate leucyltransferase",
    "2.3.2.30\tL-ornithine N(alpha)-acyltransferase",
    "2.3.2.31\tRBR-type E3 ubiquitin transferase",
    "2.3.2.32\tCullin-RING-type E3 NEDD8 transferase",
    "2.3.2.33\tRCR-type E3 ubiquitin transferase",
    "2.3.2.34\tE2 NEDD8-conjugating enzyme",
    "2.3.2.35\tCapsaicin synthase",
    "2.3.2.36\tRING-type E3 ubiquitin transferase (cysteine targeting)",
    "2.3.3.1\tCitrate (Si)-synthase",
    "2.3.3.2\tDecylcitrate synthase",
    "2.3.3.3\tCitrate (Re)-synthase",
    "2.3.3.4\tDecylhomocitrate synthase",
    "2.3.3.5\t2-methylcitrate synthase",
    "2.3.3.6\t2-ethylmalate synthase",
    "2.3.3.7\t3-ethylmalate synthase",
    "2.3.3.8\tATP citrate synthase",
    "2.3.3.9\tMalate synthase",
    "2.3.3.10\tHydroxymethylglutaryl-CoA synthase",
    "2.3.3.11\t2-hydroxyglutarate synthase",
    "2.3.3.12\t3-propylmalate synthase",
    "2.3.3.13\t2-isopropylmalate synthase",
    "2.3.3.14\tHomocitrate synthase",
    "2.3.3.15\tSulfoacetaldehyde acetyltransferase",
    "2.3.3.16\tCitrate synthase (unknown stereospecificity)",
    "2.3.3.17\tMethylthioalkylmalate synthase",
    "2.3.3.18\t2-phosphinomethylmalate synthase",
    "2.3.3.19\t2-phosphonomethylmalate synthase",
    "2.3.3.20\tAcyl-CoA:acyl-CoA alkyltransferase",
    "2.4.1.1\tGlycogen phosphorylase",
    "2.4.1.2\tDextrin dextranase",
    "2.4.1.4\tAmylosucrase",
    "2.4.1.5\tDextransucrase",
    "2.4.1.7\tSucrose phosphorylase",
    "2.4.1.8\tMaltose phosphorylase",
    "2.4.1.9\tInulosucrase",
    "2.4.1.10\tLevansucrase",
    "2.4.1.11\tGlycogen(starch) synthase",
    "2.4.1.12\tCellulose synthase (UDP-forming)",
    "2.4.1.13\tSucrose synthase",
    "2.4.1.14\tSucrose-phosphate synthase",
    "2.4.1.15\tAlpha,alpha-trehalose-phosphate synthase (UDP-forming)",
    "2.4.1.16\tChitin synthase",
    "2.4.1.17\tGlucuronosyltransferase",
    "2.4.1.18\t1,4-alpha-glucan branching enzyme",
    "2.4.1.19\tCyclomaltodextrin glucanotransferase",
    "2.4.1.20\tCellobiose phosphorylase",
    "2.4.1.21\tStarch synthase",
    "2.4.1.22\tLactose synthase",
    "2.4.1.23\tSphingosine beta-galactosyltransferase",
    "2.4.1.24\t1,4-alpha-glucan 6-alpha-glucosyltransferase",
    "2.4.1.25\t4-alpha-glucanotransferase",
    "2.4.1.26\tDNA alpha-glucosyltransferase",
    "2.4.1.27\tDNA beta-glucosyltransferase",
    "2.4.1.28\tGlucosyl-DNA beta-glucosyltransferase",
    "2.4.1.29\tCellulose synthase (GDP-forming)",
    "2.4.1.30\t1,3-beta-oligoglucan phosphorylase",
    "2.4.1.31\tLaminaribiose phosphorylase",
    "2.4.1.32\tGlucomannan 4-beta-mannosyltransferase",
    "2.4.1.33\tMannuronan synthase",
    "2.4.1.34\t1,3-beta-glucan synthase",
    "2.4.1.35\tPhenol beta-glucosyltransferase",
    "2.4.1.36\tAlpha,alpha-trehalose-phosphate synthase (GDP-forming)",
    "2.4.1.37\tFucosylgalactoside 3-alpha-galactosyltransferase",
    "2.4.1.38\tBeta-N-acetylglucosaminylglycopeptide beta-1,4-galactosyltransferase",
    "2.4.1.39\tSteroid N-acetylglucosaminyltransferase",
    "2.4.1.40\tGlycoprotein-fucosylgalactoside alpha-N-acetylgalactosaminyltransferase",
    "2.4.1.41\tPolypeptide N-acetylgalactosaminyltransferase",
    "2.4.1.43\tPolygalacturonate 4-alpha-galacturonosyltransferase",
    "2.4.1.44\tLipopolysaccharide 3-alpha-galactosyltransferase",
    "2.4.1.46\tMonogalactosyldiacylglycerol synthase",
    "2.4.1.47\tN-acylsphingosine galactosyltransferase",
    "2.4.1.48\tHeteroglycan alpha-mannosyltransferase",
    "2.4.1.49\tCellodextrin phosphorylase",
    "2.4.1.50\tProcollagen galactosyltransferase",
    "2.4.1.52\tPoly(glycerol-phosphate) alpha-glucosyltransferase",
    "2.4.1.53\tPoly(ribitol-phosphate) beta-glucosyltransferase",
    "2.4.1.54\tUndecaprenyl-phosphate mannosyltransferase",
    "2.4.1.56\tLipopolysaccharide N-acetylglucosaminyltransferase",
    "2.4.1.58\tLipopolysaccharide glucosyltransferase I",
    "2.4.1.60\tCDP-abequose:alpha-D-Man-(1->4)-alpha-L-Rha-(1->3)-alpha-D-Gal-PP-Und alpha-1,3-abequosyltransferase",
    "2.4.1.62\tGanglioside galactosyltransferase",
    "2.4.1.63\tLinamarin synthase",
    "2.4.1.64\tAlpha,alpha-trehalose phosphorylase",
    "2.4.1.65\t3-galactosyl-N-acetylglucosaminide 4-alpha-L-fucosyltransferase",
    "2.4.1.66\tProcollagen glucosyltransferase",
    "2.4.1.67\tGalactinol--raffinose galactosyltransferase",
    "2.4.1.68\tGlycoprotein 6-alpha-L-fucosyltransferase",
    "2.4.1.69\tType 1 galactoside alpha-(1,2)-fucosyltransferase",
    "2.4.1.70\tPoly(ribitol-phosphate) alpha-N-acetylglucosaminyltransferase",
    "2.4.1.71\tArylamine glucosyltransferase",
    "2.4.1.73\tLipopolysaccharide glucosyltransferase II",
    "2.4.1.74\tGlycosaminoglycan galactosyltransferase",
    "2.4.1.78\tPhosphopolyprenol glucosyltransferase",
    "2.4.1.79\tGlobotriaosylceramide 3-beta-N-acetylgalactosaminyltransferase",
    "2.4.1.80\tCeramide glucosyltransferase",
    "2.4.1.81\tFlavone 7-O-beta-glucosyltransferase",
    "2.4.1.82\tGalactinol--sucrose galactosyltransferase",
    "2.4.1.83\tDolichyl-phosphate beta-D-mannosyltransferase",
    "2.4.1.85\tCyanohydrin beta-glucosyltransferase",
    "2.4.1.86\tN-acetyl-beta-D-glucosaminide beta-(1,3)-galactosyltransferase",
    "2.4.1.87\tN-acetyllactosaminide 3-alpha-galactosyltransferase",
    "2.4.1.88\tGloboside alpha-N-acetylgalactosaminyltransferase",
    "2.4.1.90\tN-acetyllactosamine synthase",
    "2.4.1.91\tFlavonol 3-O-glucosyltransferase",
    "2.4.1.92\t(N-acetylneuraminyl)-galactosylglucosylceramide N-acetylgalactosaminyltransferase",
    "2.4.1.94\tProtein N-acetylglucosaminyltransferase",
    "2.4.1.96\tsn-glycerol-3-phosphate 1-galactosyltransferase",
    "2.4.1.97\t1,3-beta-D-glucan phosphorylase",
    "2.4.1.99\tSucrose:sucrose fructosyltransferase",
    "2.4.1.100\t2,1-fructan:2,1-fructan 1-fructosyltransferase",
    "2.4.1.101\tAlpha-1,3-mannosyl-glycoprotein 2-beta-N-acetylglucosaminyltransferase",
    "2.4.1.102\tBeta-1,3-galactosyl-O-glycosyl-glycoprotein beta-1,6-N-acetylglucosaminyltransferase",
    "2.4.1.103\tAlizarin 2-beta-glucosyltransferase",
    "2.4.1.104\to-dihydroxycoumarin 7-O-glucosyltransferase",
    "2.4.1.105\tVitexin beta-glucosyltransferase",
    "2.4.1.106\tIsovitexin beta-glucosyltransferase",
    "2.4.1.109\tDolichyl-phosphate-mannose--protein mannosyltransferase",
    "2.4.1.110\ttRNA-queuosine beta-mannosyltransferase",
    "2.4.1.111\tConiferyl-alcohol glucosyltransferase",
    "2.4.1.113\tAlpha-1,4-glucan-protein synthase (ADP-forming)",
    "2.4.1.114\t2-coumarate O-beta-glucosyltransferase",
    "2.4.1.115\tAnthocyanidin 3-O-glucosyltransferase",
    "2.4.1.116\tCyanidin 3-O-rutinoside 5-O-glucosyltransferase",
    "2.4.1.117\tDolichyl-phosphate beta-glucosyltransferase",
    "2.4.1.118\tCytokinin 7-beta-glucosyltransferase",
    "2.4.1.120\tSinapate 1-glucosyltransferase",
    "2.4.1.121\tIndole-3-acetate beta-glucosyltransferase",
    "2.4.1.122\tN-acetylgalactosaminide beta-1,3-galactosyltransferase",
    "2.4.1.123\tInositol 3-alpha-galactosyltransferase",
    "2.4.1.125\tSucrose--1,6-alpha-glucan 3(6)-alpha-glucosyltransferase",
    "2.4.1.126\tHydroxycinnamate 4-beta-glucosyltransferase",
    "2.4.1.127\tMonoterpenol beta-glucosyltransferase",
    "2.4.1.128\tScopoletin glucosyltransferase",
    "2.4.1.129\tPeptidoglycan glycosyltransferase",
    "2.4.1.131\tGDP-Man:Man(3)GlcNAc(2)-PP-dolichol alpha-1,2-mannosyltransferase",
    "2.4.1.132\tGDP-Man:Man(1)GlcNAc(2)-PP-dolichol alpha-1,3-mannosyltransferase",
    "2.4.1.133\tXylosylprotein 4-beta-galactosyltransferase",
    "2.4.1.134\tGalactosylxylosylprotein 3-beta-galactosyltransferase",
    "2.4.1.135\tGalactosylgalactosylxylosylprotein 3-beta-glucuronosyltransferase",
    "2.4.1.136\tGallate 1-beta-glucosyltransferase",
    "2.4.1.137\tsn-glycerol-3-phosphate 2-alpha-galactosyltransferase",
    "2.4.1.138\tMannotetraose 2-alpha-N-acetylglucosaminyltransferase",
    "2.4.1.139\tMaltose synthase",
    "2.4.1.140\tAlternansucrase",
    "2.4.1.141\tN-acetylglucosaminyldiphosphodolichol N-acetylglucosaminyltransferase",
    "2.4.1.142\tChitobiosyldiphosphodolichol beta-mannosyltransferase",
    "2.4.1.143\tAlpha-1,6-mannosyl-glycoprotein 2-beta-N-acetylglucosaminyltransferase",
    "2.4.1.144\tBeta-1,4-mannosyl-glycoprotein 4-beta-N-acetylglucosaminyltransferase",
    "2.4.1.145\tAlpha-1,3-mannosyl-glycoprotein 4-beta-N-acetylglucosaminyltransferase",
    "2.4.1.146\tBeta-1,3-galactosyl-O-glycosyl-glycoprotein beta-1,3-N-acetylglucosaminyltransferase",
    "2.4.1.147\tAcetylgalactosaminyl-O-glycosyl-glycoprotein beta-1,3-N-acetylglucosaminyltransferase",
    "2.4.1.148\tAcetylgalactosaminyl-O-glycosyl-glycoprotein beta-1,6-N-acetylglucosaminyltransferase",
    "2.4.1.149\tN-acetyllactosaminide beta-1,3-N-acetylglucosaminyltransferase",
    "2.4.1.150\tN-acetyllactosaminide beta-1,6-N-acetylglucosaminyltransferase",
    "2.4.1.152\t4-galactosyl-N-acetylglucosaminide 3-alpha-L-fucosyltransferase",
    "2.4.1.153\tUDP-N-acetylglucosamine--dolichyl-phosphate N-acetylglucosaminyltransferase",
    "2.4.1.155\tAlpha-1,6-mannosyl-glycoprotein 6-beta-N-acetylglucosaminyltransferase",
    "2.4.1.156\tIndolylacetyl-myo-inositol galactosyltransferase",
    "2.4.1.158\t13-hydroxydocosanoate 13-beta-glucosyltransferase",
    "2.4.1.159\tFlavonol-3-O-glucoside L-rhamnosyltransferase",
    "2.4.1.160\tPyridoxine 5'-O-beta-D-glucosyltransferase",
    "2.4.1.161\tOligosaccharide 4-alpha-D-glucosyltransferase",
    "2.4.1.162\tAldose beta-D-fructosyltransferase",
    "2.4.1.164\tGalactosyl-N-acetylglucosaminylgalactosylglucosyl-ceramide beta-1,6-N-acetylglucosaminyltransferase",
    "2.4.1.165\tN-acetylneuraminylgalactosylglucosylceramide beta-1,4-N-acetylgalactosaminyltransferase",
    "2.4.1.166\tRaffinose--raffinose alpha-galactosyltransferase",
    "2.4.1.167\tSucrose 6(F)-alpha-galactosyltransferase",
    "2.4.1.168\tXyloglucan 4-glucosyltransferase",
    "2.4.1.170\tIsoflavone 7-O-glucosyltransferase",
    "2.4.1.171\tMethyl-ONN-azoxymethanol beta-D-glucosyltransferase",
    "2.4.1.172\tSalicyl-alcohol beta-D-glucosyltransferase",
    "2.4.1.173\tSterol 3-beta-glucosyltransferase",
    "2.4.1.174\tGlucuronylgalactosylproteoglycan 4-beta-N-acetylgalactosaminyltransferase",
    "2.4.1.175\tGlucuronosyl-N-acetylgalactosaminyl-proteoglycan 4-beta-N-acetylgalactosaminyltransferase",
    "2.4.1.176\tGibberellin beta-D-glucosyltransferase",
    "2.4.1.177\tCinnamate beta-D-glucosyltransferase",
    "2.4.1.178\tHydroxymandelonitrile glucosyltransferase",
    "2.4.1.179\tLactosylceramide beta-1,3-galactosyltransferase",
    "2.4.1.180\tLipopolysaccharide N-acetylmannosaminouronosyltransferase",
    "2.4.1.181\tHydroxyanthraquinone glucosyltransferase",
    "2.4.1.182\tLipid-A-disaccharide synthase",
    "2.4.1.183\tAlpha-1,3-glucan synthase",
    "2.4.1.184\tGalactolipid galactosyltransferase",
    "2.4.1.185\tFlavanone 7-O-beta-glucosyltransferase",
    "2.4.1.186\tGlycogenin glucosyltransferase",
    "2.4.1.187\tN-acetylglucosaminyldiphosphoundecaprenol N-acetyl-beta-D-mannosaminyltransferase",
    "2.4.1.188\tN-acetylglucosaminyldiphosphoundecaprenol glucosyltransferase",
    "2.4.1.189\tLuteolin 7-O-glucuronosyltransferase",
    "2.4.1.190\tLuteolin-7-O-glucuronide 2''-O-glucuronosyltransferase",
    "2.4.1.191\tLuteolin-7-O-diglucuronide 4'-O-glucuronosyltransferase",
    "2.4.1.192\tNuatigenin 3-beta-glucosyltransferase",
    "2.4.1.193\tSarsapogenin 3-beta-glucosyltransferase",
    "2.4.1.194\t4-hydroxybenzoate 4-O-beta-D-glucosyltransferase",
    "2.4.1.195\tN-hydroxythioamide S-beta-glucosyltransferase",
    "2.4.1.196\tNicotinate glucosyltransferase",
    "2.4.1.197\tHigh-mannose-oligosaccharide beta-1,4-N-acetylglucosaminyltransferase",
    "2.4.1.198\tPhosphatidylinositol N-acetylglucosaminyltransferase",
    "2.4.1.199\tBeta-mannosylphosphodecaprenol--mannooligosaccharide 6-mannosyltransferase",
    "2.4.1.201\tAlpha-1,6-mannosyl-glycoprotein 4-beta-N-acetylglucosaminyltransferase",
    "2.4.1.202\t2,4-dihydroxy-7-methoxy-2H-1,4-benzoxazin-3(4H)-one 2-D-glucosyltransferase",
    "2.4.1.203\tTrans-zeatin O-beta-D-glucosyltransferase",
    "2.4.1.205\tGalactogen 6-beta-galactosyltransferase",
    "2.4.1.206\tLactosylceramide 1,3-N-acetyl-beta-D-glucosaminyltransferase",
    "2.4.1.207\tXyloglucan:xyloglucosyl transferase",
    "2.4.1.208\tDiglucosyl diacylglycerol synthase (1,2-linking)",
    "2.4.1.209\tCis-p-coumarate glucosyltransferase",
    "2.4.1.210\tLimonoid glucosyltransferase",
    "2.4.1.211\t1,3-beta-galactosyl-N-acetylhexosamine phosphorylase",
    "2.4.1.212\tHyaluronan synthase",
    "2.4.1.213\tGlucosylglycerol-phosphate synthase",
    "2.4.1.214\tGlycoprotein 3-alpha-L-fucosyltransferase",
    "2.4.1.215\tCis-zeatin O-beta-D-glucosyltransferase",
    "2.4.1.216\tTrehalose 6-phosphate phosphorylase",
    "2.4.1.217\tMannosyl-3-phosphoglycerate synthase",
    "2.4.1.218\tHydroquinone glucosyltransferase",
    "2.4.1.219\tVomilenine glucosyltransferase",
    "2.4.1.220\tIndoxyl-UDPG glucosyltransferase",
    "2.4.1.221\tPeptide-O-fucosyltransferase",
    "2.4.1.222\tO-fucosylpeptide 3-beta-N-acetylglucosaminyltransferase",
    "2.4.1.223\tGlucuronosyl-galactosyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase",
    "2.4.1.224\tGlucuronosyl-N-acetylglucosaminyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase",
    "2.4.1.225\tN-acetylglucosaminyl-proteoglycan 4-beta-glucuronosyltransferase",
    "2.4.1.226\tN-acetylgalactosaminyl-proteoglycan 3-beta-glucuronosyltransferase",
    "2.4.1.227\tUndecaprenyldiphospho-muramoylpentapeptide beta-N-acetylglucosaminyltransferase",
    "2.4.1.228\tLactosylceramide 4-alpha-galactosyltransferase",
    "2.4.1.229\t[Skp1-protein]-hydroxyproline N-acetylglucosaminyltransferase",
    "2.4.1.230\tKojibiose phosphorylase",
    "2.4.1.231\tAlpha,alpha-trehalose phosphorylase (configuration-retaining)",
    "2.4.1.232\tInitiation-specific alpha-1,6-mannosyltransferase",
    "2.4.1.234\tKaempferol 3-O-galactosyltransferase",
    "2.4.1.236\tFlavanone 7-O-glucoside 2''-O-beta-L-rhamnosyltransferase",
    "2.4.1.237\tFlavonol 7-O-beta-glucosyltransferase",
    "2.4.1.238\tDelphinidin 3,5-di-O-glucoside 3'-O-glucosyltransferase",
    "2.4.1.239\tFlavonol-3-O-glucoside glucosyltransferase",
    "2.4.1.240\tFlavonol-3-O-glycoside glucosyltransferase",
    "2.4.1.241\tDigalactosyldiacylglycerol synthase",
    "2.4.1.242\tNDP-glucose--starch glucosyltransferase",
    "2.4.1.243\t6(G)-fructosyltransferase",
    "2.4.1.244\tN-acetyl-beta-glucosaminyl-glycoprotein 4-beta-N-acetylgalactosaminyltransferase",
    "2.4.1.245\tAlpha,alpha-trehalose synthase",
    "2.4.1.246\tMannosylfructose-phosphate synthase",
    "2.4.1.247\tBeta-D-galactosyl-(1->4)-L-rhamnose phosphorylase",
    "2.4.1.248\tCycloisomaltooligosaccharide glucanotransferase",
    "2.4.1.249\tDelphinidin 3',5'-O-glucosyltransferase",
    "2.4.1.250\tD-inositol-3-phosphate glycosyltransferase",
    "2.4.1.251\tGlcA-beta-(1->2)-D-Man-alpha-(1->3)-D-Glc-beta-(1->4)-D-Glc-alpha-1-diphospho-ditrans,octacis-undecaprenol 4-beta-mannosyltransferase",
    "2.4.1.252\tGDP-mannose:cellobiosyl-diphosphopolyprenol alpha-mannosyltransferase",
    "2.4.1.253\tBaicalein 7-O-glucuronosyltransferase",
    "2.4.1.254\tCyanidin-3-O-glucoside 2''-O-glucuronosyltransferase",
    "2.4.1.255\tProtein O-GlcNAc transferase",
    "2.4.1.256\tDolichyl-P-Glc:Glc(2)Man(9)GlcNAc(2)-PP-dolichol alpha-1,2-glucosyltransferase",
    "2.4.1.257\tGDP-Man:Man(2)GlcNAc(2)-PP-dolichol alpha-1,6-mannosyltransferase",
    "2.4.1.258\tDolichyl-P-Man:Man(5)GlcNAc(2)-PP-dolichol alpha-1,3-mannosyltransferase",
    "2.4.1.259\tDolichyl-P-Man:Man(6)GlcNAc(2)-PP-dolichol alpha-1,2-mannosyltransferase",
    "2.4.1.260\tDolichyl-P-Man:Man(7)GlcNAc(2)-PP-dolichol alpha-1,6-mannosyltransferase",
    "2.4.1.261\tDolichyl-P-Man:Man(8)GlcNAc(2)-PP-dolichol alpha-1,2-mannosyltransferase",
    "2.4.1.262\tSoyasapogenol glucuronosyltransferase",
    "2.4.1.263\tAbscisate beta-glucosyltransferase",
    "2.4.1.264\tD-man-alpha-(1->3)-D-Glc-beta-(1->4)-D-Glc-alpha-1-diphosphoundecaprenol 2-beta-glucuronosyltransferase",
    "2.4.1.265\tDolichyl-P-Glc:Glc(1)Man(9)GlcNAc(2)-PP-dolichol alpha-1,3-glucosyltransferase",
    "2.4.1.266\tGlucosyl-3-phosphoglycerate synthase",
    "2.4.1.267\tDolichyl-P-Glc:Man(9)GlcNAc(2)-PP-dolichol alpha-1,3-glucosyltransferase",
    "2.4.1.268\tGlucosylglycerate synthase",
    "2.4.1.269\tMannosylglycerate synthase",
    "2.4.1.270\tMannosylglucosyl-3-phosphoglycerate synthase",
    "2.4.1.271\tCrocetin glucosyltransferase",
    "2.4.1.272\tSoyasapogenol B glucuronide galactosyltransferase",
    "2.4.1.273\tSoyasaponin III rhamnosyltransferase",
    "2.4.1.274\tGlucosylceramide beta-1,4-galactosyltransferase",
    "2.4.1.275\tNeolactotriaosylceramide beta-1,4-galactosyltransferase",
    "2.4.1.276\tZeaxanthin glucosyltransferase",
    "2.4.1.277\t10-deoxymethynolide desosaminyltransferase",
    "2.4.1.278\t3-alpha-mycarosylerythronolide B desosaminyl transferase",
    "2.4.1.279\tNigerose phosphorylase",
    "2.4.1.280\tN,N'-diacetylchitobiose phosphorylase",
    "2.4.1.281\t4-O-beta-D-mannosyl-D-glucose phosphorylase",
    "2.4.1.282\t3-O-alpha-D-glucosyl-L-rhamnose phosphorylase",
    "2.4.1.283\t2-deoxystreptamine N-acetyl-D-glucosaminyltransferase",
    "2.4.1.284\t2-deoxystreptamine glucosyltransferase",
    "2.4.1.285\tUDP-GlcNAc:ribostamycin N-acetylglucosaminyltransferase",
    "2.4.1.286\tChalcone 4'-O-glucosyltransferase",
    "2.4.1.287\tRhamnopyranosyl-N-acetylglucosaminyl-diphospho-decaprenol beta-1,4/1,5-galactofuranosyltransferase",
    "2.4.1.288\tGalactofuranosylgalactofuranosylrhamnosyl-N-acetylglucosaminyl-diphospho-decaprenol beta-1,5/1,6-galactofuranosyltransferase",
    "2.4.1.289\tN-acetylglucosaminyl-diphospho-decaprenol L-rhamnosyltransferase",
    "2.4.1.290\tN,N'-diacetylbacillosaminyl-diphospho-undecaprenol alpha-1,3-N-acetylgalactosaminyltransferase",
    "2.4.1.291\tN-acetylgalactosamine-N,N'-diacetylbacillosaminyl-diphospho-undecaprenol 4-alpha-N-acetylgalactosaminyltransferase",
    "2.4.1.292\tGalNAc-alpha-(1->4)-GalNAc-alpha-(1->3)-diNAcBac-PP-undecaprenol alpha-1,4-N-acetyl-D-galactosaminyltransferase",
    "2.4.1.293\tGalNAc(5)-diNAcBac-PP-undecaprenol beta-1,3-glucosyltransferase",
    "2.4.1.294\tCyanidin 3-O-galactosyltransferase",
    "2.4.1.295\tAnthocyanin 3-O-sambubioside 5-O-glucosyltransferase",
    "2.4.1.296\tAnthocyanidin 3-O-coumaroylrutinoside 5-O-glucosyltransferase",
    "2.4.1.297\tAnthocyanidin 3-O-glucoside 2''-O-glucosyltransferase",
    "2.4.1.298\tAnthocyanidin 3-O-glucoside 5-O-glucosyltransferase",
    "2.4.1.299\tCyanidin 3-O-glucoside 5-O-glucosyltransferase (acyl-glucose)",
    "2.4.1.300\tCyanidin 3-O-glucoside 7-O-glucosyltransferase (acyl-glucose)",
    "2.4.1.301\t2'-deamino-2'-hydroxyneamine 1-alpha-D-kanosaminyltransferase",
    "2.4.1.302\tL-demethylnoviosyl transferase",
    "2.4.1.303\tUDP-Gal:alpha-D-GlcNAc-diphosphoundecaprenol beta-1,3-galactosyltransferase",
    "2.4.1.304\tUDP-Gal:alpha-D-GlcNAc-diphosphoundecaprenol beta-1,4-galactosyltransferase",
    "2.4.1.305\tUDP-Glc:alpha-D-GlcNAc-glucosaminyl-diphosphoundecaprenol beta-1,3-glucosyltransferase",
    "2.4.1.306\tUDP-GalNAc:alpha-D-GalNAc-diphosphoundecaprenol alpha-1,3-N-acetylgalactosaminyltransferase",
    "2.4.1.308\tGDP-Fuc:beta-D-Gal-1,3-alpha-D-GalNAc-1,3-alpha-GalNAc-diphosphoundecaprenol alpha-1,2-fucosyltransferase",
    "2.4.1.309\tUDP-Gal:alpha-L-Fuc-1,2-beta-Gal-1,3-alpha-GalNAc-1,3-alpha-GalNAc-diphosphoundecaprenol alpha-1,3-galactosyltransferase",
    "2.4.1.310\tVancomycin aglycone glucosyltransferase",
    "2.4.1.311\tdTDP-epi-vancosaminyltransferase",
    "2.4.1.312\tProtein O-mannose beta-1,4-N-acetylglucosaminyltransferase",
    "2.4.1.313\tProtein O-mannose beta-1,3-N-acetylgalactosaminyltransferase",
    "2.4.1.314\tGinsenoside Rd glucosyltransferase",
    "2.4.1.315\tDiglucosyl diacylglycerol synthase (1,6-linking)",
    "2.4.1.316\tTylactone mycaminosyltransferase",
    "2.4.1.317\tO-mycaminosyltylonolide 6-deoxyallosyltransferase",
    "2.4.1.318\tDemethyllactenocin mycarosyltransferase",
    "2.4.1.319\tBeta-1,4-mannooligosaccharide phosphorylase",
    "2.4.1.320\t1,4-beta-mannosyl-N-acetylglucosamine phosphorylase",
    "2.4.1.321\tCellobionic acid phosphorylase",
    "2.4.1.322\tDevancosaminyl-vancomycin vancosaminetransferase",
    "2.4.1.323\t7-deoxyloganetic acid glucosyltransferase",
    "2.4.1.324\t7-deoxyloganetin glucosyltransferase",
    "2.4.1.325\tTDP-N-acetylfucosamine:lipid II N-acetylfucosaminyltransferase",
    "2.4.1.326\tAklavinone 7-L-rhodosaminyltransferase",
    "2.4.1.327\tAclacinomycin-T 2-deoxy-L-fucose transferase",
    "2.4.1.328\tErythronolide mycarosyltransferase",
    "2.4.1.329\tSucrose 6(F)-phosphate phosphorylase",
    "2.4.1.330\tBeta-D-glucosyl crocetin beta-1,6-glucosyltransferase",
    "2.4.1.331\t8-demethyltetracenomycin C L-rhamnosyltransferase",
    "2.4.1.332\t1,2-alpha-glucosylglycerol phosphorylase",
    "2.4.1.333\t1,2-beta-oligoglucan phosphorylase",
    "2.4.1.334\t1,3-alpha-oligoglucan phosphorylase",
    "2.4.1.335\tDolichyl N-acetyl-alpha-D-glucosaminyl phosphate 3-beta-D-2,3-diacetamido-2,3-dideoxy-beta-D-glucuronosyltransferase",
    "2.4.1.336\tMonoglucosyldiacylglycerol synthase",
    "2.4.1.337\t1,2-diacylglycerol 3-alpha-glucosyltransferase",
    "2.4.1.338\tValidoxylamine A glucosyltransferase",
    "2.4.1.339\tBeta-1,2-mannobiose phosphorylase",
    "2.4.1.340\t1,2-beta-oligomannan phosphorylase",
    "2.4.1.341\tAlpha-1,2-colitosyltransferase",
    "2.4.1.342\tAlpha-maltose-1-phosphate synthase",
    "2.4.1.343\tUDP-Gal:alpha-D-GlcNAc-diphosphoundecaprenol alpha-1,3-galactosyltransferase",
    "2.4.1.344\tType 2 galactoside alpha-(1,2)-fucosyltransferase",
    "2.4.1.345\tPhosphatidyl-myo-inositol alpha-mannosyltransferase",
    "2.4.1.346\tPhosphatidyl-myo-inositol dimannoside synthase",
    "2.4.1.347\tAlpha,alpha-trehalose-phosphate synthase (ADP-forming)",
    "2.4.1.348\tN-acetyl-alpha-D-glucosaminyl-diphospho-ditrans,octacis-undecaprenol 3-alpha-mannosyltransferase",
    "2.4.1.349\tMannosyl-N-acetyl-alpha-D-glucosaminyl-diphospho-ditrans,octacis-undecaprenol 3-alpha-mannosyltransferase",
    "2.4.1.350\tMogroside IE synthase",
    "2.4.1.351\tRhamnogalacturonan I rhamnosyltransferase",
    "2.4.1.352\tGlucosylglycerate phosphorylase",
    "2.4.1.353\tSordaricin 6-deoxyaltrosyltransferase",
    "2.4.1.354\t(R)-mandelonitrile beta-glucosyltransferase",
    "2.4.1.355\tPoly(ribitol-phosphate) beta-N-acetylglucosaminyltransferase",
    "2.4.1.356\tGlucosyl-dolichyl phosphate glucuronosyltransferase",
    "2.4.1.357\tPhlorizin synthase",
    "2.4.1.358\tAcylphloroglucinol glucosyltransferase",
    "2.4.1.359\tGlucosylglycerol phosphorylase (configuration-retaining)",
    "2.4.1.360\t2-hydroxyflavanone C-glucosyltransferase",
    "2.4.1.361\tGDP-mannose:di-myo-inositol-1,3'-phosphate beta-1,2-mannosyltransferase",
    "2.4.1.362\tAlpha-(1->3) branching sucrase",
    "2.4.1.363\tGinsenoside 20-O-glucosyltransferase",
    "2.4.1.364\tProtopanaxadiol-type ginsenoside 3-O-glucosyltransferase",
    "2.4.1.365\tProtopanaxadiol-type ginsenoside-3-O-glucoside 2''-O-glucosyltransferase",
    "2.4.1.366\tGinsenoside F1 6-O-glucosyltransferase",
    "2.4.1.367\tGinsenoside 6-O-glucosyltransferase",
    "2.4.1.368\tOleanolate 3-O-glucosyltransferase",
    "2.4.1.369\tEnterobactin C-glucosyltransferase",
    "2.4.1.370\tInositol phosphorylceramide mannosyltransferase",
    "2.4.1.371\tPolymannosyl GlcNAc-diphospho-ditrans,octacis-undecaprenol 2,3-alpha-mannosylpolymerase",
    "2.4.1.372\tMutansucrase",
    "2.4.1.373\tAlpha-(1->2) branching sucrase",
    "2.4.1.374\tBeta-1,2-mannooligosaccharide synthase",
    "2.4.1.375\tRhamnogalacturonan I galactosyltransferase",
    "2.4.1.376\tEGF-domain serine glucosyltransferase",
    "2.4.1.377\tdTDP-Rha:alpha-D-Gal-diphosphoundecaprenol alpha-1,3-rhamnosyltransferase",
    "2.4.1.378\tGDP-mannose:alpha-L-Rha-(1->3)-alpha-D-Gal-PP-Und alpha-1,4-mannosyltransferase",
    "2.4.1.379\tGDP-Man:alpha-D-Gal-diphosphoundecaprenol alpha-1,3-mannosyltransferase",
    "2.4.1.380\tGDP-Man:alpha-D-Man-(1->3)-alpha-D-Gal diphosphoundecaprenol alpha-1,2-mannosyltransferase",
    "2.4.1.381\tdTDP-Rha:alpha-D-Man-(1->3)-alpha-D-Gal diphosphoundecaprenol alpha-1,2-rahmnosyltransferase",
    "2.4.1.382\tCDP-abequose:alpha-L-Rha(2)OAc-(1->2)-alpha-D-Man-(1->2)-alpha-D-Man-(1->3)-alpha-D-Gal-PP-Und alpha-1,3-abequosyltransferase",
    "2.4.1.383\tGDP-Man:alpha-L-Rha-(1->3)-alpha-D-Gal-PP-Und beta-1,4-mannosyltransferase",
    "2.4.1.384\tNDP-glycosyltransferase",
    "2.4.1.n2\tLoliose synthase",
    "2.4.2.1\tPurine-nucleoside phosphorylase",
    "2.4.2.2\tPyrimidine-nucleoside phosphorylase",
    "2.4.2.3\tUridine phosphorylase",
    "2.4.2.4\tThymidine phosphorylase",
    "2.4.2.5\tNucleoside ribosyltransferase",
    "2.4.2.6\tNucleoside deoxyribosyltransferase",
    "2.4.2.7\tAdenine phosphoribosyltransferase",
    "2.4.2.8\tHypoxanthine phosphoribosyltransferase",
    "2.4.2.9\tUracil phosphoribosyltransferase",
    "2.4.2.10\tOrotate phosphoribosyltransferase",
    "2.4.2.12\tNicotinamide phosphoribosyltransferase",
    "2.4.2.14\tAmidophosphoribosyltransferase",
    "2.4.2.15\tGuanosine phosphorylase",
    "2.4.2.16\tUrate-ribonucleoside phosphorylase",
    "2.4.2.17\tATP phosphoribosyltransferase",
    "2.4.2.18\tAnthranilate phosphoribosyltransferase",
    "2.4.2.19\tNicotinate-nucleotide diphosphorylase (carboxylating)",
    "2.4.2.20\tDioxotetrahydropyrimidine phosphoribosyltransferase",
    "2.4.2.21\tNicotinate-nucleotide--dimethylbenzimidazole phosphoribosyltransferase",
    "2.4.2.22\tXanthine phosphoribosyltransferase",
    "2.4.2.24\t1,4-beta-D-xylan synthase",
    "2.4.2.25\tFlavone apiosyltransferase",
    "2.4.2.26\tProtein xylosyltransferase",
    "2.4.2.27\tdTDP-dihydrostreptose--streptidine-6-phosphate dihydrostreptosyltransferase",
    "2.4.2.28\tS-methyl-5'-thioadenosine phosphorylase",
    "2.4.2.29\ttRNA-guanosine(34) preQ(1) transglycosylase",
    "2.4.2.30\tNAD(+) ADP-ribosyltransferase",
    "2.4.2.31\tNAD(+)--protein-arginine ADP-ribosyltransferase",
    "2.4.2.32\tDolichyl-phosphate D-xylosyltransferase",
    "2.4.2.33\tDolichyl-xylosyl-phosphate--protein xylosyltransferase",
    "2.4.2.34\tIndolylacetylinositol arabinosyltransferase",
    "2.4.2.35\tFlavonol-3-O-glycoside xylosyltransferase",
    "2.4.2.36\tNAD(+)--diphthamide ADP-ribosyltransferase",
    "2.4.2.37\tNAD(+)--dinitrogen-reductase ADP-D-ribosyltransferase",
    "2.4.2.38\tGlycoprotein 2-beta-D-xylosyltransferase",
    "2.4.2.39\tXyloglucan 6-xylosyltransferase",
    "2.4.2.40\tZeatin O-beta-D-xylosyltransferase",
    "2.4.2.41\tXylogalacturonan beta-1,3-xylosyltransferase",
    "2.4.2.42\tUDP-D-xylose:beta-D-glucoside alpha-1,3-D-xylosyltransferase",
    "2.4.2.43\tLipid IV(A) 4-amino-4-deoxy-L-arabinosyltransferase",
    "2.4.2.44\tS-methyl-5'-thioinosine phosphorylase",
    "2.4.2.45\tDecaprenyl-phosphate phosphoribosyltransferase",
    "2.4.2.46\tGalactan 5-O-arabinofuranosyltransferase",
    "2.4.2.47\tArabinofuranan 3-O-arabinosyltransferase",
    "2.4.2.48\ttRNA-guanine(15) transglycosylase",
    "2.4.2.49\tNeamine phosphoribosyltransferase",
    "2.4.2.50\tCyanidin 3-O-galactoside 2''-O-xylosyltransferase",
    "2.4.2.51\tAnthocyanidin 3-O-glucoside 2'''-O-xylosyltransferase",
    "2.4.2.52\tTriphosphoribosyl-dephospho-CoA synthase",
    "2.4.2.53\tUndecaprenyl-phosphate 4-deoxy-4-formamido-L-arabinose transferase",
    "2.4.2.54\tBeta-ribofuranosylphenol 5'-phosphate synthase",
    "2.4.2.55\tNicotinate D-ribonucleotide:phenol phospho-D-ribosyltransferase",
    "2.4.2.56\tKaempferol 3-O-xylosyltransferase",
    "2.4.2.57\tAMP phosphorylase",
    "2.4.2.58\tHydroxyproline O-arabinosyltransferase",
    "2.4.2.59\tSulfide-dependent adenosine diphosphate thiazole synthase",
    "2.4.2.60\tCysteine-dependent adenosine diphosphate thiazole synthase",
    "2.4.2.61\tAlpha-dystroglycan beta-1,4-xylosyltransferase",
    "2.4.2.62\tXylosyl alpha-1,3-xylosyltransferase",
    "2.4.2.63\tEGF-domain serine xylosyltransferase",
    "2.4.2.64\ttRNA-guanosine(34) queuine transglycosylase",
    "2.4.2.n2\tGlucoside xylosyltransferase",
    "2.4.99.1\tBeta-galactoside alpha-(2,6)-sialyltransferase",
    "2.4.99.2\tBeta-D-galactosyl-(1->3)-N-acetyl-beta-D-galactosaminide alpha-2,3-sialyltransferase",
    "2.4.99.3\tAlpha-N-acetylgalactosaminide alpha-2,6-sialyltransferase",
    "2.4.99.4\tBeta-galactoside alpha-2,3-sialyltransferase",
    "2.4.99.5\tGalactosyldiacylglycerol alpha-2,3-sialyltransferase",
    "2.4.99.6\tN-acetyllactosaminide alpha-2,3-sialyltransferase",
    "2.4.99.7\tAlpha-N-acetylneuraminyl-2,3-beta-galactosyl-1,3-N-acetylgalactosaminide 6-alpha-sialyltransferase",
    "2.4.99.8\tAlpha-N-acetylneuraminate alpha-2,8-sialyltransferase",
    "2.4.99.9\tLactosylceramide alpha-2,3-sialyltransferase",
    "2.4.99.10\tNeolactotetraosylceramide alpha-2,3-sialyltransferase",
    "2.4.99.12\tLipid IV(A) 3-deoxy-D-manno-octulosonic acid transferase",
    "2.4.99.13\t(Kdo)-lipid IV(A) 3-deoxy-D-manno-octulosonic acid transferase",
    "2.4.99.14\t(Kdo)(2)-lipid IV(A) (2-8) 3-deoxy-D-manno-octulosonic acid transferase",
    "2.4.99.15\t(Kdo)(3)-lipid IV(A) (2-4) 3-deoxy-D-manno-octulosonic acid transferase",
    "2.4.99.16\tStarch synthase (maltosyl-transferring)",
    "2.4.99.17\tS-adenosylmethionine:tRNA ribosyltransferase-isomerase",
    "2.4.99.18\tDolichyl-diphosphooligosaccharide--protein glycotransferase",
    "2.4.99.19\tUndecaprenyl-diphosphooligosaccharide--protein glycotransferase",
    "2.4.99.20\t2'-phospho-ADP-ribosyl cyclase/2'-phospho-cyclic-ADP-ribose transferase",
    "2.4.99.21\tDolichyl-phosphooligosaccharide-protein glycotransferase",
    "2.4.99.22\tN-acetylglucosaminide alpha-(2,6)-sialyltransferase",
    "2.5.1.1\tDimethylallyltranstransferase",
    "2.5.1.2\tThiamine pyridinylase",
    "2.5.1.3\tThiamine phosphate synthase",
    "2.5.1.4\tAdenosylmethionine cyclotransferase",
    "2.5.1.5\tGalactose-6-sulfurylase",
    "2.5.1.6\tMethionine adenosyltransferase",
    "2.5.1.7\tUDP-N-acetylglucosamine 1-carboxyvinyltransferase",
    "2.5.1.9\tRiboflavin synthase",
    "2.5.1.10\t(2E,6E)-farnesyl diphosphate synthase",
    "2.5.1.15\tDihydropteroate synthase",
    "2.5.1.16\tSpermidine synthase",
    "2.5.1.17\tCorrinoid adenosyltransferase",
    "2.5.1.18\tGlutathione transferase",
    "2.5.1.19\t3-phosphoshikimate 1-carboxyvinyltransferase",
    "2.5.1.20\tRubber cis-polyprenylcistransferase",
    "2.5.1.21\tSqualene synthase",
    "2.5.1.22\tSpermine synthase",
    "2.5.1.23\tSym-norspermidine synthase",
    "2.5.1.24\tDiscadenine synthase",
    "2.5.1.25\ttRNA-uridine aminocarboxypropyltransferase",
    "2.5.1.26\tAlkylglycerone-phosphate synthase",
    "2.5.1.27\tAdenylate dimethylallyltransferase (AMP-dependent)",
    "2.5.1.28\tDimethylallylcistransferase",
    "2.5.1.29\tGeranylgeranyl diphosphate synthase",
    "2.5.1.30\tHeptaprenyl diphosphate synthase",
    "2.5.1.31\tDitrans,polycis-undecaprenyl-diphosphate synthase ((2E,6E)-farnesyl-diphosphate specific)",
    "2.5.1.32\t15-cis-phytoene synthase",
    "2.5.1.34\t4-dimethylallyltryptophan synthase",
    "2.5.1.35\tAspulvinone dimethylallyltransferase",
    "2.5.1.36\tTrihydroxypterocarpan dimethylallyltransferase",
    "2.5.1.38\tIsonocardicin synthase",
    "2.5.1.39\t4-hydroxybenzoate polyprenyltransferase",
    "2.5.1.41\tPhosphoglycerol geranylgeranyltransferase",
    "2.5.1.42\tGeranylgeranylglycerol-phosphate geranylgeranyltransferase",
    "2.5.1.43\tNicotianamine synthase",
    "2.5.1.44\tHomospermidine synthase",
    "2.5.1.45\tHomospermidine synthase (spermidine-specific)",
    "2.5.1.46\tDeoxyhypusine synthase",
    "2.5.1.47\tCysteine synthase",
    "2.5.1.48\tCystathionine gamma-synthase",
    "2.5.1.49\tO-acetylhomoserine aminocarboxypropyltransferase",
    "2.5.1.50\tZeatin 9-aminocarboxyethyltransferase",
    "2.5.1.51\tBeta-pyrazolylalanine synthase",
    "2.5.1.52\tL-mimosine synthase",
    "2.5.1.53\tUracilylalanine synthase",
    "2.5.1.54\t3-deoxy-7-phosphoheptulonate synthase",
    "2.5.1.55\t3-deoxy-8-phosphooctulonate synthase",
    "2.5.1.56\tN-acetylneuraminate synthase",
    "2.5.1.57\tN-acylneuraminate-9-phosphate synthase",
    "2.5.1.58\tProtein farnesyltransferase",
    "2.5.1.59\tProtein geranylgeranyltransferase type I",
    "2.5.1.60\tProtein geranylgeranyltransferase type II",
    "2.5.1.61\tHydroxymethylbilane synthase",
    "2.5.1.62\tChlorophyll synthase",
    "2.5.1.63\tAdenosyl-fluoride synthase",
    "2.5.1.65\tO-phosphoserine sulfhydrylase",
    "2.5.1.66\tN(2)-(2-carboxyethyl)arginine synthase",
    "2.5.1.67\tChrysanthemyl diphosphate synthase",
    "2.5.1.68\t(2Z,6E)-farnesyl diphosphate synthase",
    "2.5.1.69\tLavandulyl diphosphate synthase",
    "2.5.1.70\tNaringenin 8-dimethylallyltransferase",
    "2.5.1.71\tLeachianone-G 2''-dimethylallyltransferase",
    "2.5.1.72\tQuinolinate synthase",
    "2.5.1.73\tO-phospho-L-seryl-tRNA:Cys-tRNA synthase",
    "2.5.1.74\t1,4-dihydroxy-2-naphthoate polyprenyltransferase",
    "2.5.1.75\ttRNA dimethylallyltransferase",
    "2.5.1.76\tCysteate synthase",
    "2.5.1.78\t6,7-dimethyl-8-ribityllumazine synthase",
    "2.5.1.79\tThermospermine synthase",
    "2.5.1.80\t7-dimethylallyltryptophan synthase",
    "2.5.1.81\tGeranylfarnesyl diphosphate synthase",
    "2.5.1.82\tHexaprenyl diphosphate synthase (geranylgeranyl-diphosphate specific)",
    "2.5.1.83\tHexaprenyl-diphosphate synthase ((2E,6E)-farnesyl-diphosphate specific)",
    "2.5.1.84\tAll-trans-nonaprenyl-diphosphate synthase (geranyl-diphosphate specific)",
    "2.5.1.85\tAll-trans-nonaprenyl-diphosphate synthase (geranylgeranyl-diphosphate specific)",
    "2.5.1.86\tTrans,polycis-decaprenyl diphosphate synthase",
    "2.5.1.87\tDitrans,polycis-polyprenyl diphosphate synthase ((2E,6E)-farnesyl diphosphate specific)",
    "2.5.1.88\tTrans,polycis-polyprenyl diphosphate synthase ((2Z,6E)-farnesyl diphosphate specific)",
    "2.5.1.89\tTritrans,polycis-undecaprenyl-diphosphate synthase (geranylgeranyl-diphosphate specific)",
    "2.5.1.90\tAll-trans-octaprenyl-diphosphate synthase",
    "2.5.1.91\tAll-trans-decaprenyl-diphosphate synthase",
    "2.5.1.92\t(2Z,6Z)-farnesyl diphosphate synthase",
    "2.5.1.93\t4-hydroxybenzoate geranyltransferase",
    "2.5.1.94\tAdenosyl-chloride synthase",
    "2.5.1.95\tXanthan pyruvate transferase",
    "2.5.1.96\t4,4'-diapophytoene synthase",
    "2.5.1.97\tPseudaminic acid synthase",
    "2.5.1.98\tRhizobium leguminosarum exopolysaccharide glucosyl ketal-pyruvate-transferase",
    "2.5.1.100\tFumigaclavine A dimethylallyltransferase",
    "2.5.1.101\tN,N'-diacetyllegionaminate synthase",
    "2.5.1.102\tGeranylpyrophosphate--olivetolic acid geranyltransferase",
    "2.5.1.103\tPresqualene diphosphate synthase",
    "2.5.1.104\tN(1)-aminopropylagmatine synthase",
    "2.5.1.105\t7,8-dihydropterin-6-yl-methyl-4-(beta-D-ribofuranosyl)aminobenzene 5'-phosphate synthase",
    "2.5.1.106\tTryprostatin B synthase",
    "2.5.1.107\tVerruculogen prenyltransferase",
    "2.5.1.108\t2-(3-amino-3-carboxypropyl)histidine synthase",
    "2.5.1.109\tBrevianamide F prenyltransferase (deoxybrevianamide E-forming)",
    "2.5.1.110\t12-alpha,13-alpha-dihydroxyfumitremorgin C prenyltransferase",
    "2.5.1.111\t4-hydroxyphenylpyruvate 3-dimethylallyltransferase",
    "2.5.1.112\tAdenylate dimethylallyltransferase (ADP/ATP-dependent)",
    "2.5.1.113\t[CysO sulfur-carrier protein]-thiocarboxylate-dependent cysteine synthase",
    "2.5.1.114\ttRNA(Phe) (4-demethylwyosine(37)-C(7)) aminocarboxypropyltransferase",
    "2.5.1.115\tHomogentisate phytyltransferase",
    "2.5.1.116\tHomogentisate geranylgeranyltransferase",
    "2.5.1.117\tHomogentisate solanesyltransferase",
    "2.5.1.118\tBeta-(isoxazolin-5-on-2-yl)-L-alanine synthase",
    "2.5.1.119\tBeta-(isoxazolin-5-on-4-yl)-L-alanine synthase",
    "2.5.1.120\tAminodeoxyfutalosine synthase",
    "2.5.1.121\t5,10-dihydrophenazine-1-carboxylate 9-dimethylallyltransferase",
    "2.5.1.122\t4-O-dimethylallyl-L-tyrosine synthase",
    "2.5.1.123\tFlaviolin linalyltransferase",
    "2.5.1.124\t6-linalyl-2-O,3-dimethylflaviolin synthase",
    "2.5.1.125\t7-geranyloxy-5-hydroxy-2-methoxy-3-methylnaphthalene-1,4-dione synthase",
    "2.5.1.126\tNorspermine synthase",
    "2.5.1.127\tCaldopentamine synthase",
    "2.5.1.128\tN(4)-bis(aminopropyl)spermidine synthase",
    "2.5.1.129\tFlavin prenyltransferase",
    "2.5.1.130\t2-carboxy-1,4-naphthoquinone phytyltransferase",
    "2.5.1.131\t(4-(4-(2-(gamma-L-glutamylamino)ethyl)phenoxymethyl)furan-2-yl)methanamine synthase",
    "2.5.1.132\t3-deoxy-D-glycero-D-galacto-nononate 9-phosphate synthase",
    "2.5.1.133\tBacteriochlorophyll a synthase",
    "2.5.1.134\tCystathionine beta-synthase (O-acetyl-L-serine)",
    "2.5.1.135\tValidamine 7-phosphate valienyltransferase",
    "2.5.1.136\t2-acylphloroglucinol 4-prenyltransferase",
    "2.5.1.137\t2-acyl-4-prenylphloroglucinol 6-prenyltransferase",
    "2.5.1.138\tCoumarin 8-geranyltransferase",
    "2.5.1.139\tUmbelliferone 6-dimethylallyltransferase",
    "2.5.1.140\tN-(2-amino-2-carboxyethyl)-L-glutamate synthase",
    "2.5.1.141\tHeme o synthase",
    "2.5.1.142\tNerylneryl diphosphate synthase",
    "2.5.1.143\tPyridinium-3,5-biscarboxylic acid mononucleotide synthase",
    "2.5.1.144\tS-sulfo-L-cysteine synthase (O-acetyl-L-serine-dependent)",
    "2.5.1.145\tPhosphatidylglycerol--prolipoprotein diacylglyceryl transferase",
    "2.5.1.146\t3-geranyl-3-((Z)-2-isocyanoethenyl)indole synthase",
    "2.5.1.147\t5-amino-6-(D-ribitylamino)uracil--L-tyrosine 4-hydroxyphenyl transferase",
    "2.5.1.148\tLycopaoctaene synthase",
    "2.5.1.149\tLycopene elongase/hydratase (flavuxanthin-forming)",
    "2.5.1.150\tLycopene elongase/hydratase (dihydrobisanhydrobacterioruberin-forming)",
    "2.5.1.151\tAlkylcobalamin dealkylase",
    "2.5.1.152\tD-histidine 2-aminobutanoyltransferase",
    "2.5.1.153\tAdenosine tuberculosinyltransferase",
    "2.5.1.n9\tHeptaprenylglyceryl phosphate synthase",
    "2.6.1.1\tAspartate transaminase",
    "2.6.1.2\tAlanine transaminase",
    "2.6.1.3\tCysteine transaminase",
    "2.6.1.4\tGlycine transaminase",
    "2.6.1.5\tTyrosine transaminase",
    "2.6.1.6\tLeucine transaminase",
    "2.6.1.7\tKynurenine--oxoglutarate transaminase",
    "2.6.1.8\t2,5-diaminovalerate transaminase",
    "2.6.1.9\tHistidinol-phosphate transaminase",
    "2.6.1.11\tAcetylornithine transaminase",
    "2.6.1.12\tAlanine--oxo-acid transaminase",
    "2.6.1.13\tOrnithine aminotransferase",
    "2.6.1.14\tAsparagine--oxo-acid transaminase",
    "2.6.1.15\tGlutamine--pyruvate transaminase",
    "2.6.1.16\tGlutamine--fructose-6-phosphate transaminase (isomerizing)",
    "2.6.1.17\tSuccinyldiaminopimelate transaminase",
    "2.6.1.18\tBeta-alanine--pyruvate transaminase",
    "2.6.1.19\t4-aminobutyrate--2-oxoglutarate transaminase",
    "2.6.1.21\tD-amino-acid transaminase",
    "2.6.1.22\t(S)-3-amino-2-methylpropionate transaminase",
    "2.6.1.23\t4-hydroxyglutamate transaminase",
    "2.6.1.24\tDiiodotyrosine transaminase",
    "2.6.1.26\tThyroid-hormone transaminase",
    "2.6.1.27\tTryptophan transaminase",
    "2.6.1.28\tTryptophan--phenylpyruvate transaminase",
    "2.6.1.29\tDiamine transaminase",
    "2.6.1.30\tPyridoxamine--pyruvate transaminase",
    "2.6.1.31\tPyridoxamine--oxaloacetate transaminase",
    "2.6.1.32\tValine--3-methyl-2-oxovalerate transaminase",
    "2.6.1.33\tdTDP-4-amino-4,6-dideoxy-D-glucose transaminase",
    "2.6.1.34\tUDP-N-acetylbacillosamine transaminase",
    "2.6.1.35\tGlycine--oxaloacetate transaminase",
    "2.6.1.36\tL-lysine 6-transaminase",
    "2.6.1.37\t2-aminoethylphosphonate--pyruvate transaminase",
    "2.6.1.38\tHistidine transaminase",
    "2.6.1.39\t2-aminoadipate transaminase",
    "2.6.1.40\t(R)-3-amino-2-methylpropionate--pyruvate transaminase",
    "2.6.1.41\tD-methionine--pyruvate transaminase",
    "2.6.1.42\tBranched-chain-amino-acid transaminase",
    "2.6.1.43\tAminolevulinate transaminase",
    "2.6.1.44\tAlanine--glyoxylate transaminase",
    "2.6.1.45\tSerine--glyoxylate transaminase",
    "2.6.1.46\tDiaminobutyrate--pyruvate transaminase",
    "2.6.1.47\tAlanine--oxomalonate transaminase",
    "2.6.1.48\t5-aminovalerate transaminase",
    "2.6.1.49\tDihydroxyphenylalanine transaminase",
    "2.6.1.50\tGlutamine--scyllo-inositol transaminase",
    "2.6.1.51\tSerine--pyruvate transaminase",
    "2.6.1.52\tPhosphoserine transaminase",
    "2.6.1.54\tPyridoxamine-phosphate transaminase",
    "2.6.1.55\tTaurine--2-oxoglutarate transaminase",
    "2.6.1.56\t1D-1-guanidino-3-amino-1,3-dideoxy-scyllo-inositol transaminase",
    "2.6.1.57\tAromatic-amino-acid transaminase",
    "2.6.1.58\tPhenylalanine(histidine) transaminase",
    "2.6.1.59\tdTDP-4-amino-4,6-dideoxygalactose transaminase",
    "2.6.1.60\tAromatic-amino-acid--glyoxylate transaminase",
    "2.6.1.62\tAdenosylmethionine--8-amino-7-oxononanoate transaminase",
    "2.6.1.63\tKynurenine--glyoxylate transaminase",
    "2.6.1.64\tGlutamine--phenylpyruvate transaminase",
    "2.6.1.65\tN(6)-acetyl-beta-lysine transaminase",
    "2.6.1.66\tValine--pyruvate transaminase",
    "2.6.1.67\t2-aminohexanoate transaminase",
    "2.6.1.70\tAspartate--phenylpyruvate transaminase",
    "2.6.1.71\tLysine--pyruvate 6-transaminase",
    "2.6.1.72\tD-4-hydroxyphenylglycine transaminase",
    "2.6.1.73\tMethionine--glyoxylate transaminase",
    "2.6.1.74\tCephalosporin-C transaminase",
    "2.6.1.75\tCysteine-conjugate transaminase",
    "2.6.1.76\tDiaminobutyrate--2-oxoglutarate transaminase",
    "2.6.1.77\tTaurine--pyruvate aminotransferase",
    "2.6.1.78\tAspartate--prephenate aminotransferase",
    "2.6.1.79\tGlutamate--prephenate aminotransferase",
    "2.6.1.80\tNicotianamine aminotransferase",
    "2.6.1.81\tSuccinylornithine transaminase",
    "2.6.1.82\tPutrescine--2-oxoglutarate transaminase",
    "2.6.1.83\tLL-diaminopimelate aminotransferase",
    "2.6.1.84\tArginine--pyruvate transaminase",
    "2.6.1.85\tAminodeoxychorismate synthase",
    "2.6.1.86\t2-amino-4-deoxychorismate synthase",
    "2.6.1.87\tUDP-4-amino-4-deoxy-L-arabinose aminotransferase",
    "2.6.1.88\tMethionine transaminase",
    "2.6.1.89\tdTDP-3-amino-3,6-dideoxy-alpha-D-glucopyranose transaminase",
    "2.6.1.90\tdTDP-3-amino-3,6-dideoxy-alpha-D-galactopyranose transaminase",
    "2.6.1.92\tUDP-4-amino-4,6-dideoxy-N-acetyl-beta-L-altrosamine transaminase",
    "2.6.1.93\tNeamine transaminase",
    "2.6.1.94\t2'-deamino-2'-hydroxyneamine transaminase",
    "2.6.1.95\tNeomycin C transaminase",
    "2.6.1.96\t4-aminobutyrate--pyruvate transaminase",
    "2.6.1.97\tArchaeosine synthase",
    "2.6.1.98\tUDP-2-acetamido-2-deoxy-ribo-hexuluronate aminotransferase",
    "2.6.1.99\tL-tryptophan--pyruvate aminotransferase",
    "2.6.1.100\tL-glutamine:2-deoxy-scyllo-inosose aminotransferase",
    "2.6.1.101\tL-glutamine:3-amino-2,3-dideoxy-scyllo-inosose aminotransferase",
    "2.6.1.102\tGDP-perosamine synthase",
    "2.6.1.103\t(S)-3,5-dihydroxyphenylglycine transaminase",
    "2.6.1.104\t3-dehydro-glucose-6-phosphate--glutamate transaminase",
    "2.6.1.105\tLysine--8-amino-7-oxononanoate transaminase",
    "2.6.1.106\tdTDP-3-amino-3,4,6-trideoxy-alpha-D-glucose transaminase",
    "2.6.1.107\tBeta-methylphenylalanine transaminase",
    "2.6.1.108\t(5-formylfuran-3-yl)methyl phosphate transaminase",
    "2.6.1.109\t8-amino-3,8-dideoxy-alpha-D-manno-octulosonate transaminase",
    "2.6.1.110\tdTDP-4-dehydro-2,3,6-trideoxy-D-glucose 4-aminotransferase",
    "2.6.1.111\t3-aminobutanoyl-CoA transaminase",
    "2.6.1.112\t(S)-ureidoglycine--glyoxylate transaminase",
    "2.6.1.113\tPutrescine--pyruvate transaminase",
    "2.6.1.114\t8-demethyl-8-aminoriboflavin-5'-phosphate synthase",
    "2.6.1.115\t5-hydroxydodecatetraenal 1-aminotransferase",
    "2.6.1.116\t6-aminohexanoate aminotransferase",
    "2.6.1.117\tL-glutamine--4-(methylsulfanyl)-2-oxobutanoate aminotransferase",
    "2.6.1.118\t[Amino group carrier protein]-gamma-(L-lysyl)-L-glutamate aminotransferase",
    "2.6.1.119\tVanillin aminotransferase",
    "2.6.3.1\tOximinotransferase",
    "2.6.99.1\tdATP(dGTP)--DNA purinetransferase",
    "2.6.99.2\tPyridoxine 5'-phosphate synthase",
    "2.6.99.3\tO-ureido-L-serine synthase",
    "2.7.1.1\tHexokinase",
    "2.7.1.2\tGlucokinase",
    "2.7.1.3\tKetohexokinase",
    "2.7.1.4\tFructokinase",
    "2.7.1.5\tRhamnulokinase",
    "2.7.1.6\tGalactokinase",
    "2.7.1.7\tMannokinase",
    "2.7.1.8\tGlucosamine kinase",
    "2.7.1.10\tPhosphoglucokinase",
    "2.7.1.11\t6-phosphofructokinase",
    "2.7.1.12\tGluconokinase",
    "2.7.1.13\tDehydrogluconokinase",
    "2.7.1.14\tSedoheptulokinase",
    "2.7.1.15\tRibokinase",
    "2.7.1.16\tRibulokinase",
    "2.7.1.17\tXylulokinase",
    "2.7.1.18\tPhosphoribokinase",
    "2.7.1.19\tPhosphoribulokinase",
    "2.7.1.20\tAdenosine kinase",
    "2.7.1.21\tThymidine kinase",
    "2.7.1.22\tRibosylnicotinamide kinase",
    "2.7.1.23\tNAD(+) kinase",
    "2.7.1.24\tDephospho-CoA kinase",
    "2.7.1.25\tAdenylyl-sulfate kinase",
    "2.7.1.26\tRiboflavin kinase",
    "2.7.1.27\tErythritol kinase (D-erythritol 4-phosphate-forming)",
    "2.7.1.28\tTriokinase",
    "2.7.1.29\tGlycerone kinase",
    "2.7.1.30\tGlycerol kinase",
    "2.7.1.31\tGlycerate 3-kinase",
    "2.7.1.32\tCholine kinase",
    "2.7.1.33\tPantothenate kinase",
    "2.7.1.34\tPantetheine kinase",
    "2.7.1.35\tPyridoxal kinase",
    "2.7.1.36\tMevalonate kinase",
    "2.7.1.39\tHomoserine kinase",
    "2.7.1.40\tPyruvate kinase",
    "2.7.1.41\tGlucose-1-phosphate phosphodismutase",
    "2.7.1.42\tRiboflavin phosphotransferase",
    "2.7.1.43\tGlucuronokinase",
    "2.7.1.44\tGalacturonokinase",
    "2.7.1.45\t2-dehydro-3-deoxygluconokinase",
    "2.7.1.46\tL-arabinokinase",
    "2.7.1.47\tD-ribulokinase",
    "2.7.1.48\tUridine/cytidine kinase",
    "2.7.1.49\tHydroxymethylpyrimidine kinase",
    "2.7.1.50\tHydroxyethylthiazole kinase",
    "2.7.1.51\tL-fuculokinase",
    "2.7.1.52\tFucokinase",
    "2.7.1.53\tL-xylulokinase",
    "2.7.1.54\tD-arabinokinase",
    "2.7.1.55\tAllose kinase",
    "2.7.1.56\t1-phosphofructokinase",
    "2.7.1.58\t2-dehydro-3-deoxygalactonokinase",
    "2.7.1.59\tN-acetylglucosamine kinase",
    "2.7.1.60\tN-acylmannosamine kinase",
    "2.7.1.61\tAcyl-phosphate--hexose phosphotransferase",
    "2.7.1.62\tPhosphoramidate--hexose phosphotransferase",
    "2.7.1.63\tPolyphosphate--glucose phosphotransferase",
    "2.7.1.64\tInositol 3-kinase",
    "2.7.1.65\tScyllo-inosamine 4-kinase",
    "2.7.1.66\tUndecaprenol kinase",
    "2.7.1.67\t1-phosphatidylinositol 4-kinase",
    "2.7.1.68\t1-phosphatidylinositol-4-phosphate 5-kinase",
    "2.7.1.71\tShikimate kinase",
    "2.7.1.72\tStreptomycin 6-kinase",
    "2.7.1.73\tInosine kinase",
    "2.7.1.74\tDeoxycytidine kinase",
    "2.7.1.76\tDeoxyadenosine kinase",
    "2.7.1.77\tNucleoside phosphotransferase",
    "2.7.1.78\tPolynucleotide 5'-hydroxyl-kinase",
    "2.7.1.79\tDiphosphate--glycerol phosphotransferase",
    "2.7.1.80\tDiphosphate--serine phosphotransferase",
    "2.7.1.81\tHydroxylysine kinase",
    "2.7.1.82\tEthanolamine kinase",
    "2.7.1.83\tPseudouridine kinase",
    "2.7.1.84\tAlkylglycerone kinase",
    "2.7.1.85\tBeta-glucoside kinase",
    "2.7.1.86\tNADH kinase",
    "2.7.1.87\tStreptomycin 3''-kinase",
    "2.7.1.88\tDihydrostreptomycin-6-phosphate 3'-alpha-kinase",
    "2.7.1.89\tThiamine kinase",
    "2.7.1.90\tDiphosphate--fructose-6-phosphate 1-phosphotransferase",
    "2.7.1.91\tSphingosine kinase",
    "2.7.1.92\t5-dehydro-2-deoxygluconokinase",
    "2.7.1.93\tAlkylglycerol kinase",
    "2.7.1.94\tAcylglycerol kinase",
    "2.7.1.95\tKanamycin kinase",
    "2.7.1.100\tS-methyl-5-thioribose kinase",
    "2.7.1.101\tTagatose kinase",
    "2.7.1.102\tHamamelose kinase",
    "2.7.1.103\tViomycin kinase",
    "2.7.1.105\t6-phosphofructo-2-kinase",
    "2.7.1.106\tGlucose-1,6-bisphosphate synthase",
    "2.7.1.107\tDiacylglycerol kinase (ATP)",
    "2.7.1.108\tDolichol kinase",
    "2.7.1.113\tDeoxyguanosine kinase",
    "2.7.1.114\tAMP--thymidine kinase",
    "2.7.1.118\tADP--thymidine kinase",
    "2.7.1.119\tHygromycin-B 7''-O-kinase",
    "2.7.1.121\tPhosphoenolpyruvate--glycerone phosphotransferase",
    "2.7.1.122\tXylitol kinase",
    "2.7.1.127\tInositol-trisphosphate 3-kinase",
    "2.7.1.130\tTetraacyldisaccharide 4'-kinase",
    "2.7.1.134\tInositol-tetrakisphosphate 1-kinase",
    "2.7.1.136\tMacrolide 2'-kinase",
    "2.7.1.137\tPhosphatidylinositol 3-kinase",
    "2.7.1.138\tCeramide kinase",
    "2.7.1.140\tInositol-tetrakisphosphate 5-kinase",
    "2.7.1.142\tGlycerol-3-phosphate--glucose phosphotransferase",
    "2.7.1.143\tDiphosphate-purine nucleoside kinase",
    "2.7.1.144\tTagatose-6-phosphate kinase",
    "2.7.1.145\tDeoxynucleoside kinase",
    "2.7.1.146\tADP-specific phosphofructokinase",
    "2.7.1.147\tADP-specific glucose/glucosamine kinase",
    "2.7.1.148\t4-(cytidine 5'-diphospho)-2-C-methyl-D-erythritol kinase",
    "2.7.1.149\t1-phosphatidylinositol-5-phosphate 4-kinase",
    "2.7.1.150\t1-phosphatidylinositol-3-phosphate 5-kinase",
    "2.7.1.151\tInositol-polyphosphate multikinase",
    "2.7.1.153\tPhosphatidylinositol-4,5-bisphosphate 3-kinase",
    "2.7.1.154\tPhosphatidylinositol-4-phosphate 3-kinase",
    "2.7.1.156\tAdenosylcobinamide kinase",
    "2.7.1.157\tN-acetylgalactosamine kinase",
    "2.7.1.158\tInositol-pentakisphosphate 2-kinase",
    "2.7.1.159\tInositol-1,3,4-trisphosphate 5/6-kinase",
    "2.7.1.160\t2'-phosphotransferase",
    "2.7.1.161\tCTP-dependent riboflavin kinase",
    "2.7.1.162\tN-acetylhexosamine 1-kinase",
    "2.7.1.163\tHygromycin B 4-O-kinase",
    "2.7.1.164\tO-phosphoseryl-tRNA(Sec) kinase",
    "2.7.1.165\tGlycerate 2-kinase",
    "2.7.1.166\t3-deoxy-D-manno-octulosonic acid kinase",
    "2.7.1.167\tD-glycero-beta-D-manno-heptose-7-phosphate kinase",
    "2.7.1.168\tD-glycero-alpha-D-manno-heptose-7-phosphate kinase",
    "2.7.1.169\tPantoate kinase",
    "2.7.1.170\tAnhydro-N-acetylmuramic acid kinase",
    "2.7.1.171\tProtein-fructosamine 3-kinase",
    "2.7.1.172\tProtein-ribulosamine 3-kinase",
    "2.7.1.173\tNicotinate riboside kinase",
    "2.7.1.174\tDiacylglycerol kinase (CTP)",
    "2.7.1.175\tMaltokinase",
    "2.7.1.176\tUDP-N-acetylglucosamine kinase",
    "2.7.1.177\tL-threonine kinase",
    "2.7.1.178\t2-dehydro-3-deoxyglucono/galactono-kinase",
    "2.7.1.179\tKanosamine kinase",
    "2.7.1.180\tFAD:protein FMN transferase",
    "2.7.1.181\tPolymannosyl GlcNAc-diphospho-ditrans,octacis-undecaprenol kinase",
    "2.7.1.182\tPhytol kinase",
    "2.7.1.183\tGlycoprotein-mannosyl O(6)-kinase",
    "2.7.1.184\tSulfofructose kinase",
    "2.7.1.185\tMevalonate 3-kinase",
    "2.7.1.186\tMevalonate-3-phosphate 5-kinase",
    "2.7.1.187\tAcarbose 7(IV)-phosphotransferase",
    "2.7.1.188\t2-epi-5-epi-valiolone 7-kinase",
    "2.7.1.189\tAutoinducer-2 kinase",
    "2.7.1.190\tAminoglycoside 2''-phosphotransferase",
    "2.7.1.191\tProtein-N(pi)-phosphohistidine--D-mannose phosphotransferase",
    "2.7.1.192\tProtein-N(pi)-phosphohistidine--N-acetylmuramate phosphotransferase",
    "2.7.1.193\tProtein-N(pi)-phosphohistidine--N-acetyl-D-glucosamine phosphotransferase",
    "2.7.1.194\tProtein-N(pi)-phosphohistidine--L-ascorbate phosphotransferase",
    "2.7.1.195\tProtein-N(pi)-phosphohistidine--2-O-alpha-mannosyl-D-glycerate phosphotransferase",
    "2.7.1.196\tProtein-N(pi)-phosphohistidine--N,N'-diacetylchitobiose phosphotransferase",
    "2.7.1.197\tProtein-N(pi)-phosphohistidine--D-mannitol phosphotransferase",
    "2.7.1.198\tProtein-N(pi)-phosphohistidine--D-sorbitol phosphotransferase",
    "2.7.1.199\tProtein-N(pi)-phosphohistidine--D-glucose phosphotransferase",
    "2.7.1.200\tProtein-N(pi)-phosphohistidine--galactitol phosphotransferase",
    "2.7.1.201\tProtein-N(pi)-phosphohistidine--trehalose phosphotransferase",
    "2.7.1.202\tProtein-N(pi)-phosphohistidine--D-fructose phosphotransferase",
    "2.7.1.203\tProtein-N(pi)-phosphohistidine--D-glucosaminate phosphotransferase",
    "2.7.1.204\tProtein-N(pi)-phosphohistidine--D-galactose phosphotransferase",
    "2.7.1.205\tProtein-N(pi)-phosphohistidine--D-cellobiose phosphotransferase",
    "2.7.1.206\tProtein-N(pi)-phosphohistidine--L-sorbose phosphotransferase",
    "2.7.1.207\tProtein-N(pi)-phosphohistidine--lactose phosphotransferase",
    "2.7.1.208\tProtein-N(pi)-phosphohistidine--maltose phosphotransferase",
    "2.7.1.209\tL-erythrulose 1-kinase",
    "2.7.1.210\tD-erythrulose 4-kinase",
    "2.7.1.211\tProtein-N(pi)-phosphohistidine--sucrose phosphotransferase",
    "2.7.1.212\tAlpha-D-ribose-1-phosphate 5-kinase (ADP)",
    "2.7.1.213\tCytidine kinase",
    "2.7.1.214\tC(7)-cyclitol 7-kinase",
    "2.7.1.215\tErythritol kinase (D-erythritol 1-phosphate-forming)",
    "2.7.1.216\tFarnesol kinase",
    "2.7.1.217\t3-dehydrotetronate 4-kinase",
    "2.7.1.218\tFructoselysine 6-kinase",
    "2.7.1.219\tD-threonate 4-kinase",
    "2.7.1.220\tD-erythronate 4-kinase",
    "2.7.1.221\tN-acetylmuramate 1-kinase",
    "2.7.1.222\t4-hydroxytryptamine kinase",
    "2.7.1.223\tAminoimidazole riboside kinase",
    "2.7.1.224\tCytidine diphosphoramidate kinase",
    "2.7.1.225\tL-serine kinase (ATP)",
    "2.7.1.226\tL-serine kinase (ADP)",
    "2.7.1.227\tInositol phosphorylceramide synthase",
    "2.7.1.228\tMannosyl-inositol-phosphoceramide inositolphosphotransferase",
    "2.7.1.229\tDeoxyribokinase",
    "2.7.1.230\tAmicoumacin kinase",
    "2.7.1.231\t3-oxoisoapionate kinase",
    "2.7.1.232\tLevoglucosan kinase",
    "2.7.1.233\tApulose kinase",
    "2.7.2.1\tAcetate kinase",
    "2.7.2.2\tCarbamate kinase",
    "2.7.2.3\tPhosphoglycerate kinase",
    "2.7.2.4\tAspartate kinase",
    "2.7.2.6\tFormate kinase",
    "2.7.2.7\tButyrate kinase",
    "2.7.2.8\tAcetylglutamate kinase",
    "2.7.2.10\tPhosphoglycerate kinase (GTP)",
    "2.7.2.11\tGlutamate 5-kinase",
    "2.7.2.12\tAcetate kinase (diphosphate)",
    "2.7.2.14\tBranched-chain-fatty-acid kinase",
    "2.7.2.15\tPropionate kinase",
    "2.7.2.16\t2-phosphoglycerate kinase",
    "2.7.2.17\t[Amino-group carrier protein]-L-2-aminoadipate 6-kinase",
    "2.7.2.18\tFatty acid kinase",
    "2.7.3.1\tGuanidinoacetate kinase",
    "2.7.3.2\tCreatine kinase",
    "2.7.3.3\tArginine kinase",
    "2.7.3.4\tTaurocyamine kinase",
    "2.7.3.5\tLombricine kinase",
    "2.7.3.6\tHypotaurocyamine kinase",
    "2.7.3.7\tOpheline kinase",
    "2.7.3.8\tAmmonia kinase",
    "2.7.3.9\tPhosphoenolpyruvate--protein phosphotransferase",
    "2.7.3.10\tAgmatine kinase",
    "2.7.3.13\tGlutamine kinase",
    "2.7.4.1\tATP-polyphosphate phosphotransferase",
    "2.7.4.2\tPhosphomevalonate kinase",
    "2.7.4.3\tAdenylate kinase",
    "2.7.4.4\tNucleoside-phosphate kinase",
    "2.7.4.6\tNucleoside-diphosphate kinase",
    "2.7.4.7\tPhosphooxymethylpyrimidine kinase",
    "2.7.4.8\tGuanylate kinase",
    "2.7.4.9\tdTMP kinase",
    "2.7.4.10\tNucleoside-triphosphate--adenylate kinase",
    "2.7.4.11\t(Deoxy)adenylate kinase",
    "2.7.4.12\tT(2)-induced deoxynucleotide kinase",
    "2.7.4.13\t(Deoxy)nucleoside-phosphate kinase",
    "2.7.4.14\tUMP/CMP kinase",
    "2.7.4.15\tThiamine-diphosphate kinase",
    "2.7.4.16\tThiamine-phosphate kinase",
    "2.7.4.17\t3-phosphoglyceroyl-phosphate--polyphosphate phosphotransferase",
    "2.7.4.18\tFarnesyl-diphosphate kinase",
    "2.7.4.19\t5-methyldeoxycytidine-5'-phosphate kinase",
    "2.7.4.20\tDolichyl-diphosphate--polyphosphate phosphotransferase",
    "2.7.4.21\tInositol-hexakisphosphate kinase",
    "2.7.4.22\tUMP kinase",
    "2.7.4.23\tRibose 1,5-bisphosphate phosphokinase",
    "2.7.4.24\tDiphosphoinositol-pentakisphosphate kinase",
    "2.7.4.25\t(d)CMP kinase",
    "2.7.4.26\tIsopentenyl phosphate kinase",
    "2.7.4.27\t([Pyruvate, phosphate dikinase] phosphate) phosphotransferase",
    "2.7.4.28\t([Pyruvate, water dikinase] phosphate) phosphotransferase",
    "2.7.4.29\tKdo(2)-lipid A phosphotransferase",
    "2.7.4.31\t(5-(aminomethyl)furan-3-yl)methyl phosphate kinase",
    "2.7.4.32\tFarnesyl phosphate kinase",
    "2.7.4.33\tAMP-polyphosphate phosphotransferase",
    "2.7.4.34\tGDP-polyphosphate phosphotransferase",
    "2.7.6.1\tRibose-phosphate diphosphokinase",
    "2.7.6.2\tThiamine diphosphokinase",
    "2.7.6.3\t2-amino-4-hydroxy-6-hydroxymethyldihydropteridine diphosphokinase",
    "2.7.6.4\tNucleotide diphosphokinase",
    "2.7.6.5\tGTP diphosphokinase",
    "2.7.7.1\tNicotinamide-nucleotide adenylyltransferase",
    "2.7.7.2\tFAD synthase",
    "2.7.7.3\tPantetheine-phosphate adenylyltransferase",
    "2.7.7.4\tSulfate adenylyltransferase",
    "2.7.7.5\tSulfate adenylyltransferase (ADP)",
    "2.7.7.6\tDNA-directed RNA polymerase",
    "2.7.7.7\tDNA-directed DNA polymerase",
    "2.7.7.8\tPolyribonucleotide nucleotidyltransferase",
    "2.7.7.9\tUTP--glucose-1-phosphate uridylyltransferase",
    "2.7.7.10\tUTP--hexose-1-phosphate uridylyltransferase",
    "2.7.7.11\tUTP--xylose-1-phosphate uridylyltransferase",
    "2.7.7.12\tUDP-glucose--hexose-1-phosphate uridylyltransferase",
    "2.7.7.13\tMannose-1-phosphate guanylyltransferase",
    "2.7.7.14\tEthanolamine-phosphate cytidylyltransferase",
    "2.7.7.15\tCholine-phosphate cytidylyltransferase",
    "2.7.7.18\tNicotinate-nucleotide adenylyltransferase",
    "2.7.7.19\tPolynucleotide adenylyltransferase",
    "2.7.7.22\tMannose-1-phosphate guanylyltransferase (GDP)",
    "2.7.7.23\tUDP-N-acetylglucosamine diphosphorylase",
    "2.7.7.24\tGlucose-1-phosphate thymidylyltransferase",
    "2.7.7.27\tGlucose-1-phosphate adenylyltransferase",
    "2.7.7.28\tNucleoside-triphosphate-aldose-1-phosphate nucleotidyltransferase",
    "2.7.7.30\tFucose-1-phosphate guanylyltransferase",
    "2.7.7.31\tDNA nucleotidylexotransferase",
    "2.7.7.32\tGalactose-1-phosphate thymidylyltransferase",
    "2.7.7.33\tGlucose-1-phosphate cytidylyltransferase",
    "2.7.7.34\tGlucose-1-phosphate guanylyltransferase",
    "2.7.7.35\tADP ribose phosphorylase",
    "2.7.7.36\tAldose-1-phosphate adenylyltransferase",
    "2.7.7.37\tAldose-1-phosphate nucleotidyltransferase",
    "2.7.7.38\t3-deoxy-manno-octulosonate cytidylyltransferase",
    "2.7.7.39\tGlycerol-3-phosphate cytidylyltransferase",
    "2.7.7.40\tD-ribitol-5-phosphate cytidylyltransferase",
    "2.7.7.41\tPhosphatidate cytidylyltransferase",
    "2.7.7.42\t[Glutamine synthetase] adenylyltransferase",
    "2.7.7.43\tN-acylneuraminate cytidylyltransferase",
    "2.7.7.44\tGlucuronate-1-phosphate uridylyltransferase",
    "2.7.7.45\tGuanosine-triphosphate guanylyltransferase",
    "2.7.7.46\tGentamicin 2''-nucleotidyltransferase",
    "2.7.7.47\tStreptomycin 3''-adenylyltransferase",
    "2.7.7.48\tRNA-directed RNA polymerase",
    "2.7.7.49\tRNA-directed DNA polymerase",
    "2.7.7.50\tmRNA guanylyltransferase",
    "2.7.7.51\tAdenylylsulfate--ammonia adenylyltransferase",
    "2.7.7.52\tRNA uridylyltransferase",
    "2.7.7.53\tATP adenylyltransferase",
    "2.7.7.56\ttRNA nucleotidyltransferase",
    "2.7.7.57\tN-methylphosphoethanolamine cytidylyltransferase",
    "2.7.7.59\t[Protein-PII] uridylyltransferase",
    "2.7.7.60\t2-C-methyl-D-erythritol 4-phosphate cytidylyltransferase",
    "2.7.7.61\tCitrate lyase holo-[acyl-carrier protein] synthase",
    "2.7.7.62\tAdenosylcobinamide-phosphate guanylyltransferase",
    "2.7.7.64\tUTP-monosaccharide-1-phosphate uridylyltransferase",
    "2.7.7.65\tDiguanylate cyclase",
    "2.7.7.66\tMalonate decarboxylase holo-[acyl-carrier protein] synthase",
    "2.7.7.67\tCDP-2,3-bis-(O-geranylgeranyl)-sn-glycerol synthase",
    "2.7.7.68\t2-phospho-L-lactate guanylyltransferase",
    "2.7.7.69\tGDP-L-galactose/GDP-D-glucose: hexose 1-phosphate guanylyltransferase",
    "2.7.7.70\tD-glycero-beta-D-manno-heptose 1-phosphate adenylyltransferase",
    "2.7.7.71\tD-glycero-alpha-D-manno-heptose 1-phosphate guanylyltransferase",
    "2.7.7.72\tCCA tRNA nucleotidyltransferase",
    "2.7.7.73\tSulfur carrier protein ThiS adenylyltransferase",
    "2.7.7.74\t1L-myo-inositol 1-phosphate cytidylyltransferase",
    "2.7.7.75\tMolybdopterin adenylyltransferase",
    "2.7.7.76\tMolybdenum cofactor cytidylyltransferase",
    "2.7.7.77\tMolybdenum cofactor guanylyltransferase",
    "2.7.7.78\tGDP-D-glucose phosphorylase",
    "2.7.7.79\ttRNA(His) guanylyltransferase",
    "2.7.7.80\tMolybdopterin-synthase adenylyltransferase",
    "2.7.7.81\tPseudaminic acid cytidylyltransferase",
    "2.7.7.82\tCMP-N,N'-diacetyllegionaminic acid synthase",
    "2.7.7.83\tUDP-N-acetylgalactosamine diphosphorylase",
    "2.7.7.84\t2'-5' oligoadenylate synthase",
    "2.7.7.85\tDiadenylate cyclase",
    "2.7.7.86\tCyclic GMP-AMP synthase",
    "2.7.7.87\tL-threonylcarbamoyladenylate synthase",
    "2.7.7.88\tGDP polyribonucleotidyltransferase",
    "2.7.7.89\t[Glutamine synthetase]-adenylyl-L-tyrosine phosphorylase",
    "2.7.7.90\t8-amino-3,8-dideoxy-manno-octulosonate cytidylyltransferase",
    "2.7.7.91\tValienol-1-phosphate guanylyltransferase",
    "2.7.7.92\t3-deoxy-D-glycero-D-galacto-nononate cytidylyltransferase",
    "2.7.7.93\tPhosphonoformate cytidylyltransferase",
    "2.7.7.96\tADP-D-ribose pyrophosphorylase",
    "2.7.7.97\t3-hydroxy-4-methylanthranilate adenylyltransferase",
    "2.7.7.99\tN-acetyl-alpha-D-muramate 1-phosphate uridylyltransferase",
    "2.7.7.100\tSAMP-activating enzyme",
    "2.7.7.101\tDNA primase DnaG",
    "2.7.7.102\tDNA primase AEP",
    "2.7.7.103\tL-glutamine-phosphate cytidylyltransferase",
    "2.7.7.104\t2-hydroxyethylphosphonate cytidylyltransferase",
    "2.7.7.105\tPhosphoenolpyruvate guanylyltransferase",
    "2.7.7.106\t3-phospho-D-glycerate guanylyltransferase",
    "2.7.7.n1\tProtein adenylyltransferase",
    "2.7.7.n6\tGuanine phosphate-protein transferase",
    "2.7.8.1\tEthanolaminephosphotransferase",
    "2.7.8.2\tDiacylglycerol cholinephosphotransferase",
    "2.7.8.3\tCeramide cholinephosphotransferase",
    "2.7.8.4\tSerine-phosphoethanolamine synthase",
    "2.7.8.5\tCDP-diacylglycerol--glycerol-3-phosphate 1-phosphatidyltransferase",
    "2.7.8.6\tUndecaprenyl-phosphate galactose phosphotransferase",
    "2.7.8.7\tHolo-[acyl-carrier-protein] synthase",
    "2.7.8.8\tCDP-diacylglycerol--serine O-phosphatidyltransferase",
    "2.7.8.9\tPhosphomannan mannosephosphotransferase",
    "2.7.8.10\tSphingosine cholinephosphotransferase",
    "2.7.8.11\tCDP-diacylglycerol--inositol 3-phosphatidyltransferase",
    "2.7.8.12\tTeichoic acid poly(glycerol phosphate) polymerase",
    "2.7.8.13\tPhospho-N-acetylmuramoyl-pentapeptide-transferase",
    "2.7.8.14\tCDP-ribitol ribitolphosphotransferase",
    "2.7.8.15\tUDP-N-acetylglucosamine--dolichyl-phosphate N-acetylglucosaminephosphotransferase",
    "2.7.8.17\tUDP-N-acetylglucosamine--lysosomal-enzyme N-acetylglucosaminephosphotransferase",
    "2.7.8.18\tUDP-galactose--UDP-N-acetylglucosamine galactose phosphotransferase",
    "2.7.8.19\tUDP-glucose--glycoprotein glucose phosphotransferase",
    "2.7.8.20\tPhosphatidylglycerol--membrane-oligosaccharide glycerophosphotransferase",
    "2.7.8.21\tMembrane-oligosaccharide glycerophosphotransferase",
    "2.7.8.22\t1-alkenyl-2-acylglycerol choline phosphotransferase",
    "2.7.8.23\tCarboxyvinyl-carboxyphosphonate phosphorylmutase",
    "2.7.8.24\tPhosphatidylcholine synthase",
    "2.7.8.26\tAdenosylcobinamide-GDP ribazoletransferase",
    "2.7.8.27\tSphingomyelin synthase",
    "2.7.8.28\t2-phospho-L-lactate transferase",
    "2.7.8.29\tL-serine-phosphatidylethanolamine phosphatidyltransferase",
    "2.7.8.31\tUndecaprenyl-phosphate glucose phosphotransferase",
    "2.7.8.32\t3-O-alpha-D-mannopyranosyl-alpha-D-mannopyranose xylosylphosphotransferase",
    "2.7.8.33\tUDP-N-acetylglucosamine--undecaprenyl-phosphate N-acetylglucosaminephosphotransferase",
    "2.7.8.34\tCDP-L-myo-inositol myo-inositolphosphotransferase",
    "2.7.8.35\tUDP-N-acetylglucosamine--decaprenyl-phosphate N-acetylglucosaminephosphotransferase",
    "2.7.8.36\tUndecaprenyl phosphate N,N'-diacetylbacillosamine 1-phosphate transferase",
    "2.7.8.37\tAlpha-D-ribose 1-methylphosphonate 5-triphosphate synthase",
    "2.7.8.38\tArchaetidylserine synthase",
    "2.7.8.39\tArchaetidylinositol phosphate synthase",
    "2.7.8.40\tUDP-N-acetylgalactosamine-undecaprenyl-phosphate N-acetylgalactosaminephosphotransferase",
    "2.7.8.41\tCardiolipin synthase (CMP-forming)",
    "2.7.8.42\tKdo(2)-lipid A phosphoethanolamine 7''-transferase",
    "2.7.8.43\tLipid A phosphoethanolamine transferase",
    "2.7.8.44\tTeichoic acid glycerol-phosphate primase",
    "2.7.8.45\tTeichoic acid glycerol-phosphate transferase",
    "2.7.8.46\tTeichoic acid ribitol-phosphate primase",
    "2.7.8.47\tTeichoic acid ribitol-phosphate polymerase",
    "2.7.8.n3\tCeramide phosphoethanolamine synthase",
    "2.7.9.1\tPyruvate, phosphate dikinase",
    "2.7.9.2\tPyruvate, water dikinase",
    "2.7.9.3\tSelenide, water dikinase",
    "2.7.9.4\tAlpha-glucan, water dikinase",
    "2.7.9.5\tPhosphoglucan, water dikinase",
    "2.7.9.6\tRifampicin phosphotransferase",
    "2.7.10.1\tReceptor protein-tyrosine kinase",
    "2.7.10.2\tNon-specific protein-tyrosine kinase",
    "2.7.11.1\tNon-specific serine/threonine protein kinase",
    "2.7.11.2\t[Pyruvate dehydrogenase (acetyl-transferring)] kinase",
    "2.7.11.3\tDephospho-[reductase kinase] kinase",
    "2.7.11.4\t[3-methyl-2-oxobutanoate dehydrogenase (acetyl-transferring)] kinase",
    "2.7.11.5\t[Isocitrate dehydrogenase (NADP(+))] kinase",
    "2.7.11.6\t[Tyrosine 3-monooxygenase] kinase",
    "2.7.11.7\t[Myosin heavy-chain] kinase",
    "2.7.11.8\tFas-activated serine/threonine kinase",
    "2.7.11.9\t[Goodpasture-antigen-binding protein] kinase",
    "2.7.11.10\tI-kappa-B kinase",
    "2.7.11.11\tcAMP-dependent protein kinase",
    "2.7.11.12\tcGMP-dependent protein kinase",
    "2.7.11.13\tProtein kinase C",
    "2.7.11.14\tRhodopsin kinase",
    "2.7.11.15\t[Beta-adrenergic-receptor] kinase",
    "2.7.11.16\t[G-protein-coupled receptor] kinase",
    "2.7.11.17\tCalcium/calmodulin-dependent protein kinase",
    "2.7.11.18\t[Myosin light-chain] kinase",
    "2.7.11.19\tPhosphorylase kinase",
    "2.7.11.20\t[Elongation factor 2] kinase",
    "2.7.11.21\tPolo kinase",
    "2.7.11.22\tCyclin-dependent kinase",
    "2.7.11.23\t[RNA-polymerase]-subunit kinase",
    "2.7.11.24\tMitogen-activated protein kinase",
    "2.7.11.25\tMitogen-activated protein kinase kinase kinase",
    "2.7.11.26\t[Tau protein] kinase",
    "2.7.11.27\t[Acetyl-CoA carboxylase] kinase",
    "2.7.11.28\tTropomyosin kinase",
    "2.7.11.29\t[Low-density-lipoprotein receptor] kinase",
    "2.7.11.30\tReceptor protein serine/threonine kinase",
    "2.7.11.31\t[Hydroxymethylglutaryl-CoA reductase (NADPH)] kinase",
    "2.7.11.32\t[Pyruvate, phosphate dikinase] kinase",
    "2.7.11.33\t[Pyruvate, water dikinase] kinase",
    "2.7.12.1\tDual-specificity kinase",
    "2.7.12.2\tMitogen-activated protein kinase kinase",
    "2.7.13.1\tProtein-histidine pros-kinase",
    "2.7.13.2\tProtein-histidine tele-kinase",
    "2.7.13.3\tHistidine kinase",
    "2.7.14.1\tProtein arginine kinase",
    "2.7.99.1\tTriphosphate--protein phosphotransferase",
    "2.8.1.1\tThiosulfate sulfurtransferase",
    "2.8.1.2\t3-mercaptopyruvate sulfurtransferase",
    "2.8.1.3\tThiosulfate--thiol sulfurtransferase",
    "2.8.1.4\ttRNA uracil 4-sulfurtransferase",
    "2.8.1.5\tThiosulfate--dithiol sulfurtransferase",
    "2.8.1.6\tBiotin synthase",
    "2.8.1.7\tCysteine desulfurase",
    "2.8.1.8\tLipoyl synthase",
    "2.8.1.9\tMolybdenum cofactor sulfurtransferase",
    "2.8.1.10\tThiazole synthase",
    "2.8.1.11\tMolybdopterin synthase sulfurtransferase",
    "2.8.1.12\tMolybdopterin synthase",
    "2.8.1.13\ttRNA-uridine 2-sulfurtransferase",
    "2.8.1.14\ttRNA-5-taurinomethyluridine 2-sulfurtransferase",
    "2.8.1.15\ttRNA-5-methyluridine(54) 2-sulfurtransferase",
    "2.8.1.16\tL-aspartate semialdehyde sulfurtransferase",
    "2.8.2.1\tAryl sulfotransferase",
    "2.8.2.2\tAlcohol sulfotransferase",
    "2.8.2.3\tAmine sulfotransferase",
    "2.8.2.4\tEstrone sulfotransferase",
    "2.8.2.5\tChondroitin 4-sulfotransferase",
    "2.8.2.6\tCholine sulfotransferase",
    "2.8.2.7\tUDP-N-acetylgalactosamine-4-sulfate sulfotransferase",
    "2.8.2.8\t[Heparan sulfate]-glucosamine N-sulfotransferase",
    "2.8.2.9\tTyrosine-ester sulfotransferase",
    "2.8.2.10\tRenilla-luciferin sulfotransferase",
    "2.8.2.11\tGalactosylceramide sulfotransferase",
    "2.8.2.13\tPsychosine sulfotransferase",
    "2.8.2.14\tBile-salt sulfotransferase",
    "2.8.2.15\tSteroid sulfotransferase",
    "2.8.2.16\tThiol sulfotransferase",
    "2.8.2.17\tChondroitin 6-sulfotransferase",
    "2.8.2.18\tCortisol sulfotransferase",
    "2.8.2.19\tTriglucosylalkylacylglycerol sulfotransferase",
    "2.8.2.20\tProtein-tyrosine sulfotransferase",
    "2.8.2.21\tKeratan sulfotransferase",
    "2.8.2.22\tAryl-sulfate sulfotransferase",
    "2.8.2.23\t[Heparan sulfate]-glucosamine 3-sulfotransferase 1",
    "2.8.2.24\tAromatic desulfoglucosinolate sulfotransferase",
    "2.8.2.25\tFlavonol 3-sulfotransferase",
    "2.8.2.26\tQuercetin-3-sulfate 3'-sulfotransferase",
    "2.8.2.27\tQuercetin-3-sulfate 4'-sulfotransferase",
    "2.8.2.28\tQuercetin-3,3'-bissulfate 7-sulfotransferase",
    "2.8.2.29\t[Heparan sulfate]-glucosamine 3-sulfotransferase 2",
    "2.8.2.30\t[Heparan sulfate]-glucosamine 3-sulfotransferase 3",
    "2.8.2.31\tPetromyzonol sulfotransferase",
    "2.8.2.32\tScymnol sulfotransferase",
    "2.8.2.33\tN-acetylgalactosamine 4-sulfate 6-O-sulfotransferase",
    "2.8.2.34\tGlycochenodeoxycholate sulfotransferase",
    "2.8.2.35\tDermatan 4-sulfotransferase",
    "2.8.2.36\tDesulfo-A47934 sulfotransferase",
    "2.8.2.37\tTrehalose 2-sulfotransferase",
    "2.8.2.38\tAliphatic desulfoglucosinolate sulfotransferase",
    "2.8.2.39\tHydroxyjasmonate sulfotransferase",
    "2.8.2.40\tOmega-hydroxy-beta-dihydromenaquinone-9 sulfotransferase",
    "2.8.2.n2\tThyroxine sulfotransferase",
    "2.8.3.1\tPropionate CoA-transferase",
    "2.8.3.2\tOxalate CoA-transferase",
    "2.8.3.3\tMalonate CoA-transferase",
    "2.8.3.5\t3-oxoacid CoA-transferase",
    "2.8.3.6\t3-oxoadipate CoA-transferase",
    "2.8.3.8\tAcetate CoA-transferase",
    "2.8.3.9\tButyrate--acetoacetate CoA-transferase",
    "2.8.3.10\tCitrate CoA-transferase",
    "2.8.3.11\tCitramalate CoA-transferase",
    "2.8.3.12\tGlutaconate CoA-transferase",
    "2.8.3.13\tSuccinate--hydroxymethylglutarate CoA-transferase",
    "2.8.3.14\t5-hydroxypentanoate CoA-transferase",
    "2.8.3.15\tSuccinyl-CoA:(R)-benzylsuccinate CoA-transferase",
    "2.8.3.16\tFormyl-CoA transferase",
    "2.8.3.17\t3-(aryl)acryloyl-CoA:(R)-3-(aryl)lactate CoA-transferase",
    "2.8.3.18\tSuccinyl-CoA:acetate CoA-transferase",
    "2.8.3.19\tCoA:oxalate CoA-transferase",
    "2.8.3.20\tSuccinyl-CoA--D-citramalate CoA-transferase",
    "2.8.3.21\tL-carnitine CoA-transferase",
    "2.8.3.22\tSuccinyl-CoA--L-malate CoA-transferase",
    "2.8.3.23\tCaffeate CoA-transferase",
    "2.8.3.24\t(R)-2-hydroxy-4-methylpentanoate CoA-transferase",
    "2.8.3.25\tBile acid CoA-transferase",
    "2.8.3.26\tSuccinyl-CoA:mesaconate CoA transferase",
    "2.8.4.1\tCoenzyme-B sulfoethylthiotransferase",
    "2.8.4.2\tArsenate-mycothiol transferase",
    "2.8.4.3\ttRNA-2-methylthio-N(6)-dimethylallyladenosine synthase",
    "2.8.4.4\t[Ribosomal protein S12] (aspartate(89)-C(3))-methylthiotransferase",
    "2.8.4.5\ttRNA (N(6)-L-threonylcarbamoyladenosine(37)-C(2))-methylthiotransferase",
    "2.8.5.1\tS-sulfo-L-cysteine synthase (3-phospho-L-serine-dependent)",
    "2.8.5.2\tL-cysteine S-thiosulfotransferase",
    "2.9.1.1\tL-seryl-tRNA(Sec) selenium transferase",
    "2.9.1.2\tO-phospho-L-seryl-tRNA(Sec):L-selenocysteinyl-tRNA synthase",
    "2.9.1.3\ttRNA 2-selenouridine synthase",
    "2.10.1.1\tMolybdopterin molybdotransferase",
    "3.1.1.1\tCarboxylesterase",
    "3.1.1.2\tArylesterase",
    "3.1.1.3\tTriacylglycerol lipase",
    "3.1.1.4\tPhospholipase A(2)",
    "3.1.1.5\tLysophospholipase",
    "3.1.1.6\tAcetylesterase",
    "3.1.1.7\tAcetylcholinesterase",
    "3.1.1.8\tCholinesterase",
    "3.1.1.10\tTropinesterase",
    "3.1.1.11\tPectinesterase",
    "3.1.1.13\tSterol esterase",
    "3.1.1.14\tChlorophyllase",
    "3.1.1.15\tL-arabinonolactonase",
    "3.1.1.17\tGluconolactonase",
    "3.1.1.19\tUronolactonase",
    "3.1.1.20\tTannase",
    "3.1.1.22\tHydroxybutyrate-dimer hydrolase",
    "3.1.1.23\tAcylglycerol lipase",
    "3.1.1.24\t3-oxoadipate enol-lactonase",
    "3.1.1.25\t1,4-lactonase",
    "3.1.1.26\tGalactolipase",
    "3.1.1.27\t4-pyridoxolactonase",
    "3.1.1.28\tAcylcarnitine hydrolase",
    "3.1.1.29\tAminoacyl-tRNA hydrolase",
    "3.1.1.30\tD-arabinonolactonase",
    "3.1.1.31\t6-phosphogluconolactonase",
    "3.1.1.32\tPhospholipase A(1)",
    "3.1.1.33\t6-acetylglucose deacetylase",
    "3.1.1.34\tLipoprotein lipase",
    "3.1.1.35\tDihydrocoumarin hydrolase",
    "3.1.1.36\tLimonin-D-ring-lactonase",
    "3.1.1.37\tSteroid-lactonase",
    "3.1.1.38\tTriacetate-lactonase",
    "3.1.1.39\tActinomycin lactonase",
    "3.1.1.40\tOrsellinate-depside hydrolase",
    "3.1.1.41\tCephalosporin-C deacetylase",
    "3.1.1.42\tChlorogenate hydrolase",
    "3.1.1.43\tAlpha-amino-acid esterase",
    "3.1.1.44\t4-methyloxaloacetate esterase",
    "3.1.1.45\tCarboxymethylenebutenolidase",
    "3.1.1.46\tDeoxylimonate A-ring-lactonase",
    "3.1.1.47\t1-alkyl-2-acetylglycerophosphocholine esterase",
    "3.1.1.48\tFusarinine-C ornithinesterase",
    "3.1.1.49\tSinapine esterase",
    "3.1.1.50\tWax-ester hydrolase",
    "3.1.1.51\tPhorbol-diester hydrolase",
    "3.1.1.52\tPhosphatidylinositol deacylase",
    "3.1.1.53\tSialate O-acetylesterase",
    "3.1.1.54\tAcetoxybutynylbithiophene deacetylase",
    "3.1.1.55\tAcetylsalicylate deacetylase",
    "3.1.1.56\tMethylumbelliferyl-acetate deacetylase",
    "3.1.1.57\t2-pyrone-4,6-dicarboxylate lactonase",
    "3.1.1.58\tN-acetylgalactosaminoglycan deacetylase",
    "3.1.1.59\tJuvenile-hormone esterase",
    "3.1.1.60\tBis(2-ethylhexyl)phthalate esterase",
    "3.1.1.61\tProtein-glutamate methylesterase",
    "3.1.1.63\t11-cis-retinyl-palmitate hydrolase",
    "3.1.1.64\tRetinoid isomerohydrolase",
    "3.1.1.65\tL-rhamnono-1,4-lactonase",
    "3.1.1.66\t5-(3,4-diacetoxybut-1-ynyl)-2,2'-bithiophene deacetylase",
    "3.1.1.67\tFatty-acyl-ethyl-ester synthase",
    "3.1.1.68\tXylono-1,4-lactonase",
    "3.1.1.70\tCetraxate benzylesterase",
    "3.1.1.71\tAcetylalkylglycerol acetylhydrolase",
    "3.1.1.72\tAcetylxylan esterase",
    "3.1.1.73\tFeruloyl esterase",
    "3.1.1.74\tCutinase",
    "3.1.1.75\tPoly(3-hydroxybutyrate) depolymerase",
    "3.1.1.76\tPoly(3-hydroxyoctanoate) depolymerase",
    "3.1.1.77\tAcyloxyacyl hydrolase",
    "3.1.1.78\tPolyneuridine-aldehyde esterase",
    "3.1.1.79\tHormone-sensitive lipase",
    "3.1.1.80\tAcetylajmaline esterase",
    "3.1.1.81\tQuorum-quenching N-acyl-homoserine lactonase",
    "3.1.1.82\tPheophorbidase",
    "3.1.1.83\tMonoterpene epsilon-lactone hydrolase",
    "3.1.1.84\tCocaine esterase",
    "3.1.1.85\tPimeloyl-[acyl-carrier protein] methyl ester esterase",
    "3.1.1.86\tRhamnogalacturonan acetylesterase",
    "3.1.1.87\tFumonisin B1 esterase",
    "3.1.1.88\tPyrethroid hydrolase",
    "3.1.1.89\tProtein phosphatase methylesterase-1",
    "3.1.1.90\tAll-trans-retinyl ester 13-cis isomerohydrolase",
    "3.1.1.91\t2-oxo-3-(5-oxofuran-2-ylidene)propanoate lactonase",
    "3.1.1.92\t4-sulfomuconolactone hydrolase",
    "3.1.1.93\tMycophenolic acid acyl-glucuronide esterase",
    "3.1.1.94\tVersiconal hemiacetal acetate esterase",
    "3.1.1.95\tAclacinomycin methylesterase",
    "3.1.1.96\tD-aminoacyl-tRNA deacylase",
    "3.1.1.97\tMethylated diphthine methylhydrolase",
    "3.1.1.98\t[Wnt protein] O-palmitoleoyl-L-serine hydrolase",
    "3.1.1.99\t6-deoxy-6-sulfogluconolactonase",
    "3.1.1.100\tChlorophyllide a hydrolase",
    "3.1.1.101\tPoly(ethylene terephthalate) hydrolase",
    "3.1.1.102\tMono(ethylene terephthalate) hydrolase",
    "3.1.1.103\tTeichoic acid D-alanine hydrolase",
    "3.1.1.104\t5-phospho-D-xylono-1,4-lactonase",
    "3.1.1.105\t3-O-acetylpapaveroxine carboxylesterase",
    "3.1.1.106\tO-acetyl-ADP-ribose deacetylase",
    "3.1.1.107\tApo-salmochelin esterase",
    "3.1.1.108\tIron(III) enterobactin esterase",
    "3.1.1.109\tIron(III) salmochelin esterase",
    "3.1.1.110\tXylono-1,5-lactonase",
    "3.1.1.111\tPhosphatidylserine sn-1 acylhydrolase",
    "3.1.1.112\tIsoamyl acetate esterase",
    "3.1.1.113\tEthyl acetate hydrolase",
    "3.1.1.114\tMethyl acetate hydrolase",
    "3.1.1.115\tD-apionolactonase",
    "3.1.1.116\tsn-1-specific diacylglycerol lipase",
    "3.1.1.117\t(4-O-methyl)-D-glucuronate--lignin esterase",
    "3.1.1.118\tPhospholipid sn-1 acylhydrolase",
    "3.1.1.n2\tProtein-S-isoprenylcysteine alpha-carbonyl methylesterase",
    "3.1.2.1\tAcetyl-CoA hydrolase",
    "3.1.2.2\tPalmitoyl-CoA hydrolase",
    "3.1.2.3\tSuccinyl-CoA hydrolase",
    "3.1.2.4\t3-hydroxyisobutyryl-CoA hydrolase",
    "3.1.2.5\tHydroxymethylglutaryl-CoA hydrolase",
    "3.1.2.6\tHydroxyacylglutathione hydrolase",
    "3.1.2.7\tGlutathione thiolesterase",
    "3.1.2.10\tFormyl-CoA hydrolase",
    "3.1.2.11\tAcetoacetyl-CoA hydrolase",
    "3.1.2.12\tS-formylglutathione hydrolase",
    "3.1.2.13\tS-succinylglutathione hydrolase",
    "3.1.2.14\tOleoyl-[acyl-carrier-protein] hydrolase",
    "3.1.2.16\tCitrate-lyase deacetylase",
    "3.1.2.17\t(S)-methylmalonyl-CoA hydrolase",
    "3.1.2.18\tADP-dependent short-chain-acyl-CoA hydrolase",
    "3.1.2.19\tADP-dependent medium-chain-acyl-CoA hydrolase",
    "3.1.2.20\tAcyl-CoA hydrolase",
    "3.1.2.21\tDodecanoyl-[acyl-carrier-protein] hydrolase",
    "3.1.2.22\tPalmitoyl-protein hydrolase",
    "3.1.2.23\t4-hydroxybenzoyl-CoA thioesterase",
    "3.1.2.25\tPhenylacetyl-CoA hydrolase",
    "3.1.2.27\tCholoyl-CoA hydrolase",
    "3.1.2.28\t1,4-dihydroxy-2-naphthoyl-CoA hydrolase",
    "3.1.2.29\tFluoroacetyl-CoA thioesterase",
    "3.1.2.30\t(3S)-malyl-CoA thioesterase",
    "3.1.2.31\tDihydromonacolin L-[lovastatin nonaketide synthase] thioesterase",
    "3.1.2.32\t2-aminobenzoylacetyl-CoA thioesterase",
    "3.1.3.1\tAlkaline phosphatase",
    "3.1.3.2\tAcid phosphatase",
    "3.1.3.3\tPhosphoserine phosphatase",
    "3.1.3.4\tPhosphatidate phosphatase",
    "3.1.3.5\t5'-nucleotidase",
    "3.1.3.6\t3'-nucleotidase",
    "3.1.3.7\t3'(2'),5'-bisphosphate nucleotidase",
    "3.1.3.8\t3-phytase",
    "3.1.3.9\tGlucose-6-phosphatase",
    "3.1.3.10\tGlucose-1-phosphatase",
    "3.1.3.11\tFructose-bisphosphatase",
    "3.1.3.12\tTrehalose-phosphatase",
    "3.1.3.14\tMethylphosphothioglycerate phosphatase",
    "3.1.3.15\tHistidinol-phosphatase",
    "3.1.3.16\tProtein-serine/threonine phosphatase",
    "3.1.3.17\t[Phosphorylase] phosphatase",
    "3.1.3.18\tPhosphoglycolate phosphatase",
    "3.1.3.19\tGlycerol-2-phosphatase",
    "3.1.3.20\tPhosphoglycerate phosphatase",
    "3.1.3.21\tGlycerol-1-phosphatase",
    "3.1.3.22\tMannitol-1-phosphatase",
    "3.1.3.23\tSugar-phosphatase",
    "3.1.3.24\tSucrose-phosphate phosphatase",
    "3.1.3.25\tInositol-phosphate phosphatase",
    "3.1.3.26\t4-phytase",
    "3.1.3.27\tPhosphatidylglycerophosphatase",
    "3.1.3.28\tADP-phosphoglycerate phosphatase",
    "3.1.3.29\tN-acylneuraminate-9-phosphatase",
    "3.1.3.32\tPolynucleotide 3'-phosphatase",
    "3.1.3.33\tPolynucleotide 5'-phosphatase",
    "3.1.3.34\tDeoxynucleotide 3'-phosphatase",
    "3.1.3.35\tThymidylate 5'-phosphatase",
    "3.1.3.36\tPhosphoinositide 5-phosphatase",
    "3.1.3.37\tSedoheptulose-bisphosphatase",
    "3.1.3.38\t3-phosphoglycerate phosphatase",
    "3.1.3.39\tStreptomycin-6-phosphatase",
    "3.1.3.40\tGuanidinodeoxy-scyllo-inositol-4-phosphatase",
    "3.1.3.41\t4-nitrophenylphosphatase",
    "3.1.3.42\t[Glycogen-synthase-D] phosphatase",
    "3.1.3.43\t[Pyruvate dehydrogenase (acetyl-transferring)]-phosphatase",
    "3.1.3.44\t[Acetyl-CoA carboxylase]-phosphatase",
    "3.1.3.45\t3-deoxy-manno-octulosonate-8-phosphatase",
    "3.1.3.46\tFructose-2,6-bisphosphate 2-phosphatase",
    "3.1.3.47\t[Hydroxymethylglutaryl-CoA reductase (NADPH)]-phosphatase",
    "3.1.3.48\tProtein-tyrosine-phosphatase",
    "3.1.3.49\t[Pyruvate kinase]-phosphatase",
    "3.1.3.50\tSorbitol-6-phosphatase",
    "3.1.3.51\tDolichyl-phosphatase",
    "3.1.3.52\t[3-methyl-2-oxobutanoate dehydrogenase (2-methylpropanoyl-transferring)]-phosphatase",
    "3.1.3.53\t[Myosin-light-chain] phosphatase",
    "3.1.3.54\tFructose-2,6-bisphosphate 6-phosphatase",
    "3.1.3.55\tCaldesmon-phosphatase",
    "3.1.3.56\tInositol-polyphosphate 5-phosphatase",
    "3.1.3.57\tInositol-1,4-bisphosphate 1-phosphatase",
    "3.1.3.58\tSugar-terminal-phosphatase",
    "3.1.3.59\tAlkylacetylglycerophosphatase",
    "3.1.3.60\tPhosphoenolpyruvate phosphatase",
    "3.1.3.62\tMultiple inositol-polyphosphate phosphatase",
    "3.1.3.63\t2-carboxy-D-arabinitol-1-phosphatase",
    "3.1.3.64\tPhosphatidylinositol-3-phosphatase",
    "3.1.3.66\tPhosphatidylinositol-3,4-bisphosphate 4-phosphatase",
    "3.1.3.67\tPhosphatidylinositol-3,4,5-trisphosphate 3-phosphatase",
    "3.1.3.68\t2-deoxyglucose-6-phosphatase",
    "3.1.3.69\tGlucosylglycerol 3-phosphatase",
    "3.1.3.70\tMannosyl-3-phosphoglycerate phosphatase",
    "3.1.3.71\t2-phosphosulfolactate phosphatase",
    "3.1.3.72\t5-phytase",
    "3.1.3.73\tAdenosylcobalamin/alpha-ribazole phosphatase",
    "3.1.3.74\tPyridoxal phosphatase",
    "3.1.3.75\tPhosphoethanolamine/phosphocholine phosphatase",
    "3.1.3.76\tLipid-phosphate phosphatase",
    "3.1.3.77\tAcireductone synthase",
    "3.1.3.78\tPhosphatidylinositol-4,5-bisphosphate 4-phosphatase",
    "3.1.3.79\tMannosylfructose-phosphate phosphatase",
    "3.1.3.80\t2,3-bisphosphoglycerate 3-phosphatase",
    "3.1.3.81\tDiacylglycerol diphosphate phosphatase",
    "3.1.3.82\tD-glycero-beta-D-manno-heptose 1,7-bisphosphate 7-phosphatase",
    "3.1.3.83\tD-glycero-alpha-D-manno-heptose-1,7-bisphosphate 7-phosphatase",
    "3.1.3.84\tADP-ribose 1''-phosphate phosphatase",
    "3.1.3.85\tGlucosyl-3-phosphoglycerate phosphatase",
    "3.1.3.86\tPhosphatidylinositol-3,4,5-trisphosphate 5-phosphatase",
    "3.1.3.87\t2-hydroxy-3-keto-5-methylthiopentenyl-1-phosphate phosphatase",
    "3.1.3.88\t5''-phosphoribostamycin phosphatase",
    "3.1.3.89\t5'-deoxynucleotidase",
    "3.1.3.90\tMaltose 6'-phosphate phosphatase",
    "3.1.3.91\t7-methylguanosine nucleotidase",
    "3.1.3.92\tKanosamine-6-phosphate phosphatase",
    "3.1.3.93\tL-galactose 1-phosphate phosphatase",
    "3.1.3.94\tD-galactose 1-phosphate phosphatase",
    "3.1.3.95\tPhosphatidylinositol-3,5-bisphosphate 3-phosphatase",
    "3.1.3.96\tPseudouridine 5'-phosphatase",
    "3.1.3.97\t3',5'-nucleoside bisphosphate phosphatase",
    "3.1.3.99\tIMP-specific 5'-nucleotidase",
    "3.1.3.100\tThiamine phosphate phosphatase",
    "3.1.3.101\tValidoxylamine A 7'-phosphate phosphatase",
    "3.1.3.102\tFMN hydrolase",
    "3.1.3.103\t3-deoxy-D-glycero-D-galacto-nonulopyranosonate 9-phosphatase",
    "3.1.3.104\t5-amino-6-(5-phospho-D-ribitylamino)uracil phosphatase",
    "3.1.3.105\tN-acetyl-D-muramate 6-phosphate phosphatase",
    "3.1.3.106\t2-lysophosphatidate phosphatase",
    "3.1.3.107\tAmicoumacin phosphatase",
    "3.1.3.108\tNocturnin",
    "3.1.4.1\tPhosphodiesterase I",
    "3.1.4.2\tGlycerophosphocholine phosphodiesterase",
    "3.1.4.3\tPhospholipase C",
    "3.1.4.4\tPhospholipase D",
    "3.1.4.11\tPhosphoinositide phospholipase C",
    "3.1.4.12\tSphingomyelin phosphodiesterase",
    "3.1.4.13\tSerine-ethanolaminephosphate phosphodiesterase",
    "3.1.4.14\t[Acyl-carrier-protein] phosphodiesterase",
    "3.1.4.16\t2',3'-cyclic-nucleotide 2'-phosphodiesterase",
    "3.1.4.17\t3',5'-cyclic-nucleotide phosphodiesterase",
    "3.1.4.35\t3',5'-cyclic-GMP phosphodiesterase",
    "3.1.4.37\t2',3'-cyclic-nucleotide 3'-phosphodiesterase",
    "3.1.4.38\tGlycerophosphocholine cholinephosphodiesterase",
    "3.1.4.39\tAlkylglycerophosphoethanolamine phosphodiesterase",
    "3.1.4.40\tCMP-N-acylneuraminate phosphodiesterase",
    "3.1.4.41\tSphingomyelin phosphodiesterase D",
    "3.1.4.42\tGlycerol-1,2-cyclic-phosphate 2-phosphodiesterase",
    "3.1.4.43\tGlycerophosphoinositol inositolphosphodiesterase",
    "3.1.4.44\tGlycerophosphoinositol glycerophosphodiesterase",
    "3.1.4.45\tN-acetylglucosamine-1-phosphodiester alpha-N-acetylglucosaminidase",
    "3.1.4.46\tGlycerophosphodiester phosphodiesterase",
    "3.1.4.48\tDolichylphosphate-glucose phosphodiesterase",
    "3.1.4.49\tDolichylphosphate-mannose phosphodiesterase",
    "3.1.4.50\tGlycosylphosphatidylinositol phospholipase D",
    "3.1.4.51\tGlucose-1-phospho-D-mannosylglycoprotein phosphodiesterase",
    "3.1.4.52\tCyclic-guanylate-specific phosphodiesterase",
    "3.1.4.53\t3',5'-cyclic-AMP phosphodiesterase",
    "3.1.4.54\tN-acetylphosphatidylethanolamine-hydrolyzing phospholipase D",
    "3.1.4.55\tPhosphoribosyl 1,2-cyclic phosphate phosphodiesterase",
    "3.1.4.56\t7,8-dihydroneopterin 2',3'-cyclic phosphate phosphodiesterase",
    "3.1.4.57\tPhosphoribosyl 1,2-cyclic phosphate 1,2-diphosphodiesterase",
    "3.1.4.58\tRNA 2',3'-cyclic 3'-phosphodiesterase",
    "3.1.4.59\tCyclic-di-AMP phosphodiesterase",
    "3.1.4.60\tPApA phosphodiesterase",
    "3.1.4.61\tCyclic 2,3-diphosphoglycerate hydrolase",
    "3.1.5.1\tdGTPase",
    "3.1.6.1\tArylsulfatase (type I)",
    "3.1.6.2\tSteryl-sulfatase",
    "3.1.6.3\tGlycosulfatase",
    "3.1.6.4\tN-acetylgalactosamine-6-sulfatase",
    "3.1.6.6\tCholine-sulfatase",
    "3.1.6.7\tCellulose-polysulfatase",
    "3.1.6.8\tCerebroside-sulfatase",
    "3.1.6.9\tChondro-4-sulfatase",
    "3.1.6.10\tChondro-6-sulfatase",
    "3.1.6.11\tDisulfoglucosamine-6-sulfatase",
    "3.1.6.12\tN-acetylgalactosamine-4-sulfatase",
    "3.1.6.13\tIduronate-2-sulfatase",
    "3.1.6.14\tN-acetylglucosamine-6-sulfatase",
    "3.1.6.15\tN-sulfoglucosamine-3-sulfatase",
    "3.1.6.16\tMonomethyl-sulfatase",
    "3.1.6.17\tD-lactate-2-sulfatase",
    "3.1.6.18\tGlucuronate-2-sulfatase",
    "3.1.6.19\t(R)-specific secondary-alkylsulfatase (type III)",
    "3.1.6.20\tS-sulfosulfanyl-L-cysteine sulfohydrolase",
    "3.1.6.21\tLinear primary-alkylsulfatase",
    "3.1.6.22\tBranched primary-alkylsulfatase",
    "3.1.7.1\tPrenyl-diphosphatase",
    "3.1.7.2\tGuanosine-3',5'-bis(diphosphate) 3'-diphosphatase",
    "3.1.7.3\tMonoterpenyl-diphosphatase",
    "3.1.7.5\tGeranylgeranyl diphosphate diphosphatase",
    "3.1.7.6\tFarnesyl diphosphatase",
    "3.1.7.9\tIsotuberculosinol synthase",
    "3.1.7.10\t(13E)-labda-7,13-dien-15-ol synthase",
    "3.1.7.11\tGeranyl diphosphate diphosphatase",
    "3.1.7.12\t(+)-kolavelool synthase",
    "3.1.8.1\tAryldialkylphosphatase",
    "3.1.8.2\tDiisopropyl-fluorophosphatase",
    "3.1.11.1\tExodeoxyribonuclease I",
    "3.1.11.2\tExodeoxyribonuclease III",
    "3.1.11.3\tExodeoxyribonuclease (lambda-induced)",
    "3.1.11.4\tExodeoxyribonuclease (phage SP3-induced)",
    "3.1.11.5\tExodeoxyribonuclease V",
    "3.1.11.6\tExodeoxyribonuclease VII",
    "3.1.12.1\t5' to 3' exodeoxyribonuclease (nucleoside 3'-phosphate-forming)",
    "3.1.13.1\tExoribonuclease II",
    "3.1.13.2\tExoribonuclease H",
    "3.1.13.3\tOligonucleotidase",
    "3.1.13.4\tPoly(A)-specific ribonuclease",
    "3.1.13.5\tRibonuclease D",
    "3.1.14.1\tYeast ribonuclease",
    "3.1.15.1\tVenom exonuclease",
    "3.1.16.1\tSpleen exonuclease",
    "3.1.21.1\tDeoxyribonuclease I",
    "3.1.21.2\tDeoxyribonuclease IV",
    "3.1.21.3\tType I site-specific deoxyribonuclease",
    "3.1.21.4\tType II site-specific deoxyribonuclease",
    "3.1.21.5\tType III site-specific deoxyribonuclease",
    "3.1.21.6\tCC-preferring endodeoxyribonuclease",
    "3.1.21.7\tDeoxyribonuclease V",
    "3.1.21.8\tT(4) deoxyribonuclease II",
    "3.1.21.9\tT(4) deoxyribonuclease IV",
    "3.1.21.10\tCrossover junction endodeoxyribonuclease",
    "3.1.22.1\tDeoxyribonuclease II",
    "3.1.22.2\tAspergillus deoxyribonuclease K(1)",
    "3.1.22.5\tDeoxyribonuclease X",
    "3.1.25.1\tDeoxyribonuclease (pyrimidine dimer)",
    "3.1.26.1\tPhysarum polycephalum ribonuclease",
    "3.1.26.2\tRibonuclease alpha",
    "3.1.26.3\tRibonuclease III",
    "3.1.26.4\tRibonuclease H",
    "3.1.26.5\tRibonuclease P",
    "3.1.26.6\tRibonuclease IV",
    "3.1.26.7\tRibonuclease P4",
    "3.1.26.8\tRibonuclease M5",
    "3.1.26.9\tRibonuclease (poly-(U)-specific)",
    "3.1.26.10\tRibonuclease IX",
    "3.1.26.11\tRibonuclease Z",
    "3.1.26.12\tRibonuclease E",
    "3.1.26.13\tRetroviral ribonuclease H",
    "3.1.26.n2\tArgonaute-2",
    "3.1.27.7\tRibonuclease F",
    "3.1.27.8\tRibonuclease V",
    "3.1.30.1\tAspergillus nuclease S(1)",
    "3.1.30.2\tSerratia marcescens nuclease",
    "3.1.31.1\tMicrococcal nuclease",
    "3.2.1.1\tAlpha-amylase",
    "3.2.1.2\tBeta-amylase",
    "3.2.1.3\tGlucan 1,4-alpha-glucosidase",
    "3.2.1.4\tCellulase",
    "3.2.1.6\tEndo-1,3(4)-beta-glucanase",
    "3.2.1.7\tInulinase",
    "3.2.1.8\tEndo-1,4-beta-xylanase",
    "3.2.1.10\tOligo-1,6-glucosidase",
    "3.2.1.11\tDextranase",
    "3.2.1.14\tChitinase",
    "3.2.1.15\tEndo-polygalacturonase",
    "3.2.1.17\tLysozyme",
    "3.2.1.18\tExo-alpha-sialidase",
    "3.2.1.20\tAlpha-glucosidase",
    "3.2.1.21\tBeta-glucosidase",
    "3.2.1.22\tAlpha-galactosidase",
    "3.2.1.23\tBeta-galactosidase",
    "3.2.1.24\tAlpha-mannosidase",
    "3.2.1.25\tBeta-mannosidase",
    "3.2.1.26\tBeta-fructofuranosidase",
    "3.2.1.28\tAlpha,alpha-trehalase",
    "3.2.1.31\tBeta-glucuronidase",
    "3.2.1.32\tEndo-1,3-beta-xylanase",
    "3.2.1.33\tAmylo-alpha-1,6-glucosidase",
    "3.2.1.35\tHyaluronoglucosaminidase",
    "3.2.1.36\tHyaluronoglucuronidase",
    "3.2.1.37\tXylan 1,4-beta-xylosidase",
    "3.2.1.38\tBeta-D-fucosidase",
    "3.2.1.39\tGlucan endo-1,3-beta-D-glucosidase",
    "3.2.1.40\tAlpha-L-rhamnosidase",
    "3.2.1.41\tPullulanase",
    "3.2.1.42\tGDP-glucosidase",
    "3.2.1.43\tBeta-L-rhamnosidase",
    "3.2.1.45\tGlucosylceramidase",
    "3.2.1.46\tGalactosylceramidase",
    "3.2.1.47\tGalactosylgalactosylglucosylceramidase",
    "3.2.1.48\tSucrose alpha-glucosidase",
    "3.2.1.49\tAlpha-N-acetylgalactosaminidase",
    "3.2.1.50\tAlpha-N-acetylglucosaminidase",
    "3.2.1.51\tAlpha-L-fucosidase",
    "3.2.1.52\tBeta-N-acetylhexosaminidase",
    "3.2.1.53\tBeta-N-acetylgalactosaminidase",
    "3.2.1.54\tCyclomaltodextrinase",
    "3.2.1.55\tNon-reducing end alpha-L-arabinofuranosidase",
    "3.2.1.56\tGlucuronosyl-disulfoglucosamine glucuronidase",
    "3.2.1.57\tIsopullulanase",
    "3.2.1.58\tGlucan 1,3-beta-glucosidase",
    "3.2.1.59\tGlucan endo-1,3-alpha-glucosidase",
    "3.2.1.60\tGlucan 1,4-alpha-maltotetraohydrolase",
    "3.2.1.61\tMycodextranase",
    "3.2.1.62\tGlycosylceramidase",
    "3.2.1.63\t1,2-alpha-L-fucosidase",
    "3.2.1.64\t2,6-beta-fructan 6-levanbiohydrolase",
    "3.2.1.65\tLevanase",
    "3.2.1.66\tQuercitrinase",
    "3.2.1.67\tGalacturonan 1,4-alpha-galacturonidase",
    "3.2.1.68\tIsoamylase",
    "3.2.1.70\tGlucan 1,6-alpha-glucosidase",
    "3.2.1.71\tGlucan endo-1,2-beta-glucosidase",
    "3.2.1.72\tXylan 1,3-beta-xylosidase",
    "3.2.1.73\tLicheninase",
    "3.2.1.74\tGlucan 1,4-beta-glucosidase",
    "3.2.1.75\tGlucan endo-1,6-beta-glucosidase",
    "3.2.1.76\tL-iduronidase",
    "3.2.1.77\tMannan 1,2-(1,3)-alpha-mannosidase",
    "3.2.1.78\tMannan endo-1,4-beta-mannosidase",
    "3.2.1.80\tFructan beta-fructosidase",
    "3.2.1.81\tBeta-agarase",
    "3.2.1.82\tExo-poly-alpha-digalacturonosidase",
    "3.2.1.83\tKappa-carrageenase",
    "3.2.1.84\tGlucan 1,3-alpha-glucosidase",
    "3.2.1.85\t6-phospho-beta-galactosidase",
    "3.2.1.86\t6-phospho-beta-glucosidase",
    "3.2.1.87\tCapsular-polysaccharide endo-1,3-alpha-galactosidase",
    "3.2.1.88\tNon-reducing end beta-L-arabinopyranosidase",
    "3.2.1.89\tArabinogalactan endo-beta-1,4-galactanase",
    "3.2.1.91\tCellulose 1,4-beta-cellobiosidase (non-reducing end)",
    "3.2.1.92\tPeptidoglycan beta-N-acetylmuramidase",
    "3.2.1.93\tAlpha,alpha-phosphotrehalase",
    "3.2.1.94\tGlucan 1,6-alpha-isomaltosidase",
    "3.2.1.95\tDextran 1,6-alpha-isomaltotriosidase",
    "3.2.1.96\tMannosyl-glycoprotein endo-beta-N-acetylglucosaminidase",
    "3.2.1.97\tEndo-alpha-N-acetylgalactosaminidase",
    "3.2.1.98\tGlucan 1,4-alpha-maltohexaosidase",
    "3.2.1.99\tArabinan endo-1,5-alpha-L-arabinosidase",
    "3.2.1.100\tMannan 1,4-mannobiosidase",
    "3.2.1.101\tMannan endo-1,6-alpha-mannosidase",
    "3.2.1.102\tBlood-group-substance endo-1,4-beta-galactosidase",
    "3.2.1.103\tKeratan-sulfate endo-1,4-beta-galactosidase",
    "3.2.1.104\tSteryl-beta-glucosidase",
    "3.2.1.105\t3-alpha-(S)-strictosidine beta-glucosidase",
    "3.2.1.106\tMannosyl-oligosaccharide glucosidase",
    "3.2.1.107\tProtein-glucosylgalactosylhydroxylysine glucosidase",
    "3.2.1.108\tLactase",
    "3.2.1.109\tEndogalactosaminidase",
    "3.2.1.111\t1,3-alpha-L-fucosidase",
    "3.2.1.112\t2-deoxyglucosidase",
    "3.2.1.113\tMannosyl-oligosaccharide 1,2-alpha-mannosidase",
    "3.2.1.114\tMannosyl-oligosaccharide 1,3-1,6-alpha-mannosidase",
    "3.2.1.115\tBranched-dextran exo-1,2-alpha-glucosidase",
    "3.2.1.116\tGlucan 1,4-alpha-maltotriohydrolase",
    "3.2.1.117\tAmygdalin beta-glucosidase",
    "3.2.1.118\tPrunasin beta-glucosidase",
    "3.2.1.119\tVicianin beta-glucosidase",
    "3.2.1.120\tOligoxyloglucan beta-glycosidase",
    "3.2.1.121\tPolymannuronate hydrolase",
    "3.2.1.122\tMaltose-6'-phosphate glucosidase",
    "3.2.1.123\tEndoglycosylceramidase",
    "3.2.1.124\t3-deoxy-2-octulosonidase",
    "3.2.1.125\tRaucaffricine beta-glucosidase",
    "3.2.1.126\tConiferin beta-glucosidase",
    "3.2.1.127\t1,6-alpha-L-fucosidase",
    "3.2.1.128\tGlycyrrhizinate beta-glucuronidase",
    "3.2.1.129\tEndo-alpha-sialidase",
    "3.2.1.130\tGlycoprotein endo-alpha-1,2-mannosidase",
    "3.2.1.131\tXylan alpha-1,2-glucuronosidase",
    "3.2.1.132\tChitosanase",
    "3.2.1.133\tGlucan 1,4-alpha-maltohydrolase",
    "3.2.1.134\tDifructose-anhydride-I synthase",
    "3.2.1.135\tNeopullulanase",
    "3.2.1.136\tGlucuronoarabinoxylan endo-1,4-beta-xylanase",
    "3.2.1.137\tMannan exo-1,2-1,6-alpha-mannosidase",
    "3.2.1.139\tAlpha-glucuronidase",
    "3.2.1.140\tLacto-N-biosidase",
    "3.2.1.141\t4-alpha-D-((1->4)-alpha-D-glucano)trehalose trehalohydrolase",
    "3.2.1.142\tLimit dextrinase",
    "3.2.1.143\tPoly(ADP-ribose) glycohydrolase",
    "3.2.1.144\t3-deoxyoctulosonase",
    "3.2.1.145\tGalactan 1,3-beta-galactosidase",
    "3.2.1.146\tBeta-galactofuranosidase",
    "3.2.1.147\tThioglucosidase",
    "3.2.1.149\tBeta-primeverosidase",
    "3.2.1.150\tOligoxyloglucan reducing-end-specific cellobiohydrolase",
    "3.2.1.151\tXyloglucan-specific endo-beta-1,4-glucanase",
    "3.2.1.152\tMannosylglycoprotein endo-beta-mannosidase",
    "3.2.1.153\tFructan beta-(2,1)-fructosidase",
    "3.2.1.154\tFructan beta-(2,6)-fructosidase",
    "3.2.1.155\tXyloglucan-specific endo-processive beta-1,4-glucanase",
    "3.2.1.156\tOligosaccharide reducing-end xylanase",
    "3.2.1.157\tIota-carrageenase",
    "3.2.1.158\tAlpha-agarase",
    "3.2.1.159\tAlpha-neoagaro-oligosaccharide hydrolase",
    "3.2.1.161\tBeta-apiosyl-beta-glucosidase",
    "3.2.1.162\tLambda-carrageenase",
    "3.2.1.163\t1,6-alpha-D-mannosidase",
    "3.2.1.164\tGalactan endo-1,6-beta-galactosidase",
    "3.2.1.165\tExo-1,4-beta-D-glucosaminidase",
    "3.2.1.166\tHeparanase",
    "3.2.1.167\tBaicalin-beta-D-glucuronidase",
    "3.2.1.168\tHesperidin 6-O-alpha-L-rhamnosyl-beta-D-glucosidase",
    "3.2.1.169\tProtein O-GlcNAcase",
    "3.2.1.170\tMannosylglycerate hydrolase",
    "3.2.1.171\tRhamnogalacturonan hydrolase",
    "3.2.1.172\tUnsaturated rhamnogalacturonyl hydrolase",
    "3.2.1.173\tRhamnogalacturonan galacturonohydrolase",
    "3.2.1.174\tRhamnogalacturonan rhamnohydrolase",
    "3.2.1.175\tBeta-D-glucopyranosyl abscisate beta-glucosidase",
    "3.2.1.176\tCellulose 1,4-beta-cellobiosidase (reducing end)",
    "3.2.1.177\tAlpha-D-xyloside xylohydrolase",
    "3.2.1.178\tBeta-porphyranase",
    "3.2.1.179\tGellan tetrasaccharide unsaturated glucuronosyl hydrolase",
    "3.2.1.180\tUnsaturated chondroitin disaccharide hydrolase",
    "3.2.1.181\tGalactan endo-beta-1,3-galactanase",
    "3.2.1.182\t4-hydroxy-7-methoxy-3-oxo-3,4-dihydro-2H-1,4-benzoxazin-2-yl glucoside beta-D-glucosidase",
    "3.2.1.183\tUDP-N-acetylglucosamine 2-epimerase (hydrolyzing)",
    "3.2.1.184\tUDP-N,N'-diacetylbacillosamine 2-epimerase (hydrolyzing)",
    "3.2.1.185\tNon-reducing end beta-L-arabinofuranosidase",
    "3.2.1.186\tProtodioscin 26-O-beta-D-glucosidase",
    "3.2.1.187\t(Ara-f)(3)-Hyp beta-L-arabinobiosidase",
    "3.2.1.188\tAvenacosidase",
    "3.2.1.189\tDioscin glycosidase (diosgenin-forming)",
    "3.2.1.190\tDioscin glycosidase (3-O-beta-D-Glc-diosgenin-forming)",
    "3.2.1.191\tGinsenosidase type III",
    "3.2.1.192\tGinsenoside Rb1 beta-glucosidase",
    "3.2.1.193\tGinsenosidase type I",
    "3.2.1.194\tGinsenosidase type IV",
    "3.2.1.195\t20-O-multi-glycoside ginsenosidase",
    "3.2.1.196\tLimit dextrin alpha-1,6-maltotetraose-hydrolase",
    "3.2.1.197\tBeta-1,2-mannosidase",
    "3.2.1.198\tAlpha-mannan endo-1,2-alpha-mannanase",
    "3.2.1.199\tSulfoquinovosidase",
    "3.2.1.200\tExo-chitinase (non-reducing end)",
    "3.2.1.201\tExo-chitinase (reducing end)",
    "3.2.1.202\tEndo-chitodextinase",
    "3.2.1.203\tCarboxymethylcellulase",
    "3.2.1.204\t1,3-alpha-isomaltosidase",
    "3.2.1.205\tIsomaltose glucohydrolase",
    "3.2.1.206\tOleuropein beta-glucosidase",
    "3.2.1.207\tMannosyl-oligosaccharide alpha-1,3-glucosidase",
    "3.2.1.208\tGlucosylglycerate hydrolase",
    "3.2.1.209\tEndoplasmic reticulum Man(9)GlcNAc(2) 1,2-alpha-mannosidase",
    "3.2.1.210\tEndoplasmic reticulum Man(8)GlcNAc(2) 1,2-alpha-mannosidase",
    "3.2.1.211\tEndo-(1->3)-fucoidanase",
    "3.2.1.212\tEndo-(1->4)-fucoidanase",
    "3.2.1.213\tGalactan exo-1,6-beta-galactobiohydrolase (non-reducing end)",
    "3.2.1.214\tExo beta-1,2-glucooligosaccharide sophorohydrolase (non-reducing end)",
    "3.2.1.n1\tBlood group B branched chain alpha-1,3-galactosidase",
    "3.2.1.n2\tBlood group B linear chain alpha-1,3-galactosidase",
    "3.2.1.n3\tDictyostelium lysozyme A",
    "3.2.2.1\tPurine nucleosidase",
    "3.2.2.2\tInosine nucleosidase",
    "3.2.2.3\tUridine nucleosidase",
    "3.2.2.4\tAMP nucleosidase",
    "3.2.2.5\tNAD(+) glycohydrolase",
    "3.2.2.6\tADP-ribosyl cyclase/cyclic ADP-ribose hydrolase",
    "3.2.2.7\tAdenosine nucleosidase",
    "3.2.2.8\tRibosylpyrimidine nucleosidase",
    "3.2.2.9\tAdenosylhomocysteine nucleosidase",
    "3.2.2.10\tPyrimidine-5'-nucleotide nucleosidase",
    "3.2.2.11\tBeta-aspartyl-N-acetylglucosaminidase",
    "3.2.2.12\tInosinate nucleosidase",
    "3.2.2.13\t1-methyladenosine nucleosidase",
    "3.2.2.14\tNMN nucleosidase",
    "3.2.2.15\tDNA-deoxyinosine glycosylase",
    "3.2.2.16\tMethylthioadenosine nucleosidase",
    "3.2.2.17\tDeoxyribodipyrimidine endonucleosidase",
    "3.2.2.19\t[Protein ADP-ribosylarginine] hydrolase",
    "3.2.2.20\tDNA-3-methyladenine glycosylase I",
    "3.2.2.21\tDNA-3-methyladenine glycosylase II",
    "3.2.2.22\trRNA N-glycosylase",
    "3.2.2.23\tDNA-formamidopyrimidine glycosylase",
    "3.2.2.24\tADP-ribosyl-[dinitrogen reductase] hydrolase",
    "3.2.2.25\tN-methyl nucleosidase",
    "3.2.2.26\tFutalosine hydrolase",
    "3.2.2.27\tUracil-DNA glycosylase",
    "3.2.2.28\tDouble-stranded uracil-DNA glycosylase",
    "3.2.2.29\tThymine-DNA glycosylase",
    "3.2.2.30\tAminodeoxyfutalosine nucleosidase",
    "3.2.2.31\tAdenine glycosylase",
    "3.2.2.n1\tCytokinin riboside 5'-monophosphate phosphoribohydrolase",
    "3.3.1.1\tAdenosylhomocysteinase",
    "3.3.1.2\tS-adenosyl-L-methionine hydrolase (L-homoserine-forming)",
    "3.3.2.1\tIsochorismatase",
    "3.3.2.2\tLysoplasmalogenase",
    "3.3.2.4\tTrans-epoxysuccinate hydrolase",
    "3.3.2.6\tLeukotriene-A(4) hydrolase",
    "3.3.2.7\tHepoxilin-epoxide hydrolase",
    "3.3.2.8\tLimonene-1,2-epoxide hydrolase",
    "3.3.2.9\tMicrosomal epoxide hydrolase",
    "3.3.2.10\tSoluble epoxide hydrolase",
    "3.3.2.11\tCholesterol-5,6-oxide hydrolase",
    "3.3.2.12\tOxepin-CoA hydrolase",
    "3.3.2.13\tChorismatase",
    "3.3.2.14\t2,4-dinitroanisole O-demethylase",
    "3.3.2.15\tTrans-2,3-dihydro-3-hydroxyanthranilic acid synthase",
    "3.4.11.1\tLeucyl aminopeptidase",
    "3.4.11.2\tMembrane alanyl aminopeptidase",
    "3.4.11.3\tCystinyl aminopeptidase",
    "3.4.11.4\tTripeptide aminopeptidase",
    "3.4.11.5\tProlyl aminopeptidase",
    "3.4.11.6\tAminopeptidase B",
    "3.4.11.7\tGlutamyl aminopeptidase",
    "3.4.11.9\tXaa-Pro aminopeptidase",
    "3.4.11.10\tBacterial leucyl aminopeptidase",
    "3.4.11.13\tClostridial aminopeptidase",
    "3.4.11.14\tCytosol alanyl aminopeptidase",
    "3.4.11.15\tAminopeptidase Y",
    "3.4.11.16\tXaa-Trp aminopeptidase",
    "3.4.11.17\tTryptophanyl aminopeptidase",
    "3.4.11.18\tMethionyl aminopeptidase",
    "3.4.11.19\tD-stereospecific aminopeptidase",
    "3.4.11.20\tAminopeptidase Ey",
    "3.4.11.21\tAspartyl aminopeptidase",
    "3.4.11.22\tAminopeptidase I",
    "3.4.11.23\tPepB aminopeptidase",
    "3.4.11.24\tAminopeptidase S",
    "3.4.11.25\tBeta-peptidyl aminopeptidase",
    "3.4.11.26\tIntermediate cleaving peptidase 55",
    "3.4.13.4\tXaa-Arg dipeptidase",
    "3.4.13.5\tXaa-methyl-His dipeptidase",
    "3.4.13.7\tGlu-Glu dipeptidase",
    "3.4.13.9\tXaa-Pro dipeptidase",
    "3.4.13.12\tMet-Xaa dipeptidase",
    "3.4.13.17\tNon-stereospecific dipeptidase",
    "3.4.13.18\tCytosol nonspecific dipeptidase",
    "3.4.13.19\tMembrane dipeptidase",
    "3.4.13.20\tBeta-Ala-His dipeptidase",
    "3.4.13.21\tDipeptidase E",
    "3.4.13.22\tD-Ala-D-Ala dipeptidase",
    "3.4.13.23\tCysteinylglycine-S-conjugate dipeptidase",
    "3.4.14.1\tDipeptidyl-peptidase I",
    "3.4.14.2\tDipeptidyl-peptidase II",
    "3.4.14.4\tDipeptidyl-peptidase III",
    "3.4.14.5\tDipeptidyl-peptidase IV",
    "3.4.14.6\tDipeptidyl-dipeptidase",
    "3.4.14.9\tTripeptidyl-peptidase I",
    "3.4.14.10\tTripeptidyl-peptidase II",
    "3.4.14.11\tXaa-Pro dipeptidyl-peptidase",
    "3.4.14.12\tXaa-Xaa-Pro tripeptidyl-peptidase",
    "3.4.14.13\tGamma-D-glutamyl-L-lysine dipeptidyl-peptidase",
    "3.4.14.14\t[Mycofactocin precursor peptide] peptidase",
    "3.4.15.1\tPeptidyl-dipeptidase A",
    "3.4.15.4\tPeptidyl-dipeptidase B",
    "3.4.15.5\tPeptidyl-dipeptidase Dcp",
    "3.4.15.6\tCyanophycinase",
    "3.4.16.2\tLysosomal Pro-Xaa carboxypeptidase",
    "3.4.16.4\tSerine-type D-Ala-D-Ala carboxypeptidase",
    "3.4.16.5\tCarboxypeptidase C",
    "3.4.16.6\tCarboxypeptidase D",
    "3.4.17.1\tCarboxypeptidase A",
    "3.4.17.2\tCarboxypeptidase B",
    "3.4.17.3\tLysine carboxypeptidase",
    "3.4.17.4\tGly-Xaa carboxypeptidase",
    "3.4.17.6\tAlanine carboxypeptidase",
    "3.4.17.8\tMuramoylpentapeptide carboxypeptidase",
    "3.4.17.10\tCarboxypeptidase E",
    "3.4.17.11\tGlutamate carboxypeptidase",
    "3.4.17.12\tCarboxypeptidase M",
    "3.4.17.13\tMuramoyltetrapeptide carboxypeptidase",
    "3.4.17.14\tZinc D-Ala-D-Ala carboxypeptidase",
    "3.4.17.15\tCarboxypeptidase A2",
    "3.4.17.16\tMembrane Pro-Xaa carboxypeptidase",
    "3.4.17.17\tTubulinyl-Tyr carboxypeptidase",
    "3.4.17.18\tCarboxypeptidase T",
    "3.4.17.19\tCarboxypeptidase Taq",
    "3.4.17.20\tCarboxypeptidase U",
    "3.4.17.21\tGlutamate carboxypeptidase II",
    "3.4.17.22\tMetallocarboxypeptidase D",
    "3.4.17.23\tAngiotensin-converting enzyme 2",
    "3.4.17.24\tTubulin-glutamate carboxypeptidase",
    "3.4.18.1\tCathepsin X",
    "3.4.19.1\tAcylaminoacyl-peptidase",
    "3.4.19.2\tPeptidyl-glycinamidase",
    "3.4.19.3\tPyroglutamyl-peptidase I",
    "3.4.19.5\tBeta-aspartyl-peptidase",
    "3.4.19.6\tPyroglutamyl-peptidase II",
    "3.4.19.7\tN-formylmethionyl-peptidase",
    "3.4.19.9\tFolate gamma-glutamyl hydrolase",
    "3.4.19.11\tGamma-D-glutamyl-meso-diaminopimelate peptidase",
    "3.4.19.12\tUbiquitinyl hydrolase 1",
    "3.4.19.13\tGlutathione gamma-glutamate hydrolase",
    "3.4.19.14\tLeukotriene-C(4) hydrolase",
    "3.4.19.15\tDesampylase",
    "3.4.19.16\tGlucosinolate gamma-glutamyl hydrolase",
    "3.4.21.1\tChymotrypsin",
    "3.4.21.2\tChymotrypsin C",
    "3.4.21.3\tMetridin",
    "3.4.21.4\tTrypsin",
    "3.4.21.5\tThrombin",
    "3.4.21.6\tCoagulation factor Xa",
    "3.4.21.7\tPlasmin",
    "3.4.21.9\tEnteropeptidase",
    "3.4.21.10\tAcrosin",
    "3.4.21.12\tAlpha-lytic endopeptidase",
    "3.4.21.19\tGlutamyl endopeptidase",
    "3.4.21.20\tCathepsin G",
    "3.4.21.21\tCoagulation factor VIIa",
    "3.4.21.22\tCoagulation factor IXa",
    "3.4.21.25\tCucumisin",
    "3.4.21.26\tProlyl oligopeptidase",
    "3.4.21.27\tCoagulation factor XIa",
    "3.4.21.32\tBrachyurin",
    "3.4.21.34\tPlasma kallikrein",
    "3.4.21.35\tTissue kallikrein",
    "3.4.21.36\tPancreatic elastase",
    "3.4.21.37\tLeukocyte elastase",
    "3.4.21.38\tCoagulation factor XIIa",
    "3.4.21.39\tChymase",
    "3.4.21.41\tComplement subcomponent C1r",
    "3.4.21.42\tComplement subcomponent C1s",
    "3.4.21.43\tClassical-complement-pathway C3/C5 convertase",
    "3.4.21.45\tComplement factor I",
    "3.4.21.46\tComplement factor D",
    "3.4.21.47\tAlternative-complement-pathway C3/C5 convertase",
    "3.4.21.48\tCerevisin",
    "3.4.21.49\tHypodermin C",
    "3.4.21.50\tLysyl endopeptidase",
    "3.4.21.53\tEndopeptidase La",
    "3.4.21.54\tGamma-renin",
    "3.4.21.55\tVenombin AB",
    "3.4.21.57\tLeucyl endopeptidase",
    "3.4.21.59\tTryptase",
    "3.4.21.60\tScutelarin",
    "3.4.21.61\tKexin",
    "3.4.21.62\tSubtilisin",
    "3.4.21.63\tOryzin",
    "3.4.21.64\tPeptidase K",
    "3.4.21.65\tThermomycolin",
    "3.4.21.66\tThermitase",
    "3.4.21.67\tEndopeptidase So",
    "3.4.21.68\tT-plasminogen activator",
    "3.4.21.69\tProtein C (activated)",
    "3.4.21.70\tPancreatic endopeptidase E",
    "3.4.21.71\tPancreatic elastase II",
    "3.4.21.72\tIgA-specific serine endopeptidase",
    "3.4.21.73\tU-plasminogen activator",
    "3.4.21.74\tVenombin A",
    "3.4.21.75\tFurin",
    "3.4.21.76\tMyeloblastin",
    "3.4.21.77\tSemenogelase",
    "3.4.21.78\tGranzyme A",
    "3.4.21.79\tGranzyme B",
    "3.4.21.80\tStreptogrisin A",
    "3.4.21.81\tStreptogrisin B",
    "3.4.21.82\tGlutamyl endopeptidase II",
    "3.4.21.83\tOligopeptidase B",
    "3.4.21.84\tLimulus clotting factor C",
    "3.4.21.85\tLimulus clotting factor B",
    "3.4.21.86\tLimulus clotting enzyme",
    "3.4.21.88\tRepressor LexA",
    "3.4.21.89\tSignal peptidase I",
    "3.4.21.90\tTogavirin",
    "3.4.21.91\tFlavivirin",
    "3.4.21.92\tEndopeptidase Clp",
    "3.4.21.93\tProprotein convertase 1",
    "3.4.21.94\tProprotein convertase 2",
    "3.4.21.95\tSnake venom factor V activator",
    "3.4.21.96\tLactocepin",
    "3.4.21.97\tAssemblin",
    "3.4.21.98\tHepacivirin",
    "3.4.21.99\tSpermosin",
    "3.4.21.100\tSedolisin",
    "3.4.21.101\tXanthomonalisin",
    "3.4.21.102\tC-terminal processing peptidase",
    "3.4.21.103\tPhysarolisin",
    "3.4.21.104\tMannan-binding lectin-associated serine protease-2",
    "3.4.21.105\tRhomboid protease",
    "3.4.21.106\tHepsin",
    "3.4.21.107\tPeptidase Do",
    "3.4.21.108\tHtrA2 peptidase",
    "3.4.21.109\tMatriptase",
    "3.4.21.110\tC5a peptidase",
    "3.4.21.111\tAqualysin 1",
    "3.4.21.112\tSite-1 protease",
    "3.4.21.113\tPestivirus NS3 polyprotein peptidase",
    "3.4.21.114\tEquine arterivirus serine peptidase",
    "3.4.21.115\tInfectious pancreatic necrosis birnavirus Vp4 peptidase",
    "3.4.21.116\tSpoIVB peptidase",
    "3.4.21.117\tStratum corneum chymotryptic enzyme",
    "3.4.21.118\tKallikrein 8",
    "3.4.21.119\tKallikrein 13",
    "3.4.21.120\tOviductin",
    "3.4.21.121\tLys-Lys/Arg-Xaa endopeptidase",
    "3.4.22.1\tCathepsin B",
    "3.4.22.2\tPapain",
    "3.4.22.3\tFicain",
    "3.4.22.6\tChymopapain",
    "3.4.22.7\tAsclepain",
    "3.4.22.8\tClostripain",
    "3.4.22.10\tStreptopain",
    "3.4.22.14\tActinidain",
    "3.4.22.15\tCathepsin L",
    "3.4.22.16\tCathepsin H",
    "3.4.22.24\tCathepsin T",
    "3.4.22.25\tGlycyl endopeptidase",
    "3.4.22.26\tCancer procoagulant",
    "3.4.22.27\tCathepsin S",
    "3.4.22.28\tPicornain 3C",
    "3.4.22.29\tPicornain 2A",
    "3.4.22.30\tCaricain",
    "3.4.22.31\tAnanain",
    "3.4.22.32\tStem bromelain",
    "3.4.22.33\tFruit bromelain",
    "3.4.22.34\tLegumain",
    "3.4.22.35\tHistolysain",
    "3.4.22.36\tCaspase-1",
    "3.4.22.37\tGingipain R",
    "3.4.22.38\tCathepsin K",
    "3.4.22.39\tAdenain",
    "3.4.22.40\tBleomycin hydrolase",
    "3.4.22.41\tCathepsin F",
    "3.4.22.42\tCathepsin O",
    "3.4.22.43\tCathepsin V",
    "3.4.22.44\tNuclear-inclusion-a endopeptidase",
    "3.4.22.45\tHelper-component proteinase",
    "3.4.22.46\tL-peptidase",
    "3.4.22.47\tGingipain K",
    "3.4.22.48\tStaphopain",
    "3.4.22.49\tSeparase",
    "3.4.22.50\tV-cath endopeptidase",
    "3.4.22.51\tCruzipain",
    "3.4.22.52\tCalpain-1",
    "3.4.22.53\tCalpain-2",
    "3.4.22.54\tCalpain-3",
    "3.4.22.55\tCaspase-2",
    "3.4.22.56\tCaspase-3",
    "3.4.22.57\tCaspase-4",
    "3.4.22.58\tCaspase-5",
    "3.4.22.59\tCaspase-6",
    "3.4.22.60\tCaspase-7",
    "3.4.22.61\tCaspase-8",
    "3.4.22.62\tCaspase-9",
    "3.4.22.63\tCaspase-10",
    "3.4.22.64\tCaspase-11",
    "3.4.22.65\tPeptidase 1 (mite)",
    "3.4.22.66\tCalicivirin",
    "3.4.22.67\tZingipain",
    "3.4.22.68\tUlp1 peptidase",
    "3.4.22.69\tSARS coronavirus main proteinase",
    "3.4.22.70\tSortase A",
    "3.4.22.71\tSortase B",
    "3.4.23.1\tPepsin A",
    "3.4.23.2\tPepsin B",
    "3.4.23.3\tGastricsin",
    "3.4.23.4\tChymosin",
    "3.4.23.5\tCathepsin D",
    "3.4.23.12\tNepenthesin",
    "3.4.23.15\tRenin",
    "3.4.23.16\tHIV-1 retropepsin",
    "3.4.23.17\tPro-opiomelanocortin converting enzyme",
    "3.4.23.18\tAspergillopepsin I",
    "3.4.23.19\tAspergillopepsin II",
    "3.4.23.20\tPenicillopepsin",
    "3.4.23.21\tRhizopuspepsin",
    "3.4.23.22\tEndothiapepsin",
    "3.4.23.23\tMucorpepsin",
    "3.4.23.24\tCandidapepsin",
    "3.4.23.25\tSaccharopepsin",
    "3.4.23.26\tRhodotorulapepsin",
    "3.4.23.28\tAcrocylindropepsin",
    "3.4.23.29\tPolyporopepsin",
    "3.4.23.30\tPycnoporopepsin",
    "3.4.23.31\tScytalidopepsin A",
    "3.4.23.32\tScytalidopepsin B",
    "3.4.23.34\tCathepsin E",
    "3.4.23.35\tBarrierpepsin",
    "3.4.23.36\tSignal peptidase II",
    "3.4.23.38\tPlasmepsin I",
    "3.4.23.39\tPlasmepsin II",
    "3.4.23.40\tPhytepsin",
    "3.4.23.41\tYapsin 1",
    "3.4.23.42\tThermopsin",
    "3.4.23.43\tPrepilin peptidase",
    "3.4.23.44\tNodavirus endopeptidase",
    "3.4.23.45\tMemapsin 1",
    "3.4.23.46\tMemapsin 2",
    "3.4.23.47\tHIV-2 retropepsin",
    "3.4.23.48\tPlasminogen activator Pla",
    "3.4.23.49\tOmptin",
    "3.4.23.50\tHuman endogenous retrovirus K endopeptidase",
    "3.4.23.51\tHycI peptidase",
    "3.4.23.52\tPreflagellin peptidase",
    "3.4.24.1\tAtrolysin A",
    "3.4.24.3\tMicrobial collagenase",
    "3.4.24.6\tLeucolysin",
    "3.4.24.7\tInterstitial collagenase",
    "3.4.24.11\tNeprilysin",
    "3.4.24.12\tEnvelysin",
    "3.4.24.13\tIgA-specific metalloendopeptidase",
    "3.4.24.14\tProcollagen N-endopeptidase",
    "3.4.24.15\tThimet oligopeptidase",
    "3.4.24.16\tNeurolysin",
    "3.4.24.17\tStromelysin 1",
    "3.4.24.18\tMeprin A",
    "3.4.24.19\tProcollagen C-endopeptidase",
    "3.4.24.20\tPeptidyl-Lys metalloendopeptidase",
    "3.4.24.21\tAstacin",
    "3.4.24.22\tStromelysin 2",
    "3.4.24.23\tMatrilysin",
    "3.4.24.24\tGelatinase A",
    "3.4.24.25\tVibriolysin",
    "3.4.24.26\tPseudolysin",
    "3.4.24.27\tThermolysin",
    "3.4.24.28\tBacillolysin",
    "3.4.24.29\tAureolysin",
    "3.4.24.30\tCoccolysin",
    "3.4.24.31\tMycolysin",
    "3.4.24.32\tBeta-lytic metalloendopeptidase",
    "3.4.24.33\tPeptidyl-Asp metalloendopeptidase",
    "3.4.24.34\tNeutrophil collagenase",
    "3.4.24.35\tGelatinase B",
    "3.4.24.36\tLeishmanolysin",
    "3.4.24.37\tSaccharolysin",
    "3.4.24.38\tGametolysin",
    "3.4.24.39\tDeuterolysin",
    "3.4.24.40\tSerralysin",
    "3.4.24.41\tAtrolysin B",
    "3.4.24.42\tAtrolysin C",
    "3.4.24.43\tAtroxase",
    "3.4.24.44\tAtrolysin E",
    "3.4.24.45\tAtrolysin F",
    "3.4.24.46\tAdamalysin",
    "3.4.24.47\tHorrilysin",
    "3.4.24.48\tRuberlysin",
    "3.4.24.49\tBothropasin",
    "3.4.24.50\tBothrolysin",
    "3.4.24.51\tOphiolysin",
    "3.4.24.52\tTrimerelysin I",
    "3.4.24.53\tTrimerelysin II",
    "3.4.24.54\tMucrolysin",
    "3.4.24.55\tPitrilysin",
    "3.4.24.56\tInsulysin",
    "3.4.24.57\tO-sialoglycoprotein endopeptidase",
    "3.4.24.58\tRussellysin",
    "3.4.24.59\tMitochondrial intermediate peptidase",
    "3.4.24.60\tDactylysin",
    "3.4.24.61\tNardilysin",
    "3.4.24.62\tMagnolysin",
    "3.4.24.63\tMeprin B",
    "3.4.24.64\tMitochondrial processing peptidase",
    "3.4.24.65\tMacrophage elastase",
    "3.4.24.66\tChoriolysin L",
    "3.4.24.67\tChoriolysin H",
    "3.4.24.68\tTentoxilysin",
    "3.4.24.69\tBontoxilysin",
    "3.4.24.70\tOligopeptidase A",
    "3.4.24.71\tEndothelin-converting enzyme 1",
    "3.4.24.72\tFibrolase",
    "3.4.24.73\tJararhagin",
    "3.4.24.74\tFragilysin",
    "3.4.24.75\tLysostaphin",
    "3.4.24.76\tFlavastacin",
    "3.4.24.77\tSnapalysin",
    "3.4.24.78\tGPR endopeptidase",
    "3.4.24.79\tPappalysin-1",
    "3.4.24.80\tMembrane-type matrix metalloproteinase-1",
    "3.4.24.81\tADAM10 endopeptidase",
    "3.4.24.82\tADAMTS-4 endopeptidase",
    "3.4.24.83\tAnthrax lethal factor endopeptidase",
    "3.4.24.84\tSte24 endopeptidase",
    "3.4.24.85\tS2P endopeptidase",
    "3.4.24.86\tADAM 17 endopeptidase",
    "3.4.24.87\tADAMTS13 endopeptidase",
    "3.4.24.89\tPro-Pro endopeptidase",
    "3.4.25.1\tProteasome endopeptidase complex",
    "3.4.25.2\tHslU--HslV peptidase",
    "3.5.1.1\tAsparaginase",
    "3.5.1.2\tGlutaminase",
    "3.5.1.3\tOmega-amidase",
    "3.5.1.4\tAmidase",
    "3.5.1.5\tUrease",
    "3.5.1.6\tBeta-ureidopropionase",
    "3.5.1.7\tUreidosuccinase",
    "3.5.1.8\tFormylaspartate deformylase",
    "3.5.1.9\tArylformamidase",
    "3.5.1.10\tFormyltetrahydrofolate deformylase",
    "3.5.1.11\tPenicillin amidase",
    "3.5.1.12\tBiotinidase",
    "3.5.1.13\tAryl-acylamidase",
    "3.5.1.14\tN-acyl-aliphatic-L-amino acid amidohydrolase",
    "3.5.1.15\tAspartoacylase",
    "3.5.1.16\tAcetylornithine deacetylase",
    "3.5.1.17\tAcyl-lysine deacylase",
    "3.5.1.18\tSuccinyl-diaminopimelate desuccinylase",
    "3.5.1.19\tNicotinamidase",
    "3.5.1.20\tCitrullinase",
    "3.5.1.21\tN-acetyl-beta-alanine deacetylase",
    "3.5.1.22\tPantothenase",
    "3.5.1.23\tCeramidase",
    "3.5.1.24\tCholoylglycine hydrolase",
    "3.5.1.25\tN-acetylglucosamine-6-phosphate deacetylase",
    "3.5.1.26\tN(4)-(beta-N-acetylglucosaminyl)-L-asparaginase",
    "3.5.1.28\tN-acetylmuramoyl-L-alanine amidase",
    "3.5.1.29\t2-(acetamidomethylene)succinate hydrolase",
    "3.5.1.30\t5-aminopentanamidase",
    "3.5.1.31\tFormylmethionine deformylase",
    "3.5.1.32\tHippurate hydrolase",
    "3.5.1.33\tN-acetylglucosamine deacetylase",
    "3.5.1.35\tD-glutaminase",
    "3.5.1.36\tN-methyl-2-oxoglutaramate hydrolase",
    "3.5.1.38\tGlutamin-(asparagin-)ase",
    "3.5.1.39\tAlkylamidase",
    "3.5.1.40\tAcylagmatine amidase",
    "3.5.1.41\tChitin deacetylase",
    "3.5.1.42\tNicotinamide-nucleotide amidase",
    "3.5.1.43\tPeptidyl-glutaminase",
    "3.5.1.44\tProtein-glutamine glutaminase",
    "3.5.1.46\t6-aminohexanoate-oligomer exohydrolase",
    "3.5.1.47\tN-acetyldiaminopimelate deacetylase",
    "3.5.1.48\tAcetylspermidine deacetylase",
    "3.5.1.49\tFormamidase",
    "3.5.1.50\tPentanamidase",
    "3.5.1.51\t4-acetamidobutyryl-CoA deacetylase",
    "3.5.1.52\tPeptide-N(4)-(N-acetyl-beta-glucosaminyl)asparagine amidase",
    "3.5.1.53\tN-carbamoylputrescine amidase",
    "3.5.1.54\tAllophanate hydrolase",
    "3.5.1.55\tLong-chain-fatty-acyl-glutamate deacylase",
    "3.5.1.56\tN,N-dimethylformamidase",
    "3.5.1.57\tTryptophanamidase",
    "3.5.1.58\tN-benzyloxycarbonylglycine hydrolase",
    "3.5.1.59\tN-carbamoylsarcosine amidase",
    "3.5.1.60\tN-(long-chain-acyl)ethanolamine deacylase",
    "3.5.1.61\tMimosinase",
    "3.5.1.62\tAcetylputrescine deacetylase",
    "3.5.1.63\t4-acetamidobutyrate deacetylase",
    "3.5.1.64\tN(alpha)-benzyloxycarbonylleucine hydrolase",
    "3.5.1.65\tTheanine hydrolase",
    "3.5.1.66\t2-(hydroxymethyl)-3-(acetamidomethylene)succinate hydrolase",
    "3.5.1.67\t4-methyleneglutaminase",
    "3.5.1.68\tN-formylglutamate deformylase",
    "3.5.1.69\tGlycosphingolipid deacylase",
    "3.5.1.70\tAculeacin-A deacylase",
    "3.5.1.71\tN-feruloylglycine deacylase",
    "3.5.1.72\tD-benzoylarginine-4-nitroanilide amidase",
    "3.5.1.73\tCarnitinamidase",
    "3.5.1.74\tChenodeoxycholoyltaurine hydrolase",
    "3.5.1.75\tUrethanase",
    "3.5.1.76\tArylalkyl acylamidase",
    "3.5.1.77\tN-carbamoyl-D-amino-acid hydrolase",
    "3.5.1.78\tGlutathionylspermidine amidase",
    "3.5.1.79\tPhthalyl amidase",
    "3.5.1.81\tN-acyl-D-amino-acid deacylase",
    "3.5.1.82\tN-acyl-D-glutamate deacylase",
    "3.5.1.83\tN-acyl-D-aspartate deacylase",
    "3.5.1.84\tBiuret amidohydrolase",
    "3.5.1.85\t(S)-N-acetyl-1-phenylethylamine hydrolase",
    "3.5.1.86\tMandelamide amidase",
    "3.5.1.87\tN-carbamoyl-L-amino-acid hydrolase",
    "3.5.1.88\tPeptide deformylase",
    "3.5.1.89\tN-acetylglucosaminylphosphatidylinositol deacetylase",
    "3.5.1.90\tAdenosylcobinamide hydrolase",
    "3.5.1.91\tN-substituted formamide deformylase",
    "3.5.1.92\tPantetheine hydrolase",
    "3.5.1.93\tGlutaryl-7-aminocephalosporanic-acid acylase",
    "3.5.1.94\tGamma-glutamyl-gamma-aminobutyrate hydrolase",
    "3.5.1.95\tN-malonylurea hydrolase",
    "3.5.1.96\tSuccinylglutamate desuccinylase",
    "3.5.1.97\tAcyl-homoserine-lactone acylase",
    "3.5.1.98\tHistone deacetylase",
    "3.5.1.99\tFatty acid amide hydrolase",
    "3.5.1.100\t(R)-amidase",
    "3.5.1.101\tL-proline amide hydrolase",
    "3.5.1.102\t2-amino-5-formylamino-6-ribosylaminopyrimidin-4(3H)-one 5'-monophosphate deformylase",
    "3.5.1.103\tN-acetyl-1-D-myo-inositol-2-amino-2-deoxy-alpha-D-glucopyranoside deacetylase",
    "3.5.1.104\tPeptidoglycan-N-acetylglucosamine deacetylase",
    "3.5.1.105\tChitin disaccharide deacetylase",
    "3.5.1.106\tN-formylmaleamate deformylase",
    "3.5.1.107\tMaleamate amidohydrolase",
    "3.5.1.108\tUDP-3-O-acyl-N-acetylglucosamine deacetylase",
    "3.5.1.109\tSphingomyelin deacylase",
    "3.5.1.110\tUreidoacrylate amidohydrolase",
    "3.5.1.111\t2-oxoglutaramate amidase",
    "3.5.1.112\t2'-N-acetylparomamine deacetylase",
    "3.5.1.113\t2'''-acetyl-6'''-hydroxyneomycin C deacetylase",
    "3.5.1.114\tN-acyl-aromatic-L-amino acid amidohydrolase",
    "3.5.1.115\tMycothiol S-conjugate amidase",
    "3.5.1.116\tUreidoglycolate amidohydrolase",
    "3.5.1.117\t6-aminohexanoate-oligomer endohydrolase",
    "3.5.1.118\tGamma-glutamyl hercynylcysteine S-oxide hydrolase",
    "3.5.1.119\tPup amidohydrolase",
    "3.5.1.121\tProtein N-terminal asparagine amidohydrolase",
    "3.5.1.122\tProtein N-terminal glutamine amidohydrolase",
    "3.5.1.123\tGamma-glutamylanilide hydrolase",
    "3.5.1.124\tProtein deglycase",
    "3.5.1.125\tN(2)-acetyl-L-2,4-diaminobutanoate deacetylase",
    "3.5.1.126\tOxamate amidohydrolase",
    "3.5.1.127\tJasmonoyl-L-amino acid hydrolase",
    "3.5.1.128\tDeaminated glutathione amidase",
    "3.5.1.129\tN(5)-(cytidine 5'-diphosphoramidyl)-L-glutamine hydrolase",
    "3.5.1.130\t[Amino group carrier protein]-lysine hydrolase",
    "3.5.1.131\t1-carboxybiuret hydrolase",
    "3.5.1.132\t[Amino group carrier protein]-ornithine hydrolase",
    "3.5.1.133\tN(alpha)-acyl-L-glutamine aminoacylase",
    "3.5.1.134\t(Indol-3-yl)acetyl-L-aspartate hydrolase",
    "3.5.1.135\tN(4)-acetylcytidine amidohydrolase",
    "3.5.1.136\tN,N'-diacetylchitobiose non-reducing end deacetylase",
    "3.5.1.n3\t4-deoxy-4-formamido-L-arabinose-phosphoundecaprenol deformylase",
    "3.5.2.1\tBarbiturase",
    "3.5.2.2\tDihydropyrimidinase",
    "3.5.2.3\tDihydroorotase",
    "3.5.2.4\tCarboxymethylhydantoinase",
    "3.5.2.5\tAllantoinase",
    "3.5.2.6\tBeta-lactamase",
    "3.5.2.7\tImidazolonepropionase",
    "3.5.2.9\t5-oxoprolinase (ATP-hydrolyzing)",
    "3.5.2.10\tCreatininase",
    "3.5.2.11\tL-lysine-lactamase",
    "3.5.2.12\t6-aminohexanoate-cyclic-dimer hydrolase",
    "3.5.2.13\t2,5-dioxopiperazine hydrolase",
    "3.5.2.14\tN-methylhydantoinase (ATP-hydrolyzing)",
    "3.5.2.15\tCyanuric acid amidohydrolase",
    "3.5.2.16\tMaleimide hydrolase",
    "3.5.2.17\tHydroxyisourate hydrolase",
    "3.5.2.18\tEnamidase",
    "3.5.2.19\tStreptothricin hydrolase",
    "3.5.2.20\tIsatin hydrolase",
    "3.5.3.1\tArginase",
    "3.5.3.2\tGuanidinoacetase",
    "3.5.3.3\tCreatinase",
    "3.5.3.4\tAllantoicase",
    "3.5.3.5\tFormimidoylaspartate deiminase",
    "3.5.3.6\tArginine deiminase",
    "3.5.3.7\tGuanidinobutyrase",
    "3.5.3.8\tFormimidoylglutamase",
    "3.5.3.9\tAllantoate deiminase",
    "3.5.3.10\tD-arginase",
    "3.5.3.11\tAgmatinase",
    "3.5.3.12\tAgmatine deiminase",
    "3.5.3.13\tFormimidoylglutamate deiminase",
    "3.5.3.14\tAmidinoaspartase",
    "3.5.3.15\tProtein-arginine deiminase",
    "3.5.3.16\tMethylguanidinase",
    "3.5.3.17\tGuanidinopropionase",
    "3.5.3.18\tDimethylargininase",
    "3.5.3.20\tDiguanidinobutanase",
    "3.5.3.21\tMethylenediurea deaminase",
    "3.5.3.22\tProclavaminate amidinohydrolase",
    "3.5.3.23\tN-succinylarginine dihydrolase",
    "3.5.3.24\tN(1)-aminopropylagmatine ureohydrolase",
    "3.5.3.25\tN(omega)-hydroxy-L-arginine amidinohydrolase",
    "3.5.3.26\t(S)-ureidoglycine aminohydrolase",
    "3.5.4.1\tCytosine deaminase",
    "3.5.4.2\tAdenine deaminase",
    "3.5.4.3\tGuanine deaminase",
    "3.5.4.4\tAdenosine deaminase",
    "3.5.4.5\tCytidine deaminase",
    "3.5.4.6\tAMP deaminase",
    "3.5.4.7\tADP deaminase",
    "3.5.4.8\tAminoimidazolase",
    "3.5.4.9\tMethenyltetrahydrofolate cyclohydrolase",
    "3.5.4.10\tIMP cyclohydrolase",
    "3.5.4.11\tPterin deaminase",
    "3.5.4.12\tdCMP deaminase",
    "3.5.4.13\tdCTP deaminase",
    "3.5.4.15\tGuanosine deaminase",
    "3.5.4.16\tGTP cyclohydrolase I",
    "3.5.4.17\tAdenosine-phosphate deaminase",
    "3.5.4.18\tATP deaminase",
    "3.5.4.19\tPhosphoribosyl-AMP cyclohydrolase",
    "3.5.4.20\tPyrithiamine deaminase",
    "3.5.4.21\tCreatinine deaminase",
    "3.5.4.22\t1-pyrroline-4-hydroxy-2-carboxylate deaminase",
    "3.5.4.23\tBlasticidin-S deaminase",
    "3.5.4.24\tSepiapterin deaminase",
    "3.5.4.25\tGTP cyclohydrolase II",
    "3.5.4.26\tDiaminohydroxyphosphoribosylaminopyrimidine deaminase",
    "3.5.4.27\tMethenyltetrahydromethanopterin cyclohydrolase",
    "3.5.4.28\tS-adenosylhomocysteine deaminase",
    "3.5.4.29\tGTP cyclohydrolase IIa",
    "3.5.4.30\tdCTP deaminase (dUMP-forming)",
    "3.5.4.31\tS-methyl-5'-thioadenosine deaminase",
    "3.5.4.32\t8-oxoguanine deaminase",
    "3.5.4.33\ttRNA(adenine(34)) deaminase",
    "3.5.4.34\ttRNA(Ala)(adenine(37)) deaminase",
    "3.5.4.35\ttRNA(cytosine(8)) deaminase",
    "3.5.4.36\tmRNA(cytosine(6666)) deaminase",
    "3.5.4.37\tDouble-stranded RNA adenine deaminase",
    "3.5.4.38\tSingle-stranded DNA cytosine deaminase",
    "3.5.4.39\tGTP cyclohydrolase IV",
    "3.5.4.40\tAminodeoxyfutalosine deaminase",
    "3.5.4.41\t5'-deoxyadenosine deaminase",
    "3.5.4.42\tN-isopropylammelide isopropylaminohydrolase",
    "3.5.4.43\tHydroxydechloroatrazine ethylaminohydrolase",
    "3.5.4.44\tEctoine hydrolase",
    "3.5.4.45\tMelamine deaminase",
    "3.5.4.46\tcAMP deaminase",
    "3.5.5.1\tNitrilase",
    "3.5.5.2\tRicinine nitrilase",
    "3.5.5.4\tCyanoalanine nitrilase",
    "3.5.5.5\tArylacetonitrilase",
    "3.5.5.6\tBromoxynil nitrilase",
    "3.5.5.7\tAliphatic nitrilase",
    "3.5.5.8\tThiocyanate hydrolase",
    "3.5.99.1\tRiboflavinase",
    "3.5.99.2\tAminopyrimidine aminohydrolase",
    "3.5.99.5\t2-aminomuconate deaminase",
    "3.5.99.6\tGlucosamine-6-phosphate deaminase",
    "3.5.99.7\t1-aminocyclopropane-1-carboxylate deaminase",
    "3.5.99.8\t5-nitroanthranilic acid aminohydrolase",
    "3.5.99.9\t2-nitroimidazole nitrohydrolase",
    "3.5.99.10\t2-iminobutanoate/2-iminopropanoate deaminase",
    "3.5.99.11\t2-aminomuconate deaminase (2-hydroxymuconate-forming)",
    "3.6.1.1\tInorganic diphosphatase",
    "3.6.1.2\tTrimetaphosphatase",
    "3.6.1.5\tApyrase",
    "3.6.1.6\tNucleoside diphosphate phosphatase",
    "3.6.1.7\tAcylphosphatase",
    "3.6.1.8\tATP diphosphatase",
    "3.6.1.9\tNucleotide diphosphatase",
    "3.6.1.10\tEndopolyphosphatase",
    "3.6.1.11\tExopolyphosphatase",
    "3.6.1.12\tdCTP diphosphatase",
    "3.6.1.13\tADP-ribose diphosphatase",
    "3.6.1.14\tAdenosine-tetraphosphatase",
    "3.6.1.15\tNucleoside-triphosphate phosphatase",
    "3.6.1.16\tCDP-glycerol diphosphatase",
    "3.6.1.17\tBis(5'-nucleosyl)-tetraphosphatase (asymmetrical)",
    "3.6.1.18\tFAD diphosphatase",
    "3.6.1.20\t5'-acylphosphoadenosine hydrolase",
    "3.6.1.21\tADP-sugar diphosphatase",
    "3.6.1.22\tNAD(+) diphosphatase",
    "3.6.1.23\tdUTP diphosphatase",
    "3.6.1.24\tNucleoside phosphoacylhydrolase",
    "3.6.1.25\tTriphosphatase",
    "3.6.1.26\tCDP-diacylglycerol diphosphatase",
    "3.6.1.27\tUndecaprenyl-diphosphate phosphatase",
    "3.6.1.28\tThiamine-triphosphatase",
    "3.6.1.29\tBis(5'-adenosyl)-triphosphatase",
    "3.6.1.31\tPhosphoribosyl-ATP diphosphatase",
    "3.6.1.39\tThymidine-triphosphatase",
    "3.6.1.40\tGuanosine-5'-triphosphate,3'-diphosphate diphosphatase",
    "3.6.1.41\tBis(5'-nucleosyl)-tetraphosphatase (symmetrical)",
    "3.6.1.42\tGuanosine-diphosphatase",
    "3.6.1.43\tDolichyldiphosphatase",
    "3.6.1.44\tOligosaccharide-diphosphodolichol diphosphatase",
    "3.6.1.45\tUDP-sugar diphosphatase",
    "3.6.1.52\tDiphosphoinositol-polyphosphate diphosphatase",
    "3.6.1.53\tMn(2+)-dependent ADP-ribose/CDP-alcohol diphosphatase",
    "3.6.1.54\tUDP-2,3-diacylglucosamine diphosphatase",
    "3.6.1.55\t8-oxo-dGTP diphosphatase",
    "3.6.1.56\t2-hydroxy-dATP diphosphatase",
    "3.6.1.57\tUDP-2,4-diacetamido-2,4,6-trideoxy-beta-L-altropyranose hydrolase",
    "3.6.1.58\t8-oxo-dGDP phosphatase",
    "3.6.1.59\t5'-(N(7)-methyl 5'-triphosphoguanosine)-[mRNA] diphosphatase",
    "3.6.1.60\tDiadenosine hexaphosphate hydrolase (AMP-forming)",
    "3.6.1.61\tDiadenosine hexaphosphate hydrolase (ATP-forming)",
    "3.6.1.62\t5'-(N(7)-methylguanosine 5'-triphospho)-[mRNA] hydrolase",
    "3.6.1.63\tAlpha-D-ribose 1-methylphosphonate 5-triphosphate diphosphatase",
    "3.6.1.64\tInosine diphosphate phosphatase",
    "3.6.1.65\t(d)CTP diphosphatase",
    "3.6.1.66\tXTP/dITP diphosphatase",
    "3.6.1.67\tDihydroneopterin triphosphate diphosphatase",
    "3.6.1.68\tGeranyl diphosphate phosphohydrolase",
    "3.6.1.69\t8-oxo-(d)GTP phosphatase",
    "3.6.1.70\tGuaosine-5'-diphospho-5'-(DNA) diphosphatase",
    "3.6.1.71\tAdenosine-5'-diphospho-5'-(DNA) diphosphatase",
    "3.6.1.72\tDNA-3'-diphospho-5'-guanosine diphosphatase",
    "3.6.1.73\tInosine/xanthosine triphosphatase",
    "3.6.1.74\tmRNA 5'-phosphatase",
    "3.6.1.n1\tD-tyrosyl-tRNA(Tyr) hydrolase",
    "3.6.1.n2\tL-cysteinyl-tRNA(Pro)",
    "3.6.1.n3\tL-cysteinyl-tRNA(Cys) hydrolase",
    "3.6.2.1\tAdenylylsulfatase",
    "3.6.2.2\tPhosphoadenylylsulfatase",
    "3.6.4.6\tVesicle-fusing ATPase",
    "3.6.4.7\tPeroxisome-assembly ATPase",
    "3.6.4.10\tNon-chaperonin molecular chaperone ATPase",
    "3.6.4.12\tDNA helicase",
    "3.6.4.13\tRNA helicase",
    "3.6.5.1\tHeterotrimeric G-protein GTPase",
    "3.6.5.2\tSmall monomeric GTPase",
    "3.6.5.3\tProtein-synthesizing GTPase",
    "3.6.5.4\tSignal-recognition-particle GTPase",
    "3.6.5.5\tDynamin GTPase",
    "3.6.5.6\tTubulin GTPase",
    "3.6.5.n1\tElongation factor 4",
    "3.7.1.1\tOxaloacetase",
    "3.7.1.2\tFumarylacetoacetase",
    "3.7.1.3\tKynureninase",
    "3.7.1.4\tPhloretin hydrolase",
    "3.7.1.5\tAcylpyruvate hydrolase",
    "3.7.1.6\tAcetylpyruvate hydrolase",
    "3.7.1.7\tBeta-diketone hydrolase",
    "3.7.1.8\t2,6-dioxo-6-phenylhexa-3-enoate hydrolase",
    "3.7.1.9\t2-hydroxymuconate-6-semialdehyde hydrolase",
    "3.7.1.10\tCyclohexane-1,3-dione hydrolase",
    "3.7.1.11\tCyclohexane-1,2-dione hydrolase",
    "3.7.1.12\tCobalt-precorrin 5A hydrolase",
    "3.7.1.13\t2-hydroxy-6-oxo-6-(2-aminophenyl)hexa-2,4-dienoate hydrolase",
    "3.7.1.14\t2-hydroxy-6-oxonona-2,4-dienedioate hydrolase",
    "3.7.1.17\t4,5-9,10-diseco-3-hydroxy-5,9,17-trioxoandrosta-1(10),2-diene-4-oate hydrolase",
    "3.7.1.18\t6-oxocamphor hydrolase",
    "3.7.1.19\t2,6-dihydroxypseudooxynicotine hydrolase",
    "3.7.1.20\t3-fumarylpyruvate hydrolase",
    "3.7.1.21\t6-oxocyclohex-1-ene-1-carbonyl-CoA hydratase",
    "3.7.1.22\t3D-(3,5/4)-trihydroxycyclohexane-1,2-dione acylhydrolase (decyclizing)",
    "3.7.1.23\tMaleylpyruvate hydrolase",
    "3.7.1.24\t2,4-diacetylphloroglucinol hydrolase",
    "3.7.1.25\t2-hydroxy-6-oxohepta-2,4-dienoate hydrolase",
    "3.7.1.26\t2,4-didehydro-3-deoxy-L-rhamnonate hydrolase",
    "3.7.1.27\tNeryl diphosphate diphosphatase",
    "3.7.1.28\t3-oxoisoapionate-4-phosphate transcarboxylase/hydrolase",
    "3.8.1.2\t(S)-2-haloacid dehalogenase",
    "3.8.1.3\tHaloacetate dehalogenase",
    "3.8.1.5\tHaloalkane dehalogenase",
    "3.8.1.6\t4-chlorobenzoate dehalogenase",
    "3.8.1.7\t4-chlorobenzoyl-CoA dehalogenase",
    "3.8.1.8\tAtrazine chlorohydrolase",
    "3.8.1.9\t(R)-2-haloacid dehalogenase",
    "3.8.1.10\t2-haloacid dehalogenase (configuration-inverting)",
    "3.8.1.11\t2-haloacid dehalogenase (configuration-retaining)",
    "3.9.1.1\tPhosphoamidase",
    "3.9.1.2\tProtein arginine phosphatase",
    "3.9.1.3\tPhosphohistidine phosphatase",
    "3.10.1.1\tN-sulfoglucosamine sulfohydrolase",
    "3.10.1.2\tCyclamate sulfohydrolase",
    "3.11.1.1\tPhosphonoacetaldehyde hydrolase",
    "3.11.1.2\tPhosphonoacetate hydrolase",
    "3.11.1.3\tPhosphonopyruvate hydrolase",
    "3.12.1.1\tTrithionate hydrolase",
    "3.13.1.1\tUDP-sulfoquinovose synthase",
    "3.13.1.3\t2'-hydroxybiphenyl-2-sulfinate desulfinase",
    "3.13.1.4\t3-sulfinopropanoyl-CoA desulfinase",
    "3.13.1.5\tCarbon disulfide hydrolase",
    "3.13.1.6\t[CysO sulfur-carrier protein]-S-L-cysteine hydrolase",
    "3.13.1.7\tCarbonyl sulfide hydrolase",
    "3.13.1.8\tS-adenosyl-L-methionine hydrolase (adenosine-forming)",
    "3.13.1.9\tS-inosyl-L-homocysteine hydrolase",
    "4.1.1.1\tPyruvate decarboxylase",
    "4.1.1.2\tOxalate decarboxylase",
    "4.1.1.4\tAcetoacetate decarboxylase",
    "4.1.1.5\tAcetolactate decarboxylase",
    "4.1.1.6\tCis-aconitate decarboxylase",
    "4.1.1.7\tBenzoylformate decarboxylase",
    "4.1.1.8\tOxalyl-CoA decarboxylase",
    "4.1.1.9\tMalonyl-CoA decarboxylase",
    "4.1.1.11\tAspartate 1-decarboxylase",
    "4.1.1.12\tAspartate 4-decarboxylase",
    "4.1.1.14\tValine decarboxylase",
    "4.1.1.15\tGlutamate decarboxylase",
    "4.1.1.16\tHydroxyglutamate decarboxylase",
    "4.1.1.17\tOrnithine decarboxylase",
    "4.1.1.18\tLysine decarboxylase",
    "4.1.1.19\tArginine decarboxylase",
    "4.1.1.20\tDiaminopimelate decarboxylase",
    "4.1.1.21\tPhosphoribosylaminoimidazole carboxylase",
    "4.1.1.22\tHistidine decarboxylase",
    "4.1.1.23\tOrotidine-5'-phosphate decarboxylase",
    "4.1.1.24\tAminobenzoate decarboxylase",
    "4.1.1.25\tTyrosine decarboxylase",
    "4.1.1.28\tAromatic-L-amino-acid decarboxylase",
    "4.1.1.29\tSulfinoalanine decarboxylase",
    "4.1.1.30\tPantothenoylcysteine decarboxylase",
    "4.1.1.31\tPhosphoenolpyruvate carboxylase",
    "4.1.1.32\tPhosphoenolpyruvate carboxykinase (GTP)",
    "4.1.1.33\tDiphosphomevalonate decarboxylase",
    "4.1.1.34\tDehydro-L-gulonate decarboxylase",
    "4.1.1.35\tUDP-glucuronate decarboxylase",
    "4.1.1.36\tPhosphopantothenoylcysteine decarboxylase",
    "4.1.1.37\tUroporphyrinogen decarboxylase",
    "4.1.1.38\tPhosphoenolpyruvate carboxykinase (diphosphate)",
    "4.1.1.39\tRibulose-bisphosphate carboxylase",
    "4.1.1.40\tHydroxypyruvate decarboxylase",
    "4.1.1.42\tCarnitine decarboxylase",
    "4.1.1.43\tPhenylpyruvate decarboxylase",
    "4.1.1.44\t4-carboxymuconolactone decarboxylase",
    "4.1.1.45\tAminocarboxymuconate-semialdehyde decarboxylase",
    "4.1.1.46\to-pyrocatechuate decarboxylase",
    "4.1.1.47\tTartronate-semialdehyde synthase",
    "4.1.1.48\tIndole-3-glycerol-phosphate synthase",
    "4.1.1.49\tPhosphoenolpyruvate carboxykinase (ATP)",
    "4.1.1.50\tAdenosylmethionine decarboxylase",
    "4.1.1.51\t3-hydroxy-2-methylpyridine-4,5-dicarboxylate 4-decarboxylase",
    "4.1.1.52\t6-methylsalicylate decarboxylase",
    "4.1.1.53\tPhenylalanine decarboxylase",
    "4.1.1.54\tDihydroxyfumarate decarboxylase",
    "4.1.1.55\t4,5-dihydroxyphthalate decarboxylase",
    "4.1.1.56\t3-oxolaurate decarboxylase",
    "4.1.1.57\tMethionine decarboxylase",
    "4.1.1.58\tOrsellinate decarboxylase",
    "4.1.1.59\tGallate decarboxylase",
    "4.1.1.60\tStipitatonate decarboxylase",
    "4.1.1.61\t4-hydroxybenzoate decarboxylase",
    "4.1.1.62\tGentisate decarboxylase",
    "4.1.1.63\tProtocatechuate decarboxylase",
    "4.1.1.64\t2,2-dialkylglycine decarboxylase (pyruvate)",
    "4.1.1.65\tPhosphatidylserine decarboxylase",
    "4.1.1.66\tUracil-5-carboxylate decarboxylase",
    "4.1.1.67\tUDP-galacturonate decarboxylase",
    "4.1.1.68\t5-oxopent-3-ene-1,2,5-tricarboxylate decarboxylase",
    "4.1.1.69\t3,4-dihydroxyphthalate decarboxylase",
    "4.1.1.71\t2-oxoglutarate decarboxylase",
    "4.1.1.72\tBranched-chain-2-oxoacid decarboxylase",
    "4.1.1.73\tTartrate decarboxylase",
    "4.1.1.74\tIndolepyruvate decarboxylase",
    "4.1.1.75\t5-guanidino-2-oxopentanoate decarboxylase",
    "4.1.1.76\tArylmalonate decarboxylase",
    "4.1.1.77\t2-oxo-3-hexenedioate decarboxylase",
    "4.1.1.78\tAcetylenedicarboxylate decarboxylase",
    "4.1.1.79\tSulfopyruvate decarboxylase",
    "4.1.1.80\t4-hydroxyphenylpyruvate decarboxylase",
    "4.1.1.81\tThreonine-phosphate decarboxylase",
    "4.1.1.82\tPhosphonopyruvate decarboxylase",
    "4.1.1.83\t4-hydroxyphenylacetate decarboxylase",
    "4.1.1.84\tD-dopachrome decarboxylase",
    "4.1.1.85\t3-dehydro-L-gulonate-6-phosphate decarboxylase",
    "4.1.1.86\tDiaminobutyrate decarboxylase",
    "4.1.1.87\tMalonyl-S-ACP decarboxylase",
    "4.1.1.88\tBiotin-independent malonate decarboxylase",
    "4.1.1.90\tPeptidyl-glutamate 4-carboxylase",
    "4.1.1.91\tSalicylate decarboxylase",
    "4.1.1.92\tIndole-3-carboxylate decarboxylase",
    "4.1.1.93\tPyrrole-2-carboxylate decarboxylase",
    "4.1.1.94\tEthylmalonyl-CoA decarboxylase",
    "4.1.1.95\tL-glutamyl-[BtrI acyl-carrier protein] decarboxylase",
    "4.1.1.96\tCarboxynorspermidine decarboxylase",
    "4.1.1.97\t2-oxo-4-hydroxy-4-carboxy-5-ureidoimidazoline decarboxylase",
    "4.1.1.98\t4-hydroxy-3-polyprenylbenzoate decarboxylase",
    "4.1.1.99\tPhosphomevalonate decarboxylase",
    "4.1.1.100\tPrephenate decarboxylase",
    "4.1.1.101\tMalolactic enzyme",
    "4.1.1.102\tPhenacrylate decarboxylase",
    "4.1.1.103\tGamma-resorcylate decarboxylase",
    "4.1.1.104\t3-dehydro-4-phosphotetronate decarboxylase",
    "4.1.1.105\tL-tryptophan decarboxylase",
    "4.1.1.106\tFatty acid photodecarboxylase",
    "4.1.1.107\t3,4-dihydroxyphenylacetaldehyde synthase",
    "4.1.1.108\t4-hydroxyphenylacetaldehyde synthase",
    "4.1.1.109\tPhenylacetaldehyde synthase",
    "4.1.1.110\tBisphosphomevalonate decarboxylase",
    "4.1.1.111\tSiroheme decarboxylase",
    "4.1.1.112\tOxaloacetate decarboxylase",
    "4.1.1.113\tTrans-aconitate decarboxylase",
    "4.1.1.114\tCis-3-alkyl-4-alkyloxetan-2-one decarboxylase",
    "4.1.1.115\tIndoleacetate decarboxylase",
    "4.1.1.116\tD-ornithine/D-lysine decarboxylase",
    "4.1.1.117\t2-((L-alanin-3-ylcarbamoyl)methyl)-2-hydroxybutanedioate decarboxylase",
    "4.1.1.118\tIsophthalyl-CoA decarboxylase",
    "4.1.1.119\tPhenylacetate decarboxylase",
    "4.1.1.120\t3-oxoisoapionate decarboxylase",
    "4.1.1.121\t3-oxoisoapionate-4-phosphate decarboxylase",
    "4.1.2.2\tKetotetrose-phosphate aldolase",
    "4.1.2.4\tDeoxyribose-phosphate aldolase",
    "4.1.2.5\tL-threonine aldolase",
    "4.1.2.8\tIndole-3-glycerol-phosphate lyase",
    "4.1.2.9\tPhosphoketolase",
    "4.1.2.10\t(R)-mandelonitrile lyase",
    "4.1.2.11\tHydroxymandelonitrile lyase",
    "4.1.2.12\t2-dehydropantoate aldolase",
    "4.1.2.13\tFructose-bisphosphate aldolase",
    "4.1.2.14\t2-dehydro-3-deoxy-phosphogluconate aldolase",
    "4.1.2.17\tL-fuculose-phosphate aldolase",
    "4.1.2.18\t2-dehydro-3-deoxy-L-pentonate aldolase",
    "4.1.2.19\tRhamnulose-1-phosphate aldolase",
    "4.1.2.20\t2-dehydro-3-deoxyglucarate aldolase",
    "4.1.2.21\t2-dehydro-3-deoxy-6-phosphogalactonate aldolase",
    "4.1.2.22\tFructose-6-phosphate phosphoketolase",
    "4.1.2.23\t3-deoxy-D-manno-octulosonate aldolase",
    "4.1.2.24\tDimethylaniline-N-oxide aldolase",
    "4.1.2.25\tDihydroneopterin aldolase",
    "4.1.2.26\tPhenylserine aldolase",
    "4.1.2.27\tSphinganine-1-phosphate aldolase",
    "4.1.2.28\t2-dehydro-3-deoxy-D-pentonate aldolase",
    "4.1.2.29\t5-dehydro-2-deoxyphosphogluconate aldolase",
    "4.1.2.32\tTrimethylamine-oxide aldolase",
    "4.1.2.33\tFucosterol-epoxide lyase",
    "4.1.2.34\t4-(2-carboxyphenyl)-2-oxobut-3-enoate aldolase",
    "4.1.2.35\tPropioin synthase",
    "4.1.2.36\tLactate aldolase",
    "4.1.2.38\tBenzoin aldolase",
    "4.1.2.40\tTagatose-bisphosphate aldolase",
    "4.1.2.42\tD-threonine aldolase",
    "4.1.2.43\t3-hexulose-6-phosphate synthase",
    "4.1.2.44\t2,3-epoxybenzoyl-CoA dihydrolase",
    "4.1.2.45\tTrans-o-hydroxybenzylidenepyruvate hydratase-aldolase",
    "4.1.2.46\tAliphatic (R)-hydroxynitrile lyase",
    "4.1.2.47\t(S)-hydroxynitrile lyase",
    "4.1.2.48\tLow-specificity L-threonine aldolase",
    "4.1.2.49\tL-allo-threonine aldolase",
    "4.1.2.50\t6-carboxytetrahydropterin synthase",
    "4.1.2.51\t2-dehydro-3-deoxy-D-gluconate aldolase",
    "4.1.2.52\t4-hydroxy-2-oxoheptanedioate aldolase",
    "4.1.2.53\t2-keto-3-deoxy-L-rhamnonate aldolase",
    "4.1.2.54\tL-threo-3-deoxy-hexylosonate aldolase",
    "4.1.2.55\t2-dehydro-3-deoxy-phosphogluconate/2-dehydro-3-deoxy-6-phosphogalactonate aldolase",
    "4.1.2.56\t2-amino-4,5-dihydroxy-6-oxo-7-(phosphonooxy)heptanoate synthase",
    "4.1.2.57\tSulfofructosephosphate aldolase",
    "4.1.2.58\t2-dehydro-3,6-dideoxy-6-sulfogluconate aldolase",
    "4.1.2.59\tDihydroneopterin phosphate aldolase",
    "4.1.2.60\tDihydroneopterin triphosphate aldolase",
    "4.1.2.61\tFeruloyl-CoA hydratase/lyase",
    "4.1.2.62\t5-deoxyribulose 1-phosphate aldolase",
    "4.1.2.63\t2-hydroxyacyl-CoA lyase",
    "4.1.3.1\tIsocitrate lyase",
    "4.1.3.3\tN-acetylneuraminate lyase",
    "4.1.3.4\tHydroxymethylglutaryl-CoA lyase",
    "4.1.3.6\tCitrate (pro-3S)-lyase",
    "4.1.3.13\tOxalomalate lyase",
    "4.1.3.14\tL-erythro-3-hydroxyaspartate aldolase",
    "4.1.3.16\t4-hydroxy-2-oxoglutarate aldolase",
    "4.1.3.17\t4-hydroxy-4-methyl-2-oxoglutarate aldolase",
    "4.1.3.22\tCitramalate lyase",
    "4.1.3.24\tMalyl-CoA lyase",
    "4.1.3.25\t(S)-citramalyl-CoA lyase",
    "4.1.3.26\t3-hydroxy-3-isohexenylglutaryl-CoA lyase",
    "4.1.3.27\tAnthranilate synthase",
    "4.1.3.30\tMethylisocitrate lyase",
    "4.1.3.32\t2,3-dimethylmalate lyase",
    "4.1.3.34\tCitryl-CoA lyase",
    "4.1.3.35\t(1-hydroxycyclohexan-1-yl)acetyl-CoA lyase",
    "4.1.3.36\t1,4-dihydroxy-2-naphthoyl-CoA synthase",
    "4.1.3.38\tAminodeoxychorismate lyase",
    "4.1.3.39\t4-hydroxy-2-oxovalerate aldolase",
    "4.1.3.40\tChorismate lyase",
    "4.1.3.41\t3-hydroxy-D-aspartate aldolase",
    "4.1.3.42\t(4S)-4-hydroxy-2-oxoglutarate aldolase",
    "4.1.3.43\t4-hydroxy-2-oxohexanoate aldolase",
    "4.1.3.44\ttRNA 4-demethylwyosine synthase (AdoMet-dependent)",
    "4.1.3.45\t3-hydroxybenzoate synthase",
    "4.1.3.46\t(R)-citramalyl-CoA lyase",
    "4.1.99.1\tTryptophanase",
    "4.1.99.2\tTyrosine phenol-lyase",
    "4.1.99.3\tDeoxyribodipyrimidine photo-lyase",
    "4.1.99.5\tAldehyde oxygenase (deformylating)",
    "4.1.99.11\tBenzylsuccinate synthase",
    "4.1.99.12\t3,4-dihydroxy-2-butanone-4-phosphate synthase",
    "4.1.99.13\t(6-4)DNA photolyase",
    "4.1.99.14\tSpore photoproduct lyase",
    "4.1.99.16\tGeosmin synthase",
    "4.1.99.17\tPhosphomethylpyrimidine synthase",
    "4.1.99.19\t2-iminoacetate synthase",
    "4.1.99.20\t3-amino-4-hydroxybenzoate synthase",
    "4.1.99.22\tGTP 3',8-cyclase",
    "4.1.99.23\t5-hydroxybenzimidazole synthase",
    "4.1.99.24\tL-tyrosine isonitrile synthase",
    "4.1.99.25\tL-tryptophan isonitrile synthase",
    "4.1.99.26\t3-amino-5-((4-hydroxyphenyl)methyl)-4,4-dimethylpyrrolidin-2-one synthase",
    "4.2.1.1\tCarbonic anhydrase",
    "4.2.1.2\tFumarate hydratase",
    "4.2.1.3\tAconitate hydratase",
    "4.2.1.5\tArabinonate dehydratase",
    "4.2.1.6\tGalactonate dehydratase",
    "4.2.1.7\tAltronate dehydratase",
    "4.2.1.8\tMannonate dehydratase",
    "4.2.1.9\tDihydroxy-acid dehydratase",
    "4.2.1.10\t3-dehydroquinate dehydratase",
    "4.2.1.11\tPhosphopyruvate hydratase",
    "4.2.1.12\tPhosphogluconate dehydratase",
    "4.2.1.17\tEnoyl-CoA hydratase",
    "4.2.1.18\tMethylglutaconyl-CoA hydratase",
    "4.2.1.19\tImidazoleglycerol-phosphate dehydratase",
    "4.2.1.20\tTryptophan synthase",
    "4.2.1.22\tCystathionine beta-synthase",
    "4.2.1.24\tPorphobilinogen synthase",
    "4.2.1.25\tL-arabinonate dehydratase",
    "4.2.1.27\tAcetylenecarboxylate hydratase",
    "4.2.1.28\tPropanediol dehydratase",
    "4.2.1.30\tGlycerol dehydratase",
    "4.2.1.31\tMaleate hydratase",
    "4.2.1.32\tL(+)-tartrate dehydratase",
    "4.2.1.33\t3-isopropylmalate dehydratase",
    "4.2.1.34\t(S)-2-methylmalate dehydratase",
    "4.2.1.35\t(R)-2-methylmalate dehydratase",
    "4.2.1.36\tHomoaconitate hydratase",
    "4.2.1.39\tGluconate dehydratase",
    "4.2.1.40\tGlucarate dehydratase",
    "4.2.1.41\t5-dehydro-4-deoxyglucarate dehydratase",
    "4.2.1.42\tGalactarate dehydratase",
    "4.2.1.43\t2-dehydro-3-deoxy-L-arabinonate dehydratase",
    "4.2.1.44\tMyo-inosose-2 dehydratase",
    "4.2.1.45\tCDP-glucose 4,6-dehydratase",
    "4.2.1.46\tdTDP-glucose 4,6-dehydratase",
    "4.2.1.47\tGDP-mannose 4,6-dehydratase",
    "4.2.1.48\tD-glutamate cyclase",
    "4.2.1.49\tUrocanate hydratase",
    "4.2.1.50\tPyrazolylalanine synthase",
    "4.2.1.51\tPrephenate dehydratase",
    "4.2.1.53\tOleate hydratase",
    "4.2.1.54\tLactoyl-CoA dehydratase",
    "4.2.1.55\t3-hydroxybutyryl-CoA dehydratase",
    "4.2.1.56\tItaconyl-CoA hydratase",
    "4.2.1.57\tIsohexenylglutaconyl-CoA hydratase",
    "4.2.1.59\t3-hydroxyacyl-[acyl-carrier-protein] dehydratase",
    "4.2.1.62\t5-alpha-hydroxysteroid dehydratase",
    "4.2.1.65\t3-cyanoalanine hydratase",
    "4.2.1.66\tCyanide hydratase",
    "4.2.1.67\tD-fuconate dehydratase",
    "4.2.1.68\tL-fuconate dehydratase",
    "4.2.1.69\tCyanamide hydratase",
    "4.2.1.70\tPseudouridylate synthase",
    "4.2.1.73\tProtoaphin-aglucone dehydratase (cyclizing)",
    "4.2.1.74\tLong-chain-enoyl-CoA hydratase",
    "4.2.1.75\tUroporphyrinogen-III synthase",
    "4.2.1.76\tUDP-glucose 4,6-dehydratase",
    "4.2.1.77\tTrans-L-3-hydroxyproline dehydratase",
    "4.2.1.78\t(S)-norcoclaurine synthase",
    "4.2.1.79\t2-methylcitrate dehydratase",
    "4.2.1.80\t2-oxopent-4-enoate hydratase",
    "4.2.1.81\tD(-)-tartrate dehydratase",
    "4.2.1.82\tXylonate dehydratase",
    "4.2.1.83\t4-oxalmesaconate hydratase",
    "4.2.1.84\tNitrile hydratase",
    "4.2.1.85\tDimethylmaleate hydratase",
    "4.2.1.87\tOctopamine dehydratase",
    "4.2.1.88\tSynephrine dehydratase",
    "4.2.1.90\tL-rhamnonate dehydratase",
    "4.2.1.91\tArogenate dehydratase",
    "4.2.1.92\tHydroperoxide dehydratase",
    "4.2.1.93\tATP-dependent NAD(P)H-hydrate dehydratase",
    "4.2.1.94\tScytalone dehydratase",
    "4.2.1.95\tKievitone hydratase",
    "4.2.1.96\t4a-hydroxytetrahydrobiopterin dehydratase",
    "4.2.1.97\tPhaseollidin hydratase",
    "4.2.1.98\t16-alpha-hydroxyprogesterone dehydratase",
    "4.2.1.99\t2-methylisocitrate dehydratase",
    "4.2.1.100\tCyclohexa-1,5-dienecarbonyl-CoA hydratase",
    "4.2.1.101\tTrans-feruloyl-CoA hydratase",
    "4.2.1.103\tCyclohexyl-isocyanide hydratase",
    "4.2.1.104\tCyanase",
    "4.2.1.105\t2-hydroxyisoflavanone dehydratase",
    "4.2.1.106\tBile-acid 7-alpha-dehydratase",
    "4.2.1.107\t3-alpha,7-alpha,12-alpha-trihydroxy-5-beta-cholest-24-enoyl-CoA hydratase",
    "4.2.1.108\tEctoine synthase",
    "4.2.1.109\tMethylthioribulose 1-phosphate dehydratase",
    "4.2.1.110\tAldos-2-ulose dehydratase",
    "4.2.1.111\t1,5-anhydro-D-fructose dehydratase",
    "4.2.1.112\tAcetylene hydratase",
    "4.2.1.113\to-succinylbenzoate synthase",
    "4.2.1.114\tMethanogen homoaconitase",
    "4.2.1.115\tUDP-N-acetylglucosamine 4,6-dehydratase (inverting)",
    "4.2.1.116\t3-hydroxypropionyl-CoA dehydratase",
    "4.2.1.117\t2-methylcitrate dehydratase (2-methyl-trans-aconitate forming)",
    "4.2.1.118\t3-dehydroshikimate dehydratase",
    "4.2.1.119\tEnoyl-CoA hydratase 2",
    "4.2.1.120\t4-hydroxybutanoyl-CoA dehydratase",
    "4.2.1.121\tColneleate synthase",
    "4.2.1.122\tTryptophan synthase (indole-salvaging)",
    "4.2.1.123\tTetrahymanol synthase",
    "4.2.1.124\tArabidiol synthase",
    "4.2.1.125\tDammarenediol II synthase",
    "4.2.1.126\tN-acetylmuramic acid 6-phosphate etherase",
    "4.2.1.127\tLinalool dehydratase",
    "4.2.1.128\tLupan-3-beta,20-diol synthase",
    "4.2.1.129\tSqualene--hopanol cyclase",
    "4.2.1.130\tD-lactate dehydratase",
    "4.2.1.131\tCarotenoid 1,2-hydratase",
    "4.2.1.132\t2-hydroxyhexa-2,4-dienoate hydratase",
    "4.2.1.133\tCopal-8-ol diphosphate hydratase",
    "4.2.1.134\tVery-long-chain (3R)-3-hydroxyacyl-CoA dehydratase",
    "4.2.1.135\tUDP-N-acetylglucosamine 4,6-dehydratase (configuration-retaining)",
    "4.2.1.136\tADP-dependent NAD(P)H-hydrate dehydratase",
    "4.2.1.137\tSporulenol synthase",
    "4.2.1.138\t(+)-caryolan-1-ol synthase",
    "4.2.1.139\tPterocarpan synthase",
    "4.2.1.140\tGluconate/galactonate dehydratase",
    "4.2.1.141\t2-dehydro-3-deoxy-D-arabinonate dehydratase",
    "4.2.1.142\t5'-oxoaverantin cyclase",
    "4.2.1.143\tVersicolorin B synthase",
    "4.2.1.144\t3-amino-5-hydroxybenzoate synthase",
    "4.2.1.145\tCapreomycidine synthase",
    "4.2.1.146\tL-galactonate dehydratase",
    "4.2.1.147\t5,6,7,8-tetrahydromethanopterin hydro-lyase",
    "4.2.1.148\t2-methylfumaryl-CoA hydratase",
    "4.2.1.149\tCrotonobetainyl-CoA hydratase",
    "4.2.1.150\tShort-chain-enoyl-CoA hydratase",
    "4.2.1.151\tChorismate dehydratase",
    "4.2.1.152\tHydroperoxy icosatetraenoate dehydratase",
    "4.2.1.153\t3-methylfumaryl-CoA hydratase",
    "4.2.1.154\tTetracenomycin F2 cyclase",
    "4.2.1.155\tMethylthioacryloyl-CoA hydratase",
    "4.2.1.156\tL-talarate dehydratase",
    "4.2.1.157\t(R)-2-hydroxyisocaproyl-CoA dehydratase",
    "4.2.1.158\tGalactarate dehydratase (D-threo-forming)",
    "4.2.1.159\tdTDP-4-dehydro-6-deoxy-alpha-D-glucopyranose 2,3-dehydratase",
    "4.2.1.160\t2,5-diamino-6-(5-phospho-D-ribosylamino)pyrimidin-4(3H)-one isomerase/dehydratase",
    "4.2.1.161\tBisanhydrobacterioruberin hydratase",
    "4.2.1.162\t6-deoxy-6-sulfo-D-gluconate dehydratase",
    "4.2.1.163\t2-oxo-hept-4-ene-1,7-dioate hydratase",
    "4.2.1.164\tdTDP-4-dehydro-2,6-dideoxy-D-glucose 3-dehydratase",
    "4.2.1.165\tChlorophyllide a 3(1)-hydratase",
    "4.2.1.166\tPhosphinomethylmalate isomerase",
    "4.2.1.167\t(R)-2-hydroxyglutaryl-CoA dehydratase",
    "4.2.1.168\tGDP-4-dehydro-6-deoxy-alpha-D-mannose 3-dehydratase",
    "4.2.1.169\t3-vinylbacteriochlorophyllide d 3(1)-hydratase",
    "4.2.1.170\t2-(omega-methylthio)alkylmalate dehydratase",
    "4.2.1.171\tCis-l-3-hydroxyproline dehydratase",
    "4.2.1.172\tTrans-4-hydroxy-L-proline dehydratase",
    "4.2.1.173\tEnt-8-alpha-hydroxylabd-13-en-15-yl diphosphate synthase",
    "4.2.1.174\tPeregrinol diphosphate synthase",
    "4.2.1.175\t(R)-3-(aryl)lactoyl-CoA dehydratase",
    "4.2.1.176\tL-lyxonate dehydratase",
    "4.2.1.177\t(2S)-3-sulfopropanediol dehydratase",
    "4.2.2.1\tHyaluronate lyase",
    "4.2.2.2\tPectate lyase",
    "4.2.2.3\tMannuronate-specific alginate lyase",
    "4.2.2.5\tChondroitin AC lyase",
    "4.2.2.6\tOligogalacturonide lyase",
    "4.2.2.7\tHeparin lyase",
    "4.2.2.8\tHeparin-sulfate lyase",
    "4.2.2.9\tPectate disaccharide-lyase",
    "4.2.2.10\tPectin lyase",
    "4.2.2.11\tGuluronate-specific alginate lyase",
    "4.2.2.12\tXanthan lyase",
    "4.2.2.13\tExo-(1->4)-alpha-D-glucan lyase",
    "4.2.2.14\tGlucuronan lyase",
    "4.2.2.15\tAnhydrosialidase",
    "4.2.2.16\tLevan fructotransferase (DFA-IV-forming)",
    "4.2.2.17\tInulin fructotransferase (DFA-I-forming)",
    "4.2.2.18\tInulin fructotransferase (DFA-III-forming)",
    "4.2.2.19\tChondroitin B lyase",
    "4.2.2.20\tChondroitin-sulfate-ABC endolyase",
    "4.2.2.21\tChondroitin-sulfate-ABC exolyase",
    "4.2.2.22\tPectate trisaccharide-lyase",
    "4.2.2.23\tRhamnogalacturonan endolyase",
    "4.2.2.24\tRhamnogalacturonan exolyase",
    "4.2.2.25\tGellan lyase",
    "4.2.2.26\tOligo-alginate lyase",
    "4.2.2.27\tPectin monosaccharide-lyase",
    "4.2.2.n1\tPeptidoglycan lytic exotransglycosylase",
    "4.2.2.n2\tPeptidoglycan lytic endotransglycosylase",
    "4.2.3.1\tThreonine synthase",
    "4.2.3.2\tEthanolamine-phosphate phospho-lyase",
    "4.2.3.3\tMethylglyoxal synthase",
    "4.2.3.4\t3-dehydroquinate synthase",
    "4.2.3.5\tChorismate synthase",
    "4.2.3.6\tTrichodiene synthase",
    "4.2.3.7\tPentalenene synthase",
    "4.2.3.8\tCasbene synthase",
    "4.2.3.9\tAristolochene synthase",
    "4.2.3.10\t(-)-endo-fenchol synthase",
    "4.2.3.11\tSabinene-hydrate synthase",
    "4.2.3.12\t6-pyruvoyltetrahydropterin synthase",
    "4.2.3.13\t(+)-delta-cadinene synthase",
    "4.2.3.15\tMyrcene synthase",
    "4.2.3.16\t(4S)-limonene synthase",
    "4.2.3.17\tTaxadiene synthase",
    "4.2.3.18\tAbieta-7,13-diene synthase",
    "4.2.3.19\tEnt-kaurene synthase",
    "4.2.3.20\t(R)-limonene synthase",
    "4.2.3.21\tVetispiradiene synthase",
    "4.2.3.22\tGermacradienol synthase",
    "4.2.3.23\tGermacrene-A synthase",
    "4.2.3.24\tAmorpha-4,11-diene synthase",
    "4.2.3.25\tS-linalool synthase",
    "4.2.3.26\tR-linalool synthase",
    "4.2.3.27\tIsoprene synthase",
    "4.2.3.28\tEnt-cassa-12,15-diene synthase",
    "4.2.3.29\tEnt-sandaracopimaradiene synthase",
    "4.2.3.30\tEnt-pimara-8(14),15-diene synthase",
    "4.2.3.31\tEnt-pimara-9(11),15-diene synthase",
    "4.2.3.32\tLevopimaradiene synthase",
    "4.2.3.33\tStemar-13-ene synthase",
    "4.2.3.34\tStemod-13(17)-ene synthase",
    "4.2.3.35\tSyn-pimara-7,15-diene synthase",
    "4.2.3.36\tTerpentetriene synthase",
    "4.2.3.37\tEpi-isozizaene synthase",
    "4.2.3.38\tAlpha-bisabolene synthase",
    "4.2.3.39\tEpi-cedrol synthase",
    "4.2.3.40\t(Z)-gamma-bisabolene synthase",
    "4.2.3.41\tElisabethatriene synthase",
    "4.2.3.42\tAphidicolan-16-beta-ol synthase",
    "4.2.3.43\tFusicocca-2,10(14)-diene synthase",
    "4.2.3.44\tIsopimara-7,15-diene synthase",
    "4.2.3.45\tPhyllocladan-16-alpha-ol synthase",
    "4.2.3.46\tAlpha-farnesene synthase",
    "4.2.3.47\tBeta-farnesene synthase",
    "4.2.3.48\t(3S,6E)-nerolidol synthase",
    "4.2.3.49\t(3R,6E)-nerolidol synthase",
    "4.2.3.50\t(+)-alpha-santalene synthase ((2Z,6Z)-farnesyl diphosphate cyclizing)",
    "4.2.3.51\tBeta-phellandrene synthase (neryl-diphosphate-cyclizing)",
    "4.2.3.52\t(4S)-beta-phellandrene synthase (geranyl-diphosphate-cyclizing)",
    "4.2.3.53\t(+)-endo-beta-bergamotene synthase ((2Z,6Z)-farnesyl diphosphate cyclizing)",
    "4.2.3.54\t(-)-endo-alpha-bergamotene synthase ((2Z,6Z)-farnesyl diphosphate cyclizing)",
    "4.2.3.55\t(S)-beta-bisabolene synthase",
    "4.2.3.56\tGamma-humulene synthase",
    "4.2.3.57\t(-)-beta-caryophyllene synthase",
    "4.2.3.58\tLongifolene synthase",
    "4.2.3.59\t(E)-gamma-bisabolene synthase",
    "4.2.3.60\tGermacrene C synthase",
    "4.2.3.61\t5-epiaristolochene synthase",
    "4.2.3.62\t(-)-gamma-cadinene synthase ((2Z,6E)-farnesyl diphosphate cyclizing)",
    "4.2.3.63\t(+)-cubenene synthase",
    "4.2.3.64\t(+)-epicubenol synthase",
    "4.2.3.65\tZingiberene synthase",
    "4.2.3.66\tBeta-selinene cyclase",
    "4.2.3.67\tCis-muuroladiene synthase",
    "4.2.3.68\tBeta-eudesmol synthase",
    "4.2.3.69\t(+)-alpha-barbatene synthase",
    "4.2.3.70\tPatchoulol synthase",
    "4.2.3.71\t(E,E)-germacrene B synthase",
    "4.2.3.72\tAlpha-gurjunene synthase",
    "4.2.3.73\tValencene synthase",
    "4.2.3.74\tPresilphiperfolanol synthase",
    "4.2.3.75\t(-)-germacrene D synthase",
    "4.2.3.76\t(+)-delta-selinene synthase",
    "4.2.3.77\t(+)-germacrene D synthase",
    "4.2.3.78\tBeta-chamigrene synthase",
    "4.2.3.79\tThujopsene synthase",
    "4.2.3.80\tAlpha-longipinene synthase",
    "4.2.3.81\tExo-alpha-bergamotene synthase",
    "4.2.3.82\tAlpha-santalene synthase",
    "4.2.3.83\tBeta-santalene synthase",
    "4.2.3.84\t10-epi-gamma-eudesmol synthase",
    "4.2.3.85\tAlpha-eudesmol synthase",
    "4.2.3.86\t7-epi-alpha-selinene synthase",
    "4.2.3.87\tAlpha-guaiene synthase",
    "4.2.3.88\tViridiflorene synthase",
    "4.2.3.89\t(+)-beta-caryophyllene synthase",
    "4.2.3.90\t5-epi-alpha-selinene synthase",
    "4.2.3.91\tCubebol synthase",
    "4.2.3.92\t(+)-gamma-cadinene synthase",
    "4.2.3.93\tDelta-guaiene synthase",
    "4.2.3.94\tGamma-curcumene synthase",
    "4.2.3.95\t(-)-alpha-cuprenene synthase",
    "4.2.3.96\tAvermitilol synthase",
    "4.2.3.97\t(-)-delta-cadinene synthase",
    "4.2.3.98\t(+)-T-muurolol synthase",
    "4.2.3.99\tLabdatriene synthase",
    "4.2.3.100\tBicyclogermacrene synthase",
    "4.2.3.101\t7-epi-sesquithujene synthase",
    "4.2.3.102\tSesquithujene synthase",
    "4.2.3.103\tEnt-isokaurene synthase",
    "4.2.3.104\tAlpha-humulene synthase",
    "4.2.3.105\tTricyclene synthase",
    "4.2.3.106\t(E)-beta-ocimene synthase",
    "4.2.3.107\t(+)-car-3-ene synthase",
    "4.2.3.108\t1,8-cineole synthase",
    "4.2.3.109\t(-)-sabinene synthase",
    "4.2.3.110\t(+)-sabinene synthase",
    "4.2.3.111\t(-)-alpha-terpineol synthase",
    "4.2.3.112\t(+)-alpha-terpineol synthase",
    "4.2.3.113\tTerpinolene synthase",
    "4.2.3.114\tGamma-terpinene synthase",
    "4.2.3.115\tAlpha-terpinene synthase",
    "4.2.3.116\t(+)-camphene synthase",
    "4.2.3.117\t(-)-camphene synthase",
    "4.2.3.118\t2-methylisoborneol synthase",
    "4.2.3.119\t(-)-alpha-pinene synthase",
    "4.2.3.120\t(-)-beta-pinene synthase",
    "4.2.3.121\t(+)-alpha-pinene synthase",
    "4.2.3.122\t(+)-beta-pinene synthase",
    "4.2.3.123\tBeta-sesquiphellandrene synthase",
    "4.2.3.124\t2-deoxy-scyllo-inosose synthase",
    "4.2.3.125\tAlpha-muurolene synthase",
    "4.2.3.126\tGamma-muurolene synthase",
    "4.2.3.127\tBeta-copaene synthase",
    "4.2.3.128\tBeta-cubebene synthase",
    "4.2.3.129\t(+)-sativene synthase",
    "4.2.3.130\tTetraprenyl-beta-curcumene synthase",
    "4.2.3.131\tMiltiradiene synthase",
    "4.2.3.132\tNeoabietadiene synthase",
    "4.2.3.133\tAlpha-copaene synthase",
    "4.2.3.134\t5-phosphooxy-L-lysine phospho-lyase",
    "4.2.3.135\tDelta(6)-protoilludene synthase",
    "4.2.3.136\tAlpha-isocomene synthase",
    "4.2.3.137\t(E)-2-epi-beta-caryophyllene synthase",
    "4.2.3.138\t(+)-epi-alpha-bisabolol synthase",
    "4.2.3.139\tValerena-4,7(11)-diene synthase",
    "4.2.3.140\tCis-abienol synthase",
    "4.2.3.141\tSclareol synthase",
    "4.2.3.142\t7-epizingiberene synthase ((2Z,6Z)-farnesyl diphosphate cyclizing)",
    "4.2.3.143\tKunzeaol synthase",
    "4.2.3.144\tGeranyllinalool synthase",
    "4.2.3.145\tOphiobolin F synthase",
    "4.2.3.146\tCyclooctat-9-en-7-ol synthase",
    "4.2.3.147\tPimaradiene synthase",
    "4.2.3.148\tCembrene C synthase",
    "4.2.3.149\tNephthenol synthase",
    "4.2.3.150\tCembrene A synthase",
    "4.2.3.151\tPentamethylcyclopentadecatrienol synthase",
    "4.2.3.152\t2-epi-5-epi-valiolone synthase",
    "4.2.3.153\t(5-formylfuran-3-yl)methyl phosphate synthase",
    "4.2.3.154\tDemethyl-4-deoxygadusol synthase",
    "4.2.3.155\t2-epi-valiolone synthase",
    "4.2.3.156\tHydroxysqualene synthase",
    "4.2.3.157\t(+)-isoafricanol synthase",
    "4.2.3.158\t(-)-spiroviolene synthase",
    "4.2.3.159\tTsukubadiene synthase",
    "4.2.3.160\t(2S,3R,6S,9S)-(-)-protoillud-7-ene synthase",
    "4.2.3.161\t(3S)-(+)-asterisca-2(9),6-diene synthase",
    "4.2.3.162\t(-)-alpha-amorphene synthase",
    "4.2.3.163\t(+)-corvol ether B synthase",
    "4.2.3.164\t(+)-eremophilene synthase",
    "4.2.3.165\t(1R,4R,5S)-(-)-guaia-6,10(14)-diene synthase",
    "4.2.3.166\t(+)-(1(10)E,4E,6S,7R)-germacradien-6-ol synthase",
    "4.2.3.167\tDolabella-3,7-dien-18-ol synthase",
    "4.2.3.168\tDolathalia-3,7,11-triene synthase",
    "4.2.3.169\t7-epi-alpha-eudesmol synthase",
    "4.2.3.170\t4-epi-cubebol synthase",
    "4.2.3.171\t(+)-corvol ether A synthase",
    "4.2.3.172\t10-epi-juneol synthase",
    "4.2.3.173\tTau-cadinol synthase",
    "4.2.3.174\t(2E,6E)-hedycaryol synthase",
    "4.2.3.175\t10-epi-cubebol synthase",
    "4.2.3.176\tSesterfisherol synthase",
    "4.2.3.177\tBeta-thujene synthase",
    "4.2.3.178\tStellata-2,6,19-triene synthase",
    "4.2.3.179\tGuaia-4,6-diene synthase",
    "4.2.3.180\tPseudolaratriene synthase",
    "4.2.3.181\tSelina-4(15),7(11)-diene synthase",
    "4.2.3.182\tPristinol synthase",
    "4.2.3.183\tNezukol synthase",
    "4.2.3.184\t5-hydroxy-alpha-gurjunene synthase",
    "4.2.3.185\tEnt-atiserene synthase",
    "4.2.3.186\tEnt-13-epi-manoyl oxide synthase",
    "4.2.3.187\t(2Z,6E)-hedycaryol synthase",
    "4.2.3.188\tBeta-geranylfarnesene synthase",
    "4.2.3.189\t9,13-epoxylabda-14-ene synthase",
    "4.2.3.190\tManoyl oxide synthase",
    "4.2.3.191\tCycloaraneosene synthase",
    "4.2.3.192\tLabda-7,13(16),14-triene synthase",
    "4.2.3.193\t(12E)-labda-8(17),12,14-triene synthase",
    "4.2.3.194\t(-)-drimenol synthase",
    "4.2.3.195\tRhizathalene A synthase",
    "4.2.3.196\tDolabradiene synthase",
    "4.2.3.197\tEudesmane-5,11-diol synthase",
    "4.2.3.198\tAlpha-selinene synthase",
    "4.2.3.199\t(-)-5-epieremophilene synthase",
    "4.2.3.200\tBeta-pinacene synthase",
    "4.2.3.201\tHydropyrene synthase",
    "4.2.3.202\tHydropyrenol synthase",
    "4.2.3.203\tIsoelisabethatriene synthase",
    "4.2.3.204\tValerianol synthase",
    "4.2.3.205\tSodorifen synthase",
    "4.2.3.n2\tDelta-selinene synthase",
    "4.2.99.12\tCarboxymethyloxysuccinate lyase",
    "4.2.99.18\tDNA-(apurinic or apyrimidinic site) lyase",
    "4.2.99.20\t2-succinyl-6-hydroxy-2,4-cyclohexadiene-1-carboxylate synthase",
    "4.2.99.21\tIsochorismate lyase",
    "4.2.99.22\tTuliposide A-converting enzyme",
    "4.2.99.23\tTuliposide B-converting enzyme",
    "4.2.99.24\tThebaine synthase",
    "4.3.1.1\tAspartate ammonia-lyase",
    "4.3.1.2\tMethylaspartate ammonia-lyase",
    "4.3.1.3\tHistidine ammonia-lyase",
    "4.3.1.4\tFormimidoyltetrahydrofolate cyclodeaminase",
    "4.3.1.6\tBeta-alanyl-CoA ammonia-lyase",
    "4.3.1.7\tEthanolamine ammonia-lyase",
    "4.3.1.9\tGlucosaminate ammonia-lyase",
    "4.3.1.10\tSerine-sulfate ammonia-lyase",
    "4.3.1.12\tOrnithine cyclodeaminase",
    "4.3.1.13\tCarbamoyl-serine ammonia-lyase",
    "4.3.1.14\t3-aminobutyryl-CoA ammonia-lyase",
    "4.3.1.15\tDiaminopropionate ammonia-lyase",
    "4.3.1.16\tThreo-3-hydroxy-L-aspartate ammonia-lyase",
    "4.3.1.17\tL-serine ammonia-lyase",
    "4.3.1.18\tD-serine ammonia-lyase",
    "4.3.1.19\tThreonine ammonia-lyase",
    "4.3.1.20\tErythro-3-hydroxy-L-aspartate ammonia-lyase",
    "4.3.1.22\t3,4-dihydroxyphenylalanine reductive deaminase",
    "4.3.1.23\tTyrosine ammonia-lyase",
    "4.3.1.24\tPhenylalanine ammonia-lyase",
    "4.3.1.25\tPhenylalanine/tyrosine ammonia-lyase",
    "4.3.1.27\tThreo-3-hydroxy-D-aspartate ammonia-lyase",
    "4.3.1.28\tL-lysine cyclodeaminase",
    "4.3.1.29\tD-glucosaminate-6-phosphate ammonia lyase",
    "4.3.1.30\tdTDP-4-amino-4,6-dideoxy-D-glucose ammonia-lyase",
    "4.3.1.31\tL-tryptophan ammonia lyase",
    "4.3.1.32\t7,8-didemethyl-8-hydroxy-5-deazariboflavin synthase",
    "4.3.2.1\tArgininosuccinate lyase",
    "4.3.2.2\tAdenylosuccinate lyase",
    "4.3.2.3\tUreidoglycolate lyase",
    "4.3.2.4\tPurine imidazole-ring cyclase",
    "4.3.2.5\tPeptidylamidoglycolate lyase",
    "4.3.2.6\tGamma-L-glutamyl-butirosin B gamma-glutamyl cyclotransferase",
    "4.3.2.7\tGlutathione-specific gamma-glutamylcyclotransferase",
    "4.3.2.8\tGamma-glutamylamine cyclotransferase",
    "4.3.2.9\tGamma-glutamylcyclotransferase",
    "4.3.2.10\tImidazole glycerol-phosphate synthase",
    "4.3.3.1\t3-ketovalidoxylamine C-N-lyase",
    "4.3.3.2\tStrictosidine synthase",
    "4.3.3.3\tDeacetylisoipecoside synthase",
    "4.3.3.4\tDeacetylipecoside synthase",
    "4.3.3.5\t4'-demethylrebeccamycin synthase",
    "4.3.3.6\tPyridoxal 5'-phosphate synthase (glutamine hydrolyzing)",
    "4.3.3.7\t4-hydroxy-tetrahydrodipicolinate synthase",
    "4.3.99.3\t7-carboxy-7-deazaguanine synthase",
    "4.3.99.4\tCholine trimethylamine-lyase",
    "4.4.1.1\tCystathionine gamma-lyase",
    "4.4.1.2\tHomocysteine desulfhydrase",
    "4.4.1.3\tDimethylpropiothetin dethiomethylase",
    "4.4.1.4\tAlliin lyase",
    "4.4.1.5\tLactoylglutathione lyase",
    "4.4.1.6\tS-alkylcysteine lyase",
    "4.4.1.8\tCystathionine beta-lyase",
    "4.4.1.9\tL-3-cyanoalanine synthase",
    "4.4.1.10\tCysteine lyase",
    "4.4.1.11\tMethionine gamma-lyase",
    "4.4.1.13\tCysteine-S-conjugate beta-lyase",
    "4.4.1.14\t1-aminocyclopropane-1-carboxylate synthase",
    "4.4.1.15\tD-cysteine desulfhydrase",
    "4.4.1.16\tSelenocysteine lyase",
    "4.4.1.17\tHolocytochrome-c synthase",
    "4.4.1.19\tPhosphosulfolactate synthase",
    "4.4.1.20\tLeukotriene-C(4) synthase",
    "4.4.1.21\tS-ribosylhomocysteine lyase",
    "4.4.1.22\tS-(hydroxymethyl)glutathione synthase",
    "4.4.1.23\t2-hydroxypropyl-CoM lyase",
    "4.4.1.24\t(2R)-sulfolactate sulfo-lyase",
    "4.4.1.25\tL-cysteate sulfo-lyase",
    "4.4.1.26\tOlivetolic acid cyclase",
    "4.4.1.28\tL-cysteine desulfidase",
    "4.4.1.29\tPhycobiliprotein cysteine-84 phycobilin lyase",
    "4.4.1.30\tPhycobiliprotein beta-cysteine-155 phycobilin lyase",
    "4.4.1.31\tPhycoerythrocyanin alpha-cysteine-84 phycoviolobilin lyase/isomerase",
    "4.4.1.32\tC-phycocyanin alpha-cysteine-84 phycocyanobilin lyase",
    "4.4.1.33\tR-phycocyanin alpha-cysteine-84 phycourobilin lyase/isomerase",
    "4.4.1.34\tIsoprene-epoxide--glutathione S-transferase",
    "4.4.1.35\tL-cystine beta-lyase",
    "4.4.1.36\tHercynylcysteine S-oxide lyase",
    "4.4.1.37\tPyridinium-3,5-bisthiocarboxylic acid mononucleotide synthase",
    "4.4.1.38\tIsethionate sulfite-lyase",
    "4.4.1.39\tC-phycoerythrin alpha-cysteine-82 phycoerythrobilin lyase",
    "4.4.1.40\tC-phycoerythrin beta-cysteine-48/59 phycoerythrobilin lyase",
    "4.4.1.41\t(2S)-3-sulfopropanediol sulfolyase",
    "4.5.1.1\tDDT-dehydrochlorinase",
    "4.5.1.2\t3-chloro-D-alanine dehydrochlorinase",
    "4.5.1.3\tDichloromethane dehalogenase",
    "4.5.1.4\tL-2-amino-4-chloropent-4-enoate dehydrochlorinase",
    "4.5.1.5\tS-carboxymethylcysteine synthase",
    "4.6.1.1\tAdenylate cyclase",
    "4.6.1.2\tGuanylate cyclase",
    "4.6.1.6\tCytidylate cyclase",
    "4.6.1.12\t2-C-methyl-D-erythritol 2,4-cyclodiphosphate synthase",
    "4.6.1.13\tPhosphatidylinositol diacylglycerol-lyase",
    "4.6.1.14\tGlycosylphosphatidylinositol diacylglycerol-lyase",
    "4.6.1.15\tFAD-AMP lyase (cyclizing)",
    "4.6.1.16\ttRNA-intron lyase",
    "4.6.1.17\tCyclic pyranopterin monophosphate synthase",
    "4.6.1.18\tPancreatic ribonuclease",
    "4.6.1.19\tRibonuclease T(2)",
    "4.6.1.20\tRibonuclease U(2)",
    "4.6.1.21\tEnterobacter ribonuclease",
    "4.6.1.22\tBacillus subtilis ribonuclease",
    "4.6.1.23\tRibotoxin",
    "4.6.1.24\tRibonuclease T(1)",
    "4.6.1.25\tBacteriophage T(4) restriction endoribonuclease RegB",
    "4.7.1.1\tAlpha-D-ribose 1-methylphosphonate 5-phosphate C-P-lyase",
    "4.99.1.1\tProtoporphyrin ferrochelatase",
    "4.99.1.2\tAlkylmercury lyase",
    "4.99.1.3\tSirohydrochlorin cobaltochelatase",
    "4.99.1.4\tSirohydrochlorin ferrochelatase",
    "4.99.1.5\tAliphatic aldoxime dehydratase",
    "4.99.1.6\tIndoleacetaldoxime dehydratase",
    "4.99.1.7\tPhenylacetaldoxime dehydratase",
    "4.99.1.8\tHeme ligase",
    "4.99.1.9\tCoproporphyrin ferrochelatase",
    "4.99.1.10\tMagnesium dechelatase",
    "4.99.1.11\tSirohydrochlorin nickelchelatase",
    "4.99.1.12\tPyridinium-3,5-bisthiocarboxylic acid mononucleotide nickel chelatase",
    "5.1.1.1\tAlanine racemase",
    "5.1.1.2\tMethionine racemase",
    "5.1.1.3\tGlutamate racemase",
    "5.1.1.4\tProline racemase",
    "5.1.1.5\tLysine racemase",
    "5.1.1.6\tThreonine racemase",
    "5.1.1.7\tDiaminopimelate epimerase",
    "5.1.1.8\t4-hydroxyproline epimerase",
    "5.1.1.9\tArginine racemase",
    "5.1.1.10\tAmino-acid racemase",
    "5.1.1.11\tPhenylalanine racemase (ATP-hydrolyzing)",
    "5.1.1.12\tOrnithine racemase",
    "5.1.1.13\tAspartate racemase",
    "5.1.1.14\tNocardicin-A epimerase",
    "5.1.1.15\t2-aminohexano-6-lactam racemase",
    "5.1.1.16\tProtein-serine epimerase",
    "5.1.1.17\tIsopenicillin-N epimerase",
    "5.1.1.18\tSerine racemase",
    "5.1.1.19\tO-ureido-serine racemase",
    "5.1.1.20\tL-Ala-D/L-Glu epimerase",
    "5.1.1.21\tIsoleucine 2-epimerase",
    "5.1.1.22\t4-hydroxyproline betaine 2-epimerase",
    "5.1.1.23\tUDP-N-acetyl-alpha-D-muramoyl-L-alanyl-L-glutamate epimerase",
    "5.1.1.24\tHistidine racemase",
    "5.1.2.1\tLactate racemase",
    "5.1.2.2\tMandelate racemase",
    "5.1.2.3\t3-hydroxybutyryl-CoA epimerase",
    "5.1.2.4\tAcetoin racemase",
    "5.1.2.5\tTartrate epimerase",
    "5.1.2.6\tIsocitrate epimerase",
    "5.1.2.7\tTagaturonate epimerase",
    "5.1.3.1\tRibulose-phosphate 3-epimerase",
    "5.1.3.2\tUDP-glucose 4-epimerase",
    "5.1.3.3\tAldose 1-epimerase",
    "5.1.3.4\tL-ribulose-5-phosphate 4-epimerase",
    "5.1.3.5\tUDP-arabinose 4-epimerase",
    "5.1.3.6\tUDP-glucuronate 4-epimerase",
    "5.1.3.7\tUDP-N-acetylglucosamine 4-epimerase",
    "5.1.3.8\tN-acylglucosamine 2-epimerase",
    "5.1.3.9\tN-acylglucosamine-6-phosphate 2-epimerase",
    "5.1.3.10\tCDP-paratose 2-epimerase",
    "5.1.3.11\tCellobiose epimerase",
    "5.1.3.13\tdTDP-4-dehydrorhamnose 3,5-epimerase",
    "5.1.3.14\tUDP-N-acetylglucosamine 2-epimerase (non-hydrolyzing)",
    "5.1.3.15\tGlucose-6-phosphate 1-epimerase",
    "5.1.3.16\tUDP-glucosamine 4-epimerase",
    "5.1.3.17\tHeparosan-N-sulfate-glucuronate 5-epimerase",
    "5.1.3.18\tGDP-mannose 3,5-epimerase",
    "5.1.3.19\tChondroitin-glucuronate 5-epimerase",
    "5.1.3.20\tADP-glyceromanno-heptose 6-epimerase",
    "5.1.3.21\tMaltose epimerase",
    "5.1.3.22\tL-ribulose-5-phosphate 3-epimerase",
    "5.1.3.23\tUDP-2,3-diacetamido-2,3-dideoxyglucuronic acid 2-epimerase",
    "5.1.3.24\tN-acetylneuraminate epimerase",
    "5.1.3.25\tdTDP-L-rhamnose 4-epimerase",
    "5.1.3.26\tN-acetyl-alpha-D-glucosaminyl-diphospho-ditrans,octacis-undecaprenol 4-epimerase",
    "5.1.3.27\tdTDP-4-dehydro-6-deoxy-D-glucose 3-epimerase",
    "5.1.3.28\tUDP-N-acetyl-L-fucosamine synthase",
    "5.1.3.29\tL-fucose mutarotase",
    "5.1.3.30\tD-psicose 3-epimerase",
    "5.1.3.31\tD-tagatose 3-epimerase",
    "5.1.3.32\tL-rhamnose mutarotase",
    "5.1.3.33\t2-epi-5-epi-valiolone epimerase",
    "5.1.3.34\tMonoglucosyldiacylglycerol epimerase",
    "5.1.3.35\t2-epi-5-epi-valiolone 7-phosphate 2-epimerase",
    "5.1.3.36\tHeparosan-glucuronate 5-epimerase",
    "5.1.3.37\tMannuronan 5-epimerase",
    "5.1.3.38\tD-erythrulose 1-phosphate 3-epimerase",
    "5.1.3.40\tD-tagatose 6-phosphate 4-epimerase",
    "5.1.3.41\tFructoselysine 3-epimerase",
    "5.1.3.42\tD-glucosamine-6-phosphate 4-epimerase",
    "5.1.3.43\tSulfoquinovose mutarotase",
    "5.1.3.44\tMannose 2-epimerase",
    "5.1.99.1\tMethylmalonyl-CoA epimerase",
    "5.1.99.2\t16-hydroxysteroid epimerase",
    "5.1.99.3\tAllantoin racemase",
    "5.1.99.4\tAlpha-methylacyl-CoA racemase",
    "5.1.99.5\tHydantoin racemase",
    "5.1.99.6\tNAD(P)H-hydrate epimerase",
    "5.1.99.7\tDihydroneopterin triphosphate 2'-epimerase",
    "5.1.99.8\t7,8-dihydroneopterin epimerase",
    "5.2.1.1\tMaleate isomerase",
    "5.2.1.2\tMaleylacetoacetate isomerase",
    "5.2.1.4\tMaleylpyruvate isomerase",
    "5.2.1.5\tLinoleate isomerase",
    "5.2.1.6\tFurylfuramide isomerase",
    "5.2.1.8\tPeptidylprolyl isomerase",
    "5.2.1.9\tFarnesol 2-isomerase",
    "5.2.1.10\t2-chloro-4-carboxymethylenebut-2-en-1,4-olide isomerase",
    "5.2.1.12\tZeta-carotene isomerase",
    "5.2.1.13\tProlycopene isomerase",
    "5.2.1.14\tBeta-carotene isomerase",
    "5.3.1.1\tTriose-phosphate isomerase",
    "5.3.1.3\tD-arabinose isomerase",
    "5.3.1.4\tL-arabinose isomerase",
    "5.3.1.5\tXylose isomerase",
    "5.3.1.6\tRibose-5-phosphate isomerase",
    "5.3.1.7\tMannose isomerase",
    "5.3.1.8\tMannose-6-phosphate isomerase",
    "5.3.1.9\tGlucose-6-phosphate isomerase",
    "5.3.1.12\tGlucuronate isomerase",
    "5.3.1.13\tArabinose-5-phosphate isomerase",
    "5.3.1.14\tL-rhamnose isomerase",
    "5.3.1.15\tD-lyxose ketol-isomerase",
    "5.3.1.16\t1-(5-phosphoribosyl)-5-((5-phosphoribosylamino)methylideneamino)imidazole-4-carboxamide isomerase",
    "5.3.1.17\t5-dehydro-4-deoxy-D-glucuronate isomerase",
    "5.3.1.20\tRibose isomerase",
    "5.3.1.21\tCorticosteroid side-chain-isomerase",
    "5.3.1.22\tHydroxypyruvate isomerase",
    "5.3.1.23\tS-methyl-5-thioribose-1-phosphate isomerase",
    "5.3.1.24\tPhosphoribosylanthranilate isomerase",
    "5.3.1.25\tL-fucose isomerase",
    "5.3.1.26\tGalactose-6-phosphate isomerase",
    "5.3.1.27\t6-phospho-3-hexuloisomerase",
    "5.3.1.28\tD-sedoheptulose 7-phosphate isomerase",
    "5.3.1.29\tRibose 1,5-bisphosphate isomerase",
    "5.3.1.30\t5-deoxy-glucuronate isomerase",
    "5.3.1.31\tSulfoquinovose isomerase",
    "5.3.1.32\t(4S)-4-hydroxy-5-phosphooxypentane-2,3-dione isomerase",
    "5.3.1.33\tL-erythrulose 1-phosphate isomerase",
    "5.3.1.34\tD-erythrulose 4-phosphate isomerase",
    "5.3.1.35\t2-dehydrotetronate isomerase",
    "5.3.1.36\tD-apiose isomerase",
    "5.3.2.1\tPhenylpyruvate tautomerase",
    "5.3.2.2\tOxaloacetate tautomerase",
    "5.3.2.3\tTDP-4-oxo-6-deoxy-alpha-D-glucose-3,4-oxoisomerase (dTDP-3-dehydro-6-deoxy-alpha-D-galactopyranose-forming)",
    "5.3.2.4\tTDP-4-oxo-6-deoxy-alpha-D-glucose-3,4-oxoisomerase (dTDP-3-dehydro-6-deoxy-alpha-D-glucopyranose-forming)",
    "5.3.2.5\t2,3-diketo-5-methylthiopentyl-1-phosphate enolase",
    "5.3.2.6\t2-hydroxymuconate tautomerase",
    "5.3.2.7\tAscopyrone tautomerase",
    "5.3.2.8\t4-oxalomesaconate tautomerase",
    "5.3.3.1\tSteroid Delta-isomerase",
    "5.3.3.2\tIsopentenyl-diphosphate Delta-isomerase",
    "5.3.3.3\tVinylacetyl-CoA Delta-isomerase",
    "5.3.3.4\tMuconolactone Delta-isomerase",
    "5.3.3.5\tCholestenol Delta-isomerase",
    "5.3.3.6\tMethylitaconate Delta-isomerase",
    "5.3.3.7\tAconitate Delta-isomerase",
    "5.3.3.8\tDelta(3)-Delta(2)-enoyl-CoA isomerase",
    "5.3.3.9\tProstaglandin-A(1) Delta-isomerase",
    "5.3.3.10\t5-carboxymethyl-2-hydroxymuconate Delta-isomerase",
    "5.3.3.11\tIsopiperitenone Delta-isomerase",
    "5.3.3.12\tL-dopachrome isomerase",
    "5.3.3.13\tPolyenoic fatty acid isomerase",
    "5.3.3.14\tTrans-2-decenoyl-[acyl-carrier-protein] isomerase",
    "5.3.3.17\tTrans-2,3-dihydro-3-hydroxyanthranilate isomerase",
    "5.3.3.18\t2-(1,2-epoxy-1,2-dihydrophenyl)acetyl-CoA isomerase",
    "5.3.3.19\t3-((4R)-4-hydroxycyclohexa-1,5-dien-1-yl)-2-oxopropanoate isomerase",
    "5.3.3.21\tDelta(3,5)-Delta(2,4)-dienoyl-CoA isomerase",
    "5.3.3.22\tLutein isomerase",
    "5.3.3.23\tS-methyl-5-thioribulose 1-phosphate isomerase",
    "5.3.4.1\tProtein disulfide-isomerase",
    "5.3.99.2\tProstaglandin-D synthase",
    "5.3.99.3\tProstaglandin-E synthase",
    "5.3.99.4\tProstaglandin-I synthase",
    "5.3.99.5\tThromboxane-A synthase",
    "5.3.99.6\tAllene-oxide cyclase",
    "5.3.99.7\tStyrene-oxide isomerase",
    "5.3.99.8\tCapsanthin/capsorubin synthase",
    "5.3.99.9\tNeoxanthin synthase",
    "5.3.99.10\tThiazole tautomerase",
    "5.3.99.11\t2-keto-myo-inositol isomerase",
    "5.4.1.1\tLysolecithin acylmutase",
    "5.4.1.3\t2-methylfumaryl-CoA isomerase",
    "5.4.1.4\tD-galactarolactone isomerase",
    "5.4.2.2\tPhosphoglucomutase (alpha-D-glucose-1,6-bisphosphate-dependent)",
    "5.4.2.3\tPhosphoacetylglucosamine mutase",
    "5.4.2.4\tBisphosphoglycerate mutase",
    "5.4.2.5\tPhosphoglucomutase (glucose-cofactor)",
    "5.4.2.6\tBeta-phosphoglucomutase",
    "5.4.2.7\tPhosphopentomutase",
    "5.4.2.8\tPhosphomannomutase",
    "5.4.2.9\tPhosphoenolpyruvate mutase",
    "5.4.2.10\tPhosphoglucosamine mutase",
    "5.4.2.11\tPhosphoglycerate mutase (2,3-diphosphoglycerate-dependent)",
    "5.4.2.12\tPhosphoglycerate mutase (2,3-diphosphoglycerate-independent)",
    "5.4.2.13\tPhosphogalactosamine mutase",
    "5.4.3.2\tLysine 2,3-aminomutase",
    "5.4.3.3\tLysine 5,6-aminomutase",
    "5.4.3.4\tD-lysine 5,6-aminomutase",
    "5.4.3.5\tD-ornithine 4,5-aminomutase",
    "5.4.3.6\tTyrosine 2,3-aminomutase",
    "5.4.3.7\tLeucine 2,3-aminomutase",
    "5.4.3.8\tGlutamate-1-semialdehyde 2,1-aminomutase",
    "5.4.3.9\tGlutamate 2,3-aminomutase",
    "5.4.3.10\tPhenylalanine aminomutase (L-beta-phenylalanine forming)",
    "5.4.3.11\tPhenylalanine aminomutase (D-beta-phenylalanine forming)",
    "5.4.4.1\t(Hydroxyamino)benzene mutase",
    "5.4.4.2\tIsochorismate synthase",
    "5.4.4.3\t3-(hydroxyamino)phenol mutase",
    "5.4.4.4\tGeraniol isomerase",
    "5.4.4.5\t9,12-octadecadienoate 8-hydroperoxide 8R-isomerase",
    "5.4.4.6\t9,12-octadecadienoate 8-hydroperoxide 8S-isomerase",
    "5.4.4.7\tHydroperoxy icosatetraenoate isomerase",
    "5.4.4.8\tLinalool isomerase",
    "5.4.99.1\tMethylaspartate mutase",
    "5.4.99.2\tMethylmalonyl-CoA mutase",
    "5.4.99.3\t2-acetolactate mutase",
    "5.4.99.4\t2-methyleneglutarate mutase",
    "5.4.99.5\tChorismate mutase",
    "5.4.99.7\tLanosterol synthase",
    "5.4.99.8\tCycloartenol synthase",
    "5.4.99.9\tUDP-galactopyranose mutase",
    "5.4.99.11\tIsomaltulose synthase",
    "5.4.99.12\ttRNA pseudouridine(38-40) synthase",
    "5.4.99.13\tIsobutyryl-CoA mutase",
    "5.4.99.14\t4-carboxymethyl-4-methylbutenolide mutase",
    "5.4.99.15\t(1->4)-alpha-D-glucan 1-alpha-D-glucosylmutase",
    "5.4.99.16\tMaltose alpha-D-glucosyltransferase",
    "5.4.99.17\tSqualene--hopene cyclase",
    "5.4.99.18\t5-(carboxyamino)imidazole ribonucleotide mutase",
    "5.4.99.19\t16S rRNA pseudouridine(516) synthase",
    "5.4.99.20\t23S rRNA pseudouridine(2457) synthase",
    "5.4.99.21\t23S rRNA pseudouridine(2604) synthase",
    "5.4.99.22\t23S rRNA pseudouridine(2605) synthase",
    "5.4.99.23\t23S rRNA pseudouridine(1911/1915/1917) synthase",
    "5.4.99.24\t23S rRNA pseudouridine(955/2504/2580) synthase",
    "5.4.99.25\ttRNA pseudouridine(55) synthase",
    "5.4.99.26\ttRNA pseudouridine(65) synthase",
    "5.4.99.27\ttRNA pseudouridine(13) synthase",
    "5.4.99.28\ttRNA pseudouridine(32) synthase",
    "5.4.99.29\t23S rRNA pseudouridine(746) synthase",
    "5.4.99.30\tUDP-arabinopyranose mutase",
    "5.4.99.31\tThalianol synthase",
    "5.4.99.32\tProtostadienol synthase",
    "5.4.99.33\tCucurbitadienol synthase",
    "5.4.99.34\tGermanicol synthase",
    "5.4.99.35\tTaraxerol synthase",
    "5.4.99.36\tIsomultiflorenol synthase",
    "5.4.99.37\tDammaradiene synthase",
    "5.4.99.38\tCamelliol C synthase",
    "5.4.99.39\tBeta-amyrin synthase",
    "5.4.99.40\tAlpha-amyrin synthase",
    "5.4.99.41\tLupeol synthase",
    "5.4.99.42\ttRNA pseudouridine(31) synthase",
    "5.4.99.43\t21S rRNA pseudouridine(2819) synthase",
    "5.4.99.44\tMitochondrial tRNA pseudouridine(27/28) synthase",
    "5.4.99.45\ttRNA pseudouridine(38/39) synthase",
    "5.4.99.46\tShionone synthase",
    "5.4.99.47\tParkeol synthase",
    "5.4.99.48\tAchilleol B synthase",
    "5.4.99.49\tGlutinol synthase",
    "5.4.99.50\tFriedelin synthase",
    "5.4.99.51\tBaccharis oxide synthase",
    "5.4.99.52\tAlpha-seco-amyrin synthase",
    "5.4.99.53\tMarneral synthase",
    "5.4.99.54\tBeta-seco-amyrin synthase",
    "5.4.99.55\tDelta-amyrin synthase",
    "5.4.99.56\tTirucalladienol synthase",
    "5.4.99.57\tBaruol synthase",
    "5.4.99.58\tMethylornithine synthase",
    "5.4.99.59\tdTDP-fucopyranose mutase",
    "5.4.99.60\tCobalt-precorrin-8 methylmutase",
    "5.4.99.61\tPrecorrin-8X methylmutase",
    "5.4.99.62\tD-ribose pyranase",
    "5.4.99.63\tEthylmalonyl-CoA mutase",
    "5.4.99.64\t2-hydroxyisobutanoyl-CoA mutase",
    "5.4.99.65\tPre-alpha-onocerin synthase",
    "5.4.99.66\tAlpha-onocerin synthase",
    "5.4.99.67\t4-amino-4-deoxychorismate mutase",
    "5.5.1.1\tMuconate cycloisomerase",
    "5.5.1.2\t3-carboxy-cis,cis-muconate cycloisomerase",
    "5.5.1.3\tTetrahydroxypteridine cycloisomerase",
    "5.5.1.4\tInositol-3-phosphate synthase",
    "5.5.1.5\tCarboxy-cis,cis-muconate cyclase",
    "5.5.1.6\tChalcone isomerase",
    "5.5.1.7\tChloromuconate cycloisomerase",
    "5.5.1.8\t(+)-bornyl diphosphate synthase",
    "5.5.1.9\tCycloeucalenol cycloisomerase",
    "5.5.1.10\tAlpha-pinene-oxide decyclase",
    "5.5.1.11\tDichloromuconate cycloisomerase",
    "5.5.1.12\tCopalyl diphosphate synthase",
    "5.5.1.13\tEnt-copalyl diphosphate synthase",
    "5.5.1.14\tSyn-copalyl-diphosphate synthase",
    "5.5.1.15\tTerpentedienyl-diphosphate synthase",
    "5.5.1.16\tHalimadienyl-diphosphate synthase",
    "5.5.1.17\t(S)-beta-macrocarpene synthase",
    "5.5.1.18\tLycopene epsilon-cyclase",
    "5.5.1.19\tLycopene beta-cyclase",
    "5.5.1.20\tProsolanapyrone-III cycloisomerase",
    "5.5.1.22\t(-)-bornyl diphosphate synthase",
    "5.5.1.23\tAklanonic acid methyl ester cyclase",
    "5.5.1.24\tTocopherol cyclase",
    "5.5.1.25\t3,6-anhydro-L-galactonate cycloisomerase",
    "5.5.1.26\tNogalonic acid methyl ester cyclase",
    "5.5.1.27\tD-galactarolactone cycloisomerase",
    "5.5.1.28\t(-)-kolavenyl diphosphate synthase",
    "5.5.1.29\t(+)-kolavenyl diphosphate synthase",
    "5.5.1.30\tLabda-7,13-dienyl diphosphate synthase",
    "5.5.1.31\tHapalindole H synthase",
    "5.5.1.32\t12-epi-hapalindole U synthase",
    "5.5.1.33\t12-epi-fischerindole U synthase",
    "5.5.1.34\t(+)-cis,trans-nepetalactol synthase",
    "5.5.1.35\t(+)-cis,cis-nepetalactol synthase",
    "5.6.1.1\tMicrotubule-severing ATPase",
    "5.6.1.2\tDynein ATPase",
    "5.6.1.3\tPlus-end-directed kinesin ATPase",
    "5.6.1.4\tMinus-end-directed kinesin ATPase",
    "5.6.1.5\tProteasome ATPase",
    "5.6.1.6\tChannel-conductance-controlling ATPase",
    "5.6.1.7\tChaperonin ATPase",
    "5.6.1.8\tMyosin ATPase",
    "5.6.1.9\t(R)-2-hydroxyacyl-CoA dehydratase activating ATPase",
    "5.6.2.1\tDNA topoisomerase",
    "5.6.2.2\tDNA topoisomerase (ATP-hydrolyzing)",
    "5.99.1.1\tThiocyanate isomerase",
    "5.99.1.4\t2-hydroxychromene-2-carboxylate isomerase",
    "6.1.1.1\tTyrosine--tRNA ligase",
    "6.1.1.2\tTryptophan--tRNA ligase",
    "6.1.1.3\tThreonine--tRNA ligase",
    "6.1.1.4\tLeucine--tRNA ligase",
    "6.1.1.5\tIsoleucine--tRNA ligase",
    "6.1.1.6\tLysine--tRNA ligase",
    "6.1.1.7\tAlanine--tRNA ligase",
    "6.1.1.9\tValine--tRNA ligase",
    "6.1.1.10\tMethionine--tRNA ligase",
    "6.1.1.11\tSerine--tRNA ligase",
    "6.1.1.12\tAspartate--tRNA ligase",
    "6.1.1.13\tD-alanine--poly(phosphoribitol) ligase",
    "6.1.1.14\tGlycine--tRNA ligase",
    "6.1.1.15\tProline--tRNA ligase",
    "6.1.1.16\tCysteine--tRNA ligase",
    "6.1.1.17\tGlutamate--tRNA ligase",
    "6.1.1.18\tGlutamine--tRNA ligase",
    "6.1.1.19\tArginine--tRNA ligase",
    "6.1.1.20\tPhenylalanine--tRNA ligase",
    "6.1.1.21\tHistidine--tRNA ligase",
    "6.1.1.22\tAsparagine--tRNA ligase",
    "6.1.1.23\tAspartate--tRNA(Asn) ligase",
    "6.1.1.24\tGlutamate--tRNA(Gln) ligase",
    "6.1.1.26\tPyrrolysine--tRNA(Pyl) ligase",
    "6.1.1.27\tO-phosphoserine--tRNA ligase",
    "6.1.2.1\tD-alanine--(R)-lactate ligase",
    "6.1.2.2\tNebramycin 5' synthase",
    "6.1.3.1\tOlefin beta-lactone synthetase",
    "6.2.1.1\tAcetate--CoA ligase",
    "6.2.1.2\tMedium-chain acyl-CoA ligase",
    "6.2.1.3\tLong-chain-fatty-acid--CoA ligase",
    "6.2.1.4\tSuccinate--CoA ligase (GDP-forming)",
    "6.2.1.5\tSuccinate--CoA ligase (ADP-forming)",
    "6.2.1.6\tGlutarate--CoA ligase",
    "6.2.1.7\tCholate--CoA ligase",
    "6.2.1.8\tOxalate--CoA ligase",
    "6.2.1.9\tMalate--CoA ligase",
    "6.2.1.10\tAcid--CoA ligase (GDP-forming)",
    "6.2.1.11\tBiotin--CoA ligase",
    "6.2.1.12\t4-coumarate--CoA ligase",
    "6.2.1.13\tAcetate--CoA ligase (ADP-forming)",
    "6.2.1.14\t6-carboxyhexanoate--CoA ligase",
    "6.2.1.15\tArachidonate--CoA ligase",
    "6.2.1.16\tAcetoacetate--CoA ligase",
    "6.2.1.17\tPropionate--CoA ligase",
    "6.2.1.18\tCitrate--CoA ligase",
    "6.2.1.19\tLong-chain-fatty-acid--protein ligase",
    "6.2.1.20\tLong-chain-fatty-acid--[acyl-carrier-protein] ligase",
    "6.2.1.22\t[Citrate (pro-3S)-lyase] ligase",
    "6.2.1.23\tDicarboxylate--CoA ligase",
    "6.2.1.24\tPhytanate--CoA ligase",
    "6.2.1.25\tBenzoate--CoA ligase",
    "6.2.1.26\to-succinylbenzoate--CoA ligase",
    "6.2.1.27\t4-hydroxybenzoate--CoA ligase",
    "6.2.1.28\t3-alpha,7-alpha-dihydroxy-5-beta-cholestanate--CoA ligase",
    "6.2.1.30\tPhenylacetate--CoA ligase",
    "6.2.1.31\t2-furoate--CoA ligase",
    "6.2.1.32\tAnthranilate--CoA ligase",
    "6.2.1.33\t4-chlorobenzoate--CoA ligase",
    "6.2.1.34\tTrans-feruloyl-CoA synthase",
    "6.2.1.35\tAcetate--[acyl-carrier protein] ligase",
    "6.2.1.36\t3-hydroxypropionyl-CoA synthase",
    "6.2.1.37\t3-hydroxybenzoate--CoA ligase",
    "6.2.1.38\t(2,2,3-trimethyl-5-oxocyclopent-3-enyl)acetyl-CoA synthase",
    "6.2.1.39\t[Butirosin acyl-carrier protein]--L-glutamate ligase",
    "6.2.1.40\t4-hydroxybutyrate--CoA ligase (AMP-forming)",
    "6.2.1.41\t3-((3aS,4S,7aS)-7a-methyl-1,5-dioxo-octahydro-1H-inden-4-yl)propanoate--CoA ligase",
    "6.2.1.42\t3-oxocholest-4-en-26-oate--CoA ligase",
    "6.2.1.43\t2-hydroxy-7-methoxy-5-methyl-1-naphthoate--CoA ligase",
    "6.2.1.44\t3-(methylthio)propionyl--CoA ligase",
    "6.2.1.45\tE1 ubiquitin-activating enzyme",
    "6.2.1.46\tL-allo-isoleucine--holo-[CmaA peptidyl-carrier protein] ligase",
    "6.2.1.47\tMedium-chain-fatty-acid--[acyl-carrier-protein] ligase",
    "6.2.1.48\tCarnitine--CoA ligase",
    "6.2.1.49\tLong-chain fatty acid adenylyltransferase FadD28",
    "6.2.1.50\t4-hydroxybenzoate adenylyltransferase FadD22",
    "6.2.1.51\t4-hydroxyphenylalkanoate adenylyltransferase FadD29",
    "6.2.1.52\tL-firefly luciferin--CoA ligase",
    "6.2.1.53\tL-proline--[L-prolyl-carrier protein] ligase",
    "6.2.1.54\tD-alanine--[D-alanyl-carrier protein] ligase",
    "6.2.1.55\tE1 SAMP-activating enzyme",
    "6.2.1.56\t4-hydroxybutyrate--CoA ligase (ADP-forming)",
    "6.2.1.57\tLong-chain fatty acid adenylase/transferase FadD23",
    "6.2.1.58\tIsophthalate--CoA ligase",
    "6.2.1.59\tLong-chain fatty acid adenylase/transferase FadD26",
    "6.2.1.60\tMarinolic acid--CoA ligase",
    "6.2.1.61\tSalicylate--[aryl-carrier protein] ligase",
    "6.2.1.62\t3,4-dihydroxybenzoate--[aryl-carrier protein] ligase",
    "6.2.1.63\tL-arginine--[L-arginyl-carrier protein] ligase",
    "6.2.1.64\tE1 NEDD8-activating enzyme",
    "6.2.1.65\tSalicylate--CoA ligase",
    "6.2.1.66\tGlyine--[glycyl-carrier protein] ligase",
    "6.2.1.67\tL-alanine--[L-alanyl-carrier protein] ligase",
    "6.2.1.68\tL-glutamate--[L-glutamyl-carrier protein] ligase",
    "6.2.1.69\tL-cysteine--[L-cysteinyl-carrier protein] ligase",
    "6.2.1.70\tL-threonine--[L-threonyl-carrier protein] ligase",
    "6.2.1.71\t2,3-dihydroxybenzoate--[aryl-carrier protein] ligase",
    "6.2.1.72\tL-serine--[L-seryl-carrier protein] ligase",
    "6.2.1.73\tL-tryptophan--[L-tryptophyl-carrier protein] ligase",
    "6.2.1.74\t3-amino-5-hydroxybenzoate--[acyl-carrier protein] ligase",
    "6.2.1.n2\tAmino acid--[acyl-carrier-protein] ligase",
    "6.2.1.n3\tMalonate--CoA ligase",
    "6.2.2.1\tThioglycine synthase",
    "6.2.2.2\tOxazoline synthase",
    "6.2.2.3\tThiazoline synthase",
    "6.3.1.1\tAspartate--ammonia ligase",
    "6.3.1.2\tGlutamine synthetase",
    "6.3.1.4\tAspartate--ammonia ligase (ADP-forming)",
    "6.3.1.5\tNAD(+) synthase",
    "6.3.1.6\tGlutamate--ethylamine ligase",
    "6.3.1.7\t4-methyleneglutamate--ammonia ligase",
    "6.3.1.8\tGlutathionylspermidine synthase",
    "6.3.1.9\tTrypanothione synthase",
    "6.3.1.10\tAdenosylcobinamide-phosphate synthase",
    "6.3.1.11\tGlutamate--putrescine ligase",
    "6.3.1.12\tD-aspartate ligase",
    "6.3.1.13\tL-cysteine:1D-myo-inositol 2-amino-2-deoxy-alpha-D-glucopyranoside ligase",
    "6.3.1.14\tDiphthine--ammonia ligase",
    "6.3.1.15\t8-demethylnovobiocic acid synthase",
    "6.3.1.17\tBeta-citrylglutamate synthase",
    "6.3.1.18\tGamma-glutamylanilide synthase",
    "6.3.1.19\tProkaryotic ubiquitin-like protein ligase",
    "6.3.1.20\tLipoate--protein ligase",
    "6.3.1.21\tPhosphoribosylglycinamide formyltransferase 2",
    "6.3.2.1\tPantoate--beta-alanine ligase (AMP-forming)",
    "6.3.2.2\tGlutamate--cysteine ligase",
    "6.3.2.3\tGlutathione synthase",
    "6.3.2.4\tD-alanine--D-alanine ligase",
    "6.3.2.5\tPhosphopantothenate--cysteine ligase (CTP)",
    "6.3.2.6\tPhosphoribosylaminoimidazolesuccinocarboxamide synthase",
    "6.3.2.7\tUDP-N-acetylmuramoyl-L-alanyl-D-glutamate--L-lysine ligase",
    "6.3.2.8\tUDP-N-acetylmuramate--L-alanine ligase",
    "6.3.2.9\tUDP-N-acetylmuramoyl-L-alanine--D-glutamate ligase",
    "6.3.2.10\tUDP-N-acetylmuramoyl-tripeptide--D-alanyl-D-alanine ligase",
    "6.3.2.11\tCarnosine synthase",
    "6.3.2.12\tDihydrofolate synthase",
    "6.3.2.13\tUDP-N-acetylmuramoyl-L-alanyl-D-glutamate--2,6-diaminopimelate ligase",
    "6.3.2.14\tEnterobactin synthase",
    "6.3.2.16\tD-alanine--alanyl-poly(glycerolphosphate) ligase",
    "6.3.2.17\tTetrahydrofolate synthase",
    "6.3.2.18\tGamma-glutamylhistamine synthase",
    "6.3.2.20\tIndoleacetate--lysine synthetase",
    "6.3.2.23\tHomoglutathione synthase",
    "6.3.2.24\tTyrosine--arginine ligase",
    "6.3.2.25\tTubulin--tyrosine ligase",
    "6.3.2.26\tN-(5-amino-5-carboxypentanoyl)-L-cysteinyl-D-valine synthase",
    "6.3.2.29\tCyanophycin synthase (L-aspartate-adding)",
    "6.3.2.30\tCyanophycin synthase (L-arginine-adding)",
    "6.3.2.31\tCoenzyme F420-0:L-glutamate ligase",
    "6.3.2.32\tCoenzyme gamma-F420-2:alpha-L-glutamate ligase",
    "6.3.2.33\tTetrahydrosarcinapterin synthase",
    "6.3.2.34\tCoenzyme F420-1:gamma-L-glutamate ligase",
    "6.3.2.35\tD-alanine--D-serine ligase",
    "6.3.2.36\t4-phosphopantoate--beta-alanine ligase",
    "6.3.2.37\tUDP-N-acetylmuramoyl-L-alanyl-D-glutamate--D-lysine ligase",
    "6.3.2.38\tN(2)-citryl-N(6)-acetyl-N(6)-hydroxylysine synthase",
    "6.3.2.39\tAerobactin synthase",
    "6.3.2.40\tCyclopeptine synthase",
    "6.3.2.41\tN-acetylaspartylglutamate synthase",
    "6.3.2.42\tN-acetylaspartylglutamylglutamate synthase",
    "6.3.2.43\t[Amino-group carrier protein]--L-2-aminoadipate ligase",
    "6.3.2.44\tPantoate--beta-alanine ligase (ADP-forming)",
    "6.3.2.45\tUDP-N-acetylmuramate L-alanyl-gamma-D-glutamyl-meso-2,6-diaminoheptanedioate ligase",
    "6.3.2.46\tFumarate--(S)-2,3-diaminopropanoate ligase",
    "6.3.2.47\tDapdiamide synthase",
    "6.3.2.48\tL-arginine-specific L-amino acid ligase",
    "6.3.2.49\tL-alanine--L-anticapsin ligase",
    "6.3.2.50\tTenuazonic acid synthetase",
    "6.3.2.51\tPhosphopantothenate--cysteine ligase (ATP)",
    "6.3.2.52\tJasmonoyl--L-amino acid ligase",
    "6.3.2.53\tUDP-N-acetylmuramoyl-L-alanine--L-glutamate ligase",
    "6.3.2.54\tL-2,3-diaminopropanoate--citrate ligase",
    "6.3.2.55\t2-((L-alanin-3-ylcarbamoyl)methyl)-3-(2-aminoethylcarbamoyl)-2-hydroxypropanoate synthase",
    "6.3.2.56\tStaphyloferrin B synthase",
    "6.3.2.57\tStaphyloferrin A synthase",
    "6.3.2.58\tD-ornithine--citrate ligase",
    "6.3.2.59\t3-methyl-D-ornithine--L-lysine ligase",
    "6.3.2.60\tGlutamate--[amino group carrier protein] ligase",
    "6.3.2.n3\tISG15--protein ligase",
    "6.3.3.1\tPhosphoribosylformylglycinamidine cyclo-ligase",
    "6.3.3.2\t5-formyltetrahydrofolate cyclo-ligase",
    "6.3.3.3\tDethiobiotin synthase",
    "6.3.3.4\t(Carboxyethyl)arginine beta-lactam-synthase",
    "6.3.3.5\tO-ureido-D-serine cyclo-ligase",
    "6.3.3.6\tCarbapenam-3-carboxylate synthase",
    "6.3.3.7\tNi-sirohydrochlorin a,c-diamide reductive cyclase",
    "6.3.4.2\tCTP synthase (glutamine hydrolyzing)",
    "6.3.4.3\tFormate--tetrahydrofolate ligase",
    "6.3.4.4\tAdenylosuccinate synthase",
    "6.3.4.5\tArgininosuccinate synthase",
    "6.3.4.6\tUrea carboxylase",
    "6.3.4.7\tRibose-5-phosphate--ammonia ligase",
    "6.3.4.8\tImidazoleacetate--phosphoribosyldiphosphate ligase",
    "6.3.4.9\tBiotin--[methylmalonyl-CoA-carboxytransferase] ligase",
    "6.3.4.10\tBiotin--[propionyl-CoA-carboxylase (ATP-hydrolyzing)] ligase",
    "6.3.4.11\tBiotin--[methylcrotonoyl-CoA-carboxylase] ligase",
    "6.3.4.12\tGlutamate--methylamine ligase",
    "6.3.4.13\tPhosphoribosylamine--glycine ligase",
    "6.3.4.14\tBiotin carboxylase",
    "6.3.4.15\tBiotin--[biotin carboxyl-carrier protein] ligase",
    "6.3.4.16\tCarbamoyl-phosphate synthase (ammonia)",
    "6.3.4.17\tFormate--dihydrofolate ligase",
    "6.3.4.18\t5-(carboxyamino)imidazole ribonucleotide synthase",
    "6.3.4.19\ttRNA(Ile)-lysidine synthetase",
    "6.3.4.20\t7-cyano-7-deazaguanine synthase",
    "6.3.4.21\tNicotinate phosphoribosyltransferase",
    "6.3.4.22\ttRNA(Ile)(2)-agmatinylcytidine synthase",
    "6.3.4.23\tFormate--phosphoribosylaminoimidazolecarboxamide ligase",
    "6.3.4.24\tTyramine--L-glutamate ligase",
    "6.3.4.25\t2-amino-2'-deoxyadenylo-succinate synthase",
    "6.3.5.1\tNAD(+) synthase (glutamine-hydrolyzing)",
    "6.3.5.2\tGMP synthase (glutamine-hydrolyzing)",
    "6.3.5.3\tPhosphoribosylformylglycinamidine synthase",
    "6.3.5.4\tAsparagine synthase (glutamine-hydrolyzing)",
    "6.3.5.5\tCarbamoyl-phosphate synthase (glutamine-hydrolyzing)",
    "6.3.5.6\tAsparaginyl-tRNA synthase (glutamine-hydrolyzing)",
    "6.3.5.7\tGlutaminyl-tRNA synthase (glutamine-hydrolyzing)",
    "6.3.5.9\tHydrogenobyrinic acid a,c-diamide synthase (glutamine-hydrolyzing)",
    "6.3.5.10\tAdenosylcobyric acid synthase (glutamine-hydrolyzing)",
    "6.3.5.11\tCobyrinate a,c-diamide synthase (glutamine-hydrolyzing)",
    "6.3.5.12\tNi-sirohydrochlorin a,c-diamide synthase",
    "6.3.5.13\tLipid II isoglutaminyl synthase (glutamine-hydrolyzing)",
    "6.4.1.1\tPyruvate carboxylase",
    "6.4.1.2\tAcetyl-CoA carboxylase",
    "6.4.1.3\tPropionyl-CoA carboxylase",
    "6.4.1.4\tMethylcrotonoyl-CoA carboxylase",
    "6.4.1.5\tGeranoyl-CoA carboxylase",
    "6.4.1.6\tAcetone carboxylase",
    "6.4.1.7\t2-oxoglutarate carboxylase",
    "6.4.1.8\tAcetophenone carboxylase",
    "6.4.1.9\tCoenzyme F(430) synthetase",
    "6.5.1.1\tDNA ligase (ATP)",
    "6.5.1.2\tDNA ligase (NAD(+))",
    "6.5.1.3\tRNA ligase (ATP)",
    "6.5.1.4\tRNA 3'-terminal-phosphate cyclase (ATP)",
    "6.5.1.5\tRNA 3'-terminal-phosphate cyclase (GTP)",
    "6.5.1.6\tDNA ligase (ATP or NAD(+))",
    "6.5.1.7\tDNA ligase (ATP, ADP or GTP)",
    "6.5.1.8\t3'-phosphate/5'-hydroxy nucleic acid ligase",
    "6.5.1.9\tCyclic 2,3-diphosphoglycerate synthase",
    "6.6.1.1\tMagnesium chelatase",
    "6.6.1.2\tCobaltochelatase",
    "7.1.1.1\tProton-translocating NAD(P)(+) transhydrogenase",
    "7.1.1.2\tNADH:ubiquinone reductase (H(+)-translocating)",
    "7.1.1.3\tUbiquinol oxidase (H(+)-transporting)",
    "7.1.1.4\tCaldariellaquinol oxidase (H(+)-transporting)",
    "7.1.1.5\tMenaquinol oxidase (H(+)-transporting)",
    "7.1.1.6\tPlastoquinol--plastocyanin reductase",
    "7.1.1.7\tUbiquinol oxidase (electrogenic, proton-motive force generating)",
    "7.1.1.8\tQuinol--cytochrome-c reductase",
    "7.1.1.9\tCytochrome-c oxidase",
    "7.1.1.10\tFerredoxin--quinone oxidoreductase (H(+)-translocating)",
    "7.1.1.11\tFerredoxin--NAD(+) oxidoreductase (H(+)-transporting)",
    "7.1.2.1\tP-type H(+)-exporting transporter",
    "7.1.2.2\tH(+)-transporting two-sector ATPase",
    "7.1.3.1\tH(+)-exporting diphosphatase",
    "7.1.3.2\tNa(+)-exporting diphosphatase",
    "7.2.1.1\tNADH:ubiquinone reductase (Na(+)-transporting)",
    "7.2.1.2\tFerredoxin--NAD(+) oxidoreductase (Na(+)-transporting)",
    "7.2.1.3\tAscorbate ferrireductase (transmembrane)",
    "7.2.2.1\tNa(+)-transporting two-sector ATPase",
    "7.2.2.2\tABC-type Cd(2+) transporter",
    "7.2.2.3\tP-type Na(+) transporter",
    "7.2.2.4\tABC-type Na(+) transporter",
    "7.2.2.5\tABC-type Mn(2+) transporter",
    "7.2.2.6\tP-type K(+) transporter",
    "7.2.2.7\tABC-type Fe(3+) transporter",
    "7.2.2.8\tP-type Cu(+) transporter",
    "7.2.2.9\tP-type Cu(2+) transporter",
    "7.2.2.10\tP-type Ca(2+) transporter",
    "7.2.2.11\tABC-type Ni(2+) transporter",
    "7.2.2.12\tP-type Zn(2+) transporter",
    "7.2.2.13\tNa(+)/K(+)-exchanging ATPase",
    "7.2.2.14\tP-type Mg(2+) transporter",
    "7.2.2.15\tP-type Ag(+) transporter",
    "7.2.2.16\tABC-type ferric hydroxamate transporter",
    "7.2.2.17\tABC-type ferric enterobactin transporter",
    "7.2.2.18\tABC-type ferric citrate transporter",
    "7.2.2.19\tH(+)/K(+)-exchanging ATPase",
    "7.2.2.20\tABC-type Zn(2+) transporter",
    "7.2.2.21\tCd(2+)-exporting ATPase",
    "7.2.2.22\tP-type Mn(2+) transporter",
    "7.2.4.1\tCarboxybiotin decarboxylase",
    "7.2.4.2\tOxaloacetate decarboxylase (Na(+) extruding)",
    "7.2.4.3\t(S)-methylmalonyl-CoA decarboxylase (sodium-transporting)",
    "7.2.4.4\tBiotin-dependent malonate decarboxylase",
    "7.2.4.5\tGlutaconyl-CoA decarboxylase",
    "7.3.2.1\tABC-type phosphate transporter",
    "7.3.2.2\tABC-type phosphonate transporter",
    "7.3.2.3\tABC-type sulfate transporter",
    "7.3.2.4\tABC-type nitrate transporter",
    "7.3.2.5\tABC-type molybdate transporter",
    "7.3.2.6\tABC-type tungstate transporter",
    "7.3.2.7\tArsenite-transporting ATPase",
    "7.4.2.1\tABC-type polar-amino-acid transporter",
    "7.4.2.2\tABC-type nonpolar-amino-acid transporter",
    "7.4.2.3\tMitochondrial protein-transporting ATPase",
    "7.4.2.4\tChloroplast protein-transporting ATPase",
    "7.4.2.5\tBacterial ABC-type protein transporter",
    "7.4.2.6\tABC-type oligopeptide transporter",
    "7.4.2.7\tABC-type alpha-factor-pheromone transporter",
    "7.4.2.8\tProtein-secreting ATPase",
    "7.4.2.9\tABC-type dipeptide transporter",
    "7.4.2.10\tABC-type glutathione transporter",
    "7.4.2.11\tABC-type methionine transporter",
    "7.4.2.12\tABC-type cystine transporter",
    "7.4.2.13\tABC-type tyrosine transporter",
    "7.4.2.14\tABC-type antigen peptide transporter",
    "7.5.2.1\tABC-type maltose transporter",
    "7.5.2.2\tABC-type oligosaccharide transporter",
    "7.5.2.3\tABC-type beta-glucan transporter",
    "7.5.2.4\tABC-type teichoic-acid transporter",
    "7.5.2.5\tABC-type lipopolysaccharide transporter",
    "7.5.2.6\tABC-type lipid A-core oligosaccharide transporter",
    "7.5.2.7\tABC-type D-ribose transporter",
    "7.5.2.8\tABC-type D-allose transporter",
    "7.5.2.9\tABC-type D-galactofuranose transporter",
    "7.5.2.10\tABC-type D-xylose transporter",
    "7.5.2.11\tABC-type D-galactose transporter",
    "7.5.2.12\tABC-type L-arabinose transporter",
    "7.5.2.13\tABC-type D-xylose/L-arabinose transporter",
    "7.6.2.1\tP-type phospholipid transporter",
    "7.6.2.2\tABC-type xenobiotic transporter",
    "7.6.2.3\tABC-type glutathione-S-conjugate transporter",
    "7.6.2.4\tABC-type fatty-acyl-CoA transporter",
    "7.6.2.5\tABC-type heme transporter",
    "7.6.2.6\tABC-type guanine transporter",
    "7.6.2.7\tABC-type taurine transporter",
    "7.6.2.8\tABC-type vitamin B12 transporter",
    "7.6.2.9\tABC-type quaternary amine transporter",
    "7.6.2.10\tABC-type glycerol 3-phosphate transporter",
    "7.6.2.11\tABC-type polyamine transporter",
    "7.6.2.12\tABC-type capsular-polysaccharide transporter",
    "7.6.2.13\tABC-type autoinducer-2 transporter",
    "7.6.2.14\tABC-type aliphatic sulfonate transporter",
    "7.6.2.15\tABC-type thiamine transporter",
    "7.6.2.16\tABC-type putrescine transporter"
};
