from typing import List, Tuple, Optional, Callable, Union, IO, Any, Dict, Mapping, Text
from datetime import datetime, tzinfo

_FileOrStr = Union[bytes, Text, IO[str], IO[Any]]

__all__ = ...  # type: List[str]

class parserinfo(object):
    JUMP = ...  # type: List[str]
    WEEKDAYS = ...  # type: List[Tuple[str, str]]
    MONTHS = ...  # type: List[Tuple[str, str]]
    HMS = ...  # type: List[Tuple[str, str, str]]
    AMPM = ...  # type: List[Tuple[str, str]]
    UTCZONE = ...  # type: List[str]
    PERTAIN = ...  # type: List[str]
    TZOFFSET = ...  # type: Dict[str, int]

    def __init__(self, dayfirst: bool=..., yearfirst: bool=...) -> None: ...
    def jump(self, name: Text) -> bool: ...
    def weekday(self, name: Text) -> Optional[int]: ...
    def month(self, name: Text) -> Optional[int]: ...
    def hms(self, name: Text) -> Optional[int]: ...
    def ampm(self, name: Text) -> Optional[int]: ...
    def pertain(self, name: Text) -> bool: ...
    def utczone(self, name: Text) -> bool: ...
    def tzoffset(self, name: Text) -> Optional[int]: ...
    def convertyear(self, year: int) -> int: ...
    def validate(self, res: datetime) -> bool: ...

class parser(object):
    def __init__(self, info: Optional[parserinfo] = ...) -> None: ...
    def parse(self, timestr: _FileOrStr,
              default: Optional[datetime] = ...,
              ignoretz: bool = ..., tzinfos: Optional[Mapping[Text, tzinfo]] = ...,
              **kwargs: Any) -> datetime: ...

DEFAULTPARSER = ...  # type: parser
def parse(timestr: _FileOrStr, parserinfo: Optional[parserinfo] = ..., **kwargs: Any) -> datetime: ...
class _tzparser: ...

DEFAULTTZPARSER = ...  # type: _tzparser

class InvalidDatetimeError(ValueError): ...
class InvalidDateError(InvalidDatetimeError): ...
class InvalidTimeError(InvalidDatetimeError): ...
