/*******************************************************************************
*                                                                              *
*   (C) 1997-2021 by Ernst W. Mayer.                                           *
*                                                                              *
*  This program is free software; you can redistribute it and/or modify it     *
*  under the terms of the GNU General Public License as published by the       *
*  Free Software Foundation; either version 2 of the License, or (at your      *
*  option) any later version.                                                  *
*                                                                              *
*  This program is distributed in the hope that it will be useful, but WITHOUT *
*  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
*  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for   *
*  more details.                                                               *
*                                                                              *
*  You should have received a copy of the GNU General Public License along     *
*  with this program; see the file GPL.txt.  If not, you may view one at       *
*  http://www.fsf.org/licenses/licenses.html, or obtain one by writing to the  *
*  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA     *
*  02111-1307, USA.                                                            *
*                                                                              *
*******************************************************************************/

/****************************************************************************
 * We now include this header file if it was not included before.
 ****************************************************************************/
#ifndef radix4032_avx_negadwt_consts_included
#define radix4032_avx_negadwt_consts_included

	#include "types.h"

	const uint64 radix4032_avx_negadwt_consts[4032] = {	// 8 entries per line ==> RADIX/8 lines:
		0x3FF0000000000000ull,0x3FEFFFFFD742236Eull,0x3FEFFFFF5D088E20ull,0x3FEFFFFE9153414Eull,0x3FEFFFFD74223EFDull,0x3FEFFFFC05758A04ull,0x3FEFFFFA454D2609ull,0x3FEFFFF833A91781ull,
		0x3FEFFFF5D08963B1ull,0x3FEFFFF31BEE10ADull,0x3FEFFFF015D72557ull,0x3FEFFFECBE44A965ull,0x3FEFFFE91536A557ull,0x3FEFFFE51AAD2281ull,0x3FEFFFE0CEA82B03ull,0x3FEFFFDC3127C9CFull,
		0x3FEFFFD7422C0AA5ull,0x3FEFFFD201B4FA16ull,0x3FEFFFCC6FC2A580ull,0x3FEFFFC68C551B13ull,0x3FEFFFC0576C69CDull,0x3FEFFFB9D108A17Cull,0x3FEFFFB2F929D2BEull,0x3FEFFFABCFD00EFFull,
		0x3FEFFFA454FB687Bull,0x3FEFFF9C88ABF240ull,0x3FEFFF946AE1C027ull,0x3FEFFF8BFB9CE6DCull,0x3FEFFF833ADD7BD8ull,0x3FEFFF7A28A39566ull,0x3FEFFF70C4EF4AA0ull,0x3FEFFF670FC0B36Cull,
		0x3FEFFF5D0917E885ull,0x3FEFFF52B0F50370ull,0x3FEFFF4807581E86ull,0x3FEFFF3D0C4154EDull,0x3FEFFF31BFB0C29Bull,0x3FEFFF2621A68455ull,0x3FEFFF1A3222B7B1ull,0x3FEFFF0DF1257B13ull,
		0x3FEFFF015EAEEDAEull,0x3FEFFEF47ABF2F87ull,0x3FEFFEE74556616Full,0x3FEFFED9BE74A509ull,0x3FEFFECBE61A1CC7ull,0x3FEFFEBDBC46EBEBull,0x3FEFFEAF40FB3684ull,0x3FEFFEA074372172ull,
		0x3FEFFE9155FAD266ull,0x3FEFFE81E6466FDEull,0x3FEFFE72251A2129ull,0x3FEFFE6212760E64ull,0x3FEFFE51AE5A607Eull,0x3FEFFE40F8C74131ull,0x3FEFFE2FF1BCDB0Cull,0x3FEFFE1E993B596Aull,
		0x3FEFFE0CEF42E875ull,0x3FEFFDFAF3D3B528ull,0x3FEFFDE8A6EDED4Dull,0x3FEFFDD60891BF7Eull,0x3FEFFDC318BF5B23ull,0x3FEFFDAFD776F075ull,0x3FEFFD9C44B8B07Bull,0x3FEFFD886084CD0Dull,
		0x3FEFFD742ADB78D0ull,0x3FEFFD5FA3BCE73Cull,0x3FEFFD4ACB294C95ull,0x3FEFFD35A120DDF0ull,0x3FEFFD2025A3D131ull,0x3FEFFD0A58B25D0Dull,0x3FEFFCF43A4CB906ull,0x3FEFFCDDCA731D6Eull,
		0x3FEFFCC70925C367ull,0x3FEFFCAFF664E4E3ull,0x3FEFFC989230BCA3ull,0x3FEFFC80DC898636ull,0x3FEFFC68D56F7DFCull,0x3FEFFC507CE2E124ull,0x3FEFFC37D2E3EDABull,0x3FEFFC1ED772E261ull,
		0x3FEFFC058A8FFEE1ull,0x3FEFFBEBEC3B8399ull,0x3FEFFBD1FC75B1C3ull,0x3FEFFBB7BB3ECB6Cull,0x3FEFFB9D2897136Eull,0x3FEFFB82447ECD72ull,0x3FEFFB670EF63DF3ull,0x3FEFFB4B87FDAA38ull,
		0x3FEFFB2FAF95585Aull,0x3FEFFB1385BD8F41ull,0x3FEFFAF70A7696A3ull,0x3FEFFADA3DC0B706ull,0x3FEFFABD1F9C39C0ull,0x3FEFFA9FB00968F5ull,0x3FEFFA81EF088F9Bull,0x3FEFFA63DC99F974ull,
		0x3FEFFA4578BDF313ull,0x3FEFFA26C374C9DCull,0x3FEFFA07BCBECBFEull,0x3FEFF9E8649C487Cull,0x3FEFF9C8BB0D8F26ull,0x3FEFF9A8C012F09Aull,0x3FEFF98873ACBE49ull,0x3FEFF967D5DB4A70ull,
		0x3FEFF946E69EE81Dull,0x3FEFF925A5F7EB2Dull,0x3FEFF90413E6A84Cull,0x3FEFF8E2306B74F5ull,0x3FEFF8BFFB86A774ull,0x3FEFF89D753896E3ull,0x3FEFF87A9D819B2Aull,0x3FEFF85774620D04ull,
		0x3FEFF833F9DA45F7ull,0x3FEFF8102DEAA05Bull,0x3FEFF7EC10937757ull,0x3FEFF7C7A1D526E0ull,0x3FEFF7A2E1B00BBDull,0x3FEFF77DD0248380ull,0x3FEFF7586D32EC8Full,0x3FEFF732B8DBA61Cull,
		0x3FEFF70CB31F1029ull,0x3FEFF6E65BFD8B88ull,0x3FEFF6BFB37779D9ull,0x3FEFF698B98D3D8Dull,0x3FEFF6716E3F39E3ull,0x3FEFF649D18DD2E9ull,0x3FEFF621E3796D7Eull,0x3FEFF5F9A4026F4Eull,
		0x3FEFF5D113293ED5ull,0x3FEFF5A830EE4360ull,0x3FEFF57EFD51E508ull,0x3FEFF55578548CB8ull,0x3FEFF52BA1F6A428ull,0x3FEFF5017A3895E2ull,0x3FEFF4D7011ACD3Dull,0x3FEFF4AC369DB65Full,
		0x3FEFF4811AC1BE3Full,0x3FEFF455AD8752A2ull,0x3FEFF429EEEEE21Cull,0x3FEFF3FDDEF8DC10ull,0x3FEFF3D17DA5B0B2ull,0x3FEFF3A4CAF5D104ull,0x3FEFF377C6E9AED6ull,0x3FEFF34A7181BCC8ull,
		0x3FEFF31CCABE6E4Cull,0x3FEFF2EED2A0379Eull,0x3FEFF2C089278DCDull,0x3FEFF291EE54E6B5ull,0x3FEFF2630228B903ull,0x3FEFF233C4A37C32ull,0x3FEFF20435C5A88Dull,0x3FEFF1D4558FB72Cull,
		0x3FEFF1A4240221F9ull,0x3FEFF173A11D63ABull,0x3FEFF142CCE1F7C9ull,0x3FEFF111A7505AAAull,0x3FEFF0E030690971ull,0x3FEFF0AE682C8214ull,0x3FEFF07C4E9B4356ull,0x3FEFF049E3B5CCC9ull,
		0x3FEFF017277C9ECFull,0x3FEFEFE419F03A98ull,0x3FEFEFB0BB112225ull,0x3FEFEF7D0ADFD843ull,0x3FEFEF49095CE090ull,0x3FEFEF14B688BF7Aull,0x3FEFEEE01263FA3Dull,0x3FEFEEAB1CEF16E3ull,
		0x3FEFEE75D62A9C46ull,0x3FEFEE403E171210ull,0x3FEFEE0A54B500BAull,0x3FEFEDD41A04F189ull,0x3FEFED9D8E076E94ull,0x3FEFED66B0BD02C1ull,0x3FEFED2F822639C3ull,0x3FEFECF80243A01Full,
		0x3FEFECC03115C326ull,0x3FEFEC880E9D30F9ull,0x3FEFEC4F9ADA788Aull,0x3FEFEC16D5CE2997ull,0x3FEFEBDDBF78D4AEull,0x3FEFEBA457DB0B2Cull,0x3FEFEB6A9EF55F3Full,0x3FEFEB3094C863E1ull,
		0x3FEFEAF63954ACDCull,0x3FEFEABB8C9ACECAull,0x3FEFEA808E9B5F12ull,0x3FEFEA453F56F3ECull,0x3FEFEA099ECE245Dull,0x3FEFE9CDAD01883Aull,0x3FEFE99169F1B828ull,0x3FEFE954D59F4D98ull,
		0x3FEFE917F00AE2CDull,0x3FEFE8DAB93512D7ull,0x3FEFE89D311E7996ull,0x3FEFE85F57C7B3B8ull,0x3FEFE8212D315EBAull,0x3FEFE7E2B15C18E9ull,0x3FEFE7A3E448815Full,0x3FEFE764C5F73806ull,
		0x3FEFE7255668DD97ull,0x3FEFE6E5959E139Bull,0x3FEFE6A583977C66ull,0x3FEFE6652055BB1Full,0x3FEFE6246BD973BAull,0x3FEFE5E366234AFAull,0x3FEFE5A20F33E671ull,0x3FEFE560670BEC7Full,
		0x3FEFE51E6DAC0454ull,0x3FEFE4DC2314D5EEull,0x3FEFE49987470A1Aull,0x3FEFE4569A434A75ull,0x3FEFE4135C0A4168ull,0x3FEFE3CFCC9C9A2Eull,0x3FEFE38BEBFB00CFull,0x3FEFE347BA262221ull,
		0x3FEFE303371EABCBull,0x3FEFE2BE62E54C40ull,0x3FEFE2793D7AB2C6ull,0x3FEFE233C6DF8F6Cull,0x3FEFE1EDFF149315ull,0x3FEFE1A7E61A6F70ull,0x3FEFE1617BF1D6FAull,0x3FEFE11AC09B7D02ull,
		0x3FEFE0D3B41815A2ull,0x3FEFE08C566855C5ull,0x3FEFE044A78CF324ull,0x3FEFDFFCA786A447ull,0x3FEFDFB456562084ull,0x3FEFDF6BB3FC2001ull,0x3FEFDF22C0795BB1ull,0x3FEFDED97BCE8D56ull,
		0x3FEFDE8FE5FC6F82ull,0x3FEFDE45FF03BD95ull,0x3FEFDDFBC6E533BCull,0x3FEFDDB13DA18EF5ull,0x3FEFDD6663398D0Cull,0x3FEFDD1B37ADEC9Aull,0x3FEFDCCFBAFF6D09ull,0x3FEFDC83ED2ECE90ull,
		0x3FEFDC37CE3CD235ull,0x3FEFDBEB5E2A39CDull,0x3FEFDB9E9CF7C7FAull,0x3FEFDB518AA64030ull,0x3FEFDB04273666ADull,0x3FEFDAB672A90081ull,0x3FEFDA686CFED38Aull,0x3FEFDA1A1638A674ull,
		0x3FEFD9CB6E5740B8ull,0x3FEFD97C755B6AA0ull,0x3FEFD92D2B45ED44ull,0x3FEFD8DD9017928Aull,0x3FEFD88DA3D12526ull,0x3FEFD83D6673709Bull,0x3FEFD7ECD7FF413Bull,0x3FEFD79BF8756426ull,
		0x3FEFD74AC7D6A74Bull,0x3FEFD6F94623D966ull,0x3FEFD6A7735DCA03ull,0x3FEFD6554F85497Cull,0x3FEFD602DA9B28F9ull,0x3FEFD5B014A03A71ull,0x3FEFD55CFD9550A9ull,0x3FEFD509957B3F34ull,
		0x3FEFD4B5DC52DA75ull,0x3FEFD461D21CF79Cull,0x3FEFD40D76DA6CA8ull,0x3FEFD3B8CA8C1066ull,0x3FEFD363CD32BA71ull,0x3FEFD30E7ECF4333ull,0x3FEFD2B8DF6283E5ull,0x3FEFD262EEED568Dull,
		0x3FEFD20CAD709600ull,0x3FEFD1B61AED1DE2ull,0x3FEFD15F3763CAA3ull,0x3FEFD10802D57984ull,0x3FEFD0B07D430893ull,0x3FEFD058A6AD56ADull,0x3FEFD0007F15437Cull,0x3FEFCFA8067BAF7Aull,
		0x3FEFCF4F3CE17BEDull,0x3FEFCEF622478AEBull,0x3FEFCE9CB6AEBF58ull,0x3FEFCE42FA17FCE7ull,0x3FEFCDE8EC842817ull,0x3FEFCD8E8DF42637ull,0x3FEFCD33DE68DD64ull,0x3FEFCCD8DDE33489ull,
		0x3FEFCC7D8C64135Full,0x3FEFCC21E9EC626Dull,0x3FEFCBC5F67D0B09ull,0x3FEFCB69B216F756ull,0x3FEFCB0D1CBB1247ull,0x3FEFCAB0366A479Bull,0x3FEFCA52FF2583E1ull,0x3FEFC9F576EDB475ull,
		0x3FEFC9979DC3C781ull,0x3FEFC93973A8ABFEull,0x3FEFC8DAF89D51B3ull,0x3FEFC87C2CA2A934ull,0x3FEFC81D0FB9A3E4ull,0x3FEFC7BDA1E333F4ull,0x3FEFC75DE3204C64ull,0x3FEFC6FDD371E0FFull,
		0x3FEFC69D72D8E661ull,0x3FEFC63CC15651F4ull,0x3FEFC5DBBEEB19EFull,0x3FEFC57A6B983556ull,0x3FEFC518C75E9BFDull,0x3FEFC4B6D23F4685ull,0x3FEFC4548C3B2E5Dull,0x3FEFC3F1F5534DC3ull,
		0x3FEFC38F0D889FC2ull,0x3FEFC32BD4DC2033ull,0x3FEFC2C84B4ECBBCull,0x3FEFC26470E19FD3ull,0x3FEFC20045959ABBull,0x3FEFC19BC96BBB85ull,0x3FEFC136FC650210ull,0x3FEFC0D1DE826F08ull,
		0x3FEFC06C6FC503E7ull,0x3FEFC006B02DC2F7ull,0x3FEFBFA09FBDAF4Eull,0x3FEFBF3A3E75CCCFull,0x3FEFBED38C57202Eull,0x3FEFBE6C8962AEE9ull,0x3FEFBE0535997F50ull,0x3FEFBD9D90FC987Cull,
		0x3FEFBD359B8D0258ull,0x3FEFBCCD554BC59Bull,0x3FEFBC64BE39EBCAull,0x3FEFBBFBD6587F37ull,0x3FEFBB929DA88B04ull,0x3FEFBB29142B1B1Eull,0x3FEFBABF39E13C42ull,0x3FEFBA550ECBFBF9ull,
		0x3FEFB9EA92EC689Bull,0x3FEFB97FC643914Dull,0x3FEFB914A8D28603ull,0x3FEFB8A93A9A577Cull,0x3FEFB83D7B9C1747ull,0x3FEFB7D16BD8D7C1ull,0x3FEFB7650B51AC12ull,0x3FEFB6F85A07A833ull,
		0x3FEFB68B57FBE0E8ull,0x3FEFB61E052F6BC4ull,0x3FEFB5B061A35F27ull,0x3FEFB5426D58D23Full,0x3FEFB4D42850DD07ull,0x3FEFB465928C984Aull,0x3FEFB3F6AC0D1D9Cull,0x3FEFB38774D38763ull,
		0x3FEFB317ECE0F0D0ull,0x3FEFB2A8143675E3ull,0x3FEFB237EAD53369ull,0x3FEFB1C770BE46FBull,0x3FEFB156A5F2CF02ull,0x3FEFB0E58A73EAB4ull,0x3FEFB0741E42BA12ull,0x3FEFB00261605DEEull,
		0x3FEFAF9053CDF7E6ull,0x3FEFAF1DF58CAA64ull,0x3FEFAEAB469D98A1ull,0x3FEFAE384701E6A5ull,0x3FEFADC4F6BAB941ull,0x3FEFAD5155C93618ull,0x3FEFACDD642E8398ull,0x3FEFAC6921EBC8FDull,
		0x3FEFABF48F022E4Full,0x3FEFAB7FAB72DC66ull,0x3FEFAB0A773EFCE5ull,0x3FEFAA94F267BA3Eull,0x3FEFAA1F1CEE3FB0ull,0x3FEFA9A8F6D3B945ull,0x3FEFA932801953D8ull,0x3FEFA8BBB8C03D10ull,
		0x3FEFA844A0C9A35Full,0x3FEFA7CD3836B607ull,0x3FEFA7557F08A517ull,0x3FEFA6DD7540A169ull,0x3FEFA6651ADFDCA8ull,0x3FEFA5EC6FE78948ull,0x3FEFA5737458DA8Eull,0x3FEFA4FA2835048Aull,
		0x3FEFA4808B7D3C19ull,0x3FEFA4069E32B6E7ull,0x3FEFA38C6056AB6Bull,0x3FEFA311D1EA50EBull,0x3FEFA296F2EEDF79ull,0x3FEFA21BC3658FF4ull,0x3FEFA1A0434F9C0Aull,0x3FEFA12472AE3E33ull,
		0x3FEFA0A85182B1B7ull,0x3FEFA02BDFCE32AAull,0x3FEF9FAF1D91FDECull,0x3FEF9F320ACF512Cull,0x3FEF9EB4A7876AE4ull,0x3FEF9E36F3BB8A5Dull,0x3FEF9DB8EF6CEFACull,0x3FEF9D3A9A9CDBB3ull,
		0x3FEF9CBBF54C9021ull,0x3FEF9C3CFF7D4F72ull,0x3FEF9BBDB9305CEFull,0x3FEF9B3E2266FCAEull,0x3FEF9ABE3B227393ull,0x3FEF9A3E0364074Dull,0x3FEF99BD7B2CFE59ull,0x3FEF993CA27EA001ull,
		0x3FEF98BB795A345Bull,0x3FEF9839FFC1044Bull,0x3FEF97B835B45982ull,0x3FEF97361B357E7Cull,0x3FEF96B3B045BE83ull,0x3FEF9630F4E665AFull,0x3FEF95ADE918C0E4ull,0x3FEF952A8CDE1DD1ull,
		0x3FEF94A6E037CAF5ull,0x3FEF9422E3271799ull,0x3FEF939E95AD53D4ull,0x3FEF9319F7CBD08Aull,0x3FEF92950983DF6Bull,0x3FEF920FCAD6D2F5ull,0x3FEF918A3BC5FE71ull,0x3FEF91045C52B5F5ull,
		0x3FEF907E2C7E4E65ull,0x3FEF8FF7AC4A1D71ull,0x3FEF8F70DBB77996ull,0x3FEF8EE9BAC7BA1Cull,0x3FEF8E62497C3719ull,0x3FEF8DDA87D64970ull,0x3FEF8D5275D74AD0ull,0x3FEF8CCA138095B4ull,
		0x3FEF8C4160D38565ull,0x3FEF8BB85DD175F7ull,0x3FEF8B2F0A7BC44Dull,0x3FEF8AA566D3CE13ull,0x3FEF8A1B72DAF1C4ull,0x3FEF89912E928EA7ull,0x3FEF890699FC04D0ull,0x3FEF887BB518B51Eull,
		0x3FEF87F07FEA013Eull,0x3FEF8764FA714BA9ull,0x3FEF86D924AFF7A4ull,0x3FEF864CFEA76940ull,0x3FEF85C08859055Cull,0x3FEF8533C1C631A3ull,0x3FEF84A6AAF0548Bull,0x3FEF841943D8D557ull,
		0x3FEF838B8C811C17ull,0x3FEF82FD84EA91A8ull,0x3FEF826F2D169FB1ull,0x3FEF81E08506B0A8ull,0x3FEF81518CBC2FCDull,0x3FEF80C24438892Dull,0x3FEF8032AB7D29A2ull,0x3FEF7FA2C28B7ED3ull,
		0x3FEF7F128964F730ull,0x3FEF7E82000B01F8ull,0x3FEF7DF1267F0F35ull,0x3FEF7D5FFCC28FBFull,0x3FEF7CCE82D6F539ull,0x3FEF7C3CB8BDB210ull,0x3FEF7BAA9E783981ull,0x3FEF7B183407FF93ull,
		0x3FEF7A85796E791Aull,0x3FEF79F26EAD1BB4ull,0x3FEF795F13C55DCFull,0x3FEF78CB68B8B6A1ull,0x3FEF78376D889E2Eull,0x3FEF77A322368D47ull,0x3FEF770E86C3FD88ull,0x3FEF76799B326958ull,
		0x3FEF75E45F834BECull,0x3FEF754ED3B82144ull,0x3FEF74B8F7D2662Bull,0x3FEF7422CBD3983Aull,0x3FEF738C4FBD35D5ull,0x3FEF72F58390BE2Bull,0x3FEF725E674FB139ull,0x3FEF71C6FAFB8FC6ull,
		0x3FEF712F3E95DB67ull,0x3FEF709732201679ull,0x3FEF6FFED59BC42Aull,0x3FEF6F66290A6870ull,0x3FEF6ECD2C6D880Eull,0x3FEF6E33DFC6A893ull,0x3FEF6D9A4317505Aull,0x3FEF6D005661068Aull,
		0x3FEF6C6619A55315ull,0x3FEF6BCB8CE5BEB8ull,0x3FEF6B30B023D2FEull,0x3FEF6A9583611A3Cull,0x3FEF69FA069F1F94ull,0x3FEF695E39DF6EF2ull,0x3FEF68C21D23950Full,0x3FEF6825B06D1F6Full,
		0x3FEF6788F3BD9C63ull,0x3FEF66EBE7169B06ull,0x3FEF664E8A79AB3Full,0x3FEF65B0DDE85DC1ull,0x3FEF6512E164440Aull,0x3FEF647494EEF065ull,0x3FEF63D5F889F5E7ull,0x3FEF63370C36E871ull,
		0x3FEF6297CFF75CB0ull,0x3FEF61F843CCE81Cull,0x3FEF615867B920F9ull,0x3FEF60B83BBD9E55ull,0x3FEF6017BFDBF80Cull,0x3FEF5F76F415C6C3ull,0x3FEF5ED5D86CA3EDull,0x3FEF5E346CE229C5ull,
		0x3FEF5D92B177F354ull,0x3FEF5CF0A62F9C6Eull,0x3FEF5C4E4B0AC1B3ull,0x3FEF5BABA00B008Bull,0x3FEF5B08A531F72Eull,0x3FEF5A655A81449Cull,0x3FEF59C1BFFA88A2ull,0x3FEF591DD59F63D7ull,
		0x3FEF58799B71779Full,0x3FEF57D511726627ull,0x3FEF573037A3D269ull,0x3FEF568B0E07602Aull,0x3FEF55E5949EB3FAull,0x3FEF553FCB6B7333ull,0x3FEF5499B26F43FCull,0x3FEF53F349ABCD47ull,
		0x3FEF534C9122B6D0ull,0x3FEF52A588D5A91Eull,0x3FEF51FE30C64D85ull,0x3FEF515688F64E23ull,0x3FEF50AE916755E0ull,0x3FEF50064A1B1070ull,0x3FEF4F5DB3132A54ull,0x3FEF4EB4CC5150D3ull,
		0x3FEF4E0B95D73205ull,0x3FEF4D620FA67CC9ull,0x3FEF4CB839C0E0CAull,0x3FEF4C0E14280E7Eull,0x3FEF4B639EDDB726ull,0x3FEF4AB8D9E38CCEull,0x3FEF4A0DC53B424Eull,0x3FEF496260E68B46ull,
		0x3FEF48B6ACE71C23ull,0x3FEF480AA93EAA1Dull,0x3FEF475E55EEEB37ull,0x3FEF46B1B2F9963Cull,0x3FEF4604C06062C6ull,0x3FEF45577E250937ull,0x3FEF44A9EC4942BDull,0x3FEF43FC0ACEC950ull,
		0x3FEF434DD9B757B2ull,0x3FEF429F5904A972ull,0x3FEF41F088B87AE8ull,0x3FEF414168D48937ull,0x3FEF4091F95A924Eull,0x3FEF3FE23A4C54E3ull,0x3FEF3F322BAB907Cull,0x3FEF3E81CD7A0565ull,
		0x3FEF3DD11FB974B6ull,0x3FEF3D20226BA053ull,0x3FEF3C6ED5924AE9ull,0x3FEF3BBD392F37F0ull,0x3FEF3B0B4D442BABull,0x3FEF3A5911D2EB27ull,0x3FEF39A686DD3C3Bull,0x3FEF38F3AC64E589ull,
		0x3FEF3840826BAE7Eull,0x3FEF378D08F35F51ull,0x3FEF36D93FFDC103ull,0x3FEF3625278C9D60ull,0x3FEF3570BFA1BEFEull,0x3FEF34BC083EF13Eull,0x3FEF34070166004Bull,0x3FEF3351AB18B919ull,
		0x3FEF329C0558E969ull,0x3FEF31E610285FC4ull,0x3FEF312FCB88EB7Full,0x3FEF3079377C5CB7ull,0x3FEF2FC254048456ull,0x3FEF2F0B2123340Full,0x3FEF2E539EDA3E5Eull,0x3FEF2D9BCD2B768Bull,
		0x3FEF2CE3AC18B0A7ull,0x3FEF2C2B3BA3C18Eull,0x3FEF2B727BCE7EE5ull,0x3FEF2AB96C9ABF1Dull,0x3FEF2A000E0A5970ull,0x3FEF2946601F25E1ull,0x3FEF288C62DAFD40ull,0x3FEF27D2163FB923ull,
		0x3FEF27177A4F33EDull,0x3FEF265C8F0B48CAull,0x3FEF25A15475D3B1ull,0x3FEF24E5CA90B162ull,0x3FEF2429F15DBF67ull,0x3FEF236DC8DEDC13ull,0x3FEF22B15115E686ull,0x3FEF21F48A04BEA6ull,
		0x3FEF213773AD4526ull,0x3FEF207A0E115B81ull,0x3FEF1FBC5932E3FDull,0x3FEF1EFE5513C1A9ull,0x3FEF1E4001B5D85Eull,0x3FEF1D815F1B0CBFull,0x3FEF1CC26D454438ull,0x3FEF1C032C366501ull,
		0x3FEF1B439BF05619ull,0x3FEF1A83BC74FF49ull,0x3FEF19C38DC64927ull,0x3FEF19030FE61D0Eull,0x3FEF184242D66526ull,0x3FEF178126990C5Full,0x3FEF16BFBB2FFE73ull,0x3FEF15FE009D27E6ull,
		0x3FEF153BF6E27605ull,0x3FEF14799E01D6E7ull,0x3FEF13B6F5FD396Dull,0x3FEF12F3FED68D41ull,0x3FEF1230B88FC2D5ull,0x3FEF116D232ACB66ull,0x3FEF10A93EA998FCull,0x3FEF0FE50B0E1E65ull,
		0x3FEF0F20885A4F3Cull,0x3FEF0E5BB6901FE2ull,0x3FEF0D9695B18584ull,0x3FEF0CD125C07617ull,0x3FEF0C0B66BEE859ull,0x3FEF0B4558AED3D4ull,0x3FEF0A7EFB9230D7ull,0x3FEF09B84F6AF87Eull,
		0x3FEF08F1543B24ADull,0x3FEF082A0A04B011ull,0x3FEF076270C99620ull,0x3FEF069A888BD319ull,0x3FEF05D2514D6406ull,0x3FEF0509CB1046B9ull,0x3FEF0440F5D679CCull,0x3FEF0377D1A1FCA4ull,
		0x3FEF02AE5E74CF6Eull,0x3FEF01E49C50F320ull,0x3FEF011A8B38697Bull,0x3FEF00502B2D3506ull,0x3FEEFF857C315913ull,0x3FEEFEBA7E46D9BDull,0x3FEEFDEF316FBBE7ull,0x3FEEFD2395AE053Eull,
		0x3FEEFC57AB03BC37ull,0x3FEEFB8B7172E811ull,0x3FEEFABEE8FD90D2ull,0x3FEEF9F211A5BF4Cull,0x3FEEF924EB6D7D17ull,0x3FEEF8577656D496ull,0x3FEEF789B263D0F2ull,0x3FEEF6BB9F967E20ull,
		0x3FEEF5ED3DF0E8DBull,0x3FEEF51E8D751EAAull,0x3FEEF44F8E252DD9ull,0x3FEEF38040032580ull,0x3FEEF2B0A311157Dull,0x3FEEF1E0B7510E79ull,0x3FEEF1107CC521E5ull,0x3FEEF03FF36F61F9ull,
		0x3FEEEF6F1B51E1B7ull,0x3FEEEE9DF46EB4EAull,0x3FEEEDCC7EC7F026ull,0x3FEEECFABA5FA8C5ull,0x3FEEEC28A737F4ECull,0x3FEEEB564552EB88ull,0x3FEEEA8394B2A44Dull,0x3FEEE9B0955937BAull,
		0x3FEEE8DD4748BF15ull,0x3FEEE809AA83546Cull,0x3FEEE735BF0B1296ull,0x3FEEE66184E21532ull,0x3FEEE58CFC0A78A9ull,0x3FEEE4B824865A2Bull,0x3FEEE3E2FE57D7B0ull,0x3FEEE30D89810FF8ull,
		0x3FEEE237C604228Dull,0x3FEEE161B3E32FC0ull,0x3FEEE08B532058AAull,0x3FEEDFB4A3BDBF2Eull,0x3FEEDEDDA5BD85F6ull,0x3FEEDE065921D073ull,0x3FEEDD2EBDECC2DFull,0x3FEEDC56D420823Full,
		0x3FEEDB7E9BBF345Bull,0x3FEEDAA614CAFFC7ull,0x3FEED9CD3F460BDDull,0x3FEED8F41B3280C1ull,0x3FEED81AA892875Cull,0x3FEED740E7684963ull,0x3FEED666D7B5F150ull,0x3FEED58C797DAA65ull,
		0x3FEED4B1CCC1A0AEull,0x3FEED3D6D18400FDull,0x3FEED2FB87C6F8EDull,0x3FEED21FEF8CB6E0ull,0x3FEED14408D76A01ull,0x3FEED067D3A94241ull,0x3FEECF8B5004705Cull,0x3FEECEAE7DEB25D2ull,
		0x3FEECDD15D5F94EDull,0x3FEECCF3EE63F0BFull,0x3FEECC1630FA6D21ull,0x3FEECB3825253EB3ull,0x3FEECA59CAE69ADEull,0x3FEEC97B2240B7D2ull,0x3FEEC89C2B35CC87ull,0x3FEEC7BCE5C810BCull,
		0x3FEEC6DD51F9BCF8ull,0x3FEEC5FD6FCD0A8Aull,0x3FEEC51D3F443387ull,0x3FEEC43CC06172CFull,0x3FEEC35BF3270404ull,0x3FEEC27AD7972395ull,0x3FEEC1996DB40EB6ull,0x3FEEC0B7B5800361ull,
		0x3FEEBFD5AEFD405Aull,0x3FEEBEF35A2E052Cull,0x3FEEBE10B7149228ull,0x3FEEBD2DC5B32867ull,0x3FEEBC4A860C09C9ull,0x3FEEBB66F82178F7ull,0x3FEEBA831BF5B95Full,0x3FEEB99EF18B0F38ull,
		0x3FEEB8BA78E3BF7Full,0x3FEEB7D5B2020FF9ull,0x3FEEB6F09CE84731ull,0x3FEEB60B3998AC7Cull,0x3FEEB525881587F3ull,0x3FEEB43F88612278ull,0x3FEEB3593A7DC5B3ull,0x3FEEB2729E6DBC14ull,
		0x3FEEB18BB43350D1ull,0x3FEEB0A47BD0CFE9ull,0x3FEEAFBCF548861Full,0x3FEEAED5209CC100ull,0x3FEEADECFDCFCEDEull,0x3FEEAD048CE3FED3ull,0x3FEEAC1BCDDBA0BFull,0x3FEEAB32C0B9054Aull,
		0x3FEEAA49657E7DE2ull,0x3FEEA95FBC2E5CBCull,0x3FEEA875C4CAF4D4ull,0x3FEEA78B7F5699EEull,0x3FEEA6A0EBD3A092ull,0x3FEEA5B60A445E11ull,0x3FEEA4CADAAB2882ull,0x3FEEA3DF5D0A56C3ull,
		0x3FEEA2F391644078ull,0x3FEEA20777BB3E0Dull,0x3FEEA11B1011A8B3ull,0x3FEEA02E5A69DA62ull,0x3FEE9F4156C62DDAull,0x3FEE9E540528FEA1ull,0x3FEE9D666594A902ull,0x3FEE9C78780B8A10ull,
		0x3FEE9B8A3C8FFFA4ull,0x3FEE9A9BB324685Full,0x3FEE99ACDBCB23A5ull,0x3FEE98BDB68691A4ull,0x3FEE97CE4359134Eull,0x3FEE96DE82450A5Eull,0x3FEE95EE734CD951ull,0x3FEE94FE1672E370ull,
		0x3FEE940D6BB98CC5ull,0x3FEE931C73233A25ull,0x3FEE922B2CB25126ull,0x3FEE91399869382Aull,0x3FEE9047B64A5654ull,0x3FEE8F5586581391ull,0x3FEE8E630894D893ull,0x3FEE8D703D030ED1ull,
		0x3FEE8C7D23A52089ull,0x3FEE8B89BC7D78BFull,0x3FEE8A96078E833Full,0x3FEE89A204DAAC97ull,0x3FEE88ADB464621Eull,0x3FEE87B9162E11F0ull,0x3FEE86C42A3A2AF1ull,0x3FEE85CEF08B1CC7ull,
		0x3FEE84D9692357E1ull,0x3FEE83E394054D73ull,0x3FEE82ED71336F77ull,0x3FEE81F700B030ADull,0x3FEE8100427E049Aull,0x3FEE8009369F5F8Bull,0x3FEE7F11DD16B68Full,0x3FEE7E1A35E67F7Eull,
		0x3FEE7D22411130F5ull,0x3FEE7C29FE994256ull,0x3FEE7B316E812BC9ull,0x3FEE7A3890CB663Cull,0x3FEE793F657A6B63ull,0x3FEE7845EC90B5B6ull,0x3FEE774C2610C074ull,0x3FEE765211FD07A1ull,
		0x3FEE7557B0580807ull,0x3FEE745D01243F36ull,0x3FEE736204642B81ull,0x3FEE7266BA1A4C03ull,0x3FEE716B2249209Cull,0x3FEE706F3CF329F1ull,0x3FEE6F730A1AE96Cull,0x3FEE6E7689C2E13Cull,
		0x3FEE6D79BBED9458ull,0x3FEE6C7CA09D8679ull,0x3FEE6B7F37D53C1Full,0x3FEE6A8181973A90ull,0x3FEE69837DE607D5ull,0x3FEE68852CC42ABEull,0x3FEE67868E342AE0ull,0x3FEE6687A2389093ull,
		0x3FEE658868D3E4F9ull,0x3FEE6488E208B1F3ull,0x3FEE63890DD9822Cull,0x3FEE6288EC48E112ull,0x3FEE61887D595AD8ull,0x3FEE6087C10D7C76ull,0x3FEE5F86B767D3A9ull,0x3FEE5E85606AEEF5ull,
		0x3FEE5D83BC195D9Full,0x3FEE5C81CA75AFB4ull,0x3FEE5B7F8B827605ull,0x3FEE5A7CFF424228ull,0x3FEE597A25B7A677ull,0x3FEE5876FEE53612ull,0x3FEE57738ACD84DDull,0x3FEE566FC9732781ull,
		0x3FEE556BBAD8B36Bull,0x3FEE54675F00BED0ull,0x3FEE5362B5EDE0A4ull,0x3FEE525DBFA2B0A4ull,0x3FEE51587C21C751ull,0x3FEE5052EB6DBDF0ull,0x3FEE4F4D0D892E89ull,0x3FEE4E46E276B3ECull,
		0x3FEE4D406A38E9ABull,0x3FEE4C39A4D26C1Dull,0x3FEE4B329245D85Dull,0x3FEE4A2B3295CC4Cull,0x3FEE492385C4E68Full,0x3FEE481B8BD5C68Dull,0x3FEE471344CB0C75ull,0x3FEE460AB0A75939ull,
		0x3FEE4501CF6D4E8Dull,0x3FEE43F8A11F8EECull,0x3FEE42EF25C0BD95ull,0x3FEE41E55D537E8Bull,0x3FEE40DB47DA7693ull,0x3FEE3FD0E5584B3Bull,0x3FEE3EC635CFA2D0ull,0x3FEE3DBB39432466ull,
		0x3FEE3CAFEFB577D5ull,0x3FEE3BA4592945B9ull,0x3FEE3A9875A13770ull,0x3FEE398C451FF71Full,0x3FEE387FC7A82FAEull,0x3FEE3772FD3C8CC7ull,0x3FEE3665E5DFBADBull,0x3FEE35588194671Eull,
		0x3FEE344AD05D3F86ull,0x3FEE333CD23CF2CFull,0x3FEE322E87363078ull,0x3FEE311FEF4BA8C4ull,0x3FEE30110A800CBAull,0x3FEE2F01D8D60E24ull,0x3FEE2DF25A505F91ull,0x3FEE2CE28EF1B452ull,
		0x3FEE2BD276BCC07Dull,0x3FEE2AC211B438ECull,0x3FEE29B15FDAD33Bull,0x3FEE28A0613345CBull,0x3FEE278F15C047C0ull,0x3FEE267D7D849101ull,0x3FEE256B9882DA3Bull,0x3FEE245966BDDCDAull,
		0x3FEE2346E8385312ull,0x3FEE22341CF4F7D8ull,0x3FEE212104F686E5ull,0x3FEE200DA03FBCB5ull,0x3FEE1EF9EED35688ull,0x3FEE1DE5F0B41262ull,0x3FEE1CD1A5E4AF07ull,0x3FEE1BBD0E67EC03ull,
		0x3FEE1AA82A4089A1ull,0x3FEE1992F97148F3ull,0x3FEE187D7BFCEBCAull,0x3FEE1767B1E634BEull,0x3FEE16519B2FE729ull,0x3FEE153B37DCC726ull,0x3FEE142487EF9996ull,0x3FEE130D8B6B241Bull,
		0x3FEE11F642522D1Cull,0x3FEE10DEACA77BC0ull,0x3FEE0FC6CA6DD7F5ull,0x3FEE0EAE9BA80A68ull,0x3FEE0D962058DC8Cull,0x3FEE0C7D58831894ull,0x3FEE0B6444298979ull,0x3FEE0A4AE34EFAF5ull,
		0x3FEE093135F63984ull,0x3FEE08173C221267ull,0x3FEE06FCF5D553A0ull,0x3FEE05E26312CBF4ull,0x3FEE04C783DD4AECull,0x3FEE03AC5837A0D2ull,0x3FEE0290E0249EB3ull,0x3FEE01751BA71660ull,
		0x3FEE00590AC1DA6Bull,0x3FEDFF3CAD77BE29ull,0x3FEDFE2003CB95B1ull,0x3FEDFD030DC035DEull,0x3FEDFBE5CB58744Cull,0x3FEDFAC83C97275Bull,0x3FEDF9AA617F262Bull,0x3FEDF88C3A1348A0ull,
		0x3FEDF76DC6566761ull,0x3FEDF64F064B5BD6ull,0x3FEDF52FF9F5002Aull,0x3FEDF410A1562F4Aull,0x3FEDF2F0FC71C4E5ull,0x3FEDF1D10B4A9D6Dull,0x3FEDF0B0CDE39616ull,0x3FEDEF90443F8CD4ull,
		0x3FEDEE6F6E616061ull,0x3FEDED4E4C4BF036ull,0x3FEDEC2CDE021C90ull,0x3FEDEB0B2386C66Dull,0x3FEDE9E91CDCCF8Cull,0x3FEDE8C6CA071A71ull,0x3FEDE7A42B088A5Full,0x3FEDE6813FE4035Cull,
		0x3FEDE55E089C6A31ull,0x3FEDE43A8534A468ull,0x3FEDE316B5AF984Bull,0x3FEDE1F29A102CE9ull,0x3FEDE0CE32594A11ull,0x3FEDDFA97E8DD853ull,0x3FEDDE847EB0C104ull,0x3FEDDD5F32C4EE36ull,
		0x3FEDDC399ACD4AC1ull,0x3FEDDB13B6CCC23Cull,0x3FEDD9ED86C64101ull,0x3FEDD8C70ABCB42Bull,0x3FEDD7A042B30995ull,0x3FEDD6792EAC2FDFull,0x3FEDD551CEAB1667ull,0x3FEDD42A22B2AD50ull,
		0x3FEDD3022AC5E57Bull,0x3FEDD1D9E6E7B08Bull,0x3FEDD0B1571B00E8ull,0x3FEDCF887B62C9B6ull,0x3FEDCE5F53C1FEDEull,0x3FEDCD35E03B950Aull,0x3FEDCC0C20D281A3ull,0x3FEDCAE21589BAD5ull,
		0x3FEDC9B7BE64378Eull,0x3FEDC88D1B64EF7Bull,0x3FEDC7622C8EDB0Cull,0x3FEDC636F1E4F370ull,0x3FEDC50B6B6A329Aull,0x3FEDC3DF9921933Cull,0x3FEDC2B37B0E10C8ull,0x3FEDC1871132A775ull,
		0x3FEDC05A5B925437ull,0x3FEDBF2D5A3014C4ull,0x3FEDBE000D0EE795ull,0x3FEDBCD27431CBE0ull,0x3FEDBBA48F9BC19Full,0x3FEDBA765F4FC98Dull,0x3FEDB947E350E523ull,0x3FEDB8191BA2169Dull,
		0x3FEDB6EA084660F6ull,0x3FEDB5BAA940C7EDull,0x3FEDB48AFE944FFEull,0x3FEDB35B0843FE67ull,0x3FEDB22AC652D928ull,0x3FEDB0FA38C3E6FEull,0x3FEDAFC95F9A2F6Bull,0x3FEDAE983AD8BAAFull,
		0x3FEDAD66CA8291CAull,0x3FEDAC350E9ABE7Dull,0x3FEDAB0307244B4Bull,0x3FEDA9D0B4224375ull,0x3FEDA89E1597B2FEull,0x3FEDA76B2B87A6A9ull,0x3FEDA637F5F52BF9ull,0x3FEDA50474E35131ull,
		0x3FEDA3D0A8552555ull,0x3FEDA29C904DB829ull,0x3FEDA1682CD01A30ull,0x3FEDA0337DDF5CAFull,0x3FED9EFE837E91ABull,0x3FED9DC93DB0CBE7ull,0x3FED9C93AC791EE8ull,0x3FED9B5DCFDA9EF2ull,
		0x3FED9A27A7D8610Bull,0x3FED98F134757AF5ull,0x3FED97BA75B50337ull,0x3FED96836B9A1114ull,0x3FED954C1627BC90ull,0x3FED941475611E6Full,0x3FED92DC89495036ull,0x3FED91A451E36C27ull,
		0x3FED906BCF328D46ull,0x3FED8F330139CF57ull,0x3FED8DF9E7FC4EDBull,0x3FED8CC0837D2916ull,0x3FED8B86D3BF7C09ull,0x3FED8A4CD8C66676ull,0x3FED8912929507DFull,0x3FED87D8012E8083ull,
		0x3FED869D2495F164ull,0x3FED8561FCCE7C42ull,0x3FED842689DB439Aull,0x3FED82EACBBF6AADull,0x3FED81AEC27E1577ull,0x3FED80726E1A68B7ull,0x3FED7F35CE9789E8ull,0x3FED7DF8E3F89F48ull,
		0x3FED7CBBAE40CFD0ull,0x3FED7B7E2D73433Cull,0x3FED7A4061932205ull,0x3FED79024AA39564ull,0x3FED77C3E8A7C751ull,0x3FED76853BA2E282ull,0x3FED75464398126Eull,0x3FED7407008A834Aull,
		0x3FED72C7727D620Aull,0x3FED71879973DC61ull,0x3FED7047757120C1ull,0x3FED6F0706785E5Cull,0x3FED6DC64C8CC520ull,0x3FED6C8547B185BCull,0x3FED6B43F7E9D19Full,0x3FED6A025D38DAF4ull,
		0x3FED68C077A1D4A6ull,0x3FED677E4727F25Eull,0x3FED663BCBCE6887ull,0x3FED64F905986C45ull,0x3FED63B5F4893380ull,0x3FED627298A3F4DBull,0x3FED612EF1EBE7B9ull,0x3FED5FEB0064443Cull,
		0x3FED5EA6C4104343ull,0x3FED5D623CF31E6Cull,0x3FED5C1D6B101015ull,0x3FED5AD84E6A5359ull,0x3FED5992E7052411ull,0x3FED584D34E3BED5ull,0x3FED5707380960FAull,0x3FED55C0F0794897ull,
		0x3FED547A5E36B47Cull,0x3FED53338144E43Bull,0x3FED51EC59A71824ull,0x3FED50A4E7609142ull,0x3FED4F5D2A749162ull,0x3FED4E1522E65B0Dull,0x3FED4CCCD0B9318Bull,0x3FED4B8433F058DFull,
		0x3FED4A3B4C8F15CFull,0x3FED48F21A98ADDCull,0x3FED47A89E106744ull,0x3FED465ED6F98904ull,0x3FED4514C5575AD9ull,0x3FED43CA692D253Aull,0x3FED427FC27E315Eull,0x3FED4134D14DC93Aull,
		0x3FED3FE9959F377Full,0x3FED3E9E0F75C79Dull,0x3FED3D523ED4C5C2ull,0x3FED3C0623BF7ED9ull,0x3FED3AB9BE39408Aull,0x3FED396D0E45593Bull,0x3FED382013E71810ull,0x3FED36D2CF21CCEBull,
		0x3FED35853FF8C869ull,0x3FED3437666F5BE7ull,0x3FED32E94288D97Full,0x3FED319AD4489406ull,0x3FED304C1BB1DF11ull,0x3FED2EFD18C80EF2ull,0x3FED2DADCB8E78B8ull,0x3FED2C5E3408722Dull,
		0x3FED2B0E523951DBull,0x3FED29BE26246F09ull,0x3FED286DAFCD21B9ull,0x3FED271CEF36C2ACull,0x3FED25CBE464AB60ull,0x3FED247A8F5A360Full,0x3FED2328F01ABDB1ull,0x3FED21D706A99DF9ull,
		0x3FED2084D30A335Aull,0x3FED1F32553FDB02ull,0x3FED1DDF8D4DF2DCull,0x3FED1C8C7B37D98Full,0x3FED1B391F00EE81ull,0x3FED19E578AC91D3ull,0x3FED1891883E2463ull,0x3FED173D4DB907CDull,
		0x3FED15E8C9209E67ull,0x3FED1493FA784B46ull,0x3FED133EE1C3723Bull,0x3FED11E97F0577D3ull,0x3FED1093D241C158ull,0x3FED0F3DDB7BB4D0ull,0x3FED0DE79AB6B8FFull,0x3FED0C910FF63562ull,
		0x3FED0B3A3B3D9237ull,0x3FED09E31C903874ull,0x3FED088BB3F191CEull,0x3FED0734016508B6ull,0x3FED05DC04EE0859ull,0x3FED0483BE8FFC9Full,0x3FED032B2E4E522Eull,0x3FED01D2542C7667ull,
		0x3FED0079302DD767ull,0x3FECFF1FC255E409ull,0x3FECFDC60AA80BE1ull,0x3FECFC6C0927BF41ull,0x3FECFB11BDD86F38ull,0x3FECF9B728BD8D8Dull,0x3FECF85C49DA8CC8ull,0x3FECF7012132E028ull,
		0x3FECF5A5AEC9FBACull,0x3FECF449F2A3540Cull,0x3FECF2EDECC25EBDull,0x3FECF1919D2A91F0ull,0x3FECF03503DF6490ull,0x3FECEED820E44E45ull,0x3FECED7AF43CC773ull,0x3FECEC1D7DEC4939ull,
		0x3FECEABFBDF64D72ull,0x3FECE961B45E4EB3ull,0x3FECE8036127C84Eull,0x3FECE6A4C4563651ull,0x3FECE545DDED1585ull,0x3FECE3E6ADEFE36Bull,0x3FECE28734621E46ull,0x3FECE1277147450Eull,
		0x3FECDFC764A2D779ull,0x3FECDE670E7855FAull,0x3FECDD066ECB41BCull,0x3FECDBA5859F1CA6ull,0x3FECDA4452F7695Cull,0x3FECD8E2D6D7AB3Bull,0x3FECD7811143665Dull,0x3FECD61F023E1F94ull,
		0x3FECD4BCA9CB5C71ull,0x3FECD35A07EEA33Cull,0x3FECD1F71CAB7AFBull,0x3FECD093E8056B6Eull,0x3FECCF3069FFFD0Full,0x3FECCDCCA29EB913ull,0x3FECCC6891E5296Cull,0x3FECCB0437D6D8C3ull,
		0x3FECC99F9477527Full,0x3FECC83AA7CA22BFull,0x3FECC6D571D2D660ull,0x3FECC56FF294FAF7ull,0x3FECC40A2A141ED3ull,0x3FECC2A41853D101ull,0x3FECC13DBD57A145ull,0x3FECBFD71923201Eull,
		0x3FECBE702BB9DEC9ull,0x3FECBD08F51F6F38ull,0x3FECBBA17557641Cull,0x3FECBA39AC6550DDull,0x3FECB8D19A4CC99Full,0x3FECB7693F116340ull,0x3FECB6009AB6B359ull,0x3FECB497AD40503Cull,
		0x3FECB32E76B1D0F4ull,0x3FECB1C4F70ECD4Aull,0x3FECB05B2E5ADDBEull,0x3FECAEF11C999B8Aull,0x3FECAD86C1CEA0A4ull,0x3FECAC1C1DFD87B9ull,0x3FECAAB13129EC34ull,0x3FECA945FB576A36ull,
		0x3FECA7DA7C899E9Dull,0x3FECA66EB4C426FEull,0x3FECA502A40AA1AAull,0x3FECA3964A60ADAAull,0x3FECA229A7C9EAC3ull,0x3FECA0BCBC49F971ull,0x3FEC9F4F87E47AECull,0x3FEC9DE20A9D1124ull,
		0x3FEC9C7444775EC4ull,0x3FEC9B063577072Full,0x3FEC9997DD9FAE83ull,0x3FEC98293CF4F996ull,0x3FEC96BA537A8DF9ull,0x3FEC954B213411F5ull,0x3FEC93DBA6252C8Dull,0x3FEC926BE251857Dull,
		0x3FEC90FBD5BCC53Cull,0x3FEC8F8B806A94F7ull,0x3FEC8E1AE25E9E97ull,0x3FEC8CA9FB9C8CBEull,0x3FEC8B38CC280AC5ull,0x3FEC89C75404C4C0ull,0x3FEC88559336677Cull,0x3FEC86E389C0A07Eull,
		0x3FEC857137A71E06ull,0x3FEC83FE9CED8F09ull,0x3FEC828BB997A33Aull,0x3FEC81188DA90B02ull,0x3FEC7FA519257783ull,0x3FEC7E315C109A97ull,0x3FEC7CBD566E26D3ull,0x3FEC7B490841CF84ull,
		0x3FEC79D4718F48AFull,0x3FEC785F925A4711ull,0x3FEC76EA6AA68022ull,0x3FEC7574FA77AA10ull,0x3FEC73FF41D17BC4ull,0x3FEC728940B7ACDEull,0x3FEC7112F72DF5B7ull,0x3FEC6F9C65380F5Full,
		0x3FEC6E258AD9B3A1ull,0x3FEC6CAE68169CFFull,0x3FEC6B36FCF286B3ull,0x3FEC69BF49712CAFull,0x3FEC68474D964BA0ull,0x3FEC66CF0965A0E7ull,0x3FEC65567CE2EAA1ull,0x3FEC63DDA811E7A0ull,
		0x3FEC62648AF65771ull,0x3FEC60EB2593FA57ull,0x3FEC5F7177EE914Eull,0x3FEC5DF78209DE0Aull,0x3FEC5C7D43E9A2F7ull,0x3FEC5B02BD91A337ull,0x3FEC5987EF05A2A8ull,0x3FEC580CD84965DBull,
		0x3FEC56917960B21Dull,0x3FEC5515D24F4D71ull,0x3FEC5399E318FE91ull,0x3FEC521DABC18CEFull,0x3FEC50A12C4CC0B6ull,0x3FEC4F2464BE62C8ull,0x3FEC4DA7551A3CBEull,0x3FEC4C29FD6418E8ull,
		0x3FEC4AAC5D9FC250ull,0x3FEC492E75D104B5ull,0x3FEC47B045FBAC8Full,0x3FEC4631CE23870Bull,0x3FEC44B30E4C6211ull,0x3FEC4334067A0C3Eull,0x3FEC41B4B6B054E7ull,0x3FEC40351EF30C17ull,
		0x3FEC3EB53F460291ull,0x3FEC3D3517AD09D1ull,0x3FEC3BB4A82BF407ull,0x3FEC3A33F0C6941Dull,0x3FEC38B2F180BDB1ull,0x3FEC3731AA5E451Bull,0x3FEC35B01B62FF68ull,0x3FEC342E4492C25Dull,
		0x3FEC32AC25F16475ull,0x3FEC3129BF82BCE3ull,0x3FEC2FA7114AA390ull,0x3FEC2E241B4CF11Cull,0x3FEC2CA0DD8D7EDFull,0x3FEC2B1D581026E4ull,0x3FEC29998AD8C3F1ull,0x3FEC281575EB3180ull,
		0x3FEC2691194B4BC4ull,0x3FEC250C74FCEFA3ull,0x3FEC23878903FABCull,0x3FEC220255644B65ull,0x3FEC207CDA21C0A8ull,0x3FEC1EF717403A49ull,0x3FEC1D710CC398BEull,0x3FEC1BEABAAFBD37ull,
		0x3FEC1A6421088998ull,0x3FEC18DD3FD1E07Dull,0x3FEC1756170FA536ull,0x3FEC15CEA6C5BBCCull,0x3FEC1446EEF808FCull,0x3FEC12BEEFAA723Aull,0x3FEC1136A8E0DDB0ull,0x3FEC0FAE1A9F323Dull,
		0x3FEC0E2544E95777ull,0x3FEC0C9C27C335ABull,0x3FEC0B12C330B5DAull,0x3FEC09891735C1BBull,0x3FEC07FF23D643BBull,0x3FEC0674E91626FFull,0x3FEC04EA66F9575Full,0x3FEC035F9D83C16Aull,
		0x3FEC01D48CB95263ull,0x3FEC0049349DF845ull,0x3FEBFEBD9535A1C0ull,0x3FEBFD31AE843E39ull,0x3FEBFBA5808DBDC9ull,0x3FEBFA190B561143ull,0x3FEBF88C4EE12A29ull,0x3FEBF6FF4B32FAB9ull,
		0x3FEBF572004F75E2ull,0x3FEBF3E46E3A8F4Aull,0x3FEBF25694F83B4Bull,0x3FEBF0C8748C6EF7ull,0x3FEBEF3A0CFB2011ull,0x3FEBEDAB5E484515ull,0x3FEBEC1C6877D533ull,0x3FEBEA8D2B8DC84Full,
		0x3FEBE8FDA78E1703ull,0x3FEBE76DDC7CBA9Dull,0x3FEBE5DDCA5DAD22ull,0x3FEBE44D7134E94Aull,0x3FEBE2BCD1066A83ull,0x3FEBE12BE9D62CEFull,0x3FEBDF9ABBA82D66ull,0x3FEBDE0946806972ull,
		0x3FEBDC778A62DF56ull,0x3FEBDAE587538E06ull,0x3FEBD9533D56752Dull,0x3FEBD7C0AC6F952Aull,0x3FEBD62DD4A2EF0Eull,0x3FEBD49AB5F484A3ull,0x3FEBD30750685865ull,0x3FEBD173A4026D83ull,
		0x3FEBCFDFB0C6C7E5ull,0x3FEBCE4B76B96C22ull,0x3FEBCCB6F5DE5F88ull,0x3FEBCB222E39A81Bull,0x3FEBC98D1FCF4C8Full,0x3FEBC7F7CAA35451ull,0x3FEBC6622EB9C77Eull,0x3FEBC4CC4C16AEE9ull,
		0x3FEBC33622BE141Aull,0x3FEBC19FB2B4014Bull,0x3FEBC008FBFC816Bull,0x3FEBBE71FE9BA01Eull,0x3FEBBCDABA9569BAull,0x3FEBBB432FEDEB4Bull,0x3FEBB9AB5EA9328Eull,0x3FEBB81346CB4DF6ull,
		0x3FEBB67AE8584CAAull,0x3FEBB4E243543E84ull,0x3FEBB34957C33411ull,0x3FEBB1B025A93E92ull,0x3FEBB016AD0A6FFDull,0x3FEBAE7CEDEADAF9ull,0x3FEBACE2E84E92E3ull,0x3FEBAB489C39ABCBull,
		0x3FEBA9AE09B03A73ull,0x3FEBA81330B65452ull,0x3FEBA67811500F91ull,0x3FEBA4DCAB81830Dull,0x3FEBA340FF4EC657ull,0x3FEBA1A50CBBF1B2ull,0x3FEBA008D3CD1E16ull,0x3FEB9E6C5486652Bull,
		0x3FEB9CCF8EEBE14Full,0x3FEB9B328301AD92ull,0x3FEB999530CBE5B7ull,0x3FEB97F7984EA634ull,0x3FEB9659B98E0C33ull,0x3FEB94BB948E358Full,0x3FEB931D295340D8ull,0x3FEB917E77E14D4Eull,
		0x3FEB8FDF803C7AE7ull,0x3FEB8E404268EA4Aull,0x3FEB8CA0BE6ABCD0ull,0x3FEB8B00F4461487ull,0x3FEB8960E3FF142Dull,0x3FEB87C08D99DF35ull,0x3FEB861FF11A99C3ull,0x3FEB847F0E8568ADull,
		0x3FEB82DDE5DE717Eull,0x3FEB813C7729DA70ull,0x3FEB7F9AC26BCA73ull,0x3FEB7DF8C7A86926ull,0x3FEB7C5686E3DEDCull,0x3FEB7AB40022549Bull,0x3FEB79113367F41Aull,0x3FEB776E20B8E7C1ull,
		0x3FEB75CAC8195AAEull,0x3FEB7427298D78ADull,0x3FEB728345196E3Eull,0x3FEB70DF1AC16892ull,0x3FEB6F3AAA89958Full,0x3FEB6D95F47623C8ull,0x3FEB6BF0F88B4286ull,0x3FEB6A4BB6CD21C2ull,
		0x3FEB68A62F3FF227ull,0x3FEB670061E7E512ull,0x3FEB655A4EC92C92ull,0x3FEB63B3F5E7FB66ull,0x3FEB620D57488501ull,0x3FEB606672EEFD87ull,0x3FEB5EBF48DF99CCull,0x3FEB5D17D91E8F57ull,
		0x3FEB5B7023B01460ull,0x3FEB59C828985FD0ull,0x3FEB581FE7DBA943ull,0x3FEB5677617E2904ull,0x3FEB54CE95841811ull,0x3FEB532583F1B019ull,0x3FEB517C2CCB2B7Bull,0x3FEB4FD29014C549ull,
		0x3FEB4E28ADD2B944ull,0x3FEB4C7E860943E2ull,0x3FEB4AD418BCA244ull,0x3FEB492965F11242ull,0x3FEB477E6DAAD261ull,0x3FEB45D32FEE21D9ull,0x3FEB4427ACBF4092ull,0x3FEB427BE4226F24ull,
		0x3FEB40CFD61BEEDAull,0x3FEB3F2382B001AEull,0x3FEB3D76E9E2EA4Bull,0x3FEB3BCA0BB8EC0Dull,0x3FEB3A1CE8364B01ull,0x3FEB386F7F5F4BE3ull,0x3FEB36C1D1383422ull,0x3FEB3513DDC549DBull,
		0x3FEB3365A50AD3DEull,0x3FEB31B7270D19A8ull,0x3FEB300863D0636Aull,0x3FEB2E595B58FA02ull,0x3FEB2CAA0DAB2702ull,0x3FEB2AFA7ACB34A9ull,0x3FEB294AA2BD6DE7ull,0x3FEB279A85861E5Eull,
		0x3FEB25EA2329925Dull,0x3FEB24397BAC16E6ull,0x3FEB22888F11F9A9ull,0x3FEB20D75D5F8907ull,0x3FEB1F25E6991410ull,0x3FEB1D742AC2EA86ull,0x3FEB1BC229E15CD9ull,0x3FEB1A0FE3F8BC28ull,
		0x3FEB185D590D5A44ull,0x3FEB16AA892389ADull,0x3FEB14F7743F9D92ull,0x3FEB13441A65E9D3ull,0x3FEB11907B9AC2FCull,0x3FEB0FDC97E27E4Eull,0x3FEB0E286F4171B6ull,0x3FEB0C7401BBF3D0ull,
		0x3FEB0ABF4F565BEAull,0x3FEB090A58150200ull,0x3FEB07551BFC3EBCull,0x3FEB059F9B106B79ull,0x3FEB03E9D555E242ull,0x3FEB0233CAD0FDD0ull,0x3FEB007D7B86198Aull,0x3FEAFEC6E7799187ull,
		0x3FEAFD100EAFC290ull,0x3FEAFB58F12D0A18ull,0x3FEAF9A18EF5C645ull,0x3FEAF7E9E80E55E9ull,0x3FEAF631FC7B1888ull,0x3FEAF479CC406E52ull,0x3FEAF2C15762B827ull,0x3FEAF1089DE65796ull,
		0x3FEAEF4F9FCFAEDDull,0x3FEAED965D2320E8ull,0x3FEAEBDCD5E51152ull,0x3FEAEA230A19E463ull,0x3FEAE868F9C5FF15ull,0x3FEAE6AEA4EDC70Dull,0x3FEAE4F40B95A2A0ull,0x3FEAE3392DC1F8D3ull,
		0x3FEAE17E0B773156ull,0x3FEADFC2A4B9B48Aull,0x3FEADE06F98DEB7Eull,0x3FEADC4B09F83FEDull,0x3FEADA8ED5FD1C43ull,0x3FEAD8D25DA0EB99ull,0x3FEAD715A0E819B5ull,0x3FEAD5589FD7130Eull,
		0x3FEAD39B5A7244C6ull,0x3FEAD1DDD0BE1CAFull,0x3FEAD02002BF0947ull,0x3FEACE61F07979BDull,0x3FEACCA399F1DDEAull,0x3FEACAE4FF2CA657ull,0x3FEAC926202E443Cull,0x3FEAC766FCFB297Bull,
		0x3FEAC5A79597C8A8ull,0x3FEAC3E7EA089501ull,0x3FEAC227FA520274ull,0x3FEAC067C678859Bull,0x3FEABEA74E8093BFull,0x3FEABCE6926EA2D5ull,0x3FEABB2592472980ull,0x3FEAB9644E0E9F10ull,
		0x3FEAB7A2C5C97B84ull,0x3FEAB5E0F97C3786ull,0x3FEAB41EE92B4C6Eull,0x3FEAB25C94DB3442ull,0x3FEAB099FC9069B4ull,0x3FEAAED7204F6825ull,0x3FEAAD14001CABA0ull,0x3FEAAB509BFCB0DFull,
		0x3FEAA98CF3F3F54Aull,0x3FEAA7C90806F6F3ull,0x3FEAA604D83A349Cull,0x3FEAA44064922DB1ull,0x3FEAA27BAD13624Cull,0x3FEAA0B6B1C25335ull,0x3FEA9EF172A381DFull,0x3FEA9D2BEFBB706Aull,
		0x3FEA9B66290EA1A3ull,0x3FEA99A01EA19903ull,0x3FEA97D9D078DAB0ull,0x3FEA96133E98EB7Dull,0x3FEA944C690650E8ull,0x3FEA92854FC5911Cull,0x3FEA90BDF2DB32F2ull,0x3FEA8EF6524BBDECull,
		0x3FEA8D2E6E1BBA3Aull,0x3FEA8B66464FB0BAull,0x3FEA899DDAEC2AF3ull,0x3FEA87D52BF5B31Aull,0x3FEA860C3970D40Full,0x3FEA84430362195Full,0x3FEA827989CE0F43ull,0x3FEA80AFCCB9429Full,
		0x3FEA7EE5CC284103ull,0x3FEA7D1B881F98ACull,0x3FEA7B5100A3D882ull,0x3FEA798635B99018ull,0x3FEA77BB27654FAEull,0x3FEA75EFD5ABA82Full,0x3FEA742440912B33ull,0x3FEA7258681A6AFAull,
		0x3FEA708C4C4BFA74ull,0x3FEA6EBFED2A6D39ull,0x3FEA6CF34ABA578Eull,0x3FEA6B2665004E63ull,0x3FEA69593C00E754ull,0x3FEA678BCFC0B8A8ull,0x3FEA65BE20445950ull,0x3FEA63F02D9060EAull,
		0x3FEA6221F7A967BEull,0x3FEA60537E9406C0ull,0x3FEA5E84C254D78Full,0x3FEA5CB5C2F07473ull,0x3FEA5AE6806B7862ull,0x3FEA5916FACA7EFAull,0x3FEA574732122487ull,0x3FEA5577264705FEull,
		0x3FEA53A6D76DC0FEull,0x3FEA51D6458AF3D3ull,0x3FEA500570A33D71ull,0x3FEA4E3458BB3D7Aull,0x3FEA4C62FDD79437ull,0x3FEA4A915FFCE29Dull,0x3FEA48BF7F2FCA4Eull,0x3FEA46ED5B74ED93ull,
		0x3FEA451AF4D0EF61ull,0x3FEA43484B487356ull,0x3FEA41755EE01DBCull,0x3FEA3FA22F9C9388ull,0x3FEA3DCEBD827A56ull,0x3FEA3BFB08967870ull,0x3FEA3A2710DD34C6ull,0x3FEA3852D65B56F7ull,
		0x3FEA367E59158747ull,0x3FEA34A999106EA8ull,0x3FEA32D49650B6B4ull,0x3FEA30FF50DB09AFull,0x3FEA2F29C8B41287ull,0x3FEA2D53FDE07CD5ull,0x3FEA2B7DF064F4DAull,0x3FEA29A7A0462782ull,
		0x3FEA27D10D88C262ull,0x3FEA25FA383173B8ull,0x3FEA24232044EA6Eull,0x3FEA224BC5C7D615ull,0x3FEA207428BEE6E8ull,0x3FEA1E9C492ECDCDull,0x3FEA1CC4271C3C52ull,0x3FEA1AEBC28BE4AFull,
		0x3FEA19131B8279C4ull,0x3FEA173A3204AF1Cull,0x3FEA1561061738EAull,0x3FEA138797BECC0Bull,0x3FEA11ADE7001E05ull,0x3FEA0FD3F3DFE506ull,0x3FEA0DF9BE62D7E6ull,0x3FEA0C1F468DAE27ull,
		0x3FEA0A448C651FF2ull,0x3FEA08698FEDE619ull,0x3FEA068E512CBA19ull,0x3FEA04B2D0265615ull,0x3FEA02D70CDF74DBull,0x3FEA00FB075CD1E0ull,0x3FE9FF1EBFA32943ull,0x3FE9FD4235B737CAull,
		0x3FE9FB65699DBAE6ull,0x3FE9F9885B5B70AEull,0x3FE9F7AB0AF517E3ull,0x3FE9F5CD786F6FEFull,0x3FE9F3EFA3CF38E1ull,0x3FE9F2118D193375ull,0x3FE9F0333452210Bull,0x3FE9EE54997EC3AFull,
		0x3FE9EC75BCA3DE12ull,0x3FE9EA969DC6338Full,0x3FE9E8B73CEA8828ull,0x3FE9E6D79A15A089ull,0x3FE9E4F7B54C4203ull,0x3FE9E3178E933292ull,0x3FE9E13725EF38D7ull,0x3FE9DF567B651C1Eull,
		0x3FE9DD758EF9A457ull,0x3FE9DB9460B19A1Eull,0x3FE9D9B2F091C6B3ull,0x3FE9D7D13E9EF400ull,0x3FE9D5EF4ADDEC96ull,0x3FE9D40D15537BADull,0x3FE9D22A9E046D24ull,0x3FE9D047E4F58D84ull,
		0x3FE9CE64EA2BA9FBull,0x3FE9CC81ADAB9060ull,0x3FE9CA9E2F7A0F2Full,0x3FE9C8BA6F9BF58Dull,0x3FE9C6D66E161348ull,0x3FE9C4F22AED38D1ull,0x3FE9C30DA6263743ull,0x3FE9C128DFC5E060ull,
		0x3FE9BF43D7D10690ull,0x3FE9BD5E8E4C7CE2ull,0x3FE9BB79033D170Dull,0x3FE9B99336A7A96Eull,0x3FE9B7AD28910909ull,0x3FE9B5C6D8FE0B8Aull,0x3FE9B3E047F38741ull,0x3FE9B1F975765327ull,
		0x3FE9B012618B46DBull,0x3FE9AE2B0C373AA4ull,0x3FE9AC43757F076Cull,0x3FE9AA5B9D6786C7ull,0x3FE9A87383F592EEull,0x3FE9A68B292E06C0ull,0x3FE9A4A28D15BDC4ull,0x3FE9A2B9AFB19425ull,
		0x3FE9A0D0910666B7ull,0x3FE99EE7311912F1ull,0x3FE99CFD8FEE76F3ull,0x3FE99B13AD8B7182ull,0x3FE9992989F4E209ull,0x3FE9973F252FA898ull,0x3FE995547F40A5E8ull,0x3FE99369982CBB56ull,
		0x3FE9917E6FF8CAE3ull,0x3FE98F9306A9B739ull,0x3FE98DA75C4463A7ull,0x3FE98BBB70CDB420ull,0x3FE989CF444A8D3Full,0x3FE987E2D6BFD443ull,0x3FE985F628326F11ull,0x3FE9840938A74435ull,
		0x3FE9821C08233ADEull,0x3FE9802E96AB3AE2ull,0x3FE97E40E4442CBBull,0x3FE97C52F0F2F98Bull,0x3FE97A64BCBC8B18ull,0x3FE9787647A5CBCBull,0x3FE9768791B3A6B5ull,0x3FE974989AEB078Cull,
		0x3FE972A96350DAA9ull,0x3FE970B9EAEA0D0Dull,0x3FE96ECA31BB8C5Bull,0x3FE96CDA37CA46DEull,0x3FE96AE9FD1B2B82ull,0x3FE968F981B329DCull,0x3FE96708C5973224ull,0x3FE96517C8CC3535ull,
		0x3FE963268B572492ull,0x3FE961350D3CF260ull,0x3FE95F434E82916Bull,0x3FE95D514F2CF521ull,0x3FE95B5F0F411197ull,0x3FE9596C8EC3DB84ull,0x3FE95779CDBA4844ull,0x3FE95586CC294DDAull,
		0x3FE953938A15E2EAull,0x3FE951A00784FEBFull,0x3FE94FAC447B9944ull,0x3FE94DB840FEAB0Eull,0x3FE94BC3FD132D51ull,0x3FE949CF78BE19E7ull,0x3FE947DAB4046B50ull,0x3FE945E5AEEB1CADull,
		0x3FE943F0697729C4ull,0x3FE941FAE3AD8EFEull,0x3FE940051D93496Bull,0x3FE93E0F172D56BAull,0x3FE93C18D080B542ull,0x3FE93A22499263FBull,0x3FE9382B82676282ull,0x3FE936347B04B117ull,
		0x3FE9343D336F509Cull,0x3FE93245ABAC429Bull,0x3FE9304DE3C0893Cull,0x3FE92E55DBB1274Eull,0x3FE92C5D93832041ull,0x3FE92A650B3B782Bull,0x3FE9286C42DF33C3ull,0x3FE926733A735864ull,
		0x3FE92479F1FCEC0Bull,0x3FE922806980F55Bull,0x3FE92086A1047B96ull,0x3FE91E8C988C86A4ull,0x3FE91C92501E1F0Eull,0x3FE91A97C7BE4E02ull,0x3FE9189CFF721D50ull,0x3FE916A1F73E9769ull,
		0x3FE914A6AF28C763ull,0x3FE912AB2735B8F5ull,0x3FE910AF5F6A787Aull,0x3FE90EB357CC12EFull,0x3FE90CB7105F95F3ull,0x3FE90ABA892A0FC9ull,0x3FE908BDC2308F55ull,0x3FE906C0BB78241Dull,
		0x3FE904C37505DE4Bull,0x3FE902C5EEDECEAAull,0x3FE900C8290806A7ull,0x3FE8FECA23869853ull,0x3FE8FCCBDE5F965Full,0x3FE8FACD5998141Full,0x3FE8F8CE95352589ull,0x3FE8F6CF913BDF35ull,
		0x3FE8F4D04DB1565Dull,0x3FE8F2D0CA9AA0DCull,0x3FE8F0D107FCD530ull,0x3FE8EED105DD0A78ull,0x3FE8ECD0C4405876ull,0x3FE8EAD0432BD78Bull,0x3FE8E8CF82A4A0BDull,0x3FE8E6CE82AFCDB0ull,
		0x3FE8E4CD435278ADull,0x3FE8E2CBC491BC9Cull,0x3FE8E0CA0672B507ull,0x3FE8DEC808FA7E19ull,0x3FE8DCC5CC2E34A1ull,0x3FE8DAC35012F60Bull,0x3FE8D8C094ADE067ull,0x3FE8D6BD9A041266ull,
		0x3FE8D4BA601AAB58ull,0x3FE8D2B6E6F6CB32ull,0x3FE8D0B32E9D9286ull,0x3FE8CEAF37142289ull,0x3FE8CCAB005F9D11ull,0x3FE8CAA68A852493ull,0x3FE8C8A1D589DC27ull,0x3FE8C69CE172E785ull,
		0x3FE8C497AE456B06ull,0x3FE8C2923C068BA2ull,0x3FE8C08C8ABB6EF3ull,0x3FE8BE869A693B35ull,0x3FE8BC806B151741ull,0x3FE8BA79FCC42A93ull,0x3FE8B8734F7B9D46ull,0x3FE8B66C63409817ull,
		0x3FE8B46538184462ull,0x3FE8B25DCE07CC23ull,0x3FE8B056251459F8ull,0x3FE8AE4E3D43191Dull,0x3FE8AC461699356Eull,0x3FE8AA3DB11BDB69ull,0x3FE8A8350CD0382Bull,0x3FE8A62C29BB7971ull,
		0x3FE8A42307E2CD97ull,0x3FE8A219A74B639Aull,0x3FE8A01007FA6B17ull,0x3FE89E0629F51448ull,0x3FE89BFC0D40900Bull,0x3FE899F1B1E20FDAull,0x3FE897E717DEC5D0ull,0x3FE895DC3F3BE4A8ull,
		0x3FE893D127FE9FBBull,0x3FE891C5D22C2B03ull,0x3FE88FBA3DC9BB19ull,0x3FE88DAE6ADC8534ull,0x3FE88BA25969BF2Bull,0x3FE8899609769F75ull,0x3FE887897B085D28ull,0x3FE8857CAE242FF8ull,
		0x3FE8836FA2CF5039ull,0x3FE88162590EF6DEull,0x3FE87F54D0E85D77ull,0x3FE87D470A60BE36ull,0x3FE87B39057D53EBull,0x3FE8792AC2435A02ull,0x3FE8771C40B80C8Aull,0x3FE8750D80E0A82Dull,
		0x3FE872FE82C26A36ull,0x3FE870EF4662908Dull,0x3FE86EDFCBC659BBull,0x3FE86CD012F304E4ull,0x3FE86AC01BEDD1CDull,0x3FE868AFE6BC00D8ull,0x3FE8669F7362D307ull,0x3FE8648EC1E789F9ull,
		0x3FE8627DD24F67EAull,0x3FE8606CA49FAFB6ull,0x3FE85E5B38DDA4D8ull,0x3FE85C498F0E8B66ull,0x3FE85A37A737A817ull,0x3FE85825815E403Dull,0x3FE856131D8799CBull,0x3FE854007BB8FB50ull,
		0x3FE851ED9BF7ABFAull,0x3FE84FDA7E48F392ull,0x3FE84DC722B21A82ull,0x3FE84BB3893869D0ull,0x3FE8499FB1E12B20ull,0x3FE8478B9CB1A8B3ull,0x3FE8457749AF2D68ull,0x3FE84362B8DF04BBull,
		0x3FE8414DEA467AC6ull,0x3FE83F38DDEADC3Full,0x3FE83D2393D1767Cull,0x3FE83B0E0BFF976Eull,0x3FE838F8467A8DA2ull,0x3FE836E24347A846ull,0x3FE834CC026C3721ull,0x3FE832B583ED8A99ull,
		0x3FE8309EC7D0F3B2ull,0x3FE82E87CE1BC40Bull,0x3FE82C7096D34DDFull,0x3FE82A5921FCE40Aull,0x3FE828416F9DD9FFull,0x3FE826297FBB83D3ull,0x3FE82411525B3635ull,0x3FE821F8E7824670ull,
		0x3FE81FE03F360A6Dull,0x3FE81DC7597BD8B0ull,0x3FE81BAE3659085Cull,0x3FE81994D5D2F12Eull,0x3FE8177B37EEEB7Full,0x3FE815615CB25047ull,0x3FE8134744227917ull,0x3FE8112CEE44C01Full,
		0x3FE80F125B1E8028ull,0x3FE80CF78AB5149Aull,0x3FE80ADC7D0DD978ull,0x3FE808C1322E2B60ull,0x3FE806A5AA1B678Dull,0x3FE80489E4DAEBD6ull,0x3FE8026DE27216ABull,0x3FE80051A2E6471Dull,
		0x3FE7FE35263CDCD4ull,0x3FE7FC186C7B3815ull,0x3FE7F9FB75A6B9C1ull,0x3FE7F7DE41C4C355ull,0x3FE7F5C0D0DAB6E9ull,0x3FE7F3A322EDF72Full,0x3FE7F1853803E777ull,0x3FE7EF671021EBA9ull,
		0x3FE7ED48AB4D684Cull,0x3FE7EB2A098BC27Full,0x3FE7E90B2AE25FFFull,0x3FE7E6EC0F56A720ull,0x3FE7E4CCB6EDFED6ull,0x3FE7E2AD21ADCEADull,0x3FE7E08D4F9B7ECBull,0x3FE7DE6D40BC77F4ull,
		0x3FE7DC4CF5162385ull,0x3FE7DA2C6CADEB75ull,0x3FE7D80BA7893A58ull,0x3FE7D5EAA5AD7B5Aull,0x3FE7D3C967201A43ull,0x3FE7D1A7EBE68376ull,0x3FE7CF86340623F0ull,0x3FE7CD643F846948ull,
		0x3FE7CB420E66C1AFull,0x3FE7C91FA0B29BF3ull,0x3FE7C6FCF66D6779ull,0x3FE7C4DA0F9C9442ull,0x3FE7C2B6EC4592E9ull,0x3FE7C0938C6DD4A2ull,0x3FE7BE6FF01ACB3Dull,0x3FE7BC4C1751E922ull,
		0x3FE7BA280218A154ull,0x3FE7B803B0746771ull,0x3FE7B5DF226AAFAFull,0x3FE7B3BA5800EEDEull,0x3FE7B195513C9A68ull,0x3FE7AF700E232852ull,0x3FE7AD4A8EBA0F38ull,0x3FE7AB24D306C652ull,
		0x3FE7A8FEDB0EC571ull,0x3FE7A6D8A6D784FEull,0x3FE7A4B236667DFDull,0x3FE7A28B89C12A0Bull,0x3FE7A064A0ED035Dull,0x3FE79E3D7BEF84C4ull,0x3FE79C161ACE29A8ull,0x3FE799EE7D8E6E0Aull,
		0x3FE797C6A435CE85ull,0x3FE7959E8EC9C84Dull,0x3FE793763D4FD92Full,0x3FE7914DAFCD7F90ull,0x3FE78F24E6483A6Full,0x3FE78CFBE0C58964ull,0x3FE78AD29F4AEC9Eull,0x3FE788A921DDE4E7ull,
		0x3FE7867F6883F39Full,0x3FE7845573429AC1ull,0x3FE7822B421F5CE0ull,0x3FE78000D51FBD26ull,0x3FE77DD62C493F57ull,0x3FE77BAB47A167D0ull,0x3FE77980272DBB83ull,0x3FE77754CAF3BFFEull,
		0x3FE7752932F8FB65ull,0x3FE772FD5F42F475ull,0x3FE770D14FD73283ull,0x3FE76EA504BB3D7Cull,0x3FE76C787DF49DE5ull,0x3FE76A4BBB88DCDBull,0x3FE7681EBD7D8412ull,0x3FE765F183D81DD8ull,
		0x3FE763C40E9E350Full,0x3FE761965DD55536ull,0x3FE75F6871830A5Eull,0x3FE75D3A49ACE134ull,0x3FE75B0BE65866FBull,0x3FE758DD478B298Cull,0x3FE756AE6D4AB759ull,0x3FE7547F579C9F6Dull,
		0x3FE7525006867166ull,0x3FE750207A0DBD7Eull,0x3FE74DF0B2381482ull,0x3FE74BC0AF0B07D9ull,0x3FE74990708C2981ull,0x3FE7475FF6C10C0Dull,0x3FE7452F41AF42AAull,0x3FE742FE515C6118ull,
		0x3FE740CD25CDFBB2ull,0x3FE73E9BBF09A766ull,0x3FE73C6A1D14F9BDull,0x3FE73A383FF588D3ull,0x3FE7380627B0EB5Cull,0x3FE735D3D44CB8A3ull,0x3FE733A145CE888Aull,0x3FE7316E7C3BF387ull,
		0x3FE72F3B779A92AAull,0x3FE72D0837EFFF96ull,0x3FE72AD4BD41D487ull,0x3FE728A10795AC4Eull,0x3FE7266D16F12252ull,0x3FE72438EB59D290ull,0x3FE7220484D5599Cull,0x3FE71FCFE36954A1ull,
		0x3FE71D9B071B615Dull,0x3FE71B65EFF11E26ull,0x3FE719309DF029E7ull,0x3FE716FB111E2423ull,0x3FE714C54980ACF0ull,0x3FE7128F471D64FAull,0x3FE7105909F9ED84ull,0x3FE70E22921BE867ull,
		0x3FE70BEBDF88F80Full,0x3FE709B4F246BF81ull,0x3FE7077DCA5AE253ull,0x3FE7054667CB04B5ull,0x3FE7030ECA9CCB6Aull,0x3FE700D6F2D5DBC9ull,0x3FE6FE9EE07BDBC1ull,0x3FE6FC66939471D4ull,
		0x3FE6FA2E0C25451Aull,0x3FE6F7F54A33FD41ull,0x3FE6F5BC4DC6428Aull,0x3FE6F38316E1BDCCull,0x3FE6F149A58C1872ull,0x3FE6EF0FF9CAFC7Eull,0x3FE6ECD613A41485ull,0x3FE6EA9BF31D0BB0ull,
		0x3FE6E861983B8DBEull,0x3FE6E62703054703ull,0x3FE6E3EC337FE466ull,0x3FE6E1B129B11363ull,0x3FE6DF75E59E820Cull,0x3FE6DD3A674DDF05ull,0x3FE6DAFEAEC4D987ull,0x3FE6D8C2BC092160ull,
		0x3FE6D6868F2066F3ull,0x3FE6D44A28105B34ull,0x3FE6D20D86DEAFADull,0x3FE6CFD0AB91167Eull,0x3FE6CD93962D4257ull,0x3FE6CB5646B8E67Full,0x3FE6C918BD39B6CFull,0x3FE6C6DAF9B567B5ull,
		0x3FE6C49CFC31AE32ull,0x3FE6C25EC4B43FDBull,0x3FE6C0205342D2D9ull,0x3FE6BDE1A7E31DE8ull,0x3FE6BBA2C29AD857ull,0x3FE6B963A36FBA0Aull,0x3FE6B7244A677B77ull,0x3FE6B4E4B787D5A8ull,
		0x3FE6B2A4EAD6823Aull,0x3FE6B064E4593B5Eull,0x3FE6AE24A415BBD7ull,0x3FE6ABE42A11BEFBull,0x3FE6A9A3765300B5ull,0x3FE6A76288DF3D81ull,0x3FE6A52161BC326Full,0x3FE6A2E000EF9D21ull,
		0x3FE6A09E667F3BCDull,0x3FE69E5C9270CD3Aull,0x3FE69C1A84CA10C5ull,0x3FE699D83D90C659ull,0x3FE69795BCCAAE78ull,0x3FE69553027D8A34ull,0x3FE693100EAF1B32ull,0x3FE690CCE16523A9ull,
		0x3FE68E897AA56664ull,0x3FE68C45DA75A6BFull,0x3FE68A0200DBA8A9ull,0x3FE687BDEDDD30A1ull,0x3FE68579A18003BCull,0x3FE683351BC9E79Dull,0x3FE680F05CC0A27Cull,0x3FE67EAB6469FB22ull,
		0x3FE67C6632CBB8E9ull,0x3FE67A20C7EBA3BFull,0x3FE677DB23CF8422ull,0x3FE67595467D2321ull,0x3FE6734F2FFA4A60ull,0x3FE67108E04CC411ull,0x3FE66EC2577A5AF9ull,0x3FE66C7B9588DA70ull,
		0x3FE66A349A7E0E5Cull,0x3FE667ED665FC339ull,0x3FE665A5F933C610ull,0x3FE6635E52FFE47Eull,0x3FE6611673C9ECAFull,0x3FE65ECE5B97AD63ull,0x3FE65C860A6EF5E9ull,0x3FE65A3D80559621ull,
		0x3FE657F4BD515E7Dull,0x3FE655ABC1682000ull,0x3FE653628C9FAC3Cull,0x3FE651191EFDD557ull,0x3FE64ECF78886E06ull,0x3FE64C859945498Dull,0x3FE64A3B813A3BC3ull,0x3FE647F1306D190Full,
		0x3FE645A6A6E3B669ull,0x3FE6435BE4A3E959ull,0x3FE64110E9B387F6ull,0x3FE63EC5B61868E9ull,0x3FE63C7A49D8636Cull,0x3FE63A2EA4F94F48ull,0x3FE637E2C78104D5ull,0x3FE63596B1755CFEull,
		0x3FE6334A62DC313Bull,0x3FE630FDDBBB5B97ull,0x3FE62EB11C18B6ACull,0x3FE62C6423FA1DA1ull,0x3FE62A16F3656C31ull,0x3FE627C98A607EA5ull,0x3FE6257BE8F131D5ull,0x3FE6232E0F1D632Aull,
		0x3FE620DFFCEAF09Bull,0x3FE61E91B25FB8B0ull,0x3FE61C432F819A80ull,0x3FE619F4745675B2ull,0x3FE617A580E42A7Bull,0x3FE61556553099A0ull,0x3FE61306F141A475ull,0x3FE610B7551D2CDFull,
		0x3FE60E6780C9154Full,0x3FE60C17744B40C7ull,0x3FE609C72FA992D8ull,0x3FE60776B2E9EFA2ull,0x3FE60525FE123BD3ull,0x3FE602D511285CA8ull,0x3FE60083EC3237EEull,0x3FE5FE328F35B400ull,
		0x3FE5FBE0FA38B7C6ull,0x3FE5F98F2D412ABAull,0x3FE5F73D2854F4E1ull,0x3FE5F4EAEB79FED2ull,0x3FE5F29876B631AFull,0x3FE5F045CA0F772Aull,0x3FE5EDF2E58BB984ull,0x3FE5EB9FC930E38Bull,
		0x3FE5E94C7504E09Cull,0x3FE5E6F8E90D9CA2ull,0x3FE5E4A525510415ull,0x3FE5E25129D503FCull,0x3FE5DFFCF69F89EDull,0x3FE5DDA88BB6840Aull,0x3FE5DB53E91FE104ull,0x3FE5D8FF0EE19018ull,
		0x3FE5D6A9FD018114ull,0x3FE5D454B385A450ull,0x3FE5D1FF3273EAB5ull,0x3FE5CFA979D245B6ull,0x3FE5CD5389A6A756ull,0x3FE5CAFD61F70226ull,0x3FE5C8A702C94942ull,0x3FE5C6506C237055ull,
		0x3FE5C3F99E0B6B95ull,0x3FE5C1A298872FC9ull,0x3FE5BF4B5B9CB242ull,0x3FE5BCF3E751E8E0ull,0x3FE5BA9C3BACCA0Dull,0x3FE5B84458B34CC4ull,0x3FE5B5EC3E6B688Bull,0x3FE5B393ECDB1573ull,
		0x3FE5B13B64084C1Cull,0x3FE5AEE2A3F905B3ull,0x3FE5AC89ACB33BF1ull,0x3FE5AA307E3CE91Bull,0x3FE5A7D7189C0802ull,0x3FE5A57D7BD69406ull,0x3FE5A323A7F28911ull,0x3FE5A0C99CF5E39Bull,
		0x3FE59E6F5AE6A0A7ull,0x3FE59C14E1CABDC5ull,0x3FE599BA31A83910ull,0x3FE5975F4A851131ull,0x3FE595042C67455Cull,0x3FE592A8D754D550ull,0x3FE5904D4B53C15Bull,0x3FE58DF1886A0A54ull,
		0x3FE58B958E9DB19Eull,0x3FE589395DF4B929ull,0x3FE586DCF6752371ull,0x3FE584805824F37Cull,0x3FE58223830A2CDCull,0x3FE57FC6772AD3AFull,0x3FE57D69348CECA0ull,0x3FE57B0BBB367CE2ull,
		0x3FE578AE0B2D8A35ull,0x3FE5765024781AE6ull,0x3FE573F2071C35CAull,0x3FE57193B31FE244ull,0x3FE56F3528892840ull,0x3FE56CD6675E1036ull,0x3FE56A776FA4A329ull,0x3FE568184162EAA7ull,
		0x3FE565B8DC9EF0C9ull,0x3FE56359415EC031ull,0x3FE560F96FA8640Full,0x3FE55E996781E81Bull,0x3FE55C3928F15899ull,0x3FE559D8B3FCC256ull,0x3FE5577808AA32ABull,0x3FE5551726FFB77Bull,
		0x3FE552B60F035F34ull,0x3FE55054C0BB38CDull,0x3FE54DF33C2D53C9ull,0x3FE54B91815FC032ull,0x3FE5492F90588EA0ull,0x3FE546CD691DD033ull,0x3FE5446B0BB59696ull,0x3FE542087825F3FCull,
		0x3FE53FA5AE74FB23ull,0x3FE53D42AEA8BF55ull,0x3FE53ADF78C75462ull,0x3FE5387C0CD6CEA6ull,0x3FE536186ADD4307ull,0x3FE533B492E0C6F3ull,0x3FE5315084E77063ull,0x3FE52EEC40F755D8ull,
		0x3FE52C87C7168E5Dull,0x3FE52A23174B3188ull,0x3FE527BE319B5775ull,0x3FE52559160D18CCull,0x3FE522F3C4A68EBEull,0x3FE5208E3D6DD303ull,0x3FE51E288068FFDEull,0x3FE51BC28D9E301Aull,
		0x3FE5195C65137F0Cull,0x3FE516F606CF0891ull,0x3FE5148F72D6E90Full,0x3FE51228A9313D74ull,0x3FE50FC1A9E42338ull,0x3FE50D5A74F5B85Bull,0x3FE50AF30A6C1B65ull,0x3FE5088B6A4D6B68ull,
		0x3FE50623949FC7FDull,0x3FE503BB89695147ull,0x3FE5015348B027EEull,0x3FE4FEEAD27A6D26ull,0x3FE4FC8226CE42AAull,0x3FE4FA1945B1CABCull,0x3FE4F7B02F2B2827ull,0x3FE4F546E3407E3Eull,
		0x3FE4F2DD61F7F0DCull,0x3FE4F073AB57A463ull,0x3FE4EE09BF65BDBFull,0x3FE4EB9F9E286261ull,0x3FE4E93547A5B844ull,0x3FE4E6CABBE3E5E9ull,0x3FE4E45FFAE9125Aull,0x3FE4E1F504BB6526ull,
		0x3FE4DF89D9610668ull,0x3FE4DD1E78E01EBDull,0x3FE4DAB2E33ED74Eull,0x3FE4D847188359C9ull,0x3FE4D5DB18B3D062ull,0x3FE4D36EE3D665D7ull,0x3FE4D10279F1456Cull,0x3FE4CE95DB0A9AEBull,
		0x3FE4CC29072892A5ull,0x3FE4C9BBFE515975ull,0x3FE4C74EC08B1CB8ull,0x3FE4C4E14DDC0A56ull,0x3FE4C273A64A50BCull,0x3FE4C005C9DC1EDCull,0x3FE4BD97B897A432ull,0x3FE4BB29728310BFull,
		0x3FE4B8BAF7A49509ull,0x3FE4B64C4802621Eull,0x3FE4B3DD63A2A993ull,0x3FE4B16E4A8B9D81ull,0x3FE4AEFEFCC3708Bull,0x3FE4AC8F7A5055D5ull,0x3FE4AA1FC338810Eull,0x3FE4A7AFD7822667ull,
		0x3FE4A53FB7337A9Bull,0x3FE4A2CF6252B2E8ull,0x3FE4A05ED8E60513ull,0x3FE49DEE1AF3A765ull,0x3FE49B7D2881D0B0ull,0x3FE4990C0196B84Aull,0x3FE4969AA638960Dull,0x3FE49429166DA25Cull,
		0x3FE491B7523C161Dull,0x3FE48F4559AA2ABBull,0x3FE48CD32CBE1A28ull,0x3FE48A60CB7E1EDCull,0x3FE487EE35F073D1ull,0x3FE4857B6C1B5489ull,0x3FE483086E04FD0Bull,0x3FE480953BB3A9E1ull,
		0x3FE47E21D52D981Dull,0x3FE47BAE3A790552ull,0x3FE4793A6B9C2F9Cull,0x3FE476C6689D5599ull,0x3FE474523182B66Eull,0x3FE471DDC65291C1ull,0x3FE46F69271327C1ull,0x3FE46CF453CAB91Full,
		0x3FE46A7F4C7F8712ull,0x3FE4680A1137D352ull,0x3FE46594A1F9E020ull,0x3FE4631EFECBF03Full,0x3FE460A927B446F6ull,0x3FE45E331CB92810ull,0x3FE45BBCDDE0D7DEull,0x3FE459466B319B34ull,
		0x3FE456CFC4B1B768ull,0x3FE45458EA677257ull,0x3FE451E1DC591261ull,0x3FE44F6A9A8CDE69ull,0x3FE44CF325091DD6ull,0x3FE44A7B7BD41893ull,0x3FE448039EF4170Full,0x3FE4458B8E6F623Cull,
		0x3FE443134A4C438Full,0x3FE4409AD2910501ull,0x3FE43E222743F10Full,0x3FE43BA9486B52B8ull,0x3FE43930360D7580ull,0x3FE436B6F030A56Dull,0x3FE4343D76DB2F07ull,0x3FE431C3CA135F5Cull,
		0x3FE42F49E9DF83FBull,0x3FE42CCFD645EAF5ull,0x3FE42A558F4CE2E1ull,0x3FE427DB14FABAD6ull,0x3FE425606755C26Eull,0x3FE422E5866449C8ull,0x3FE4206A722CA183ull,0x3FE41DEF2AB51AC2ull,
		0x3FE41B73B004072Bull,0x3FE418F8021FB8E3ull,0x3FE4167C210E8297ull,0x3FE414000CD6B771ull,0x3FE41183C57EAB20ull,0x3FE40F074B0CB1D6ull,0x3FE40C8A9D872043ull,0x3FE40A0DBCF44B9Full,
		0x3FE40790A95A899Full,0x3FE4051362C0307Cull,0x3FE40295E92B96F1ull,0x3FE400183CA3143Aull,0x3FE3FD9A5D2D0015ull,0x3FE3FB1C4ACFB2C3ull,0x3FE3F89E05918505ull,0x3FE3F61F8D78D01Dull,
		0x3FE3F3A0E28BEDD1ull,0x3FE3F12204D13867ull,0x3FE3EEA2F44F0AA5ull,0x3FE3EC23B10BBFD4ull,0x3FE3E9A43B0DB3BFull,0x3FE3E724925B42B0ull,0x3FE3E4A4B6FAC973ull,0x3FE3E224A8F2A556ull,
		0x3FE3DFA468493427ull,0x3FE3DD23F504D434ull,0x3FE3DAA34F2BE44Full,0x3FE3D82276C4C3C7ull,0x3FE3D5A16BD5D26Full,0x3FE3D3202E657098ull,0x3FE3D09EBE79FF15ull,0x3FE3CE1D1C19DF39ull,
		0x3FE3CB9B474B72D9ull,0x3FE3C91940151C48ull,0x3FE3C697067D3E5Bull,0x3FE3C4149A8A3C67ull,0x3FE3C191FC427A41ull,0x3FE3BF0F2BAC5C3Eull,0x3FE3BC8C28CE4734ull,0x3FE3BA08F3AEA077ull,
		0x3FE3B7858C53CDDEull,0x3FE3B501F2C435BDull,0x3FE3B27E27063EEAull,0x3FE3AFFA292050B9ull,0x3FE3AD75F918D2FFull,0x3FE3AAF196F62E11ull,0x3FE3A86D02BECAC1ull,0x3FE3A5E83C791264ull,
		0x3FE3A363442B6ECBull,0x3FE3A0DE19DC4A4Bull,0x3FE39E58BD920FB3ull,0x3FE39BD32F532A54ull,0x3FE3994D6F260600ull,0x3FE396C77D110F04ull,0x3FE39441591AB230ull,0x3FE391BB03495CCFull,
		0x3FE38F347BA37CAFull,0x3FE38CADC22F801Bull,0x3FE38A26D6F3D5DCull,0x3FE3879FB9F6ED3Bull,0x3FE385186B3F3600ull,0x3FE38290EAD32070ull,0x3FE3800938B91D50ull,0x3FE37D8154F79DE3ull,
		0x3FE37AF93F9513EAull,0x3FE37870F897F1A5ull,0x3FE375E88006A9D4ull,0x3FE3735FD5E7AFB0ull,0x3FE370D6FA4176F7ull,0x3FE36E4DED1A73DFull,0x3FE36BC4AE791B21ull,0x3FE3693B3E63E1F0ull,
		0x3FE366B19CE13DFFull,0x3FE36427C9F7A57Full,0x3FE3619DC5AD8F1Full,0x3FE35F1390097209ull,0x3FE35C892911C5E8ull,0x3FE359FE90CD02E4ull,0x3FE35773C741A1A1ull,0x3FE354E8CC761B41ull,
		0x3FE3525DA070E964ull,0x3FE34FD243388627ull,0x3FE34D46B4D36C25ull,0x3FE34ABAF5481676ull,0x3FE3482F049D00ADull,0x3FE345A2E2D8A6DDull,0x3FE3431690018594ull,0x3FE3408A0C1E19DFull,
		0x3FE33DFD5734E146ull,0x3FE33B70714C59CEull,0x3FE338E35A6B01FBull,0x3FE33656129758CAull,0x3FE333C899D7DDB8ull,0x3FE3313AF03310BCull,0x3FE32EAD15AF724Cull,0x3FE32C1F0A538358ull,
		0x3FE32990CE25C54Full,0x3FE32702612CBA19ull,0x3FE32473C36EE41Dull,0x3FE321E4F4F2C63Eull,0x3FE31F55F5BEE3D9ull,0x3FE31CC6C5D9C0C9ull,0x3FE31A376549E164ull,0x3FE317A7D415CA7Eull,
		0x3FE3151812440163ull,0x3FE312881FDB0BDEull,0x3FE30FF7FCE17035ull,0x3FE30D67A95DB529ull,0x3FE30AD7255661F7ull,0x3FE3084670D1FE57ull,0x3FE305B58BD7127Eull,0x3FE30324766C271Cull,
		0x3FE300933097C559ull,0x3FE2FE01BA6076DEull,0x3FE2FB7013CCC5CAull,0x3FE2F8DE3CE33CBBull,0x3FE2F64C35AA66C7ull,0x3FE2F3B9FE28CF81ull,0x3FE2F127966502F7ull,0x3FE2EE94FE658DB1ull,
		0x3FE2EC023630FCB1ull,0x3FE2E96F3DCDDD77ull,0x3FE2E6DC1542BDF9ull,0x3FE2E448BC962CACull,0x3FE2E1B533CEB87Eull,0x3FE2DF217AF2F0D5ull,0x3FE2DC8D92096596ull,0x3FE2D9F97918A71Dull,
		0x3FE2D76530274641ull,0x3FE2D4D0B73BD453ull,0x3FE2D23C0E5CE321ull,0x3FE2CFA7359104EFull,0x3FE2CD122CDECC7Dull,0x3FE2CA7CF44CCD05ull,0x3FE2C7E78BE19A3Aull,0x3FE2C551F3A3C84Bull,
		0x3FE2C2BC2B99EBDFull,0x3FE2C02633CA9A16ull,0x3FE2BD900C3C688Bull,0x3FE2BAF9B4F5ED53ull,0x3FE2B8632DFDBEFAull,0x3FE2B5CC775A748Aull,0x3FE2B3359112A581ull,0x3FE2B09E7B2CE9DBull,
		0x3FE2AE0735AFDA09ull,0x3FE2AB6FC0A20EF9ull,0x3FE2A8D81C0A2210ull,0x3FE2A64047EEAD2Cull,0x3FE2A3A844564AA5ull,0x3FE2A1101147954Bull,0x3FE29E77AEC92868ull,0x3FE29BDF1CE19FBDull,
		0x3FE299465B979786ull,0x3FE296AD6AF1AC76ull,0x3FE294144AF67BB8ull,0x3FE2917AFBACA2F2ull,0x3FE28EE17D1AC040ull,0x3FE28C47CF477238ull,0x3FE289ADF23957E8ull,0x3FE28713E5F710D5ull,
		0x3FE28479AA873CFEull,0x3FE281DF3FF07CD9ull,0x3FE27F44A6397155ull,0x3FE27CA9DD68BBD8ull,0x3FE27A0EE584FE3Full,0x3FE27773BE94DAE3ull,0x3FE274D8689EF490ull,0x3FE2723CE3A9EE8Cull,
		0x3FE26FA12FBC6C94ull,0x3FE26D054CDD12DFull,0x3FE26A693B128617ull,0x3FE267CCFA636B62ull,0x3FE265308AD6685Aull,0x3FE26293EC722313ull,0x3FE25FF71F3D4216ull,0x3FE25D5A233E6C65ull,
		0x3FE25ABCF87C4978ull,0x3FE2581F9EFD813Full,0x3FE2558216C8BC20ull,0x3FE252E45FE4A2F8ull,0x3FE250467A57DF1Cull,0x3FE24DA866291A57ull,0x3FE24B0A235EFEEAull,0x3FE2486BB200378Full,
		0x3FE245CD12136F74ull,0x3FE2432E439F523Full,0x3FE2408F46AA8C0Cull,0x3FE23DF01B3BC96Full,0x3FE23B50C159B76Eull,0x3FE238B1390B038Bull,0x3FE2361182565BBAull,0x3FE233719D426E67ull,
		0x3FE230D189D5EA73ull,0x3FE22E3148177F37ull,0x3FE22B90D80DDC7Full,0x3FE228F039BFB28Full,0x3FE2264F6D33B221ull,0x3FE223AE72708C63ull,0x3FE2210D497CF2FBull,0x3FE21E6BF25F9802ull,
		0x3FE21BCA6D1F2E09ull,0x3FE21928B9C26814ull,0x3FE21686D84FF99Full,0x3FE213E4C8CE969Aull,0x3FE211428B44F369ull,0x3FE20EA01FB9C4E9ull,0x3FE20BFD8633C068ull,0x3FE2095ABEB99BABull,
		0x3FE206B7C9520CEDull,0x3FE20414A603CADBull,0x3FE2017154D58C9Aull,0x3FE1FECDD5CE09C3ull,0x3FE1FC2A28F3FA61ull,0x3FE1F9864E4E16F9ull,0x3FE1F6E245E3187Full,0x3FE1F43E0FB9B85Full,
		0x3FE1F199ABD8B078ull,0x3FE1EEF51A46BB1Full,0x3FE1EC505B0A931Cull,0x3FE1E9AB6E2AF3ACull,0x3FE1E70653AE987Eull,0x3FE1E4610B9C3DB9ull,0x3FE1E1BB95FA9FF6ull,0x3FE1DF15F2D07C40ull,
		0x3FE1DC702224901Aull,0x3FE1D9CA23FD9978ull,0x3FE1D723F86256C3ull,0x3FE1D47D9F5986D7ull,0x3FE1D1D718E9E905ull,0x3FE1CF30651A3D10ull,0x3FE1CC8983F1432Full,0x3FE1C9E27575BC0Dull,
		0x3FE1C73B39AE68C8ull,0x3FE1C493D0A20AF2ull,0x3FE1C1EC3A576490ull,0x3FE1BF4476D53819ull,0x3FE1BC9C86224878ull,0x3FE1B9F46845590Cull,0x3FE1B74C1D452DA5ull,0x3FE1B4A3A5288A89ull,
		0x3FE1B1FAFFF6346Dull,0x3FE1AF522DB4F07Cull,0x3FE1ACA92E6B8452ull,0x3FE1AA000220B5FEull,0x3FE1A756A8DB4C03ull,0x3FE1A4AD22A20D53ull,0x3FE1A2036F7BC157ull,0x3FE19F598F6F2FE7ull,
		0x3FE19CAF8283214Eull,0x3FE19A0548BE5E4Cull,0x3FE1975AE227B00Eull,0x3FE194B04EC5E038ull,0x3FE192058E9FB8DEull,0x3FE18F5AA1BC0486ull,0x3FE18CAF88218E27ull,0x3FE18A0441D7212Dull,
		0x3FE18758CEE38971ull,0x3FE184AD2F4D9343ull,0x3FE18201631C0B61ull,0x3FE17F556A55BEFBull,0x3FE17CA945017BB4ull,0x3FE179FCF3260F9Full,0x3FE1775074CA4942ull,0x3FE174A3C9F4F793ull,
		0x3FE171F6F2ACE9F9ull,0x3FE16F49EEF8F04Eull,0x3FE16C9CBEDFDADAull,0x3FE169EF62687A59ull,0x3FE16741D9999FF8ull,0x3FE16494247A1D52ull,0x3FE161E64310C475ull,0x3FE15F38356467E0ull,
		0x3FE15C89FB7BDA82ull,0x3FE159DB955DEFBAull,0x3FE1572D03117B5Aull,0x3FE1547E449D51A1ull,0x3FE151CF5A084742ull,0x3FE14F204359315Dull,0x3FE14C710096E585ull,0x3FE149C191C839BCull,
		0x3FE14711F6F40474ull,0x3FE1446230211C90ull,0x3FE141B23D565962ull,0x3FE13F021E9A92ADull,0x3FE13C51D3F4A0A2ull,0x3FE139A15D6B5BE4ull,0x3FE136F0BB059D86ull,0x3FE1343FECCA3F07ull,
		0x3FE1318EF2C01A5Bull,0x3FE12EDDCCEE09E0ull,0x3FE12C2C7B5AE868ull,0x3FE1297AFE0D9133ull,0x3FE126C9550CDFEEull,0x3FE12417805FB0B9ull,0x3FE12165800CE021ull,0x3FE11EB3541B4B23ull,
		0x3FE11C00FC91CF29ull,0x3FE1194E79774A10ull,0x3FE1169BCAD29A20ull,0x3FE113E8F0AA9E12ull,0x3FE11135EB06350Dull,0x3FE10E82B9EC3EA7ull,0x3FE10BCF5D639AE6ull,0x3FE1091BD5732A3Bull,
		0x3FE106682221CD8Aull,0x3FE103B443766622ull,0x3FE101003977D5C2ull,0x3FE0FE4C042CFE96ull,0x3FE0FB97A39CC33Bull,0x3FE0F8E317CE06BAull,0x3FE0F62E60C7AC89ull,0x3FE0F3797E90988Full,
		0x3FE0F0C4712FAF1Full,0x3FE0EE0F38ABD4FAull,0x3FE0EB59D50BEF51ull,0x3FE0E8A44656E3BFull,0x3FE0E5EE8C939850ull,0x3FE0E338A7C8F37Cull,0x3FE0E08297FDDC29ull,0x3FE0DDCC5D3939ABull,
		0x3FE0DB15F781F3C2ull,0x3FE0D85F66DEF29Cull,0x3FE0D5A8AB571ED6ull,0x3FE0D2F1C4F16178ull,0x3FE0D03AB3B4A3F7ull,0x3FE0CD8377A7D038ull,0x3FE0CACC10D1D089ull,0x3FE0C8147F398FA8ull,
		0x3FE0C55CC2E5F8BFull,0x3FE0C2A4DBDDF764ull,0x3FE0BFECCA28779Bull,0x3FE0BD348DCC65D4ull,0x3FE0BA7C26D0AEEBull,0x3FE0B7C3953C402Aull,0x3FE0B50AD9160747ull,0x3FE0B251F264F263ull,
		0x3FE0AF98E12FF00Dull,0x3FE0ACDFA57DEF3Full,0x3FE0AA263F55DF61ull,0x3FE0A76CAEBEB045ull,0x3FE0A4B2F3BF522Bull,0x3FE0A1F90E5EB5BCull,0x3FE09F3EFEA3CC12ull,0x3FE09C84C49586ADull,
		0x3FE099CA603AD77Dull,0x3FE0970FD19AB0DCull,0x3FE0945518BC0590ull,0x3FE0919A35A5C8C9ull,0x3FE08EDF285EEE26ull,0x3FE08C23F0EE69AFull,0x3FE089688F5B2FD7ull,0x3FE086AD03AC357Dull,
		0x3FE083F14DE86FECull,0x3FE081356E16D4D9ull,0x3FE07E79643E5A64ull,0x3FE07BBD3065F71Aull,0x3FE07900D294A1F0ull,0x3FE076444AD15248ull,0x3FE073879922FFEEull,0x3FE070CABD90A318ull,
		0x3FE06E0DB8213469ull,0x3FE06B5088DBACEDull,0x3FE068932FC7061Aull,0x3FE065D5ACEA39D1ull,0x3FE06318004C425Full,0x3FE0605A29F41A78ull,0x3FE05D9C29E8BD3Dull,0x3FE05ADE00312638ull,
		0x3FE0581FACD4515Eull,0x3FE055612FD93B0Dull,0x3FE052A28946E00Dull,0x3FE04FE3B9243D91ull,0x3FE04D24BF785135ull,0x3FE04A659C4A18FFull,0x3FE047A64FA0935Eull,0x3FE044E6D982BF2Dull,
		0x3FE0422739F79BACull,0x3FE03F677106288Aull,0x3FE03CA77EB565DBull,0x3FE039E7630C541Full,0x3FE037271E11F43Eull,0x3FE03466AFCD4789ull,0x3FE031A618454FBCull,0x3FE02EE557810EFAull,
		0x3FE02C246D8787CFull,0x3FE029635A5FBD32ull,0x3FE026A21E10B281ull,0x3FE023E0B8A16B83ull,0x3FE0211F2A18EC69ull,0x3FE01E5D727E39CBull,0x3FE01B9B91D858AAull,0x3FE018D9882E4E71ull,
		0x3FE01617558720F1ull,0x3FE01354F9E9D665ull,0x3FE01092755D7570ull,0x3FE00DCFC7E9051Eull,0x3FE00B0CF1938CE1ull,0x3FE00849F2641495ull,0x3FE00586CA61A47Dull,0x3FE002C379934545ull,
		0x3FE0000000000000ull,0x3FDFFA78BB5DBC52ull,0x3FDFF4F1254DD347ull,0x3FDFEF693DDE5972ull,0x3FDFE9E1051D6438ull,0x3FDFE4587B1909CDull,0x3FDFDECF9FDF6132ull,0x3FDFD946737E8238ull,
		0x3FDFD3BCF6048580ull,0x3FDFCE33277F8477ull,0x3FDFC8A907FD995Aull,0x3FDFC31E978CDF33ull,0x3FDFBD93D63B71DCull,0x3FDFB808C4176DFAull,0x3FDFB27D612EF104ull,0x3FDFACF1AD901939ull,
		0x3FDFA765A94905ACull,0x3FDFA1D95467D638ull,0x3FDF9C4CAEFAAB88ull,0x3FDF96BFB90FA713ull,0x3FDF913272B4EB1Eull,0x3FDF8BA4DBF89ABAull,0x3FDF8616F4E8D9C5ull,0x3FDF8088BD93CCEAull,
		0x3FDF7AFA3607999Eull,0x3FDF756B5E526626ull,0x3FDF6FDC36825991ull,0x3FDF6A4CBEA59BB9ull,0x3FDF64BCF6CA5546ull,0x3FDF5F2CDEFEAFABull,0x3FDF599C7750D525ull,0x3FDF540BBFCEF0BFull,
		0x3FDF4E7AB8872E4Eull,0x3FDF48E96187BA70ull,0x3FDF4357BADEC293ull,0x3FDF3DC5C49A74EBull,0x3FDF38337EC90079ull,0x3FDF32A0E9789508ull,0x3FDF2D0E04B7632Eull,0x3FDF277AD0939C4Bull,
		0x3FDF21E74D1B728Aull,0x3FDF1C537A5D18DDull,0x3FDF16BF5866C302ull,0x3FDF112AE746A583ull,0x3FDF0B96270AF5AFull,0x3FDF060117C1E9A1ull,0x3FDF006BB979B83Eull,0x3FDEFAD60C409932ull,
		0x3FDEF5401024C4F4ull,0x3FDEEFA9C53474C2ull,0x3FDEEA132B7DE2A4ull,0x3FDEE47C430F496Aull,0x3FDEDEE50BF6E4AEull,0x3FDED94D8642F0D0ull,0x3FDED3B5B201AAFAull,0x3FDECE1D8F41511Bull,
		0x3FDEC8851E1021EFull,0x3FDEC2EC5E7C5CF5ull,0x3FDEBD5350944277ull,0x3FDEB7B9F4661383ull,0x3FDEB2204A0011F1ull,0x3FDEAC8651708060ull,0x3FDEA6EC0AC5A235ull,0x3FDEA151760DBB9Bull,
		0x3FDE9BB693571187ull,0x3FDE961B62AFE9B2ull,0x3FDE907FE4268A9Cull,0x3FDE8AE417C93B8Bull,0x3FDE8547FDA6448Cull,0x3FDE7FAB95CBEE72ull,0x3FDE7A0EE04882D5ull,0x3FDE7471DD2A4C13ull,
		0x3FDE6ED48C7F9551ull,0x3FDE6936EE56AA77ull,0x3FDE639902BDD834ull,0x3FDE5DFAC9C36BFDull,0x3FDE585C4375B409ull,0x3FDE52BD6FE2FF58ull,0x3FDE4D1E4F199DABull,0x3FDE477EE127DF89ull,
		0x3FDE41DF261C163Full,0x3FDE3C3F1E0493DCull,0x3FDE369EC8EFAB34ull,0x3FDE30FE26EBAFE0ull,0x3FDE2B5D3806F63Bull,0x3FDE25BBFC4FD366ull,0x3FDE201A73D49D44ull,0x3FDE1A789EA3AA7Bull,
		0x3FDE14D67CCB5277ull,0x3FDE0F340E59ED64ull,0x3FDE0991535DD433ull,0x3FDE03EE4BE56098ull,0x3FDDFE4AF7FEED09ull,0x3FDDF8A757B8D4BEull,0x3FDDF3036B2173B2ull,0x3FDDED5F324726A4ull,
		0x3FDDE7BAAD384B13ull,0x3FDDE215DC033F41ull,0x3FDDDC70BEB66232ull,0x3FDDD6CB556013AAull,0x3FDDD125A00EB432ull,0x3FDDCB7F9ED0A512ull,0x3FDDC5D951B44853ull,0x3FDDC032B8C800C1ull,
		0x3FDDBA8BD41A31E8ull,0x3FDDB4E4A3B94015ull,0x3FDDAF3D27B39055ull,0x3FDDA99560178878ull,0x3FDDA3ED4CF38F0Cull,0x3FDD9E44EE560B60ull,0x3FDD989C444D6584ull,0x3FDD92F34EE80647ull,
		0x3FDD8D4A0E345738ull,0x3FDD87A08240C2A7ull,0x3FDD81F6AB1BB3A2ull,0x3FDD7C4C88D395F8ull,0x3FDD76A21B76D635ull,0x3FDD70F76313E1A7ull,0x3FDD6B4C5FB9265Aull,0x3FDD65A111751317ull,
		0x3FDD5FF578561769ull,0x3FDD5A49946AA397ull,0x3FDD549D65C128A7ull,0x3FDD4EF0EC68185Full,0x3FDD4944286DE542ull,0x3FDD439719E10290ull,0x3FDD3DE9C0CFE448ull,0x3FDD383C1D48FF27ull,
		0x3FDD328E2F5AC8A7ull,0x3FDD2CDFF713B700ull,0x3FDD273174824126ull,0x3FDD2182A7B4DECCull,0x3FDD1BD390BA0862ull,0x3FDD16242FA03712ull,0x3FDD10748475E4C6ull,0x3FDD0AC48F498C23ull,
		0x3FDD05145029A88Cull,0x3FDCFF63C724B61Dull,0x3FDCF9B2F44931B3ull,0x3FDCF401D7A598E1ull,0x3FDCEE50714869FDull,0x3FDCE89EC1402411ull,0x3FDCE2ECC79B46EAull,0x3FDCDD3A8468530Bull,
		0x3FDCD787F7B5C9B4ull,0x3FDCD1D521922CE2ull,0x3FDCCC22020BFF4Aull,0x3FDCC66E9931C45Eull,0x3FDCC0BAE712004Aull,0x3FDCBB06EBBB37F4ull,0x3FDCB552A73BF0FDull,0x3FDCAF9E19A2B1C1ull,
		0x3FDCA9E942FE0155ull,0x3FDCA434235C6789ull,0x3FDC9E7EBACC6CE5ull,0x3FDC98C9095C9AADull,0x3FDC93130F1B7ADEull,0x3FDC8D5CCC17982Cull,0x3FDC87A6405F7E08ull,0x3FDC81EF6C01B89Bull,
		0x3FDC7C384F0CD4C4ull,0x3FDC7680E98F601Full,0x3FDC70C93B97E8FEull,0x3FDC6B114534FE6Dull,0x3FDC655906753030ull,0x3FDC5FA07F670EC3ull,0x3FDC59E7B0192B5Aull,0x3FDC542E989A17E0ull,
		0x3FDC4E7538F866FCull,0x3FDC48BB9142AC07ull,0x3FDC4301A1877B15ull,0x3FDC3D4769D568F2ull,0x3FDC378CEA3B0B1Eull,0x3FDC31D222C6F7D3ull,0x3FDC2C171387C600ull,0x3FDC265BBC8C0D4Dull,
		0x3FDC20A01DE26617ull,0x3FDC1AE437996972ull,0x3FDC152809BFB128ull,0x3FDC0F6B9463D7BAull,0x3FDC09AED794785Eull,0x3FDC03F1D3602F01ull,0x3FDBFE3487D59846ull,0x3FDBF876F5035184ull,
		0x3FDBF2B91AF7F8C8ull,0x3FDBECFAF9C22CD7ull,0x3FDBE73C91708D27ull,0x3FDBE17DE211B9E6ull,0x3FDBDBBEEBB453F6ull,0x3FDBD5FFAE66FCEFull,0x3FDBD0402A38571Bull,0x3FDBCA805F37057Aull,
		0x3FDBC4C04D71ABC1ull,0x3FDBBEFFF4F6EE58ull,0x3FDBB93F55D5725Dull,0x3FDBB37E701BDD9Eull,0x3FDBADBD43D8D6A1ull,0x3FDBA7FBD11B049Eull,0x3FDBA23A17F10F7Full,0x3FDB9C7818699FE4ull,
		0x3FDB96B5D2935F1Eull,0x3FDB90F3467CF731ull,0x3FDB8B30743512D7ull,0x3FDB856D5BCA5D78ull,0x3FDB7FA9FD4B8333ull,0x3FDB79E658C730D7ull,0x3FDB74226E4C13E4ull,0x3FDB6E5E3DE8DA91ull,
		0x3FDB6899C7AC33C1ull,0x3FDB62D50BA4CF0Eull,0x3FDB5D1009E15CC0ull,0x3FDB574AC2708DD3ull,0x3FDB5185356113F4ull,0x3FDB4BBF62C1A17Full,0x3FDB45F94AA0E984ull,0x3FDB4032ED0D9FC3ull,
		0x3FDB3A6C4A1678ADull,0x3FDB34A561CA2963ull,0x3FDB2EDE343767B7ull,0x3FDB2916C16CEA2Bull,0x3FDB234F097967F2ull,0x3FDB1D870C6B98EFull,0x3FDB17BECA5235B5ull,0x3FDB11F6433BF785ull,
		0x3FDB0C2D77379853ull,0x3FDB06646653D2BFull,0x3FDB009B109F621Cull,0x3FDAFAD176290268ull,0x3FDAF50796FF7054ull,0x3FDAEF3D7331693Eull,0x3FDAE9730ACDAB33ull,0x3FDAE3A85DE2F4EFull,
		0x3FDADDDD6C8005DCull,0x3FDAD81236B39E12ull,0x3FDAD246BC8C7E59ull,0x3FDACC7AFE196825ull,0x3FDAC6AEFB691D99ull,0x3FDAC0E2B48A6185ull,0x3FDABB16298BF768ull,0x3FDAB5495A7CA36Eull,
		0x3FDAAF7C476B2A6Eull,0x3FDAA9AEF06651EFull,0x3FDAA3E1557CE025ull,0x3FDA9E1376BD9BEFull,0x3FDA984554374CDAull,0x3FDA9276EDF8BB1Full,0x3FDA8CA84410AFA4ull,0x3FDA86D9568DF3FCull,
		0x3FDA810A257F5263ull,0x3FDA7B3AB0F395C6ull,0x3FDA756AF8F989B8ull,0x3FDA6F9AFD9FFA7Dull,0x3FDA69CABEF5B501ull,0x3FDA63FA3D0986DEull,0x3FDA5E2977EA3E56ull,0x3FDA58586FA6AA5Aull,
		0x3FDA5287244D9A84ull,0x3FDA4CB595EDDF17ull,0x3FDA46E3C4964904ull,0x3FDA4111B055A9E4ull,0x3FDA3B3F593AD3FDull,0x3FDA356CBF549A3Dull,0x3FDA2F99E2B1D03Cull,0x3FDA29C6C3614A3Dull,
		0x3FDA23F36171DD2Dull,0x3FDA1E1FBCF25EA2ull,0x3FDA184BD5F1A4DBull,0x3FDA1277AC7E86C2ull,0x3FDA0CA340A7DBE8ull,0x3FDA06CE927C7C89ull,0x3FDA00F9A20B4188ull,0x3FD9FB246F630473ull,
		0x3FD9F54EFA929F7Full,0x3FD9EF7943A8ED8Aull,0x3FD9E9A34AB4CA1Aull,0x3FD9E3CD0FC5115Eull,0x3FD9DDF692E8A02Cull,0x3FD9D81FD42E5402ull,0x3FD9D248D3A50B06ull,0x3FD9CC71915BA406ull,
		0x3FD9C69A0D60FE77ull,0x3FD9C0C247C3FA75ull,0x3FD9BAEA409378C3ull,0x3FD9B511F7DE5ACCull,0x3FD9AF396DB382A1ull,0x3FD9A960A221D2FAull,0x3FD9A38795382F35ull,0x3FD99DAE47057B57ull,
		0x3FD997D4B7989C0Bull,0x3FD991FAE70076A3ull,0x3FD98C20D54BF114ull,0x3FD986468289F1FEull,0x3FD9806BEEC960A0ull,0x3FD97A911A1924E5ull,0x3FD974B604882759ull,0x3FD96EDAAE25512Eull,
		0x3FD968FF16FF8C3Dull,0x3FD963233F25C302ull,0x3FD95D4726A6E09Eull,0x3FD9576ACD91D0D6ull,0x3FD9518E33F58017ull,0x3FD94BB159E0DB6Dull,0x3FD945D43F62D08Dull,0x3FD93FF6E48A4DCCull,
		0x3FD93A1949664225ull,0x3FD9343B6E059D38ull,0x3FD92E5D52774F45ull,0x3FD9287EF6CA4933ull,0x3FD922A05B0D7C8Aull,0x3FD91CC17F4FDB76ull,0x3FD916E263A058C5ull,0x3FD91103080DE7EAull,
		0x3FD90B236CA77CF9ull,0x3FD90543917C0CA7ull,0x3FD8FF63769A8C50ull,0x3FD8F9831C11F1EDull,0x3FD8F3A281F1341Dull,0x3FD8EDC1A8474A1Full,0x3FD8E7E08F232BD5ull,0x3FD8E1FF3693D1C0ull,
		0x3FD8DC1D9EA83507ull,0x3FD8D63BC76F4F6Dull,0x3FD8D059B0F81B5Aull,0x3FD8CA775B5193D7ull,0x3FD8C494C68AB48Bull,0x3FD8BEB1F2B279C1ull,0x3FD8B8CEDFD7E062ull,0x3FD8B2EB8E09E5F9ull,
		0x3FD8AD07FD5788B2ull,0x3FD8A7242DCFC757ull,0x3FD8A1401F81A152ull,0x3FD89B5BD27C16B0ull,0x3FD8957746CE281Bull,0x3FD88F927C86D6DCull,0x3FD889AD73B524DDull,0x3FD883C82C6814A7ull,
		0x3FD87DE2A6AEA963ull,0x3FD877FCE297E6D6ull,0x3FD87216E032D166ull,0x3FD86C309F8E6E18ull,0x3FD8664A20B9C28Full,0x3FD8606363C3D50Bull,0x3FD85A7C68BBAC6Cull,0x3FD854952FB05030ull,
		0x3FD84EADB8B0C871ull,0x3FD848C603CC1DE9ull,0x3FD842DE111159EEull,0x3FD83CF5E08F8675ull,0x3FD8370D7255AE0Full,0x3FD83124C672DBEAull,0x3FD82B3BDCF61BD3ull,0x3FD82552B5EE7A31ull,
		0x3FD81F69516B040Aull,0x3FD8197FAF7AC6FFull,0x3FD81395D02CD150ull,0x3FD80DABB39031D5ull,0x3FD807C159B3F806ull,0x3FD801D6C2A733F5ull,0x3FD7FBEBEE78F650ull,0x3FD7F600DD385061ull,
		0x3FD7F0158EF4540Full,0x3FD7EA2A03BC13D8ull,0x3FD7E43E3B9EA2DBull,0x3FD7DE5236AB14CDull,0x3FD7D865F4F07E00ull,0x3FD7D279767DF362ull,0x3FD7CC8CBB628A7Aull,0x3FD7C69FC3AD596Aull,
		0x3FD7C0B28F6D76EDull,0x3FD7BAC51EB1FA5Aull,0x3FD7B4D77189FBA1ull,0x3FD7AEE98804934Dull,0x3FD7A8FB6230DA82ull,0x3FD7A30D001DEAFCull,0x3FD79D1E61DADF13ull,0x3FD7972F8776D1B7ull,
		0x3FD791407100DE70ull,0x3FD78B511E882162ull,0x3FD78561901BB747ull,0x3FD77F71C5CABD73ull,0x3FD77981BFA451D2ull,0x3FD773917DB792E8ull,0x3FD76DA100139FD3ull,0x3FD767B046C79846ull,
		0x3FD761BF51E29C90ull,0x3FD75BCE2173CD93ull,0x3FD755DCB58A4CCCull,0x3FD74FEB0E353C4Full,0x3FD749F92B83BEC7ull,0x3FD744070D84F775ull,0x3FD73E14B4480A32ull,0x3FD738221FDC1B6Full,
		0x3FD7322F50505031ull,0x3FD72C3C45B3CE16ull,0x3FD726490015BB52ull,0x3FD720557F853EADull,0x3FD71A61C4117F88ull,0x3FD7146DCDC9A5D9ull,0x3FD70E799CBCDA2Aull,0x3FD7088530FA459Full,
		0x3FD702908A9111ECull,0x3FD6FC9BA990695Eull,0x3FD6F6A68E0776D7ull,0x3FD6F0B1380565CDull,0x3FD6EABBA799624Aull,0x3FD6E4C5DCD298EFull,0x3FD6DECFD7C036F0ull,0x3FD6D8D998716A17ull,
		0x3FD6D2E31EF560C0ull,0x3FD6CCEC6B5B49DEull,0x3FD6C6F57DB254F4ull,0x3FD6C0FE5609B21Dull,0x3FD6BB06F4709206ull,0x3FD6B50F58F625EEull,0x3FD6AF1783A99FAAull,0x3FD6A91F749A31A1ull,
		0x3FD6A3272BD70ECDull,0x3FD69D2EA96F6ABAull,0x3FD69735ED72798Aull,0x3FD6913CF7EF6FEDull,0x3FD68B43C8F5832Aull,0x3FD6854A6093E918ull,0x3FD67F50BED9D81Full,0x3FD67956E3D6873Bull,
		0x3FD6735CCF992DFBull,0x3FD66D628231047Cull,0x3FD66767FBAD436Full,0x3FD6616D3C1D2417ull,0x3FD65B72438FE046ull,0x3FD655771214B262ull,0x3FD64F7BA7BAD55Full,0x3FD64980049184C3ull,
		0x3FD6438428A7FCA7ull,0x3FD63D88140D79B0ull,0x3FD6378BC6D13917ull,0x3FD6318F410278A3ull,0x3FD62B9282B076ADull,0x3FD625958BEA721Cull,0x3FD61F985CBFAA68ull,0x3FD6199AF53F5F98ull,
		0x3FD6139D5578D244ull,0x3FD60D9F7D7B4390ull,0x3FD607A16D55F532ull,0x3FD601A32518296Eull,0x3FD5FBA4A4D12317ull,0x3FD5F5A5EC90258Eull,0x3FD5EFA6FC6474C4ull,0x3FD5E9A7D45D5538ull,
		0x3FD5E3A8748A0BF5ull,0x3FD5DDA8DCF9DE98ull,0x3FD5D7A90DBC1348ull,0x3FD5D1A906DFF0BCull,0x3FD5CBA8C874BE39ull,0x3FD5C5A85289C390ull,0x3FD5BFA7A52E4920ull,0x3FD5B9A6C07197D5ull,
		0x3FD5B3A5A462F928ull,0x3FD5ADA45111B720ull,0x3FD5A7A2C68D1C4Full,0x3FD5A1A104E473D4ull,0x3FD59B9F0C27095Cull,0x3FD5959CDC64291Dull,0x3FD58F9A75AB1FDDull,0x3FD58997D80B3AEBull,
		0x3FD583950393C822ull,0x3FD57D91F85415ECull,0x3FD5778EB65B7339ull,0x3FD5718B3DB92F89ull,0x3FD56B878E7C9AE6ull,0x3FD56583A8B505E3ull,0x3FD55F7F8C71C1A0ull,0x3FD5597B39C21FC7ull,
		0x3FD55376B0B5728Eull,0x3FD54D71F15B0CB2ull,0x3FD5476CFBC2417Eull,0x3FD54167CFFA64C5ull,0x3FD53B626E12CAE5ull,0x3FD5355CD61AC8C5ull,0x3FD52F570821B3D6ull,0x3FD529510436E212ull,
		0x3FD5234ACA69A9FEull,0x3FD51D445AC962A6ull,0x3FD5173DB56563A1ull,0x3FD51136DA4D050Eull,0x3FD50B2FC98F9F94ull,0x3FD50528833C8C64ull,0x3FD4FF2107632537ull,0x3FD4F9195612C44Dull,
		0x3FD4F3116F5AC471ull,0x3FD4ED09534A80F4ull,0x3FD4E70101F155AEull,0x3FD4E0F87B5E9F00ull,0x3FD4DAEFBFA1B9D3ull,0x3FD4D4E6CECA0396ull,0x3FD4CEDDA8E6DA41ull,0x3FD4C8D44E079C51ull,
		0x3FD4C2CABE3BA8CBull,0x3FD4BCC0F9925F3Bull,0x3FD4B6B7001B1FB3ull,0x3FD4B0ACD1E54ACCull,0x3FD4AAA26F0041A5ull,0x3FD4A497D77B65E3ull,0x3FD49E8D0B6619B1ull,0x3FD498820ACFBFC0ull,
		0x3FD49276D5C7BB48ull,0x3FD48C6B6C5D7004ull,0x3FD4865FCEA04236ull,0x3FD48053FC9F96A5ull,0x3FD47A47F66AD29Dull,0x3FD4743BBC115BEEull,0x3FD46E2F4DA298EFull,0x3FD46822AB2DF07Aull,
		0x3FD46215D4C2C9EEull,0x3FD45C08CA708D2Dull,0x3FD455FB8C46A29Full,0x3FD44FEE1A547330ull,0x3FD449E074A9684Eull,0x3FD443D29B54EBECull,0x3FD43DC48E666880ull,0x3FD437B64DED4905ull,
		0x3FD431A7D9F8F8F7ull,0x3FD42B993298E457ull,0x3FD4258A57DC77A7ull,0x3FD41F7B49D31FEDull,0x3FD4196C088C4AB2ull,0x3FD4135C94176601ull,0x3FD40D4CEC83E067ull,0x3FD4073D11E128F3ull,
		0x3FD4012D043EAF37ull,0x3FD3FB1CC3ABE346ull,0x3FD3F50C503835B5ull,0x3FD3EEFBA9F3179Aull,0x3FD3E8EAD0EBFA8Full,0x3FD3E2D9C53250ABull,0x3FD3DCC886D58C89ull,0x3FD3D6B715E52144ull,
		0x3FD3D0A572708279ull,0x3FD3CA939C872444ull,0x3FD3C48194387B41ull,0x3FD3BE6F5993FC90ull,0x3FD3B85CECA91DCDull,0x3FD3B24A4D875515ull,0x3FD3AC377C3E1907ull,0x3FD3A62478DCE0C0ull,
		0x3FD3A011437323DCull,0x3FD399FDDC105A77ull,0x3FD393EA42C3FD2Eull,0x3FD38DD6779D851Aull,0x3FD387C27AAC6BD5ull,0x3FD381AE4C002B78ull,0x3FD37B99EBA83E99ull,0x3FD3758559B4204Dull,
		0x3FD36F7096334C28ull,0x3FD3695BA1353E3Cull,0x3FD363467AC9731Aull,0x3FD35D3122FF67CEull,0x3FD3571B99E699E4ull,0x3FD35105DF8E8765ull,0x3FD34AEFF406AED8ull,0x3FD344D9D75E8F40ull,
		0x3FD33EC389A5A81Eull,0x3FD338AD0AEB7970ull,0x3FD332965B3F83AFull,0x3FD32C7F7AB147D4ull,0x3FD3266869504752ull,0x3FD32051272C0418ull,0x3FD31A39B4540093ull,0x3FD3142210D7BFABull,
		0x3FD30E0A3CC6C4C3ull,0x3FD307F2383093BCull,0x3FD301DA0324B0F0ull,0x3FD2FBC19DB2A137ull,0x3FD2F5A907E9E9E1ull,0x3FD2EF9041DA10BCull,0x3FD2E9774B929C10ull,0x3FD2E35E2523129Full,
		0x3FD2DD44CE9AFBA7ull,0x3FD2D72B4809DEDFull,0x3FD2D111917F4479ull,0x3FD2CAF7AB0AB522ull,0x3FD2C4DD94BBBA00ull,0x3FD2BEC34EA1DCB2ull,0x3FD2B8A8D8CCA752ull,0x3FD2B28E334BA475ull,
		0x3FD2AC735E2E5F25ull,0x3FD2A658598462EAull,0x3FD2A03D255D3BC3ull,0x3FD29A21C1C87626ull,0x3FD294062ED59F06ull,0x3FD28DEA6C9443CAull,0x3FD287CE7B13F256ull,0x3FD281B25A643902ull,
		0x3FD27B960A94A6A2ull,0x3FD275798BB4CA7Full,0x3FD26F5CDDD4345Bull,0x3FD2694001027470ull,0x3FD26322F54F1B70ull,0x3FD25D05BAC9BA83ull,0x3FD256E85181E349ull,0x3FD250CAB98727D8ull,
		0x3FD24AACF2E91ABFull,0x3FD2448EFDB74F02ull,0x3FD23E70DA01581Dull,0x3FD2385287D6CA01ull,0x3FD2323407473915ull,0x3FD22C1558623A39ull,0x3FD225F67B3762C0ull,0x3FD21FD76FD64873ull,
		0x3FD219B8364E8193ull,0x3FD21398CEAFA4D5ull,0x3FD20D7939094963ull,0x3FD20759756B06DCull,0x3FD2013983E47556ull,0x3FD1FB1964852D59ull,0x3FD1F4F9175CC7E5ull,0x3FD1EED89C7ADE6Bull,
		0x3FD1E8B7F3EF0AD4ull,0x3FD1E2971DC8E77Cull,0x3FD1DC761A180F31ull,0x3FD1D654E8EC1D37ull,0x3FD1D0338A54AD47ull,0x3FD1CA11FE615B8Aull,0x3FD1C3F04521C4A1ull,0x3FD1BDCE5EA5859Cull,
		0x3FD1B7AC4AFC3C02ull,0x3FD1B18A0A3585C9ull,0x3FD1AB679C61015Eull,0x3FD1A545018E4D9Full,0x3FD19F2239CD09DBull,0x3FD198FF452CD5D5ull,0x3FD192DC23BD51C3ull,0x3FD18CB8D58E1E4Bull,
		0x3FD186955AAEDC88ull,0x3FD18071B32F2E03ull,0x3FD17A4DDF1EB4B9ull,0x3FD17429DE8D1319ull,0x3FD16E05B189EC01ull,0x3FD167E15824E2C3ull,0x3FD161BCD26D9B1Full,0x3FD15B982073B949ull,
		0x3FD155734246E1E2ull,0x3FD14F4E37F6BA00ull,0x3FD149290192E725ull,0x3FD143039F2B0F46ull,0x3FD13CDE10CED8C8ull,0x3FD136B8568DEA7Eull,0x3FD130927077EBAEull,0x3FD12A6C5E9C840Aull,
		0x3FD12446210B5BB5ull,0x3FD11E1FB7D41B42ull,0x3FD117F923066BB3ull,0x3FD111D262B1F677ull,0x3FD10BAB76E6656Full,0x3FD105845FB362E9ull,0x3FD0FF5D1D2899A1ull,0x3FD0F935AF55B4C1ull,
		0x3FD0F30E164A5FE4ull,0x3FD0ECE652164710ull,0x3FD0E6BE62C916BAull,0x3FD0E09648727BC6ull,0x3FD0DA6E03222383ull,0x3FD0D44592E7BBB0ull,0x3FD0CE1CF7D2F278ull,0x3FD0C7F431F37673ull,
		0x3FD0C1CB4158F6A5ull,0x3FD0BBA226132283ull,0x3FD0B578E031A9E9ull,0x3FD0AF4F6FC43D23ull,0x3FD0A925D4DA8CE8ull,0x3FD0A2FC0F844A5Dull,0x3FD09CD21FD12711ull,0x3FD096A805D0D500ull,
		0x3FD0907DC1930690ull,0x3FD08A5353276E96ull,0x3FD08428BA9DC04Eull,0x3FD07DFDF805AF63ull,0x3FD077D30B6EEFE9ull,0x3FD071A7F4E93660ull,0x3FD06B7CB48437B2ull,0x3FD065514A4FA934ull,
		0x3FD05F25B65B40A5ull,0x3FD058F9F8B6B42Full,0x3FD052CE1171BA66ull,0x3FD04CA2009C0A48ull,0x3FD04675C6455B3Dull,0x3FD04049627D6515ull,0x3FD03A1CD553E00Dull,0x3FD033F01ED884C7ull,
		0x3FD02DC33F1B0C52ull,0x3FD02796362B3024ull,0x3FD021690418AA1Dull,0x3FD01B3BA8F33484ull,0x3FD0150E24CA8A0Bull,0x3FD00EE077AE65CBull,0x3FD008B2A1AE8345ull,0x3FD00284A2DA9E63ull,
		0x3FCFF8ACF684E6EDull,0x3FCFEC5055EB7E72ull,0x3FCFDFF364087D97ull,0x3FCFD39620FB5F6Dull,0x3FCFC7388CE39FD3ull,0x3FCFBADAA7E0BB78ull,0x3FCFAE7C72122FD8ull,0x3FCFA21DEB977B3Dull,
		0x3FCF95BF14901CBEull,0x3FCF895FED1B943Full,0x3FCF7D0075596272ull,0x3FCF70A0AD6908D4ull,0x3FCF6440956A09B0ull,0x3FCF57E02D7BE81Aull,0x3FCF4B7F75BE27F4ull,0x3FCF3F1E6E504DECull,
		0x3FCF32BD1751DF77ull,0x3FCF265B70E262D7ull,0x3FCF19F97B215F1Bull,0x3FCF0D97362E5C16ull,0x3FCF0134A228E26Aull,0x3FCEF4D1BF307B80ull,0x3FCEE86E8D64B189ull,0x3FCEDC0B0CE50F82ull,
		0x3FCECFA73DD1212Cull,0x3FCEC34320487315ull,0x3FCEB6DEB46A928Eull,0x3FCEAA79FA570DB3ull,0x3FCE9E14F22D7366ull,0x3FCE91AF9C0D534Full,0x3FCE8549F8163DDEull,0x3FCE78E40667C448ull,
		0x3FCE6C7DC7217888ull,0x3FCE60173A62ED5Full,0x3FCE53B0604BB654ull,0x3FCE474938FB67B1ull,0x3FCE3AE1C4919687ull,0x3FCE2E7A032DD8A9ull,0x3FCE2211F4EFC4B0ull,0x3FCE15A999F6F1F7ull,
		0x3FCE0940F262F89Eull,0x3FCDFCD7FE537186ull,0x3FCDF06EBDE7F655ull,0x3FCDE40531402173ull,0x3FCDD79B587B8E08ull,0x3FCDCB3133B9D800ull,0x3FCDBEC6C31A9C08ull,0x3FCDB25C06BD778Eull,
		0x3FCDA5F0FEC208C1ull,0x3FCD9985AB47EE90ull,0x3FCD8D1A0C6EC8ABull,0x3FCD80AE22563782ull,0x3FCD7441ED1DDC44ull,0x3FCD67D56CE558DFull,0x3FCD5B68A1CC5001ull,0x3FCD4EFB8BF26516ull,
		0x3FCD428E2B773C48ull,0x3FCD3620807A7A80ull,0x3FCD29B28B1BC565ull,0x3FCD1D444B7AC35Aull,0x3FCD10D5C1B71B7Full,0x3FCD0466EDF075B3ull,0x3FCCF7F7D0467A8Full,0x3FCCEB8868D8D369ull,
		0x3FCCDF18B7C72A53ull,0x3FCCD2A8BD312A1Cull,0x3FCCC63879367E4Aull,0x3FCCB9C7EBF6D323ull,0x3FCCAD571591D5A3ull,0x3FCCA0E5F6273385ull,0x3FCC94748DD69B39ull,0x3FCC8802DCBFBBECull,
		0x3FCC7B90E3024582ull,0x3FCC6F1EA0BDE89Cull,0x3FCC62AC1612568Eull,0x3FCC5639431F4169ull,0x3FCC49C628045BF3ull,0x3FCC3D52C4E159ADull,0x3FCC30DF19D5EECCull,0x3FCC246B2701D03Eull,
		0x3FCC17F6EC84B3A7ull,0x3FCC0B826A7E4F63ull,0x3FCBFF0DA10E5A82ull,0x3FCBF29890548CCBull,0x3FCBE62338709EBBull,0x3FCBD9AD99824982ull,0x3FCBCD37B3A94708ull,0x3FCBC0C1870551E8ull,
		0x3FCBB44B13B62571ull,0x3FCBA7D459DB7DA6ull,0x3FCB9B5D5995173Eull,0x3FCB8EE61302AFA4ull,0x3FCB826E864404F4ull,0x3FCB75F6B378D5FFull,0x3FCB697E9AC0E246ull,0x3FCB5D063C3BE9FFull,
		0x3FCB508D9809AE0Full,0x3FCB4414AE49F00Dull,0x3FCB379B7F1C7243ull,0x3FCB2B220AA0F7AAull,0x3FCB1EA850F743EAull,0x3FCB122E523F1B60ull,0x3FCB05B40E984314ull,0x3FCAF939862280BFull,
		0x3FCAECBEB8FD9ACCull,0x3FCAE043A749584Full,0x3FCAD3C851258111ull,0x3FCAC74CB6B1DD85ull,0x3FCABAD0D80E36CEull,0x3FCAAE54B55A56BBull,0x3FCAA1D84EB607CAull,0x3FCA955BA4411525ull,
		0x3FCA88DEB61B4AA3ull,0x3FCA7C61846474C6ull,0x3FCA6FE40F3C60BFull,0x3FCA636656C2DC68ull,0x3FCA56E85B17B649ull,0x3FCA4A6A1C5ABD91ull,0x3FCA3DEB9AABC21Full,0x3FCA316CD62A9478ull,
		0x3FCA24EDCEF705CEull,0x3FCA186E8530E7FAull,0x3FCA0BEEF8F80D83ull,0x3FC9FF6F2A6C4995ull,0x3FC9F2EF19AD7006ull,0x3FC9E66EC6DB5556ull,0x3FC9D9EE3215CEABull,0x3FC9CD6D5B7CB1D5ull,
		0x3FC9C0EC432FD54Bull,0x3FC9B46AE94F102Bull,0x3FC9A7E94DFA3A39ull,0x3FC99B6771512BE2ull,0x3FC98EE55373BE37ull,0x3FC98262F481CAF1ull,0x3FC975E0549B2C6Dull,0x3FC9695D73DFBDAFull,
		0x3FC95CDA526F5A5Full,0x3FC95056F069DECAull,0x3FC943D34DEF27E1ull,0x3FC9374F6B1F133Bull,0x3FC92ACB48197F10ull,0x3FC91E46E4FE4A3Eull,0x3FC911C241ED5445ull,0x3FC9053D5F067D47ull,
		0x3FC8F8B83C69A60Bull,0x3FC8EC32DA36AFF7ull,0x3FC8DFAD388D7D17ull,0x3FC8D327578DF015ull,0x3FC8C6A13757EC3Dull,0x3FC8BA1AD80B557Eull,0x3FC8AD9439C81065ull,0x3FC8A10D5CAE0220ull,
		0x3FC8948640DD1080ull,0x3FC887FEE67521F1ull,0x3FC87B774D961D81ull,0x3FC86EEF765FEADDull,0x3FC8626760F27250ull,0x3FC855DF0D6D9CC5ull,0x3FC849567BF153C2ull,0x3FC83CCDAC9D816Eull,
		0x3FC830449F92108Dull,0x3FC823BB54EEEC7Dull,0x3FC81731CCD4013Dull,0x3FC80AA807613B65ull,0x3FC7FE1E04B6882Dull,0x3FC7F193C4F3D566ull,0x3FC7E5094839117Cull,0x3FC7D87E8EA62B7Aull,
		0x3FC7CBF3985B1301ull,0x3FC7BF686577B851ull,0x3FC7B2DCF61C0C42ull,0x3FC7A6514A680045ull,0x3FC799C5627B8669ull,0x3FC78D393E769150ull,0x3FC780ACDE79143Bull,0x3FC7742042A30300ull,
		0x3FC767936B14520Full,0x3FC75B0657ECF66Full,0x3FC74E79094CE5C0ull,0x3FC741EB7F541638ull,0x3FC7355DBA227EA6ull,0x3FC728CFB9D8166Eull,0x3FC71C417E94D58Bull,0x3FC70FB30878B48Full,
		0x3FC7032457A3ACA1ull,0x3FC6F6956C35B77Dull,0x3FC6EA06464ECF76ull,0x3FC6DD76E60EEF72ull,0x3FC6D0E74B9612EDull,0x3FC6C457770435F6ull,0x3FC6B7C768795532ull,0x3FC6AB3720156DD6ull,
		0x3FC69EA69DF87DAEull,0x3FC69215E2428318ull,0x3FC68584ED137D03ull,0x3FC678F3BE8B6AF2ull,0x3FC66C6256CA4CF9ull,0x3FC65FD0B5F023BFull,0x3FC6533EDC1CF07Bull,0x3FC646ACC970B4F6ull,
		0x3FC63A1A7E0B738Aull,0x3FC62D87FA0D2F20ull,0x3FC620F53D95EB32ull,0x3FC6146248C5ABCBull,0x3FC607CF1BBC7583ull,0x3FC5FB3BB69A4D83ull,0x3FC5EEA8197F3982ull,0x3FC5E214448B3FC6ull,
		0x3FC5D58037DE6724ull,0x3FC5C8EBF398B6FCull,0x3FC5BC5777DA373Full,0x3FC5AFC2C4C2F06Aull,0x3FC5A32DDA72EB85ull,0x3FC59698B90A3227ull,0x3FC58A0360A8CE74ull,0x3FC57D6DD16ECB19ull,
		0x3FC570D80B7C3350ull,0x3FC564420EF112DFull,0x3FC557ABDBED7618ull,0x3FC54B15729169D4ull,0x3FC53E7ED2FCFB7Aull,0x3FC531E7FD5038F9ull,0x3FC52550F1AB30CBull,0x3FC518B9B02DF1F3ull,
		0x3FC50C2238F88BFDull,0x3FC4FF8A8C2B0EFDull,0x3FC4F2F2A9E58B92ull,0x3FC4E65A924812DFull,0x3FC4D9C24572B693ull,0x3FC4CD29C38588E2ull,0x3FC4C0910CA09C89ull,0x3FC4B3F820E404C9ull,
		0x3FC4A75F006FD56Dull,0x3FC49AC5AB6422C4ull,0x3FC48E2C21E101A4ull,0x3FC4819264068767ull,0x3FC474F871F4C9EEull,0x3FC4685E4BCBDF9Full,0x3FC45BC3F1ABDF63ull,0x3FC44F2963B4E0A9ull,
		0x3FC4428EA206FB64ull,0x3FC435F3ACC24808ull,0x3FC429588406DF90ull,0x3FC41CBD27F4DB78ull,0x3FC4102198AC55BFull,0x3FC40385D64D68E7ull,0x3FC3F6E9E0F82FF4ull,0x3FC3EA4DB8CCC66Aull,
		0x3FC3DDB15DEB4851ull,0x3FC3D114D073D230ull,0x3FC3C47810868111ull,0x3FC3B7DB1E43727Dull,0x3FC3AB3DF9CAC47Dull,0x3FC39EA0A33C959Aull,0x3FC392031AB904DEull,0x3FC38565606031D0ull,
		0x3FC378C774523C77ull,0x3FC36C2956AF455Aull,0x3FC35F8B07976D7Bull,0x3FC352EC872AD65Cull,0x3FC3464DD589A1FDull,0x3FC339AEF2D3F2DBull,0x3FC32D0FDF29EBEEull,0x3FC320709AABB0AEull,
		0x3FC313D12579650Cull,0x3FC307317FB32D78ull,0x3FC2FA91A9792EDBull,0x3FC2EDF1A2EB8E9Cull,0x3FC2E1516C2A729Aull,0x3FC2D4B105560133ull,0x3FC2C8106E8E613Aull,0x3FC2BB6FA7F3BA01ull,
		0x3FC2AECEB1A63351ull,0x3FC2A22D8BC5F56Eull,0x3FC2958C36732913ull,0x3FC288EAB1CDF776ull,0x3FC27C48FDF68A45ull,0x3FC26FA71B0D0BA5ull,0x3FC263050931A634ull,0x3FC25662C8848507ull,
		0x3FC249C05925D3ACull,0x3FC23D1DBB35BE24ull,0x3FC2307AEED470EBull,0x3FC223D7F42218F0ull,0x3FC21734CB3EE399ull,0x3FC20A91744AFEC3ull,0x3FC1FDEDEF6698BEull,0x3FC1F14A3CB1E050ull,
		0x3FC1E4A65C4D04B5ull,0x3FC1D8024E58359Aull,0x3FC1CB5E12F3A323ull,0x3FC1BEB9AA3F7DE8ull,0x3FC1B215145BF6F1ull,0x3FC1A57051693FBCull,0x3FC198CB61878A39ull,0x3FC18C2644D708CBull,
		0x3FC17F80FB77EE46ull,0x3FC172DB858A6DEFull,0x3FC16635E32EBB7Full,0x3FC1599014850B1Full,0x3FC14CEA19AD9168ull,0x3FC14043F2C88364ull,0x3FC1339D9FF6168Dull,0x3FC126F7215680CEull,
		0x3FC11A507709F880ull,0x3FC10DA9A130B46Dull,0x3FC101029FEAEBCBull,0x3FC0F45B7358D642ull,0x3FC0E7B41B9AABE5ull,0x3FC0DB0C98D0A538ull,0x3FC0CE64EB1AFB2Aull,0x3FC0C1BD1299E71Aull,
		0x3FC0B5150F6DA2D1ull,0x3FC0A86CE1B66886ull,0x3FC09BC4899472DDull,0x3FC08F1C0727FCE5ull,0x3FC082735A91421Aull,0x3FC075CA83F07E61ull,0x3FC069218365EE0Dull,0x3FC05C785911CDD9ull,
		0x3FC04FCF05145AECull,0x3FC04325878DD2D7ull,0x3FC0367BE09E7394ull,0x3FC029D210667B87ull,0x3FC01D281706297Eull,0x3FC0107DF49DBCADull,0x3FC003D3A94D74B4ull,0x3FBFEE526A6B2332ull,
		0x3FBFD4FD30ECA794ull,0x3FBFBBA7A65FF83Aull,0x3FBFA251CB05979Eull,0x3FBF88FB9F1E0908ull,0x3FBF6FA522E9D08Dull,0x3FBF564E56A9730Eull,0x3FBF3CF73A9D7639ull,0x3FBF239FCF066086ull,
		0x3FBF0A481424B937ull,0x3FBEF0F00A39085Bull,0x3FBED797B183D6C6ull,0x3FBEBE3F0A45AE19ull,0x3FBEA4E614BF18B8ull,0x3FBE8B8CD130A1D4ull,0x3FBE72333FDAD55Full,0x3FBE58D960FE4016ull,
		0x3FBE3F7F34DB6F78ull,0x3FBE2624BBB2F1CAull,0x3FBE0CC9F5C55616ull,0x3FBDF36EE3532C28ull,0x3FBDDA13849D048Full,0x3FBDC0B7D9E3709Eull,0x3FBDA75BE3670267ull,0x3FBD8DFFA1684CBFull,
		0x3FBD74A31427E339ull,0x3FBD5B463BE65A2Bull,0x3FBD41E918E446A6ull,0x3FBD288BAB623E7Cull,0x3FBD0F2DF3A0D83Dull,0x3FBCF5CFF1E0AB35ull,0x3FBCDC71A6624F6Bull,0x3FBCC31311665DA5ull,
		0x3FBCA9B4332D6F61ull,0x3FBC90550BF81EDAull,0x3FBC76F59C070704ull,0x3FBC5D95E39AC38Bull,0x3FBC4435E2F3F0D5ull,0x3FBC2AD59A532BFFull,0x3FBC117509F912DFull,0x3FBBF814322643FFull,
		0x3FBBDEB3131B5EA1ull,0x3FBBC551AD1902BCull,0x3FBBABF0005FD0FBull,0x3FBB928E0D306ABEull,0x3FBB792BD3CB7217ull,0x3FBB5FC9547189CCull,0x3FBB46668F635556ull,0x3FBB2D0384E178DDull,
		0x3FBB13A0352C993Bull,0x3FBAFA3CA0855BFBull,0x3FBAE0D8C72C6757ull,0x3FBAC774A9626237ull,0x3FBAAE104767F434ull,0x3FBA94ABA17DC591ull,0x3FBA7B46B7E47F40ull,0x3FBA61E18ADCCAE0ull,
		0x3FBA487C1AA752BAull,0x3FBA2F166784C1C2ull,0x3FBA15B071B5C39Aull,0x3FB9FC4A397B0489ull,0x3FB9E2E3BF153181ull,0x3FB9C97D02C4F81Eull,0x3FB9B01604CB06A1ull,0x3FB996AEC5680BF5ull,
		0x3FB97D4744DCB7AAull,0x3FB963DF8369B9F5ull,0x3FB94A77814FC3B4ull,0x3FB9310F3ECF8664ull,0x3FB917A6BC29B42Cull,0x3FB8FE3DF99EFFD1ull,0x3FB8E4D4F7701CBFull,0x3FB8CB6BB5DDBF01ull,
		0x3FB8B20235289B45ull,0x3FB89898759166D9ull,0x3FB87F2E7758D7ACull,0x3FB865C43ABFA44Bull,0x3FB84C59C00683E4ull,0x3FB832EF076E2E41ull,0x3FB8198411375BCBull,0x3FB80018DDA2C588ull,
		0x3FB7E6AD6CF12518ull,0x3FB7CD41BF6334BAull,0x3FB7B3D5D539AF46ull,0x3FB79A69AEB5502Dull,0x3FB780FD4C16D37Eull,0x3FB76790AD9EF5DCull,0x3FB74E23D38E7485ull,0x3FB734B6BE260D4Full,
		0x3FB71B496DA67EA7ull,0x3FB701DBE2508790ull,0x3FB6E86E1C64E7A2ull,0x3FB6CF001C245F0Cull,0x3FB6B591E1CFAE90ull,0x3FB69C236DA79784ull,0x3FB682B4BFECDBD3ull,0x3FB66945D8E03DF8ull,
		0x3FB64FD6B8C28103ull,0x3FB636675FD46891ull,0x3FB61CF7CE56B8D5ull,0x3FB60388048A368Dull,0x3FB5EA1802AFA70Aull,0x3FB5D0A7C907D02Bull,0x3FB5B73757D3785Bull,0x3FB59DC6AF536694ull,
		0x3FB58455CFC8625Dull,0x3FB56AE4B97333CAull,0x3FB551736C94A378ull,0x3FB53801E96D7A91ull,0x3FB51E90303E82C8ull,0x3FB5051E4148865Aull,0x3FB4EBAC1CCC500Eull,0x3FB4D239C30AAB32ull,
		0x3FB4B8C73444639Bull,0x3FB49F5470BA45A7ull,0x3FB485E178AD1E39ull,0x3FB46C6E4C5DBAB9ull,0x3FB452FAEC0CE917ull,0x3FB4398757FB77C4ull,0x3FB42013906A35B7ull,0x3FB4069F9599F26Aull,
		0x3FB3ED2B67CB7DD8ull,0x3FB3D3B7073FA87Eull,0x3FB3BA427437435Dull,0x3FB3A0CDAEF31FF3ull,0x3FB38758B7B41040ull,0x3FB36DE38EBAE6C3ull,0x3FB3546E34487679ull,0x3FB33AF8A89D92DEull,
		0x3FB32182EBFB0FE9ull,0x3FB3080CFEA1C211ull,0x3FB2EE96E0D27E46ull,0x3FB2D52092CE19F6ull,0x3FB2BBAA14D56B08ull,0x3FB2A233672947DDull,0x3FB288BC8A0A8751ull,0x3FB26F457DBA00B8ull,
		0x3FB255CE42788BDEull,0x3FB23C56D8870106ull,0x3FB222DF402638EBull,0x3FB2096779970CBDull,0x3FB1EFEF851A5624ull,0x3FB1D67762F0EF39ull,0x3FB1BCFF135BB28Eull,0x3FB1A386969B7B25ull,
		0x3FB18A0DECF12474ull,0x3FB17095169D8A64ull,0x3FB1571C13E1894Full,0x3FB13DA2E4FDFE01ull,0x3FB124298A33C5B6ull,0x3FB10AB003C3BE19ull,0x3FB0F13651EEC545ull,0x3FB0D7BC74F5B9C3ull,
		0x3FB0BE426D197A8Bull,0x3FB0A4C83A9AE701ull,0x3FB08B4DDDBADEF6ull,0x3FB071D356BA42A6ull,0x3FB05858A5D9F2BAull,0x3FB03EDDCB5AD044ull,0x3FB02562C77DBCC2ull,0x3FB00BE79A839A19ull,
		0x3FAFE4D8895A952Eull,0x3FAFB1E18C7761E9ull,0x3FAF7EEA3EDF609Dull,0x3FAF4BF2A1145855ull,0x3FAF18FAB39810E6ull,0x3FAEE60276EC52F2ull,0x3FAEB309EB92E7E3ull,0x3FAE8011120D99EDull,
		0x3FAE4D17EADE3408ull,0x3FAE1A1E768681F6ull,0x3FADE724B588503Aull,0x3FADB42AA8656C1Bull,0x3FAD81304F9FA3A4ull,0x3FAD4E35ABB8C59Dull,0x3FAD1B3ABD32A191ull,0x3FACE83F848F07C6ull,
		0x3FACB544024FC940ull,0x3FAC824836F6B7BFull,0x3FAC4F4C2305A5BCull,0x3FAC1C4FC6FE666Aull,0x3FABE9532362CDB2ull,0x3FABB65638B4B035ull,0x3FAB83590775E348ull,0x3FAB505B90283CF4ull,
		0x3FAB1D5DD34D93F4ull,0x3FAAEA5FD167BFB4ull,0x3FAAB7618AF89851ull,0x3FAA84630081F696ull,0x3FAA51643285B3F9ull,0x3FAA1E652185AA9Full,0x3FA9EB65CE03B557ull,0x3FA9B8663881AF98ull,
		0x3FA9856661817583ull,0x3FA952664984E3DDull,0x3FA91F65F10DD814ull,0x3FA8EC65589E3037ull,0x3FA8B96480B7CAF9ull,0x3FA8866369DC87B0ull,0x3FA85362148E4651ull,0x3FA82060814EE76Full,
		0x3FA7ED5EB0A04C3Dull,0x3FA7BA5CA3045689ull,0x3FA7875A58FCE8BCull,0x3FA75457D30BE5DAull,0x3FA7215511B3317Eull,0x3FA6EE521574AFDCull,0x3FA6BB4EDED245BDull,0x3FA6884B6E4DD87Eull,
		0x3FA65547C4694E11ull,0x3FA62243E1A68CF9ull,0x3FA5EF3FC6877C4Aull,0x3FA5BC3B738E03A8ull,0x3FA58936E93C0B44ull,0x3FA5563228137BDDull,0x3FA5232D30963EBEull,0x3FA4F02803463DBCull,
		0x3FA4BD22A0A56333ull,0x3FA48A1D09359A0Aull,0x3FA457173D78CDADull,0x3FA424113DF0EA0Dull,0x3FA3F10B0B1FDB9Eull,0x3FA3BE04A5878F59ull,0x3FA38AFE0DA9F2B7ull,0x3FA357F74408F3B0ull,
		0x3FA324F0492680BCull,0x3FA2F1E91D8488D1ull,0x3FA2BEE1C1A4FB5Full,0x3FA28BDA3609C853ull,0x3FA258D27B34E012ull,0x3FA225CA91A8337Aull,0x3FA1F2C279E5B3E0ull,0x3FA1BFBA346F530Eull,
		0x3FA18CB1C1C70344ull,0x3FA159A9226EB733ull,0x3FA126A056E861FFull,0x3FA0F3975FB5F73Cull,0x3FA0C08E3D596AEEull,0x3FA08D84F054B186ull,0x3FA05A7B7929BFE1ull,0x3FA02771D85A8B4Bull,
		0x3F9FE8D01CD212E9ull,0x3F9F82BC37AE60F6ull,0x3F9F1CA8024DEDC4ull,0x3F9EB6937DB4A726ull,0x3F9E507EAAE67BB9ull,0x3F9DEA698AE75AE1ull,0x3F9D84541EBB34C7ull,0x3F9D1E3E6765FA56ull,
		0x3F9CB82865EB9D38ull,0x3F9C52121B500FD4ull,0x3F9BEBFB8897454Bull,0x3F9B85E4AEC53176ull,0x3F9B1FCD8EDDC8E3ull,0x3F9AB9B629E500D2ull,0x3F9A539E80DECF33ull,0x3F99ED8694CF2AA4ull,
		0x3F99876E66BA0A6Dull,0x3F992155F7A3667Eull,0x3F98BB3D488F376Dull,0x3F9855245A817672ull,0x3F97EF0B2E7E1D67ull,0x3F9788F1C58926C3ull,0x3F9722D820A68D98ull,0x3F96BCBE40DA4D90ull,
		0x3F9656A4272862EBull,0x3F95F089D494CA7Full,0x3F958A6F4A2381B0ull,0x3F95245488D88671ull,0x3F94BE3991B7D741ull,0x3F94581E65C57328ull,0x3F93F203060559B4ull,0x3F938BE7737B8AF8ull,
		0x3F9325CBAF2C0788ull,0x3F92BFAFBA1AD075ull,0x3F925993954BE74Full,0x3F91F37741C34E1Dull,0x3F918D5AC085075Eull,0x3F91273E12951607ull,0x3F90C12138F77D7Bull,0x3F905B0434B04191ull,
		0x3F8FE9CE0D86CD12ull,0x3F8F1D936069E21Cull,0x3F8E51586411CC65ull,0x3F8D851D1A8696DEull,0x3F8CB8E185D04D38ull,0x3F8BECA5A7F6FBE9ull,0x3F8B20698302B01Cull,0x3F8A542D18FB77B4ull,
		0x3F8987F06BE96143ull,0x3F88BBB37DD47C07ull,0x3F87EF7650C4D7E2ull,0x3F872338E6C28556ull,0x3F8656FB41D59582ull,0x3F858ABD64061A1Aull,0x3F84BE7F4F5C2562ull,0x3F83F24105DFCA2Bull,
		0x3F83260289991BCDull,0x3F8259C3DC902E20ull,0x3F818D8500CD1578ull,0x3F80C145F857E6A2ull,0x3F7FEA0D8A716DB2ull,0x3F7E518ED2EF3792ull,0x3F7CB90FCE395705ull,0x3F7B2090805FF8F4ull,
		0x3F798810ED734B00ull,0x3F77EF9119837B7Aull,0x3F76571108A0B95Bull,0x3F74BE90BEDB3433ull,0x3F73261040431C28ull,0x3F718D8F90E8A1E2ull,0x3F6FEA1D69B7ED0Dull,0x3F6CB91B605A975Eull,
		0x3F6988190DD9A6B3ull,0x3F6657167A557FC5ull,0x3F632613ADEE87F3ull,0x3F5FEA21618A4A58ull,0x3F59881B15F37BB4ull,0x3F532614895971A2ull,0x3F49881B97F9F4D6ull,0x3F39881BB87B935Cull
	};

#endif	/* #ifndef radix4032_avx_negadwt_consts_included */
