/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef XMText_H
#include "XMText.h"
#endif

#ifndef SimpleEditor_H
#include "SimpleEditor.h"
#endif

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Log_H
#include "Log.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif
#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef RequestPanelLine_H
#include "RequestPanelLine.h"
#endif


SimpleEditor::SimpleEditor(const IconClass& name,const string& kind):
	XEditor<UISimpleEditor_c>(name,kind),
	panel_(name, where_)
{
}

SimpleEditor::~SimpleEditor()
{
}



IconObject* SimpleEditor::copy(const string& name)
{
	IconObject* o = IconFactory::create(name, class_);
	panel_.apply();
	o->request(panel_.request());
	return o;
}

void SimpleEditor::apply()
{
	panel_.apply();
	current_->request(panel_.request());
}

void SimpleEditor::reset()
{
	   panel_.reset(current_);
}

void SimpleEditor::close()
{

}

Request SimpleEditor::currentRequest(long custom_expand)
{
	panel_.apply();
	return custom_expand ? panel_.request(custom_expand) : panel_.request();
}

void SimpleEditor::replace(IconObject* o)
{
   	panel_.replace(o);
}

void  SimpleEditor::merge(IconObject* o)
{
	panel_.merge(o);
}


static EditorMaker<SimpleEditor> editorMaker("SimpleEditor");

