/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipScanner;

public class ZipFileSet
extends FileSet {
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    private File srcFile = null;
    private String prefix = "";
    private String fullpath = "";
    private boolean hasDir = false;
    private int fileMode = 33188;
    private int dirMode = 16877;
    private boolean fileModeHasBeenSet = false;
    private boolean dirModeHasBeenSet = false;

    public ZipFileSet() {
    }

    protected ZipFileSet(FileSet fileset) {
        super(fileset);
    }

    protected ZipFileSet(ZipFileSet fileset) {
        super(fileset);
        this.srcFile = fileset.srcFile;
        this.prefix = fileset.prefix;
        this.fullpath = fileset.fullpath;
        this.hasDir = fileset.hasDir;
        this.fileMode = fileset.fileMode;
        this.dirMode = fileset.dirMode;
        this.fileModeHasBeenSet = fileset.fileModeHasBeenSet;
        this.dirModeHasBeenSet = fileset.dirModeHasBeenSet;
    }

    public void setDir(File dir) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.srcFile != null) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        super.setDir(dir);
        this.hasDir = true;
    }

    public void setSrc(File srcFile) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.hasDir) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        this.srcFile = srcFile;
    }

    public File getSrc(Project p) {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(p)).getSrc(p);
        }
        return this.srcFile;
    }

    public void setPrefix(String prefix) {
        if (!prefix.equals("") && !this.fullpath.equals("")) {
            throw new BuildException("Cannot set both fullpath and prefix attributes");
        }
        this.prefix = prefix;
    }

    public String getPrefix(Project p) {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(p)).getPrefix(p);
        }
        return this.prefix;
    }

    public void setFullpath(String fullpath) {
        if (!this.prefix.equals("") && !fullpath.equals("")) {
            throw new BuildException("Cannot set both fullpath and prefix attributes");
        }
        this.fullpath = fullpath;
    }

    public String getFullpath(Project p) {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(p)).getFullpath(p);
        }
        return this.fullpath;
    }

    public DirectoryScanner getDirectoryScanner(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getDirectoryScanner(p);
        }
        if (this.srcFile != null) {
            ZipScanner zs = new ZipScanner();
            zs.setSrc(this.srcFile);
            super.setDir(p.getBaseDir());
            this.setupDirectoryScanner(zs, p);
            zs.init();
            return zs;
        }
        return super.getDirectoryScanner(p);
    }

    public void setFileMode(String octalString) {
        this.fileModeHasBeenSet = true;
        this.fileMode = 0x8000 | Integer.parseInt(octalString, 8);
    }

    public int getFileMode(Project p) {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(p)).getFileMode(p);
        }
        return this.fileMode;
    }

    public boolean hasFileModeBeenSet() {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(this.getProject())).hasFileModeBeenSet();
        }
        return this.fileModeHasBeenSet;
    }

    public void setDirMode(String octalString) {
        this.dirModeHasBeenSet = true;
        this.dirMode = 0x4000 | Integer.parseInt(octalString, 8);
    }

    public int getDirMode(Project p) {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(p)).getDirMode(p);
        }
        return this.dirMode;
    }

    public boolean hasDirModeBeenSet() {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(this.getProject())).hasDirModeBeenSet();
        }
        return this.dirModeHasBeenSet;
    }

    protected AbstractFileSet getRef(Project p) {
        Object o;
        if (!this.isChecked()) {
            Stack<ZipFileSet> stk = new Stack<ZipFileSet>();
            stk.push(this);
            this.dieOnCircularReference(stk, p);
        }
        if ((o = this.getRefid().getReferencedObject(p)) instanceof ZipFileSet) {
            return (AbstractFileSet)o;
        }
        if (o instanceof FileSet) {
            ZipFileSet zfs = new ZipFileSet((FileSet)o);
            zfs.setPrefix(this.prefix);
            zfs.setFullpath(this.fullpath);
            zfs.fileModeHasBeenSet = this.fileModeHasBeenSet;
            zfs.fileMode = this.fileMode;
            zfs.dirModeHasBeenSet = this.dirModeHasBeenSet;
            zfs.dirMode = this.dirMode;
            return zfs;
        }
        String msg = this.getRefid().getRefId() + " doesn't denote a zipfileset or a fileset";
        throw new BuildException(msg);
    }

    public Object clone() {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(this.getProject())).clone();
        }
        return super.clone();
    }
}

