
#include "amisc.h"
#include "parseopt.h"
#include "vec.h"

#include "dnsimpl.h"

struct rcparser : public parseargs {
  explicit rcparser (str file) : parseargs (file) {}
  void error (str) {}
};

str
satostr (const sockaddr_storage *ss)
{
  char host[NI_MAXHOST];
  char port[NI_MAXSERV];
  if (getnameinfo (reinterpret_cast<const sockaddr *> (ss),
		   sizeof (*ss), host, sizeof (host), port, sizeof (port),
		   NI_NUMERICHOST|NI_NUMERICSERV))
    return NULL;
  str res = strbuf ("[%s]:%s", host, port);
  return res;
}

bool
strtosa (sockaddr_storage *ss, socklen_t *lenp, const char *p)
{
  static addrinfo hints;
  if (!hints.ai_flags)
    hints.ai_flags = AI_NUMERICHOST|AI_NUMERICSERV;

  str addr;
  const char *port;
  if (*p == '[') {
    const char *e = strchr (++p, ']');
    if (!e)
      return false;
    addr.setbuf (p, e - p);
    port = *e == ':' ? e + 1 : "53";
  }
  else {
    addr = p;
    port = "53";
  }

  struct addrinfo *ai;
  if (getaddrinfo (addr, port, &hints, &ai))
    return false;
  if (lenp)
    *lenp = ai->ai_addrlen;
  memcpy (ss, ai->ai_addr, ai->ai_addrlen);
  freeaddrinfo (ai);
  return true;
}

void
show_resolv_conf (const parsed_resolv_conf &rc)
{
  strbuf sb ("parsed resolv.conf:\n  search");
  for (const str *p = rc.searchlist.base(), *e = rc.searchlist.lim();
       p < e; ++p)
    sb << " " << *p;
  sb << "\n";
  for (const sockaddr_storage *p = rc.resolvers.base(),
	 *e = rc.resolvers.lim(); p < e; ++p) {
    sb << "  nameserver " << satostr (p) << "\n";
  }
  warn << sb;
}

void
parse_resolv_conf (parsed_resolv_conf *out, const str &path, bool v4only)
{
  rcparser pa (path);
  union {
    sockaddr_storage ss;
    sockaddr_in sin;
  };

  out->resolvers.clear ();
  out->resolvers_sa_len.clear ();
  out->searchlist.clear ();
  vec<str> av;
  while (pa.getline (&av)) {
    socklen_t len;
    if (av[0] == "nameserver" && av.size() >= 2 && strtosa (&ss, &len, av[1])
	&& (ss.ss_family == AF_INET || !v4only)) {
      if (ss.ss_family == AF_INET && sin.sin_addr.s_addr == INADDR_ANY)
	sin.sin_addr.s_addr = INADDR_LOOPBACK;
      out->resolvers.push_back (ss);
      out->resolvers_sa_len.push_back (len);
    }
    else if (av[0] == "domain" || av[0] == "search")
      for (str *p = av.base() + 1, *e = av.lim(); p < e; p++)
	out->searchlist.push_back (*p);
  }

  if (out->resolvers.empty()) {
    bzero (&ss, sizeof (ss));
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = INADDR_LOOPBACK;
    sin.sin_port = htons (53);
    out->resolvers.push_back (ss);
  }
}
